/////////////////////////////////////////////////////////////////////////////////////////
//
// SPI interface
//
// --------------------------------------------------------------------------------------
//
// Filename:      spi.h
// Version:       1.0
// Date:          15/10/2011
// Author:        Joel Guittet - http://myfreescalewebpage.free.fr
//
/////////////////////////////////////////////////////////////////////////////////////////
//
// Revisions
//
// Version	| Author		| Description
// --------------------------------------------------------------------------------------
//			|				| 
//
/////////////////////////////////////////////////////////////////////////////////////////


#ifndef SPI_H_
#define SPI_H_


//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------

#include <avr/io.h>
#include <stdint.h>
#include <util/delay.h>


//---------------------------------------------------------------------------------------
// SPI peripheral definitions
// It is possible to modify the following definitions to use another SPI peripheral
//---------------------------------------------------------------------------------------


 #define SPI_CTRL_REGISTER	SPCR
 #define SPI_STATUS_REGISTER	SPSR
 #define SPI_DATA_REGISTER	SPDR
 #define SPI_STATUS_IF_BIT	SPIF

 #define SPI_WRITE(a)	 	{ SPDR=(a); }
 #define SPI_WAIT() 		{ while ( !(SPSR & (1<<SPIF))) {;} }
	 
 #define DUMMY_WRITE		(uint8_t)(0xFF)
  
  #define PORT_MMC_CS	PORTG
  #define PIN_MMC_CS	PG5
  #define DDR_MMC_CS	DDRG
  #define DD_MMC_CS		DDG5
  
  #define PORT_W51_CS	PORTB
  #define PIN_W51_CS	PB4
  #define DDR_W51_CS	DDRB
  #define DD_W51_CS		DDB4
  
  #define PORT_HW_CS	PORTB
  #define PIN_HW_CS		PB0
  #define DDR_HW_CS		DDRB
  #define DD_HW_CS		DDB0
  
  #define DDR_SPI		DDRB
  #define DD_MOSI		DDB2
  #define DD_MISO		DDB3
  #define DD_SCK		DDB1
  
  /*
  #define HW_CS_BIT		0			//Pin number for Hardware_CS
  #define HW_CS_PORT 	PORTB
  #define HW_CS_DDR 	DDRB
    
  #define MMC_CS_BIT		5		//Pin number for MMC_CS
  #define MMC_CS_PORT 	PORTG   //Port where MMC_CS is located
  #define MMC_CS_DDR 	DDRG    //Port direction register where MMC_CS is located
 
  #define MMC_SCK_BIT	7
  #define MMC_SCK_PORT   PORTB
  #define MMC_SCK_DDR    DDRB

  #define MMC_MISO_BIT	6
  #define MMC_MISO_PORT  PORTB
  #define MMC_MISO_DDR   DDRB

  #define MMC_MOSI_BIT	5
  #define MMC_MOSI_PORT  PORTB
  #define MMC_MOSI_DDR   DDRB
  
  #define W51_CS_BIT		4		//Pin number for Ethernet
  #define W51_CS_PORT 	PORTB   //Port where Ethernet is located
  #define W51_CS_DDR 	DDRB    //Port direction register where Ethernet is located
  */


//---------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------

void SPI_Init_LowRate(void);
void SPI_Init_HighRate(void);
uint8_t SPI_Write(uint8_t u8Byte);
uint8_t SPI_Read(void);
uint8_t SPI_WriteAndRead(uint8_t u8Byte);
void SPI_SelectW5100Device(void);
void SPI_UnselectW5100Device(void);
void SPI_SelectSDCard(void);
void SPI_UnselectSDCard(void);
uint8_t SPI_IsSDCardPresent(void);
uint8_t SPI_IsSDCardWriteProtected(void);


#endif
