/*************************************************************************
Title:     UART addon-library 
Author:    Martin Thomas <eversmith@heizung-thomas.de>   
           http://www.siwawi.arubi.uni-kl.de/avr_projects
Software:  AVR-GCC 3.3/3.4, Peter Fleury's UART-Library

DESCRIPTION:
    
USAGE:
    Refere to the header file uart_addon.h for a description of the routines. 

*************************************************************************/

#include <stdlib.h>

#include <avr/io.h>
#include "USART.h"
#include "uart_addon.h"




/*************************************************************************
Function: uart_puthex_nibble()
Purpose:  transmit lower nibble as ASCII-hex to UART
Input:    byte value
Returns:  none
**************************************************************************/
void uart_puthex_nibble(const unsigned char b)
{
	unsigned char  c = b & 0x0f;
	if ( c > 9 ) { 
		c += 'A'-10; 
	}
	else {
		c += '0';
	}
	USARTPutChar(c, c);
} /* uart_puthex_nibble */

/*************************************************************************
Function: uart_puthex_byte()
Purpose:  transmit upper and lower nibble as ASCII-hex to UART
Input:    byte value
Returns:  none
**************************************************************************/
void uart_puthex_byte( const unsigned char  b )
{
	uart_puthex_nibble( b >> 4 );
	uart_puthex_nibble( b );
} /* uart_puthex_byte */

