#ifndef UART_ADDON_H
#define UART_ADDON_H
/************************************************************************
Title:     UART addon-library 
Author:    Martin Thomas <eversmith@heizung-thomas.de>   
           http://www.siwawi.arubi.uni-kl.de/avr_projects
Software:  AVR-GCC 3.3/3.4, Peter Fleury's UART-Library
************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/** 
 *  @defgroup UART library-addon
 *  @code #include <uart_addon.h> @endcode
 * 
 *  @brief Additional functions for send numbers as decimal and hex to UART
 *
 *  @note needs Peter Fleury's UART-Library http://jump.to/fleury
 *  @author  Martin Thomas eversmith@heizung-thomas.de   
 */
 
/*@{*/


extern void uart_puthex_nibble( const unsigned char b );

/**
 * @brief    Put byte as hex to ringbuffer for transmit via UART.
 *
 * The upper and lower nibble of the parameter are convertet to 
 * correspondig hex-chars and put in a circular buffer and one 
 * character at a time is transmitted to the UART using interrupts.
 *
 * @param    value to transfer
 * @return   none
 * @see      uart_puthex_nibble
 */
extern void uart_puthex_byte( const unsigned char b );



#ifdef __cplusplus
}
#endif


#endif /* UART_ADDON_H */

