/* ATB_Prg_Graphik_2.c Created: 06.04.2015 14:37:28 Author: AS */ 

#define F_CPU 16000000UL
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>

#include "ks0108.h"
#include "arial_bold_14.h"
#include "corsiva_12.h"
#include "arial8.h"
#include "small_font.h"

#include "addidas_logo.h"
#include "argentina_logo.h"
#include "sailor_man.h"
#include "nike.h"

void LoadBitmap(unsigned char *bitmap, uint8_t size_x, uint8_t size_y)
  {
	uint16_t i, j,by;
	for(i=0; i<size_x; i+=8)
	for(j=0; j<size_y; j++)
	  {
		by=pgm_read_byte(bitmap++);
		ks0108GotoXY(j, i);
		ks0108WriteData(by);
	  }
  }

int main(void) 
  {
	  
	DDRD=0b00001000;							// Angabe Pin am AT1284p
	//PORTD &=~(1<<PD3);						// LED aus
	PORTD |=(1<<PD3);							// LED Licht an
	ks0108Init(0);								// Initialize GLCD
	_delay_ms(5);								// Pause
	// Ausgabe Rand
	ks0108DrawRoundRect(1, 2, 125, 61, 8, BLACK);
	//Ausgabe Linie
	ks0108DrawLine(110, 32, 67, 60, BLACK);
	//Ausgabe Viereck leer
	ks0108DrawRect(12, 37, 10, 20, BLACK);
	//Ausgabe Viereck gefllt
	ks0108FillRect(40, 50, 10, 10, BLACK);
	// Ausgabe Kreis
	ks0108Circle(110, 50, 10, BLACK);
	// Auswahl Schrift
	ks0108SelectFont(Arial_Bold_14, ks0108ReadFontData, BLACK);
	ks0108GotoXY(14,5);							// Angabe Position
	// Ausgabe Text
	ks0108Puts_P(PSTR("Display - Modul\nmit dem KS0108"));
	_delay_ms(1000);							// Pause
	ks0108SelectFont(small_font, ks0108ReadFontData, BLACK);
	ks0108GotoXY(35,35);						//Angabe Position
	ks0108Puts_P(PSTR("Bilder"));				// Ausgabe Text
	_delay_ms(5000);							// Pause
	ks0108ClearScreen();						// Display lschen
	_delay_ms(1000);							// Pause  
	// Bild addidas
	LoadBitmap(addidas_logo, 64, 128);
	_delay_ms(5000);
	// Bild argentina
	LoadBitmap(argentina_logo, 64, 128);
	_delay_ms(5000);
	// Bild nike
	LoadBitmap(nike, 64, 128);
	_delay_ms(5000);
	// Bild Sailor		
	LoadBitmap(sailor_man, 64, 128);
	_delay_ms(5000);

	while(1);
}