/* ATB_Prg_Graphik_3.c Created: 11.04.2015 20:48:14 Author: AS */ 

#define F_CPU 16000000UL
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <util/delay.h>

#include "ks0108.h"
#include "arial_bold_14.h"
#include "corsiva_12.h"
#include "arial8.h"
#include "small_font.h"

#include "horse001.h"
#include "horse002.h"
#include "horse003.h"
#include "horse004.h"
#include "horse005.h"
#include "horse006.h"
#include "horse007.h"
#include "horse008.h"
#include "horse009.h"
#include "horse010.h"
#include "horse011.h"
#include "horse012.h"

void LoadBitmap(unsigned char *bitmap, uint8_t size_x, uint8_t size_y)
  {
	uint16_t i, j,by;
	for(i=0; i<size_x; i+=8)
	for(j=0; j<size_y; j++)
	{
		by=pgm_read_byte(bitmap++);
		ks0108GotoXY(j, i);
		ks0108WriteData(by);
	}
  }

int main(void)
  {
	DDRD=0b00001000;							// Angabe Pin am AT1284p
	//PORTD &=~(1<<PD3);						// LED aus
	PORTD |=(1<<PD3);							// LED Licht an
	ks0108Init(0);								// Initialize GLCD
	_delay_ms(5);								// Pause
	// Ausgabe Rand
	ks0108DrawRoundRect(1, 2, 125, 61, 8, BLACK);
	//Ausgabe Linie
	ks0108DrawLine(110, 32, 67, 60, BLACK);
	//Ausgabe Viereck leer
	ks0108DrawRect(12, 37, 10, 20, BLACK);
	//Ausgabe Viereck gefllt
	ks0108FillRect(40, 50, 10, 10, BLACK);
	// Ausgabe Kreis
	ks0108Circle(110, 50, 10, BLACK);
	// Auswahl Schrift
	ks0108SelectFont(Arial_Bold_14, ks0108ReadFontData, BLACK);
	ks0108GotoXY(14,5);							// Angabe Position
	// Ausgabe Text
	ks0108Puts_P(PSTR("Display - Modul\nmit dem KS0108"));
	_delay_ms(3000);							// Pause
	ks0108SelectFont(small_font, ks0108ReadFontData, BLACK);
	ks0108GotoXY(35,35);						//Angabe Position
	ks0108Puts_P(PSTR("Bilder 2"));				// Ausgabe Text
	_delay_ms(3000);							// Pause
	ks0108ClearScreen();						// Display lschen	
	LoadBitmap(horse001, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse002, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse003, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse004, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse005, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse006, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse007, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse008, 64, 128);
	_delay_ms(500);	
	LoadBitmap(horse009, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse010, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse011, 64, 128);
	_delay_ms(500);
	LoadBitmap(horse012, 64, 128);
	_delay_ms(500);		
	while(1);
  }