/*****************************************************************************
Description:    	HID Demo of the STM32F105/F107 USB Library.

Notes:				The Main Loop waits for 8 Bytes from Host and
					sends them back again.

					HID Device Setup:
					VID		 					= 0xFFFF
					PID		 					= 0xFFFF
					Transfer Size (IN and OUT)	= 8
					Report ID (IN and OUT)		= 0
					Transfer Interval 			= 25ms

Known Problems: 	none

File:				main.c
Version/Date:		1.00 / 19.03.2015
******************************************************************************/
#include "usb.h"

int main(void)
{
	SystemInit();
	USB_Init();

    while(1)
    {
    	//VBUS detected?
    	if (USB_IsConnected())
		{
			USB_ProcessIO();
    	}

    	//Enumeration done?
		if(USB_IsConfigured())
    	{
			//Transfer Size is always 8 Bytes.
			uint8_t Data[8];

			if (USB_Read(Data))
			{
				uint8_t i;
				for (i = 0; i < 8; i++) Data[i]++;

				USB_Write(Data);
			}
    	}
    }
}
