/*****************************************************************************
Description:    	Part of the USB Library for STM32F105/F107.

Notes:				This File defines the Function Interface.

Known Problems: 	-

File:				usb.h
Version/Date:		1.00 / 17.04.2015
******************************************************************************/
#ifndef __USB_H__
	#define __USB_H__

#include "stm32f10x.h"

/*****************************************************************************
Function:		USB_Init(void)

Purpose:		Configures the STM32F10x device for handling USB device transfer.

Parameters:		None
******************************************************************************/
void USB_Init(void);


/*****************************************************************************
Function:		USB_IsConnected(void);

Purpose:		Returns 1, if the Device is connected to USB.

Parameters:		None
******************************************************************************/
uint8_t USB_IsConnected(void);


/*****************************************************************************
Function:		USB_IsConfigured(void);

Purpose:		Returns 1, if the Device is ready to transfer Data.

Parameters:		None
******************************************************************************/
uint8_t USB_IsConfigured(void);


/*****************************************************************************
Function:		USB_ProcessIO(void)

Purpose:		Handles all USB specific Tasks.

Parameters:		None
******************************************************************************/
void USB_ProcessIO(void);


/*****************************************************************************
Function:		USB_Read(uint8_t *buffer)

Purpose:		Read Data from Host.

Parameters:		buffer - Transfer Buffer
******************************************************************************/
uint8_t USB_Read(uint8_t *buffer);


/*****************************************************************************
Function:		USB_Write(uint8_t *buffer)

Purpose:		Write Data to Host.

Parameters:		buffer - Transfer Buffer
******************************************************************************/
uint8_t USB_Write(uint8_t *buffer);


#endif // __USB_H__
