{   obcc, a small oberoncompiler for the C16x-family
      based on Oberon-0 by N. Wirth

    Copyright Guido B. (user "guido-b" at http://www.mikrocontroller.net)

    obcg.pas, the generator, is part of obcc.
    
    obcc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    obcc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with obcc.  If not, see <http://www.gnu.org/licenses/>.                }


unit obcg; { Der Codegenerator }

interface
uses obcd, obcs; { Deklarationen und Scanner einbinden }

VAR boolType, intType, wordtype, stringType, ptrType: g_Type;
    
    
    //relx, cno: INTEGER;
    //entry, fixlist: LONGINT;
    //regs: SET; (* used registers *)
    //code: ARRAY [1..maxCode] OF LONGINT;
    //rel: ARRAY [1..maxRel] OF INTEGER;
    //comname: ARRAY [1..NofCom] OF Ident;  (*commands*)
    //comadr: ARRAY [1..NofCom] OF LONGINT;
    //mnemo: ARRAY [1..54,1..5] OF CHAR;  (*for decoder*)

PROCEDURE RetReg(VAR x: g_Item);
PROCEDURE load(VAR x: g_Item);
PROCEDURE IncLevel(n: INTEGER);
PROCEDURE CopyAddr(x: g_Item; VAR y: g_Item);
PROCEDURE CopyVal(x: g_Item; VAR y: g_Item);
PROCEDURE SwapBytes(VAR x: g_item);
PROCEDURE DoPeek(VAR adr: g_item; page, ziel: g_Item; bytewise: Boolean);
PROCEDURE DoPoke(VAR adr, seite, wert: g_item; bytewise: Boolean);
PROCEDURE DoNew(x: g_item; len:Integer);
PROCEDURE CheckIN(VAR x: g_item; y: LongInt);
PROCEDURE SetIEN(on: Boolean);
PROCEDURE Set_Breakpoint;
PROCEDURE DoFunction(VAR x: g_item; fnr: Integer); 
PROCEDURE DoArith(f: Integer; x, y: g_item);
PROCEDURE MakeConstItem(VAR x: g_Item; typ: g_Type; val: LONGINT);
PROCEDURE MakeStringItem(VAR x: g_Item; typ: g_Type; s: String);
PROCEDURE MakeItem(VAR x: g_Item; y: g_Object);
PROCEDURE LoadRel(x: g_Item);
PROCEDURE SelStruct(VAR x: g_Item);
PROCEDURE PtrField(VAR x: g_Item; y: g_Object; procpar: Boolean);   (* x := x.y *)
PROCEDURE Field(VAR x: g_Item; y: g_Object);   (* x := x.y *)
PROCEDURE Index(VAR x, y: g_Item);   (* x := x[y] *)
PROCEDURE TabIndex(Var x: g_item; y: g_Item); { dito fuer Tables }
PROCEDURE Op1(op: INTEGER; VAR x: g_Item);   (* x := op x *)
PROCEDURE Op2(op: INTEGER; VAR x, y: g_Item);   (* x := x op y *)
PROCEDURE TestTrue(VAR x:g_Item);
PROCEDURE Relation(op: INTEGER; VAR x, y: g_Item);   (* x := x ? y *)
PROCEDURE Store(VAR x, y: g_Item); (* x := y *)
PROCEDURE StoreLv(VAR x: g_Item); {write back controllvariable after FOR}
PROCEDURE g_Parameter(VAR x: g_Item; ftyp: g_Type; class: INTEGER; sc: BOOLEAN);
PROCEDURE CJump(lab: LONGINT; signed: Boolean);
PROCEDURE BJump(lab: LONGINT);
PROCEDURE FJump(lab: LONGINT);
PROCEDURE Call(VAR x: g_Object);
PROCEDURE IOCall(VAR x, y: g_Item);
PROCEDURE OpenWrite;
PROCEDURE PutWrite(x: g_Item; form: Integer);
PROCEDURE CloseWrite(nl: Boolean);
PROCEDURE Return(s: string; int: BOOLEAN);
PROCEDURE Open;
FUNCTION GetLabel:Longint;
PROCEDURE SetLabel(nlabel: Longint; s:string);
PROCEDURE NewLabel(nlabel: Longint; s:string);
PROCEDURE SetProcLabel(s: STRING; int: BOOLEAN);
PROCEDURE g_Inc(VAR x: g_Item);
PROCEDURE DoSpecials(tval: INTEGER);
PROCEDURE g_OpenProc(blksize: INTEGER; small: BOOLEAN);
PROCEDURE CallMain1;
PROCEDURE CallMain2;
PROCEDURE Open_Gen;
PROCEDURE Init_Sproc(vsize:LONGINT);
PROCEDURE WriteVectors;
PROCEDURE End_MOD;
PROCEDURE InclMod(n: Ident);
PROCEDURE LinkCode(pos: Word; isRam: Boolean);

implementation
Uses Sprocs;

	PROCEDURE GetReg(VAR r:integer); 
	BEGIN {r := Nextreg; Nextreg := Nextreg + 1;
	  IF nextreg > maxreg THEN maxreg := nextreg;
	  if Nextreg = Lastreg then Mark('too many registers used!');}
	  r := nextreg;
	  IF oplevel > 1 THEN
	    WHILE ((RegUsed[r] > 0) OR (Regs[r] <> -1)) AND (r <= lastreg) DO
	      r := r + 1;
	  IF r > lastreg THEN r := nextreg;
	  WHILE (r <= lastreg) AND (RegUsed[r] > 0) DO
	    r:= r +1;
	  IF r > lastreg THEN Mark('too many registers used!')
	  ELSE RegUsed[r] := RegUsed[r] + 1;
	END;
	
	PROCEDURE RetReg(VAR x: g_Item);
	BEGIN IF ((x.r <= lastreg) AND (x.r > FSP)) OR (IsInt AND (x.r <= lastreg)) THEN BEGIN
	      {  if x.r = nextreg - 1 then Nextreg := nextreg - 1;}
	        RegUsed[x.r] := RegUsed[x.r] - 1;
	        //If RegUsed[x.r] < 0 Then RegUsed[x.r] := 0;
	        IF x.mode = g_Reg THEN BEGIN
	          x.mode := g_VAR; x.r := g_PC; END
	        ELSE IF x.mode = g_Par THEN BEGIN 
	          IF smallproc THEN
	            x.r := 16 - (x.a DIV 2)
	          ELSE
	            x.r := FSP;
	        END
	      END;
	END;

	PROCEDURE testrange(i:LONGINT);
	BEGIN {IF (i > $FFFF) OR (i < 0) then 
	         Mark('value out of range');}
	END;
	
	PROCEDURE g_Inc(VAR x: g_Item);
	  VAR reg, reg2: INTEGER; r: LONGINT;
	BEGIN
	  IF x.mode = g_Reg THEN BEGIN
	      writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', #1'); 
	      addi($0800 + x.r*16 + 1);
	     IF (Not(smallproc)) AND (NOT(IsInt)) AND (oplevel = 0) THEN 
	      { Spezialbehandlung für arrays ohne Optimierung }
	      If x.lev = 0 Then Begin
		  r := ramstart + x.a - 2; 
		  writeln(Taus, chr(9), 'mov', chr(9), '(', hexword(r), ' + roffs),  R', x.r); 
		  addi($F6F0 + x.r); addv(r Mod $10000); End
	      Else Begin
		writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', x.a, '], R', x.r);
		addi($C400 + x.r*16 + FSP); addv(x.a); End;
	  END
	  ELSE IF (x.mode = g_Var) OR (x.mode = g_Par) THEN BEGIN
	    GetReg(reg); 
	    IF x.lev = 0 THEN BEGIN
	      r := ramstart + x.a - 2; 
	      writeln(Taus,char(9), 'mov', chr(9), 'R', reg, ', #1');
	      addi($E000 + 1*16 + reg);
	      writeln(Taus, chr(9), 'add', chr(9), hexword(r), ', R', reg);
	      addi($04F0 + reg); addv( r Mod $10000); END
	    ELSE IF x.lev = curlev THEN BEGIN
	      IF smallproc THEN Begin { g_Par! }
	        writeln(Taus,char(9), 'mov', chr(9), 'R', reg, ', [R', x.r, ']');
	        addi($A800 + reg*16 + x.r);
	        writeln(Taus,char(9), 'add', chr(9), 'R', reg, ', #1');
	        addi($E000 + 1*16 + reg);
	        writeln(Taus,char(9), 'mov', chr(9), '[R', x.r, '], R', reg);
	        addi($B800 + reg*16 + x.r);
	      END
	      ELSE BEGIN
	        writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
	        addi($D400 + reg*16 + FSP); addv(x.a);
	        IF x.mode = g_Par THEN BEGIN
	          getreg(reg2);
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', R', reg);
	          addi($F000 + reg2*16 + reg);
	          writeln(Taus,char(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
	          addi($A800 + reg*16 + reg);
	        END;
	        writeln(Taus,char(9), 'add', chr(9), 'R', reg, ', #1');
	        addi($E000 + 1*16 + reg);
	        IF x.mode = g_Par THEN BEGIN
	          writeln(Taus,char(9), 'mov', chr(9), '[R', reg2, '], R', reg);
	          addi($B800 + reg*16 + reg2);
	          Regs[reg2] := -1; RegUsed[reg2] := 0;
	        END
	        ELSE Begin
	          writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', x.a, '], R', reg);
	          addi($C400 +reg*16 + FSP); addv(x.a); End;
	      END;
	      RegUsed[reg] := 0;
	      IF x.mode = g_Var THEN Regs[reg] := 65000 * x.lev + x.a;
	    END
	    ELSE Mark('level?');
	  END;
	END; {_g_Inc }
	
	PROCEDURE LoadRel(x: g_Item);
	Begin
	  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
	  addi($A800 + x.r*16 + x.r);
	End;
	
	PROCEDURE load(VAR x: g_Item);
	  VAR r: LONGINT; reg: INTEGER;
	BEGIN (* erstmal x.mode # Reg: *)
	  IF x.mode = g_Const THEN BEGIN
            TestRange(x.a); GetReg(reg);
            writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #', x.a); 
            If x.a < 0 Then Begin
	      addi($E6F0 + reg); addv($FFFF + x.a + 1);
            End
            Else If x.a < 16 Then
	      addi($E000 + x.a*16 + reg)
	    Else Begin
	      addi($E6F0 + reg); addv(x.a);
	    End;
            x.mode := g_Reg; x.r := reg; Regs[reg] := -1; 
          END
          ELSE IF x.mode = g_PAR THEN BEGIN	        
	     IF (smallproc) THEN  BEGIN
	      IF x.r >= lastreg THEN BEGIN
		Getreg(reg);
		writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', x.r, ']'); 
		addi($A800 + reg*16 + x.r);
		x.r := reg; x.mode := g_Reg; { Achtung: ist g_Reg o.k.? Sollte sein!}
		Regs[reg] := (65000 * x.lev) + x.a; END;
	     END
	     ELSE BEGIN 
	        Getreg(reg);
	        writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
	        addi($D400 + reg*16 + FSP); addv(x.a);
	        writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
	        addi($A800 + reg*16 + reg);
	        x.r := reg; Regs[reg] := (65000 * x.lev) + x.a; 
	     END
	  END
	  ELSE IF x.mode <> g_Reg THEN BEGIN
	    x.r := g_PC;
	    IF oplevel > 0 Then
	    { Nicht fuer Level-0-Variablen, sonst gibt es ein Not-Volatile-Problem!.}
	      IF x.lev <> 0 THEN BEGIN
	        reg := nextreg;
	        WHILE (reg <= 15) AND (Regs[reg] <> ((65000 * x.lev) + x.a)) DO 
	          reg := reg + 1;
	        IF (reg < 16) AND (Regs[reg] = ((65000 * x.lev) + x.a)) THEN BEGIN
	          x.r := reg; X.mode := g_Reg; {nextreg := reg + 1;}
	          RegUsed[x.r] := RegUsed[x.r] + 1; END 
	      END;  
	    IF (x.r = g_PC)  THEN BEGIN
	      IF (x.mode = g_Var) OR (x.mode = g_Par) THEN BEGIN
	        IF x.lev = 0 THEN BEGIN
	          r := (ramstart + x.a - 2); 
	          GetReg(reg); 
	          If r = ramstart Then Begin { _FRESULT? }
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', ', hexword(r));
		    addi($F2F0 + reg); addv(r Mod $10000); End
		  Else Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', (', hexword(r), ' + roffs)');
		    addi($F2F0 + reg); Addramlink; addv(r Mod $10000); End;
	          x.r := reg; x.mode := g_Reg; Regs[reg] := (65000 * x.lev) + x.a; 
	        END
	        ELSE IF x.lev = curlev THEN BEGIN
	          IF x.mode = g_Var THEN BEGIN
	            IF NOT smallproc THEN BEGIN
	              Getreg(reg); //r := x.a - 2;
	              writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
	              addi($D400 + reg*16 + FSP); addv(x.a);
	              x.r := reg; x.mode := g_Reg; Regs[reg] := (65000 * x.lev) + x.a;
	            END;
	          END	          
	        END
	        ELSE Mark('level!');
	      END
            END;
          END;
	END {load};	
	
	{ Speziell fuer INC und DEC auf Arrayelemente }
	PROCEDURE CopyAddr(x: g_Item; VAR y: g_Item);
	VAR reg: INTEGER;
	BEGIN Getreg(reg);
	  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r);
	  addi($F000 + reg*16 + x.r);
	  y.r := reg; 
	END {CopyAddr };
	
	{ Speziell fuer PeekW auf Arrayelemente }
	PROCEDURE CopyVAL(x: g_Item; VAR y: g_Item);
	VAR reg: INTEGER;
	BEGIN Getreg(reg);
	  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', x.r, ']');
	  addi($A800 + reg*16 + x.r);
	  y.r := reg; 
	END {CopyAddr };
	
	PROCEDURE SwapBytes(VAR x: g_item);
	BEGIN 
	  IF x.i_type^.form = g_Array THEN BEGIN
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
	    addi($A800 + x.r*16 + x.r);
	    x.a := 0; { Wert in Rx } 
	  END;
	  Writeln(Taus, chr(9), 'rol', chr(9), 'R', x.r, ', #8');
	  addi($1C00 + 8*16 + x.r);
	END {SwapBytes};
	
	PROCEDURE DoPeek(VAR adr: g_item; page, ziel: g_Item; bytewise: Boolean);
	VAR regret: BOOLEAN; reg, treg: Integer; za: Longint;
	BEGIN regret := FALSE;
	  IF page.mode = g_Const THEN Begin
	    Writeln(Taus, chr(9), 'exts', chr(9), '#', page.a, ', #1');
	    addi($D700); addv(page.a); 
	  End
	  ELSE BEGIN
	    IF page.mode <> g_Reg THEN BEGIN
	      regret := TRUE; load(page); END;
	    Writeln(Taus, chr(9), 'exts', chr(9), 'R', page.r, ', #1');
	    addi($DC00 + 0*16 + page.r);
	  END;
	  za := ramstart + ziel.a - 2; { = ramstart! }
	  If Not bytewise then Begin
	    Getreg(reg);
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', adr.r, ']');
	    addi($A800 + reg*16 + adr.r);
	    Writeln(Taus, chr(9), 'mov', chr(9), HexWord(za), ', R', reg);
	    addi($F6F0 + reg); addv(za Mod $10000); 
	    treg := adr.r; adr.r := reg; Retreg(adr); adr.r := treg; End
	  Else Begin
	    If Not regret Then Begin
	      regret := True; GetReg(reg); page.r := reg; End;
	    If page.r > 7 Then mark('got no byteregister!')
	    Else Begin
	      page.r := reg;
	      Writeln(Taus, chr(9), 'movb', chr(9), 'RL', page.r, ', [R', adr.r, ']');
	      addi($A900 + page.r*32 + adr.r);
	      Writeln(Taus, chr(9), 'movbz', chr(9), HexWord(za), ', RL', page.r);
	      addi($C5F0 + page.r*2); addv(za Mod $10000);
	    End;
	  End;
	  adr.mode := g_Reg; retreg(adr);
	  IF regret THEN retreg(page);
	  IF adr.i_type^.form = g_Array then adr.a := 0;
	END { DoPeek };
	
	PROCEDURE DoPoke(VAR adr, seite, wert: g_item; bytewise: Boolean);
	VAR reg, wreg: INTEGER;
	BEGIN 
	  IF adr.mode <> g_Const THEN BEGIN
	    IF adr.mode <> g_Reg then load(adr);
	    IF adr.i_type^.form = g_Array THEN Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', adr.r, ', [R', adr.r, ']');
	      addi($A800 + adr.r*16 + adr.r); End;
	  END;
	  IF wert.mode = g_Const THEN BEGIN
	    GetReg(reg);
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #', wert.a);
	    If wert.a < 16 Then addi($E000 + wert.a*16 + reg)
	    Else Begin
	      addi($E6F0 + reg); addv(wert.a); End;
	    wert.r := reg; 
	  END
	  ELSE BEGIN
	    IF wert.mode <> g_reg THEN load(wert);
	    IF wert.i_type^.form = g_Array THEN Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', wert.r, ', [R', wert.r, ']');
	      addi($A800 + wert.r*16 + wert.r); End;
	  END;
	  If (bytewise) And (wert.r > 7) Then Begin
	    GetReg(wreg);
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', wreg, ', R', wert.r);
	    addi($F000 + wreg*16 + wert.r);
	    wert.r := wreg; End;
	  IF seite.mode = g_Const THEN Begin
	    
	    Writeln(Taus, chr(9), 'exts', chr(9), '#', seite.a, ', #1');
	    addi($D700); addv(seite.a); 
	  
	  End
	  ELSE BEGIN
	    IF seite.mode <> g_Reg THEN BEGIN
	      load(seite);
	      IF seite.i_type^.form = g_Array THEN Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', seite.r, ', [R', seite.r, ']');
		addi($A800 + seite.r*16 + seite.r); End;
	    END;
	   Writeln(Taus, chr(9), 'exts', chr(9), 'R', seite.r, ', #1');
	    addi($DC00 + 0*16 + seite.r);
	  END;
	  IF adr.mode = g_Const THEN BEGIN
	      If not bytewise Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), HexWord(adr.a), ', R', wert.r);
		addi($F6F0 + wert.r); addv(adr.a Mod $10000); End
	      Else 
		If wert.r < 8 Then Begin
		  Writeln(Taus, chr(9), 'movb', chr(9), HexWord(adr.a), ', RL', wert.r);
		  addi($F7F0 + wert.r*2); addv(adr.a Mod $10000); End
		Else Mark('not a byteregister!');
	  END
	  ELSE BEGIN
	      If not bytewise Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', adr.r, '], R', wert.r);
		addi($B800 + wert.r*16 + adr.r); End 
	      Else
		If wert.r < 8 Then Begin
		  Writeln(Taus, chr(9), 'movb', chr(9), '[R', adr.r, '], RL', wert.r);
		  addi($B900 + wert.r*32 + adr.r); End
		Else Mark('not a byteregister!');
	  END;
	  RetReg(wert); 
	  IF seite.mode = g_Reg THEN RetReg(seite);
	  IF adr.mode = g_Reg THEN RetReg(adr);
	END { DoPoke };
	
	PROCEDURE DoNew(x: g_item; len:Integer);
	Var reg, reg2: Integer; a: LongInt;
	Begin GetReg(reg);
	  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', ', HexWord(Heaptop));
	  addi($F2F0 + reg); addv(heaptop Mod $10000);
	  If x.lev = 0 Then Begin
	    a := ramstart + x.a - 2;
	    Writeln(Taus, chr(9), 'mov', chr(9), HexWord(a), ', R', reg);
	    addi($F6F0 + reg); addv(a Mod $10000);
	  End
	  Else If x.lev = curlev Then begin
	    If x.mode = g_par Then
	      If smallproc Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', x.r, '], R', reg);
		addi($B800 + reg*16 + x.r);
	      End
	      Else Begin
		GetReg(reg2);
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', [R', FSP, '+#', x.a, ']');
		addi($D400 + reg2*16 + FSP); addv(x.a);
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', reg2, '], R', reg);
		addi($B800 + reg*16 + reg2);
		x.r := reg2; RetReg(x);
	      End
	    Else
	      If smallproc Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', R', reg);
		addi($F000 + x.r*16 + reg);
	      End
	      Else Begin
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', x.a, '], R', reg);
		addi($C400 + reg*16 + FSP); addv(x.a);
	      End;
	  End
	  Else Mark('level?');
	  Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', len);
	  If len < 16 Then addi($E000 + len*16 +reg)
	  Else Begin
	    addi($E6F0 + reg); addv(len); End;
	  Writeln(Taus, chr(9), 'mov', chr(9), HexWord(Heaptop), ', R', reg);
	  addi($F6F0 + reg); addv(HeapTop Mod $10000);
	  x.r := reg; RetReg(x);
	  { ToDo: Fuer Debuglevel testen, ob der Heap mit dem Frame kollidiert }
	End {DoNew };
	
	PROCEDURE Findlabel(Var p: labp; nr: Longint);
	Begin p := labl;
	  While (p <> Nil) And (p^.nr <> nr) Do
	    p := p^.next;
	End;
	
	PROCEDURE AddLabRef(Var p: labp; nr: Longint);
	Var i: Integer;
	Begin If p = Nil Then Findlabel(p, nr);
	  If p <> Nil Then Begin
	    i := 0;
	    While (p^.refs[i] <> 0) And (i <= maxstringref) Do
	      i := i + 1;
	    If i <= maxstringref Then p^.refs[i] := cap
	    Else Mark('oops: too many refs');
	  End
	  Else Mark('oops: label not found (AddLabRef)');
	End;
	
	FUNCTION GetLabel:Longint;
	Var p: labp; i: Integer;
	BEGIN GetLabel := NextLab;
	  p := labl;
	  While (p <> Nil) And (p^.nr <> Nextlab) Do
	    p := p^.next;
	  If p = Nil Then begin
	    New(p); p^.next := labl; labl := p; End;
	  p^.start := 0; p^.ziel := 0; p^.nr := NextLab;
	  For i := 0 To Maxstringref Do p^.refs[i] := 0;
	  NextLab := NextLab + 1;
	END;

	PROCEDURE SetLabel(nlabel: Longint; s:string); { Nach z.B. jmp ohne Doppelpunkt }
	  VAR i, j: INTEGER;
	BEGIN i := 10000; J := 5;
	  Write(Taus,modname);
	  WHILE (i > 1) AND (nlabel < i) DO BEGIN
	    write(Taus,'0'); j:=j-1; i := i div 10; END;
	  write(Taus, nlabel:j);
	  if s <>'' then writeln(Taus, chr(9), chr(9), chr(9), '; ', s)
	  else writeln(Taus);
	END;
	
	PROCEDURE NewLabel(nlabel: Longint; s:string); { als Sprungziel mit Doppelpunkt }
	  VAR i, j: INTEGER; p: labp;
	BEGIN i := 10000; J := 5;
	  Write(Taus, modname);
	  WHILE (i > 1) AND (nlabel < i) DO BEGIN
	    write(Taus,'0'); j:=j-1; i := i div 10; END;
	  write(Taus, nlabel:j);
	  if s <>'' then writeln(Taus, ':', chr(9), chr(9), chr(9), chr(9), chr(9), '; ', s)
	  else writeln(Taus, ':');
	  Findlabel(p, nlabel);
	  If p <> Nil Then Begin
	    If p^.refs[0] <> 0 Then Begin { gibt es Referebzen? }
	      i := 0;
	      While (p^.refs[i] <> 0) And (i <= maxstringref) Do Begin
		code[p^.refs[i]] := cap Mod 256;
		code[p^.refs[i] + 1] := cap Div 256;
		i := i + 1; End;
	      p^.nr := -1; { abgearbeitet }
	    End
	    Else p^.Ziel := cap; { fuer BackJump }
	  End
	  Else Begin
	    mark('oops: label not found (NewLabel)');
	    //writeln(nlabel, ', ', s); 
	    End;
	END;
	
	PROCEDURE CheckStack;
	Var lab: LongInt; p: Tsfrreg; s: Word;
	Begin
	  { Stack checken, mindestens 44 Bytes müssen für
	    einen Interrupt übrigbleiben (besser 82?) + 2 Bytes Reserve. }
	    lab := GetLabel; p := Fsfr('SP');
	    writeln(Taus, '; CheckStack');
	    IF DPP[3] <> 3 THEN Begin
	      writeln(Taus, chr(9), 'extp', chr(9), '#3, #2');
	      addi($D750); addv(0003);
	    End;
	    writeln(Taus, chr(9), 'mov', chr(9), 'R1, ', HexWord(p.adr));
	    addi($F2F0 + 1); addv(p.adr);
	    writeln(Taus, chr(9), 'mov', chr(9), 'R2, ', HexWord(CPadr));
	    addi($F2F0 + 2); addv(CPadr);
	    writeln(taus, chr(9), 'sub', chr(9), 'R1, R2');
	    addi($2000 + 1*16 + 2);
	    Writeln(Taus, chr(9), 'cmp', chr(9), 'R1, #46');
	    addi($46F0 + 1); addv(46);
	    write(Taus, chr(9), 'jmpr', chr(9), 'UGE, ');
	    setlabel(lab, ''); s:= cap; addi(0);
	    p := Fsfr('TFR');
	    Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.14', chr(9),'; STKOF');
	    addi($EF00 + p.reg);
	    //writeln(Taus, chr(9), 'bset', chr(9), 'STKOF');
	    NewLabel(lab, 'CheckStack'); rfj(s, 9);
	End; {CheckStack}
	
	PROCEDURE SetProcLabel(s: STRING; int: BOOLEAN);
	BEGIN IF NOT int THEN s := modname + s;
	  writeln(Taus, s, ':');
	  IF int THEN BEGIN
	    writeln(Taus, chr(9), 'add', chr(9), HexWord(CPadr), ', #32');
	    addi($0600 + CPreg); addv(32);
	    writeln(Taus, chr(9), 'nop'); addi($CC00);
	    If DebugLevel > 1 Then CheckStack;
	  END;
	END;
	
	PROCEDURE CheckIN(VAR x: g_item; y: LongInt);
	VAR reg, t: INTEGER; lab: LongInt; p: Tsfrreg; s: Word;
	BEGIN
	  IF x.mode = g_const THEN Mark('constant IN?')
	  ELSE BEGIN
	    IF x.mode <> g_Reg THEN load(x);
	    IF x.i_type^.form = g_Array THEN Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
	      addi($A800 + x.r*16 + x.r); End;
	    If DebugLevel > 1 Then BEGIN
	      lab := GetLabel;
	      Writeln(taus, '; Check Value for IN ');
	      Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', #15');
	      addi($46F0 + x.r); addv(15);
	      Write(Taus, chr(9),'jmpr', chr(9), 'ULE, '); SetLabel(lab, '');
	      s := cap; addi(0);
	      p := Fsfr('TFR');
	      Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.14', chr(9),'; STKOF');
	      addi($EF00 + p.reg);
	      NewLabel(lab, 'Check Value'); rfj(s, 15);
	    END;
	    GetReg(reg);
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #1');
	    addi($E000 + 1*16 + reg);
	    Writeln(Taus, chr(9), 'shl', chr(9), 'R', reg, ', R', x.r);
	    addi($4C00 + reg*16 + x.r);
	    Writeln(Taus, chr(9), 'and', chr(9), 'R', reg, ', #', y);
	    addi($66F0 + reg); addv(y Mod $10000);
	    t := x.r; x.r := reg; retreg(x); x.r := t; retreg(x);
	    Lastop := zero_; 
	  END;
	END { CheckIN };	

	PROCEDURE SetIEN(on: Boolean);
	Var p: Tsfrreg;
	BEGIN p := Fsfr('PSW');
	  If on Then Begin
	    Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr),'.11');
	    addi($BF00 + p.reg); End
	  Else Begin
	    Writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.11');
	    addi($BEF0 + p.reg); End;
	END {SetIEN};
	
	PROCEDURE Set_Breakpoint;
	BEGIN If DebugLevel IN [1,3] Then
	  writeln(Taus, chr(9), 'DB', chr(9), '044h, 044h');
	  addi($4444);
	END { Set_Breakpoint };

	PROCEDURE DoFunction(VAR x: g_item; fnr: Integer);
	Var reg: Integer; lab: LongInt;
	Begin GetReg(reg);
	  If x.mode <> g_Reg Then load(x);
	  Case fnr Of
	    15: {Trunc}
	      Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r);
		addi($F000 + reg*16 + x.r); x.r := reg;
		Writeln(Taus, chr(9), 'bclr', chr(9), 'R', reg, '.15');
		addi($FEF0 + reg);
	      End;
	    16: {Abs}
	      Begin lab := GetLabel;
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r);
		addi($F000 + reg*16 + x.r); x.r := reg;
		Write(Taus, chr(9), 'jnb', chr(9), 'R', reg, '.15, '); SetLabel(lab, '');
		addi($9AF0 + reg); addv(2 + $F000);
		Writeln(Taus, chr(9), 'cpl', chr(9), 'R', reg);
		addi($9100 + reg*16);
		Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #1');
		addi($0800 + reg*16 + 1);
		Newlabel(lab, '');
	      End;
	    17: {Odd}
	      Begin lab := GetLabel;
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #0');
		addi($E000 + 0*16 + reg);
		Write(Taus, chr(9), 'jnb', chr(9), 'R', x.r, '.0, '); SetLabel(lab, '');
		addi($9AF0 + x.r); addv(1 + $0000);
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #1');
		addi($E000 + 1*16 + reg);
		Newlabel(lab, ''); x.r := reg;
		lastop := neq_; { falls als Bedingung aufgerufen }
	      End;
	  End;
	End {DoFunction};
	
	PROCEDURE DoArith(f: Integer; x, y: g_item);
	Begin
	  Case f OF
	    28: Begin
	      If (x.mode = g_Reg) And (y.mode = g_Reg) Then Begin
		If x.i_type = IntType Then Begin
		  Writeln(Taus, chr(9), 'ashr', chr(9), 'R', x.r, ', R', y.r);
		  addi($AC00 + x.r*16 + y.r); End
		Else Begin  
		  Writeln(Taus, chr(9), 'shr', chr(9), 'R', x.r, ', R', y.r);
		  addi($6C00 + x.r*16 + y.r); End
	      End
	      Else Mark(' implemented for loc. vars. in *-procs only');
	    End;
	    Else Mark('oops: arith-Function not found');
	  End;
	
	End; { DoArith }
	
	PROCEDURE CheckIndex(max, regind:Integer);
	VAR lab: LongInt; p: Tsfrreg; s: Word;
	Begin { Arryindex checken, auch fuer Tables }
	  p := Fsfr('TFR');
	  lab := GetLabel;
	  writeln(Taus, '; CheckIndex');
	  writeln(taus, chr(9), 'cmp', chr(9), 'R', regind, ', #0');
	  addi($4800 +regind*16 + 0);
	  write(taus, chr(9), 'jmp', chr(9), 'NE, '); setlabel(lab,''); 
	  s := cap; addi(0);
	  Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.2', chr(9),'; ILLOPA');
	  addi($2F00 + p.reg);
	  //writeln(taus, chr(9), 'bset', chr(9), 'ILLOPA');
	  NewLabel(lab, ''); rfj(s, 3);
	  lab := GetLabel;
	  writeln(taus, chr(9), 'cmp', chr(9), 'R', regind, ', #', max);
	  If max < 8 Then addi($4800 + regind*16 + max)
	  Else Begin
	    addi($46F0 + regind); addv(max); End;
	  write(taus, chr(9), 'jmp', chr(9), 'ULE, '); setlabel(lab,'');
	  s := cap; addi(0);
	  Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.2', chr(9),'; ILLOPA');
	  addi($2F00 + p.reg);
	  NewLabel(lab, 'CheckIndex'); rfj(s, 15);
	End; {CheckIndex}
	
	PROCEDURE CheckFlag(bed:String);
	VAR lab: LongInt; p: Tsfrreg; s: Word; bc: Byte;
	Begin lab := GetLabel; p := Fsfr('TFR');
	  If bed = 'NC' Then bc := 9
	  Else If bed = 'NV' Then bc := 5
	  Else Mark('oops: condition not found');
	  writeln(Taus, '; CheckFlag');
	  write(taus, chr(9), 'jmpr', chr(9), bed, ', '); SetLabel(lab, ''); s := cap;
	  Writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.1', chr(9),'; ILLINA');
	  addi($1F00 + p.reg);
	  NewLabel(lab, 'CheckFlag'); rfj(s, bc);
	End; {CheckFlag}

	FUNCTION IsPot(VAR k:Longint; a:LONGINT):BOOLEAN;
	  VAR j: INTEGER;
	BEGIN j := a; k := 0;
	  WHILE NOT ODD(j) DO BEGIN
	    j := j DIV 2; k := k + 1;
	  END;
	  IF j = 1 THEN IsPot := TRUE
	  ELSE IsPot := FALSE;
	END;

	PROCEDURE IncLevel(n: INTEGER);
	  BEGIN curlev := curlev + n;
	  END {IncLevel};

	PROCEDURE MakeConstItem(VAR x: g_Item; typ: g_Type; val: LONGINT);
	  BEGIN x.mode := g_Const; x.i_type := typ; x.a := val;  x.lev := curlev; x.r := g_PC;
	  END {MakeConstItem};
	  
	PROCEDURE MakeStringItem(VAR x: g_Item; typ: g_Type; s: String);
	  VAR nstring: stringp; i: Integer;
	BEGIN x.a := nextstring; nextstring := nextstring + 1;
	  nstring := stringl;
	  While (nstring^.inh <> '') And (nstring^.next <> Nil) Do
	    nstring := nstring^.next;
	  If nstring^.inh <> '' Then Begin
	    NEW(nstring); nstring^.next := stringl; stringl := nstring;
	  End;
	  nstring^.nr := x.a; nstring^.inh := s; nstring^.lev := curlev;
	  For i := 0 To maxstringref Do nstring^.refs[i] := 0;
	  x.mode := g_String; x.i_type := typ; x.lev := curlev;
	END;
	

	PROCEDURE MakeItem(VAR x: g_Item; y: g_Object);
	BEGIN x.mode := y^.class; x.i_type := y^.o_type; x.lev := y^.lev; 
	  x.a := y^.val; x.b := 0;
	  If y^.name = 'NIL' Then Begin x.mode := g_Const; exit; End;  
	  IF y^.lev = 0 THEN BEGIN
	    x.r := g_PC; 
	  END
	  ELSE IF y^.lev = curlev THEN BEGIN
	    IF x.mode = g_Var THEN BEGIN
	      IF smallproc THEN BEGIN
	        x.mode := g_Reg; x.r := (16 - x.a DIV 2); END
	      ELSE BEGIN
	        x.r := FSP; x.a := x.a - 2; END;
	    END
	    ELSE IF x.mode = g_Par THEN BEGIN
	      IF smallproc THEN 
	        x.r := 16 - (x.a DIV 2)
	      ELSE BEGIN
	        x.r := FSP; x.a := x.a - 2;
	      END;
	    END;
	  END
	  Else If x.mode = g_table Then Begin
	  End
	  ELSE IF (y^.name <> 'TRUE') AND (y^.name <> 'FALSE') 
	    AND (y^.class <> g_Proc) AND (y^.class <> g_ProcR) AND (y^.class <> g_Sproc) THEN 
	    BEGIN 
	      Mark('level?!'); x.r := 0; 
	  END;
	  IF y^.class = g_SFR THEN BEGIN
	    IF (x.a < $FFFF) And (x.a >= $FE00) Then
	      x.b := (x.a - $FE00) Div 2
	    Else If (x.a < $F1FF) And (x.a >= $F000) Then
	      x.b := (x.a - $F000) Div 2
	    Else x.b := -1;
	    x.r := g_PC;
	    x.tok := y^.name; 
	  END;    
	END {MakeItem};
	
	{ Startadresse eines Arrays oder Records berechnen: }
	PROCEDURE SelStruct(VAR x: g_Item);
	Var reg: Integer; a: LongInt;
	Begin x.b := x.i_type^.size; 
	  If x.mode = g_Var Then Begin
	    GetReg(reg);
	    If x.lev = 0 Then Begin
	      a := (ramstart Mod $10000) + x.a - x.b;
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #(', Hexword(a), ' + roffs)');
	      addi($E6F0 + reg); addv(a);
	    End
	    Else If x.lev = curlev Then Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', FSP);
	      addi($F000 + reg*16 + FSP);
	      a := x.a - x.b + 2;
	      IF a <> 0 Then Begin
		Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', a);
		If a < 8 Then
		  addi($0800 + reg*16 + a)
		Else Begin
		  addi($06F0 + reg); addv(a);
		End;
	      End;
	    End
	    Else Mark('level!');
	    x.r := reg;
	  End
	  Else If x.mode = g_Par Then Begin
	    GetReg(reg);
	    If smallproc Then Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r);
	      addi($F000 + reg*16 + x.r);
	      Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', 2);
	      addi($0800 + reg*16 + 2);
	    End
	    Else Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', FSP);   
	      addi($F000 + reg*16 + FSP);
	      IF x.a <> 0 Then Begin
		Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', x.a);
		If x.a < 8 Then
		  addi($0800 + reg*16 + x.a)
		Else Begin
		  addi($06F0 + reg); addv(x.a);
		End;
	      End;
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
	      addi($A800 + reg*16 + reg);
	      Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', 2);
	      addi($0800 + reg*16 + 2);
	    End;
	    x.r := reg;
	  End
	  Else If x.mode = g_Ptr Then Begin
	    //Mark('not yet implemented');
	  End
	  Else Mark('structure?');
	End {SelStruct};
	
	PROCEDURE PtrField(VAR x: g_Item; y: g_Object; procpar: Boolean);   (* x := x.y *)
	VAR offs, reg, size: INTEGER; a: LongInt;
	Begin
	  If x.i_type^.form = g_Pointer Then Begin
	    GetReg(reg);
	    If x.lev = 0 Then Begin
	      a := ramstart + x.a - 2;
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', (', HexWord(a), ' + roffs)');
	      addi($F2F0 + reg); addv(a Mod $10000);
	      If y^.o_type^.form = g_Array Then Begin
		size := y^.o_Type^.base^.size;
		If y^.val > size Then Begin
		  Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', y^.val - size);
		  If (y^.val - size) < 8 Then addi($0800 + reg*16 + y^.val - size)
		  Else Begin
		    addi($06F0 + reg); addv(y^.val - size); End; End;
	      End
	      Else Begin
		If y^.val <> 0 Then Begin
		  Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', y^.val);
		  If y^.val < 8 Then addi($0800 + reg*16 + y^.val)
		  Else Begin
		    addi($06F0 + reg); addv(y^.val); End; End;
	      End;
	    End
	    Else If x.lev = curlev Then Begin
	      If Not procpar Then Begin { sonst muss das g_parameter übernehmen }
		IF smallproc THEN BEGIN
		  writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r); 
		  addi($F000 + reg*16 + x.r);
		END
		ELSE BEGIN
		  writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
		  addi($D400 + reg*16 + FSP); addv(x.a);
		END;
		If (x.mode = g_par) Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
		  addi($A800 + reg*16 + reg);
		End;
		If y^.val <> 0 Then Begin
		  Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', y^.val);
		  If y^.val < 8 Then addi($0800 + reg*16 + y^.val)
		  Else Begin
		    addi($06F0 + reg); addv(y^.val); End; End;
	      End
	      //Else x.b := y^.val; {für g_parameter wird aber unten ueberschrieben!}
	    End
	    Else Begin
	      Mark('level?'); End;
	  x.r := reg; x.mode := g_Ptr; x.b := 1;
	  End
	  Else Mark('no pointer');
	End {PtrField};

	PROCEDURE Field(VAR x: g_Item; y: g_Object);   (* x := x.y *)
	VAR offs, reg: INTEGER;
	  BEGIN 
	    IF x.i_type^.form = g_Record THEN BEGIN
	      if y^.o_type^.form = g_array then Begin
		offs := y^.val + y^.o_type^.size - x.i_type^.size; End 
	      else
		offs := 2 - x.i_type^.size + y^.val; 
	      IF x.mode = g_PAR THEN BEGIN
	        GetReg(reg); 
	        IF smallproc THEN BEGIN
 	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r); 
 	          addi($F000 + reg*16 + x.r);
	        END
	        ELSE BEGIN
		  writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
		  addi($D400 + reg*16 + FSP); addv(x.a);
	        END;
	        writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', y^.val + 2);
	        If y^.val < 6 Then addi($0800 + reg*16 + y^.val + 2)
	        Else Begin
		  addi($06F0 + reg); addv(y^.val + 2); End;
	        x.r := reg; 
	      END
	      ELSE Begin
		x.a := x.a + offs;
		If x.mode = g_Ptr Then Begin
		  If y^.val > 0 Then Begin
		  { TODO: was soll das mit R1 ?? }
		    writeln(Taus, chr(9), 'add', chr(9), 'R1, #', y^.val);
		    If y^.val < 8 Then addi($0800 + 1*16 + y^.val)
		    Else Begin
		      addi($06F0 + 1); addv(y^.val); End;
		    End; End;
	      End;  
	      x.b := 1;
	    END
	    ELSE Mark('no record!');
	  END {Field};
	  
	PROCEDURE Index(VAR x, y: g_Item);   (* x := x[y] *)
	  VAR reg1, reg2, reg3: INTEGER; offs,l: LONGINT; p: Tsfrreg; w: Word;
	  BEGIN reg2 := 0; reg3 := 0;
	    If y.i_type^.form = g_word Then Begin
	      If x.mode = g_Ptr Then Begin
		IF y.mode = g_Const THEN BEGIN 
		  IF (y.a <= 0) OR (y.a > x.i_type^.len) THEN  Mark('invalid index');
		  offs := ((y.a - 1) * x.i_type^.base^.size);
		END
		ELSE BEGIN 
		  // Fuer Arrays korrekt??? 
		  offs := (x.i_type^.base^.size - 2);
		END;
		//If offs > $FFFE Then Mark('RAM-overrun');
		If offs > 0 Then Begin
		  writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', #', offs);
		  If offs < 8 Then addi($0800 + x.r*16 + offs)
		  Else Begin
		    addi($06F0 + x.r); addv(offs); End; End
		Else If offs < 0 Then Begin
		  writeln(Taus, chr(9), 'sub', chr(9), 'R', x.r, ', #', abs(offs));
		  If abs(offs) < 8 Then addi($2800 + x.r*16 + abs(offs))
		  Else Begin
		    addi($26F0 + x.r); addv(abs(offs)); End; End;
		x.a := 1; { ??? }
	      End
	      Else IF x.lev = 0 THEN BEGIN
		getreg(reg1); x.r := reg1; x.mode := g_Reg;
		offs := ramstart;// mod $10000;
		IF y.mode = g_Const THEN BEGIN 
		  IF (y.a <= 0) OR (y.a > x.i_type^.len) THEN  Mark('invalid index');
		  offs := offs + x.a - x.i_type^.size + (y.a - 1) * x.i_type^.base^.size;  
		  x.a := 1;
		END
		ELSE BEGIN 
		  offs := offs + (x.a - 2) - x.i_type^.size;
		END;
		//If offs > $FFFE Then Mark('RAM-overrun');
		writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', #(', hexword(offs), ' + roffs)');
		addi($E6F0 + x.r); addramlink; addv( offs Mod $10000);
	      END
	      ELSE IF smallproc THEN BEGIN
		getreg(reg1); 
		writeln(Taus, chr(9), 'mov', chr(9), 'R', reg1, ', R', x.r);
		addi($F000 + reg1*16 + x.r);
		x.r := reg1; x.mode := g_Reg; 
		IF y.mode = g_Const THEN Begin
		  w := y.a  * x.i_type^.base^.size;
		  writeln(Taus, chr(9), 'add', chr(9), 'R', reg1, ', #', w);
		  If w < 8 Then addi($0800 + reg1*16 + w)
		  Else Begin
		    addi($06F0 + reg1); addv(w); End;
		  IF (y.a <= 0) OR (y.a > x.i_type^.len) THEN  Mark('invalid index');
		  x.a := 1;
		End
	      END
	      ELSE BEGIN { lange Prozedur }	
		IF x.mode = g_Par THEN BEGIN
		  GetReg(reg1);
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg1, ', [R', FSP, '+#', x.a, ']');
		  addi($D400 + reg1*16 + FSP); addv(x.a Mod $10000);
		  x.r := reg1; x.mode := g_Reg; 
		  IF y.mode = g_Const THEN Begin
		    IF (y.a <= 0) OR (y.a > x.i_type^.len) THEN  Mark('invalid index');
		      w := y.a  * x.i_type^.base^.size;
		      Writeln(Taus, chr(9), 'add', chr(9), 'R', reg1, ', #', w);
		      If w < 8 Then addi($0800 + reg1*16 + w)
		      Else Begin
			addi($06F0 + reg1); addv(w); End;
		    x.a := 1;
		  END;
		END
		ELSE
		IF y.mode = g_Const THEN BEGIN
	          IF (y.a <= 0) OR (y.a > x.i_type^.len) THEN  Mark('invalid index');
	          x.r := FSP;
	          offs := x.a - x.i_type^.size + 2 + (y.a - 1) * x.i_type^.base^.size; 
	          x.a := offs;  {??? nicht Adresse in Rx! }
	          { ev. R(x.r) := R(FSP); R(x.r) := R(x.r) + #offs; s.u.
		    wird unten mit If x.r = FSP erledigt!}
	          END
		ELSE BEGIN
	          offs := x.a - x.i_type^.size + 2;
	          getreg(reg1); x.r := reg1; x.mode := g_Reg;
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', R', FSP);  
	          addi($F000 + x.r*16 + FSP);
	          writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', #', offs - 2);
	          If (offs - 2) < 8 Then addi($0800 + x.r*16 + offs - 2)
		  Else Begin
		    addi($06F0 + x.r); addv(offs - 2); End;
	          x.a := 0; 
		END;
	      END;
	      IF (y.mode = g_Var) THEN BEGIN
	        load(y); 
	        IF RegUsed[y.r] > 1 THEN BEGIN
	          getreg(reg2); 
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', R', y.r);
	          addi($F000 + reg2*16 + y.r);
	         RetReg(y); y.r := reg2;
	        END;
	      END
	      ELSE IF y.mode = g_Reg THEN BEGIN 
		GetReg(reg2);
		writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', R', y.r);
		addi($F000 + reg2*16 + y.r);
		retreg(y); {NEU!!!}
		y.r := reg2; 
	      END;
	      IF y.mode <> g_Const THEN BEGIN
		If DebugLevel > 1 Then CheckIndex(x.i_type^.len, y.r);
		offs := x.i_type^.base^.size;
		IF IsPot(l,offs) THEN BEGIN
		  writeln(Taus, chr(9), 'shl', chr(9), 'R', y.r, ', #', l); 
		  addi($5C00 + l*16 + y.r); End
		ELSE BEGIN
		  GetReg(reg3);
		  writeln(Taus, chr(9), 'mov', chr(9), 'R', reg3, ', #', offs);
		  If offs < 16 Then addi($E000 + offs*16 + reg3)
		  Else Begin
		    addi($E6F0 + reg3); addv(offs); End;
		  writeln(Taus, chr(9), 'mulu', chr(9), 'R', y.r, ', R', reg3);
		  addi($1B00 + y.r*16 + reg3);
		  p := Fsfr('MDL');
		  extp31;
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', ', HexWord(p.adr));
		  addi($F2F0 + y.r); addv(p.adr);
		  y.r := reg3; RetReg(y); reg3 := 0; y.r := reg2;
		END;
		Writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', R', y.r);
		addi($0000 + x.r*16 + y.r);
		If reg3 <> 0 Then Begin
		  y.r := reg3; RetReg(y); End;
		If reg2 <> 0 Then Begin 
		  y.r := reg2; RetReg(y); End;
	      END;
	      If y.mode <> g_Const Then x.a := 1; { Adresse in Rx }
	      x.b := 1; 
	    End
	    Else Mark('signed index?');
	  END {Index};
	  
	  PROCEDURE TabIndex(Var x:g_item; y: g_Item); (* x := x[y] fuer Tabellen *)
	  var reg: Integer; s: String; adr: LongInt; w: Word;
	  Begin 
	    If y.i_type^.form = g_word Then Begin
	      {If y.mode <> g_Reg Then GetReg(reg)
	      Else reg := y.r;}
	      GetReg(reg);
	      str(x.a, s); 
	      s := 'Table' + ModName + s;
	      Case y.mode Of
		g_const: Begin
		    If (y.a  < 1) Or (y.a > x.i_type^.len) Then 
		      Mark('table-index out of range')
		    Else Begin
		      w := (y.a - 1) * 2;
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #', w);
		      If w < 16 Then addi($E000 + w*16 + reg)
		      Else Begin
			addi($E6F0 + reg); addv(w); End; End;
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, '+#', s, ']');
		    addi($D400 + reg*16 + reg); AddTableRef(x.a); addv(0);
		  End;
		g_reg: Begin
		     If y.lev = curlev Then Begin
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', y.r);
			addi($F000 + reg*16 + y.r);
			End
		      Else Mark('index: level?');
		  End;
		g_Var: Begin
		      If y.lev = 0 Then Begin
			adr := Ramstart + y.a - 2; 
			WriteLn(Taus, chr(9), 'mov', chr(9), 'R', reg, ', (', HexWord(adr), '+roffs)');
			addi($F6F0 + reg); addv(adr Mod $10000); End
		      Else If y.lev = curlev Then Begin { lange Prozedur }
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', y.a, ']');
			addi($D400 + reg*16 + FSP); addv(y.a); End
		      Else Mark('index: level?');
		  End;  
		g_Par: Begin
		      If smallproc Then Begin
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', y.r);
			addi($F000 + reg*16 + y.r); End
		      Else Begin
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
			addi($D400 + reg*16 + FSP); addv(x.a); End;
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
		      addi($A800 + reg*16 + reg);
		  End;
		Else Mark('unknown index!');
	      End;
	      If (y.mode <> g_const) And (DebugLevel > 1)
		Then CheckIndex(x.i_type^.len, reg);
	      If (y.mode <> g_const) Then Begin
		Writeln(Taus, chr(9), 'sub', chr(9), 'R', reg, ', #1');
		addi($2800 + reg*16 + 1);
		Writeln(Taus, chr(9), 'shl', chr(9), 'R', reg, ', #1');
		addi($5C00 + 1*16 + reg);
		Writeln(Taus, chr(9), 'add', chr(9), 'R', reg, ', #', s);
		addi($06F0 + reg); AddTableRef(x.a); addv(0);
		Writeln(Taus, chr(9), 'exts', chr(9), '#', aseg, ', #1');
		addi($D700); addv(aseg*256);
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
		addi($A800 + reg*16 + reg); End;
	      x.r := reg; x.mode := g_reg; End
	    Else Mark('signed index?');
	  End; { TabIndex }
	  
	PROCEDURE BJump(lab: LONGINT);
	Var p: labp;
	  BEGIN Findlabel(p, lab);
	    If (cap - p^.Ziel + 2) < 256 Then Begin { jmpr }
	      write(Taus, chr(9), 'jmpr', chr(9), 'UC, ');
	      SetLabel(lab, '');
	      addi($0D00 + rbj(p^.Ziel)); End
	    Else Begin { jmpa }
	      write(Taus, chr(9), 'jmpa', chr(9), 'UC, ');
	      SetLabel(lab, '');
	      addi($EA00); Addromlink; addv(p^.Ziel); End;
	    p^.nr := -1 ; { ist erledigt }
	  END {BJump};

	PROCEDURE FJump(lab: LONGINT);
	Var p: labp;
	  BEGIN Findlabel(p, lab);
	    If p <> Nil Then Begin
	      write(Taus, chr(9), 'jmpa', chr(9), 'UC, ');
	      SetLabel(lab, '');
	      addi($EA00); AddLabRef(p, lab); Addromlink; addv(0);
	    End
	    Else Mark('oops: Label not found (FJump)');
	  END {BFump};

	  PROCEDURE CJump(lab:longint; signed: Boolean);
	  var op1:string; op1c: Byte; p:labp;
	  BEGIN
	    CASE Lastop of
	      eql_: Begin op1 := 'NE'; op1c := 3; End;
	      neq_: Begin op1 := 'EQ'; op1c := 2; End;
	      lss_: If signed Then Begin
		      op1 := 'SGE'; op1c := 13; End
		    Else Begin
		      op1 := 'UGE'; op1c := 9; End;
	      geq_: If signed Then Begin
		      op1 := 'SLT'; op1c := 12; End
		    Else Begin
		      op1 := 'ULT'; op1c := 8; End;
	      leq_: If signed Then Begin
		      op1 := 'SGT'; op1c := 10; End
		    Else Begin
		      op1 := 'UGT'; op1c := 14; End;
	      gtr_: If signed Then Begin
		      op1 := 'SLE'; op1c := 11; End
		    Else Begin
		      op1 := 'ULE'; op1c := 15; End;
	      zero_: Begin op1 := 'Z'; ; op1c := 2; End;
	    END;
	    Findlabel(p, lab); 
	    If p^.Ziel = 0 Then Begin { Vorwaertssprung: }
	      write(Taus, chr(9), 'jmpa', chr(9), op1, ', ');
	      addi($EA00 + op1c*16); AddLabRef(p, lab);
	      SetLabel(lab, ''); Addromlink; addv(0); 
	    End
	    Else Begin { Rueckwaertssprung: durch REPEAT-UNTIL }
	      If (cap - p^.Ziel + 2) < 256 Then Begin { jmpr }
		write(Taus, chr(9), 'jmpr', chr(9), op1, ', ');
		SetLabel(lab, '');
		addi(op1c*256*16 + $0D00 + rbj(p^.Ziel)); End
	      Else Begin { jmpa }
		write(Taus, chr(9), 'jmpa', chr(9), op1, ', ');
		SetLabel(lab, '');
		addi($EA00 + op1c*16); Addromlink; addv(p^.Ziel); End;
	      p^.nr := -1 ; { ist erledigt }
	    End;
	  END {CJump};
  
	PROCEDURE Op1(op: INTEGER; VAR x: g_Item);   (* x := op x *)
	  VAR lab1, lab2: Longint; opform: Integer; p: labp;
	  BEGIN 
	    If x.i_type^.form = g_Array Then
	      opform := x.i_type^.base^.form
	    Else opform := x.i_type^.form;
	    CASE op OF
	      minus_: 
		    If opform = g_Integer Then Begin
		      If x.mode = g_Const Then x.a := -x.a
		      Else Begin
			IF x.mode = g_Ptr Then begin
			  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
			  addi($A800 + x.r*16 + x.r); x.mode := g_Reg;
			End
			Else If x.mode <> g_Reg Then load(x);
			writeln(Taus, chr(9), 'cpl', chr(9), 'R', x.r); 
			addi($9100 + x.r*16);
			writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', #1'); 
			addi($0800 + x.r*16 + 1); End;
		    End
		    Else Mark('not signed');
	      not_: BEGIN 
		    If opform = g_Boolean Then Begin
		      IF x.mode = g_Ptr Then begin
			  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
			  addi($A800 + x.r*16 + x.r); x.mode := g_Reg;
		      End
		      Else if x.mode <> g_Reg then load(x);
	              writeln(Taus, chr(9), 'xor', chr(9), 'R', x.r, ', #1'); 
	              addi($5800 + x.r*16 + 1); End
	            Else Mark('not boolean!');
	            END;
	      or_: BEGIN 
	             lab1 := Getlabel; x.a := Getlabel;
	             CJump(lab1, False);
	             write(Taus, chr(9), 'jmpa', chr(9)); 
	             Setlabel(x.a, 'OR passed'); 
	             addi($EA00); p:= Nil; AddLabRef(p, x.a);
	             x.mode := g_Cond; Addromlink; addv(0); NeWlabel(lab1, ''); 
	           END;
	      and_: BEGIN 
	             lab1 := Getlabel; lab2 := Getlabel; x.a := Getlabel;
	             CJump(lab1, False);
	             write(Taus, chr(9), 'jmpa', chr(9)); Setlabel(lab2, 'AND passed');
	             addi($EA00); p:= Nil; AddLabRef(p, lab2); Addromlink; addv(0);
	             NeWlabel(lab1, ''); 
	             write(Taus, chr(9), 'jmpa', chr(9)); Setlabel(x.a, 'AND failed');
	             addi($EA00); p := Nil; AddLabRef(p, x.a); Addromlink; addv(0);
	             Newlabel(lab2, ' AND next');
	             x.mode := g_Cond;
	            END;
	      ELSE Mark('operator?');
	    END;
	  END {Op1};
	  
	

	PROCEDURE Op2(op: INTEGER; VAR x, y: g_Item);   (* x := x op y *)
	  VAR lab1, lab2, n: LONGINT; reg, zform, qform: INTEGER; p: Tsfrreg; pl: labp;
	      i, j: Integer;
	  BEGIN 
	    IF x.mode = g_Cond THEN BEGIN
	        IF op = or_ THEN BEGIN
	          lab1 := GetLabel; lab2 := GetLabel; CJump(lab1, False); //CJump(x.a);
	          Getreg(reg);
	          Newlabel(x.a, ' OR passed');
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #1');
	          addi($E000 + 16 + reg);
	          write(Taus, chr(9), 'jmpa', chr(9)); setlabel(lab2, '');
	          addi($EA00); pl:= Nil; AddLabRef(pl, lab2); Addromlink; addv(0);
	          NewLabel(lab1, ' OR failed');
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #0');
	          addi($E000 + reg);
	          Newlabel(lab2, ' OR done'); 
	          lastop := neq_; x.r := reg; retreg(x);
	        END
	        ELSE IF op = and_ THEN BEGIN
	          lab1 := GetLabel; 
	          CJump(x.a, False); Getreg(reg);
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #0');
	          addi($E000 + reg);
	          write(Taus, chr(9), 'jmpa', chr(9)); setlabel(lab1, '');
	          addi($EA00); pl:= Nil; AddLabRef(pl, lab1); Addromlink; addv(0);
	          NewLabel(x.a, 'AND failed');
	          writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #1');
	          addi($E000 + 16 + reg);
	          Newlabel(lab1, ' AND done'); 
	          lastop := eql_; x.r := reg; retreg(x); 
	        END
	        ELSE Mark('operator?');
	    END { conditional}
	    ELSE Begin
	      IF x.i_type^.form In [g_Array, g_tablef] THEN zform := x.i_type^.base^.form
	      ELSE zform := x.i_type^.form;
	      IF y.i_type^.form IN [g_Array, g_tablef] THEN qform := y.i_type^.base^.form
	      ELSE qform := y.i_type^.form;   
	      If (x.mode = g_const) And (qform = g_Integer) Then
		If x.a < 32768 Then zform := g_Integer
		Else Mark('too large fpr int');
	      If (y.mode = g_const) And (zform = g_Integer) Then
		If y.a < 32658 Then qform := g_Integer
		Else Mark('too large fpr int');
	    IF (zform In [g_Word, g_Integer]) AND (zform = qform) THEN BEGIN {Word/Integer}    
	      IF (zform = g_Word) AND (x.mode = g_Const) AND (y.mode = g_Const) THEN
	        CASE op OF
	          plus_:  BEGIN x.a := x.a + y.a;
	          	  if x.a > $FFFF THEN Warn('overflow?'); END;
	          minus_: BEGIN x.a := x.a - y.a;
	          	  if x.a < 0 THEN Warn('underflow?'); END;
	          times_: BEGIN x.a := (x.a * y.a); // MOD $10000;
			if x.a > $FFFF then Warn('overflow?'); END;
	          div_:   x.a := x.a DIV y.a;
	          mod_:   x.a := x.a Mod y.a;
	          ELSE mark('bad type!');
	        END
	      ELSE If (zform = g_Word) And (y.mode = g_Const) AND (op IN [times_, div_, mod_]) AND IsPot(n, y.a) THEN BEGIN
	        If x.mode = g_Ptr Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  addi($A800 + x.r*16 + x.r); x.mode := g_Reg;
	        End
	        Else IF x.mode <> g_Reg THEN load(x);
	        CASE op OF
	          times_: 
	            IF y.a = 0 THEN Begin
	              writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', #0');
	              addi($E000 + 0*16 + x.r); End
	            ELSE BEGIN
	              writeln(Taus, chr(9), 'shl', chr(9), 'R', x.r, ', #', n);
	              addi($5C00 + n*16 + x.r);
	              If DebugLevel > 1 Then CheckFlag('NC');
	            End;
	          div_:
	            IF y.a = 0 THEN
		      Mark('div. by zero!')
	            ELSE If n > 0 Then Begin
	              writeln(Taus, chr(9), 'shr', chr(9), 'R', x.r, ', #', n);
	              addi($7C00 + n*16 +x.r); End;
	          mod_:
	            IF y.a = 0 THEN
		      Mark('div. by zero!')
	            ELSE Begin
	              y.a := y.a - 1;
	              writeln(Taus, chr(9), 'and', chr(9),'R', x.r, ', #', hexword(y.a));
	              If y.a < 8 Then addi($6800 + x.r*16 + y.a)
	              Else Begin
			addi($66F0 + x.r); addv(y.a); End; End;
	        END;
	      END
	      ELSE BEGIN
		IF x.i_type^.form = g_Array THEN BEGIN
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  addi($A800 + x.r*16 + x.r);
		  x.a := 0; { Wert in Rx } 
		END;
	        If x.mode = g_Ptr Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  addi($A800 + x.r*16 + x.r); x.mode := g_Reg; End
	        Else If (x.mode = g_SFR) And (op In [times_, div_, mod_]) Then Begin
		  GetReg(reg); x.r := reg; x.mode := g_Reg;
		  extp31;
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', ', Hexword(x.a));
		  addi($F2F0 + x.r); addv(x.a); End
	        Else IF (x.mode <> g_Reg) And (x.mode <> g_SFR) THEN load(x);
	        If y.mode = g_Ptr Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		  addi($A800 + y.r*16 + y.r); y.mode := g_Reg; End
	        Else IF (y.mode <> g_Const) OR (op = times_) then load(y);
	        CASE op OF
	          plus_:  Begin
		    If x.mode = g_SFR Then Begin
		      If y.mode = g_Const Then Begin
			extr1(x.a);
			Writeln(Taus, chr(9), 'add', chr(9), Hexword(x.a), ', #', y.a);
			addi($0600 + x.b); addv(y.a);
		      End
		      Else Begin
			extp31;
			Writeln(Taus, chr(9), 'add', chr(9), Hexword(x.a), ', R', y.r);
			addi($04F0 + y.r); addv(x.a);
		      End;
		    End
		    Else Begin
		      If y.mode <> g_Reg Then Begin
			Write(Taus, chr(9), 'add', chr (9), 'R', x.r, ', ');
			Writeln(Taus, '#', y.a); 
			If (y.a >= 0) And (y.a < 8) Then addi($0800 + x.r*16 + y.a)
			Else Begin
			  addi($06F0 + x.r); addv(y.a); End;
		      End
		      Else Begin
			Write(Taus, chr(9), 'add', chr (9), 'R', x.r, ', ');
			Writeln(Taus, 'R', y.r); 
			addi($0000 + x.r*16 + y.r);
		      End;
		      IF DebugLevel > 1 Then CheckFlag('NC');
		    End;
		  End;
	          minus_: Begin
		    If x.mode = g_SFR Then Begin
		      If y.mode = g_Const Then Begin
			extr1(x.a);
			Writeln(Taus, chr(9), 'sub', chr(9), Hexword(x.a), ', #', y.a);
			addi($2600 + x.b); addv(y.a);
		      End
		      Else Begin
			extp31;
			Writeln(Taus, chr(9), 'sub', chr(9), Hexword(x.a), ', R', y.r);
			addi($24F0 + y.r); addv(x.a);
		      End;
		    End
		    Else Begin
		      If y.mode <> g_Reg Then Begin
			Write(Taus, chr(9), 'sub', chr (9), 'R', x.r, ', ');
			Writeln(Taus, '#', y.a); 
			If (y.a >= 0) And (y.a < 8) Then addi($2800 + x.r*16 + y.a)
			Else Begin
			  addi($26F0 + x.r); addv(y.a); End;
		      End
		      Else Begin
			Write(Taus, chr(9), 'sub', chr (9), 'R', x.r, ', ');
			Writeln(Taus, 'R', y.r); 
			addi($2000 + x.r*16 + y.r);
		      End;
		      IF DebugLevel > 1 Then CheckFlag('NC');
		    End;
		  End;
	          andb_ : Begin
		    If x.mode = g_SFR Then Begin
		      If y.mode = g_Const Then Begin
			extr1(x.a);
			Writeln(Taus, chr(9), 'and', chr(9), Hexword(x.a), ', #', y.a);
			addi($6600 + x.b); addv(y.a);
		      End
		      Else Begin
			extp31;
			Writeln(Taus, chr(9), 'and', chr(9), Hexword(x.a), ', R', y.r);
			addi($64F0 + y.r); addv(x.a);
		      End;
		    End
		    Else Begin
		      IF (y.mode <> g_Reg) THEN Begin
			Write(Taus, chr(9), 'and', chr (9), 'R', x.r, ', ');
			Writeln(Taus, '#', y.a);
			If (y.a >= 0) And (y.a < 8) Then addi($6800 + x.r*16 + y.a)
			Else Begin
			  addi($66F0 + x.r); addv(y.a); End; End
		      ELSE Begin
			Write(Taus, chr(9), 'and', chr (9), 'R', x.r, ', ');
			Writeln(Taus, 'R', y.r);
			addi($6000 + x.r*16 +y.r); End; 
		    End;
		  End;
	          orb_: Begin
		    If x.mode = g_SFR Then Begin
		      If y.mode = g_Const Then Begin
			extr1(x.a);
			Writeln(Taus, chr(9), 'or', chr(9), Hexword(x.a), ', #', y.a);
			addi($7600 + x.b); addv(y.a);
		      End
		      Else Begin
			extp31;
			Writeln(Taus, chr(9), 'or', chr(9), Hexword(x.a), ', R', y.r);
			addi($74F0 + y.r); addv(x.a);
		      End;
		    End
		    Else Begin
		      IF (y.mode <> g_Reg) THEN Begin
			Write(Taus, chr(9), 'or', chr (9), 'R', x.r, ', ');
			Writeln(Taus, '#', y.a);
			If (y.a >= 0) And (y.a < 8) Then addi($7800 + x.r*16 + y.a)
			Else Begin
			  addi($76F0 + x.r); addv(y.a); End; End
		      ELSE Begin
			Write(Taus, chr(9), 'or', chr (9), 'R', x.r, ', ');
			Writeln(Taus, 'R', y.r);
			addi($7000 + x.r*16 +y.r); End; 
		    End;
		  End;
	          xorb_: Begin
		    If x.mode = g_SFR Then Begin
		      If y.mode = g_Const Then Begin
			extr1(x.a);
			Writeln(Taus, chr(9), 'xor', chr(9), Hexword(x.a), ', #', y.a);
			addi($5600 + x.b); addv(y.a);
		      End
		      Else Begin
			extp31;
			Writeln(Taus, chr(9), 'xor', chr(9), Hexword(x.a), ', R', y.r);
			addi($54F0 + y.r); addv(x.a);
		      End;
		    End
		    Else Begin
		      IF (y.mode <> g_Reg) THEN Begin
			Write(Taus, chr(9), 'xor', chr (9), 'R', x.r, ', ');
			Writeln(Taus, '#', y.a);
			If (y.a >= 0) And (y.a < 8) Then addi($5800 + x.r*16 + y.a)
			Else Begin
			  addi($56F0 + x.r); addv(y.a); End; End
		      ELSE Begin
			Write(Taus, chr(9), 'xor', chr (9), 'R', x.r, ', ');
			Writeln(Taus, 'R', y.r);
			addi($5000 + x.r*16 +y.r); End; 
		    End;
		  End;
	          times_: Begin
			If zform = g_Word Then Begin
			  Writeln(Taus, chr(9), 'mulu', chr (9), 'R', x.r, ', R', y.r);
			  addi($1B00 + x.r*16 + y.r); End
			Else Begin
			  Writeln(Taus, chr(9), 'mul', chr (9), 'R', x.r, ', R', y.r);
			  addi($0B00 + x.r*16 + y.r) End;
			IF DebugLevel > 1 Then CheckFlag('NV');
			p := Fsfr('MDL'); extp31;
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', ', HexWord(p.adr)); 
			addi($F2F0 + x.r); addv(p.adr);
		    End;
	          div_, mod_: Begin
			IF (y.mode <> g_Reg) then load(y);
			p := Fsfr('MDL'); extp31;
			Writeln(Taus, chr(9), 'mov', chr(9), HexWord(p.adr),', R', x.r);
			addi($F6F0 + x.r); addv(p.adr);
			If zform = g_Word Then Begin
			  Writeln(Taus, chr(9), 'divu', chr(9), 'R', y.r);
			  addi($5B00 + y.r*16 + y.r); End
			Else Begin
			  Writeln(Taus, chr(9), 'div', chr(9), 'R', y.r);
			  addi($4B00 + y.r*16 + y.r); End;
			IF DebugLevel > 1 Then CheckFlag('NV');
			If op = mod_ Then p := Fsfr('MDH');
			extp31;
			Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', ', HexWord(p.adr)); 
			addi($F2F0 + x.r); addv(p.adr);
			If (op = mod_) And (zform = g_Integer) Then Begin {Mod ist immer positiv}
			  lab1 := Getlabel;
			  Write(Taus, chr(9), 'jnb', chr(9), 'R', x.r, '.15, '); 
			  SetLabel(lab1, '> 0');
			  addi($9AF0 + x.r); addv(2 + 15*256*16);
			  writeln(Taus, chr(9), 'cpl', chr(9), 'R', x.r);
			  addi($9100 + x.r*16);
			  writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ',#1'); 
			  addi($0800 + x.r*16 + 1);
			  Newlabel(lab1, '');
	          	End;
		    End;
	          ELSE mark('bad type!');
	        END;
	        IF (y.mode = g_Reg) THEN Retreg(y); 
	      END;
	    END { Word/Integer }
	    ELSE IF (zform = g_Boolean) AND (zform = qform) THEN BEGIN
	        If x.mode = g_Ptr Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  addi($A800 + x.r*16 + x.r); x.mode := g_Reg;
	        End
	        Else load(x);
	        If y.mode = g_Ptr Then Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		  addi($A800 + y.r*16 + y.r); y.mode := g_Reg;
	        End
	        Else IF (y.mode <> g_Const) then load(y);
	        CASE op OF
	          and_: Begin
		      IF (y.mode = g_Const) THEN Begin
			Write(Taus, chr(9), 'and', chr(9), 'R', x.r, ', #', y.a);
			If (y.a >= 0) And (y.a < 8) Then
			  addi($6800 + x.r*16 + y.a)
			Else Begin
			  addi($66F0 + x.r); addv(y.a); End;
		      End
		      Else Begin
			Write(Taus, chr(9), 'and', chr(9), 'R', x.r, ', R', y.r);
			RetReg(y);
			addi($6000 + x.r*16 + y.r); End;
		    End;
	          or_: Begin
		      IF (y.mode = g_Const) THEN Begin
			Write(Taus, chr(9), 'or', chr(9), 'R', x.r, ', #', y.a);
			If (y.a >= 0) And (y.a < 8) Then
			  addi($7800 + x.r*16 + y.a)
			Else Begin
			  addi($76F0 + x.r); addv(y.a); End;
		      End
		      Else Begin
			Write(Taus, chr(9), 'or', chr(9), 'R', x.r, ', R', y.r);
			RetReg(y);
			addi($7000 + x.r*16 + y.r); End;
		    End;
	          ELSE mark('operator?');
	        END;
	    END { Boolean }
	    Else Mark('type not allowed');
	    end;
	  END {Op2};
	  
	PROCEDURE TestTrue(VAR x:g_Item);
	BEGIN 
	  If x.mode = g_Ptr Then Begin
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
	    addi($4800 + x.r*16 + x.r); x.mode := g_Reg;
	  End
	  Else IF x.mode <> g_Reg THEN load(x);
	  writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', #', 1);
	  addi($4800 + x.r*16 + 1); Retreg(x);
	  Lastop := eql_; 
	END;

	PROCEDURE Relation(op: INTEGER; VAR x, y: g_Item);   (* x := x ? y *)
	Var zform, qform, reg: INTEGER; a: LongInt;
	
	  PROCEDURE relptr(op: Integer; VAR x, y: g_Item);
	  Var reg, reg2: Integer; a: LongInt;
	  Begin 
	    If (op = eql_) Or (op = neq_) Then 
	      If y.i_type = ptrType Then Begin
		Lastop := op;
		If x.mode <> g_Ptr Then
		  GetReg(reg)
		Else Begin
		  reg := x.r;
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  addi($4800 + x.r*16 + y.r);
		End;
		If x.lev = 0 Then Begin
		  a := ramstart + x.a - 2;
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', (', HexWord(a), ' + roffs)');
		  addi($F2F0 + reg); addv(a Mod $10000); x.r := reg;
		End
		Else IF x.lev = curlev Then Begin
		  If smallproc Then
		    If x.mode <> g_Ptr Then Begin
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', x.r);
		      addi($F000 + reg*16 + x.r); End
		  Else 
		    If x.mode <> g_Ptr Then Begin
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a,']');
		      addi($D400 + reg*16 + FSP); addv(x.a); End;
		  If x.mode = g_Par Then Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
		    addi($A800 + reg*16 + reg);
		  End;
		  x.r := reg;
		End
		Else Mark('level?');
		If y.mode = g_const Then begin { NIL }
		  Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', #', y.a);
		  If y.a < 0 Then Begin
		    If y.a > -32769 Then Begin
		      addi($46F0 + x.r); addv($10000 + y.a); 
		    End
		    Else Mark('out of range');
		  End
		  Else If y.a < 8 Then addi($4800 + x.r*16 + y.a)
		  Else Begin
		    addi($46F0 + x.r); addv(y.a); End;
		End
		Else If y.lev = 0 Then Begin
		  a := ramstart + y.a - 2;
		  Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', (', HexWord(a), ' + roffs)');
		  addi($42F0 + reg2); addv( a Mod $10000);
		End
		Else If y.lev = curlev Then Begin
		  If y.mode = g_Par Then Begin
		    GetReg(reg2);
		    If smallproc Then Begin
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', R', y.r);
		      addi($F000 + reg2*16 + y.r);
		    End
		    Else Begin
		      Writeln(taus, chr(9), 'mov', chr(9), 'R', reg2, ', [R', FSP, '+#', y.a, ']');
		      addi($D400 + reg2*16 + FSP); addv(y.a);
		    End;
		    Writeln(taus, chr(9), 'mov', chr(9), 'R', reg2, ', [R', reg2, ']');
		    addi($A800 + reg2*16 + reg2);
		    Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', R', y.r);
		    addi($4000 + x.r*16 + y.r);
		    y.r := reg2; Retreg(y);
		  End
		  Else If smallproc Then Begin
		    Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', R', y.r);
		    addi($4000 + x.r*16 + y.r);
		  End
		  Else Begin
		    GetReg(reg2);
		    Writeln(taus, chr(9), 'mov', chr(9), 'R', reg2, ', [R', FSP, '+#', y.a, ']');
		    addi($D400 + reg2*16 + FSP); addv(y.a);
		    Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r, ', R', y.r);
		    addi($4000 + x.r*16 + y.r);
		    y.r := reg2; Retreg(y);
		  End
		End  
		Else Mark('level?');
		RetReg(x);
	      End
	      Else Mark(' no match with pointer')
	    Else Mark('compare pointer?');
	  End; { RelPtr }
	
	  BEGIN { Relation }
	    If x.i_type = ptrType Then Begin relptr(op, x, y); exit; End;
	    Lastop := op; 
	    If (x.mode = g_Par) And (x.r = FSP) Then Begin
	      getreg(reg); x.r := reg;
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
	      addi($D400 + reg*16 + FSP); addv(x.a); x.mode := g_Reg; End;
	    If (x.mode In [g_Ptr, g_Par]) Or ((x.mode = g_Reg) And (x.i_type^.form = g_Array)) Then Begin
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
	      addi($A800 + x.r*16 + x.r); x.mode := g_Reg; End;
	    If x.mode = g_SFR Then Begin { das geht auch kürzer }
	      getreg(reg); x.r := reg;
	      extp31;
	      Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', ', HexWord(x.a));
	      addi($F2F0 + reg); addv(x.a);
	      x.mode := g_Reg; End;
	    If x.mode <> g_Reg Then load(x);
	    zform := x.i_type^.form; qform := y.i_type^.form;
	    { g_Tablef noch dazu nehmen ? }
	    IF (x.i_type^.form < g_Record) AND (y.i_type^.form < g_Record) THEN BEGIN
	      If (y.mode = g_Par) And (y.r = FSP) Then Begin
		getreg(reg); y.r := reg;
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', y.a, ']');
		addi($D400 + reg*16 + FSP); addv(y.a); y.mode := g_Reg; End;
	      If y.mode = g_Const Then BEGIN
		Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r,', #', y.a);
		If y.a < 0 Then Begin
		    If y.a > -32769 Then Begin
		      addi($46F0 + x.r); addv($10000 + y.a); 
		    End
		    Else Mark('out of range');
		  End
		  Else If y.a < 8 Then addi($4800 + x.r*16 + y.a)
		  Else Begin
		    addi($46F0 + x.r); addv(y.a); End;
	      End
	      Else If ((y.mode = g_Var) And (y.lev = 0)) Or (y.mode = g_SFR) Then Begin
		If y.mode = g_SFR Then Begin
		  a := y.a; extp31; 
		  Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r,', ', a);
		End
		Else BEGIN
		  a:= ramstart + y.a - 2; { fehlt hier roffs? }
		  Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r,', ', HexWord(a));
		End;
		addi($42F0 + x.r); addv(a Mod $10000);
	      End
	      Else Begin 
		If (y.mode = g_Reg) And (y.i_type^.form = g_Array) And (y.a <> 0) Then Begin
		  getreg(reg); y.r := reg;
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R',  y.r, ']');
		  addi($A800 + reg*16 + reg); y.mode := g_Reg; End;
		If y.mode <> g_Reg Then load(y);
		Writeln(Taus, chr(9), 'cmp', chr(9), 'R', x.r,', R', y.r);
		addi($4000 + x.r*16 + y.r);
	      End;	      
	      x.c := op;
	      IF NOT(forloop) THEN BEGIN
	        IF (x.mode = g_Reg) OR (x.mode = g_Par) THEN Retreg(x);
	        IF (y.mode = g_Reg) OR (y.mode = g_Par) THEN Retreg(y);
	      END;
	    END
	    Else Mark('bad type!'); 
	    If x.r <= lastreg Then retreg(x); If y.r <= lastreg Then retreg(y);
	  END {Relation};
	  
	PROCEDURE MemCopy(x,y: g_Item); { x := y }
	var reg, treg, c: Integer; lab: Longint; l: Word;
	Begin
	  If x.i_type = y.i_type Then Begin
	    If x.mode = g_Ptr Then
	      If x.i_Type^.form = g_Array Then Begin { in SelPtr fehlen 2 Bytes im Offset: }
		Writeln(Taus, chr(9), 'add', chr(9), 'R', x.r, ', #', x.i_Type^.base^.size);
		addi($0800 + x.r*16 + x.i_Type^.base^.size);
	      End;
	    If y.mode = g_Ptr Then
	      If y.i_Type^.form = g_Array Then Begin { in SelPtr fehlen 2 Bytes im Offset: }
		Writeln(Taus, chr(9), 'add', chr(9), 'R', y.r, ', #', x.i_Type^.base^.size);
		addi($0800 + y.r*16 + x.i_Type^.base^.size);
	      End;
	    If y.b <= 10 Then Begin
	      c := 0;
	      Repeat
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', x.r, '+], [R', y.r, ']');
		addi($D800 + x.r*16 + y.r);
		If c < y.b Then Begin
		  Writeln(Taus, chr(9), 'add', chr(9), 'R', y.r, ', #2');
		  addi($0800 + y.r*16 + 2); End;
		c := c + 2;
	      Until c > y.b;
	    End
	    Else Begin
	      lab := GetLabel;
	      If x.r > 1 Then Begin { save  R1 to stack and use it}
		reg := 1;
		Writeln(Taus, chr(9), 'scxt', chr(9), 'R1, #', y.b);
		addi($C6F0 + 1); addv(y.b);
	      End
	      Else Begin
		Getreg(reg);
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #', y.b);
		addi($E6F0 + reg); addv(y.b);
	      End;
	      NewLabel(lab, 'copyloop'); l := cap;
	      Writeln(Taus, chr(9), 'mov', chr(9), '[R', x.r, '+], [R', y.r, ']');
	      addi($C800 + x.r*16 + y.r);
	      Writeln(Taus, chr(9), 'add', chr(9), 'R', y.r, ', #2');
	      addi($0800 + y.r*16 + 2);
	      Writeln(Taus, chr(9), 'sub', chr(9), 'R', reg, ', #2');
	      addi($2800 + reg*16 + 2);
	      Write(Taus, chr(9), 'jmpr', chr(9), 'NZ, '); SetLabel(lab, '');
	      addi($3D00 + rbj(l));
	      If reg = 1 Then BEGIN {restore R1 }
		Writeln(Taus, chr(9), 'pop', chr(9), 'R1');
		addi($FCF0 + 1);
	      END
	      Else Begin
		treg := x.r; x.r := reg; RetReg(x); x.r := treg; End;
	    End;
	    RetReg(y); RetReg(x);
	  End
	  Else Mark('differnet types!');
	End; { MemCopy }
  
	PROCEDURE Store(VAR x, y: g_Item); { x := y }
	  VAR r1: LONGINT; reg, reg2, z, q: g_Type; 
	  
	  PROCEDURE StorePointer(x, y: g_item);
	  Var reg, reg2: Integer; a: LongInt;
	  Begin reg := 16; 
	    If y.i_type = ptrType Then Begin
	      If y.mode = g_Ptr Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		addi($A800 + y.r*16 + y.r);
	      End
	      Else Begin
		GetReg(reg);
		If y.mode = g_Const Then  Begin { NIL }
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', #', y.a);
		  If y.a < 16 Then
		    addi($E000 + y.a*16 + reg)
		  Else begin
		    addi($E6F0 + reg); addv(y.a); End; End
		Else If y.lev = 0 Then Begin
		  a := ramstart + y.a - 2;
		  If a = ramstart Then Begin { _FRESULT? }
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', ', HexWord(a));
		    addi($E6F0 + reg); addv(a Mod $10000); End
		  Else Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', (', HexWord(a), ' + roffs)');
		    addi($E6F0 + reg); Addramlink; addv(a Mod $10000); end;
		End
		Else if y.lev = curlev Then Begin
		  If smallproc Then Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', R', y.r);
		    addi($F000 + reg*16 + y.r); End
		  Else Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', y.a,']');
		    addi($D400 +reg*16 + FSP); addv(y.a); End;
		  If (y.mode = g_Par) Then Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', reg, ']');
		    addi($A800 + reg*16 + reg);
		  End;
		End
		Else Mark('level?');
		y.r := reg; 
	      End;
	      If x.mode = g_Ptr Then Begin
		Writeln(Taus, chr(9), 'mov', chr(9), '[R', x.r, '], R', y.r);
		addi($B800 + y.r*16 + x.r);
		RetReg(x);
	      End
	      Else If x.lev = 0 Then Begin
		a := ramstart + x.a - 2;
		If a = ramstart Then Begin { _FRESULT? }
		  Writeln(Taus, chr(9), 'mov', chr(9), HexWord(a), ', R', y.r);
		  addi($F6F0 + y.r); addv(a Mod $10000); End
		Else Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), '(', HexWord(a), ' + roffs), R', y.r);
		  addi($F6F0 + y.r); Addramlink; addv(a Mod $10000); End;
	      End
	      Else If x.lev = curlev Then begin
		If x.mode = g_Par Then
		  If smallproc Then Begin
		    Writeln(taus, chr(9), 'mov', chr(9), '[R', x.r, '], R', y.r);
		    addi($B800 + y.r*16 + x.r);
		  End
		  Else Begin
		    GetReg(reg2);
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg2, ', [R', FSP, '+#', x.a, ']');
		    addi($D400 +reg2*16 + FSP); addv(x.a);
		    Writeln(taus, chr(9), 'mov', chr(9), '[R', reg2, '], R', y.r);
		    addi($B800 + y.r*16 + reg2);
		    x.r := reg2; RetReg(x);
		  End
		Else
		  If smallproc Then Begin
		    Writeln(taus, chr(9), 'mov', chr(9), 'R', x.r, ', R', y.r);
		    addi($F000 + x.r*16 + y.r);
		  End
		  Else Begin
		    writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', x.a, '], R', y.r);
		    addi($C400 + y.r*16 + FSP); addv(x.a);
		  End;
	      End
	      Else Mark('level?');      
	      RetReg(y);
	    End      
	    Else Mark('no pointer!');
	  End; { StorePointer }
	  
	  PROCEDURE StoreReg(Var x, y: g_item);
	  var i: INTEGER; r1, varval: LONGINT;
	  Begin varval := (65000 * x.lev) + x.a;
	    FOR i := nextreg TO lastreg do
	      IF Regs[i] = varval THEN Regs[i] := -1;
	    Case y.mode Of
	      g_Reg: Begin
		  If (y.i_type^.form = g_Array) And (y.a <> 0) Then Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', y.r, ']');
		    addi($A800 + x.r*16 + y.r);
		  End
		  Else If x.r <> y.r Then Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', R', y.r);
		    addi($F000 + x.r*16 + y.r);
		    Regs[y.r] := varval;
		  End;
		End;
	      g_Const: Begin
		  Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', #', y.a);
		  If (y.a >= 0) And (y.a < 16) Then
		    addi($E000 + y.a*16 + x.r)
		  Else begin
		    addi($E6F0 + x.r); addv(y.a); End;
		End;
	      g_Var:
		If y.lev = 0 Then Begin
		  
		  If y.a = 2 Then Begin { _FRESULT }
		    Write(Taus, chr(9), 'mov', chr(9), 'R', x.r); 
		    Writeln(Taus, ', ',hexword(ramstart + y.a - 2));
		    addi($F2F0 + x.r); addv((ramstart + y.a - 2) Mod $10000);
		  End
		  Else Begin
		    Write(Taus, chr(9), 'mov', chr(9), 'R', x.r); 
		    Writeln(Taus, ', (',hexword(ramstart + y.a - 2), ' + roffs)');
		    addi($F2F0 + x.r); Addramlink; addv((ramstart + y.a - 2) Mod $10000);
		  End;
		End
		Else begin
		  Write(Taus, chr(9), 'mov', chr(9), 'R', x.r); 
		  Writeln(Taus, ', [R', FSP,'+#', y.a, ']');
		  addi($D400 + x.r*16 + FSP); addv(y.a);
		End;
	      g_Par, g_Ptr: Begin
		  IF smallproc THEN BEGIN
		    writeln(Taus,chr(9), 'mov', chr(9), 'R', x.r, ', [R', y.r, ']');
		    addi($A800 + x.r*16 + y.r);
		  END
		  ELSE BEGIN
		    load(y);
		    writeln(Taus,chr(9), 'mov', chr(9), 'R', x.r, ', R', y.r);
		    addi($F000 + x.r*16 + y.r);
		  End;
		End;
	      g_SFR: Begin
		  extp31;
		  Writeln(Taus,chr(9), 'mov', chr(9), 'R', x.r, ', ', HexWord(y.a));
		  addi($F2F0 + x.r); addv(y.a);
		End;
	      {g_Adr: Begin
		  Writeln(Taus,chr(9), 'mov', chr(9), 'R', x.r, ', #(',hexword(y.a), ' + roffs)');
		End;}
	      Else Mark('y.mode?');
	    End;
	  End; { StoreReg }
	  
	  PROCEDURE StoreArray(Var x, y: g_item);
	  Var fall: Integer; mem: Longint;
	  Begin
	      Case y.mode Of
		g_reg: If (y.i_type^.form = g_Array) And (y.a <> 0) Then fall := 2
			Else fall := 1;
		g_Const: Begin load(y); fall := 1; End;
		g_Var: If y.lev = 0 Then Begin
			  mem := ramstart + y.a - 2; fall := 3; End
			Else Begin load(y); fall := 1; End;
		g_par, g_Ptr: 
		      If smallproc Then fall := 2
		      Else Begin
			load(y); Fall := 1; End;
		g_SFR: Begin fall := 3; mem := y.a; extp31; End;
		Else Mark('y.mode?');
	      End;
	      If fall = 1 Then begin
		Writeln(Taus,chr(9), 'mov', chr(9), '[R', x.r, '], R', y.r);
		addi($B800 + y.r*16 + x.r); End
	      Else If fall = 2 Then Begin
		writeln(Taus,chr(9), 'mov', chr(9), '[R', x.r, '], [R', y.r, ']');
		addi($C800 + x.r*16 + y.r); End
	      Else Begin
		If mem = ramstart then Begin { _FRESULT? }
		  Writeln(Taus,chr(9), 'mov', chr(9), '[R', x.r, '], ', HexWord(mem));
		  addi($8400 + x.r); addv(mem Mod $10000); End
		Else Begin
		  Writeln(Taus,chr(9), 'mov', chr(9), '[R', x.r, '], (', HexWord(mem), ' + roffs)');
		  addi($8400 + x.r); Addramlink; addv(mem Mod $10000); End; End;
	  End; { StoreArray }
	  
	  PROCEDURE StoreVar(Var x, y: g_item); { TODO: komplett kontrollieren! }
	  Var reg: Integer; r1: Longint;
	  Begin load(y); 
	      If (y.mode = g_SFR) Then Begin
		GetReg(reg); y.r := reg;
		extp31;
		Writeln(Taus, chr(9), 'mov', chr(9) ,'R', y.r, ', ', HexWord(y.a));
		addi($F2F0 + y.r); addv(y.a); End;
	      IF (y.i_type^.form = g_Array) And (y.a <> 0) THEN Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		addi($A800 + y.r*16 + y.r); End;
	      //If y.mode = g_const Then load(y);
	      If x.lev = 0 Then Begin
		r1 := (ramstart + x.a - 2);
		If r1 = ramstart Then Begin { _FRESULT? } 
		  Write(Taus, chr(9), 'mov', chr(9),  hexword(r1));
		  Writeln(Taus, ', R', y.r);
		  addi($F6F0 + y.r); addv(r1 Mod $10000); End
		Else Begin
		  Write(Taus, chr(9), 'mov', chr(9), '(', hexword(r1), ' + roffs)');
		  Writeln(Taus, ', R', y.r);
		  addi($F6F0 + y.r); Addramlink; addv(r1 Mod $10000); End;
	      End
	      Else Begin
		Write(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', x.a, ']');
		Writeln(Taus, ', R', y.r);
		addi($C400 + y.r*16 + FSP); addv(x.a);
	      End;
	  End; { StoreVar }
	  
	  PROCEDURE StorePar(Var x, y: g_item);
	  Var reg: Integer;
	  Begin load(y);
	      If (y.mode = g_SFR) Then Begin
		GetReg(reg); y.r := reg;
		extp31;
		Writeln(Taus, chr(9), 'mov', chr(9) ,'R', y.r, ', ', HexWord(y.a));
		addi($F2F0 + y.r); addv(y.a); End;
	      IF (y.i_type^.form = g_Array) And (y.a <> 0) THEN Begin
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		addi($A800 + y.r*16 + y.r); End;
	      IF x.r = FSP THEN BEGIN { sonst hat das field bzw. index schon erledigt }
		getreg(reg); x.r := reg;
		Writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', [R', FSP, '+#', x.a, ']');
		addi($D400 + reg*16 + FSP); addv(x.a);
	      END;
	      Writeln(Taus,chr(9), 'mov', chr(9), '[R', x.r, '], R', y.r);
	      addi($B800 + y.r*16 + x.r);
	      If x.r <= lastreg Then RetReg(x);
	  End; { StorPar }
	  
	  PROCEDURE StoreSFR(Var x, y: g_item);
	  Var reg: Integer;
	  Begin
	    Case y.mode OF
	      g_Const: Begin
		  extr1(x.a);
		  Writeln(Taus, chr(9), 'mov', chr(9), HexWord(x.a), ', #', y.a);
		  addi($E600 + x.b); addv(y.a); End;
	      g_Reg: Begin
		  IF (y.i_type^.form = g_Array) And (y.a <> 0) THEN Begin
		    Writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', y.r, ']');
		    addi($A800 + y.r*16 + y.r); End;
		  extp31;
		  Writeln(Taus, chr(9), 'mov', chr(9), HexWord(x.a), ', R', y.r);
		  addi($F6F0 + y.r); addv(x.a); End;
	      g_SFR: Begin
		If x.a <> y.a Then Begin
		  extpr31(y.a);
		  Writeln(Taus, chr(9), 'mov', chr(9), Hexword(x.a), ', ', Hexword(y.a));
		  addi($F600 + y.b); addv(x.a);
		End; End;
	      Else Begin
		  If ((y.mode = g_Par) Or (y.mode = g_Ptr)) And (smallproc) Then Begin
		    extp31;
		    Writeln(Taus, chr(9), 'mov', chr(9), HexWord(x.a), ', [R', y.r, ']');
		    addi($9400 + y.r); addv(x.a); End
		  Else Begin 
		    load(y); extp31;
		    Writeln(Taus, chr(9), 'mov', chr(9), HexWord(x.a), ', R', y.r);
		    addi($F6F0 + y.r); addv(x.a); End
		End;
	    End;
	  End; {StoreSFR }
	  
	  { Fuer _FRESULT := ADR(x); x ... g_PAR }
	  PROCEDURE StoreADR(Var x, y: g_item);
	  Var reg: Integer; r1: LongInt;
	  Begin
	    If x.lev = 0 Then Begin
	      If y.mode = g_Par Then Begin
		If Not smallproc Then Begin
		  getreg(reg); y.r := reg;
		  writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', [R', FSP, '+#', y.a, ']');
		  addi($D400 + y.r*16 + FSP); addv(y.a); End;
		r1 := ramstart + x.a - 2; 
		Writeln(Taus, chr(9), 'mov', chr(9),  hexword(r1), ', R', y.r); 
		addi($F6F0 + y.r); addv(r1 Mod $10000);
	      End
	      Else Mark('not variable parameter!');
	    End
	    Else Mark('var not global!');
	  End; { StoreADR }
	  
	  BEGIN { store x := y;}
	    If x.i_type^.form = g_Pointer Then Begin StorePointer(x, y); exit; End;
	    IF (x.i_type^.form IN [g_Array, g_Record]) And (x.b <> 1) THEN Begin
	      MemCopy(x,y); Exit End;
	    z := x.i_type;
	    While z^.form In [G_Array, g_Record] Do
	      z := z^.base;
	    q := y.i_type;
	    While q^.form In [g_Array, g_Record, g_Tablef] Do
	      q := q^.base;
	    //writeln(z^.form, ', ', q^.form,' ; ', x.mode, ', ', y.mode);
	    IF ((z^.form < g_SFRF) Or (z^.form = g_Stringf)) AND ((q^.form < g_SFRF) OR (q^.form = g_Stringf))
	    AND (z^.form = q^.form) THEN BEGIN
	      If y.mode = g_Const Then y.lev := 0;
	      If ((x.lev = 0) Or (x.lev = curlev)) And ((y.lev = 0) Or (y.lev = curlev)) Then Begin
		Case x.mode Of
		  g_Reg: 
		    If x.i_type^.form = g_Array Then
		      StoreArray(x,y)
		    Else StoreReg(x, y);
		  g_Var: If (z^.form = g_stringf) And (q^.form = g_stringf) Then
			   StoreAdr(x, y)
			 Else StoreVar(x, y);
		  g_Par, g_Ptr: StorePar(x, y);
		  g_SFR: If q^.form = g_Word Then StoreSFR(x,y)
			Else Mark('incompatible types!');
		  {Else Begin 
			If (z^.form = g_stringf) And (q^.form = g_stringf) Then
			  StoreAdr(x, y)
			Else Mark('incompatible assignement'); 
		    End;}
		   Else Mark('incompatible assignement'); 
		End; 
		If y.r <= Lastreg Then RetReg(y); 
		If x.r <= Lastreg Then RetReg(x); 
	      End
	      Else Mark('level');
	    End
	    Else BEGIN
	      Mark('incompatible assignement');
	      //writeln(z^.form, ', ', q^.form,' ; ', x.mode, ', ', y.mode);
	    End;
	  END {Store};
	  
	PROCEDURE StoreLv(VAR x: g_Item); {write back controllvariable after FOR}
	BEGIN 
	  IF oplevel > 0 THEN
	    IF x.lev = 0 THEN BEGIN
	      x.a := x.a - 2;  
	      If x.a = 0 Then Begin
		writeln(Taus, chr(9), 'mov', chr(9), hexword(ramstart + x.a), ', R', x.r);
		addi($F6F0 + x.r); addv((ramstart + x.a ) Mod $10000); End
	      Else Begin
		writeln(Taus, chr(9), 'mov', chr(9), '(',hexword(ramstart + x.a), ' + roffs), R', x.r);
		addi($F6F0 + x.r); Addramlink; addv((ramstart + x.a ) Mod $10000); End;
	      retreg(x);
	    END
	    ELSE 
	      IF (NOT smallproc) AND (NOT IsInt) THEN BEGIN
	        writeln(Taus, chr(9), 'mov', chr(9),'[R', FSP, '+#', x.a, '], R', x.r);
	        addi($C400 + x.r*16 + FSP); addv(x.a);
	        retreg(x);
	      END;
	END {StorLv};
	
	PROCEDURE g_Parameter(VAR x: g_Item; ftyp: g_Type; class: INTEGER; sc: BOOLEAN);
	  VAR r1, r2: LONGINT; s: String; w: Word;
	BEGIN
	  IF (class = g_Par) AND (ftyp^.form IN [g_Array, g_Record]) THEN
	  { Nur die Basisadresse uebergeben: }
	    IF x.i_type^.form = ftyp^.form THEN BEGIN
	      IF smallproc THEN BEGin
		r1 := 15 - ParCount;
		IF x.lev = 0 THEN Begin 
		  w := (ramstart + x.a - 2 - x.i_type^.size) Mod $10000;
		  write(Taus, chr(9), 'mov', chr(9), 'R', r1, ', ','#(');
		  Writeln(Taus, hexword(w), ' + roffs)');
		  addi($E6F0 + r1); addv(w); End
		ELSE IF x.lev = curlev THEN
		  IF sc THEN BEGIN
		    IF DPP[3] <> 3 THEN Begin
			writeln(Taus, chr(9), 'extp', chr(9), '#3, #1');
			addi($D740); addv(0003); End;
		    writeln(Taus, chr(9), 'mov',chr(9), 'R2, ', Hexword(CPadr));
		    addi($F2F2); addv(CPadr); 
		    writeln(Taus, chr(9), 'sub', chr(9), 'R2, #', x.a);
		    If x.a < 8 Then
		      addi($2800 + 2*16 + x.a)
		    Else Begin
		      addi($26F2); addv(x.a); End;
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R2]');
		    addi($A800 + 16*r1 + 2);
		  END
		  ELSE BEGIN 
		  { Da smallproc = TRUE ist patzt hier MakeItem. Es muss daher aus
		    der uebergebenen Registernummer wieder der Offset zu FSP
		    berechnet werden: }
		    r2 := 2 * (16 - x.r) - 2 - x.i_type^.size;
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', R', FSP);
		    addi($F000 + r1*16 + FSP);
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', r1, '+#', x.a - 2, ']');
		    addi($D400 + r1*16 + r1); addv(x.a - 2);
		  END
		ELSE Mark('level!');
	      END
	      ELSE BEGIN { lange Prozedur }    
		r1 := ParCount * 2;
		IF x.lev = 0 THEN BEGIN
		  r2 := (ramstart + x.a - 2- x.i_type^.size) Mod $10000;
		  writeln(Taus, chr(9), 'mov', chr(9), 'R2, ', '#(', hexword(r2), ' + roffs)');
		  If r2 < 16 Then 
		    addi($E000 + r2+16 + 2)
		  Else Begin
		    addi($E6F2); addv(r2);
		  End;
		END
		ELSE IF x.lev = curlev THEN
		  IF sc THEN BEGIN
		    extp31;
		    writeln(Taus, chr(9), 'mov',chr(9), 'R2, ', HexWord(CPadr));
		    addi($F2F2); addv(CPadr); 
		    w := 2 * x.a + 2;
		    writeln(Taus, chr(9), 'sub', chr(9), 'R2, #', w);
		    If x.a < 8 Then
		      addi($2800 + 2*16 + w)
		    Else Begin
		      addi($26F2); addv(w); 
		    End;
		    writeln(Taus, chr(9), 'mov',chr(9), 'R2, [R2]');
		    addi($A822);
		  END
		  ELSE BEGIN
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, R', FP);
		    addi($F020 + FP);
		    IF x.a <> 0 THEN Begin
		      writeln(Taus, chr(9), 'add', chr(9), 'R2, #', x.a);
		      If x.a < 8 Then
			addi($0820 + x.a)
		      Else Begin
			addi($06F2); addv(x.a); 
		      End;
		    End;
		    writeln(Taus, chr(9), 'mov',chr(9), 'R2, [R2]');
		    addi($A822);
		  END
		ELSE Mark('level!');
		writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		addi($C400 + 2*16 + FSP); addv(r1);
	      END {lange Prozedur }
	  END 
	  ELSE Mark('parametertype?')
	ELSE { kein strukt. variabler Parameter }
	  IF ((x.i_type^.form IN [g_Array, g_Record]) AND (x.i_type^.base^.form  = ftyp^.form))
	    OR (x.i_type = ftyp ) THEN BEGIN 
	    IF smallproc THEN BEGIN
	      r1 := 15 - ParCount;
	      IF x.mode = g_String THEN BEGIN
		str(x.a, s);
		writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', #String', modname, s);
		addi($E6F0 + r1);
		Addstringref(x.a); addv(0);
	      END
	      ELSE IF x.mode = g_Const THEN Begin
	        writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', #', hexword(x.a));
	        If x.a < 16 Then addi($E000 + x.a*16 + r1)
	        Else Begin
		  addi($E6F0 + r1); addv(x.a); End; End
	      ELSE IF x.lev = 0 THEN BEGIN
	       r2 := ramstart + x.a - 2;  
	       write(Taus, chr(9), 'mov', chr(9), 'R', r1, ', ');
	       If x.mode = g_Ptr Then Begin
		  If class = g_par Then Begin
		    Writeln(Taus, 'R', x.r);
		    addi($F000 + r1*16 + x.r);
		  End  
		  Else Begin
		    Writeln(Taus, '[R', x.r, ']'); 
		    addi($A800 + r1*16 + x.r);
		  End;
	        End
	        Else IF class = g_Par THEN Begin
		  If r2 = ramstart Then Begin {_FRESULT? }
		    writeln(Taus, '#', hexword(r2 Mod $10000));
		    addi($E6F0 + r1); addv(r2 Mod $10000); End
		  Else Begin
		    writeln(Taus, '#(', hexword(r2 Mod $10000), ' + roffs)');
		    addi($E6F0 + r1); Addramlink; addv(r2 Mod $10000); End; End
	        ELSE IF class = g_Var THEN Begin
		  If r2 = ramstart Then Begin {_FRESULT? }
		    writeln(Taus, hexword(r2));
		    addi($F2F0 + r1); addv(r2 Mod $10000); End
		  Else Begin
		    writeln(Taus, '(', hexword(r2), ' + roffs)');
		    addi($F2F0 + r1); Addramlink; addv(r2 Mod $10000); End; End
	        ELSE Mark('parametertype?');
	      END
	      ELSE IF sc THEN BEGIN
		//IF (x.mode = g_Var) OR (x.mode = g_Reg) Then Begin
		If x.mode In [g_Var, g_Reg, g_Ptr] Then Begin
		  IF  Not CPinR2 Then Begin 
		    writeln(Taus, chr(9), 'mov',chr(9), 'R2, ', HexWord(CPadr));
		    extp31; addi($F2F2); addv(CPadr); 
		    //writeln(Taus, chr(9), 'mov',chr(9), 'R2, CP');
		    writeln(Taus, chr(9), 'sub', chr(9), 'R2, #', 32); 
		    addi($26F2); addv(32); 
		    CPinR2 := True; End;
		  IF class = g_Par THEN Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', R2 ');
		    addi($F000 + r1*16 + 2);
		    writeln(Taus, chr(9), 'add', chr(9), 'R', r1, ', #', 32 - x.a);
		    If (32 - x.a) < 8 Then addi($0800 + r1*16 +(32-x.a))
		    Else Begin
		      addi($06F0 + r1); addv(32 - x.a);
		    End;
		    If (x.mode = g_Ptr) Then Begin
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', r1,']');
		      addi($A800 + r1*16 + r1);
		      Writeln(Taus, chr(9), 'add', chr(9), 'R', r1, ', #', x.b);
		      If x.b < 8 Then addi($0800 + r1*16 + x.b)
		      Else Begin
			addi($06F0 + r1); addv(x.b);
		      End;
		    End;
		  End
		  ELSE Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R2+#', 32 - x.a, ']');
		    addi($D400 + r1*16 + 2); addv(32 - x.a);
		    If (x.mode = g_Ptr) Then Begin
		      Writeln(Taus, chr(9), 'add', chr(9), 'R', r1, ', #', x.b);
		      If x.b < 8 Then addi($0800 + r1*16 + x.b)
		      Else Begin
			addi($06F0 + r1); addv(x.b);
		      End;
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', r1,']');
		      addi($A800 + r1*16 + r1);
		    End;
		  End;
		END
		ELSE Mark('parametertype?');
	      END { smallcall }
	      ELSE BEGIN
	      { Da smallproc = TRUE ist patzt hier MakeItem. Es muss daher aus
	        der uebergebenen Registernummer wieder der Offset zu FSP
	        berechnet werden: }
		r2 := 2 * (16 - x.r) - 2;
		//IF (x.mode = g_Var) OR (x.mode = g_Reg) THEN BEGIN
		If x.mode In [g_Var, g_Reg, g_Ptr] Then Begin
		  IF class = g_Par THEN BEGIN
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, [R', FSP, '+#', r2, ']');
		    addi($D420 + FSP); addv(r2);
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', R2'); 
		    addi($F000 + r1*16 + 2);
		    If (x.mode = g_Ptr) Then Begin
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', r1,']');
		      addi($A800 + r1*16 + r1);
		      Writeln(Taus, chr(9), 'add', chr(9), 'R', r1, ', #', x.b);
		      If x.b < 8 Then addi($0800 + r1*16 + x.b)
		      Else Begin
			addi($06F0 + r1); addv(x.b);
		      End;
		    End;
		  END 
		  ELSE Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', FSP, '+#', r2, ']');
		    addi($D400 + r1*16 + FSP); addv(r2);
		    If (x.mode = g_Ptr) Then Begin
		      Writeln(Taus, chr(9), 'add', chr(9), 'R', r1, ', #', x.b);
		      If x.b < 8 Then addi($0800 + r1*16 + x.b)
		      Else Begin
			addi($06F0 + r1); addv(x.b);
		      End;
		      Writeln(Taus, chr(9), 'mov', chr(9), 'R', r1, ', [R', r1,']');
		      addi($A800 + r1*16 + r1);
		    End;
		  End;
		END
		ELSE Mark('parametertype?');
	      END; { smallcall oder nicht }
	    END { smallproc }
	    ELSE BEGIN { lange Prozedur }
	      r1 := ParCount * 2;
	      IF x.mode = g_String THEN BEGIN
		str(x.a, s);
		writeln(Taus, chr(9), 'mov', chr(9), 'R2, #String', modname, s);
		addi($E6F2);
		Addstringref(x.a); addv(0);
		writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		addi($C400 + 2*16 + FSP); addv(r1);
	      END
	      ELSE IF x.mode = g_Const THEN BEGIN
		writeln(Taus, chr(9), 'mov', chr(9), 'R2, #', hexword(x.a));
		If x.a < 16 Then addi($E000 + x.a*16 + 2)
		Else Begin
		  addi($E6F2); addv(x.a);
		End;
		writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		addi($C400 + 2*16 + FSP); addv(r1);
	      END
	      ELSE IF x.lev = 0 THEN BEGIN
		If x.mode = g_Ptr Then Begin
		  Writeln(Taus,chr(9), 'mov', chr(9), 'R2, [R', x.r, ']'); 
		  addi($A800 + 2*16 + r1);
		End
		Else Begin
		  write(Taus, chr(9), 'mov', chr(9), 'R2, ');
		  r2 := ramstart + x.a - 2;
		  IF class = g_Par THEN Begin
		    If r2 = ramstart Then Begin { _FRESULT? }
		      writeln(Taus, '#', hexword(r2 Mod $10000));
		      addi($E6F2); addv(r2 Mod $10000); End
		    Else Begin
		      writeln(Taus, '#(', hexword(r2 Mod $10000), ' +roffs)');
		      addi($E6F2); Addramlink; addv(r2 Mod $10000); End;
		  End
		  ELSE IF class = g_Var THEN Begin
		    If r2 = ramstart Then Begin { _FRESULT? }
		      writeln(Taus, hexword(r2));
		      addi($F2F2); addv(r2 Mod $10000); End
		    Else Begin
		      writeln(Taus, '(', hexword(r2), ' + roffs)');
		      addi($F2F2); Addramlink; addv(r2 Mod $10000); End;
		  End
		  ELSE Mark('parametertype?');
		End;
		writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		addi($C400 + 2*16 + FSP); addv(r2 Mod $10000);
	      END
	      ELSE IF sc THEN BEGIN
		If x.mode In [g_Var, g_Reg, g_Ptr] Then Begin
		  writeln(Taus, chr(9), 'mov',chr(9), 'R2, ', HexWord(CPadr));
		  extp31; addi($F2F2); addv(CPadr);
		  //writeln(Taus, chr(9), 'mov',chr(9), 'R2, CP');
		  writeln(Taus, chr(9), 'sub', chr(9), 'R2, #', 2 * x.a + 2);// + 2??? wg. MakeItem
		  If (2*x.a + 2) < 8 Then
		    addi($2800 + 2*16 +2*x.a +2)
		  Else Begin
		    addi($26F2); addv( 2*x.a + 2);
		  End;
		  If x.mode = g_Ptr Then Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, [R2]');
		    addi($A800 + 2*16 + 2);
		    Writeln(Taus, chr(9), 'add', chr(9), 'R2, #', x.b);
		    If x.b < 8 Then
		      addi($080 + 2 *16 + x.b)
		    Else Begin
		      addi($06F2); addv(x.b);
		    End;
		  End;
		  IF class <> g_par THEN Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, [R2]');
		    addi($A800 + 2*16 + 2);
		  End;
		  writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		  addi($C400 + 2*16 + FSP); addv(r2 Mod $10000);
		END
		ELSE Mark('parametertype?');
	      END { smallcall }
	      ELSE BEGIN
		If x.mode In [g_Var, g_Reg, g_Ptr] Then Begin
		  writeln(Taus, chr(9), 'mov', chr(9), 'R2, R', FP);
		  addi($F000 + 2*16 + FP);
		  IF x.a <> 0 THEN Begin
		    writeln(Taus, chr(9), 'add', chr(9), 'R2, #', x.a);
		    If x.a < 8 Then
		      addi($080 + 2 *16 + x.a)
		    Else Begin
		      addi($06F2); addv(x.a);
		    End;
		  End;
		  If x.mode = g_Ptr Then Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, [R2]');
		    addi($A800 + 2*16 + 2);
		    Writeln(Taus, chr(9), 'add', chr(9), 'R2, #', x.b);
		    If x.b < 8 Then
		      addi($080 + 2 *16 + x.b)
		    Else Begin
		      addi($06F2); addv(x.b);
		    End;
		  End;
		  IF class <> g_par THEN Begin
		    writeln(Taus, chr(9), 'mov', chr(9), 'R2, [R2]');
		    addi($A800 + 2*16 + 2);
		  End;
		  writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', r1, '], R2');
		  addi($C400 + 2*16 + FSP); addv(r2 Mod $10000);
		END
		ELSE Mark('parametertype?');
	      END;
	    END;
	  END
	  ELSE Mark('bad parameter type');
	END {g_Parameter};


	PROCEDURE g_OpenProc(blksize: INTEGER; small: BOOLEAN);
	  VAR i: INTEGER; 
	BEGIN 
	  FOR i := 1 TO 15 DO BEGIN 
	    Regs[i] := -1; RegUsed[i] := 0; END;
	  writeln(Taus, chr(9), 'push', chr(9), 'R', FSP);
	  addi($ECF0 + FSP);
	  writeln(Taus, chr(9), 'add', chr(9), hexword(CPadr), ', #32');
	  addi($0600 + CPreg); addv(32);
	  writeln(Taus, chr(9), 'nop');
	  addi($CC00);
	  writeln(Taus, chr(9), 'pop', chr(9), 'R', FSP);
	  addi($FCF0 + FSP);
	  IF NOT small THEN BEGIN
	    writeln(Taus, chr(9), 'mov', chr(9), 'R', FP, ', R', FSP);
	    addi($F000 + FP*16 + FSP);
	    writeln(Taus, chr(9), 'sub', chr(9), 'R', FSP, ', #', blksize );
	    If blksize < 8 Then addi($2800 + FSP*16 + blksize)
	    Else Begin
	      addi($26F0 + FSP); addv(blksize); End;
	  END;
	  If DebugLevel > 1 Then CheckStack	 
	END;
	
	PROCEDURE Call(VAR x: g_Object);
	  BEGIN writeln(Taus, chr(9), 'calla', chr(9), modname + x^.name);
		addi($Ca00); Addromlink; addv(x^.adr);
	  END {Call};
	
	PROCEDURE Return(s: string; int: BOOLEAN);
	VAR i: INTEGER;
	  BEGIN 
	    FOR i := 1 TO 15 DO BEGIN
	      //IF RegUsed[i] <> 0 THEN Writeln('RegUsed[', i, '] = ', RegUsed[i]);
	      Regs[i] := -1; RegUsed[i] := 0; END;
	    //writeln(Taus, ';', chr(9), 'sub', chr(9), 'CP, #32');
	    writeln(Taus, chr(9), 'sub', chr(9), HexWord(CPadr), ', #32');
	    addi($2600 + CPreg); addv(32); 
	    IF int THEN Begin
	      writeln(Taus, chr(9), 'reti', chr(9), chr(9), chr(9), chr(9), '; ', s);
	      addi($FB88); End
	    ELSE Begin
	      writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), chr(9), '; ', s);
	      addi($CB00); End;
	    Put_Strings; Put_Tables;
	  END {Return};


	PROCEDURE DoSpecials(tval: INTEGER); { Fuer den Bootstraploader }
	  VAR lab: Integer;
	Begin
	  Case tval Of
	    21: Begin
		  Writeln(Taus, chr(9), 'einit');
		  addi($B54A); addv($B5B5);
		End;
	    22: Begin
		  Writeln(Taus, chr(9), 'srst');
		  addi($B748); addv($B7B7);
		  
		End;
	    23: Begin lab := Getlabel;
		  Write(Taus, chr(9), 'jmps', chr(9));
		  Setlabel(lab, 'dummi jump');
		  NewLabel(lab, '');
		  addi($FA00 + aseg); addv(cap + 2);
		End;
	    26: Begin
		  Writeln(Taus, chr(9), 'nop');
		  addi($CC00);
		End;
	    27: Begin { JMP0}
		  Writeln(Taus, chr(9), 'jmps', chr(9), '0, 0');
		  addi($FA00); addv(0);
		End;
	    29: Begin { DISWDT }
		  Writeln(Taus, chr(9), 'diswdt');
		  addi($A55A); addi($A5A5);
		End;
	    30: Begin { SRVWDT }
		  Writeln(Taus, chr(9), 'srvwdt');
		  addi($A758); addi($A7A7);
		End;
	    End;
	End { DoSpecials };
	
	PROCEDURE Put_Read;
	  VAR lab: Longint; AscFlag: String; p:Tsfrreg;
	      s: Word;
	BEGIN Str(AscPort, AscFlag); 
	  AscFlag := 'S' + AscFlag + 'RIC';
	  p := Fsfr(AscFlag); AscFlag := HexWord(p.adr) + '.7';
	  lab := GetLabel; Newlabel(lab, ''); s := cap;
	  write(Taus, chr(9), 'jnb', chr(9), AscFlag, ', ');
	  addi($9A00 + p.reg); addv($7000 + rbj(s));
	  setlabel(lab, '');
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + p.reg);
	END;

	PROCEDURE IOCall(VAR x, y: g_Item);
	  VAR nr: INTEGER;  adr: LONGINT; AscReg:String; p:Tsfrreg;
	      AscRegv: Byte; ascAdrv: Word; reg, lreg: Integer;
	  BEGIN Str(AscPort, AscReg); 
	    AscReg := 'S' + AscReg + 'RBUF';
	    p := Fsfr(Ascreg); AscReg := HexWord(p.adr); 
	    AscRegv := p.reg; AscAdrv := p.adr;
	    IF x.a = 4 THEN BEGIN { WriteLn; }
	        Put_writeln; 
	    END
	    ELSE IF x.a = 1 THEN BEGIN { Read }
	      IF y.i_type^.form > 2 THEN
	        MARK('bad readparameter!');
	      Put_Read; 
	      IF (y.mode = g_Var) OR (y.mode = g_Par) OR (y.mode = g_Reg) THEN BEGIN
	        IF y.lev = 0 THEN BEGIN
	          adr := Ramstart + y.a - 2;
	          writeln(Taus, chr(9), 'mov', chr(9), hexword(adr), ', ', AscReg);
	          addi($F600 + AscRegv); addv(adr Mod $10000);
	        END
	        ELSE IF y.lev = curlev THEN BEGIN
	          IF smallproc THEN BEGIN
	            IF (y.mode = g_Var) OR (y.mode = g_Reg) THEN BEGIN
	              extp31;
		      writeln(Taus, chr(9), 'mov', chr(9), 'R', y.r, ', ', AscReg); 
		      addi($F2F0 + y.r);  addv(AscAdrv);
		    END
	            ELSE BEGIN
		      { das geht nicht! da muss wohl ein Register her }
		      getreg(reg);
	              extp31;
		      writeln(Taus, chr(9), 'mov', chr(9), 'R', reg, ', ', AscReg); 
		      addi($F2F0 + reg); addv(AscAdrv);
	              writeln(Taus, chr(9), 'mov', chr(9), '[R', y.r, '], R', reg);
	              addi($B800 + (reg* 16) + y.r);
	              lreg := y.r; y.r := reg; retreg(y); y.r := lreg;
	            END;
	          END
	          ELSE BEGIN { lange Prozedur }
	            IF y.mode = g_Var THEN BEGIN
	              Getreg(nr); 
	              extp31;
	              writeln(Taus, chr(9), 'mov', chr(9), 'R', nr, ', ', AscReg);
	              addi($F2F0 + nr); addv(AscAdrv);
	              writeln(Taus, chr(9), 'mov', chr(9), '[R', FSP, '+#', y.a, '], R', nr);
	              addi($C400 + nr*16 + FSP); addv(y.a);
	            END
	            ELSE BEGIN
	              Getreg(nr);
	              writeln(Taus, chr(9), 'mov', chr(9), 'R', nr, ', [R', FSP,'+#', y.a, ']');
	              addi($D400 + nr*16 + FSP); addv(y.a);
	              extp31;
	              writeln(Taus, chr(9), 'mov', chr(9), '[R', nr, '], ', AscReg);
	              addi($8400 + nr); addv(AscAdrv);
	            END;
	            y.r := nr; RetReg(y);
	          END;
	        END
	        ELSE Mark ('level?');
	      END
	      ELSE Mark('read where to?');
	    END
	    ELSE IF x.a = 5 THEN Begin { Sleep }
	      writeln(Taus, chr(9), 'idle');
	      addi($8778); addv($8787);End
	    ELSE writeln('IOCall, ', y.tok);
	  END {IOCall};
	  
	  PROCEDURE OpenWrite;
	  BEGIN
	    If Not impmod Then Begin
	      write_used := TRUE;
	      Start_Sproc; 
	      IF DebugLevel > 1 Then CheckStack; End
	    Else Mark('no write in importable moduls!');
	  END; {OpenWrite}
	  
	  PROCEDURE PutWrite(x: g_Item; form: Integer);
	  VAR adr, v: Longint; iform, lab: LongInt; dif, tmp: Word;
	  BEGIN //Writeln(x.lev, ', ', x.i_Type^.form, ', ', x.mode);
	    IF x.mode = g_String THEN Begin
	      Write_String(x.a); End
	    ELSE BEGIN
	        IF x.mode = g_Const THEN Begin
	          writeln(Taus, chr(9), 'mov', chr(9), 'R1, #', x.a);
	          If x.a < 6 Then addi($E000 + x.a*16 + 1)
	          Else Begin 
		    addi($E6F1); addv(x.a); End;
	          End
	        ELSE BEGIN 
	          IF x.lev = 0 THEN BEGIN
		    If x.mode = g_Var Then Begin
		      adr := Ramstart + x.a - 2;
		      If adr = ramstart Then Begin { _FRESULT? }
			writeln(Taus, chr(9), 'mov', chr(9), 'R1, ', hexword(adr));
			addi($F2F1); addv(adr Mod $10000); End
		      Else Begin
			writeln(Taus, chr(9), 'mov', chr(9), 'R1, (', hexword(adr), ' + roffs)');
		      addi($F2F1); Addramlink; addv(adr Mod $10000); End;
		    End
		    Else If x.mode = g_Ptr Then Begin
		      {If x.r <> 1 Then Begin
			Writeln(Taus, chr(9), 'mov', chr(9), 'R1, R', x.r);
			Inc(cl, 2); End;
		      }
		      writeln(Taus, chr(9), 'mov', chr(9), 'R1, [R',x.r, ']');
		      addi($A810 + x.r);
		      Retreg(x);
		    End;
	          END 
	          ELSE BEGIN 
	            IF (smallproc) THEN BEGIN 
		      extp31;
		      writeln(Taus, chr(9), 'mov', chr(9), 'R1,', HexWord(CPadr));
		      addi($F2F1); addv(CPadr);
	              v := 32 - 2 * x.r;
	              writeln(Taus, chr(9), 'sub', chr(9), 'R1, #', v);
	              If v < 8 Then addi($2810 + v)
	              Else Begin
			addi($26F1); addv(v); End;
		      writeln(Taus, chr(9), 'mov', chr(9), 'R1, [R1]');
		      addi($A811);
	            End
	            ELSE BEGIN 
	              { Das wird durch pop R0 erledigt? Aber nur fuer den 1. Parameter!}
	              extp31;
	              writeln(Taus, chr(9), 'mov', chr(9), 'R0, ', HexWord(CPadr));
	              addi($F2F0); addv(CPadr);
	              writeln(Taus, chr(9), 'sub', chr(9), 'R0, #32');
	              addi($26F0); addv(32);
	              writeln(Taus, chr(9), 'mov', chr(9), 'R0, [R0]');
	              addi($A800);
	              If x.a <> 0 Then Begin
			writeln(Taus, chr(9), 'add', chr(9), 'R0, #', x.a);
			If x.a < 8 Then addi($0800 + x.a)
			Else Begin
			  addi($06F0); addv(x.a);
			End;
		      End;
		      writeln(Taus, chr(9), 'mov', chr(9), 'R1, [R0]');
		      addi($A810);
	            END; 
	            IF (x.mode = g_Par) Or (x.mode = g_Ptr) THEN Begin
	              writeln(Taus, chr(9), 'mov', chr(9), 'R1, [R1]');
	              addi($A811);
	            End;
	          END;
	        END;
	        {IF x.mode = g_Ptr Then Begin
		 Writeln(Taus, chr(9), 'mov', chr(9), 'R', x.r, ', [R', x.r, ']');
		  INC(cl, 2);
		End;}
	        IF form = 0 THEN Begin
		  If x.i_type^.form = g_Array then 
		    iform := x.i_type^.base^.form
		  Else iform := x.i_type^.form;
		  If iform = g_Integer Then Begin
		    lab := GetLabel;
		    write(Taus, chr(9), 'jnb', chr(9), 'R1.15, ');
		    addi($9AF1); dif := cap; addv($F000);
		    SetLabel(lab, 'positiv');
		    writeln(Taus, chr(9), 'cpl', chr(9), 'R1');
		    addi($9110);
		    writeln(Taus, chr(9), 'add', chr(9), 'R1, #1');
		    addi($0811);
		    writeln(Taus, chr(9), 'calla', chr(9), 'writesign');
		    addi($CA00); addv(link.Writesign);
		    NewLabel(lab, '');
		    tmp := (cap - dif - 2) Div 2;
		    code[dif] := tmp;
		  End;
	          writeln(Taus, chr(9), 'calla', chr(9), 'writeval');
	          addi($CA00); addv(link.Writeval);  
	        End
	        ELSE If form = 1 THEN Begin { Hexadezimal }
	          writeln(Taus, chr(9), 'calla', chr(9), 'writehex');
	          addi($CA00); addv(link.WriteHex); End
	        Else Begin { Character }
		  writeln(Taus, chr(9), 'calla', chr(9), 'writechar');
		  addi($CA00); addv(link.Writechar); End;
	      END;
	  END; {PutWrite}
	  
	  PROCEDURE CloseWrite(nl: Boolean);
	  BEGIN
	    IF nl THEN Begin
	      writeln(Taus, chr(9), 'calla', chr(9), 'writeln');
	      addi($CA00); addv(link.Writeln);
	    End;
	    end_Sprocs; 
	  END; {CloseWrite}	
	  
	PROCEDURE Init_Sproc(vsize:LONGINT);
	BEGIN
	  vartop := ramstart + vsize; ramtop := vartop;
	END;
	
	
  
	PROCEDURE Open;
	Var p: Tsfrreg;
	  BEGIN curlev := 0; pc := 0; //relx := 0; cno := 0;
	  If impmod Then Begin
	    p := Fsfr('CP');
	    If p.reg <> -1 Then Begin
	      CPreg := p.reg; CPadr := p.adr; End;
	  End;
	  END {Open};
	  
	  
	PROCEDURE mapram;
	VAR fpage, lpage,i: INTEGER; p: Tsfrreg; s: String;
	
	BEGIN fpage := ramstart DIV $4000; lpage := ramstop DIV $4000;	  
	  WHILE fpage <= lpage DO BEGIN
	    i := fpage MOD 4; DPP[i] := fpage;
	    fpage := fpage + 1;
	  END;
	  FOR i := 0 TO 3 DO Begin
	    str(i, s); s := 'DPP' + s; p := Fsfr(s);
	    writeln(Taus,chr(9), 'mov', chr(9), HexWord(p.adr), ', #', DPP[i], chr(9), ';', s);
	    addi($E600 + p.reg); addv(DPP[i]);
	  End;
	  Write(Taus, chr(9), 'assume ');
	  FOR i := 0 TO 3 DO BEGIN
	    write(Taus, 'DPP', i, ':', DPP[i]);
	    IF i <> 3 THEN write(Taus, ', '); END;
	  Writeln(Taus);	
	END {mapram};
	
	PROCEDURE CallMain1;
	BEGIN
	  If (Progstart = 0) And (Not impmod) Then Begin
	    Writeln(Taus, '; SetHeapTop:');
	    Writeln(Taus, chr(9), 'mov', chr(9), 'R2, #Heapstart');
	    Writeln(Taus, chr(9), 'mov', chr(9), HexWord(HeapTop), ', R2', chr(9), '; Top Of Heap ');
	    addi($E6F2); link.heapstart := cap; addv(0);
	    addi($F6F2); addv(HeapTop);
	  End;  
	  
	  
	END;
	
	PROCEDURE CallMain2;
	Begin
	  writeln(Taus, 'roffs', chr(9), 'SET', chr(9), ramoffset);
	  IF Odd(DebugLevel)  Then BEGIN
	    writeln(Taus, ';@ #MainStart:', modname);
	    writeln(Taus, chr(9), 'jmp', chr(9), 'dbgmonitor'); 
	    END
	  ELSE Begin
	    writeln(Taus, chr(9), 'jmpa', chr(9), modname);
	    addi($EA00); link.Mainstart := cap; Addromlink; addv(0);
	  End;
	  If (UseWrite) And (Not impmod) Then Put_Write;
	End;
	
	PROCEDURE Open_Gen;
	Var p: Tsfrreg;
	
	BEGIN
	  p := Fsfr('CP');
	    If p.reg <> -1 Then Begin
	      CPreg := p.reg; CPadr := p.adr; End;
	  writeln(Taus, chr(9), 'cpu 80c167');
          IF progstart = 0 THEN BEGIN 
	    cap := $0200;
	    If Not insinit Then Begin
	      writeln(Taus,chr(9),'org',chr(9),'0200h',chr(9),chr(9),'; start at the end of vector-table');
	      writeln(Taus, Vektoren[0].name, ':');
	      IF NOT watchdog then Begin
		writeln(Taus, chr(9),'diswdt',chr(9),chr(9), chr(9), '; watchdog off ');
		addi($A55A); addi($A5A5); End;
	      IF waitstates < 15 THEN BEGIN
		waitstates := 15 - waitstates; p := Fsfr('BUSCON0');
		writeln(Taus, '; Set waitstates for BUSCON0:'); 
		writeln(Taus, chr(9), 'or', chr(9), HexWord(p.adr), ', #', waitstates);
		addi($7600 + p.reg); addv(waitstates);
	      END;
	      p := Fsfr('SYSCON');
	      writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.2', chr(9), '; SYSCON: enable XRAM');
	      addi($2F00 + p.reg);
	      writeln(Taus, chr(9), 'or', chr(9), HexWord(p.adr), ', #0E000h', chr(9), '; SYSCON: 1024 Bytes 	Stack');
	      addi($7600 + p.reg); addv($E000);
	      writeln(Taus, chr(9), 'einit', chr(9), chr(9), chr(9), '; end of reset');
	      addi($B54A); addi($B5B5);
	      { some more initialisations? Could be done via prog-parameters. }   
	      p := Fsfr('STKUN');
	      writeln(Taus, chr(9), 'mov', chr(9), HexWord(p.adr), ', #', hexword(stackp), chr(9), '; STKUN');
	      addi($E600 + p.reg); addv(stackp);
	      p := Fsfr('STKOV');
	      writeln(Taus, chr(9), 'mov', chr(9), HexWord(p.adr), ', #', hexword(stackp - stacksize), chr(9), '; STKOV');
	      addi($E600 + p.reg); addv(stackp - stacksize);
	      p := Fsfr('SP');
	      writeln(Taus, chr(9), 'mov', chr(9), HexWord(p.adr), ', #', hexword(stackp), chr(9), '; SP');
	      addi($E600 + p.reg); addv(stackp);
	      writeln(Taus, chr(9), 'mov', chr(9), HexWord(CPadr), ', #', hexword(contextp), chr(9), '; CP');
	      addi($E600 + CPreg); addv(contextp);
	      writeln(Taus, chr(9), 'nop'); addi($CC00);
            End
            Else loadinit; 
            writeln(Taus,chr(9), 'mov',chr(9), 'R', FSP, ', #',hexword(ramstop MOD $10000), chr(9),'; FSP = top of softstack');
            addi($E6F0 + FSP); addv(ramstop Mod $10000);
            IF rammapped THEN mapram;// Else writeln('Not Mapped');
            IF Odd(DebugLevel) Then Begin
	      p := Fsfr('PSW');
	      writeln(Taus, chr(9), 'bset', chr(9), HexWord(p.adr), '.6', chr(9), chr(9), '; USR0: DebugFlag');
	    End;
          END
          ELSE BEGIN
            writeln(Taus, chr(9), 'org', chr(9), hexword(progstart)); 
            writeln(Taus, 'Reset:'); writeln(Taus);
            cap := progstart;
            //writeln(Taus, chr(9), 'jmp', chr(9), modname); 
          END;
	END; { Open_gen }
	
	PROCEDURE WriteVectors;
	  VAR i: INTEGER; p: Tsfrreg; tcap, w: Word;
	BEGIN p := Fsfr('TFR'); tcap := cap; cap := 0;
	  writeln(Taus, chr(9), 'org', chr(9), '0000h');
	  writeln(Taus, chr(9), 'jmpa', chr(9), Vektoren[0].name, chr(9), chr(9), '; Reset');
	  writeln(Taus, chr(9), 'org', chr(9), '0008h');
	  addi($EA00); addv($0200); cap := 8;
	  IF Vektoren[2].used THEN Begin
	    writeln(Taus, chr(9), 'jmpa', chr(9), Vektoren[2].name, chr(9), chr(9), '; NMI');
	    addi($EA00); addv(Vektoren[2].adr);
	  End
	  ELSE BEGIN
	    writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.15', chr(9), '; NMI');
	    writeln(Taus, chr(9), 'reti');
	    w := $FE00 + p.reg; addi(w); addi($FB88);
	  END;
	  writeln(Taus, chr(9), 'org', chr(9), '0010h'); cap := $10;
	  IF Vektoren[4].used THEN Begin
	    writeln(Taus, chr(9), 'jmpa', chr(9), Vektoren[4].name, chr(9), chr(9), '; STKOF');
	    addi($EA00); addv(Vektoren[4].adr);
	  End
	  ELSE BEGIN
	    writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.14', chr(9), '; STKOF');
	    writeln(Taus, chr(9), 'reti');
	    w := $EE00 + p.reg; addi(w); addi($FB88);
	  END;
	  writeln(Taus, chr(9), 'org', chr(9), '0018h'); cap := $18;
	  IF Vektoren[6].used THEN Begin
	    writeln(Taus, chr(9), 'jmpa', chr(9), Vektoren[6].name, chr(9), chr(9), '; STKUF');
	    addi($EA00); addv(Vektoren[6].adr);
	  End
	  ELSE BEGIN
	    writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.13', chr(9), '; STKUF');
	    writeln(Taus, chr(9), 'reti');
	    w := $DE00 + p.reg; addi(w); addi($FB88);
	  END;
	  writeln(Taus, chr(9), 'org', chr(9), '0028h'); cap := $28;
	  IF Vektoren[10].used THEN Begin
	    writeln(Taus, chr(9), 'jmpa', chr(9), Vektoren[10].name, chr(9), chr(9), '; BTRAP');
	    addi($EA00); addv(Vektoren[10].adr);
	  End
	  ELSE BEGIN
	    p := Fsfr('TFR');
	    writeln(Taus, chr(9), 'and', chr(9), HexWord(p.adr), ', #', hexword($FFFF - 143), chr(9), '; TFR');
	    writeln(Taus, chr(9), 'reti');
	    w := $6600 + p.reg; addi(w); addv($FFFF - 143); addi($FB88);
	  END;
	  writeln(Taus, chr(9), 'org', chr(9), '0040h'); cap := $40;
	  FOR i := 16 TO 71 DO BEGIN
	    IF VEKTOREN[i].used THEN BEGIN
	      writeln(Taus, chr(9), 'jmpa', chr(9), vektoren[i].name);
	      writeln(Taus, chr(9), 'org', chr(9), hexword(4 * (i + 1)));
	      addi($EA00); addv(Vektoren[i].adr); cap := 4*(i + 1);
	    END
	    ELSE BEGIN
	      writeln(Taus, chr(9), 'reti', chr(9), chr(9), '; ', Vektoren[i].name);
	      writeln(Taus, chr(9), 'nop');
	      addi($FB88); addi($CC00);
	    END
	  END;
	  If Odd(DebugLevel) Then Begin { Startadresse des Moduls auf $01FE: }
	    writeln(Taus, chr(9), 'org', chr(9), '01FCh');
	    writeln(Taus, chr(9), 'jmps', chr(9), aseg, ', ', modname);
	    cap := $01FC; addi($FA00 + aseg); addv(mainstart);
	  End;
	  cap := tcap; 
	END; { Write_Vectors }
	
	PROCEDURE End_MOD;
	  VAR lab, a: LONGINT; s: string; i: WORD; t: File Of Byte;
	BEGIN
	  IF (progstart = 0) And (Not impmod) THEN BEGIN
	    writeln(Taus); writeln(Taus, '; Endlosschleife:');
            lab := GetLabel; Newlabel(lab, '');
            write(Taus, chr(9), 'jmpr', chr(9)); Setlabel(lab, '');
            addi($0dFF);
          END;        
	  Put_Strings;
	  Put_Tables;    
	  IF Odd(DebugLevel) THEN BEGIN
	    writeln(Taus);
	    writeln(Taus, chr(9), 'include', chr(9), 'monitor.asm');
	    Vektoren[2].name := 'dbgmonitor'; Vektoren[2].used := TRUE; { NMI }
	    Vektoren[10].name := 'dbgmonitor'; Vektoren[10].used := TRUE; { BTRAP }
	    Vektoren[43].name := 'dbgmonitor'; Vektoren[43].used := TRUE; { S0RINT }
	  END;
	  If DebugLevel > 2 Then Begin
	    Vektoren[4].name := 'dbgmonitor'; Vektoren[4].used := TRUE; { STOTRAP }
	  End;
	  If (Progstart = 0) And (Not impmod) Then Begin
	    Writeln(Taus, 'HeapStart', chr(9), 'EQU',chr(9), HexWord((ramtop + 16) MOD $10000));
	    reslink(link.heapstart, ((ramtop + 16) Mod $10000));
	    Writeln(Taus, 'Vartop', chr(9), chr(9), 'EQU',chr(9), HexWord((vartop) Mod $10000));
	    reslink(link.Vartop1, vartop); reslink(link.Vartop2, vartop);
            writeln(Taus); writeln(Taus,'; Vektoren:');
            WriteVectors;
          END;    
	  Writeln('Ramtop: ', HexWord(ramtop));
	  Writeln('Codelength: ', cap - progstart, ' Bytes');
	  str(aseg, s); s := modname + '_' + s + '.bin';
	  Assign(t,s); Rewrite(t);
	  For i := progstart To cap - 1 Do Write(t, code[i]);
	  Close(t);
	END;

	PROCEDURE Enter_VEK(nr: INTEGER; name: STRING);
	BEGIN 
	  Vektoren[nr].name := name;
	  Vektoren[nr].used := FALSE;
	  IF nr <= 6 THEN Vektoren[nr].adr := nr * 4
	  ELSE IF nr = 10 THEN vektoren[nr].adr := 40
	  ELSE IF (nr > 15) AND (nr < 128) THEN
	    Vektoren[nr].adr := 64 + 4 * (nr - 16)
	  ELSE writeln('ungueltiger Vektor');
	  //writeln(nr, ', ', name, ', ', Vektoren[nr].adr);
	END;
	
		
	PROCEDURE InclMod(n: Ident);
	Var f: File Of Byte; b: Byte; i: Integer;
	BEGIN 
	  Writeln(Taus, 'roffs', chr(9), 'set', chr(9), Ramoffset mod $10000);
	  writeln(Taus,chr(9), 'include', chr(9), n + '.asm');
	  n := n + '_0.bin';
	  {$I-} assign(f, n); reset(f); {$I+}
	  i := IOresult;
	  If i = 0 Then Begin
	    While Not eof(f) Do Begin
	      Read(f, b); code[cap] := b; cap := cap + 1;
	    End;
	    Close(f);
	  End
	  Else Mark(n + ' not found');
	END;
	
	PROCEDURE LinkCode(pos: Word; isRam: Boolean);
	Var w: Word; l: LongInt;
	Begin l := code[pos] + (code[pos + 1]*256);
	  If isRam Then 
	    l := l + Ramoffset
	  Else l := l + Modstart;
	  l := l Mod $10000;
	  code[pos] := l Mod 256; code[pos + 1] := l Div 256;
	  cap := pos;
	  If IsRam Then Addramlink Else Addromlink;
	End { LinkCode};
	

initialization

NEW(boolType); boolType^.form := g_Boolean; boolType^.size := 2;
NEW(intType); intType^.form := g_Integer; intType^.size := 2;
NEW(wordType); wordType^.form := g_Word; wordType^.size := 2;
//NEW(sfrType); sfrType^.form := g_Word; sfrType^.size := 2;
NEW(stringType); stringType^.form := g_stringf; stringType^.size := 2;
NEW(ptrType); ptrType^.form := g_Pointer; ptrType^.size := 2;
NextLab := 1; 
Nextreg := 1; 
Lastreg := 15;
maxreg := 0;
ramstart := $0E000; { Start of XRAM, might be overwritten }
ramstop := $0E7FE; { End of XRAM, might be overwritten }
progstart := 0; waitstates := 2;
stackp := $FCE0; contextp := $F600; stacksize := 1024;
watchdog := FALSE; { watchdog disabled, might be changed in Sproc}
oplevel := 0;
smallproc := FALSE;
IsInt := FALSE; 
isproc := FALSE;
forloop := FALSE;
vartop := ramstart; { Top of global variables }
ramtop := vartop; { Top of used Ram abpve glob. vars in Sproc}
//Lequ := NIL;
Listsfr := NIL;
//Listptr := NIL;
DPP[0] := 0; DPP[1] := 1; DPP[2] := 2; DPP[3] := 3;
rammapped := FALSE; impmod := FALSE;
modname := ''; mainname := '';
ramoffset := 0; 
write_used := FALSE;
DebugLevel := 0; AscPort := 0;
CPreg := 0; CPadr := 0;


For vnr := 0 To maxvector Do Begin
  Vektoren[vnr].name := '';
  Vektoren[vnr].used := False; End;
FOR vnr := 1 TO 15 DO BEGIN 
  Regs[vnr] := -1; RegUsed[i] := 0; END;

Enter_Vek(0,'RESET');
Enter_Vek(2, 'NMITRAP');
Enter_Vek(4, 'STOTRAP');
Enter_Vek(6, 'STUTRAP');
Enter_Vek(10, 'BTRAP');
FOR vnr := 16 TO 31 DO BEGIN
  str(vnr - 16, vstr); vstr := 'CC' + vstr + 'INT';
  Enter_Vek(vnr, vstr); END;
Enter_Vek(32, 'T0INT');
Enter_Vek(33, 'T1INT');
FOR vnr := 34 TO 38 DO BEGIN
  str(vnr - 32, vstr); vstr := 'T' + vstr + 'INT';
  Enter_Vek(vnr, vstr); END;
Enter_Vek(39, 'CRINT');
Enter_Vek(40, 'ADCINT');
Enter_Vek(41, 'ADEINT');
Enter_Vek(42, 'S0TINT');
Enter_Vek(43, 'S0RINT');
Enter_Vek(44, 'S0EINT');
Enter_Vek(45, 'SCTINT');
Enter_Vek(46, 'SCRINT');
Enter_Vek(47, 'SCEINT');
FOR vnr := 48 TO 60 DO BEGIN
  str(vnr - 32, vstr); vstr := 'CC' + vstr + 'INT';
  Enter_Vek(vnr, vstr); END;
Enter_Vek(61, 'T7INT');
Enter_Vek(62, 'T8INT');
Enter_Vek(63, 'PWMINT');
FOR vnr := 64 TO 67 DO BEGIN
  str(vnr - 64, vstr); vstr := 'XP' + vstr + 'INT';
  Enter_Vek(vnr, vstr); END;
FOR vnr := 68 TO 70 DO BEGIN
  str(vnr - 39, vstr); vstr := 'CC' + vstr + 'INT';
  Enter_Vek(vnr, vstr); END;
Enter_Vek(71, 'S0TBINT');


end.