// file: TomCat.cpp

#include <stdio.h>
//#include "nios.h" 

#include "tc_vars.h"
#include "hardware_t.h"
#include "flash_t.h"
#include "display_t.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"
#include "opsys_t.h"

void main(void)										// Main program
{
	printf("\r\n\r\n**********************************************\r\n");
	printf("        BlueFlash firmware starting!\r\n");	
	printf("**********************************************\r\n\r\n");

	Hardware::Init();
	
	Display::Init();

	Hardware::Start_Up();
	
	printf("Ready - press h for help\r\n");
	printf("**********************************************\r\n\r\n");

	// main loop
	for(;;)	
	{
		UserIF::Rotary_Interface();	// handle events from rotary interface

		UserIF::Keyboard_Interface();	// handle events from keyboard

		Hardware::Handle_ADC();		// handle ADC events

		Signal::processSignal();	// signal processing

		Display::DrawSignals();		// create signal output for display

		inlExecSingle(0);		// execution handler for delayed event 1
		
		inlExecSingle(1);		// execution handler for delayed event 2
		
//not in use	inlExecSingle(2);		// execution handler for delayed event 3
		
		inlExecSingle(3);		// execution handler for periodic event 1
		
//not in use	inlExecSingle(4);		// execution handler for periodic event 2
		
//not in use	OpSys::ExecHandler();
		
		Hardware::TransferPlanes();	// copy buffer planes to display memory

		CommIF::Transfer_USB_Data();	// communication interface

		AMDFlash::WriteConfig();	// save configuration to flash

	}

}



