
#include "hardware_t.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
//#include "math.h"
#include "commif_t.h"
#include "userif_t.h"
#include "signal_t.h"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class CommIF
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//##########################################################################################################################################################
// BF -> UART handler
void CommIF::InterpretUART(volatile unsigned char data[37])
{	
	char cnt, result_buf = 0;
	char CalcBuf;
	int	ix, CalcBufInt;
	long int libuf;
	
    	int lcnt = 0;
    	unsigned long buflong, buflong1, buflong2 = 0;	
	
	unsigned long *prog_flash_adr_buf;
	unsigned long *prog_flash_adr_buf2;
    	unsigned char add_buf = 0;

    	char DataStr[50];

//*******************************************************
//	debug test output
	printf("Received: ");
	printf("\n\r");
	for(char i=0;i<UART2_rx_cnt;i++)
	{
		if (i%8==0)printf("\n\r");
		printf(" %2x(%d) ", data[i], data[i]);
	}
	printf("\n\r");
//*******************************************************


    if ((data[1] == 3) && (data[2] == 4))
    {
        //start_acq->np_piodata = 0x01;				//start record Port On
        //start_acq->np_piodata = 0x00;				//start record Port Off			
    }
    else
    {
	switch(data[1])
	{
		case 1: 											// Send Screen Shot
		{
			if (data[2] == 0) SendShot();
			else SendSWShot();
			break;
		}
		case 2: 											// Send Data
		{
			
			//switch(which)
			switch(data[2])
			{
				
				case 0: 									//
				{
					//
					break;
				}
				
				case 1:										// Main Time Base
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = MainTimebase;
					
					SendData(send_buffer);

					break;
				}
				
				case 2:										// Expand Time Base
				{
/*BF del no function			send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = Selected_Expand_Timebase;
					
					SendData(send_buffer);
*/					break;
				}
							
				case 8:
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = Hardware::_regADC[eFPGA1].grid_color;
					
					SendData(send_buffer);
					break;
				}				
				
				case 9:										// Main Time Base
				{
/*BF del no function					
					for (cnt = 0; cnt < 32; cnt++)
					{
						send_buffer[0] = 3;						// Command Write Data
						send_buffer[1] = data[2];
						
						send_buffer[2] = cnt;
					
						send_buffer[3] = LogicData[cnt] & 0xFF;
						send_buffer[4] = (LogicData[cnt] & 0xFF00) >> 8;
										
						SendData(send_buffer);
					}
*/					break;
				}				
				
				case 12:									// Channel 1
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
										
					CalcBuf = Selected_Voltage_CH1;
									
					if ((MenuStatus[MENU_CHANNEL1][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[MENU_CHANNEL1][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
							
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[MENU_CHANNEL1][3] - 101;
					
//					if ((MenuStatus[MENU_CHANNEL1][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;				
					
					send_buffer[4] = (char) (ZeroLevelCH1 / 1.5);
					
					SendData(send_buffer);
					
					break;
				}
				case 13:									// Channel 2
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
										
					CalcBuf = Selected_Voltage_CH2;
					if ((MenuStatus[MENU_CHANNEL2][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[MENU_CHANNEL2][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[MENU_CHANNEL2][3] - 101;
				//	if ((MenuStatus[MENU_CHANNEL2][4] - 99) == 1) CalcBuf = CalcBuf || 0x80;

					send_buffer[3] = CalcBuf;
					
					send_buffer[4] = (char) (ZeroLevelCH2 / 1.5);
					
					SendData(send_buffer);
												
					break;
				}
				case 14:									// Channel 3
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];					
					
					CalcBuf = Selected_Voltage_CH3;
					if ((MenuStatus[MENU_CHANNEL3][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[MENU_CHANNEL3][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[MENU_CHANNEL3][3] - 101;
				//	if ((MenuStatus[MENU_CHANNEL3][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;
					
					
					
					
					send_buffer[4] = (char) (ZeroLevelCH3 / 1.5);
					
					SendData(send_buffer);
												
					break;
				}
				case 15:									// Channel 4
				{
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];					
					
					CalcBuf = Selected_Voltage_CH4;
					if ((MenuStatus[MENU_CHANNEL4][0] - 6) == 0) CalcBuf = CalcBuf | 0x80;   // Ground
					if ((MenuStatus[MENU_CHANNEL4][0] - 6) == 1) CalcBuf = CalcBuf | 0x40;   // AC
			
					send_buffer[2] = CalcBuf;

					CalcBuf = (char) MenuStatus[MENU_CHANNEL4][3] - 101;
				//	if ((MenuStatus[MENU_CHANNEL4][4] - 99) == 1) CalcBuf = CalcBuf | 0x80;

					send_buffer[3] = CalcBuf;
					
					send_buffer[4] = (char) (ZeroLevelCH4 / 1.5);
					
					SendData(send_buffer);
													
					break;
				}	

				case 20:										// Protected Config Shifting
				{
					send_buffer[0] = 2;						// Command Write Data
					send_buffer[1] = 20;
					
					send_buffer[2] = tc_model & 0x000000FF;
					send_buffer[3] = (tc_model & 0x0000FF00) >> 8;
					send_buffer[4] = (tc_model & 0x00FF0000) >> 16;
					send_buffer[5] = (tc_model & 0xFF000000) >> 24;
					
					send_buffer[6] = tc_serial & 0x000000FF;
					send_buffer[7] = (tc_serial & 0x0000FF00) >> 8;
					send_buffer[8] = (tc_serial & 0x00FF0000) >> 16;
					send_buffer[9] = (tc_serial & 0xFF000000) >> 24;

					send_buffer[10] = tc_production_lot1 & 0x000000FF;
					send_buffer[11] = (tc_production_lot1 & 0x0000FF00) >> 8;
					send_buffer[12] = (tc_production_lot1 & 0x00FF0000) >> 16;
					send_buffer[13] = (tc_production_lot1 & 0xFF000000) >> 24;

					send_buffer[14] = tc_production_lot2 & 0x000000FF;
					send_buffer[15] = (tc_production_lot2 & 0x0000FF00) >> 8;
					send_buffer[16] = (tc_production_lot2 & 0x00FF0000) >> 16;
					send_buffer[17] = (tc_production_lot2 & 0xFF000000) >> 24;

					send_buffer[18] = tc_shipment_date & 0x000000FF;
					send_buffer[19] = (tc_shipment_date & 0x0000FF00) >> 8;
					send_buffer[20] = (tc_shipment_date & 0x00FF0000) >> 16;
					send_buffer[21] = (tc_shipment_date & 0xFF000000) >> 24;

				/*	send_buffer[22] = kill_adc & 0x000000FF;
					send_buffer[23] = (kill_adc & 0x0000FF00) >> 8;

					send_buffer[24] = m2k_filter_Mode | (volt_filter_Mode << 4);
				*/	
					SendData(send_buffer);					
				
				    break;
				}
				
				case 21:										// Hardware Shifting
				{
					la_gate->np_piodata = 0x00;
                    				
					send_buffer[0] = 3;						// Command Write Data
					send_buffer[1] = data[2];
					send_buffer[2] = la_data->np_piodata & 0x00FF;
					send_buffer[3] = (la_data->np_piodata & 0xFF00) >> 8;
                    					
					SendData(send_buffer);
#ifdef _Debug_USB_									
					printf("Hardware read : %x \n", la_data->np_piodata);
#endif					
					break;
				}	

				case 22:
				{                  				
					send_buffer[0] = 2;
					send_buffer[1] = 22;
					send_buffer[2] = 1;

					send_buffer[28] = Hardware::_ADC_Offset[0][0];
					send_buffer[29] = Hardware::_ADC_Offset[0][1];
					send_buffer[30] = Hardware::_ADC_Offset[0][2];
					send_buffer[31] = Hardware::_ADC_Offset[0][3];
			
					send_buffer[32] = Hardware::_ADC_Offset[1][0];
					send_buffer[33] = Hardware::_ADC_Offset[1][1];
					send_buffer[34] = Hardware::_ADC_Offset[1][2];
					send_buffer[35] = Hardware::_ADC_Offset[1][3];

					SendData(send_buffer);
					
					nr_delay(10);
					
					send_buffer[0] = 2;
					send_buffer[1] = 22;
                   			send_buffer[2] = 2;

					send_buffer[28] = Hardware::_ADC_Offset[2][0];
					send_buffer[29] = Hardware::_ADC_Offset[2][1];
					send_buffer[30] = Hardware::_ADC_Offset[2][2];
					send_buffer[31] = Hardware::_ADC_Offset[2][3];
			
					send_buffer[32] = Hardware::_ADC_Offset[3][0];
					send_buffer[33] = Hardware::_ADC_Offset[3][1];
					send_buffer[34] = Hardware::_ADC_Offset[3][2];
					send_buffer[35] = Hardware::_ADC_Offset[3][3];

					SendData(send_buffer);					
									
					printf("Sending Voltage Corretion \n\r");

					break;
				} 	
			}
			
			
			break;
		}
		case 3: 											// Receive Data
		{		
			switch(data[2])
			{
				case 0: 									// Connection made	
				{
					//BF del not used if ((data[3] & 0x01) == 0x01) OneShotRestart = true;
					if ((data[3] & 0x02) == 0x02) USB_Data_Trans = true;
					if ((data[3] & 0x04) == 0x04) Run = true;
					if ((data[3] & 0x08) == 0x08) USB_SendAllData = true;
					
					USB_At_Startup = true;

					ConfigChanged = true;
					break;
				}
				
				case 1:										// Main Time Base
				{
					MainTimebase = data[3];
					break;
				}
				
				case 2:										// Expand Time Base
				{
					//BF del -> unused Selected_Expand_Timebase = data[3];
					break;
				}
				
				case 3:										// Main Registers
				{
				/* BF del -> not used 
					//Hardware::_ctrl_reg12 = data[3] + (data[4] << 8);
					//Hardware::_ctrl_reg34 = Hardware::_ctrl_reg12;
					//adc_ctrl_reg = data[20] + (data[21] << 8);
					
					if ((Hardware::_ctrl_reg12 & 0x0010) == 0x0010)
					{					
						data_adr->np_piodata = 0x01;
			
						if ((adc_ctrl_reg & 0x0100) == 0x0100) Hardware::WriteADC(1, 0x200);
						if ((adc_ctrl_reg & 0x0200) == 0x0200) Hardware::WriteADC(2, 0x200);
						if ((adc_ctrl_reg & 0x0400) == 0x0400) Hardware::WriteADC(3, 0x200);
						if ((adc_ctrl_reg & 0x0800) == 0x0800) Hardware::WriteADC(4, 0x200);
			
						data_adr->np_piodata = 0x00;
			
						if ((adc_ctrl_reg & 0x0100) == 0x0100) printf("Read Test ADC1 : %d\n\r", Hardware::ReadADC(1));
						if ((adc_ctrl_reg & 0x0200) == 0x0200) printf("Read Test ADC2 : %d\n\r", Hardware::ReadADC(2));
						if ((adc_ctrl_reg & 0x0400) == 0x0400) printf("Read Test ADC3 : %d\n\r", Hardware::ReadADC(3));
						if ((adc_ctrl_reg & 0x0800) == 0x0800) printf("Read Test ADC4 : %d\n\r", Hardware::ReadADC(4));
					}
					
					trig_holdoff_reg = 0xFFFFFFFF - (data[5] + (data[6] << 8) + (data[7] << 16) + (data[8] << 24));					
									
					MainTimebase = data[9];
					//BF del -> unused Selected_Expand_Timebase = data[10];
					
					//SIGNALFaktor_idx = data[10];
					
					pre_reg = data[11] + (data[12] << 8);
					//trg_val_CHI_reg = (data[13] + (data[14] << 8));
					//trg_val_CHII_reg = (data[15] + (data[16] << 8));
					//trg_val_CHIII_reg = (data[31] + (data[32] << 8));					
					//trg_val_CHIV_reg = (data[33] + (data[34] << 8));

					Trigger_Pos_CH1 = (unsigned int)((255 - (data[13] + (data[14] << 8))) << 1) - 64;
					Trigger_Pos_CH2 = (unsigned int)((255 - (data[15] + (data[16] << 8))) << 1) - 64;
					Trigger_Pos_CH3 = (unsigned int)((255 - (data[31] + (data[32] << 8))) << 1) - 64;
					Trigger_Pos_CH4 = (unsigned int)((255 - (data[33] + (data[34] << 8))) << 1) - 64; 

					//BF del ram_adress_reg = data[17] + (data[18] << 8);
					
					//triggering = data[19];
					
                    			TimebaseChanged = 1;
                    			//BF del SIGNALFaktorChanged = 1;	
				    
					if ((data[20] & 0x01) == 0x01) adc_ctrl_reg |= 0x0001;
					if ((data[20] & 0x02) == 0x02) adc_ctrl_reg |= 0x0002;
					if ((data[20] & 0x04) == 0x04) adc_ctrl_reg |= 0x0004;
					if ((data[20] & 0x08) == 0x08) adc_ctrl_reg |= 0x0008;					
					
					if ((data[20] & 0x10) == 0x10) adc_ctrl_reg |= 0x0010;
					if ((data[20] & 0x20) == 0x20) adc_ctrl_reg |= 0x0020;
					if ((data[20] & 0x40) == 0x40) adc_ctrl_reg |= 0x0040;
					if ((data[20] & 0x80) == 0x80) adc_ctrl_reg |= 0x0080;						
					
					if ((data[21] & 0x01) == 0x01) adc_ctrl_reg |= 0x0100;
					if ((data[21] & 0x02) == 0x02) adc_ctrl_reg |= 0x0200;
					if ((data[21] & 0x04) == 0x04) adc_ctrl_reg |= 0x0400;
					if ((data[21] & 0x08) == 0x08) adc_ctrl_reg |= 0x0800;															
					
					if ((data[21] & 0x10) == 0x10) adc_ctrl_reg |= 0x1000;
					if ((data[21] & 0x20) == 0x20) adc_ctrl_reg |= 0x2000;
					if ((data[21] & 0x40) == 0x40) adc_ctrl_reg |= 0x4000;
					if ((data[21] & 0x80) == 0x80) adc_ctrl_reg |= 0x8000;	
										
					if ((data[20] & 0x10) == 0x10) Channel[eCh1].active = 0;
					else Channel[eCh1].active = 1;
					if ((data[20] & 0x20) == 0x20) Channel[eCh2].active = 0;
					else Channel[eCh2].active = 1;
					if ((data[20] & 0x40) == 0x40) Channel[eCh3].active = 0;
					else Channel[eCh3].active = 1;
					if ((data[20] & 0x80) == 0x80) Channel[eCh4].active = 0;
					else Channel[eCh4].active = 1;	
								
					Hardware::_TriggerSource = eTrigCh1;

//BF changed like the fix from Stefan
					trg_val_CHI_reg	= (int)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH1][GainIdx])+ADC_ZERO;
					trg_val_CHI_reg	= 255 - trg_val_CHI_reg;
		
					trg_val_CHII_reg = (int)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH2][GainIdx])+ADC_ZERO;
					trg_val_CHII_reg = 255 - trg_val_CHII_reg;
		
					trg_val_CHIII_reg = (int)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH3][GainIdx])+ADC_ZERO;
					trg_val_CHIII_reg = 255 - trg_val_CHIII_reg;
		
					trg_val_CHIV_reg = (int)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH4][GainIdx])+ADC_ZERO;
					trg_val_CHIV_reg = 255 - trg_val_CHIV_reg;


					printf("Trig1 : %x - %x\n\r", Trigger_Pos_CH1, trg_val_CHI_reg);
					printf("Trig2 : %x - %x\n\r", Trigger_Pos_CH2, trg_val_CHII_reg);
					printf("Trig3 : %x - %x\n\r", Trigger_Pos_CH3, trg_val_CHIII_reg);
					printf("Trig4 : %x - %x\n\r", Trigger_Pos_CH4, trg_val_CHIV_reg);

									
					if ((data[3] & 0x02) == 0x02)
					{
						if ((data[20] & 0x01) == 0x01) Hardware::_TriggerSource = eTrigCh1;
						if ((data[20] & 0x02) == 0x02) Hardware::_TriggerSource = eTrigCh2;
						if ((data[20] & 0x04) == 0x04) Hardware::_TriggerSource = eTrigCh3;
						if ((data[20] & 0x08) == 0x08) Hardware::_TriggerSource = eTrigCh4;
						
					}
					else Hardware::_TriggerSource = eTrigExt;
					
					//Trigger_Offset_Pos = pre_reg << 2;	//BF del not used	
					
					if ((Hardware::_ctrl_reg12 & 0x40) == 0x40) MenuStatus[MENU_TRIGGERMODE][0] = 93;
					else MenuStatus[MENU_TRIGGERMODE][0] = 94;
                 									
					Hardware::_regADC[eFPGA1].trig_range = data[22] + (data[23] << 8);
					
					Hardware::_regADC[eFPGA1].trig_width = data[24] + (data[25] << 8);
					
					
					// pulse width menu update
					if ((Hardware::_ctrl_reg12 & 0x1200) == 0x1200)
					{
					   MenuStatus[MENU_PULSEWIDTH][2] = 1;
					   Pulse22.Write_Value((float) Hardware::_regADC[eFPGA1].trig_width * (float) 0.000000008);					
					   Pulse22.RenderText();
                    			}
   					if ((Hardware::_ctrl_reg12 & 0x1400) == 0x1400)
					{
					   MenuStatus[MENU_PULSEWIDTH][2] = 2;
					   Pulse21.Write_Value((float) Hardware::_regADC[eFPGA1].trig_width * (float) 0.000000008);
                       			   Pulse21.RenderText();				
                    			}
					if ((Hardware::_ctrl_reg12 & 0x1800) == 0x1800)
					{
					   MenuStatus[MENU_PULSEWIDTH][2] = 3;
					
					   Pulse11.Write_Value((float) Hardware::_regADC[eFPGA1].trig_width * (float) 0.000000008);
					   Pulse12.Write_Value((float) Hardware::_regADC[eFPGA1].trig_range * (float) 0.000000008);
					
					   Pulse11.RenderText();
					   Pulse12.RenderText();
                    			}
                    				
					
					// Extern Trigger Level
					ext_trg_val_reg = data[26];
					Trigger_Pos_CHE = data[26];
					
					// Channel Address Add
					
					channel_Adr_add12 = data[27] + (data[28] << 8);
					channel_Adr_add34 = data[29] + (data[30] << 8);
					
					serdata->np_piodata = ext_trg_val_reg;
	
					serstartpwm->np_piodata = 1;
					serstartpwm->np_piodata = 0;						
					
					data_adr->np_piodata = 0;	//BF ram_adress_reg;					
		
					mode->np_piodata = 0x00;
					mode->np_piodata = 0x00;
						mode->np_piodata = 0x01;
					mode->np_piodata = 0x00;
					*/
/*					
						printf("pre :%x \n", pre_reg);
						printf("ctr :%x \n", ctrl_reg);
						printf("adc :%x \n", adc_ctrl_reg);
						printf("del :%x \n", adc_del_reg);
						printf("trg1 :%x \n", trg_val_CHI_reg);
						printf("extrg :%x \n", ext_trg_val_reg);	
						printf("tb :%x \n", timebase_reg);
						printf("tr :%x \n", Hardware::_regADC[eFPGA1].trig_range);
						printf("tw :%x \n", Hardware::_regADC[eFPGA1].trig_width);
						printf("CHA 1 :%d, 2 :%d, 3 :%d, 4 :%d\n", Channel[eCh1].active, Channel[eCh2].active, Channel[eCh3].active, Channel[eCh4].active);
						printf("TrigSrc %d, Trig %d\n", Selected_Trigger_Source, triggering);
						printf("Channel12 Add %x\n", channel_Adr_add12);
						printf("Channel34 Add %x\n", channel_Adr_add34);
*/
                    //S Display::Update_Channel_Data(1);

					Hardware::CaptureSetupADC();	
					Display::DRAW_ALL_CURSOR();
					
					ConfigChanged = true;
					
					
					if ((Hardware::_regADC[0].adc_ctrl & 0x1000) == 0x1000)
					{
						tc_test_var = (unsigned long) la_data->np_piodata;
			
						send_buffer[0] = 6;								 // Kennung Test Var
			
						send_buffer[1] = (unsigned char) (tc_test_var & 0x000000FF);
						send_buffer[2] = (unsigned char) ((tc_test_var & 0x0000FF00) >> 8);
			
			
						//send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
						//send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
						//send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
						//send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);
			
						SendData(send_buffer);
					}
					else					
					{
						tc_test_var = (unsigned long) la_data->np_piodata;
			
						send_buffer[0] = 8;								 // Kennung Test Var
			
						//send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
						//send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
						//send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
						//send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);
			
						SendData(send_buffer);
					}
			
					if (Active_Menu == 15)
					{
					/*	MenuItemChanged[1] = 1;
						MenuItemChanged[2] = 1;
						MenuItemChanged[3] = 1;
						MenuItemChanged[4] = 1;
					*/	
						Display::UpdateMenu();
					}
				
					
					break;
				}	
				
				case 4:									
				{		
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Run = 0;
					else Run = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;
					
					printf("Trigger Only %d\n\r", USB_OnlyTrigger);
				
				    	ConfigChanged = true;
		
					break;
				}	
						
				case 5:									
				{
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Run = 0;
					else Run = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;
					
					if (data[6] == 0) Transfer_man_data = 0;
					else Transfer_man_data = 1;
					
					
					printf("USB_Data_Trans %d\n\r", USB_Data_Trans);
		
				    	ConfigChanged = true;
					break;
				}	

				case 6:									
				{
					if (data[3] == 0) USB_Data_Trans = 0;
					else USB_Data_Trans = 1;

					if (data[4] == 0) Run = 0;
					else Run = 1;                    				
				
					if (data[5] == 0) USB_OnlyTrigger = 0;
					else USB_OnlyTrigger = 1;

					printf("USB: Continious %d\n\r", Run);
		
				    	ConfigChanged = true;
					break;
				}
						
				case 7:
				{
				    	Hardware::ISR_ADC_INT(0);
					
					break;
				}
				
				case 8:
				{
					Hardware::_regADC[eFPGA1].grid_color = data[3];
					Hardware::_regADC[eFPGA2].grid_color = data[3];
					Hardware::CaptureSetupADC();
					ConfigChanged = true;
					break;
				}

				case 9:
				{/* BF del
					adc_change12_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Change12 %x\n", adc_change12_reg);
#endif					
					Hardware::SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				*/
				}

				case 10:
				{/* BF del
					adc_ctr12_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Ctr12 %x\n", adc_ctr12_reg);
#endif					
					Hardware::SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				*/
				} 

				case 11:
				{/* BF del
					adc_change34_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_					
					if (Debug_Mode) printf("ADC_Change34 %x\n", adc_change34_reg);
#endif					
					Hardware::SetupADC();
					AMDFlash::Write_Protected_Flash();
					break;
				*/
				}
										
				case 12:									// Channel 1
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[MENU_CHANNEL1][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[MENU_CHANNEL1][0] = 7;
					else MenuStatus[MENU_CHANNEL1][0] = 8;					
				
					Selected_Voltage_CH1 = data[3] & 0x3F;					
					
					MenuStatus[MENU_CHANNEL1][3] = (data[4] & 0x3F) + 101;
					
				/*	if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x01;
					else volt_filter_Mode &= 0xFE;					
					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x01;
					else m2k_filter_Mode &= 0xFE;					
				*/	
					SwitchesCH1 = data[5] | (data[6] << 8);

                    			SwitchesCH2 &= 0xFCFF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x0200; break;    // caution 1 & 2 turned
					   case 2 : SwitchesCH2 |= 0x0100; break;
					   case 3 : SwitchesCH2 |= 0x0300; break;
                    			}
                       					
					if ((data[20] & 0x01) == 0x01)
                    			{
						//BF del multi_active = 1;
						SwitchesCH1 |= 0x8000;					
                    			}
					//BF del else
                    			//{
                      				//  multi_active = 0;
                    			//}
                    			
					//ch1_factor = data[21];	
					
					Hardware::SetSwitches(eCh1, -1);
					
					nr_delay(10);
                    					
					Hardware::SetSwitches(eCh2, -1);
					
//					ZeroLevelCH1 = (int) (data[7] * 1.5);
					
					//CH1_DAC_Offset = data[7] | (data[8] << 8);
                    			Virtual_ZeroLevelCH1 = (data[7] | (data[8] << 8)) - 8192;

				/*	DAC_Correction[0][0] = data[18] | (data[19] << 8);
					DAC_Correction[0][1] = data[24] | (data[25] << 8);
					DAC_Correction[0][2] = data[26] | (data[27] << 8);
					
					if (DAC_Correction[0][0] > 32768) DAC_Correction[0][0] -= 65536;
					if (DAC_Correction[0][1] > 32768) DAC_Correction[0][1] -= 65536;
					if (DAC_Correction[0][2] > 32768) DAC_Correction[0][2] -= 65536;
				*/										
					//ZeroLevelCH1 = (unsigned int) CH1_DAC_Offset - 7999 + CH1_DAC_Correction;
					
                    			//ZeroLevelCH1 = (unsigned int) ((CH1_DAC_Offset - 7999) / 1.74) + CH1_DAC_Correction;	
                    			//ZeroLevelCH1 = (unsigned int) (CH1_DAC_Offset - 7999) + CH1_DAC_Correction;//8115;

                    			RotarySteps = 0;
                    			UserIF::ON_Zero_Channel_1();
                    					
					/*BF del
					if ((data[16] & 0x01) == 0x01) FirEnabledCH1 = 1;
					else FirEnabledCH1 = 0;
					*/
					// BF -> not used FirStartCH = data[17];		
					
					//BF test Hardware::SetCHDacOffset(1);
					
					//BF del CH1_DAC_OffsetOld = CH1_DAC_Offset;
					
					
					//kill_adc &= 0xFFF0;
					//kill_adc |= data[28];					
					
					ConfigChanged = true;				
					break;						
				}					
				case 13:									// Channel 2
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[MENU_CHANNEL2][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[MENU_CHANNEL2][0] = 7;
					else MenuStatus[MENU_CHANNEL2][0] = 8;
					
					Selected_Voltage_CH2 = data[3] & 0x3F;					
					
					MenuStatus[MENU_CHANNEL2][3] = (data[4] & 0x3F) + 101;
					
				/*	if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x02;
					else volt_filter_Mode &= 0xFD;	
                    					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x02;
					else m2k_filter_Mode &= 0xFD;	
				*/	
					SwitchesCH2 &= 0xFF00;
					SwitchesCH2 |= data[5];// | (data[6] << 8); Hier nur unteres Byte. Oberes bleibt erhalten

                    			SwitchesCH2 &= 0xF3FF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x0400; break;
					   case 2 : SwitchesCH2 |= 0x0800; break;
					   case 3 : SwitchesCH2 |= 0x0C00; break;
                    			}					
					
					if ((data[20] & 0x01) == 0x01)
                    			{
                				//BF del        multi_active = 1;
                        			SwitchesCH1 |= 0x8000;					
                    			}
					else
                    			{
                				//BF del        multi_active = 0;
                        			SwitchesCH1 &= 0x7FFF;					
                    			}
                    				
					//ch2_factor = data[21];						
					
					Hardware::SetSwitches(eCh2, -1);
					
					nr_delay(10);
					
					Hardware::SetSwitches(eCh1, -1);
					
					
					//printf("serdat : %8x\n", (0x40000000 | data[5] | (data[6] * 256)) & 0xFFFF0FFF);					
					
//					ZeroLevelCH2 = (int) (data[7] * 1.5);
					
					//CH2_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH2 = (data[7] | (data[8] << 8)) - 8192;
					
				/*	DAC_Correction[1][0] = data[18] | (data[19]  << 8);
					DAC_Correction[1][1] = data[24] | (data[25]  << 8);
					DAC_Correction[1][2] = data[26] | (data[27]  << 8);					
					
					if (DAC_Correction[1][0] > 32768) DAC_Correction[1][0] -= 65536;
					if (DAC_Correction[1][1] > 32768) DAC_Correction[1][1] -= 65536;
					if (DAC_Correction[1][2] > 32768) DAC_Correction[1][2] -= 65536;
				*/					
					//ZeroLevelCH2 = (unsigned int) CH2_DAC_Offset - 7999 + CH2_DAC_Correction;
					//ZeroLevelCH2 = (unsigned int) ((CH2_DAC_Offset - 7999) / 1.74) + CH2_DAC_Correction;	
					//ZeroLevelCH2 = (unsigned int) (CH2_DAC_Offset - 7999) + CH2_DAC_Correction;//8115;
					
					RotarySteps = 0;
					UserIF::ON_Zero_Channel_2();
					
					/*BF del not used
					if ((data[16] & 0x01) == 0x01) FirEnabledCH2 = 1;
					else FirEnabledCH2 = 0;
					*/
					// BF -> not used FirStartCH = data[17];	
					//BF test Hardware::SetCHDacOffset(2);
			
					//BF del CH2_DAC_OffsetOld = CH2_DAC_Offset;
					
					//kill_adc &= 0xFF0F;
					//kill_adc |= (data[6] << 4);	
					
					ConfigChanged = true;				
					break;
				}	
				
				case 14:									// Channel 3
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[MENU_CHANNEL3][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[MENU_CHANNEL3][0] = 7;
					else MenuStatus[MENU_CHANNEL3][0] = 8;
					
					Selected_Voltage_CH3 = data[3] & 0x3F;					
					
					MenuStatus[MENU_CHANNEL3][3] = (data[4] & 0x3F) + 101;
					
				/*	if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x04;
					else volt_filter_Mode &= 0xFB;	
                    					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x04;
					else m2k_filter_Mode &= 0xFB;	
				*/	
					SwitchesCH3 = data[5] | (data[6] << 8);

                    			SwitchesCH2 &= 0xCFFF;

					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x2000; break;
					   case 2 : SwitchesCH2 |= 0x1000; break;
					   case 3 : SwitchesCH2 |= 0x3000; break;
                    			}	
                    					
					if ((data[20] & 0x01) == 0x01)
                    			{
                				//BF del        multi_active = 1;
                        			SwitchesCH1 |= 0x8000;					
                    			}
					else
                    			{
                 				//BF del       multi_active = 0;
                        			SwitchesCH1 &= 0x7FFF;					
                    			}
                    				
					//ch3_factor = data[21];						
					
					Hardware::SetSwitches(eCh3, -1);
					
					nr_delay(10);

					Hardware::SetSwitches(eCh2, -1);		
					
					nr_delay(10);					
					
					Hardware::SetSwitches(eCh1, -1);					
					
//					ZeroLevelCH3 = (int) (data[7] * 1.5);
					
					//CH3_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH3 = (data[7] | (data[8] << 8)) - 8192;
					
				/*	DAC_Correction[2][0] = data[18] | (data[19]  << 8);
					DAC_Correction[2][1] = data[24] | (data[25]  << 8);
					DAC_Correction[2][2] = data[26] | (data[27]  << 8);
			
					if (DAC_Correction[2][0] > 32768) DAC_Correction[2][0] -= 65536;
					if (DAC_Correction[2][1] > 32768) DAC_Correction[2][1] -= 65536;
					if (DAC_Correction[2][2] > 32768) DAC_Correction[2][2] -= 65536;
				*/			
					//ZeroLevelCH3 = (unsigned int) CH3_DAC_Offset - 7999 + CH3_DAC_Correction;
					//ZeroLevelCH3 = (unsigned int) (CH3_DAC_Offset - 7999) + CH3_DAC_Correction;//8115;
					
					RotarySteps = 0;
					UserIF::ON_Zero_Channel_3();
					
					/*BF del not used
					if ((data[16] & 0x01) == 0x01) FirEnabledCH3 = 1;
					else FirEnabledCH3 = 0;
					*/
					// BF -> not used FirStartCH = data[17];
					
					//BF test Hardware::SetCHDacOffset(3);					

					//BF del CH3_DAC_OffsetOld = CH3_DAC_Offset;
					
					
					//kill_adc &= 0xF0FF;
					//kill_adc |= (data[6] << 8);						
					
                    			ConfigChanged = true;
					break;
				}													
							
				
				case 15:									// Channel 4
				{
					if ((data[3] & 0x80) == 0x80) MenuStatus[MENU_CHANNEL4][0] = 6;
					else if ((data[3] & 0x40) == 0x40) MenuStatus[MENU_CHANNEL4][0] = 7;
					else MenuStatus[MENU_CHANNEL4][0] = 8;
					
					Selected_Voltage_CH4 = data[3] & 0x3F;
					
					
					MenuStatus[MENU_CHANNEL4][3] = (data[4] & 0x3F) + 101;
					
				/*	if ((data[4] & 0x40) == 0x40) volt_filter_Mode |= 0x08;
					else volt_filter_Mode &= 0xF7;						
					
					if ((data[4] & 0x80) == 0x80) m2k_filter_Mode |= 0x08;
					else m2k_filter_Mode &= 0xF7;	
				*/	
					SwitchesCH4 = data[5] | (data[6] << 8);

                    			SwitchesCH2 &= 0x3FFF;
                    					
					switch(data[22])
					{
					   case 1 : SwitchesCH2 |= 0x4000; break;
					   case 2 : SwitchesCH2 |= 0x8000; break;
					   case 3 : SwitchesCH2 |= 0xC000; break;
                    			}						
					
					if ((data[20] & 0x01) == 0x01)
                    			{
                				//BF del        multi_active = 1;
                        			SwitchesCH1 |= 0x8000;					
                    			}
					else
                    			{
                  				//BF del      multi_active = 0;
                        			SwitchesCH1 &= 0x7FFF;					
                    			}
                    				
					//ch4_factor = data[21];						
					
					Hardware::SetSwitches(eCh4, -1);		
					
					nr_delay(10);
					
					Hardware::SetSwitches(eCh2, -1);		
					
					nr_delay(10);					
					
					Hardware::SetSwitches(eCh1, -1);					
				
//					ZeroLevelCH4 = (int) (data[7] * 1.5);  // data[8] is high byte
				
					//CH4_DAC_Offset = data[7] | (data[8] << 8);
					Virtual_ZeroLevelCH4 = (data[7] | (data[8] << 8)) - 8192;
					
				/*	DAC_Correction[3][0] = data[18] | (data[19]  << 8);
					DAC_Correction[3][1] = data[24] | (data[25]  << 8);
					DAC_Correction[3][2] = data[26] | (data[27]  << 8);
							
					if (DAC_Correction[3][0] > 32768) DAC_Correction[3][0] -= 65536;
					if (DAC_Correction[3][1] > 32768) DAC_Correction[3][1] -= 65536;
					if (DAC_Correction[3][2] > 32768) DAC_Correction[3][2] -= 65536;
                            	*/		
					//ZeroLevelCH4 = (unsigned int) CH4_DAC_Offset - 7999 + CH4_DAC_Correction;
					//ZeroLevelCH4 = (unsigned int) (CH4_DAC_Offset - 7999) + CH4_DAC_Correction;//8115;
					RotarySteps = 0;
					UserIF::ON_Zero_Channel_4();
					
					/*BF del not used
					if ((data[16] & 0x01) == 0x01) FirEnabledCH4 = 1;
					else FirEnabledCH4 = 0;
					*/
					// BF -> not used FirStartCH = data[17];
					
					//BF test Hardware::SetCHDacOffset(4);   

					//BF del CH4_DAC_OffsetOld = CH4_DAC_Offset;
					
					
				//	kill_adc &= 0x0FFF;
				//	kill_adc |= (data[6] << 12);						
					
                   			ConfigChanged = true;
					break;
				}
				
				case 16:									// Trigger
				{
					//SwitchesTB = data[3];		// External not used anymore			
							
					//Hardware::SetSwitches(5, SwitchesTB);	//not used anymore -> use new trigger API					
					ConfigChanged = true;
					break;
				}	
				
				
				case 17:									// Spike Generator / TestPort Bits
				{				
					// TestBits
					//test_port_reg = data[3];
					//out_test->np_piodata = test_port_reg;
					
                    			ConfigChanged = true;			
					break;								
				}
				
				case 18:									// Triangle Generator
				{	
					rot_speed_read->np_piodata = 1;
								
					for (cnt = 0; cnt < 32; cnt++)
					{					
						serdata->np_piodata = data[cnt + 3];
	
						serstartpwm->np_piodata = 1;
						serstartpwm->np_piodata = 0;
						
						//printf("gtd :%x \n", data[cnt + 3]);
					}
					
					rot_speed_read->np_piodata = 0;
					ConfigChanged = true;
					break;								
				}

				case 19:									// Only one shot after restart bit
				{
					/*BF del not used OneShotRestart = data[3];
					if (OneShotRestart) printf("One shot will made after restart\n");
					else printf("Normal mode after restart\n");
					ConfigChanged = true;
					*/
					break;
				}


				case 20:									// Protected Config
				{
					tc_model = data[4] | (data[5] << 8);

                    			tc_serial = data[6] | (data[7] << 8) | (data[8] << 16) | (data[9] << 24);
					
                    			tc_production_lot1 = data[10];				
                    			tc_production_lot2 = data[11];

                    			tc_shipment_date = (data[12] << 8) | (data[13] << 4) | (data[14] & 0x0000000F);

                    		/*	kill_adc = data[15] | (data[16] << 8);
                    			m2k_filter_Mode = data[17] & 0x0F;
                    			volt_filter_Mode = (data[17] & 0xF0) >> 4;
				*/
                   			// if (data[19] != 5) Voltage_Correction[data[19]][data[18]] = data[20];


                   			// if ((data[21] != 5) && (data[22] != 5))ADC_Offset[data[21]][data[22]] = data[23];



                   			 //BF del AMDFlash::Write_Protected_Flash();

					break;
				}

				case 22:									// Protected Config
				{				
        				switch(data[3])
		          		{
						case 1:	
						{
							Hardware::_ADC_Offset[0][0] = data[28];
							Hardware::_ADC_Offset[0][1] = data[29];
							Hardware::_ADC_Offset[0][2] = data[30];
							Hardware::_ADC_Offset[0][3] = data[31];
	
							Hardware::_ADC_Offset[1][0] = data[32];
							Hardware::_ADC_Offset[1][1] = data[33];
							Hardware::_ADC_Offset[1][2] = data[34];
							Hardware::_ADC_Offset[1][3] = data[35];
							break;
						}
	
						case 2:	
						{
							Hardware::_ADC_Offset[2][0] = data[28];
							Hardware::_ADC_Offset[2][1] = data[29];
							Hardware::_ADC_Offset[2][2] = data[30];
							Hardware::_ADC_Offset[2][3] = data[31];
		
							Hardware::_ADC_Offset[3][0] = data[32];
							Hardware::_ADC_Offset[3][1] = data[33];
							Hardware::_ADC_Offset[3][2] = data[34];
							Hardware::_ADC_Offset[3][3] = data[35];
							break;
						}
                    			}

                    			//BF del AMDFlash::Write_Protected_Flash();

					break;
				}	

				case 23:									// USB Data Received
				{	
					int lVZL1=Virtual_ZeroLevelCH1, lVZL2=Virtual_ZeroLevelCH2, lVZL3=Virtual_ZeroLevelCH3, lVZL4=Virtual_ZeroLevelCH4;	//BF backup old levels for trigger calculation

					switch(data[3])
					{
						case 1: Virtual_ZeroLevelCH1 = (GRID_HEIGHT/2) - ((GRID_HEIGHT * (data[4] + (data[5] << 8))) / 384); UserIF::ON_Zero_Channel_1(); break;	//BF correction for old grid format
						case 2: Virtual_ZeroLevelCH2 = (GRID_HEIGHT/2) - ((GRID_HEIGHT * (data[4] + (data[5] << 8))) / 384); UserIF::ON_Zero_Channel_2(); break;	//BF correction for old grid format
						case 3: Virtual_ZeroLevelCH3 = (GRID_HEIGHT/2) - ((GRID_HEIGHT * (data[4] + (data[5] << 8))) / 384); UserIF::ON_Zero_Channel_3(); break;	//BF correction for old grid format
						case 4: Virtual_ZeroLevelCH4 = (GRID_HEIGHT/2) - ((GRID_HEIGHT * (data[4] + (data[5] << 8))) / 384); UserIF::ON_Zero_Channel_4(); break;	//BF correction for old grid format
					}
					/*BF del
					if (MenuStatus[MENU_TRIGGEREDGE][1] == 138 && data[3] == 1) Trigger_Pos_CH1 = GRID_HEIGHT - (data[4] + (data[5] << 8));
					else if (MenuStatus[MENU_TRIGGEREDGE][1] == 139 && data[3] == 2) Trigger_Pos_CH2 = GRID_HEIGHT - (data[4] + (data[5] << 8));
					else if (MenuStatus[MENU_TRIGGEREDGE][1] == 140 && data[3] == 3) Trigger_Pos_CH3 = GRID_HEIGHT - (data[4] + (data[5] << 8));
					else if (MenuStatus[MENU_TRIGGEREDGE][1] == 141 && data[3] == 4) Trigger_Pos_CH4 = GRID_HEIGHT - (data[4] + (data[5] << 8));
					*/
					
					//add the delta between old and new to the triggerlevel
					if (data[3] == 1) Trigger_Pos_CH1 += Virtual_ZeroLevelCH1 - lVZL1;
					else if (data[3] == 2) Trigger_Pos_CH2 += Virtual_ZeroLevelCH2 - lVZL2;
					else if (data[3] == 3) Trigger_Pos_CH3 += Virtual_ZeroLevelCH3 - lVZL3;
					else if (data[3] == 4) Trigger_Pos_CH4 += Virtual_ZeroLevelCH4 - lVZL4;

					Hardware::SetupTrigger();

					TriggerLevelChanged = 1;
					TriggerModeChanged = 1;	
					TriggerWayChanged = 1;
					TimebaseChanged = 1;
									
					Display::StatusUpdate();			
						
					break;
				}
			}
		}
		case 5: 											// Receive Data
		{

			start_acq->np_piodata = 0x01;				//start record Port On
			start_acq->np_piodata = 0x00;				//start record Port Off


			break;			
		}
					
		case 6: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button1\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(30);
					break;
				}		
				case 2: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button2\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(31);
					break;
				}
				case 3: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button3\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(32);
					break;
				}
				case 4: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button4\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(33);
					break;
				}
				case 5: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button5\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(34);
					break;
				}
				case 6: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Button6\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(35);
					break;
				}
				case 7: 									// All
				{
					printf("USB Function Channel 1\n\r");
				
					ButtonChanged = 1;
					Active_Menu = 1;
					UserIF::Buttonhandler(1);
/*
					if ((data[3]) && (Channel[eCh1].active == 0)){ Channel[eCh1].active = 1; Hardware::UpdateChannel(eCh1, 1) };

					if ((data[3] == 0) && (Channel[eCh1].active == 1))
					{ 	
						Channel[eCh1].active = 0; 
						Hardware::UpdateChannel(eCh1, 0);
					
						RemovePlane |= 0x01;
						Hardware::ClearPlanes();
					}
*/										
					break;
				}
				case 8: 									// All
				{
					printf("USB Function Math\n\r");
				
					ButtonChanged = 1;
					UserIF::Buttonhandler(26);
					break;
				}
				case 9: 									// All
				{
					printf("USB Function Channel 2\n\r");

					ButtonChanged = 1;
					Active_Menu = 2;
					UserIF::Buttonhandler(2);
/*					
					if ((data[3]) && (Channel[eCh2].active == 0)){ Channel[eCh2].active = 1; Hardware::UpdateChannel(eCh2, 1); }
					
					if ((data[3] == 0) && (Channel[eCh2].active == 1))
					{
						Channel[eCh2].active = 0; 
					 	Hardware::UpdateChannel(2, 0);
					
						RemovePlane |= 0x02;
						Hardware::ClearPlanes();
					}
*/					
				
					break;
				}
				case 10: 									// All
				{
					printf("USB Function Channel 3\n\r");

					ButtonChanged = 1;
					Active_Menu = 3;
					UserIF::Buttonhandler(3);
/*					
					if ((data[3]) && (Channel[eCh3].active == 0)){ Channel[eCh3].active = 1; Hardware::UpdateChannel(eCh3, 1); }
					
					if ((data[3] == 0) && (Channel[eCh3].active == 1))
					{
						Channel[eCh3].active = 0; 
					 	Hardware::UpdateChannel(eCh3, 0);
					
						RemovePlane |= 0x04;
						Hardware::ClearPlanes();
					}
*/					
					break;
				}
				case 11: 									// All
				{
					printf("USB Function Channel 4\n\r");
				
					ButtonChanged = 1;
					Active_Menu = 4;
					UserIF::Buttonhandler(4);
/*					
					if ((data[3]) && (Channel[eCh4].active == 0)){ Channel[eCh4].active = 1; Hardware::UpdateChannel(eCh4, 1); }
					
					if ((data[3] == 0) && (Channel[eCh4].active == 1))
					{
						Channel[eCh2].active = 0; 
					 	Hardware::UpdateChannel(eCh4, 0);
					
						RemovePlane |= 0x08;
						Hardware::ClearPlanes();
					}
*/				
					break;
				}
				case 12: 									// All
				{
					printf("USB Function Auto Scale\n\r");
				
					ButtonChanged = 1;
					UserIF::Buttonhandler(23);
					break;
				}
				case 13: 									// All
				{
					if (Debug_Mode) printf("USB Function Save/Recall\n\r");

					ButtonChanged = 1;
					break;
				}
				case 14: 									// All
    				{
					if (Debug_Mode) printf("USB Function Quick Print\n\r");
				
					ButtonChanged = 1;
					break;
				}
				case 15: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Utility\n");
#endif					
					ButtonChanged = 1;
					break;
				}
				case 16: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Pulse Width\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(15);
					break;
				}
				case 17: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Cursor\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(16);
					break;
				}
				case 18: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Quick Meas\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(19);
					break;
				}
				case 19: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Acquire\n");
#endif
					ButtonChanged = 1;
					UserIF::Buttonhandler(0);
					break;
				}
				case 20: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Display\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(5);
					break;
				}
				case 21: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Edge\n");
#endif					
					ButtonChanged = 1;
					UserIF::Buttonhandler(14);
					break;
				}
				case 22: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Mode / Coupling\n");
#endif					
					break;
				}
				case 23: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Mode\n");
#endif					
					break;
				}
				case 24: 									// All
				{
					printf("USB Function Run/Stop\n\r");
				
					ButtonChanged = 1;
					UserIF::Buttonhandler(37);
			
					if (Run)
					{		
						LED_ON[12] = 1;
						LED_ON[13] = 0;
						Hardware::Send_LED();					
					}
					else
					{		
						LED_ON[12] = 0;
						LED_ON[13] = 1;
						Hardware::Send_LED();					
					}					
								break;
				}
				case 25: 									// All
				{
					printf("USB Function Single\n\r");
			
					ButtonChanged = 1;
					UserIF::Buttonhandler(38);
					
					break;
				}
				case 26: 									// All
				{
					printf("USB Test Button\n");
					
					
					
                    buflong = 0x00000000;

                    while (1 == 1)
                    {
                        data_adr->np_piodata = 0x01;
                        buflong = Hardware::ReadADC(eCh1);

                        if ((buflong & 0x00008000) == 0x00008000)
                        {
                            buflong1 = Hardware::ReadADC(eCh1);

                      /*      if (Selected_Voltage_CH1 == 9) DAC_Correction[0][0] = (int) (buflong1 - 8192);
                            else if (Selected_Voltage_CH1 == 10) DAC_Correction[0][1] = (int) (buflong1 - 8192);
                            else if (Selected_Voltage_CH1 == 11) DAC_Correction[0][2] = (int) (buflong1 - 8192);

                            printf("buflong %8x %d\n", buflong, buflong);
                            printf("buflong1 %8x %d\n", buflong1, buflong1);
                            printf("CH1_1 : %4.4d CH1_2 : %4.4d CH1_3 : %4.4d \n", DAC_Correction[0][0], DAC_Correction[0][1], DAC_Correction[0][2]);
                        */    
                            break;
                        }

                        data_adr->np_piodata = 0x00;
                        lcnt++;
                        if (lcnt == 50000) break;
                    }					
					

                    		printf("lcnt %d\n", lcnt);

				}	
				case 27:
				{
					if (data[3] == 1)
					{
						USB_SendAllData = 1;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function Send All Data On\n");
#endif						
					}					
					else
					{
						USB_SendAllData = 0;
#ifdef _Debug_USB_						
						if (Debug_Mode) printf("USB Function Send All Data Off\n");
#endif						
					}
/*BF del not used					
					if (data[4] == 1)
					{
						OneShotRestart = 1;
					}					
					else
					{
						OneShotRestart = 0;
					}
*/					
					ConfigChanged = true;
                    					
					break;
				}


				case 28: 									// All
				{
					printf("USB Function Channel 1 ACDC\n\r");
						
					if (data[3]) MenuStatus[MENU_CHANNEL1][0] = 7;  // DC
					else MenuStatus[MENU_CHANNEL1][0] = 8;  // AC
					
					Hardware::SetSwitches(eCh1, -1);
					
					//MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();
                    					
					break;
				}
				case 29: 									// All
				{
					printf("USB Function Channel 2 ACDC\n\r");
						
					if (data[3]) MenuStatus[MENU_CHANNEL2][0] = 7;  // DC
					else MenuStatus[MENU_CHANNEL2][0] = 8;  // AC
					
					Hardware::SetSwitches(eCh2, -1);
					
					//MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				case 30: 									// All
				{
					printf("USB Function Channel 3 ACDC\n\r");

					if (data[3]) MenuStatus[MENU_CHANNEL3][0] = 7;  // DC
					else MenuStatus[MENU_CHANNEL3][0] = 8;  // AC
					
					Hardware::SetSwitches(eCh3, -1);
					
					//MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				case 31: 									// All
				{
					printf("USB Function Channel 4 ACDC\n\r");
				
					if (data[3]) MenuStatus[MENU_CHANNEL4][0] = 7;  // DC
					else MenuStatus[MENU_CHANNEL4][0] = 8;  // AC
                    					
					Hardware::SetSwitches(eCh4, -1);
					
					//MenuItemChanged[0] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 32: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 1 Invert\n");
#endif									
					if (data[3]) MenuStatus[MENU_CHANNEL1][2] = 241;  // Invert
					else MenuStatus[MENU_CHANNEL1][2] = 240;
				
					//MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 33: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 2 Invert\n");
#endif									
					if (data[3]) MenuStatus[MENU_CHANNEL2][2] = 241;  // Invert
					else MenuStatus[MENU_CHANNEL2][2] = 240;
				
					//MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}
				
				case 34: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 3 Invert\n");
#endif									
					if (data[3]) MenuStatus[MENU_CHANNEL3][2] = 241;  // Invert
					else MenuStatus[MENU_CHANNEL3][2] = 240;
				
					//MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}

				case 35: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB Function Channel 4 Invert\n");
#endif									
					if (data[3]) MenuStatus[MENU_CHANNEL4][2] = 241;  // Invert
					else MenuStatus[MENU_CHANNEL4][2] = 240;
				
					//MenuItemChanged[2] = 1;
					Menu_Changed = 1;
					Display::UpdateMenu();					
                    					
					break;
				}                				
			}

			nr_delay(10);
			SendCtrlBlock();
			
			nr_delay(10);
			SendCtrlBlock3();	

			nr_delay(10);
			SendCtrlBlock2();

			break;
		}

		case 7: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 1\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(0);
					else Hardware::Reset_LED(0);					
					break;
				}	
				case 2: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Math\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(4);
					else Hardware::Reset_LED(4);
					break;
				}	
				case 3: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 2\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(1);
					else Hardware::Reset_LED(1);
					break;
				}	
				case 4: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 3\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(2);
					else Hardware::Reset_LED(2);
					break;
				}	
				case 5: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Channel 4\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(3);
					else Hardware::Reset_LED(3);
					break;
				}	
				case 6: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Pulse Width\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(10);
					else Hardware::Reset_LED(10);
					break;
				}	
				case 7: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Wheel\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(6);
					else Hardware::Reset_LED(6);
					break;
				}	
				case 8: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Cursor\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(5);
					else Hardware::Reset_LED(5);
					break;
				}	
				case 9: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Quick Meas\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(7);
					else Hardware::Reset_LED(7);
					break;
				}	
				case 10: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Edge\n");
#endif					
					if (data[3] == 1) Hardware::Set_LED(8);
					else Hardware::Reset_LED(8);
					break;
				}	
				case 11: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Run/Stop Green\n");
#endif					
					LED_ON[12] = 1;
					LED_ON[13] = 0;
					Hardware::Send_LED();
					break;
				}	
				case 12: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Run/Stop Red\n");
#endif					
					LED_ON[13] = 1;
					LED_ON[12] = 0;
					Hardware::Send_LED();
					break;
				}	
				case 13: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Single Green\n");
#endif					
					LED_ON[14] = 1;
					LED_ON[15] = 0;
					Hardware::Send_LED();
					break;
				}	
				case 14: 									// All
				{
#ifdef _Debug_USB_				
					if (Debug_Mode) printf("USB LED Single Red\n");
#endif					
					LED_ON[15] = 1;
					LED_ON[14] = 0;
					Hardware::Send_LED();
					break;
				}									
			}
			
			SendCtrlBlock();
			
			nr_delay(10);
			
			SendCtrlBlock3();			

			nr_delay(10);
			
			SendCtrlBlock2();
			
			
			break;			
		}	
		
		case 8: 											// Receive Data
		{
			switch(data[2])
			{
				case 1: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 1 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 1 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 2: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 2 Right\n");
#endif							
							break;
						}
						case 2:
						{	
#ifdef _Debug_USB_                        				
							if (Debug_Mode) printf("USB Wheel Pos Channel 2 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 3: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 3 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 3 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 4: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 4 Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Pos Channel 4 Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 5: 									// All
				{
					RotarySteps = 1;

					switch(data[3])
					{				
						case 1:
						{											
							printf("USB Wheel Volt Channel 1 Right\n\r");
				
							RotaryDirection = 1;
							UserIF::ON_Voltage_Channel_1();	

							break;
						}
						case 2:
						{					
							printf("USB Wheel Volt Channel 1 Left\n\r");
				
							RotaryDirection = 0;
							UserIF::ON_Voltage_Channel_1();	
					
							break;
						}
					}
					break;						
				}	
				case 6: 									// All
				{
					RotarySteps = 1;

					switch(data[3])
					{				
						case 1:
						{					
							printf("USB Wheel Volt Channel 2 Right\n\r");
						
							RotaryDirection = 1;
							UserIF::ON_Voltage_Channel_2();	

							break;
						}
						case 2:
						{					
							printf("USB Wheel Volt Channel 2 Left\n\r");
					
							RotaryDirection = 0;
							UserIF::ON_Voltage_Channel_2();		

							break;
						}
					}
					break;						
				}	
				case 7: 									// All
				{
					RotarySteps = 1;

					switch(data[3])
					{				
						case 1:
						{					
							printf("USB Wheel Volt Channel 3 Right\n\r");
					
							RotaryDirection = 1;
							UserIF::ON_Voltage_Channel_3();	
							break;
						}
						case 2:
						{					
							printf("USB Wheel Volt Channel 3 Left\n\r");
					
							RotaryDirection = 0;
							UserIF::ON_Voltage_Channel_3();		
							break;
						}
					}
					break;						
				}	
				case 8: 									// All
				{
					RotarySteps = 1;

					switch(data[3])
					{				
						case 1:
						{					
							printf("USB Wheel Volt Channel 4 Right\n\r");
					
							RotaryDirection = 1;
							UserIF::ON_Voltage_Channel_4();	
							break;
						}
						case 2:
						{					
							printf("USB Wheel Volt Channel 4 Left\n");
					
							RotaryDirection = 0;
							UserIF::ON_Voltage_Channel_4();	

							break;
						}
					}
					break;						
				}	
				case 9: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Generic Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Generic Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				case 10: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Level Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Level Left\n");
#endif							
							break;
						}
					}
					break;						
				}				
				case 11: 									// All
				{
					switch(data[3])
					{				
						case 1:								//decrease timebase
						{					
							printf("USB Wheel Timebase Right\n\r");
					
                            				RotaryDirection = 1;
							RotarySteps = 1;
                            				UserIF::ON_Timebase();
                            	
							break;
						}
						case 2:								//increase timebase
						{					
							printf("USB Wheel Timebase Left\n\r");
	
                            				RotaryDirection = 0;
							RotarySteps = 1;
                            				UserIF::ON_Timebase();

							break;
						}
					}
					break;						
				}	
				case 12: 									// All
				{
					switch(data[3])
					{				
						case 1:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Delay Right\n");
#endif							
							break;
						}
						case 2:
						{					
#ifdef _Debug_USB_						
							if (Debug_Mode) printf("USB Wheel Trigger Delay Left\n");
#endif							
							break;
						}
					}
					break;						
				}	
				
			}
			
			SendCtrlBlock();
			
			nr_delay(10);
			
			SendCtrlBlock3();			
			
			nr_delay(10);
			
			SendCtrlBlock2();			
			
			break;
		}
		
		case 9:
		{	
		
			switch(data[10])
			{
				case 1 :
				{
/* BF del not used		
					CH1_X_Offset_1 = data[6];
					CH1_X_Offset_2 = data[7];
					CH1_X_Offset_3 = data[8];
					CH1_X_Offset_4 = data[9];
					
			        if (data[2] > ADCzero) Channel1_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel1_1_ADC_Correction = data[2];
			        if (data[3] > ADCzero) Channel1_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel1_2_ADC_Correction = data[3];
			        if (data[4] > ADCzero) Channel1_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel1_3_ADC_Correction = data[4];
			        if (data[5] > ADCzero) Channel1_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel1_4_ADC_Correction = data[5];					
*/					
					break;					
				}
				case 2 :
				{
/* BF del not used
					CH2_X_Offset_1 = data[6];
					CH2_X_Offset_2 = data[7];
					CH2_X_Offset_3 = data[8];
					CH2_X_Offset_4 = data[9];
					
			        if (data[2] > ADCzero) Channel2_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel2_1_ADC_Correction = data[2];
			        if (data[3] > ADCzero) Channel2_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel2_2_ADC_Correction = data[3];
			        if (data[4] > ADCzero) Channel2_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel2_3_ADC_Correction = data[4];
			        if (data[5] > ADCzero) Channel2_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel2_4_ADC_Correction = data[5];	
*/					
					break;					
				}
				case 3 :
				{
/* BF del not used
					CH3_X_Offset_1 = data[6];
					CH3_X_Offset_2 = data[7];
					CH3_X_Offset_3 = data[8];
					CH3_X_Offset_4 = data[9];	
					
			        if (data[2] > ADCzero) Channel3_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel3_1_ADC_Correction = data[2];
			        if (data[3] > ADCzero) Channel3_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel3_2_ADC_Correction = data[3];
			        if (data[4] > ADCzero) Channel3_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel3_3_ADC_Correction = data[4];
			        if (data[5] > ADCzero) Channel3_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel3_4_ADC_Correction = data[5];	
*/									
					break;				
				}
				case 4 :
				{
/* BF del not used
					CH4_X_Offset_1 = data[6];
					CH4_X_Offset_2 = data[7];
					CH4_X_Offset_3 = data[8];
					CH4_X_Offset_4 = data[9];
					
			        if (data[2] > ADCzero) Channel4_1_ADC_Correction = 256 - (256 - data[2]);
			        else Channel4_1_ADC_Correction = data[2];
			        if (data[3] > ADCzero) Channel4_2_ADC_Correction = 256 - (256 - data[3]);
			        else Channel4_2_ADC_Correction = data[3];
			        if (data[4] > ADCzero) Channel4_3_ADC_Correction = 256 - (256 - data[4]);
			        else Channel4_3_ADC_Correction = data[4];
			        if (data[5] > ADCzero) Channel4_4_ADC_Correction = 256 - (256 - data[5]);
			        else Channel4_4_ADC_Correction = data[5];	
*/								
					break;					
				}												
			}
#ifdef _Debug_USB_			
			if (Debug_Mode) printf("W : %d ; X1 : %d ; X2 : %d ; X3 : %d ; X4 : %d ; idx %i\n", data[10], data[6], data[7], data[8], data[9], data[11]);
#endif			
			
			ConfigChanged = true;
			
			break;			
		}

		//---------------------------------------------------------------------------------------------------
		//			flash programming routines
		//---------------------------------------------------------------------------------------------------
		case 10: 											// Program the Flash
		{
			switch(data[2])
			{
				case 0 :                                    // Set programm mode
				{
					switch(data[3])
					{				
				       		case 0 :                            // End programm mode
				        	{				
//                            				reset_watchdog->np_piodata = 0x01;						// Enableable WatchDog
                            				Run = true;
                            				//adc_started = false;
							result_buf = 0;

							printf("Program mode disabled \n\r");
                            				break;
                        			}
				        	case 1 :                            // Start programm mode
				        	{				
//           			                 	reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
                            				Run = false;
                            				//adc_started = true;
                            				result_buf = 1;

							Hardware::Stop_Record();

                            				printf("Program mode enabled \n\r");
                           				break;
                       				}
                    			}
                    			break;
                		}			
				case 1 :                                    // Erase a block
				{
					prog_flash_adr = (unsigned long *) (data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24));
			
					printf("Erase sector at address %x \n\r", prog_flash_adr);
			
					//BF use AMDFlash::nr_flash_erase_sector() instead!    result_buf = AMDFlash::EraseSector_Flash(prog_flash_adr);
					result_buf = AMDFlash::nr_flash_erase_sector(prog_flash_adr);

					break;
                		}
				case 2 :                                    // receive offset
				{
					prog_flash_offset = (unsigned long) (data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24));
		
					printf("Received Flash Offset %x \n\r", prog_flash_offset);
				
					result_buf = 0;
					
					break;
                		}
				case 3 :                                    // Write a block
				{
					prog_flash_adr = (unsigned long *) ((data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24)) - prog_flash_offset);
					
					prog_flash_length = data[7];
			
					result_buf = 0;
					for (cnt = 0; cnt < prog_flash_length; cnt++)
					{
						result_buf = result_buf + AMDFlash::WriteData_Byte_Flash(prog_flash_adr, cnt, data[8 + cnt]);
						//nr_delay(20);
					}

			                printf("PFD @ %x[%d]  : %d \n\r", prog_flash_adr, prog_flash_length, result_buf);
				    	break;
                		}

				case 4 :                                    // Read Data
				{
					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
                    			result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));

					printf("Read address %x byte %d res = %x\n\r", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);

					break;
                		}

				case 5 :                                    // Read Software Version
				{
				
					printf("Read Software Version %x \n\r", tc_version);				
					printf("Read Software Subversion %x \n\r", tc_subversion);
					printf("Read Software Reversion %x \n\r", tc_dev_version);
					printf("Read Software Compile %x \n\r", tc_dev_subversion);
			
					result_buf = 0;
			
					send_buffer[7] = (unsigned char) tc_version & 0x000000FF;
					send_buffer[8] = (unsigned char) ((tc_version & 0x0000FF00) >> 8);
					send_buffer[9] = (unsigned char) ((tc_version & 0x00FF0000) >> 16);
					send_buffer[10] = (unsigned char) ((tc_version & 0xFF000000) >> 24);
			
					send_buffer[11] = (unsigned char) tc_subversion & 0x000000FF;
					send_buffer[12] = (unsigned char) ((tc_subversion & 0x0000FF00) >> 8);
					send_buffer[13] = (unsigned char) ((tc_subversion & 0x00FF0000) >> 16);
					send_buffer[14] = (unsigned char) ((tc_subversion & 0xFF000000) >> 24);
			
					send_buffer[15] = (unsigned char) tc_dev_version & 0x000000FF;
					send_buffer[16] = (unsigned char) ((tc_dev_version & 0x0000FF00) >> 8);
					send_buffer[17] = (unsigned char) ((tc_dev_version & 0x00FF0000) >> 16);
					send_buffer[18] = (unsigned char) ((tc_dev_version & 0xFF000000) >> 24);
			
					send_buffer[19] = (unsigned char) tc_dev_subversion & 0x000000FF;
					send_buffer[20] = (unsigned char) ((tc_dev_subversion & 0x0000FF00) >> 8);
					send_buffer[21] = (unsigned char) ((tc_dev_subversion & 0x00FF0000) >> 16);
					send_buffer[22] = (unsigned char) ((tc_dev_subversion & 0xFF000000) >> 24);

					break;
				}

				case 6 :                                    // Read Hardware Version
				{		
					//printf("Read Hardware Version %x \n\r", tc_hw_version);				
					//printf("Read Hardware SW Version %x \n\r", tc_hw_sw_version);				
					//printf("Read Serial %d hex : %x\n\r", tc_serial, tc_serial);				

					result_buf = 0;
			
					send_buffer[7] = (unsigned char) (tc_hw_version & 0x000000FF);
					send_buffer[8] = (unsigned char) ((tc_hw_version & 0x0000FF00) >> 8);
					send_buffer[9] = (unsigned char) ((tc_hw_version & 0x00FF0000) >> 16);
					send_buffer[10] = (unsigned char) ((tc_hw_version & 0xFF000000) >> 24);
			
					//send_buffer[11] = (unsigned char) (tc_hw_sw_version & 0x000000FF);
					//send_buffer[12] = (unsigned char) ((tc_hw_sw_version & 0x0000FF00) >> 8);
					//send_buffer[13] = (unsigned char) ((tc_hw_sw_version & 0x00FF0000) >> 16);
					//send_buffer[14] = (unsigned char) ((tc_hw_sw_version & 0xFF000000) >> 24);
			
					send_buffer[15] = (unsigned char) (tc_serial & 0x000000FF);
					send_buffer[16] = (unsigned char) ((tc_serial & 0x0000FF00) >> 8);
					send_buffer[17] = (unsigned char) ((tc_serial & 0x00FF0000) >> 16);
					send_buffer[18] = (unsigned char) ((tc_serial & 0xFF000000) >> 24);
			
					send_buffer[19] = (unsigned char) (tc_production_lot1 & 0x000000FF);
					send_buffer[20] = (unsigned char) ((tc_production_lot1 & 0x0000FF00) >> 8);
					send_buffer[21] = (unsigned char) ((tc_production_lot1 & 0x00FF0000) >> 16);
					send_buffer[22] = (unsigned char) ((tc_production_lot1 & 0xFF000000) >> 24);
			
					send_buffer[23] = (unsigned char) (tc_production_lot2 & 0x000000FF);
					send_buffer[24] = (unsigned char) ((tc_production_lot2 & 0x0000FF00) >> 8);
					send_buffer[25] = (unsigned char) ((tc_production_lot2 & 0x00FF0000) >> 16);
					send_buffer[26] = (unsigned char) ((tc_production_lot2 & 0xFF000000) >> 24);
			
					send_buffer[27] = (unsigned char) (tc_model & 0x000000FF);
					send_buffer[28] = (unsigned char) ((tc_model & 0x0000FF00) >> 8);
					send_buffer[29] = (unsigned char) ((tc_model & 0x00FF0000) >> 16);
					send_buffer[30] = (unsigned char) ((tc_model & 0xFF000000) >> 24);

				    	break;
                		}

				case 7 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
					result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
				
					printf("Read address %x byte %d res = %x\n\r", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
				
					break;
                		}

				case 8 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
				
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
				
					result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
			
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
					break;
                		}

				case 9 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
               	 		}

				case 10 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 11 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
 		               	}

				case 12 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 13 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 14 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 15 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 16 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 17 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

				case 18 :                                    // Read Data
				{

					prog_flash_adr = (unsigned long *) ((data[4] << 8) + (data[5] << 16) + (data[6] << 24));
					
					if ((data[3] == 0x00) & ((data[4] % 0x04) == 0)) AMDFlash::ReadData_Prepare_Flash(prog_flash_adr);
					
						result_buf = AMDFlash::ReadData_Byte_Flash(data[3] + ((data[4] & 0x03) << 8));
	#ifdef _Debug_USB_
					printf("Read address %x byte %d res = %x\n", prog_flash_adr, data[3] + ((data[4] & 0x03) << 8), result_buf);
	#endif
					break;
                		}

            		}

			send_buffer[0] = 10;
			send_buffer[1] = data[2];
			send_buffer[2] = data[3];
			send_buffer[3] = data[4];
			send_buffer[4] = data[5];
			send_buffer[5] = data[6];
		
			send_buffer[6] = result_buf;
					
			SendData(send_buffer);

			break;
		}

		case 11: 											// Program the Flash
		{

           	 	//timebase_reg = data[3] + (data[4] << 8) + (data[5] << 16) + (data[6] << 24);
#ifdef _Debug_USB_
            if (Debug_Mode) printf("TB Reg written %x\n", timebase_reg);
#endif
            		Hardware::CaptureSetupADC();	

			break;
		}
		case 12: 											// BF send timebase register
		{
#ifdef _Debug_USB_		
			if (Debug_Mode) printf("Read TB Reg %x\n", timebase_reg);
#endif
			send_buffer[0] = 8;								 // Kennung Test Var
		/*
			send_buffer[3] = (unsigned char) (timebase_reg & 0x000000FF);
			send_buffer[4] = (unsigned char) ((timebase_reg & 0x0000FF00) >> 8);
			send_buffer[5] = (unsigned char) ((timebase_reg & 0x00FF0000) >> 16);
			send_buffer[6] = (unsigned char) ((timebase_reg & 0xFF000000) >> 24);
		*/
			SendData(send_buffer);

			break;
		}		
		case 13: 											// Search Zeros
		{
			Hardware::Calibrate_DAC_ZeroOffsets();
			 
			break;
		}
		
		case 14: 											// Refresh data -> transfer USB data
		{

			USB_Data_Requested = true;
			
			//BF del if (Run == false) Hardware::ISR_ADC_INT(6);

			break;			
		}	

		case 15: 											//BF set to default
        	{
			Hardware::Reset_To_Default();

			break;			
		}

		case 16: 											// connect to pc
		{

			SendCtrlBlock();
			
			nr_delay(100);
			
			SendCtrlBlock3();
			
			nr_delay(10);
			
			SendCtrlBlock2();
            			
//BF not used			USB_Connected = true;	

			break;			
		}             	

		case 17: 											// 
		{

			SendCtrlBlock2();

			break;			
		}
		
		case 18: 											// 
		{		
		
			New_Menu = 17;
			Menu_Changed = 1;
			
//BF not used			USB_Connected = true;		
			
			break;			
		}		
	}
    }   // else			
}

void CommIF::SendData(volatile unsigned char Bytes[40])
{
	int i;

#ifdef _Debug_USB_
    if (Command_Mode)
    {
        printf("Sending  0:%x  1:%x  2:%x  3:%x  4:%x  5:%x  6:%x  7:%x  8:%x 9:%x \n", Bytes[0], Bytes[1], Bytes[2], Bytes[3], Bytes[4], Bytes[5], Bytes[6], Bytes[7], Bytes[8], Bytes[9]);
        printf("Sending 10:%x 11:%x 12:%x 13:%x 14:%x 15:%x 16:%x 17:%x 18:%x 19:%x\n", Bytes[10], Bytes[11], Bytes[12], Bytes[13], Bytes[14], Bytes[15], Bytes[16], Bytes[17], Bytes[18], Bytes[19]);
        printf("Sending 20:%x 21:%x 22:%x 23:%x 24:%x 25:%x 26:%x 27:%x 28:%x 29:%x\n", Bytes[20], Bytes[21], Bytes[22], Bytes[23], Bytes[24], Bytes[25], Bytes[26], Bytes[27], Bytes[28], Bytes[29]);
        printf("Sending 30:%x 31:%x 32:%x 33:%x 34:%x 35:%x 36:%x \n", Bytes[30], Bytes[31], Bytes[32], Bytes[33], Bytes[34], Bytes[35], Bytes[36]);
    }
#endif

    nr_uart_txchar(40, puart2);
    for (i = 0; i < 40; i++)
    {
        nr_uart_txchar(Bytes[i], puart2);
    }
}

void CommIF::SendShot(void)
{
	printf("USB: Sending screenshot\n\r");

//    reset_watchdog->np_piodata = 0x00;                                  // Disable Watchdog

    // Disable all Interrupts
//BF del not used	Hardware::DoDisableLogicAnalyserInterrupt();
	Hardware::DisableVSyncInterrupt();
	Hardware::DoDisableADCInterrupt();
	Hardware::DoDisableTimer3Interrupt();
	//BF not used  DoDisableTimerInterrupt();
	Hardware::DoDisableUART2Interrupt();
	Hardware::DoDisableUARTInterrupt();
	Hardware::DoDisableRotInterrupt();
	Hardware::DoDisableKeyInterrupt();

	SendLayer(1);
	SendLayer(2);
	SendLayer(3);
	SendLayer(4);
	SendLayer(5);
	SendLayer(6);
	SendLayer(7);
	SendLayer(8);
	SendLayer(9);
	SendLayer(10);
	SendLayer(11);
	SendLayer(12);
	SendLayer(13);
	SendLayer(14);
	SendLayer(15);
	SendLayer(16);

    // Enable all Interrupts
	Hardware::DoEnableKeyInterrupt();
	Hardware::DoEnableRotInterrupt();
	Hardware::DoEnableUARTInterrupt();
	Hardware::DoEnableUART2Interrupt();
//	DoEnableTimerInterrupt();
	Hardware::DoEnableTimer3Interrupt();
	Hardware::DoEnableADCInterrupt();	
	Hardware::EnableVSyncInterrupt();
//    DoEnableLogicAnalyserInterrupt();	

//    reset_watchdog->np_piodata = 0x01;                                  // Enable Watchdog
}

void CommIF::SendSWShot(void)
{
    unsigned int LineCnt, PackCnt;
    unsigned long *Layer1 = UI_Plane1;
    unsigned long *Layer2 = UI_Plane2;
    unsigned long *Layer3 = UI_Plane3;
    unsigned long *Layer4 = UI_Plane4;
    unsigned long *Layer5 = UI_Plane5;
    unsigned long *Layer6 = Channel_Plane1;
    unsigned long *Layer7 = Channel_Plane2;
    unsigned long *Layer8 = Channel_Plane3;
    unsigned long *Layer9 = Channel_Plane4;
    unsigned long *Layer10 = Channel_Math_Plane;
    //BF del unsigned long *Layer11 = Memory_Plane1;
    //BF del unsigned long *Layer12 = Memory_Plane2;
    //BF del unsigned long *Layer13 = Memory_Plane3;
    unsigned long *Layer14 = Marker_Plane1;
    unsigned long *Layer15 = Marker_Plane2;
    unsigned long *Layer16 = Grid_Plane;

    unsigned long BufLayer = 0x00000000;

//    reset_watchdog->np_piodata = 0x00;                                  // Disable Watchdog

    // Disable all Interrupts
//BF del not used	Hardware::DoDisableLogicAnalyserInterrupt();
	Hardware::DisableVSyncInterrupt();
	Hardware::DoDisableADCInterrupt();
	Hardware::DoDisableTimer3Interrupt();
	//BF not used Hardware::DoDisableTimerInterrupt();
	Hardware::DoDisableUART2Interrupt();
	Hardware::DoDisableUARTInterrupt();
	Hardware::DoDisableRotInterrupt();
	Hardware::DoDisableKeyInterrupt();


    send_buffer[0] = 254;                                               // Kennung Screen Data
    send_buffer[1] = 1;                                                 // Layer number

    for(LineCnt = 0; LineCnt < 1200; LineCnt++)
    {
        send_buffer[2] = (unsigned char) ((LineCnt & 0xFF00) >> 8);     // High Line Address
        send_buffer[3] = (unsigned char) (LineCnt & 0x00FF);            // Low Line Address

        for(PackCnt = 0; PackCnt < 8; PackCnt++)
        {
/* BF del
            BufLayer = Layer1[(LineCnt * 8) + PackCnt] | Layer2[(LineCnt * 8) + PackCnt] | Layer5[(LineCnt * 8) + PackCnt] | Layer6[(LineCnt * 8) + PackCnt] | Layer7[(LineCnt * 8) + PackCnt] | Layer8[(LineCnt * 8) + PackCnt] | Layer9[(LineCnt * 8) + PackCnt] | Layer10[(LineCnt * 8) + PackCnt] | Layer11[(LineCnt * 8) + PackCnt] | Layer12[(LineCnt * 8) + PackCnt] | Layer13[(LineCnt * 8) + PackCnt] | Layer14[(LineCnt * 8) + PackCnt] | Layer15[(LineCnt * 8) + PackCnt] | Layer16[(LineCnt * 8) + PackCnt];
*/
            send_buffer[4 + (PackCnt * 4)] = (unsigned char) (BufLayer & 0x000000FF);
            send_buffer[5 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0x0000FF00) >> 8);
            send_buffer[6 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0x00FF0000) >> 16);
            send_buffer[7 + (PackCnt * 4)] = (unsigned char) ((BufLayer & 0xFF000000) >> 24);
        }

        SendData(send_buffer);
    }

    // Enable all Interrupts
	Hardware::DoEnableKeyInterrupt();
	Hardware::DoEnableRotInterrupt();
	Hardware::DoEnableUARTInterrupt();
	Hardware::DoEnableUART2Interrupt();
//	Hardware::DoEnableTimerInterrupt();
	Hardware::DoEnableTimer3Interrupt();
	Hardware::DoEnableADCInterrupt();	
	Hardware::EnableVSyncInterrupt();
//    Hardware::DoEnableLogicAnalyserInterrupt();	

//    reset_watchdog->np_piodata = 0x01;                                  // Enable Watchdog
}

void CommIF::SendLayer(unsigned char LayerNr)						// Send a Layer through USB
{
    unsigned int LineCnt, PackCnt;
    unsigned long *Layer = Planes;

    switch(LayerNr)
    {
        case 1 : Layer = UI_Plane1; break;
        case 2 : Layer = UI_Plane2; break;
        case 3 : Layer = UI_Plane3; break;
        case 4 : Layer = UI_Plane4; break;
        case 5 : Layer = UI_Plane5; break;
        case 6 : Layer = Channel_Plane1; break;
        case 7 : Layer = Channel_Plane2; break;
        case 8 : Layer = Channel_Plane3; break;
        case 9 : Layer = Channel_Plane4; break;
        case 10 : Layer = Channel_Math_Plane; break;
        //case 11 : Layer = Memory_Plane1; break;
        //case 12 : Layer = Memory_Plane2; break;
        //case 13 : Layer = Memory_Plane3; break;
        case 14 : Layer = Marker_Plane1; break;
        case 15 : Layer = Marker_Plane2; break;
        case 16 : Layer = Grid_Plane; break;
    }
    send_buffer[0] = 253;                                               // Kennung Screen Data
    send_buffer[1] = LayerNr;                                                 // Layer number

    for(LineCnt = 0; LineCnt < 1200; LineCnt++)
    {
        send_buffer[2] = (unsigned char) ((LineCnt & 0xFF00) >> 8);     // High Line Address
        send_buffer[3] = (unsigned char) (LineCnt & 0x00FF);            // Low Line Address

        for(PackCnt = 0; PackCnt < 8; PackCnt++)
        {
            send_buffer[4 + (PackCnt * 4)] = 0;
            send_buffer[5 + (PackCnt * 4)] = 0;
            send_buffer[6 + (PackCnt * 4)] = 0;
            send_buffer[7 + (PackCnt * 4)] = 0;

            send_buffer[4 + (PackCnt * 4)] = (unsigned char) (Layer[(LineCnt * 8) + PackCnt] & 0x000000FF);
            send_buffer[5 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0x0000FF00) >> 8);
            send_buffer[6 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0x00FF0000) >> 16);
            send_buffer[7 + (PackCnt * 4)] = (unsigned char) ((Layer[(LineCnt * 8) + PackCnt] & 0xFF000000) >> 24);
        }

        SendData(send_buffer);
    }
}
//##########################################################################################################################################################
// BF -> send actual scope parameters
void CommIF::SendCtrlBlock(void)
{
	int intbuf, ix;
	int chk_calc = 0;
	
	send_buffer[0] = 105;								// Kennung Data
	send_buffer[1] = 5;								// BF Kennung Datablock
	
	send_buffer[2] = (unsigned char) (Selected_Voltage_CH1);
	send_buffer[3] = (unsigned char) (Selected_Voltage_CH2);
	send_buffer[4] = (unsigned char) (Selected_Voltage_CH3);
	send_buffer[5] = (unsigned char) (Selected_Voltage_CH4);
	send_buffer[6] = (unsigned char) (MainTimebase);
	//send_buffer[7] = (unsigned char) (SIGNALFaktor_idx);
	
	intbuf = ZeroLevelCH1 - ((16 * ZeroLevelCH1) / GRID_HEIGHT);			//BF correction for the old grid format
	send_buffer[8] = (unsigned char) ((intbuf + 64) >> 1);
	//send_buffer[8] = (unsigned char) ((ZeroLevelCH1 + 64) >> 1);	

	intbuf = ZeroLevelCH1 - ((16 * ZeroLevelCH2) / GRID_HEIGHT);			//BF correction for the old grid format
	send_buffer[9] = (unsigned char) ((intbuf + 64) >> 1);
	//send_buffer[9] = (unsigned char) ((ZeroLevelCH2 + 64) >> 1);	

	intbuf = ZeroLevelCH1 - ((16 * ZeroLevelCH3) / GRID_HEIGHT);			//BF correction for the old grid format
	send_buffer[10] = (unsigned char) ((intbuf + 64) >> 1);
	//send_buffer[10] = (unsigned char) ((ZeroLevelCH3 + 64) >> 1);		

	intbuf = ZeroLevelCH1 - ((16 * ZeroLevelCH4) / GRID_HEIGHT);			//BF correction for the old grid format
	send_buffer[11] = (unsigned char) ((intbuf + 64) >> 1);
	//send_buffer[11] = (unsigned char) ((ZeroLevelCH4 + 64) >> 1);		
	
	send_buffer[12] = (unsigned char) (NumberOfChannels);
	send_buffer[13] = (unsigned char) (ZoomFactor);
				
	send_buffer[14] = (unsigned char) SingleShot;
	send_buffer[15] = (unsigned char) Run;
	
	send_buffer[16] = (unsigned char) Hardware::_TriggerSource;
	
	send_buffer[17] = (unsigned char) 0;

	switch(Hardware::_TriggerSource)
	{
		case eTrigCh1 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH1 + 64) >> 1); break;
		case eTrigCh2 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH2 + 64) >> 1); break;
		case eTrigCh3 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH3 + 64) >> 1); break;
		case eTrigCh4 : send_buffer[17] = (unsigned char) ((Trigger_Pos_CH4 + 64) >> 1); break;
		case eTrigExt : send_buffer[17] = (unsigned char) Trigger_Pos_CHE; break;
	}

	send_buffer[18] = 0;
	if (Channel[eCh1].active) send_buffer[18] = send_buffer[18] | 0x01;				// channel 1 active -> Set bit 1
	if (MenuStatus[MENU_CHANNEL1][0] == 7) send_buffer[18] = send_buffer[18] | 0x02;  	// GND -> set bit 2
	if (MenuStatus[MENU_CHANNEL1][0] == 8) send_buffer[18] = send_buffer[18] | 0x04;  	// AC -> set bit 3
	if (MenuStatus[MENU_CHANNEL1][0] == 9) send_buffer[18] = send_buffer[18] | 0x08;  	// DC -> set bit 4
	if (MenuStatus[MENU_CHANNEL1][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  	// Invert -> set bit 5

	send_buffer[19] = 0;
	if (Channel[eCh2].active) send_buffer[19] = send_buffer[19] | 0x01;
	if (MenuStatus[MENU_CHANNEL2][0] == 7) send_buffer[19] = send_buffer[19] | 0x02;  // AC
	if (MenuStatus[MENU_CHANNEL2][0] == 8) send_buffer[19] = send_buffer[19] | 0x04;  // AC
	if (MenuStatus[MENU_CHANNEL2][0] == 9) send_buffer[19] = send_buffer[19] | 0x08;  // AC
	//BF del if (MenuStatus[MENU_CHANNEL2][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert
	if (MenuStatus[MENU_CHANNEL2][2] == 241) send_buffer[19] = send_buffer[19] | 0x10;  // Invert

	send_buffer[20] = 0;
	if (Channel[eCh3].active) send_buffer[20] = send_buffer[20] | 0x01;
	if (MenuStatus[MENU_CHANNEL3][0] == 7) send_buffer[20] = send_buffer[20] | 0x02;  // AC
	if (MenuStatus[MENU_CHANNEL3][0] == 8) send_buffer[20] = send_buffer[20] | 0x04;  // AC
	if (MenuStatus[MENU_CHANNEL3][0] == 9) send_buffer[20] = send_buffer[20] | 0x08;  // AC
	//BF del if (MenuStatus[MENU_CHANNEL3][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert
	if (MenuStatus[MENU_CHANNEL3][2] == 241) send_buffer[20] = send_buffer[20] | 0x10;  // Invert

	send_buffer[21] = 0;
	if (Channel[eCh4].active) send_buffer[21] = send_buffer[21] | 0x01;
	if (MenuStatus[MENU_CHANNEL4][0] == 7) send_buffer[21] = send_buffer[21] | 0x02;  // AC
	if (MenuStatus[MENU_CHANNEL4][0] == 8) send_buffer[21] = send_buffer[21] | 0x04;  // AC
	if (MenuStatus[MENU_CHANNEL4][0] == 9) send_buffer[21] = send_buffer[21] | 0x08;  // AC
	//BF del if (MenuStatus[MENU_CHANNEL4][2] == 241) send_buffer[18] = send_buffer[18] | 0x10;  // Invert
	if (MenuStatus[MENU_CHANNEL4][2] == 241) send_buffer[21] = send_buffer[21] | 0x10;  // Invert

	//send_buffer[22] = (unsigned char) Channel[eChM].active;
	
	send_buffer[23] = (unsigned char) MenuStatus[MENU_CHANNEL1][3];		//Probe division
	send_buffer[24] = (unsigned char) MenuStatus[MENU_CHANNEL2][3];		//Probe division
	send_buffer[25] = (unsigned char) MenuStatus[MENU_CHANNEL3][3];		//Probe division
	send_buffer[26] = (unsigned char) MenuStatus[MENU_CHANNEL4][3];		//Probe division
	send_buffer[27] = (unsigned char) MenuStatus[MENU_TRIGGERMODE][4];	//external Probe

	// BF-> not used anymore intbuf = (int)((float) Timebase_Offset_Pos * OffsetFactor);
	send_buffer[28] = (unsigned char) (intbuf & 0x00FF);
	send_buffer[29] = (unsigned char) ((intbuf & 0xFF00) >> 8);
    
	// BF-> not used anymore send_buffer[30] = (unsigned char) ((Timebase_Offset_Pos + 300) & 0x00FF);      // + 300 so it was unsigned
    	// BF-> not used anymore send_buffer[31] = (unsigned char) (((Timebase_Offset_Pos + 300)  & 0xFF00) >> 8);

	send_buffer[32] = (unsigned char) MenuStatus[MENU_TRIGGEREDGE][0];        // Trigger Edge
	send_buffer[33] = (unsigned char) MenuStatus[MENU_TRIGGEREDGE][2];        // Trigger Extern
	
	send_buffer[34] = (unsigned char) (Hardware::_regADC[eFPGA1].pre & 0xFF);
	send_buffer[35] = (unsigned char) ((Hardware::_regADC[eFPGA1].pre & 0xFF00) >> 8);

	//calculate checksum
	chk_calc = 0;	
	for (ix = 0; ix < 32; ix++)
	{	
		chk_calc += send_buffer[3 + ix];
	}	
					
	send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));		//low byte
	send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));	//high byte
				
	SendData(send_buffer);
}

//##########################################################################################################################################################
// BF -> send drawing parameters to USB interface
void CommIF::SendCtrlBlock2(void)
{
    	int intbuf, ix;
    	int chk_calc = 0;

	long lCursor_Vertical_Position1;
	long lCursor_Vertical_Position2;
	
	
	if (Signal::_FFT_Mode != FFT_OFF)
	{ lCursor_Vertical_Position1 = Cursor_Vertical_Position_FFT_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_FFT_2; }
	else if (XY_Mode)
	{ lCursor_Vertical_Position1 = Cursor_Vertical_Position_XY_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_XY_2; }
	else
	{ lCursor_Vertical_Position1 = Cursor_Vertical_Position_TY_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_TY_2; }


    send_buffer[0] = 107;								// Kennung Data
//    send_buffer[1] = 7;									// Kennung Datablock

    send_buffer[2] = (unsigned char) (Cursor_Enabled);
    send_buffer[3] = (unsigned char) (SelectedCursor);
    send_buffer[4] = (unsigned char) (Cursor_XY_Selected);
    send_buffer[5] = (unsigned char) (Cursor_Both_Selected);
    send_buffer[6] = (unsigned char) (Cursor_Horizontal_Active);
    send_buffer[7] = (unsigned char) (Cursor_Vertical_Active);

    send_buffer[8] = (unsigned char) (Cursor_Horizontal_Position_Real1 & 0x000000FF);
    send_buffer[9] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0x0000FF00) >> 8);
    send_buffer[10] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0x00FF0000) >> 16);
    send_buffer[11] = (unsigned char) ((Cursor_Horizontal_Position_Real1 & 0xFF000000) >> 24);

    send_buffer[12] = (unsigned char) (Cursor_Horizontal_Position_Real2 & 0x000000FF);
    send_buffer[13] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0x0000FF00) >> 8);
    send_buffer[14] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0x00FF0000) >> 16);
    send_buffer[15] = (unsigned char) ((Cursor_Horizontal_Position_Real2 & 0xFF000000) >> 24);

    send_buffer[16] = (unsigned char) (lCursor_Vertical_Position1 & 0x000000FF);
    send_buffer[17] = (unsigned char) ((lCursor_Vertical_Position1 & 0x0000FF00) >> 8);
    send_buffer[18] = (unsigned char) ((lCursor_Vertical_Position1 & 0x00FF0000) >> 16);
    send_buffer[19] = (unsigned char) ((lCursor_Vertical_Position1 & 0xFF000000) >> 24);

    send_buffer[20] = (unsigned char) (lCursor_Vertical_Position2 & 0x000000FF);
    send_buffer[21] = (unsigned char) ((lCursor_Vertical_Position2 & 0x0000FF00) >> 8);
    send_buffer[22] = (unsigned char) ((lCursor_Vertical_Position2 & 0x00FF0000) >> 16);
    send_buffer[23] = (unsigned char) ((lCursor_Vertical_Position2 & 0xFF000000) >> 24);

    send_buffer[24] = (unsigned char) QM_Threshold_lower.Read_Value();
    send_buffer[25] = (unsigned char) QM_Threshold_middle.Read_Value();
    send_buffer[26] = (unsigned char) QM_Threshold_upper.Read_Value();

//BF -> not used anymore
    //send_buffer[27] = (unsigned char) ((SignalStartStop[MainTimebase+VirtualTimebase][0] + (int)((float) Timebase_Offset_Pos * OffsetFactor)) & 0x00FF);		//BF #023
    //send_buffer[28] = (unsigned char) (((SignalStartStop[MainTimebase+VirtualTimebase][0] + (int)((float) Timebase_Offset_Pos *OffsetFactor)) & 0xFF00) >> 8);		//BF #023

    //send_buffer[29] = (unsigned char) ((SignalStartStop[MainTimebase+VirtualTimebase][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor)) & 0x00FF);		//BF #023
    //send_buffer[30] = (unsigned char) (((SignalStartStop[MainTimebase+VirtualTimebase][1] + (int)((float) Timebase_Offset_Pos * OffsetFactor)) & 0xFF00) >> 8);		//BF #023

    send_buffer[31] = (unsigned char) (MemWinStart & 0x00FF);
    send_buffer[32] = (unsigned char) ((MemWinStart & 0xFF00) >> 8);


    //send_buffer[33] = (unsigned char) ((PreTrigComp + 100) & 0x00FF);
    //send_buffer[34] = (unsigned char) (((PreTrigComp + 100) & 0xFF00) >> 8);

    //BF not used send_buffer[35] = (unsigned char) (FirStartCH & 0x00FF);
    //BF not used send_buffer[36] = (unsigned char) ((FirStartCH & 0xFF00) >> 8);
    chk_calc = 0;	
    for (ix = 0; ix < 32; ix++)
    {	
        chk_calc += send_buffer[3 + ix];
    }	
				
    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                    		
    SendData(send_buffer);
}
//##########################################################################################################################################################
// BF -> send parameters to USB interface

void CommIF::SendCtrlBlock3(void)
{
    int intbuf, ix;
    int chk_calc = 0;

    send_buffer[0] = 108;								// Kennung Data

//BF del    send_buffer[2] = (unsigned char) (Voltage_Correction[0][Selected_Voltage_CH1]);
//BF del    send_buffer[3] = (unsigned char) (Voltage_Correction[1][Selected_Voltage_CH2]);
//BF del    send_buffer[4] = (unsigned char) (Voltage_Correction[2][Selected_Voltage_CH3]);
//BF del    send_buffer[5] = (unsigned char) (Voltage_Correction[3][Selected_Voltage_CH4]);

//BF test 
	send_buffer[2] = (unsigned char) 0;
	send_buffer[3] = (unsigned char) 0;
	send_buffer[4] = (unsigned char) 0;
	send_buffer[5] = (unsigned char) 0;
//BF end

	send_buffer[6] = (unsigned char) AutoFreeRun;	//Triggermode
    
    send_buffer[7] = (unsigned char) 0;
    send_buffer[8] = (unsigned char) 0;
    send_buffer[9] = (unsigned char) 0;
    send_buffer[10] = (unsigned char) 0;
    send_buffer[11] = (unsigned char) 0;
    send_buffer[12] = (unsigned char) 0;
    send_buffer[13] = (unsigned char) 0;
    send_buffer[14] = (unsigned char) 0;
    send_buffer[15] = (unsigned char) 0;
    send_buffer[16] = (unsigned char) 0;
    send_buffer[17] = (unsigned char) 0;
    send_buffer[18] = (unsigned char) 0;
    send_buffer[19] = (unsigned char) 0;
    send_buffer[20] = (unsigned char) 0;
    send_buffer[21] = (unsigned char) 0;
    send_buffer[22] = (unsigned char) 0;
    send_buffer[23] = (unsigned char) 0;
    send_buffer[24] = (unsigned char) 0;
    send_buffer[25] = (unsigned char) 0;
    send_buffer[26] = (unsigned char) 0;
    send_buffer[27] = (unsigned char) 0;
    send_buffer[28] = (unsigned char) 0;
    send_buffer[29] = (unsigned char) 0;
    send_buffer[30] = (unsigned char) 0;
    send_buffer[31] = (unsigned char) 0;
    send_buffer[32] = (unsigned char) 0;
    send_buffer[33] = (unsigned char) 0;
    send_buffer[34] = (unsigned char) 0;
    send_buffer[35] = (unsigned char) 0;
    send_buffer[36] = (unsigned char) 0;

    chk_calc = 0;	
    for (ix = 0; ix < 32; ix++)
    {	
        chk_calc += send_buffer[3 + ix];
    }	
				
    send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
    send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                    		
    SendData(send_buffer);
}
//##########################################################################################################################################################
//BF old WELEC USB transmission protocoll
void CommIF::Transfer_USB_Data(void)
{
	long ix, ix2, ix3, enddata = 0;
	int chk_calc = 0;
	
	volatile long buffer_addr = 0;	
	volatile long buffer_peak = 0;	
	volatile long buffer_written = 0;	
	
	int channel_trig = 0;


//----------------------------------------------------------------------------------------------------	
//			send menu status via USB to PC
//----------------------------------------------------------------------------------------------------	
	
	if (USB_Data_Trans)
	{
		//reset_watchdog->np_piodata = 0x00;						// Disable WatchDog
		
		for (int cnt = 0; cnt < 32; cnt++)
		{
			send_buffer[0] = 7;
			send_buffer[1] = cnt;
			send_buffer[2] = 1;
			//send_buffer[3] = 			
			
			send_buffer[4] = (unsigned char) MenuStatus[cnt][0];
			send_buffer[5] = (unsigned char) MenuStatus[cnt][1];
			send_buffer[6] = (unsigned char) MenuStatus[cnt][2];
			send_buffer[7] = (unsigned char) MenuStatus[cnt][3];
			send_buffer[8] = (unsigned char) MenuStatus[cnt][4];
			send_buffer[9] = (unsigned char) MenuStatus[cnt][5];			
		
			CommIF::SendData(send_buffer);
		}	
		
		//reset_watchdog->np_piodata = 0x01;						// Enable WatchDog
	}




//BF test UI Interupt!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	if (UI_request) return;	
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


	//-----------------------------------------------------------------------------------
	//       		 USB main data transfer
	//-----------------------------------------------------------------------------------

	// Submit Data to USB Client
	if (USB_Data_Requested) enddata = 511;
	else enddata = 75;

	if (USB_Data_Trans)
	{
		if (USB_SendAllData) enddata = 511;
		else enddata = 75;
		
		USB_Data_Requested = true;
	}

	//printf("USB_Data_Trans = %d  USB_Data_Requested = %d  Transfer_man_data = %d  USB_SendAllData = %d ...\n\r", USB_Data_Trans, USB_Data_Requested, Transfer_man_data, USB_SendAllData);
	
	if (USB_Data_Requested)	// && Transfer_man_data)
	{
        //printf("ba : %x bp : %x bw : %x\n", buffer_addr, buffer_peak, buffer_written);		
		
		printf("Sending USB data to PC...");

		
	
		if (Channel[eCh1].active && (USB_OnlyTrigger == false))
		{

			send_buffer[0] = 101;								// Kennung Data
			//send_buffer[1] = 1;								// Kennung Channel
			
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                		ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);		// Address Low
			
                		chk_calc = 0;
                
				for (ix = 0; ix < 32; ix++)
				{	
					chk_calc += SIGNAL1[(ix2 * 32) + ix];
					send_buffer[3 + ix] = SIGNAL1[(ix2 * 32) + ix];
				}
                
				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
				SendData(send_buffer);
				
				//printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
				nr_delay(10);
			}	
		}
		
		if (Channel[eCh2].active && (USB_OnlyTrigger == false))
		{
			send_buffer[0] = 102;								// Kennung Data
			//send_buffer[1] = 2;									// Kennung Channel
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                		ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
				
				chk_calc = 0;
				
				for (ix = 0; ix < 32; ix++)
				{	
					chk_calc += SIGNAL2[(ix2 * 32) + ix];
					send_buffer[3 + ix] = SIGNAL2[(ix2 * 32) + ix];
				}

				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
				
				SendData(send_buffer);
				nr_delay(10);
			}	
		}
		
		if (NumberOfChannels > 2)
		{
			if (Channel[eCh3].active && (USB_OnlyTrigger == false))
			{
				send_buffer[0] = 103;								// Kennung Data
				//send_buffer[1] = 3;									// Kennung Channel
				
				for (ix2 = 0; ix2 <= enddata; ix2++)
				{
                    			ix3 = ix2 * 32;

					send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
					send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
				
				    	chk_calc = 0;
					for (ix = 0; ix < 32; ix++)
					{	
						chk_calc += SIGNAL3[(ix2 * 32) + ix];
						send_buffer[3 + ix] = SIGNAL3[(ix2 * 32) + ix];
				    	}	
				
					send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
					send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));				
					
					SendData(send_buffer);
					nr_delay(10);
                		}
			}
			
			if (Channel[eCh4].active && (USB_OnlyTrigger == false))
			{		
				send_buffer[0] = 104;								// Kennung Data
				//send_buffer[1] = 4;									// Kennung Channel
				
				for (ix2 = 0; ix2 <= enddata; ix2++)
				{
                    			ix3 = ix2 * 32;

					send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
					send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
					
					chk_calc = 0;
					for (ix = 0; ix < 32; ix++)
					{	
						chk_calc += SIGNAL4[(ix2 * 32) + ix];
						send_buffer[3 + ix] = SIGNAL4[(ix2 * 32) + ix];
				    	}	
				
					send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
					send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
							
					SendData(send_buffer);
					nr_delay(10);
				}
			}		
			
	
		}

		
		if (Channel[eChM].active && (USB_OnlyTrigger == false))
		{

			send_buffer[0] = 105;								// Kennung Data
			//send_buffer[1] = 1;									// Kennung Channel
			
			
			for (ix2 = 0; ix2 <= enddata; ix2++)
			{
                		ix3 = ix2 * 32;

				send_buffer[1] = (unsigned char) ((ix3 & 0xFF00) >> 8);		// Address Hight
				send_buffer[2] = (unsigned char) (ix3 & 0x00FF);			// Address Low
			
				chk_calc = 0;	
				for (ix = 0; ix < 32; ix++)
				{	
					chk_calc += SIGNALM[(ix2 * 32) + ix];
					send_buffer[3 + ix] = SIGNALM[(ix2 * 32) + ix];
				}	
				
				send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
				send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));
                							
				SendData(send_buffer);
				
				//printf("DS %3d %3d %3d\n", send_buffer[2], send_buffer[3], send_buffer[4]);
				nr_delay(10);
			}	
		}
		
		send_buffer[0] = 100;								// Kennung Data
//		send_buffer[1] = 0;									// Kennung Datablock

		send_buffer[2] = (unsigned char) (buffer_addr & 0x000000FF);
		send_buffer[3] = (unsigned char) ((buffer_addr & 0x0000FF00) >> 8);
		send_buffer[4] = (unsigned char) ((buffer_addr & 0x00FF0000) >> 16);
		send_buffer[5] = (unsigned char) ((buffer_addr & 0xFF000000) >> 24);

		send_buffer[6] = (unsigned char) (buffer_peak & 0x000000FF);
		send_buffer[7] = (unsigned char) ((buffer_peak & 0x0000FF00) >> 8);
		send_buffer[8] = (unsigned char) ((buffer_peak & 0x00FF0000) >> 16);
		send_buffer[9] = (unsigned char) ((buffer_peak & 0xFF000000) >> 24);

		send_buffer[10] = (unsigned char) (buffer_written & 0x000000FF);
		send_buffer[11] = (unsigned char) ((buffer_written & 0x0000FF00) >> 8);
		send_buffer[12] = (unsigned char) ((buffer_written & 0x00FF0000) >> 16);
		send_buffer[13] = (unsigned char) ((buffer_written & 0xFF000000) >> 24);
		send_buffer[14] = (unsigned char) MainTimebase;
		//send_buffer[15] = (unsigned char) SIGNALFaktor_idx;
		
		chk_calc = 0;	
		for (ix = 0; ix < 32; ix++)
		{	
			chk_calc += send_buffer[3 + ix];
		}	
					
		send_buffer[37] = (unsigned char)(0xFF - (chk_calc & 0x00FF));
		send_buffer[38] = (unsigned char)(0xFF - ((chk_calc & 0xFF00) >> 8));		
		
		SendData(send_buffer);
		nr_delay(10);		
        		
		if (USB_OnlyTrigger == false)
		{
			SendCtrlBlock();
			nr_delay(50);			
			SendCtrlBlock3();		
			nr_delay(50);	
			SendCtrlBlock2();		
			nr_delay(50);
	        }

        //if (MenuStatus[MENU_QUICKPRINT][2] == 144) MenuStatus[MENU_QUICKPRINT][2] = 143;	
        //Menu_Changed = 1;		

//		reset_watchdog->np_piodata = 0x01;							// Enable WatchDog
		
		USB_Data_Requested = false;

		printf("Sending USB data to PC.................done\n\r");

	}

}

//##########################################################################################################################################################
/*********************************************************************
* rle_enc(unsigned char c, int    init)
* accept one character for encoding.
*
* Note: This function must match with the corr. w2000a-screenshot.exe in 
* welecw2000a/pc/w2000a-screenshot/trunk
*
* unsigned char c   : The character to encode
* int init          : 1 - reset pointers
*                     2 - send EOF-Marker
*
* Simple run length encoding.
*
* If previous character is identically to the actual character, do nothing
* but increment a counter.
* If this counter exceeds maxlen, Send 0xFF (ESC), the number of identical
* characters (MSB,LSB) and the character, that was repeated that many times.
* 
* If the actual character is different from the previous one, check, if
* llength is >0. If so, send ESC,MSB,LSB and the character, that was repeated
* that many times.
* Otherwise send this character.
*
* As 0xFF is used as ESC, send 0xFF 0xFF when 0xFF is sent
*
* The EOF-Mark is 0xFF 0xFE, consequently not more than 0xFFFD characters
* may be collected in one block.
*
* Better compression was tested but only leads to longer processing
* times.
*********************************************************************/

inline void rle_enc(unsigned char c, int init)
{
	static  unsigned short      llength;
	static  short   lastbyte;
	static unsigned short   maxlen=0xFEFD;  //FFFF is escaped FF, FFFE is EOF
	unsigned    char    cout;
	
	if (init==1)
	{ llength=0; lastbyte=-1; return; }
   
	if ((c==lastbyte) && (init != 2))
	{
		llength++;
		if (llength>maxlen)
		{
			putchar(0xFF);          //Escape
			putchar(llength>>8);    //MSB
			putchar(llength);       //LSB
			llength=0;
			lastbyte=-1;
		}
    	}
    	else
	{                                              //c != lastbyte
		if (llength > 0)
		{                              //if llength > 0, write esc, LSB, MSB
			putchar(0xFF);              //ESC
			putchar(llength>>8);        //MSB
			putchar(llength);           //LSB
			llength=0;
		}
		if (c==0xFF) { putchar(c); }   	//Escape
		putchar(c);
		lastbyte=c;
	}

	if (init==2)
	{ putchar(0xFF); putchar(0xFE); putchar(0x00); }
}
//##########################################################################################################################################################
// BF screenshot function for colored screenshots written by Niklas and optimzed by Falk
// new version by Niklas (nevm) 
void CommIF::SCREENSHOT(unsigned char marker)
{
	short x, y;
	unsigned char c=0;			
	int bit, pos, offset;
	int lastbyte,length,bitp=0;         //FW Last Byte, Number of same bytes

	// plane order with buffer planes 
	unsigned long *planes[] = {
		Buffer_Plane1, Copy_Plane1, Copy_Plane2, Buffer_Plane4, Buffer_Plane3, 
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Buffer_PlaneM,
		Marker_Plane1, Marker_Plane2,
		Grid_Plane,
		NULL
	};

	unsigned long *plane;
	int i, set, out=0;

	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}


//if (marker == 'B')
//send color demo
//Display::ColorDemo6();


	// copy planes to buffer for transfer
	for (int i=0; i < 9600; i++)
	{
		Buffer_Plane1[i] = UI_Plane1[i];
		Copy_Plane2[i]   = UI_Plane2[i];
		Buffer_Plane3[i] = UI_Plane3[i];
		Buffer_Plane4[i] = UI_Plane4[i];
		Copy_Plane1[i]   = UI_Plane5[i];
		Buffer_PlaneM[i] = Channel_Math_Plane[i];
	}

	// show popup with message and progress indicator
	if (MenuPopupActive > -1)
	{ Display::Rect(190, 180, 260, 80, 0, UI_Plane2); }	// remove text under the message popup
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 0);	// draw popup
	Display::TextOut12x9("Sending Color Screenshot to PC", 207, 192, 1, UI_Plane2);
	Display::Rect(200, 220, 240, 20, 1, UI_Plane1);	// draw white box


	rle_enc(0,1);					//Initialize rle
	(void)putchar('\n');
	(void)putchar(marker);				//Send start-of-transfer marker
	(void)putchar(0xFF);				//Send start-of-transfer marker
	(void)putchar(0);				//Send dumptye 0 Color
	(void)putchar(1);				//Send interface version

	for (y = 0; y < 480; y++)
	{
		Display::Connect_Pixels(200+(y>>1), 220, 240, 1, UI_Plane2);	// draw progress indicator

		for (x = 0; x < 640; x++)
		{
			offset = x >> 5;        // x div 32
			pos = Display_Line_Adresses[y] + offset;
			bit = x - (offset << 5);    // x - (offset mod 32)
		
			set = 0;
				//Walk through planes but stop as soon as a pixel is set.
			for (i = 0; (plane = planes[i]) != NULL; i++)
			{
				if (*(plane + pos) & BitMasks2[bit]) {
				set=1;
				break;
				}
			}
			//Now, if i contains the first plane with a set pixel
			//With 16 Planes we need four bits, so can put two bits into one Byte
			//If x is even, we write the plane-number into the lower four bits,
			//If x is odd, we write the upper four bits and send that byte
		
			if ((x&1)==0)
			{ c=i & 0x0f; }
			else
			{ c|=(i<<4); rle_enc(c,0); }
		}
	}
	rle_enc(0,2);

	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 1);				// delete popup
	Display::Rect(200, 220, 240, 20, 0, UI_Plane1);					// remove white box
	Display::Rect(200, 190, 240, 52, 0, UI_Plane2);					// remove text

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2();}


}
//##########################################################################################################################################################
/*
 * Why do we need this?
 * Well, using puts() and printf() intermittently
 * with putchar() results in garbled output,
 * since they seem to use different buffers
 * and don't flush them in the order we expect.
 */
inline void outstr(char *p)
{
	
	while (*p != '\0') {
		(void)putchar(*p);
		p++;
	}
}

inline void outuint16(int x)
{

	(void)putchar(x / 256);
	(void)putchar(x % 256);
}

/*
 * Dump measurement data
 *
 * Output as follows:
 *   marker 0xff 0x04 [version]
 *   [type] [mode] [n]
 *     (where type 'Q' (Quick Meas), 'C' (Cursor), or '0' (no measurements);
 *      and mode 'X' (XY-Mode), 'F' (FFT), or 'N' (normal))
 *
 * followed by n measurement spots, each:
 *   [full_string_as_on_dso] 0x01
 *   [measurement_description_string] 0x01
 *   [4 bytes of numerical data]
 *   [dimension_string] 0x01
 *   [unit_string] 0x01
 *   0x00
 */
void CommIF::DUMPMEAS(unsigned char marker)
{
	char *p;
	int i, n;

	#define OUT(x)	{ \
				outstr(x.Read_Text()); \
				(void)putchar(0x01); \
				outstr(x.Read_PreText()); \
				(void)putchar(0x01); \
				outuint16(x.Read_IntBDot()+32768); \
				outuint16(x.Read_IntADot()); \
				outstr(x.Read_DimensionUnit()); \
				(void)putchar(0x01); \
				outstr(x.Read_Unit()); \
				(void)putchar(0x01); \
			}
	#define ZERO()		(void)putchar(0x00);

	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}


	(void)putchar('\n');
	(void)putchar(marker);
	(void)putchar(0xFF);
	(void)putchar(0x04);
	(void)putchar(0x01);	/* format version */
	
	if (QM_Enabled) {
		(void)putchar('Q');
		if (XY_Mode)
			(void)putchar('X');
		else if (Signal::_FFT_Mode != FFT_OFF)
			(void)putchar('F');
		else	// normal mode
			(void)putchar('N');

		n = 0;
		for (i = 0; i < 3; i++)
			if (QM_Type[i] > 0)
				n++;
		(void)putchar(n);

		if (QM_Type[0] > 0)
			OUT(QM_Slot1);
		ZERO();
		if (QM_Type[1] > 0)
			OUT(QM_Slot2);
		ZERO();
		if (QM_Type[2] > 0)
			OUT(QM_Slot3);
		ZERO();
	} else if (Cursor_Enabled && CRS_Delta) {
		(void)putchar('C');
		if (XY_Mode)
		{
			(void)putchar('X');
			(void)putchar(0x02);

			OUT(Cursor_Delta_XY_X);
			ZERO();
			OUT(Cursor_Delta_Y);
			ZERO();;
		} else if (Signal::_FFT_Mode != FFT_OFF) {
			(void)putchar('F');
			(void)putchar(0x03);

			OUT(FFT_Cursor_Delta_X);
			ZERO();
			OUT(FFT_Cursor_Delta_1X);
			ZERO();
			OUT(FFT_Cursor_Delta_Y);
			ZERO();
		} else {
			/* normal mode */
			(void)putchar('N');
			(void)putchar(0x03);

			OUT(Cursor_Delta_X);
			ZERO();
			OUT(Cursor_Delta_1X);
			ZERO();
			OUT(Cursor_Delta_Y);
			ZERO();
		}
	} else {
		/* neither Cursor nor Quick Measure active */
		(void)putchar('0');
		(void)putchar(' ');
		(void)putchar(0x00);
	}

	(void)putchar('\n');

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2(); }

}


//##########################################################################################################################################################
// BF csv function for transmission of raw data
// improved and extended by niklas (nevm)
void CommIF::DUMPCSV(unsigned char marker)
{
	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}

	//Hardware::GetFullSignal();
	
	(void)putchar('\n');
	(void)putchar(marker);					// Send start-of-transfer marker
	(void)putchar(0xFF);					// Send start-of-transfer marker
	if(marker == 'A')
	(void)putchar(3);					// Send dumptye 3 (ASCII)
	else
	(void)putchar(2);					// Send dumptye 2 (CSV)

	putchar(45);						// 01 parameter header size

	// send actual DSO parameters
	putchar((char)NumberOfChannels);			// 02 2 or 4 channels

	putchar((char)Channel[eCh1].active);				// 03 ch1 active?
	putchar((char)Channel[eCh2].active);				// 04 ch2 active?
	putchar((char)Channel[eCh3].active);				// 05 ch3 active?
	putchar((char)Channel[eCh4].active);				// 06 ch4 active?

	putchar(Selected_Voltage_CH1);				// 07 voltage range ch1
	putchar(Selected_Voltage_CH2);				// 08 voltage range ch2
	putchar(Selected_Voltage_CH3);				// 09 voltage range ch3
	putchar(Selected_Voltage_CH4);				// 10 voltage range ch4

	putchar((char)(MenuStatus[MENU_CHANNEL1][0]-6));	// 11 ch1 coupling AC/DC
	putchar((char)(MenuStatus[MENU_CHANNEL2][0]-6));	// 12 ch2 coupling AC/DC
	putchar((char)(MenuStatus[MENU_CHANNEL3][0]-6));	// 13 ch3 coupling AC/DC
	putchar((char)(MenuStatus[MENU_CHANNEL4][0]-6));	// 14 ch4 coupling AC/DC

	putchar((char)(MenuStatus[MENU_CHANNEL1][1]-240));	// 15 ch1 BW Limit
	putchar((char)(MenuStatus[MENU_CHANNEL2][1]-240));	// 16 ch2 BW Limit
	putchar((char)(MenuStatus[MENU_CHANNEL3][1]-240));	// 17 ch3 BW Limit
	putchar((char)(MenuStatus[MENU_CHANNEL4][1]-240));	// 18 ch4 BW Limit

	putchar((char)(MenuStatus[MENU_EXTUTILS][0]-203));	// 19 ch1 delay
	putchar((char)(MenuStatus[MENU_EXTUTILS][1]-203));	// 20 ch2 delay
	putchar((char)(MenuStatus[MENU_EXTUTILS][2]-203));	// 21 ch3 delay
	putchar((char)(MenuStatus[MENU_EXTUTILS][3]-203));	// 22 ch4 delay

	putchar((char)(MenuStatus[MENU_HARDWARE][0]-223));	// 23 ADC-Setup
	putchar((char)(MenuStatus[MENU_HARDWARE][1]-230));	// 24 Pre Gain

	putchar(MainTimebase);					// 25 main timebase for sample rate

	#define OUTUINT16(x)	outuint16((int)(x));

	OUTUINT16(Virtual_ZeroLevelCH1 + 1000);			// 26+27 virtual zero level ch1-4 as uint16
	OUTUINT16(Virtual_ZeroLevelCH2 + 1000);			// 28+29 we add 1000 to make sure we're using
	OUTUINT16(Virtual_ZeroLevelCH3 + 1000);			// 30+31 positive values only, which makes
	OUTUINT16(Virtual_ZeroLevelCH4 + 1000);			// 32+33 things easier
	
	OUTUINT16(ScaleFactor[Selected_Voltage_CH1] * 1000);	// 34+35 scale factors ch1-4 converted from float
	OUTUINT16(ScaleFactor[Selected_Voltage_CH2] * 1000);	// 36+37 via multiplication with 1000 to uint16
	OUTUINT16(ScaleFactor[Selected_Voltage_CH3] * 1000);	// 38+39
	OUTUINT16(ScaleFactor[Selected_Voltage_CH4] * 1000);	// 40+41

	OUTUINT16(Trig_Pos_Mem);				// 42+43 pre trigger memory index

	OUTUINT16(MemoryEnd);					// 44+45 number of samples which have to be transferred
	
	putchar(0x02);						// header version (2), always _last_
	
/*	uint32_t samples;
	
	if (MainTimebase < 11) samples = 16384;			// fast acquisition
	else if	(MainTimebase > 10 && USTB_Mode == USTB_OFF) samples = 4096; // slow acquistion
	else
	{
		samples = MemoryEnd;
	}

	// send trace data
	for (uint32_t idx = 0; idx < ((MainTimebase < 11) ? 16384 : 4096); idx++)	// 16kSa vs. 4kSa. timebases
*/	for (uint32_t idx = 0; idx < MemoryEnd; idx++)
	{
		if (Channel[eCh1].active) putchar(S1Ptr[idx]);
		if (Channel[eCh2].active) putchar(S2Ptr[idx]);
		if (Channel[eCh3].active) putchar(S3Ptr[idx]);
		if (Channel[eCh4].active) putchar(S4Ptr[idx]);
	}

	putchar('\n');

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2(); }

}

//##########################################################################################################################################################
// BF screenshot function for black/white screenshots written by Niklas
// nevm
// BF optimized by Falk
void CommIF::SCREENSHOT_BW(void)
{
	int x, y;
	int bitp=0;
	int bit, pos, offset;

	// plane order with buffer planes 
	unsigned long *planes[] = {
		Buffer_Plane1, Copy_Plane1, Copy_Plane2, //Buffer_Plane4, Buffer_Plane3, 
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Buffer_PlaneM,
		Marker_Plane1, Marker_Plane2,
		Grid_Plane,
		NULL
	};


	unsigned long *plane;
	int i, set, out=0;

	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}


	// copy planes to buffer for transfer
	for (int i=0; i < 9600; i++)
	{
		Buffer_Plane1[i] = UI_Plane1[i];
		Copy_Plane2[i] = UI_Plane2[i];
		Buffer_Plane3[i] = UI_Plane3[i];
		Buffer_Plane4[i] = UI_Plane4[i];
		Copy_Plane1[i] = UI_Plane5[i];
		Buffer_PlaneM[i] = Channel_Math_Plane[i];
	}

	// show popup with message and progress indicator
	if (MenuPopupActive > -1)
	{ Display::Rect(190, 180, 260, 80, 0, UI_Plane2); }	// remove text under the message popup
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 0);	// draw popup
	Display::TextOut12x9("Sending B/W Screenshot to PC", 207, 192, 1, UI_Plane2);
	Display::Rect(200, 220, 240, 20, 1, UI_Plane1);	// draw white box

	rle_enc(0,1);				//Initialize rle
	(void)putchar('\n');
	(void)putchar('S');			//Send start-of-transfer marker
	(void)putchar(0xFF);			//Send start-of-transfer marker
	(void)putchar(1);			//Send dumptye 1 monochrome
	(void)putchar(1);			//Send interface version


	for (y = 0; y < 480; y++) {
		Display::Connect_Pixels(200+(y>>1), 220, 240, 1, UI_Plane2);	// draw progress indicator

		for (x = 0; x < 640; x++) {
			offset = x >> 5;		// x div 32
			pos = Display_Line_Adresses[y] + offset;
			bit = x - (offset << 5);	// x - (offset mod 32)

			set = 0;
//Walk through planes but stop as soon as a pixel is set.
			for (i = 0; (plane = planes[i]) != NULL; i++) {
				if (*(plane + pos) & BitMasks2[bit]) {
					set=1;
					break;
				}
			}

/*********************************************************************
* Changed (dl3daz):
* shift bits into one byte for rle-encoding
*********************************************************************/
			if (set) out |= (1 << bitp);
			bitp++;
			if (bitp==8) {
			rle_enc(out,0);
				out=0;
				bitp=0; }
		}
	}
	rle_enc(0,2);           //Send End-of-file marker

	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 1);				// delete popup
	Display::Rect(200, 220, 240, 20, 0, UI_Plane1);					// remove white box
	Display::Rect(200, 190, 240, 52, 0, UI_Plane2);					// remove text

	if (USTB_Mode != USTB_OFF&&Run) { Hardware::Reset_Timer2(); }

}

//##########################################################################################################################################################
// SD/USB-Host - compatiblity section by Kurt Bohnen (KB)

inline void UC_rle_enc(unsigned char c, int init)
{
	static  unsigned short      llength;
	static  short   lastbyte, outcount=0, i;
	static unsigned short   maxlen=0xFEFD;  //FFFF is escaped FF, FFFE is EOF

    	if (init==1)	//Alles auf Anfangszustand
	{
		llength=0; lastbyte=1; outcount=0;
	}
	
	if (init==2)	//Noch vorhandene Daten senden
	{
		if (llength > 0)	//Es sind wirklich noch Daten da
		{
			putchar(0xFF);	//ESC
			putchar(llength>>8);	//MSB
			putchar(llength);		//LSB
			outcount += 3;			//3 Byte gesendet
						
			if(outcount >= BLOCKSIZE)	//Wenn Datenblock vollstÃ¤ndig
			{
				outcount=0;	//ZÃ¤hler immer zurÃ¼cksetzen, nicht ideal!
				for(i=0;i<100;i++) //Versuche 100mal
				{
					if(UART_RXFlag !=0 ) //Wenn nÃ¤chster Datenblock angefordert wurde
					{
						UART_RXFlag=0;	//Flag zurÃ¼cksetzen
						break;
					}
					nr_delay(15);	// wait 10ms
				}
			}
			
		}
		
		putchar(0xFF);
		putchar(0xFE);
		putchar(0x00);
		outcount += 3;
		
		if(outcount >= BLOCKSIZE)
		{
			outcount=0;
			for(i=0;i<100;i++)
			{
				if( UART_RXFlag!=0 )
				{
					UART_RXFlag=0;
					break;
				}
				nr_delay(15);
			}
		}
	return;	
	}
	
	if ((c==lastbyte) && (init != 2))
	{
		llength++;
		if (llength>maxlen)
		{
			putchar(0xFF);
			putchar(llength>>8);
			putchar(llength);
			outcount += 3;
			
			if(outcount >= BLOCKSIZE)
			{
				outcount=0;
				for(i=0;i<100;i++)
				{
					if( UART_RXFlag!=0 )
					{
						UART_RXFlag=0;
						break;
					}
					nr_delay(15);
				}
			}
			llength=0;
			lastbyte=-1;
		}
    	}

	else	//c != lastbyte
	{   
		if (llength > 0)
			{                              //if llength > 0, write esc, LSB, MSB
				putchar(0xFF);   //ESC
				putchar(llength>>8);  //MSB
				putchar(llength);  //LSB
				outcount += 3;
							
				if(outcount >= BLOCKSIZE)
				{
					outcount=0;
					for(i=0;i<100;i++)
					{
						if( UART_RXFlag!=0 )
						{
							UART_RXFlag=0;
							break;
						}
						nr_delay(15);
					}
				}
				
				llength=0;
			}
		
			if (c==0xFF)
			{ 
				putchar(c);
				outcount++;
					
				if(outcount >= BLOCKSIZE)
				{
					outcount=0;
					for(i=0;i<100;i++)
					{
						if( UART_RXFlag!=0 )
						{
							UART_RXFlag=0;
							break;
						}
						nr_delay(15);
					}
				}
			}
		
			putchar(c);
			outcount++;
			
			if(outcount >= BLOCKSIZE)
			{
				outcount=0;
				for(i=0;i<100;i++)
				{
					if( UART_RXFlag!=0 )
					{
						UART_RXFlag=0;
						break;
					}
					nr_delay(15);
				}
			}
			
		lastbyte=c;
	}
}


//##########################################################################################################################################################
void CommIF::UC_SCREENSHOT_BW(void)
{
	int x, y;
	int	bitp=0;
	int bit, pos, offset;

	// plane order with buffer planes 
	unsigned long *planes[] = {
		Buffer_Plane1, Copy_Plane1, Copy_Plane2, //Buffer_Plane4, Buffer_Plane3, 
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Buffer_PlaneM,
		Marker_Plane1, Marker_Plane2,
		Grid_Plane,
		NULL
	};

	unsigned long *plane;
	int i, set, out=0;
	char temp=0;

	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}


	//printf("Send UC_SCREENSHOT_BW()\r\n");	
	//return;
	// copy planes to buffer for transfer
	for (int i=0; i < 9600; i++)
	{
		Buffer_Plane1[i] = UI_Plane1[i];
		Copy_Plane2[i] = UI_Plane2[i];
		Buffer_Plane3[i] = UI_Plane3[i];
		Buffer_Plane4[i] = UI_Plane4[i];
		Copy_Plane1[i]   = UI_Plane5[i];
		Buffer_PlaneM[i] = Channel_Math_Plane[i];
	}

	// show popup with message and progress indicator
	if (MenuPopupActive > -1)
	{ Display::Rect(190, 180, 260, 80, 0, UI_Plane2); }	// remove text under the message popup
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 0);	// draw popup
	Display::TextOut12x9("Sending B/W Screenshot to USB", 200, 192, 1, UI_Plane2);
	Display::Rect(200, 220, 240, 20, 1, UI_Plane1);	// draw white box

	UC_rle_enc(0,1);				//Initialize rle
	(void)putchar('\n');
	(void)putchar('S');			//Send start-of-transfer marker
	(void)putchar(0xFF);			//Send start-of-transfer marker
	(void)putchar(1);			//Send dumptye 1 monochrome
	(void)putchar(1);			//dummy

	UART_RXFlag=0;
	for(i=0;i<25;i++)
	{
		nr_delay(20);
		if(UART_RXFlag!=0)
		{
			UART_RXFlag=0;
			temp=1;
			break;
		}
	}
	UART_RXFlag=0;

	if(temp)
	for (y = 0; y < 480; y++) {
		Display::Connect_Pixels(200+(y>>1), 220, 240, 1, UI_Plane2);	// draw progress indicator

		for (x = 0; x < 640; x++) {
			offset = x >> 5;		// x div 32
			pos = Display_Line_Adresses[y] + offset;
			bit = x - (offset << 5);	// x - (offset mod 32)

			set = 0;
//Walk through planes but stop as soon as a pixel is set.
			for (i = 0; (plane = planes[i]) != NULL; i++) {
				if (*(plane + pos) & BitMasks2[bit]) {
					set=1;
					break;
				}
			}

/*********************************************************************
* Changed (dl3daz):
* shift bits into one byte for rle-encoding
*********************************************************************/
			if (set) out |= (1 << bitp);
			bitp++;
			if (bitp==8) {
			UC_rle_enc(out,0);
				out=0;
				bitp=0; }
		}
	}
	UC_rle_enc(0,2);           //Send End-of-file marker

	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 1);				// delete popup
	Display::Rect(200, 220, 240, 20, 0, UI_Plane1);					// remove white box
	Display::Rect(200, 190, 240, 52, 0, UI_Plane2);					// remove text

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2(); }


}

//##########################################################################################################################################################
void CommIF::UC_SCREENSHOT(void)
{
	short x, y;
	unsigned char c = 0;	//gcc halt's Maul, I do know, that it is not used uninitialized
	int bit, pos, offset;
	int lastbyte,length,bitp = 0;         //FW Last Byte, Number of same bytes
	
	unsigned long *planes[] = {
		Buffer_Plane1, Copy_Plane1, Copy_Plane2, Buffer_Plane4, Buffer_Plane3, 
		Channel_Plane1, Channel_Plane2, Channel_Plane3, Channel_Plane4,
		Buffer_PlaneM,
		Marker_Plane1, Marker_Plane2,
		Grid_Plane,
		NULL
	};

	unsigned long *plane;
	int i, set, out = 0;
	char connected = 0;

	if (USTB_Mode != USTB_OFF && Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}


	//printf("Send UC_SCREENSHOT()\r\n");	
	//return;

	// copy planes to buffer for transfer
	for (int i=0; i < 9600; i++)
	{
		Buffer_Plane1[i] = UI_Plane1[i];
		Copy_Plane2[i] = UI_Plane2[i];
		Buffer_Plane3[i] = UI_Plane3[i];
		Buffer_Plane4[i] = UI_Plane4[i];
		Copy_Plane1[i]   = UI_Plane5[i];
		Buffer_PlaneM[i] = Channel_Math_Plane[i];
	}

	// show popup with message and progress indicator
	if (MenuPopupActive > -1)
	{ Display::Rect(190, 180, 260, 80, 0, UI_Plane2); }		// remove text under the message popup
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 0);		// draw popup
	Display::TextOut12x9("Sending Color Screenshot to USB", 200, 192, 1, UI_Plane2);
	Display::Rect(200, 220, 240, 20, 1, UI_Plane1);			// draw white box


	UC_rle_enc(0,1);                   				//Initialize rle
	(void)putchar('\n');
	(void)putchar('S');            					//Send start-of-transfer marker
	(void)putchar(0xFF);                				//Send start-of-transfer marker
	(void)putchar(0);               				//Send dumptye 0 Color
	(void)putchar(0);						//dummy

	UART_RXFlag = 0;
	for(i=0;i<25;i++)
	{
		nr_delay(20);
		if(UART_RXFlag != 0)
		{
			UART_RXFlag = 0;
			connected = 1;
			break;
		}
	}
	UART_RXFlag=0;

	if(connected)
	for (y = 0; y < 480; y++) 
	{
		Display::Connect_Pixels(200+(y>>1), 220, 240, 1, UI_Plane2);	// draw progress indicator
	
		for (x = 0; x < 640; x++)
		{
			offset = x >> 5;        				// x div 32
			pos = Display_Line_Adresses[y] + offset;
			bit = x - (offset << 5);   				 // x - (offset mod 32)
		
			set = 0;
			
			for (i = 0; (plane = planes[i]) != NULL; i++) 		//Walk through planes but stop as soon as a pixel is set.
			{
				if (*(plane + pos) & BitMasks2[bit])
				{ set = 1; break;	}
			}
			//Now, if i contains the first plane with a set pixel
			//With 16 Planes we need four bits, so can put two bits into one Byte
			//If x is even, we write the plane-number into the lower four bits,
			//If x is odd, we write the upper four bits and send that byte
		
			if ((x&1)==0) { c = i & 0x0f; }
			else { c |= (i<<4); UC_rle_enc(c,0); }
		}
	}
	UC_rle_enc(0,2);

	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 1);				// delete popup
	Display::Rect(200, 220, 240, 20, 0, UI_Plane1);					// remove white box
	Display::Rect(200, 190, 240, 52, 0, UI_Plane2);					// remove text

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2(); }


}

//##########################################################################################################################################################
void CommIF::UC_DUMPCSV(void)
{
	int	idx;
	unsigned short i,outcount = 0;
	char temp=0;

	//printf("Send UC_DUMPCSV()\r\n");	
	//return;

	if (USTB_Mode != USTB_OFF&&Run)
	{
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();
	}

	//Hardware::GetFullSignal();
	
	(void)putchar('\n');
	(void)putchar('S');				//Send start-of-transfer marker
	(void)putchar(0xFF);				//Send start-of-transfer marker
	(void)putchar(2);				//Send dumptye 2 (CSV)
	(void)putchar(NumberOfChannels);		//ist noetig, sonst wird der obere Befehl ignoriert

	UART_RXFlag=0;
	for(i=0;i<25;i++)
	{
		nr_delay(20);
		if(UART_RXFlag!=0)
		{
			UART_RXFlag=0;
			temp=1;
			break;
		}
	}
	UART_RXFlag=0;
	if(temp==0) return;

	if(NumberOfChannels == 2) // 2 Kanal Gerät
	{
		for (idx = 0; idx < 16384; idx++)		
		{
			putchar(SIGNAL1[idx]);			//sende Wert
			putchar(SIGNAL2[idx]);			//sende Wert

			outcount +=2;
			if(outcount >= BLOCKSIZE)
			{
				outcount=0;
				for(i=0;i<100;i++)
				{
					if( UART_RXFlag!=0 )
					{
						UART_RXFlag=0;
						break;
					}
					nr_delay(25);
				}
			}

		}
	}else	// 4 Kanal Gerät
	{
		for (idx = 0; idx < 16384; idx++)		
		{
			putchar(S1Ptr[idx]);			//sende Wert
			putchar(S2Ptr[idx]);			//sende Wert
			putchar(S3Ptr[idx]);			//sende Wert
			putchar(S4Ptr[idx]);			//sende Wert

			outcount +=4;
			if(outcount >= BLOCKSIZE)
			{
				outcount=0;
				for(i=0;i<100;i++)
				{
					if( UART_RXFlag!=0 )
					{
						UART_RXFlag=0;
						break;
					}
					nr_delay(25);
				}
			}
		}
	}

	if (USTB_Mode != USTB_OFF && Run) { Hardware::Reset_Timer2(); }


}

//##########################################################################################################################################################
// BF RS232 communication written by Falk tranferred from UserIF
// extended by Kurt and Niklas
int CommIF::handleInChar(unsigned char c) {
    static int debug=0;
    int lMenuKey = -1;

	char    charTOlMenuKey[]={
	//  0x0  0x1  0x2  0x3  0x4  0x5  0x6  0x7  0x8  0x9  0xA  0xB  0xC  0xD  0xE  0xF
	    -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -11, -12, -10,  -1,  -1,  -1,  -1,  -1,
	//  0x10 0x11 0x12 0x13 0x14 0x15 0x16 0x17 0x18 0x19 0x1A 0x1B 0x1C 0x1D 0x1E 0x1F
	    -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1, -11, -12, -10,  -1,  -1,  -1,  -1,  -1,
	//  ' '  '!'  '"'  '#'  '$'  '%'  '&'  '''  '('  ')'  '*'  '+'  ','  '-'  '.'  '/'
	    -2,  80,  81,  -1,  83,  84,  85,  -1,  87,  88,  -1,  -1,  69,  71,  70,  86,
	//  '0'  '1'  '2'  '3'  '4'  '5'  '6'  '7'  '8'  '9'  ':'  ';'  '<'  '='  '>'  '?'
	    39,  30,  31,  32,  33,  34,  35,  36,  37,  38,  68,  67,-127,  89,-127,-127,
	//  '@'  'A'  'B'  'C'  'D'  'E'  'F'  'G'  'H'  'I'  'J'  'K'  'L'  'M'  'N'  'O'
	    -1,  50,  64,  62,  52,  42,  53,  54,  55,  47,  56,  57,  58,  66,  65,  48,
	//  'P'  'Q'  'R'  'S'  'T'  'U'  'V'  'W'  'X'  'Y'  'Z'  '['  '\'  ']'  '^'  '_'
	    49,  40,  43,  51,  44,  46,  63,  41,  61,  60,  45,-127,-127,-127,-127,-127,
	//  '`'  'a'  'b'  'c'  'd'  'e'  'f'  'g'  'h'  'i'  'j'  'k'  'l'  'm'  'n'  'o'
	    -1,   0,  10,  16,   5,  14,   7,  23,  55,   1,   2,   3,   4,  13,  22,  26,
	//  'p'  'q'  'r'  's'  't'  'u'  'v'  'w'  'x'  'y'  'z'  '{'  '|'  '}'  '~'  DEL
	    15,  19,   9,   8,  12,   6,  21,  20,  27,  17,  29,  -1,  -1,  -1,  -1,  -1};

    if (UART_NewData) {
        if (debug) printf("handleInChar(%.2X)\n\r",c);
        UART_NewData = 0;              //reset UART ISR flag
		if (UartRxGuiCmd) {
			if (debug) printf("handleInChar(%.2X), UartRxGuiCmd: %d\n\r",c,UartRxGuiCmd);
			switch(UartRxGuiCmd) {
					/*
					 * Handle 2 byte remote control command sequence
					 *
					 * 1, 2, 3, 4:     W2000A Screenshot
					 * 5, 6, 7, (8):   UC/Vinculum
					 */
					case    1:
						CommIF::SCREENSHOT('S');
					break;
					case    2:
						CommIF::SCREENSHOT_BW();
					break;
					case    3:
						CommIF::DUMPCSV('S');
					break;
					case	4:
						CommIF::DUMPMEAS('S');
					break;
					case    5:
						CommIF::UC_SCREENSHOT(); 		// -> UC version
					break;
					case    6:
						CommIF::UC_SCREENSHOT_BW(); 		// -> UC version black and white
					break;
					case    7:
						CommIF::UC_DUMPCSV();			// -> UC version
					break;
					case    'E':
						CommIF::handle_extended_command(UartRxGuiBuf);
					break;
					default:
						printf("Wrong Dumptype specified\n\r");
						break;
			}
			UartRxGuiCmd=0;
		}
        else {
			if (UART_RXData==STX) {
				UartRxGuiCmd=1; }
			else {
				if (UART_RXData>0) lMenuKey=charTOlMenuKey[UART_RXData];

				if(lMenuKey != -1)
				{
					ButtonChanged = 1;

					UserIF::Buttonhandler(lMenuKey);
					//return;
				}
			}
		}
    }
}

//######################################################################################################################################################
//BF RS232 test function by Falk transferred from UserIF
void CommIF::set_vars(unsigned char *buffer,char rw)
{
	long	value;
	unsigned int *addr;
	
	value=(buffer[2]<<24)+(buffer[3]<<16)+(buffer[4]<<8)+buffer[5];
	switch(buffer[1]) {
		case	0:
			//if (rw) timebase_reg=value; printf("timebase_reg=%X\n\r",timebase_reg);
		break;
		case	1:
			if (rw) Hardware::_regADC[0].ctrl=value; printf("_regCtrl12=%X\n\r",Hardware::_regADC[0].ctrl); 
		break;
		case	2:
			if (rw) Hardware::_regADC[eFPGA1].adc_change=value; printf("adc_change12_reg=%X\n\r",Hardware::_regADC[eFPGA2].adc_change);
		break;
		case	3:
			//if (rw) adc_ctr12_reg=value; printf("adc_ctr12_reg=%X\n\r",adc_ctr12_reg);	-> unused register
		break;
		case	4:
			if (rw) Hardware::_regADC[eFPGA2].adc_change=value; printf("adc_change34_reg=%X\n\r",Hardware::_regADC[eFPGA2].adc_change);
		break;
		case	5:
			//if (rw) adc_ctr34_reg=value; printf("adc_ctr34_reg=%X\n\r",adc_ctr34_reg);	-> unused register
		break;
		case	6:
			if (rw) Hardware::_regADC[0].adc_ctrl=value; printf("_regAdcCtrl=%X\n\r",Hardware::_regADC[0].adc_ctrl);
		break;
		case	10:
			if (rw) CH1_DAC_Offset=value; printf("CH1_DAC_Offset=%X\n\r",CH1_DAC_Offset);
			Hardware::SetDacOffset(eCh1);
		break;
		case	11:
			if (rw) CH2_DAC_Offset=value; printf("CH2_DAC_Offset=%X\n\r",CH2_DAC_Offset);
			Hardware::SetDacOffset(eCh2);
		break;
		case	12:
			if (rw) CH3_DAC_Offset=value; printf("CH3_DAC_Offset=%X\n\r",CH3_DAC_Offset);
			Hardware::SetDacOffset(eCh3);
		break;
		case	13:
			if (rw) CH3_DAC_Offset=value; printf("CH3_DAC_Offset=%X\n\r",CH3_DAC_Offset);
			Hardware::SetDacOffset(eCh4);
		break;
	}
	Hardware::CaptureSetupADC();
}

//######################################################################################################################################################
//BF RS232 remote function by Falk transferred from UserIF
void CommIF::Set_Analog_Inputs(unsigned char *buffer)
{
	long out_buf=0;
	
	switch (buffer[1]) {		//Channel
		case 0: out_buf = 0x70000000; break;
		case 1: out_buf = 0x50000000; break;
		case 2: out_buf = 0x10000000; break;
		case 3: out_buf = 0x30000000; break;
	}
	if (buffer[2] & (1<<0)) out_buf|=(1<<3);		//1st Divider on
		else out_buf|=(1<<2);
	if (buffer[2] & (1<<1)) out_buf|=(1<<1);		//2nd Divider on
		else out_buf|=(1<<0);
	if ((buffer[2] & (1<<2))==0) out_buf|=(1<<4);	//1.25xAmplifier
	if ((buffer[2] & (1<<3))==0) out_buf|=(1<<6);	//1st AD8131 x2
	if ((buffer[2] & (1<<4))==0) out_buf|=(1<<7);	//2nd AD8131 x2
	if (buffer[2] & (1<<5)) out_buf|=(1<<5);		//BW-Limit

//TODO: Read AC-Bit and set switches resp.
//Write selected bits
	serdata->np_piodata = out_buf;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;

	printf("Channel %d set to %X\n\r",buffer[1],out_buf);
	nr_delay(40);	//Wait for relais to settle

//Clear Bits0..3 and send again to shut off driver transistors for voltage divider-relais
	out_buf&=0xFFFFFFF0;
	serdata->np_piodata = out_buf;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;

	printf("Channel %d set to %X\n\r",buffer[1],out_buf);
	nr_delay(40);	//Wait for relais to settle
}

//######################################################################################################################################################
//BF RS232 command handler by Falk transferred from UserIF
/*********************************************************************
Handle characters received after STX-0xFF:

All commands from GUI start with STX and 0xFF
Next Byte is a command, following three bytes a parameter.
Example: Set Timebase:
STX 0xFF    Header
'T'         Command Timebase
NN NN NN    Parameter for timebase: 1: 2ns, 2: 5ns, 3: 10ns ...
*********************************************************************/
void CommIF::handle_extended_command(unsigned char *buffer) {
    unsigned char debug=0;
	unsigned int m1,m2;
	unsigned char *dumpptr;
    unsigned long count;

    if (debug) printf("extendend Command complete\n\r");
/*********************************************************************
Buffer is full. Read buffer and do what has to be done
*********************************************************************/
    switch(buffer[0]) {             //This is the command
		case 0x01:
			set_vars(buffer,1);
			break;
		case 0x03:
			set_vars(buffer,0);
			break;
        case 'A':                   //Set ADC-Offsets manually
			m1=buffer[1];
			Hardware::_ADC_Offset[m1][0] = buffer[2];
			Hardware::_ADC_Offset[m1][1] = buffer[3];
			Hardware::_ADC_Offset[m1][2] = buffer[4];
			Hardware::_ADC_Offset[m1][3] = buffer[5];
			//BF del -> special functions Display::GlobalDrawingModes|=DWM_NEED_CLEAR;
			
			break;
        case 'V':                   //Set/Get Vert. Settings
			Set_Analog_Inputs(buffer);
			break;
        case 'D':
                dumpptr=(unsigned char *)((buffer[1]<<24)+
          (buffer[2]<<16)+
          (buffer[3]<<8)+
          (buffer[4]));
                count=(buffer[5]<<16)+
          (buffer[6]<<8)+
          (buffer[7]);
          printf("Dump: %.8X - %.8X\n\r",dumpptr,dumpptr+count);
          for (m1=0;m1<count; m1+=16) {
                  for (m2=0;m2<16; m2++) {
                          if ((*(dumpptr+m2) != 0xff) && (*(dumpptr+m2)!=0)) {
                                  m2=255; }
                  }
                  printf ("%.8X  ",dumpptr);
                  if (m2>16) {
                          for (m2=0;m2<16; m2++) printf ("%.2X ",*(dumpptr+m2)); 
                          printf("    ");
                          for (m2=0;m2<16; m2++) {
                                  if ((*(dumpptr+m2)&0x7f)>0x1f) printf ("%c ",*(dumpptr+m2) & 0x7f);
                                  else printf(". ");
                          }
                          printf("\n\r");
                  }
                  else { printf (" %.2X \n\r",*(dumpptr)); }
                  dumpptr+=16;
          }
          break;

		case 'm':					//Test multiplier
			//M1=buffer[1..3]
			//M2=buffer[4..7]
			m1=	(buffer[1]<<16)+
				(buffer[2]<<8)+
				(buffer[3]);
			m2=	(buffer[4]<<24)+
				(buffer[5]<<16)+
				(buffer[6]<<8)+
				(buffer[7]);
            printf("%d * %d : %d(nm_mult)\n\r", m1,m2,nm_mult(m1, m2));
            printf("%d ? %d : %d(nm_math)\n\r", m1,m2,nm_math(m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0201, m1, m2, nm_math_pfx(0x0201, m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0203, m1, m2, nm_math_pfx(0x0203, m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0401, m1, m2, nm_math_pfx(0x0401, m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0403, m1, m2, nm_math_pfx(0x0403, m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0001, m1, m2, nm_math_pfx(0x0001, m1, m2));
            printf("nm_math_pfx(%X, %d , %d = %d\n\r", 0x0003, m1, m2, nm_math_pfx(0x0003, m1, m2));
			break;
        case 'T':                   //Set/Get Timebase
			if (buffer[1]==0xFF) {	//Get TB
				putchar(STX);
				putchar('E');
				putchar('T');
				putchar(MainTimebase);
				putchar(Selected_Voltage_CH1);
				putchar(Selected_Voltage_CH2);
				putchar(Selected_Voltage_CH3);
				putchar(Selected_Voltage_CH4);
				putchar(0); putchar(0); putchar(0);
			}
            else if ((buffer[1] <= MAXTIMEBASEVAL)) {
                if (debug) printf("Setting TB to %d\n\r",(int)buffer[1]);
                MainTimebase = buffer[1];
            	UserIF::ON_Timebase();
        	}
        break;  //case 'T':
		case 'C':
			RS232_ContData_ReqMask=buffer[1];
			if (debug) printf("Setting continuous dump to %.2X\n\r",buffer[1]);
		break;
		case 'v':
			printf("FW: %d.%d.%d.%d\n\r",tc_version,tc_subversion,tc_dev_version,tc_dev_subversion);
			printf("HW: %X.%c.%c\n\r",tc_hw_version, tc_production_lot1, tc_production_lot2);
			printf("Model: W%04dA\n\r",tc_model);
			printf("+\n\r");
		break;
//Baudrate-Divisor für USB-UART setzen:
		case 'b':
			puart2->np_uartdivisor=buffer[1];
			if (debug) printf("USB-UART set to %d\n\r",buffer[1]);
		break;
//Debugging:
//	buffer[2]*10+buffer[3]: Bit-Nummer,
//	buffer[4]: Setzen(1) oder zuruecksetzen(0)
		case 'x':
			char	bit;
			bit=((buffer[2]-'0')*10+(buffer[3]-'0'));
			switch(buffer[1]) {
				case 't':
					//if (buffer[4]&1) { timebase_reg|=(1<<bit);
					//	if (debug) printf("Setting Bit %d:%.4X\n\r",bit,timebase_reg); }
					//else { timebase_reg&=~(1<<bit);
					//	if (debug) printf("Resetting Bit %d:%.4X\n\r",bit,timebase_reg); }
				break;
				case 'p': {
					if (buffer[4]&1) { Hardware::_regADC[eFPGA1].pre|=(1<<bit);
						if (debug) printf("Setting Bit %d:%.4X\n\r",bit, Hardware::_regADC[eFPGA1].pre); }
					else { Hardware::_regADC[eFPGA1].pre&=~(1<<bit);
						if (debug) printf("Resetting Bit %d:%.4X\n\r",bit, Hardware::_regADC[eFPGA1].pre); }
				
				Hardware::_regADC[eFPGA2].pre = Hardware::_regADC[eFPGA1].pre;
				break;
				}
				case 'c':	// unused dummy register
					//if (buffer[4]&1) { adc_ctr12_reg|=(1<<bit);
					//	if (debug) printf("Setting Bit %d:%.4X\n\r",bit,adc_ctr12_reg); }
					//else { adc_ctr12_reg&=~(1<<bit);
					//	if (debug) printf("Resetting Bit %d:%.4X\n\r",bit,adc_ctr12_reg); }
				break;
				case '1':
					if (buffer[4]&1) { Hardware::_regADC[eFPGA1].adc_change|=(1<<bit);
						if (debug) printf("Setting Bit %d:%.4X\n\r",bit,Hardware::_regADC[eFPGA1].adc_change); }
					else { Hardware::_regADC[eFPGA1].adc_change&=~(1<<bit);
						if (debug) printf("Resetting Bit %d:%.4X\n\r",bit,Hardware::_regADC[eFPGA1].adc_change); }
				break;
				case '3':
					if (buffer[4]&1) { Hardware::_regADC[eFPGA2].adc_change|=(1<<bit);
						if (debug) printf("Setting Bit %d:%.4X\n\r",bit,Hardware::_regADC[eFPGA2].adc_change); }
					else { Hardware::_regADC[eFPGA2].adc_change&=~(1<<bit);
						if (debug) printf("Resetting Bit %d:%.4X\n\r",bit,Hardware::_regADC[eFPGA2].adc_change); }
				break;
			}
			Hardware::CaptureSetupADC();
		break;
    }
}

//##########################################################################################################################################################
// BF new UART2 (USB) handler #017
void CommIF::ON_UART2DataBlock(volatile unsigned char *rxdata)
{

	printf("Received: ");
	printf("\n\r");
	for(char i=0;i<UART2_rx_cnt;i++)
	{
		if (i%8==0)printf("\n\r");
		printf(" %x(%d) ", rxdata[i], rxdata[i]);
	}
	printf("\n\r");



	//++++++++++++++++++++++++++++++++++++++++++++
	//test send routine
	char txbytes[64];

	for(char x=0;x<64;x++)
	txbytes[x] = x;

	txbytes[0] = 64;	//block size


	Hardware::Disable_All_Interrupts();


	//send 64 bytes
	for (int i = 0; i < 64; i++)
	{ nr_uart_txchar(txbytes[i], puart2); }

	Hardware::Setup_Interrupts();

	//++++++++++++++++++++++++++++++++++++++++++++	



	switch(rxdata[1])	//get operation mode
	{
		case 1: { ON_Command(rxdata); break; }		//command mode
		case 2: { ON_WriteFlash(rxdata); break; }	//firmware upload, set config parameters etc.
		case 3: { ON_ReadFlash(rxdata); break; }	//backup flash etc.
		case 4: { ON_TestFunction(rxdata); break; }	//test
	}

}

//##########################################################################################################################################################
// BF new UART2 (USB) command handler #017
void CommIF::ON_Command(volatile unsigned char *rxdata)
{
	
	printf("Command Mode - Command %d \n\r",rxdata[2]);

	switch(rxdata[2])	//get command
	{
		case 1: 	// channel 1 key
		{
			KeyboardMem     = 0x07DFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}
	
		case 2: 	// channel 2 key
		{
			KeyboardMem     = 0x077FFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	
			
			break;
		}
	
		case 3: 	// channel 3 key
		{
			if(NumberOfChannels == 2) break;
			KeyboardMem     = 0x06FFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 4: 	// channel 4 key
		{
			if(NumberOfChannels == 2) break;
			KeyboardMem     = 0x05FFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 5: 	// math channel key
		{
			KeyboardMem     = 0x03FFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	







		case 21: 	// function key 1
		{
			KeyboardMem     = 0x07F7FFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 22: 	// function key 2
		{
			KeyboardMem     = 0x07FBFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 23: 	// function key 3
		{
			KeyboardMem     = 0x07FDFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 24: 	// function key 4
		{
			KeyboardMem     = 0x07FEFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	

		case 25: 	// function key 5
		{
			KeyboardMem     = 0x07BFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	
			break;
		}	

		case 26: 	// function key 6
		{
			KeyboardMem     = 0x07EFFFFF;
			KeyboardChanged = 1;
			UI_request      = 1;	

			break;
		}	




	}


	if (SingleShot && KeyboardChanged)
	{ SingleShot = 0; LED_ON[14] = 0; LED_ON[15] = 0; }



}

//##########################################################################################################################################################
//BF new Firmware upload via USB interface #017
void CommIF::ON_WriteFlash(volatile unsigned char *rxdata)
{

	printf("Flash Write Mode - Command %d \n\r",rxdata[2]);

	switch(rxdata[2])	//get command
	{
		case 1: { 	break; }	//
		case 2: { 	break; }	//
		case 3: {	break; }	//
		case 4: {	break; }	//
		case 5: {	break; }	//????


	}


}

//##########################################################################################################################################################
//BF new Firmware download via USB interface #017
void CommIF::ON_ReadFlash(volatile unsigned char *rxdata)
{

	printf("Flash Read Mode - Command %d \n\r",rxdata[2]);

	switch(rxdata[2])	//get command
	{
		case 1: { 	break; }	//
		case 2: { 	break; }	//
		case 3: {	break; }	//
		case 4: {	break; }	//
		case 5: {	break; }	//????


	}



}

//##########################################################################################################################################################
//BF new test function for USB interface #017
void CommIF::ON_TestFunction(volatile unsigned char *rxdata)
{

	printf("Test Mode - Command %d \n\r",rxdata[2]);

	switch(rxdata[2])	//get command
	{
		case 1: { 	break; }	//
		case 2: { 	break; }	//
		case 3: {	break; }	//
		case 4: {	break; }	//
		case 5: {	break; }	//????


	}



}

