#ifndef flash_t_h
#define flash_t_h

#include "nios.h"


//! Sector address map

/* 0x00000000 - 0x000DFFFF The program itself (sector 1 - 14) */

// unused #define RESERVE_SECTOR			(unsigned long *)	0x000E0000
#define PROTECTED_CONFIG			(unsigned long *)	0x000F0000
/*
#define SAVE_SIGNAL_NR_A01			(unsigned long *)	0x00100000
#define SAVE_SIGNAL_NR_A02			(unsigned long *)	0x00110000
#define SAVE_SIGNAL_NR_A03			(unsigned long *)	0x00120000
#define SAVE_SIGNAL_NR_A04			(unsigned long *)	0x00130000
#define SAVE_SIGNAL_NR_A05			(unsigned long *)	0x00140000
#define SAVE_SIGNAL_NR_A06			(unsigned long *)	0x00150000
#define SAVE_SIGNAL_NR_A07			(unsigned long *)	0x00160000
#define SAVE_SIGNAL_NR_A08			(unsigned long *)	0x00170000
#define SAVE_SIGNAL_NR_A09			(unsigned long *)	0x00180000
#define SAVE_SIGNAL_NR_A10			(unsigned long *)	0x00190000
#define SAVE_SIGNAL_NR_A11			(unsigned long *)	0x001A0000
#define SAVE_SIGNAL_NR_A12			(unsigned long *)	0x001B0000
#define SAVE_SIGNAL_NR_A13			(unsigned long *)	0x001C0000
#define SAVE_SIGNAL_NR_A14			(unsigned long *)	0x001D0000
#define SAVE_SIGNAL_NR_A15			(unsigned long *)	0x001E0000
#define SAVE_SIGNAL_NR_A16			(unsigned long *)	0x001F0000

#define SAVE_SIGNAL_NR_B01			(unsigned long *)	0x00200000
#define SAVE_SIGNAL_NR_B02			(unsigned long *)	0x00210000
#define SAVE_SIGNAL_NR_B03			(unsigned long *)	0x00220000
#define SAVE_SIGNAL_NR_B04			(unsigned long *)	0x00230000
#define SAVE_SIGNAL_NR_B05			(unsigned long *)	0x00240000
#define SAVE_SIGNAL_NR_B06			(unsigned long *)	0x00250000
#define SAVE_SIGNAL_NR_B07			(unsigned long *)	0x00260000
#define SAVE_SIGNAL_NR_B08			(unsigned long *)	0x00270000
#define SAVE_SIGNAL_NR_B09			(unsigned long *)	0x00280000
#define SAVE_SIGNAL_NR_B10			(unsigned long *)	0x00290000
#define SAVE_SIGNAL_NR_B11			(unsigned long *)	0x002A0000
#define SAVE_SIGNAL_NR_B12			(unsigned long *)	0x002B0000
#define SAVE_SIGNAL_NR_B13			(unsigned long *)	0x002C0000
#define SAVE_SIGNAL_NR_B14			(unsigned long *)	0x002D0000
#define SAVE_SIGNAL_NR_B15			(unsigned long *)	0x002E0000
#define SAVE_SIGNAL_NR_B16			(unsigned long *)	0x002F0000

#define SAVE_SIGNAL_NR_C01			(unsigned long *)	0x00300000
#define SAVE_SIGNAL_NR_C02			(unsigned long *)	0x00310000
#define SAVE_SIGNAL_NR_C03			(unsigned long *)	0x00320000
#define SAVE_SIGNAL_NR_C04			(unsigned long *)	0x00330000
#define SAVE_SIGNAL_NR_C05			(unsigned long *)	0x00340000
#define SAVE_SIGNAL_NR_C06			(unsigned long *)	0x00350000
#define SAVE_SIGNAL_NR_C07			(unsigned long *)	0x00360000
#define SAVE_SIGNAL_NR_C08			(unsigned long *)	0x00370000
#define SAVE_SIGNAL_NR_C09			(unsigned long *)	0x00380000
#define SAVE_SIGNAL_NR_C10			(unsigned long *)	0x00390000
#define SAVE_SIGNAL_NR_C11			(unsigned long *)	0x003A0000
#define SAVE_SIGNAL_NR_C12			(unsigned long *)	0x003B0000
#define SAVE_SIGNAL_NR_C13			(unsigned long *)	0x003C0000
#define SAVE_SIGNAL_NR_C14			(unsigned long *)	0x003D0000
#define SAVE_SIGNAL_NR_C15			(unsigned long *)	0x003E0000
#define SAVE_SIGNAL_NR_C16			(unsigned long *)	0x003F0000

#define SAVE_SIGNAL_NR_D01			(unsigned long *)	0x00400000
#define SAVE_SIGNAL_NR_D02			(unsigned long *)	0x00410000
#define SAVE_SIGNAL_NR_D03			(unsigned long *)	0x00420000
#define SAVE_SIGNAL_NR_D04			(unsigned long *)	0x00430000
#define SAVE_SIGNAL_NR_D05			(unsigned long *)	0x00440000
#define SAVE_SIGNAL_NR_D06			(unsigned long *)	0x00450000
#define SAVE_SIGNAL_NR_D07			(unsigned long *)	0x00460000
#define SAVE_SIGNAL_NR_D08			(unsigned long *)	0x00470000
#define SAVE_SIGNAL_NR_D09			(unsigned long *)	0x00480000
#define SAVE_SIGNAL_NR_D10			(unsigned long *)	0x00490000
#define SAVE_SIGNAL_NR_D11			(unsigned long *)	0x004A0000
#define SAVE_SIGNAL_NR_D12			(unsigned long *)	0x004B0000
#define SAVE_SIGNAL_NR_D13			(unsigned long *)	0x004C0000
#define SAVE_SIGNAL_NR_D14			(unsigned long *)	0x004D0000
#define SAVE_SIGNAL_NR_D15			(unsigned long *)	0x004E0000
#define SAVE_SIGNAL_NR_D16			(unsigned long *)	0x004F0000

#define SAVE_SIGNAL_NR_E01			(unsigned long *)	0x00500000
#define SAVE_SIGNAL_NR_E02			(unsigned long *)	0x00510000
#define SAVE_SIGNAL_NR_E03			(unsigned long *)	0x00520000
#define SAVE_SIGNAL_NR_E04			(unsigned long *)	0x00530000
#define SAVE_SIGNAL_NR_E05			(unsigned long *)	0x00540000
#define SAVE_SIGNAL_NR_E06			(unsigned long *)	0x00550000
#define SAVE_SIGNAL_NR_E07			(unsigned long *)	0x00560000
#define SAVE_SIGNAL_NR_E08			(unsigned long *)	0x00570000
#define SAVE_SIGNAL_NR_E09			(unsigned long *)	0x00580000
#define SAVE_SIGNAL_NR_E10			(unsigned long *)	0x00590000
#define SAVE_SIGNAL_NR_E11			(unsigned long *)	0x005A0000
#define SAVE_SIGNAL_NR_E12			(unsigned long *)	0x005B0000
#define SAVE_SIGNAL_NR_E13			(unsigned long *)	0x005C0000
#define SAVE_SIGNAL_NR_E14			(unsigned long *)	0x005D0000
#define SAVE_SIGNAL_NR_E15			(unsigned long *)	0x005E0000
#define SAVE_SIGNAL_NR_E16			(unsigned long *)	0x005F0000
*/
#define TEST_SECTOR				(unsigned long *)	0x00600000

/* 0x00600000 - 0x006DFFFF not used */

#define WTAG_LOGO_HALF_FLASH			(unsigned long *)	0x006C0000
#define WTAG_LOGO_BIG_FLASH			(unsigned long *)	0x006D0000
// BF unused #define UI_Plane1_Flash				(unsigned long *)	0x006E0000
// BF unused #define UI_Plane2_Flash				(unsigned long *)	0x006F0000
// BF unused #define UI_Plane3_Flash				(unsigned long *)	0x00700000
// BF unused #define UI_Plane4_Flash				(unsigned long *)	0x00710000
// BF unused #define UI_Plane5_Flash				(unsigned long *)	0x00720000
// BF unused #define Channel_Plane1_Flash			(unsigned long *)	0x00730000
// BF unused #define Channel_Plane2_Flash			(unsigned long *)	0x00740000
// BF unused #define Channel_Plane3_Flash			(unsigned long *)	0x00750000
// BF unused #define Channel_Plane4_Flash			(unsigned long *)	0x00760000
// BF unused #define Channel_Math_Plane_Flash		(unsigned long *)	0x00770000
#define TRIGOTAB01				(unsigned long *)	0x00780000
#define TRIGOTAB02				(unsigned long *)	0x00790000
#define TRIGOTAB03				(unsigned long *)	0x007A0000
//#define unused				(unsigned long *)	0x007B0000
#define CONFIG_FLASH				(unsigned long *)	0x007C0000
#define CONFIG_BACKUP				(unsigned long *)	0x007D0000	
#define CALIBRATION				(unsigned long *)	0x007E0000
//#define unused				(unsigned long *)	0x007F0000	// old config sector -> not used 
/* 0x007FFFFF Flash end */

#define SAVE_SECTOR_OFFSET			16
#define FLASH_SECTOR(sno)			((unsigned long *)((sno - 1) * 0x00010000))

//#define FLASH_SECTOR_SIZE			(unsigned char)	0x00010000
#define FLASH_SECTOR_SIZE_INT			(unsigned long)	0x00004000	// 16384 uint32 = 64kbyte
#define CONFIG_SLOT_SIZE_INT			(unsigned long) 0x0000012C	// 300	uint32

#define TABSIZE 				(unsigned long)	0x1000		// 4096 points for FFT tables in flash

class AMDFlash
{

	protected:
	static unsigned long _ConfigSlot;											// slot address offset
	//static unsigned int _SlotNumber;											// only needed for debugging
	static bool _BackupConfig;												// flag for writing to backup sector

	public:
	static unsigned short GetDeviceID(void);
	static int nr_flash_erase_sector(unsigned long *sector_address);							// Erase the flash sector at sector_address.
	static int nr_flash_write_buffer(unsigned long *start_address, unsigned long *buffer, int size);			// Write a buffer of data to the flash, using bypass mode. 
//	static int amd29lv065d_flash_write_byte(unsigned char *flash_base, unsigned char *addr, unsigned char val); 		// Writes one byte to Flash
//	static int nr_flash_write(unsigned long *flash_base, unsigned long *addr, unsigned long val); 				// Writes one Value to Flash
//	static void Clear_Data_FLASH(void);											// Clear the Data Flash;

	static int WriteTraceToFlash(unsigned long *flash_address);
	static int LoadTraceSettings(unsigned long *flash_address);								//BF load settings of corresponding trace in memory
	static void LoadTracePoints(unsigned long *flash_address);								//BF load points of corresponding trace in memory
	static void ReadTraceFromFlash(unsigned long *flash_address);
    
//	static void copy_flash_to_planes(void);											// Copy the flash memory to the planes	
	static void copy_flash_to_plane(unsigned long *flash_address, unsigned long *plane);					// Copy one flash to plane
	
	static void WriteConfig(void);												// Write Config to Flash
	static void ReadConfig(void);												// Read Config from Flash
	static void WriteConfigBackup(void);											// Write config to config sector and to backup sector
	
//	static void Write_TestData_Flash(void);											// Write TestData to Flash
//	static void Read_TestData_Flash(void);	                                                				// Read TestData from Flash

	static int WriteData_Byte_Flash(unsigned long *flash_address, unsigned char add, unsigned char data);   		// Writes a Datablock at given address
	static void ReadData_Prepare_Flash(unsigned long *flash_address);
	static unsigned char ReadData_Byte_Flash(unsigned int add);

	static void WriteProtectedSector(void);											// Write Protected to Flash
	static void ReadProtectedSector(void);	                                                				// Read Protected from Flash

	static void ReadProtReg(void);												//BF #002 read protected registervalues to get factory setting
	
	static void RecallTrace(void);
	static void SaveTrace(void);
	static void RecallOverlay(void);
	
	static void GetConfigSlot(void);											//! Get actual config slot. Slot address is relative to sector address
	static unsigned long *GetConfigStartAddr(void);

	static void WriteTrigoTables(void);
	static int ReadSinCos(unsigned int points, int *SinTab, int *CosTab);
	static int ReadWindow(unsigned int points, int WinType, int *WinTab);

	static void ReadCalibration(void);
	static void WriteCalibration(void);
};

#endif 
