//#include <stdio.h>
#include "math.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
#include "floatstr_t.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"
#include "opsys_t.h"
#include "hardware_t.h"

//#define _Debug_
//#define _Debug_IRQ_
//#define _Debug_QM_
//#define _Debug_FindZero_
//#define _Debug_AutoScale_
//#define _Debug_FindVoltage_
//#define _Debug_FindTimebase_
//#define _Debug_ZeroLevel_
//#define _Debug_Cursor_
//#define _Debug_Roll_Mode_
//#define _Debug_Memory_
//#define _Debug_USB_
//#define _Debug_FFT_

int CH1_DAC_Offset = DAC_MIDSCALE;
int CH2_DAC_Offset = DAC_MIDSCALE;
int CH3_DAC_Offset = DAC_MIDSCALE;
int CH4_DAC_Offset = DAC_MIDSCALE;


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							 Class Hardware
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++




/* declare class attributes */

adc_t Hardware::_regADC[2];

unsigned int Hardware::_regExtTrgLvl = 125;
unsigned int Hardware::_regExtTrgSetup = 0x20000000;		// set address bits to external trigger;
trigSrc_t Hardware::_TriggerSource;
int Hardware::_ChannelDelay[4];
int Hardware::_ADC_VirtualZero[4];

//unsigned long Hardware::_ReadoutBuffer[5030];
unsigned char Hardware::_ADC_Offset[4][4];

// lookup table for ADC base address
static const volatile unsigned long *RegADC[4] = { (unsigned long *) na_adc1, (unsigned long *) na_adc2, (unsigned long *) na_adc3, (unsigned long *) na_adc4 };


void (* Hardware::_DelayHdl[5])(void) = {NULL, NULL, NULL, NULL, NULL};	// init delay handler
void (* Hardware::_PeriodicHdl)(void) = NULL;				// init periodic handler
uint32_t Hardware::_VSyncCounter = 0;					// VSync counter
uint32_t Hardware::_VSyncBuffer = 0;					// buffer for VSync counter
uint32_t Hardware::_DelayTimer[5];					// delay timer
uint32_t Hardware::_PeriodicTimer = 0;					// init periodic timer
uint32_t Hardware::_PTimerValue = 0;					// init timer buffer

float Hardware::_Beta = 1.0;					// ADC beta correction




/* implement class methods */

void Hardware::Init(void)						// Hardware Init Routine
{
	unsigned long ChannelSign = 0;

	printf("- Hardware initialization\r");

	na_data_adr->np_piodata = 0x01;
	na_mode->np_piodata 	= 0x01;		//reset CH3 & CH4
	na_mode->np_piodata 	= 0x00;

	//printf("Get number of channels\r\n");
	na_data_adr->np_piodata = 0x01;
	ChannelSign = ReadADC(eCh3);

	if ((ChannelSign & 0xFFFF0000) == 0x12480000)
	{ NumberOfChannels = 4;	}
	else
	{ NumberOfChannels = 2;	}
	
	data_adr->np_piodata = 0x00;

	//printf("Setup hardware\r");
	Setup_Hardware();	
	//printf("Setup hardware 				- done\r\n");

	Read_Version();	
	//printf("HW Version : %x  Channels : %d\r\n", tc_hw_version, NumberOfChannels);

	LED_FunctionTest(0);				// perform LED quick test
	
	//printf("Setup vars\r");
	Setup_Vars();
	//printf("Setup vars 				- done\r\n");

	Hardware::Set_Vars_Default();
	
	AMDFlash::ReadProtectedSector();
	
	//Setup_Interrupts();					//enable all interupts

//	key_reset->np_piodata = 0;				//reset keyboard
//	nr_delay(1);
//	key_reset->np_piodata = 1;	

//	key_int->np_pioedgecapture = 0;				// clear IRQ conditions		

//	serdata->np_piodata = ext_trg_val_reg;			// initialize external trigger
//	serstartpwm->np_piodata = 1;
//	serstartpwm->np_piodata = 0;


	AMDFlash::GetConfigSlot();				// get active config slot

	AMDFlash::ReadConfig();					// read last configuration from active slot

	if (config_loaded == false)
	{ 	Reset_To_Default();
		AMDFlash::WriteConfigBackup();
	}	// emergency exit -> that should not happen!

	
	AMDFlash::ReadCalibration();

	printf("- Hardware initialization               - done\r\n");


}

void Hardware::ResetWatchdog(void)					//Resets the WatchDog
{
	reset_watchdog->np_piodata = 0x00;				// Reset WatchDog
	reset_watchdog->np_piodata = 0x01;	
}
//#####################################################################################################################################
void Hardware::Start_Record(void)						
{

	if(acq_ready->np_piodata == 0x01)
	{
		la_pulse->np_piodata = 0x01;			//stop record Port On
		la_pulse->np_piodata = 0x00;			//stop record Port Off	

//		for(unsigned int timeout = 0;acq_ready->np_piodata == 0x01 && timeout < 0x8FFFFFFF;timeout++){}		//wait until acquisition has terminated
//		{ if (timeout > 0xFFFFFFF0 || UI_request){ ADC_DataAvailable = 1; return; } }
	}
	na_data_adr->np_piodata = 0x01;	
	ReadADC(eCh1);

	if (NumberOfChannels == 4)   				// JK
	{ ReadADC(eCh3); }              				// JK
	na_data_adr->np_piodata = 0x00;

	ADC_DataAvailable = 0;
	ADC_Started = true;

	start_acq->np_piodata = 0x01;				//start record Port On
	start_acq->np_piodata = 0x00;				//start record Port Off	
 	//printf("Start Record\r\n");
}
//#####################################################################################################################################
void Hardware::Stop_Record()							
{
	ADC_Started = false;
	la_pulse->np_piodata = 0x01;				//stop record Port On
	la_pulse->np_piodata = 0x00;				//stop record Port Off	
/*
	if (ADC_Started)
	{
		while (acq_ready->np_piodata == 0x01)
		{}
		ADC_Started = false;
	}
*/

//    READADC(1);
 //printf("Stop Record\r\n");

}
//#####################################################################################################################################
void Hardware::Read_Version(void)					//Read the hardware version
{
    la_gate->np_piodata = 0x01;
    tc_hw_version = (unsigned long) la_data->np_piodata;
    la_gate->np_piodata = 0x00;
}
//#####################################################################################################################################
void Hardware::Setup_Vars(void)						// Set standard values for variables
{
	int32_t ix, ix2, ix3;

	// assign signal pointers
	Signal[0] = SIGNAL1;
	Signal[1] = SIGNAL2;
	Signal[2] = SIGNAL3;
	Signal[3] = SIGNAL4;
	Signal[4] = SIGNALM;
	
	Maximum[0] = SIGNAL1_Buffer;
	Maximum[1] = SIGNAL2_Buffer;
	Maximum[2] = SIGNAL3_Buffer;
	Maximum[3] = SIGNAL4_Buffer;

	Minimum[0] = Filter1_Buffer;
	Minimum[1] = Filter2_Buffer;
	Minimum[2] = Filter3_Buffer;
	Minimum[3] = Filter4_Buffer;
	
	for (ix = 0;ix < 480;ix++)
	    Display_Line_Adresses[ix] = ix * 20;	//BF used in  Display::PIXELP() and in Screenshot()

	// BF -> changed Stefans initialization to 1 dimensional array
	//for (cnt = 0; cnt < 1024; cnt++)
	//SIGNAL_Histo[cnt] = 0;

	// create lookup table for sinc interpolation
	for (ix = 0; ix < 256; ix++) 
		for (ix2 = 0; ix2 < 5; ix2++) 
			for (ix3 = 0; ix3 < 9; ix3++)
			{ FIR_SincLookup[ix][ix2][ix3] = (uint32_t)FIR_Coeff[ix2][ix3] * ix; }
	
	

	// delete signals
	for (ix = 0; ix < 0x4000; ix++) {
		SIGNAL1[ix] = ADC_ZERO;
		SIGNAL2[ix] = ADC_ZERO;
		SIGNAL3[ix] = ADC_ZERO;
		SIGNAL4[ix] = ADC_ZERO;
	        SIGNALM[ix] = ADC_ZERO;
	}	

	_regADC[eFPGA1].dummy = 0;
	_regADC[eFPGA2].dummy = 0;
	_regADC[eFPGA1].unused = 0;
	_regADC[eFPGA2].unused = 0;
	
	
    	Cursor_Enabled = false;
	
	Cursor_Both_Selected_Old = 0;	
    	Cursor_Both_Selected = 0;	
	
	SelectedCursor = 0;
	SelectedCursorOld = 0;	
	
	CursorChanged = 0;
	
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Active_Old = 0; 	

	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	

	Cursor_Horizontal_Position1_Old = 103;
	Cursor_Horizontal_Position2_Old = 203;	

	Cursor_Vertical_Active = 0;
	Cursor_Vertical_Active_Old = 0;	

	Cursor_Vertical_Position_TY_1 = 100;	
	Cursor_Vertical_Position_TY_2 = 400;	

	Cursor_Vertical_Position_XY_1 = 100;
	Cursor_Vertical_Position_XY_2 = 300;

	Cursor_Vertical_Position_FFT_1 = 125;
	Cursor_Vertical_Position_FFT_2 = 475;

	Cursor_Vertical_Position1_Old = 0;
	Cursor_Vertical_Position2_Old = 0;	
/*
	Cursor_Vertical_Position_Real_XY_1 = 103;
	Cursor_Vertical_Position_Real_XY_2 = 203;	

	Cursor_Vertical_Position_XY_1_Old = 103;
	Cursor_Vertical_Position_XY_2_Old = 203;
*/	
    	QM_Enabled = false;
	QM_Changed[0] = 0;
	QM_Changed[1] = 0;
	QM_Changed[2] = 0;
	
	QM_Type[0] = 0;
	QM_Type[1] = 0;
	QM_Type[2] = 0;

	//QM_Type_Old[0] = 0;
	//QM_Type_Old[1] = 0;
	//QM_Type_Old[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 3;
	QM_Horizontal_Active_Old = 3; 	

	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Horizontal_Position1_Old = 103;
	QM_Horizontal_Position2_Old = 203;	

	QM_Vertical_Active = 3;
	QM_Vertical_Active_Old = 3;	

	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	QM_Vertical_Position1_Old = 103;
	QM_Vertical_Position2_Old = 203;		

    	Quick_Measure_Threshold_btn_select = 1;

	MainTimebase = 4;
	
	DelayedTimebase = 0;
	dmode_Window_Offset_Pos = 0;

	Selected_Voltage_CH1 = 9;
	Selected_Voltage_CH2 = 9;
	Selected_Voltage_CH3 = 9;
	Selected_Voltage_CH4 = 9;
	
	SwitchesCH1 = 0x0FD5;			// Switches for Channel 1 (including AC/DC bits for the other channels) 
	SwitchesCH2 = 0x00D5;			// only needed for the Addon driver -> Switches for Channel 2
	SwitchesCH3 = 0x00D5;			// only needed for the Addon driver -> Switches for Channel 3
	SwitchesCH4 = 0x00D5;			// only needed for the Addon driver -> Switches for Channel 4

	ScreenShotActive = 0;	
	
	USB_Data_Trans  = 0;
	USB_SendAllData = 0;
	USB_OnlyTrigger = 0;
	Run       	= 1;
	SingleShot      = 0;	
	//Single_Restart  = 0;
	
	ADC_Debug_Mode = false;
	Debug_Mode     = false;
	Command_Mode   = false;
	
	ADC_Started    = false;
	
	//adc_del_reg = 0;
	_regADC[eFPGA1].pre = 0x0000;
	_regADC[eFPGA2].pre = 0x0000;
	
	_regExtTrgLvl = 125;	// JK 0x80;

	_regADC[eFPGA1].trig_range = 0;
	_regADC[eFPGA2].trig_range = 0;
	_regADC[eFPGA1].trig_width = 0x0001;
	_regADC[eFPGA2].trig_width = 0x0001;
	
	_regADC[eFPGA1].trg_val[0] = 0x00A0;	// trigger level channel 1
	_regADC[eFPGA2].trg_val[1] = 0x00A0;	// trigger level channel 2
	_regADC[eFPGA1].trg_val[0] = 0x00A0;	// trigger level channel 3
	_regADC[eFPGA2].trg_val[1] = 0x00A0;	// trigger level channel 4
	
	_regADC[eFPGA1].trig_holdoff = 0;    	// Trigger Holdoff
	_regADC[eFPGA2].trig_holdoff = 0;       // Trigger Holdoff

	_TriggerSource = eTrigCh1;
	TriggerWay = TRIG_EDGE;

	if (NumberOfChannels == 4)
	{
		_regADC[eFPGA1].adc_ctrl = 0x8000;							// auto slope off (/AS=1), master bits off
		_regADC[eFPGA2].adc_ctrl = 0x8000;							// auto slope off (/AS=1), master bits off 
	}
	else
	{	
		_regADC[eFPGA1].adc_ctrl = 0x80C0;							// auto slope off (/AS=1), master bits off, trigger disable 3 + 4 on
		_regADC[eFPGA2].adc_ctrl = 0;								// reset to initial
	}
	
	_regADC[eFPGA1].ctrl = 0x0000;									// reset control shadow register FPGA 1
	_regADC[eFPGA2].ctrl = 0x0000;									// reset control shadow register FPGA 2

	
//	ram_adress_reg = 0;
//	test_port_reg = 0;
	
	CH1_DAC_Offset = DAC_MIDSCALE;
	CH2_DAC_Offset = DAC_MIDSCALE;
	CH3_DAC_Offset = DAC_MIDSCALE;
	CH4_DAC_Offset = DAC_MIDSCALE;

	
	_ADC_Offset[0][0] = 0;
	_ADC_Offset[0][1] = 0;
	_ADC_Offset[0][2] = 0;
	_ADC_Offset[0][3] = 0;	
	
	_ADC_Offset[1][0] = 0;
	_ADC_Offset[1][1] = 0;
	_ADC_Offset[1][2] = 0;
	_ADC_Offset[1][3] = 0;

	_ADC_Offset[2][0] = 0;
	_ADC_Offset[2][1] = 0;
	_ADC_Offset[2][2] = 0;
	_ADC_Offset[2][3] = 0;

	_ADC_Offset[3][0] = 0;
	_ADC_Offset[3][1] = 0;
	_ADC_Offset[3][2] = 0;
	_ADC_Offset[3][3] = 0;

	//set channel delay to default
	_ChannelDelay[0] = 0;
	_ChannelDelay[1] = 0;
	_ChannelDelay[2] = 0;
	_ChannelDelay[3] = 0;
	
	MenuStatus[MENU_HARDWARE][0] = 223;		//ADC registers to factory setting
	MenuStatus[MENU_HARDWARE][1] = 231;		//Gain Standard (1.25 for all ranges)
	MenuStatus[MENU_HARDWARE][3] = 351;		//ADC driver -> default is assembler driver
	
	GainIdx = 1;					//Pre Amp Gain to standard setting
	CalSet = 0;
	
	ClearPlane  = 0x00;
	DrawPlane   = 0x00;
	RemovePlane = 0x00;

	// Display settings
	GridColorArrayPos         = 1;                                          		// Normal Grid 33 %
	_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
	_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
	
	RotaryDirection         = 0;
	RotaryDirectionMemPulse = 1;
	RotarySwitch            = 0;
	RotarySteps             = 1;
	
	KeyboardMem     = 0;
	KeyboardChanged = 0;
	
	ADC_DataAvailable = 0;

	USB_Data_Trans  = false;
	USB_SendAllData = false;
	USB_OnlyTrigger = false;
	
	PopUpPosition    = 0;
	PopupTimeCounter = 0;
	
	TriggerLevelChanged = 1;								// Was Triggerlevel changed
	TriggerModeChanged  = 1;								// Was Triggermode changed
	TriggerWayChanged   = 1;								// Was Triggerway changed
	TimebaseChanged     = 1;								// Was Timebase changed
	
	TriggerLevelActive = 0;								    	// Is Triggerlevel selected ?
	TimeOffsetActive   = 0;									// Is Time_Offset selected ?
	
	StatusBtnRemove  = 0;									// remove button
	MenuPopupChanged  = 0;									// When 1 then is changed
	MenuPopupActive   = -1;									// Stores the actual Menupopup
	VoltageChangedCh1 = 1;									// Was Voltage changed
	VoltageChangedCh2 = 1;									// Was Voltage changed
	VoltageChangedCh3 = 1;									// Was Voltage changed
	VoltageChangedCh4 = 1;									// Was Voltage changed

	MenuItemPushed[0] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[1] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[2] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[3] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[4] = 0;				                    // When Menuitem is pushed drawed
	MenuItemPushed[5] = 0;				                    // When Menuitem is pushed drawed
	
	VS_ZeroLevelChanged = 0;								// zero changed
	VS_TrigLevelChanged = 0;								// triggerlevel change
	
	MenuPopupX = 0;							
	MenuPopupY = 0;
	MenuPopupSizeX = 0;
	MenuPopupSizeY = 0;
	
	MenuTimeCounter = 0;										// Counter for Menu Pulldown
	
	MenuItemCount    = 0;										// Store the count of the Menuitems
	MenuOldItemCount = 0;										// Store the count of the old Menuitems
	
	New_Menu     = -1;
	Active_Menu  = -1;
	Menu_Changed = -1;
	
	//Memory_Position = 0;

	UI_request = 0;	

	//BufferOffset = 0;		// ADC readout offset 
	ReadoutLength = 4100;		// ADC readout length


/*BF del not used
	//clear buffers
	for (cnt = 0; cnt < 32; cnt++)
	  LogicData[cnt] = 0;
*/	

}
//#####################################################################################################################################
void Hardware::Setup_Hardware(void)					// Setup the Hardware
{
	dma->np_piointerruptmask = 0x00;							// disable all IRQs
	dma->np_piodirection = 0x01;								// set all bits to output
	dma->np_piodata = 0x00;									// Set to 0

	serstartled->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartled->np_piodirection = 0x01;							// set all bits to output
	serstartled->np_piodata = 0x00;								// Set to 0

	serstartsw->np_piointerruptmask = 0x00;							// disable all IRQs
	serstartsw->np_piodirection = 0x01;							// set all bits to output
	serstartsw->np_piodata = 0x00;								// Set to 0

	serstartdac->np_piointerruptmask = 0x00;						// disable all IRQs
	serstartdac->np_piodirection = 0x01;							// set all bits to output
	serstartdac->np_piodata = 0x00;								// Set to 0

	serdata->np_piointerruptmask = 0x00;							// disable all IRQs
	serdata->np_piodirection = 0xFF;							// set all bits to output
	serdata->np_piodata = 0x00;								// Set to 0

	key_reset->np_piointerruptmask = 0x00;							// disable all IRQs
	key_reset->np_piodirection = 0x01;							// set all bits to output
	key_reset->np_piodata = 0x01;								// Set to 1

	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piodata = 0x00;								// Set to 0

	key->np_piointerruptmask = 0x00;							// disable all IRQs
	key->np_piodirection = 0x00;								// set all bits to input
	key->np_piodata = 0x00;									// Set to 0

	rot_speed_read->np_piointerruptmask = 0x00;						// disable all IRQs
	rot_speed_read->np_piodirection = 0x01;							// set all bits to output
	rot_speed_read->np_piodata = 0x00;							// Set to 0

	data_adr->np_piointerruptmask = 0x00;							// disable all IRQs
	data_adr->np_piodirection = 0x01;							// set all bits to output
	data_adr->np_piodata = 0x00;								// Set to 0
	
	mode->np_piointerruptmask = 0x00;							// disable all IRQs
	mode->np_piodirection = 0x01;								// set all bits to output
	mode->np_piodata = 0x00;								// Set to 0
	
	start_acq->np_piointerruptmask = 0x00;							// disable all IRQs
	start_acq->np_piodirection = 0x01;							// set all bits to output
	start_acq->np_piodata = 0x00;								// Set to 0

	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	acq_ready->np_piodirection = 0x00;							// set all bits to input
	acq_ready->np_piodata = 0x00;								// Set to 0

	reset_watchdog->np_piointerruptmask = 0x00;						// disable all IRQs
	reset_watchdog->np_piodirection = 0x01;							// set all bits to output
	reset_watchdog->np_piodata = 0x00;							// Set to 0

	la_data->np_piointerruptmask = 0x00;							// disable all IRQs
	la_data->np_piodirection = 0x00;							// set all bits to input
	la_data->np_piodata = 0x00;								// Set to 0

	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
	la_interrupt->np_piodirection = 0x00;							// set all bits to input
	la_interrupt->np_piodata = 0x00;							// Set to 0

	la_gate->np_piointerruptmask = 0x00;							// disable all IRQs
	la_gate->np_piodirection = 0x01;							// set all bits to output
	la_gate->np_piodata = 0x00;									// Set to 0

	la_pulse->np_piointerruptmask = 0x00;							// disable all IRQs
	la_pulse->np_piodirection = 0x01;							// set all bits to output
	la_pulse->np_piodata = 0x00;								// Set to 0

	//out_test->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	//out_test->np_piodirection = 0x01;							// set all bits to output
	//out_test->np_piodata = 0x08;

	boot_reset_key->np_piointerruptmask = 0x00;						// disable all IRQs
	boot_reset_key->np_piodirection = 0x00;							// set all bits to input
	boot_reset_key->np_piodata = 0x00;							// Set to 0

	power_on_boot_key->np_piointerruptmask = 0x00;						// disable all IRQs
	power_on_boot_key->np_piodirection = 0x00;						// set all bits to input
	power_on_boot_key->np_piodata = 0x00;							// Set to 0
	
	//key_test->np_piointerruptmask = 0x00;							// disable all IRQs
	//key_test->np_piodirection = 0x00;							// set all bits to input
	//key_test->np_piodata = 0x00;			

	/* -> available but not needed
	na_flash_ry_by->np_piointerruptmask = 0x00;						// disable all IRQs
	na_flash_ry_by->np_piodirection = 0x00;							// set all bits to input
	na_flash_ry_by->np_piodata = 0x00;							// Set to 0
	*/

    if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("No Keyboard found\r\n");
        keyboard_found = 1;
    } 
	else if ((boot_reset_key->np_piodata == 0x01) && (power_on_boot_key->np_piodata == 0x00)) {
        printf("Power on Boot Pressed\r\n");
        keyboard_found = 2;
    } 
	else if ((boot_reset_key->np_piodata == 0x00) && (power_on_boot_key->np_piodata == 0x01)) {
        printf("Reset on Boot Pressed\r\n");
        keyboard_found = 3;
    } else {
        //printf("Keyboard found\r\n");
        keyboard_found = 4;
    }

	//triggering = 0;
}
//#####################################################################################################################################
void Hardware::Setup_Interrupts(void)					// Setup the Interrupts
{
	if (keyboard_found == 4)
	{
		DoEnableKeyInterrupt();
		DoEnableRotInterrupt();
	}
	
	DoEnableUARTInterrupt();
	DoEnableUART2Interrupt();
	DoEnableADCInterrupt();	
	EnableVSyncInterrupt();
	//DoEnableLogicAnalyserInterrupt();
	DoEnableTimer1Interrupt();
	DoEnableTimer2Interrupt();
	DoEnableTimer3Interrupt();	
}
//#####################################################################################################################################
//BF #010
void Hardware::Disable_All_Interrupts(void)					// Disable the Interrupts
{
	if (keyboard_found == 4)
	{
		DoDisableKeyInterrupt();
		DoDisableRotInterrupt();
	}
	
	DoDisableUARTInterrupt();
	DoDisableUART2Interrupt();
	DoDisableADCInterrupt();	
	DisableVSyncInterrupt();
	//    DoDisableLogicAnalyserInterrupt();
	DoDisableTimer1Interrupt();
	DoDisableTimer2Interrupt();
	DoDisableTimer3Interrupt();	
}
//#####################################################################################################################################
void Hardware::Set_Vars_Default(void)					//Resets all vars to standard values
{
	int cnt;
	
	// Main/Delayed - Timebase
	MenuStatus[MENU_TIMEBASE][0] = BTN_ON;				// Main
	MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;				// Delayed
	MenuStatus[MENU_TIMEBASE][2] = BTN_OFF;				// XY-Mode
	MenuStatus[MENU_TIMEBASE][3] = BTN_OFF;				// FFT-Mode
	MenuStatus[MENU_TIMEBASE][4] = BTN_OFF;				// Timebase - Browse off
	Memory_Window_visible = 0;

	MenuStatus[MENU_USTB][0] = USTB_ROLL;                     	// Roll-Mode 
	MenuStatus[MENU_USTB][1] = USTB_PERM;				// Display -> permanent
	MenuStatus[MENU_USTB][2] = USTB_16KB;				// Buffer size 16KB

	MenuStatus[MENU_UTILITY][4] = BTN_OFF;				// switch off test signal generator

	XY_Mode       = 0;						// Normal Mode - No XY-Mode
	USTB_Mode     = USTB_OFF;					// ultra slow timebase off	
	USTB_Mode_bak = USTB_ROLL;

	UI_request  = 0;						//BF flag for user interface activity
	QP_request  = 0;						//BF flag Quick Print requested
	ZL_changed  = 0;						//BF OnZero Channel -> only draw signal with changed zerolevel
	AS_request  = 0;						//BF auto scale requested
	RC_request  = 0;						//BF signal recall requested
	RC_overlay  = 0;

	CRS_Delta   = 1;						//BF delta cursor on/off

	UART_NewData = 0;
	UART_RXData  = -1;
	
//BF ins	
	//Trig_Pos_Mem             = 300; 
	Trig_Pos_Display           = 300;
	Trig_Pos_Display_dmode     = 300;
	Trig_Pos_Mem               = 300;
	Trig_Pos_Mem_old           = 300;	
	Trig_Pos_Display_old       = 300;
	Trig_Pos_Display_dmode_old = 300;	
	MemWinStart                = 0;
	MemWinStart_old            = -300;

// BF end
	
	dmode_Window_Offset_Pos = 0;

	MainTimebase       = 4;                                        	// Displayed timebase is 50 ns
	VirtualTimebase	   = 0;

	DelayedTimebase = 0;                                    // delayed timebase is 20 ns
	Timebase_Ratio = 0;                                             // factor for delayed windows cursor calculation

	ACQ_HighSpeed = 1;
	
	Cursor_Delayed_1    = 180;                                      // Delayed windows cursor position 1
	Cursor_Delayed_2    = 420;                                      // Delayed windows cursor position 2
	Cursor_Delayed_Size = 240;                                      // Delayed windows size

	Run  = 1;                                                 	// Running

	CalSet = 0;
	MenuStatus[MENU_UTILITY][3] = 264;					// calibration set standard
	Display::MenuPopupInit(19, MENU_UTILITY, 264);	

			
	//BF set zero levels to default
	if (NumberOfChannels == 2)
	{
		ZeroLevelCH1 = (int)(GRID_HEIGHT / 4);		// 1/4 grid height
		ZeroLevelCH2 = (int)((GRID_HEIGHT / 4) * 3);	// 3/4 grid height
		ZeroLevelCH3 = (int)(GRID_HEIGHT >> 1);	
		ZeroLevelCH4 = (int)(GRID_HEIGHT >> 1);
	}
	else
	{
		//ZeroLevelCH1 = (int)(GRID_HEIGHT / 5.333);			//10% line
		ZeroLevelCH1 = (int)(GRID_HEIGHT / 8);				// first div
		ZeroLevelCH2 = (int)((GRID_HEIGHT / 8) * 3);			//third div
		ZeroLevelCH3 = (int)((GRID_HEIGHT / 8) * 5);			//fifth div
		ZeroLevelCH4 = (int)((GRID_HEIGHT / 8) * 7);			// last div
		//ZeroLevelCH4 = (int)(GRID_HEIGHT - (GRID_HEIGHT / 5.333));	//90% line
	}

	ZeroLevelCH1_Old = ZeroLevelCH1;
	ZeroLevelCH2_Old = ZeroLevelCH2;
	ZeroLevelCH3_Old = ZeroLevelCH3;
	ZeroLevelCH4_Old = ZeroLevelCH4;

	Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2);	//Virtual zeroes are related to 1/2 grid height,
	Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2);	//means that VZero = 0 is the middle of the grid
	Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2);	
	Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2);
	
	Virtual_ZeroLevelXYCH1 = 0;	// 0 = middle of the grid
	Virtual_ZeroLevelXYCH2 = 0;	// 0 = middle of the grid
	Virtual_ZeroLevelXYCH3 = 0;	// 0 = middle of the grid	
	Virtual_ZeroLevelXYCH4 = 0;	// 0 = middle of the grid
	
	
	/* Trigger settings */
	
	MenuStatus[MENU_TRIGGERMODE][0] = TRIG_AUTO;                                   // Triggering - Auto
	MenuStatus[MENU_TRIGGERMODE][1] = 95;                                         // Triggering - Coupling DC
	MenuStatus[MENU_TRIGGERMODE][4] = 104;                                        // Triggering - External Probe 1:1
		
	MenuBtnFocus[MENU_TRIGGERMODE] = 4;						// set focus -> holdoff inactive / probe button active

	
	// Trigger Edge
	MenuStatus[MENU_TRIGGEREDGE][0] = 2;                                          // Triggering - positive edge
	MenuStatus[MENU_TRIGGEREDGE][1] = TRIG_CH1;                                   // Triggering - Source = channel 1 #019
	MenuStatus[MENU_TRIGGEREDGE][2] = 246;                                        // Triggering - no externel triggering #019
	MenuStatus[MENU_TRIGGEREDGE][3] = 246;                                        // Triggering - no externel TV triggering #019
	Display::MenuPopupInit(28, MENU_TRIGGEREDGE, TRIG_CH1);	
	//init extern trigger menu #019
	MenuPopupStatus[8][0] = 3;
	MenuPopupStatus[8][1] = 2;
	MenuPopupStatus[8][2] = 2;
	//init TV trigger menu #019
	MenuPopupStatus[11][0] = 3;
	MenuPopupStatus[11][1] = 2;


	// Trigger Pulse
	MenuStatus[MENU_PULSEWIDTH][0] = 137;                                        // Triggering - Source Channel 1
	//MenuStatus[MENU_PULSEWIDTH][1] = 2;                                          // Triggering - Negative Pulse
	MenuStatus[MENU_PULSEWIDTH][2] = 3;                                          // Triggering - bigger - smaller - then
	
	_TriggerSource = eTrigCh1;

	//BF set trigger levels
	Trigger_Pos_CH1 = ZeroLevelCH1;					// Trigger Level Channel 1
	Trigger_Pos_CH2 = ZeroLevelCH2;					// Trigger Level Channel 2
	Trigger_Pos_CH3 = ZeroLevelCH3;					// Trigger Level Channel 3
	Trigger_Pos_CH4 = ZeroLevelCH4;					// Trigger Level Channel 4
	Trigger_Pos_CHE = 61;						// Trigger Level Extern Trigger Source JK old 56
	
	Trigger_Pos_CH1_Old = ZeroLevelCH1;
	Trigger_Pos_CH2_Old = ZeroLevelCH2;
	Trigger_Pos_CH3_Old = ZeroLevelCH3;
	Trigger_Pos_CH4_Old = ZeroLevelCH4;
	Trigger_Pos_CHE_Old = 61;		// JK 56

	//trg_val_reg = 0xB1;                                       	// Trigger Value
	//trg_hyst_reg = 0xA9;                                		// Trigger Hysterese

	_regADC[eFPGA1].trg_val[0] = 0x00A0;	// trigger level channel 1
	_regADC[eFPGA2].trg_val[1] = 0x00A0;	// trigger level channel 2
	_regADC[eFPGA1].trg_val[0] = 0x00A0;	// trigger level channel 3
	_regADC[eFPGA2].trg_val[1] = 0x00A0;	// trigger level channel 4

	_regExtTrgLvl = 125;	// JK 0x80;                             		// Triggr Level Register Extern Trigger (0.00V)
	
	_regADC[eFPGA1].trig_range = 0;
	_regADC[eFPGA2].trig_range = 0;
	_regADC[eFPGA1].trig_width = 0x0001;
	_regADC[eFPGA2].trig_width = 0x0001;

	_regADC[eFPGA1].trig_holdoff = 0;                  		// Trigger Holdoff
	_regADC[eFPGA2].trig_holdoff = 0;                  		// Trigger Holdoff
	
	_regADC[eFPGA1].pre = 0x006C;					// PreTrigger Value
	_regADC[eFPGA2].pre = 0x006C;					// PreTrigger Value

	if (NumberOfChannels == 4)
	{
		_regADC[eFPGA1].adc_ctrl = 0x8101;							// auto slope off (/AS=1), master bit 1, source 1
		_regADC[eFPGA2].adc_ctrl = 0x8101;							// auto slope off (/AS=1), master bit 1, source 1 
	}
	else
	{	
		_regADC[eFPGA1].adc_ctrl = 0x81C1;							// auto slope off (/AS=1), trigger disable 3 + 4, master bit 1, source 1
		_regADC[eFPGA2].adc_ctrl = 0;								// reset
	}
	
	_regADC[eFPGA1].ctrl = 0x0047;									// auto, rising, intern, select - FPGA 1
	_regADC[eFPGA2].ctrl = 0x0047;									// auto, rising, intern, select - FPGA 1

	ACQ_ManTrigg = 0;						// manual trigger off

	TriggerWay = TRIG_EDGE;                                         // Edge
	
	
	HoldOff_Value = 0;
	HoldOff_Expo  = 1;   //ns
	HoldOff_Steps = 8;   //40;
	
	Pulse11_Value = 16;
	Pulse11_Expo  = 1;   //ns
	Pulse11_Steps = 8;
	
	Pulse12_Value = 8;
	Pulse12_Expo  = 1;   //ns
	Pulse12_Steps = 8;
	
	Pulse21_Value = 16;
	Pulse21_Expo  = 1;   //ns
	Pulse21_Steps = 8;
	
	Pulse22_Value = 16;
	Pulse22_Expo  = 1;   //ns
	Pulse22_Steps = 8;

	math_scale     = 11;	//BF added -> 5V default
	math_mul_scale = 177;	//BF -> 5V
	math_sub_scale = 161;	//BF -> 5V 
	math_add_scale = 161;	//BF -> 5V
	
	//BF added for new offset calculation
	Math_Offset     = 0;
	Math_Mul_Offset = 0;
	Math_Sub_Offset = 0;
	Math_Add_Offset = 0;
	
	Math_Offset_mul.Init(0.000001, 0.000001, 1000, 0.000001, 2, 3, "", "", "V");
	Math_Offset_mul.RenderText();
	Math_Offset_add.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_add.RenderText();
	Math_Offset_sub.Init(0.001, 0.001, 1000, 0.001, 2, 3, "", "", "V");
	Math_Offset_sub.RenderText();

	// Channel 1
	Channel[eCh1].active = 1;					// Channel 1 active
	ChannelStatusOld[eCh1] = 1;					// Channel 1 backup
	                                    
	MenuStatus[MENU_CHANNEL1][0] = 8;                               // Channel 1 - Coupling AC
	MenuStatus[MENU_CHANNEL1][1] = BTN_OFF;                             // Channel 1 - BW Limit off
	MenuStatus[MENU_CHANNEL1][2] = BTN_OFF;                             // Channel 1 - Invert off
	MenuStatus[MENU_CHANNEL1][3] = 104;                             // Channel 1 - Probe 1.0 : 1
	
	MenuPopupStatus[13][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[13][1] = 2;
	MenuPopupStatus[13][2] = 3;
	
	SwitchesCH1 = MenuStatus[MENU_HARDWARE][1] == ADD_ON ? 0x0F3A : 0x0F1A;	// Switches for Channel 1 and for the other the AC bit
	
 	SwitchesLMH[0] = 0x040A; // LMH6518 default config: aux amp disabled, no filter, low gain, max. attenuation
	//SwitchesCH1 = 0x0F1A;                                           // Switches for Channel 1 and for the other the AC bit
	
	Selected_Voltage_CH1 = e5V;                                      // Voltage 5V
	
	// Channel2
	Channel[eCh2].active = 1;					// Channel 2 active
	ChannelStatusOld[eCh2] = 1;					// Channel 2 backup
	
	MenuStatus[MENU_CHANNEL2][0] = 8;                               // Channel 2 - Coupling AC
	MenuStatus[MENU_CHANNEL2][1] = BTN_OFF;                             // Channel 2 - BW Limit off
	MenuStatus[MENU_CHANNEL2][2] = BTN_OFF;                             // Channel 2 - Invert off
	MenuStatus[MENU_CHANNEL2][3] = 104;                             // Channel 2 - Probe 1.0 : 1
	
	MenuPopupStatus[14][0] = 2;                                     // Popup Coupling = DC
	MenuPopupStatus[14][1] = 2;
	MenuPopupStatus[14][2] = 3;

	SwitchesCH2 =  0x003A; 					        // only needed for the Addon driver -> Switches for Channel 2
	SwitchesLMH[1] = 0x040A; 					// LMH6518 default config: aux amp disabled, no filter, low gain, max. attenuation

	Selected_Voltage_CH2 = 11;                                      // Voltage 5V
	
	if (NumberOfChannels == 4)
	{
		// Channel 3
		Channel[eCh3].active = 1;					// Channel 3 active
		ChannelStatusOld[eCh3] = 1;					// Channel 3 backup
		
		MenuStatus[MENU_CHANNEL3][0] = 8;                               // Channel 3 - Coupling AC
		MenuStatus[MENU_CHANNEL3][1] = BTN_OFF;                             // Channel 3 - BW Limit off
		MenuStatus[MENU_CHANNEL3][2] = BTN_OFF;                             // Channel 3 - Invert off
		MenuStatus[MENU_CHANNEL3][3] = 104;                             // Channel 3 - Probe 1.0 : 1
	
		MenuPopupStatus[15][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[15][1] = 2;
		MenuPopupStatus[15][2] = 3;

		SwitchesCH3 = 0x043A;            				// only needed for the Addon driver -> Switches for Channel 3
		SwitchesLMH[2] = 0x040A; 					// LMH6518 default config: aux amp disabled, no filter, low gain, max. attenuation

		Selected_Voltage_CH3 = e5V;                                      // Voltage 5V
	
		// Channel 4
		Channel[eCh4].active = 1;					// Channel 4 active
		ChannelStatusOld[eCh4] = 1;					// Channel 4 backup
		
		MenuStatus[MENU_CHANNEL4][0] = 8;                           	// Channel 4 - Coupling AC
		MenuStatus[MENU_CHANNEL4][1] = BTN_OFF;                         	// Channel 4 - BW Limit off
		MenuStatus[MENU_CHANNEL4][2] = BTN_OFF;                         	// Channel 4 - Invert off
		MenuStatus[MENU_CHANNEL4][3] = 104;                         	// Channel 4 - Probe 1.0 : 1
	
		MenuPopupStatus[16][0] = 2;                                     // Popup Coupling = DC
		MenuPopupStatus[16][1] = 2;
		MenuPopupStatus[16][2] = 3;
	
		SwitchesCH4 = 0x083A;						// only needed for the Addon driver -> Switches for Channel 4
		SwitchesLMH[3] = 0x040A; 					// LMH6518 default config: aux amp disabled, no filter, low gain, max. attenuation
		
		Selected_Voltage_CH4 = 11;                                      // Voltage 5V
	}
	else
	{
		// Channel 3
		Channel[eCh3].active = 0;					// Channel 3 inactive
		ChannelStatusOld[eCh3] = 0;					// Channel 3 backup must be 0
		// Channel 4
		Channel[eCh4].active = 0;					// Channel 4 inactive
		ChannelStatusOld[eCh4] = 0;					// Channel 4 backup must be 0
	}

	Channels_Active = NumberOfChannels;

	Channel[eChM].active = 0;                                      		// Math channel off
	ChannelStatusOld[eChM] = 0;						// Channel Math backup must be 0
	//MenuStatus[MENU_MATH][1] = BTN_OFF;    				// not used 
	MenuStatus[MENU_MATH][2] = BTN_OFF;					// math 1*2 off
	MenuStatus[MENU_MATH][3] = BTN_ON;					// math 1-2 on
	MenuStatus[MENU_MATH][4] = BTN_OFF;					// math 1+2 off

	math_mul_scale = 177;							//5V	math scaling default setting
	math_sub_scale = 161;							//5V	math scaling default setting
	math_add_scale = 161;							//5V	math scaling default setting
 
	MenuStatus[MENU_FFT][0] = 137;                                          // source = channel 1
	MenuStatus[MENU_FFT][1] = 193;                                          // window = rectangle
	MenuStatus[MENU_FFT][2] = 66;                                          	// mode   = linear
	MenuStatus[MENU_FFT][3] = 83;                                          	// length = 512
	
	Signal::_FFT_Mode    = FFT_OFF;						// FFT off
	Signal::_FFT_Length  = FFT_512;
	Signal::_FFT_Level   = 9;						// FFT_Level = ld(FFT_Length)
	Signal::_FFT_Windex  = -1;						// FFT window index default is rect
	FFT_NewData = 0;

//BF not needed anymore	FFT_Scale   = 2;
	
	GainIdx = MenuStatus[MENU_HARDWARE][1] - 230;				//BF #004 set gain of input stage

	SavePointer = 1;

	// Cursors
	MenuStatus[MENU_CURSOR][0] = 27;                                         // Cursor source = channel 1
	
	Cursor_Enabled = false;
	Cursor_Both_Selected = 0;	
	SelectedCursor = 0;
	Cursor_Horizontal_Active = 0;
	Cursor_Horizontal_Position_Real1 = 103;
	Cursor_Horizontal_Position_Real2 = 203;	
	Cursor_Vertical_Active = 0;

	Cursor_Vertical_Position_TY_1 = 100;	
	Cursor_Vertical_Position_TY_2 = 400;	

	Cursor_Vertical_Position_XY_1 = 100;
	Cursor_Vertical_Position_XY_2 = 300;

	Cursor_Vertical_Position_FFT_1 = 125;
	Cursor_Vertical_Position_FFT_2 = 475;


    	// Quick Measure
	QM_Enabled = false;
	
	QM_Type[0] = 5;
	QM_Type[1] = 8;
	QM_Type[2] = 0;
	
	QM_Channel[0] = 1;
	QM_Channel[1] = 1;
	QM_Channel[2] = 1;	
    	
	QM_Horizontal_Active = 0;
	QM_Horizontal_Position_Real1 = 103;
	QM_Horizontal_Position_Real2 = 203;	

	QM_Vertical_Active = 0;
	QM_Vertical_Position_Real1 = 103;
	QM_Vertical_Position_Real2 = 203;	

	Quick_Measure_Threshold_btn_select = 1;
	
	QM_Source = MenuStatus[MENU_QUICKMEASURE][0] = 27;	
	MenuStatus[MENU_QUICKMEASURE][1] = 52;
	MenuStatus[MENU_QUICKMEASURE][2] = 52;
	MenuStatus[MENU_QUICKMEASURE][4] = 244;			// gray out button

	MenuStatus[MENU_QMDELAY][0] = 27;
	MenuStatus[MENU_QMDELAY][1] = 2;
	MenuStatus[MENU_QMDELAY][2] = 28;
	MenuStatus[MENU_QMDELAY][3] = 2;
	MenuStatus[MENU_QMPHASE][0] = 27;
	MenuStatus[MENU_QMPHASE][2] = 28;

	MenuStatus[MENU_QMTHRESHOLDS][0] = 27;
	MenuStatus[MENU_QMTHRESHOLDS][1] = 49;


	for (int i=0;i<5;i++)
	{
		thres_low[i] = 10;						// QM thresholds -> 10%
		thres_mdl[i] = 50;						// QM thresholds -> 50%
		thres_up[i]  = 90;						// QM thresholds -> 90%
		thres_type[i] = 49;						// QM thresholds -> percent
	}

	// Display settings
	//ColorPalette      = 0;						// standard colors
	GridColorArrayPos = 1;                                          	// Normal Grid 33 %
	_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
	_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb

	//BF not used GridColorArrayPos_Delayed = 1;                           	// Delayed Grid 33 %
	//BF not used GridColor_Val_Delayed     = 0x15;                        	// GridColore Gray

 	MenuStatus[MENU_DISPLAY][0] = 360;     		                        // Display - Persist off
	MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;                  // Display - Grid 33%
	MenuStatus[MENU_DISPL_FFT][2] = GridColorArrayPos + 133;                // Display - Grid 33%
	MenuStatus[MENU_DISPLAY][4] = DRAW_FAST;				// Display - Draw Mode

	MenuStatus[MENU_DISPLAY][3] = 320;					// no display -> all channels off
	for(int i=0;i<4;i++)NoDisplay[i] = 0;					// no display -> all channels off

	if ( MenuStatus[MENU_DISPL_SETUP][3] != BTN_ON && MenuStatus[MENU_DISPL_SETUP][3] != BTN_OFF)
	MenuStatus[MENU_DISPL_SETUP][3] = BTN_OFF;

	// Aquire
	MenuStatus[MENU_ACQUIRE][0] = LOGA_OFF;					// Acquire - Logic		-> Off
	MenuStatus[MENU_ACQUIRE][1] = AVRG_OFF;					// Acquire - Average		-> Off
	MenuStatus[MENU_ACQUIRE][2] = FILT_OFF;					// Acquire - Noise Filter 	-> Off
	MenuStatus[MENU_ACQUIRE][3] = 42;					// Acquire - Interpolation	-> Linear
	ACQ_Average = 0;
	LA_active = 0;
	FilterType = PRO;


	// LEDs
	LED_ON[0] = 1;			                                        // Select Channel 1
	LED_ON[1] = 1;			                                        // Select Channel 2
	if (NumberOfChannels == 4)
	{
		LED_ON[2] = 1;			                                        // Select Channel 3
		LED_ON[3] = 1;			                                        // Select Channel 4
	}
	else
	{
		LED_ON[2] = 0;			                                        // Select Channel 3
		LED_ON[3] = 0;			                                        // Select Channel 4
	}
	LED_ON[4] = 0;			                                        // Select Channel Math
	LED_ON[5] = 0;			                                        // General (multi purpose)
	LED_ON[6] = 0;			                                        // Cursor
	LED_ON[7] = 0;			                                        // Quick Measure
	LED_ON[8] = 1;			                                        // Edge
	LED_ON[9] = 0;			                                        // Pattern - Not Used
	LED_ON[10] = 0;			                                        // Pulse Width
	LED_ON[11] = 0;			                                        // More - Not Used
	LED_ON[12] = 1;			                                        // Run/Stop Green
	LED_ON[13] = 0;			                                        // Run/Stop Red
	LED_ON[14] = 0;			                                        // Single Red
//	LED_ON[15] = 0;			                                        // Single Green

	if (MenuStatus[MENU_TRIGGERSUB][3] == 126)				// Single Green
	LED_ON[15] = 1;
	else
	LED_ON[15] = 0;

	S1Ptr = SIGNAL1;	// pointer to signal 1
	S2Ptr = SIGNAL2;	// pointer to signal 2
	S3Ptr = SIGNAL3;	// pointer to signal 3
	S4Ptr = SIGNAL4;	// pointer to signal 4
	SMPtr = SIGNALM;	// pointer to signal math

	RemovePlane |= 0x1F;
	
	ClearPlanes();
		
}

//#####################################################################################################################################

void Hardware::DoEnableKeyInterrupt(void)							// Enable Keyboard service routine
{
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	key_int->np_piodirection = 0x00;							// set all bits to input
	key_int->np_piointerruptmask = 0x01;							// enable Keyboard IRQ

	key_reset->np_piodata = 0;								// Reset Keyboard
	nr_delay(2);
	key_reset->np_piodata = 1;
	
	key_int->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions	

	nr_installuserisr(na_key_interrupt_irq,ISR_KEY,(int)key_int);	// Install ISR for Keyboard
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nKEY interrupt enabled.\n"); 							// print on console
#endif
}
//#####################################################################################################################################

void Hardware::DoDisableKeyInterrupt(void)							// disable keyboard I/O service routine
{
	nr_installuserisr(na_key_interrupt_irq,0,0); 					// Install empty routine for Keyboard irq
	key_int->np_piointerruptmask = 0x00;							// disable all IRQs
}
//#####################################################################################################################################

void Hardware::ISR_KEY(int context)								// keyboard interrupt subroutine
{
	KeyboardMem = key->np_piodata;								// get interrupt keyboad data

												// reset keyboard
	key_reset->np_piodata = 0;								// start reset pulse
	nr_delay(2);
	key_reset->np_piodata = 1;								// end reset pulse
	key_int->np_pioedgecapture = 0;								// clear IRQ conditions	
	
	KeyboardChanged = 1;

	UI_request = 1;	

	//printf("\r\nKEY interrupt occured %x(%d).\r\n",KeyData,KeyData ); 			// print on console
}
//#####################################################################################################################################
//BF register docu by JK
/*!
	MSB	_regADC[eFPGA1].adc_ctrl		  		MSB	_regADC[0].ctrl / _regADC[1].ctrl
	---------------------------			-----------------------------------------
	8 - ?						8 - ?
	4 - ?						4 - ?
	2 - ?						2 - 1 = Holdoff enable
	1 - ?						1 - 1 = Pulswidth enable
	---------------------------			-----------------------------------------
	8 - 1 = Ch 4 Masterbit				8 - 1 = Pulsewidth Range
	4 - 1 = Ch 3 Masterbit				4 - 1 = Pulsewidth less than
	2 - 1 = Ch 2 Masterbit				2 - 1 = Pulsewidth greater than
	1 - 1 = Ch 1 Masterbit				1 - ? Zero adjust?
	---------------------------			-----------------------------------------
	8 - 2 Ch = 1 / 4 Ch = 0	trigger disable		8 - 1 = Trigger Master enable
	4 - 2 Ch = 1 / 4 Ch = 0				4 - 0 = Normal / 1 = Auto
	2 - ?						2 - ?
	1 - ?						1 - ?
	---------------------------			-----------------------------------------
	8 - 1 = Triggersource Ch 4			8 - ?
	4 - 1 = Triggersource Ch 3			4 - 0 = falling / 1 = rising edge
	2 - 1 = Triggersource Ch 2			2 - 0 = external / 1 = internal trigger
	1 - 1 = Triggersource Ch 1			1 - 1 = SL
	---------------------------			-----------------------------------------
	LSB						LSB

*/
void Hardware::SetupTrigger(void)
{
	unsigned char trigLevel;
	float gain;
	int offs;
	
	//---------------------------------------------------
	//		Special case free run
	//---------------------------------------------------
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_FREE || USTB_Mode != USTB_OFF)		// free run
	{
		CaptureTrigSetMode(eTrigFreerun);
		return;
	}	

	//Stop_Record();	
	
	//---------------------------------------------------
	//		Initialization
	//---------------------------------------------------

/*	if (NumberOfChannels == 4)
	{
		_regADC[eFPGA1].adc_ctrl = 0x8000;							// auto slope off (/AS=1), master bits off
		_regADC[eFPGA2].adc_ctrl = 0x8000;							// auto slope off (/AS=1), master bits off 
	}
	else
	{	
		_regADC[eFPGA1].adc_ctrl = 0x80C0;							// auto slope off (/AS=1), master bits off, trigger disable 3 + 4 on
		_regADC[eFPGA2].adc_ctrl = 0;								// reset to initial
	}
	
	_regADC[eFPGA1].ctrl = 0x0000;									// reset control shadow register FPGA 1
	_regADC[eFPGA2].ctrl = 0x0000;									// reset control shadow register FPGA 2
*/	
	trigLevel = 0;
	
	if (MenuStatus[MENU_TRIGGEREDGE][0] == 2)						// rising
	{ offs = 11; gain = 0.985;}								// trigger correction
	else											// falling
	{ offs = -22; gain = 0.985;}								// trigger correction
	
	//---------------------------------------------------
	//		Holdoff
	//---------------------------------------------------

	CaptureTrigSetHoldoff((unsigned int)(HoldOff.Read_Value() * 125000000));

		
	//---------------------------------------------------
	//		Edge Triggering
	//---------------------------------------------------

	if (TriggerWay == TRIG_EDGE)
    	{
		CaptureTrigSetType(eTrigEdge);							// set edge triggering
		
		CaptureTrigSetEdge((trigEdgeSel_t)(MenuStatus[MENU_TRIGGEREDGE][0] - 2));	// set edge rising/falling
		
		/* set trigger source for edge trigger */
		if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_ALT)				// set alternating trigger source
		{
			if (_TriggerSource == eTrigCh1)
			{
				if (Channel[eCh2].active) _TriggerSource = eTrigCh2;
				else if (Channel[eCh3].active) _TriggerSource = eTrigCh3;
				else if (Channel[eCh4].active) _TriggerSource = eTrigCh4;
			}
			else if (_TriggerSource == eTrigCh2)
			{
				if (Channel[eCh3].active) _TriggerSource = eTrigCh3;
				else if (Channel[eCh4].active) _TriggerSource = eTrigCh4;
				else if (Channel[eCh1].active) _TriggerSource = eTrigCh1;
			}
			else if (_TriggerSource == eTrigCh3)
			{
				if (Channel[eCh4].active) _TriggerSource = eTrigCh4;
				else if (Channel[eCh1].active) _TriggerSource = eTrigCh1;
				else if (Channel[eCh2].active) _TriggerSource = eTrigCh2;
			}
			else if (_TriggerSource == eTrigCh4)
			{
				if (Channel[eCh1].active) _TriggerSource = eTrigCh1;
				else if (Channel[eCh2].active) _TriggerSource = eTrigCh2;
				else if (Channel[eCh3].active) _TriggerSource = eTrigCh3;
			}

		}
		else if (MenuStatus[MENU_TRIGGEREDGE][1] < TRIG_ALT)							
		{ _TriggerSource = (trigSrc_t)(MenuStatus[MENU_TRIGGEREDGE][1] - TRIG_CH1); }	// set trigger source 0 - 3
		else
		{ _TriggerSource = (trigSrc_t)(MenuStatus[MENU_TRIGGEREDGE][1] - TRIG_CH2); }	// set trigger source 5 - 6
		

		/* trigger source depending settings */
		if (_TriggerSource == eTrigCh1)							// Source = channel 1
		{
			if (Trigger_Pos_CH1 < GRID_HEIGHT && Trigger_Pos_CH1 > 0)
			{ trigLevel = (unsigned char)((float)(Trigger_Pos_CH1 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH1]) + ADC_ZERO; } 
		}
		else if (_TriggerSource == eTrigCh2)						// Source = channel 2
		{			
			if (Trigger_Pos_CH2 < GRID_HEIGHT && Trigger_Pos_CH2 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH2 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH2]) + ADC_ZERO; }
		}
		else if (_TriggerSource == eTrigCh3)						// Source = channel 3
		{			
			if (Trigger_Pos_CH3 < GRID_HEIGHT && Trigger_Pos_CH3 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH3 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH3]) + ADC_ZERO; }	
		}
		else if (_TriggerSource == eTrigCh4)						// Source = channel 4
		{
			if (Trigger_Pos_CH4 < GRID_HEIGHT && Trigger_Pos_CH4 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH4 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH4]) + ADC_ZERO; }
		}
		else if (_TriggerSource == eTrigExt)						// Source = external
		{
			// external source
			if (MenuStatus[MENU_TRIGGEREDGE][2] == 128)
			TriggerSetExtSrc(eTrigSrcLF);						// set external source LF
			else if (MenuStatus[MENU_TRIGGEREDGE][2] == 129)
			TriggerSetExtSrc(eTrigSrcHF);						// set external source HF
			else if (MenuStatus[MENU_TRIGGEREDGE][2] == 130)
			TriggerSetExtSrc(eTrigSrcMains);					// set external source Line
			
			// external coupling
			if (MenuStatus[MENU_TRIGGERMODE][1] == 95)				// trigger coupling AC/DC
			TriggerSetExtCoupling(eTrigCoupleDC);
			else
			TriggerSetExtCoupling(eTrigCoupleAC);
			
			// external trigger level
			if (MenuPopupStatus[8][2] == 3)						// Line
			{
				trigLevel = 128;
				CaptureTrigSetEdge(eEdgeRise);					// force to rising edge
			}
			else
			{
				trigLevel = (unsigned char)(Trigger_Pos_CHE + 0x40);
			}

			//printf("Trigger_Pos_CHE %d\n\r", Trigger_Pos_CHE);
			//printf("trigger extern level %d \n\r", ext_trg_val_reg);
		}
		
		else if (_TriggerSource == eTrigTV)						// Source = TV sync (external)
		{										// triggers on channel 1 with sync timing
			// external source
			TriggerSetExtSrc((trigExtSel_t)(MenuStatus[MENU_TRIGGEREDGE][3] - 127));// set external source vertical/composite
			
			// external coupling
			if (MenuStatus[MENU_TRIGGERMODE][1] == 95)				// trigger coupling AC/DC
			TriggerSetExtCoupling(eTrigCoupleDC);
			else
			TriggerSetExtCoupling(eTrigCoupleAC);
						
			trigLevel = (unsigned char)(Trigger_Pos_CHE + 0x40);			// set trigger level
		}
    	}


	//---------------------------------------------------
	//		Pulse Width Triggering
	//---------------------------------------------------

	if (TriggerWay == TRIG_PULS)	//BF pulse width triggering #021
	{
		//printf("\r\npulse width triggering active\r\n");
		CaptureTrigSetType(eTrigPulse);	// call new API
		
		/* set trigger source for pulse trigger */
		_TriggerSource = (trigSrc_t)(MenuStatus[MENU_PULSEWIDTH][0] - TRIG_CH1); 	// set trigger source 0 - 3

		/* source depending settings */
		if (_TriggerSource == eTrigCh1) 						// Channel 1 
		{ 	
			if (Trigger_Pos_CH1 < GRID_HEIGHT && Trigger_Pos_CH1 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH1 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH1]) + ADC_ZERO; }	
		}  
		else if (_TriggerSource == eTrigCh2)		  				// Channel 2 
		{ 	
			if (Trigger_Pos_CH2 < GRID_HEIGHT && Trigger_Pos_CH2 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH2 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH2]) + ADC_ZERO; }
		}
		else if (_TriggerSource == eTrigCh3)		  				// Channel 3 
		{ 	
			if (Trigger_Pos_CH3 < GRID_HEIGHT && Trigger_Pos_CH3 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH3 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH3]) + ADC_ZERO; }	
		}
		else if (_TriggerSource == eTrigCh4)		 				// Channel 4 
		{ 
			if (Trigger_Pos_CH4 < GRID_HEIGHT && Trigger_Pos_CH4 > 0)
			{ trigLevel = (unsigned char)((float)((float)Trigger_Pos_CH4 - offs - (GRID_HEIGHT/2)) * gain / ScaleFactor[Selected_Voltage_CH4]) + ADC_ZERO; }
		}
	
		
		if (MenuStatus[MENU_PULSEWIDTH][2] == 2)					// less than
		{	
			CaptureTrigSetPulse(ePulseSmaller, 0, (unsigned short)(Pulse21.Read_Value() * 125000000));
		}	
		else if (MenuStatus[MENU_PULSEWIDTH][2] == 1)					// larger than
		{	
			CaptureTrigSetPulse(ePulseLarger, (unsigned short)(Pulse22.Read_Value() * 125000000), 0);
		}
		else if (MenuStatus[MENU_PULSEWIDTH][2] == 3)					// range between
		{	
			CaptureTrigSetPulse(ePulseBetween, (unsigned short)(Pulse11.Read_Value() * 125000000), (unsigned short)(Pulse12.Read_Value() * 125000000));
		}	
	
	}
	
	


	//--------------------------------------------
	//		Trigger Mode
	//--------------------------------------------
	
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_AUTO)			// auto mode
	{ 
		CaptureTrigSetMode(eTrigAuto);
	}
	else if(MenuStatus[MENU_TRIGGERMODE][0] == TRIG_COMB)   		//combi-trigger by Stefan
	{
		if (MainTimebase < 22)						//enable normal mode for timebase < 50ms
		{
			CaptureTrigSetMode(eTrigNorm);				//ctrl_reg &= 0xFFBF;
			CombiTriggerWaitTime = 0;				//reset time-measurement
			CombiTriggerStatus   = 0;				//Starten im Normal-Modus
		}
		else
		{	
			CaptureTrigSetMode(eTrigAuto);				//Zeitbasis zu groß->immer Auto-Modus
		}
	}
	else
	{	
		CaptureTrigSetMode(eTrigNorm);					// normal mode
	}

	
	CaptureTrigSetLevel(_TriggerSource, trigLevel);				// write trigger level to register
	
	CaptureTrigSetSource(_TriggerSource);					// write source to register and write all shadow registers to hardware

	//CaptureSetupADC();							// write shadow registers to hardware -> is done in source setting

	//Start_Record(); // -> causes signal acquisition in Stop/Single mode
	//if ((Run) && (TriggerWay == TRIG_PULS)) Start_Record();    	// -> causes signal acquisition in Stop/Single mode // deshalb if (Run) :-) JK 19.4.14
									// deleted because of new work around in ADC handler
}
//#####################################################################################################################################
// switch single LED on and send LED array to serial port
void Hardware::Set_LED(int LED)
{
	LED_ON[LED] = 1;
	Send_LED();
}

// switch single LED off and send LED array to serial port
void Hardware::Reset_LED(int LED)
{
	LED_ON[LED] = 0;
	Send_LED();
}
/*
void Hardware::Clear_LED(void)
{
	int ct;
	
	for (ct = 0; ct < 13;ct++) LED_ON[ct] = 0;
}
*/
// send LED array to serial port
void Hardware::Send_LED(void)
{
	int led_value = 0xFFFF;
	
	if (LED_ON[0] == 1) led_value = led_value & 0xBFFF;		// Select Channel 1
	if (LED_ON[1] == 1) led_value = led_value & 0xEFFF;		// Select Channel 2
 	if (LED_ON[2] == 1) led_value = led_value & 0xFEFF;		// Select Channel 3
	if (LED_ON[3] == 1) led_value = led_value & 0x7FFF;		// Select Channel 4

	if (LED_ON[4] == 1) led_value = led_value & 0xDFFF;		// Select Channel Math
	if (LED_ON[5] == 1) led_value = led_value & 0xFDFF;		// General
	if (LED_ON[6] == 1) led_value = led_value & 0xFBFF;		// Cursor						
	if (LED_ON[7] == 1) led_value = led_value & 0xF7FF;		// Quick Measure
	if (LED_ON[8] == 1) led_value = led_value & 0xFFBF;		// Edge
	if (LED_ON[9] == 1) led_value = led_value & 0xFFFD;		// Trigger waiting
	if (LED_ON[10] == 1) led_value = led_value & 0xFF7F;		// Pulse Width
	if (LED_ON[11] == 1) led_value = led_value & 0xFFFE;		// Trigger event occured 
	if (LED_ON[12] == 1) led_value = led_value & 0xFFDF;		// Run/Stop Green
	if (LED_ON[13] == 1) led_value = led_value & 0xFFEF;		// Run/Stop Red
	if (LED_ON[14] == 1) led_value = led_value & 0xFFF7;		// Single Red					
	if (LED_ON[15] == 1) led_value = led_value & 0xFFFB;		// Single Green
	
	serdata->np_piodata = led_value;
	serstartled->np_piodata = 0x01;
	serstartled->np_piodata = 0x00;	
#ifdef _Debug_	
	if (Debug_Mode) printf("LED VAL : %x \n", led_value);
#endif
}
//##########################################################################################################################################

void Hardware::DoEnableRotInterrupt(void)						// Enable service routine
{
	rot_int->np_pioedgecapture = 0x00; 						// clear all existing IRQ conditions
	rot_int->np_piodirection = 0x00;						// set all bits to input
	rot_int->np_piointerruptmask = 0x01;						// enable rotary IRQ

	key_reset->np_piodata = 0;
	nr_delay(2);
	key_reset->np_piodata = 1;

	rot_int->np_pioedgecapture = 0x00; 						// clear all existing IRQ conditions
	
	nr_installuserisr(na_rot_interrupt_irq,ISR_ROT,(int32_t)rot_int);		// Install ISR for parallel I/Os

	RotarySteps = 0;								// BF reset rotary buffer

#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nRot interrupt enabled.\n");  				// print on console
#endif	
}
//##########################################################################################################################################

void Hardware::DoDisableRotInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_rot_interrupt_irq,0,0); 					// Install empty routine for pio irq
	rot_int->np_piointerruptmask = 0x00;						// disable all IRQs
}
//##########################################################################################################################################

void Hardware::ISR_ROT(int32_t context)								// Parallel I/O Interrupt subroutine
{

	int32_t ct;
	int32_t keydata;							
	int32_t rotdir;								
	
	
	keydata = key->np_piodata;								// readout first 32 bit
	rotdir = keydata & 0x000FFF;								// 
	RotarySwitch = (keydata & 0xFFF000) >> 12;						// get interrupt source 
	
	rot_speed_read->np_piodata = 1;								// reload register
	keydata = key->np_piodata;								// readout next 32 bit
	rot_speed_read->np_piodata = 0;

	RotarySteps += (keydata & 0x000FFF);							// get number of rotary steps
	
	key_reset->np_piodata = 0;								// start reset pulse
	
	//BF only draw signal with changed zerolevel
	if (((RotarySwitch & 0x00000080) == 0x00000080) && Channel[eCh1].active) { ZL_changed = 1; }
	else if (((RotarySwitch & 0x00000010) == 0x00000010) && Channel[eCh2].active) { ZL_changed = 2; }
	else if (((RotarySwitch & 0x00000800) == 0x00000800) && Channel[eCh3].active) { ZL_changed = 3; }
	else if (((RotarySwitch & 0x00000100) == 0x00000100) && Channel[eCh4].active) { ZL_changed = 4; }	
	
	if (RotarySwitch == rotdir)
	RotaryDirection = 1;
	else
	RotaryDirection = 0;

	UI_request = 1;
	
	//printf("ISR keydata %3x RotSW %3x RotDir %i RotDirection %i RotSteps : %i \n\r", key->np_piodata, Rotary_Switch, Rot_Dir, Rotary_Direction, RotarySteps);	
nr_delay(2);
	key_reset->np_piodata = 1;								// end reset pulse



	rot_int->np_pioedgecapture = 0;								// clear IRQ conditions		

	
}
//##########################################################################################################################################
void Hardware::Zero_Levels_Center(void)	 
{
	char CH1_bak, CH2_bak, CH3_bak, CH4_bak;

	//if(Run) Hardware::Stop_Record();

	//backup channel status
	CH1_bak = Channel[eCh1].active;
	CH2_bak = Channel[eCh2].active;
	CH3_bak = Channel[eCh3].active;
	CH4_bak = Channel[eCh4].active;

	//backup zerolevels
	ZeroLevelCH1_bak = ZeroLevelCH1;
	ZeroLevelCH2_bak = ZeroLevelCH2;
	ZeroLevelCH3_bak = ZeroLevelCH3;
	ZeroLevelCH4_bak = ZeroLevelCH4;

	Virtual_ZeroLevelCH1_bak = Virtual_ZeroLevelCH1;
	Virtual_ZeroLevelCH2_bak = Virtual_ZeroLevelCH2;
	Virtual_ZeroLevelCH3_bak = Virtual_ZeroLevelCH3;
	Virtual_ZeroLevelCH4_bak = Virtual_ZeroLevelCH4;

	//backup triggerlevels
	Trigger_Pos_CH1_Old = Trigger_Pos_CH1;
	Trigger_Pos_CH2_Old = Trigger_Pos_CH2;
	Trigger_Pos_CH3_Old = Trigger_Pos_CH3;
	Trigger_Pos_CH4_Old = Trigger_Pos_CH4;


	//set zerolevels to the middle of the grid
	ZeroLevelCH1 = GRID_HEIGHT / 2;
	ZeroLevelCH2 = GRID_HEIGHT / 2;
	ZeroLevelCH3 = GRID_HEIGHT / 2;
	ZeroLevelCH4 = GRID_HEIGHT / 2;

	Virtual_ZeroLevelCH1 = 0;
	Virtual_ZeroLevelCH2 = 0;
	Virtual_ZeroLevelCH3 = 0;
	Virtual_ZeroLevelCH4 = 0;

	//channel have to be active to activate new settings
	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	//activate new settings
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_2();

	Trigger_Pos_CH1    = GRID_HEIGHT/2;	
	Trigger_Pos_CH2    = GRID_HEIGHT/2;	


	if (NumberOfChannels == 4)	// 4 channel version
	{	
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

		//activate new settings
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_3();
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_4();

		Trigger_Pos_CH3    = GRID_HEIGHT/2;	
		Trigger_Pos_CH4    = GRID_HEIGHT/2;	
	}

	Hardware::SetupTrigger();

	//restore channel status
	Channel[eCh1].active = CH1_bak;
	Channel[eCh2].active = CH2_bak;
	Channel[eCh3].active = CH3_bak;
	Channel[eCh4].active = CH4_bak;

	nr_delay(200);

	if(!Run && !RC_request) SingleShot = 1;
	
	Hardware::Start_Record();

}
//##########################################################################################################################################
void Hardware::Zero_Levels_Restore(void)							// 
{
	char CH1_bak, CH2_bak, CH3_bak, CH4_bak;

	//if(Run) Hardware::Stop_Record();

	//backup channel status
	CH1_bak = Channel[eCh1].active;
	CH2_bak = Channel[eCh2].active;
	CH3_bak = Channel[eCh3].active;
	CH4_bak = Channel[eCh4].active;

	//restore zerolevels
	ZeroLevelCH1 = ZeroLevelCH1_bak;
	ZeroLevelCH2 = ZeroLevelCH2_bak;
	ZeroLevelCH3 = ZeroLevelCH3_bak;
	ZeroLevelCH4 = ZeroLevelCH4_bak;

	Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_bak;
	Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_bak;
	Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_bak;
	Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_bak;

	Trigger_Pos_CH1 = Trigger_Pos_CH1_Old;
	Trigger_Pos_CH2 = Trigger_Pos_CH2_Old;
	Trigger_Pos_CH3 = Trigger_Pos_CH3_Old;
	Trigger_Pos_CH4 = Trigger_Pos_CH4_Old;


	//channel have to be active to activate new settings
	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	//activate new settings
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_2();

	if (NumberOfChannels > 2)	// 4 channel version
	{	
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

		//activate new settings
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_3();
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_4();
	}

	Hardware::SetupTrigger();

	//restore channel status
	Channel[eCh1].active = CH1_bak;
	Channel[eCh2].active = CH2_bak;
	Channel[eCh3].active = CH3_bak;
	Channel[eCh4].active = CH4_bak;

	nr_delay(200);

	if(!Run && !RC_request)SingleShot = 1;
	
	Hardware::Start_Record();

}
//###########################################################################################################################################
void Hardware::DoEnableUARTInterrupt(void)						// Enable service routine
{
	nr_installuserisr(na_uart1_irq, ISR_UART, (int)puart);				// Install ISR for UART

	puart->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART interrupt enabled.\n"); 				// print on console
#endif	
}
	
void Hardware::DoDisableUARTInterrupt(void)						// Disable service routine
{
	puart->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart1_irq, 0, 0); 						// Install empty routine for uart irq
}
//###########################################################################################################################################
//BF cleaned ISR from useless overhead and transferred buttonhandler to keyboard interface

/********************************************************************
/ Added state machine for GUI-commands.
/ On reception of STX (0x02) eight Bytes are read into a buffer.
/ When buffer is full, UartRxGuiCmd is set to 1
*********************************************************************/
void Hardware::ISR_UART(int context)                            // UART Interrupt subroutine for RS232 interface
{
#define	debug 0
    int8_t rxchar;
    int32_t status;
    static uint8_t state=0,rxbufcnt=0;

    status = puart->np_uartstatus;
    rxchar = puart->np_uartrxdata;

    puart->np_uartstatus = 0;				//clear interrupt condition

    UART_RXFlag = 1;   					//KB new uart data received for Quick Print export function

    if (status & np_uartstatus_rrdy_mask)
    {
        switch (state) {
            case 0:
                if (rxchar != STX) {        //Standard handling
                    UART_RXData  = rxchar;
                    UART_NewData = 1;
                    UI_request   = 1;
                }
                else state=1;
            break;
            case 1:
                if (rxchar == 'E') {        //Extended CMD from GUI
					if (debug) printf("E->2\n\r");
                    state=2; }
                else {                      //This is a screenshot-request
                    UartRxGuiCmd=rxchar;    //This setting is caught in PC-comms.cpp
					UART_NewData=1;
					if (debug) printf("Extended Part invalid: %.2X\n\r",rxchar);
                    state=0; }
            break;
            case 2:
					if (debug) printf("Extended Part: %.2X\n\r",rxchar);
                    UartRxGuiBuf[rxbufcnt++]=rxchar;    //Store to buffer
                    if (rxbufcnt==UARTRXGUISIZE) {      //If buffer is full
						if (debug) printf("Is Last Extended Part: %.2X\n\r",rxchar);
                        UartRxGuiCmd='E';               //Mark UartRxGuiCmd
                    	UART_NewData = 1;
                        rxbufcnt=0;                     //Reset counter
                        state=0; }                      //and state
            break;
        }
    }
}

//###########################################################################################################################################

void Hardware::DoEnableUART2Interrupt(void)						// Enable service routine
{
	UART2_rx_cnt = 0;
	
	nr_installuserisr(na_uart_usb_irq, ISR_UART2, (int)puart2);			// Install ISR for UART2

	puart2->np_uartcontrol = np_uartcontrol_irrdy_mask;				// Enable Control Bits
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nUART USB interrupt enabled.\n"); 			// print on console
#endif	
}
//###########################################################################################################################################
	
void Hardware::DoDisableUART2Interrupt(void)						// Disable service routine
{
	puart2->np_uartcontrol = 0;							// Disable Control Bits
	nr_installuserisr(na_uart_usb_irq, 0, 0); 					// Install empty routine for uart2 irq
}
//###########################################################################################################################################
// BF new designed USB function #017
void Hardware::ISR_UART2(int context)							// UART Interrupt subroutine for USB interface
{
	int8_t rxchar = -1;
	int32_t status;
	int32_t x;
		

		
	status = puart2->np_uartstatus;									// get UART status
	rxchar = puart2->np_uartrxdata;									// get transferred byte
	
	//puart2->np_uartstatus = 0;									// Clear Interrupt condition
	   	
	if (status & np_uartstatus_rrdy_mask)
	{
		UART2_rx_buffer[UART2_rx_cnt] = rxchar;							// save byte to buffer
			
		UART2_rx_cnt++;										// increase byte counter
	}	

	if ((UART2_rx_buffer[0] != 64) && (UART2_rx_buffer[0] != 8) && (UART2_rx_buffer[0] != 37))	// check for block start indicator
	UART2_rx_cnt = 0;
													// first byte contains block size

	if ((UART2_rx_cnt == UART2_rx_buffer[0]) && (UART2_rx_cnt > 0))								// Check if data block is complete (64 byte)
	{		
		printf("USB Interface: Received data block with %d bytes\n\r",UART2_rx_cnt);

		if(UART2_rx_buffer[0] == 37) CommIF::InterpretUART(&UART2_rx_buffer[0]);		//WELEC USB handler
	
		if(UART2_rx_buffer[0] == 64) CommIF::ON_UART2DataBlock(&UART2_rx_buffer[0]);		//new USB handler by BF

		if(UART2_rx_buffer[0] == 8) CommIF::ON_UART2DataBlock(&UART2_rx_buffer[0]);		//new USB handler by BF

		UART2_rx_cnt = 0;									// reset byte counter
	}
	
	puart2->np_uartstatus = 0;									// Clear Interrupt condition

}

//##############################################################################################################################################
// BF new implemented
// timer 1 service routines for combi-trigger
void Hardware::DoEnableTimer1Interrupt(void)									// Enable service routine
{	
	nr_installuserisr(na_timer1_irq,ISR_TIMER1,(int32_t)timer1); 						// Install timer isr
	
	timer1->np_timerperiodh = (nasys_clock_freq/1000)>>16;;
	timer1->np_timerperiodl = (nasys_clock_freq/1000)&0x0000ffff;	
	
	timer1->np_timercontrol = timer1->np_timercontrol | np_timercontrol_ito_mask | np_timercontrol_start_mask | np_timercontrol_cont_mask;
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nTimer1 interrupt enabled.\n"); 						// print on console
#endif	
}
//##############################################################################################################################################

void Hardware::DoDisableTimer1Interrupt(void)									// Disable service routine
{
	nr_installuserisr(na_timer1_irq,0,0); 									// Install empty routine for timer irq
	timer1->np_timercontrol = timer1->np_timercontrol & ~np_timercontrol_ito_mask; 				// Disable timer interrupt
}
//##############################################################################################################################################

void Hardware::Start_Timer1(void)
{
	timer1->np_timerperiodh = timer_reload_high;
	timer1->np_timerperiodl = timer_reload_low;	
	
	timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_start_mask);	// Start Timer
}
//##############################################################################################################################################

void Hardware::Stop_Timer1(void)
{
   	 timer1->np_timercontrol = ((timer1->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer
}
//##############################################################################################################################################

void Hardware::ISR_TIMER1(int32_t context)							// combi trigger timer service subroutine
{
	timer1->np_timerstatus  = 0;										// clear the status register
	CombiTimingCounter++;
	CombiTriggerWaitTime++; 											//needed for combi-trigger

	if (USTB_Mode != USTB_OFF) return;

	
	//BF added for Stefans combi-trigger
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_COMB)
	{
		if (CombiTriggerWaitTime > 500  && CombiTriggerStatus == 0) //change trigger to auto-trigger
		{
			//combi-trigger,  no Trigger for 500ms, trigger still in normal-mode
			if((MainTimebase < 22) || (!(_regADC[0].ctrl & 0x0040)))
			{
				//timebase<=20ms,
				CombiTriggerStatus = 1;		//change trigger to auto-trigger
				_regADC[0].ctrl |= 0x0040;
				_regADC[1].ctrl |= 0x0040;
				CaptureSetupADC();
				// printf("Set to Auto\n");
			}
		}
	}

//	printf("We got a timer1 irq  AFR %d  AST %d tcv %d tcm %d irq %d\n", AutoFreeRun, AutoSearchTrigger, timer_counter_value, timer_counter_max, acq_ready->np_piodata);

}
//##############################################################################################################################################
// BF new implemented
// Enable timer 2 interrupt for rollmode
void Hardware::DoEnableTimer2Interrupt(void)									// Enable service routine
{	

	//timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	timer2->np_timercontrol = 0x0008;									// Stop Timer, disable interrupt
	//timer2->np_timerperiodh = (short)((USTB_timer_value[RealTimebase - 23] >> 16) & 0x0000ffff);	// Set High Register of Timer
	//timer2->np_timerperiodl = (short)(USTB_timer_value[RealTimebase - 23] & 0x0000ffff);		// Set Low Register of Timer
	timer2->np_timerstatus = 0;										// write anything to clear the ISR

	nr_installuserisr(na_timer2_irq,ISR_TIMER2,(int32_t)timer2); 						// Install timer isr
	timer2->np_timercontrol = 0x0001;									// enable interrupt

	//printf("\nTimer2 interrupt enabled.\n");

}
//##############################################################################################################################################
// BF new implemented
// disable timer 2 interrupt for rollmode
void Hardware::DoDisableTimer2Interrupt(void)									// Disable service routine
{
	
	timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	nr_installuserisr(na_timer2_irq,0,0); 									// Install empty routine for timer irq
    	timer2->np_timerstatus = 0;

	//printf("\nTimer2 interrupt disabled.\n");	

}
//##############################################################################################################################################
// BF new implemented
void Hardware::Start_Timer2(void)
{
	//timer2->np_timerperiodh = (short)((USTB_timer_value[RealTimebase - 23] >> 16) & 0x0000ffff);	// Set High Register of Timer
	//timer2->np_timerperiodl = (short)(USTB_timer_value[RealTimebase - 23] & 0x0000ffff);		// Set Low Register of Timer
	//timer2->np_timerstatus = 0;										// clear the ISR

	//timer2->np_timercontrol = np_timercontrol_start_mask;							// Start Timer
	//timer2->np_timercontrol = np_timercontrol_start_mask + np_timercontrol_ito_mask;			// Start Timer and enable Interrupt
	timer2->np_timercontrol = 0x0005;									// Start Timer and enable Interrupt
	//printf("\nTimer2 started.\n");
}
//##############################################################################################################################################
// BF new implemented
void Hardware::Stop_Timer2(void)
{
	//timer2->np_timercontrol = np_timercontrol_stop_mask;							// Stop Timer
	//timer2->np_timercontrol = 0x0009;									// Stop Timer
	timer2->np_timercontrol = 0x0008;									// Stop Timer, disable interrupt
	timer2->np_timerstatus  = 0;										// clear the ISR

	//printf("\nTimer2 stopped.\n");
}
//##############################################################################################################################################
// BF new implemented
void Hardware::Reset_Timer2(void)
{
	uint32_t regtimer = USTB_timer_value[MainTimebase - 25];

	timer2->np_timerperiodh = (uint16_t)((regtimer >> 16) & 0x0000ffff);					// set high register of timer
	timer2->np_timerperiodl = (uint16_t)(regtimer & 0x0000ffff);						// set low register of timer
	timer2->np_timerstatus = 0;										// clear the ISR
	
	timer2->np_timercontrol = 0x0007; 									// set timer to continious running and start


	//timer2->np_timercontrol = np_timercontrol_start_mask;							// start timer
	//timer2->np_timercontrol = np_timercontrol_start_mask + np_timercontrol_ito_mask;			// start timer and enable interrupt
	//timer2->np_timercontrol = 0x0005;									// start timer and enable interrupt

//	printf("\r\nReset Timer2 -> counter value = %d\r\n", USTB_timer_value[RealTimebase - 23]);

}
//##############################################################################################################################################
// timer 2 interrupt service routine for USTB rollmode
// BF new implemented
void Hardware::ISR_TIMER2(int32_t context)										// Menu Timer service subroutine
{

	if (context != (int32_t)timer2) return;

	//if (Run == false) return;

	timer2->np_timerstatus  = 0;										// clear the status register
	//Stop_Timer2();

	Start_Record();

//printf("Timer 2 interrupt   ");	
//	printf("Timer 2 interrupt occured - new record started\n\r");

}
//##############################################################################################################################################
// enable timer 3 interupt for rotary interface
void Hardware::DoEnableTimer3Interrupt(void)										// Enable service routine
{					
	timer_rotary_busy->np_timerperiodh = RegTimerRotDelay >> 16;							// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = RegTimerRotDelay & 0xffff;							// Set Low Register of Timer
    	timer_rotary_busy->np_timerstatus = 0;										// write anything to clear the IRQ

	nr_installuserisr(na_timer3_irq,ISR_TIMER3,(uint32_t)timer_rotary_busy); 						// Install timer isr

	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol | np_timercontrol_ito_mask;  		// Enable timer interrupt
	
	//if (Debug_Mode) printf("Timer3 interrupt enabled & started.\n"); 						// print on console

}
//##############################################################################################################################################
// disable timer 3 interupt for rotary interface
void Hardware::DoDisableTimer3Interrupt(void)										// Disable service routine
{
	nr_installuserisr(na_timer3_irq,0,0); 										// Install empty routine for timer irq
	timer_rotary_busy->np_timercontrol = timer_rotary_busy->np_timercontrol & ~np_timercontrol_ito_mask; 		// Disable timer interrupt
}
//##############################################################################################################################################
// timer 3 interrupt service routine for rotary interface and popup menus
// Menu Timer service subroutine
void Hardware::ISR_TIMER3(int32_t context)				
{
	timer_rotary_busy->np_timerstatus = 0;						// write anything to clear the IRQ

	TriggerLevelActive = 0;								// switch off trigger line

	if(QP_request) return;								// quick print requested?

/*BF del
	// unpush buttons
	for (int cnt = 0; cnt < 6; cnt++)
	{
		if (MenuItemPushed[cnt] == 0) continue;
		if (MenuItemDef[Active_Menu][cnt] != 0)		//only if button is active in this menu (after menu change)
		{
			//Display::ClearMenuItemTextAsm(cnt, 35040, 32);
			Display::ClearMenuItemAsm(cnt, 34560, 44);	// -> only for deleting old lines -> better in button routine!
			Display::DrawMenuItemButton(cnt, 0);
			Display::DrawMenuItem(New_Menu, cnt, MenuAktive, 1);
		}
		MenuItemPushed[cnt] = 0;
	} 
*/

	if (MenuPopupActive > -1)							// menu popup active?
    	{
		Display::DRAWMENUPOPDOWN(); 						// close popup due to timeout
		//OpSys::SetExecHdl(&Display::DRAWMENUPOPDOWN);				// load to execution queue
	}							

	// Bf changed for new menu structure 
	if ((Memory_Window_visible) && (MenuStatus[MENU_TIMEBASE][4] == BTN_OFF)) 	// if memory window is visible and browse function
    	{ Display::CloseMemoryBrowser(); }						// is not active close memory browser for timeout

	ButtonChanged = 0;
	
	if(!AS_request)
	{ ConfigChanged = 1; }								// write config
	
   	//BF del acq_ready->np_pioedgecapture = 0;	#018

}
//##############################################################################################################################################
// Reset timer 3  -> reset and start timer for timeout event (popup menus, trigger line etc.)
void Hardware::ResetTimer3(uint32_t period)	// Reset Timer
{
	//long timerVal;
	//long timerPeriod;

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);	// & ~np_timercontrol_cont_mask;	// Stop Timer
	timer_rotary_busy->np_timerstatus = 0;										// write anything to clear the IRQ
		
	timer_rotary_busy->np_timerperiodh = period >> 16;								// Set High Register of Timer
	timer_rotary_busy->np_timerperiodl = period & 0xffff;								// Set Low Register of Timer

	timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_start_mask);	// | np_timercontrol_cont_mask;	// Start Timer

}
//##############################################################################################################################################
// set hardware switches on the mainboard for voltage range
// external trigger is handeled by new trigger API now
// Kanalnummern umstellen -> DONE
// TODO Switches Variable ersetzen durch Channel Struct
void Hardware::SetSwitches(uint8_t channel, uint32_t range)
{

	if (channel > eCh4) return;
	
	if (MenuStatus[MENU_HARDWARE][1] == ADD_ON)	// support for new input stage addon PCB 
	{
		ADDON_SetSwitches(channel, range);
		return;
	}


	int16_t dat_buf = 0;
	int32_t adr_buf = 0x00000000;
	int32_t outbuf = 0x00000000;
	


	//Bit0 and Bit1: 01: 1st Voltage divider 1/10, Bit2 and 3: 2nd Voltage divider 1/10
	//Bit4: 0: OPA656N: ampl. by 1.25, 1: ampl. by 1.
	//Bit5: BW-Limit
	//Bit6: 1st AD8131 x1/x2
	//Bit7: 2nd AD8131 x1/x2
	//Bits8-11: AC Channel (Bit8..Bit11) -> only at address 0x70000000
	//Bit28-30: hardware address of the channels Bit28: channel 3  Bit28 + 29: channel 4  Bit28 + 30: channel 2  Bit28 + 29 + 20: channel 1
	
	switch(range)
	{
		case -1 : 	// for coupling AC/DC the address must be 0x70000000 -> channel 1
		{
			dat_buf = SwitchesCH1;		// get actual range setting of channel 1
			channel = eCh1;
			break;
		}
									// amplification 1.25
		//case e1mV : dat_buf = 0x	  ; break;	//0x		//1mV		not supported
		//case e2mV : dat_buf = 0x   ; break;	//0x		//2mV		not supported
		//case e5mV : dat_buf = 0x   ; break;	//0x		//5mV		not supported
		case e10mV  : dat_buf = 0x0015; break;	//0x0005	//10mV	00010101
		case e20mV  : dat_buf = 0x0055; break;	//0x0045	//20mV	01010101
		case e50mV  : dat_buf = 0x00C5; break;	//0x00D5	//50mV	11000101
		case e100mV : dat_buf = 0x0019; break;	//0x0009	//100mV	00011001
		case e200mV : dat_buf = 0x0059; break;	//0x0049	//200mV	01011001
		case e500mV : dat_buf = 0x00C9; break;	//0x00D9	//500mV	11001001
		case e1V    : dat_buf = 0x001A; break;	//0x000A	//1V	00011010
		case e2V    : dat_buf = 0x005A; break;	//0x004A	//2V	01011010
		case e5V    : dat_buf = 0x00CA; break;	//0x00DA	//5V	11001010
		default: return;
	}

		
	dat_buf &= 0xFFEF;									//delete bit 4 set amplification > 1 (switch off)

	switch(channel)
	{
		case eCh1:
		{
			adr_buf = 0x70000000;							// channel 1 address

			dat_buf = dat_buf & 0xF0DF;						// delete bit 5 and bits 8 - 11
			
			if (MenuStatus[MENU_CHANNEL1][0] == 8) dat_buf = dat_buf | 0x0100;	// set DC Bit 8
			if (MenuStatus[MENU_CHANNEL2][0] == 8) dat_buf = dat_buf | 0x0200;	// set DC Bit 9
			if (MenuStatus[MENU_CHANNEL3][0] == 8) dat_buf = dat_buf | 0x0400;	// set DC Bit 10
			if (MenuStatus[MENU_CHANNEL4][0] == 8) dat_buf = dat_buf | 0x0800;	// set DC Bit 11

			if (MenuStatus[MENU_CHANNEL1][1] == 241) dat_buf = dat_buf | 0x0020;	// BW Limit Bit 5

			SwitchesCH1 = dat_buf;		// remember the settings of channel 1
			
			outbuf = adr_buf | dat_buf;
			
			VoltageChangedCh1 = 1;
		
			break;	
		}
		case eCh2:
		{
			adr_buf = 0x50000000;							// channel 2 address
			
			dat_buf = dat_buf & 0xFFDF;						// delete Bit 5
			
			if (MenuStatus[MENU_CHANNEL2][1] == 241) dat_buf = dat_buf | 0x0020;	// BW Limit Bit 5
			
			outbuf = adr_buf | dat_buf;
	
			VoltageChangedCh2 = 1;

			break;	
		}
		case eCh3:
		{
			adr_buf = 0x10000000;							// channel 3 address
			
			dat_buf = dat_buf & 0xFFDF;						// delete Bit 5
			
			if (MenuStatus[MENU_CHANNEL3][1] == 241) dat_buf = dat_buf | 0x0020;	// BW Limit Bit 5
			
			outbuf = adr_buf | dat_buf;

			VoltageChangedCh3 = 1;

			break;	
		}
		case eCh4:
		{
			adr_buf = 0x30000000;							// channel 4 address
			
			dat_buf = dat_buf & 0xFFDF;						// delete Bit 5
			
			if (MenuStatus[MENU_CHANNEL4][1] == 241) dat_buf = dat_buf | 0x0020;	// BW Limit Bit 5
			
			outbuf = adr_buf | dat_buf;

			VoltageChangedCh4 = 1;

			break;	
		}
		default: return;
	}

	serdata->np_piodata = outbuf;								// write shadow to serial register
	
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
		
	RELAY_SETTLE;

	outbuf = (adr_buf | dat_buf) & 0xFFFFFFF0;						// switch off driver transistors
	
	serdata->np_piodata = outbuf;
	
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
	
	RELAY_SETTLE;
	

}

//##############################################################################################################################################
// support for the new input stage -> addon PCB written by Jörg
// set hardware switches on the mainboard and the add-on pcb for voltage range
// Kanalnummern umstellen -> DONE
// TODO Switches Variable ersetzen durch Channel Struct
void Hardware::ADDON_SetSwitches(uint8_t channel, uint32_t range)
{
	unsigned short dat_buf = 0;
	unsigned long lmh_buf = 0x00040A; // LMH6518 default config: aux amp disabled, no filter, low gain, max. attenuation
	unsigned long adr_buf = 0x00000000;
	unsigned long outbuf = 0x00000000;


	//Bit0 and Bit1: 01: 1st Voltage divider 1/10, Bit2 and 3: 2nd Voltage divider 1/10
	//Bit4: /CS of LMH6518, 1 if not accessing it
	//Bit5: unused, should be 1
	//Bit6: unused, should be 0
	//Bit7: unused, must be 0
	//Bits8-11: AC Channel (Bit8..Bit11)
			
	switch(range)
	{
		default: // no change
		{
			switch(channel)
			{
				case eCh1 : dat_buf = SwitchesCH1; lmh_buf = (unsigned long)SwitchesLMH[0]; break;
				case eCh2 : dat_buf = SwitchesCH2; lmh_buf = (unsigned long)SwitchesLMH[1]; break;
				case eCh3 : dat_buf = SwitchesCH3; lmh_buf = (unsigned long)SwitchesLMH[2]; break;
				case eCh4 : dat_buf = SwitchesCH4; lmh_buf = (unsigned long)SwitchesLMH[3]; break;
			}	
			break;		
		}			

		case e1mV   : dat_buf = 0x0035; lmh_buf = 0x000410; break;	//1mV	10110101, pre-amp
		case e2mV   : dat_buf = 0x0035; lmh_buf = 0x000413; break;	//2mV	10110101, pre-amp
		case e5mV   : dat_buf = 0x0035; lmh_buf = 0x000417; break;	//5mV	10110101, pre-amp
		case e10mV  : dat_buf = 0x0035; lmh_buf = 0x000400; break;	//10mV	10110101
		case e20mV  : dat_buf = 0x0035; lmh_buf = 0x000403; break;	//20mV	10110101
		case e50mV  : dat_buf = 0x0035; lmh_buf = 0x000407; break;	//50mV	10110101
		case e100mV : dat_buf = 0x0039; lmh_buf = 0x000400; break;	//100mV	10111001
		case e200mV : dat_buf = 0x0039; lmh_buf = 0x000403; break;	//200mV	10111001
		case e500mV : dat_buf = 0x0039; lmh_buf = 0x000407; break;	//500mV	10111001
		case e1V    : dat_buf = 0x003A; lmh_buf = 0x000400; break;	//1V	10111010
		case e2V    : dat_buf = 0x003A; lmh_buf = 0x000403; break;	//2V	10111010
		case e5V    : dat_buf = 0x003A; lmh_buf = 0x000407; break;	//5V	10111010
	}

	switch(channel)
	{
		case eCh1:
		{
			adr_buf = 0x70000000;		// channel 1 = address 7 (hardware)

			// Set AC Bits
			dat_buf = dat_buf & 0xF0DF;

			if (MenuStatus[MENU_CHANNEL1][0] == 8) dat_buf = dat_buf | 0x0100;
			if (MenuStatus[MENU_CHANNEL2][0] == 8) dat_buf = dat_buf | 0x0200;
			if (MenuStatus[MENU_CHANNEL3][0] == 8) dat_buf = dat_buf | 0x0400;
			if (MenuStatus[MENU_CHANNEL4][0] == 8) dat_buf = dat_buf | 0x0800;	
		
			// BW Limit
			if (MenuStatus[MENU_CHANNEL1][1] == 241) lmh_buf |= 0x0040; // 20 MHz

			SwitchesCH1 = dat_buf;
			
			VoltageChangedCh1 = 1;
			//printf("Switches : %x , erg : %x \n", SwitchesCH1, (adr_buf | SwitchesCH1));
		
			break;	
		}
		case eCh2:
		{
			adr_buf = 0x50000000;		// channel 2 = address 5 (hardware)
			
			// Set AC Bit
			dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;	
			//if (MenuStatus[MENU_CHANNEL2][0] == 8) dat_buf = dat_buf | 0x0200;	//BF add
			// BW Limit
			if (MenuStatus[MENU_CHANNEL2][1] == 241) lmh_buf |= 0x0040; // 20 MHz
			
			SwitchesCH2 = dat_buf;
	
			VoltageChangedCh2 = 1;

			//printf("Switches : %x , erg : %x \n", SwitchesCH2, (adr_buf | SwitchesCH2));

			break;	
		}
		case eCh3:
		{
			adr_buf = 0x10000000;		// channel 3 = address 4 (hardware)
			
			// Set AC Bit		
			dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;
			//if (MenuStatus[MENU_CHANNEL3][0] == 8) dat_buf = dat_buf | 0x0400;	//BF add
			// BW Limit
			if (MenuStatus[MENU_CHANNEL3][1] == 241) lmh_buf |= 0x0040; // 20 MHz
			
			SwitchesCH3 = dat_buf;

			VoltageChangedCh3 = 1;
			//printf("Switches : %x , erg : %x \n", SwitchesCH3, (adr_buf | SwitchesCH3));

			break;	
		}
		case eCh4:
		{
			adr_buf = 0x30000000;		// channel 4 = address 3 (hardware)
			
			// Set AC Bit	
            		dat_buf = dat_buf & 0xFFDF;
			//dat_buf = dat_buf & 0xF0DF;
			//if (MenuStatus[MENU_CHANNEL4][0] == 8) dat_buf = dat_buf | 0x0800;
			// BW Limit
			if (MenuStatus[MENU_CHANNEL4][1] == 241) lmh_buf |= 0x0040; // 20 MHz
			
			SwitchesCH4 = dat_buf;

			VoltageChangedCh4 = 1;

			//printf("Switches : %x , erg : %x \n", SwitchesCH4, (adr_buf | SwitchesCH4));

			break;	
		}		
	}

	SwitchesLMH[channel] = (unsigned short) lmh_buf; // save for later restore with voltage = -1

	outbuf = adr_buf | dat_buf;
    //printf("outbuf1: %x\r\n", outbuf);
	serdata->np_piodata = outbuf;//TurnBits(outbuf);
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
	Sleep_us(SPI_DELAY16); // delay >130us while FPGA shifts it out
		
	// while the relays are settling, program the LMH

	// clear /CS, assert it (this could have been done above already, 
	// only do it here because it may be first time and the line not idle high)
	outbuf = adr_buf | (dat_buf & 0xFFEF); 
    //printf("outbuf2: %x\r\n", outbuf);
    	serdata->np_piodata = outbuf;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
	Sleep_us(SPI_DELAY16); // delay >130us while FPGA shifts it out
	
	unsigned long mask = 1L << 23; // with leading 0x00 command byte, send 24 bits, MSB first
	outbuf = 0x70000000 | (SwitchesCH1 & ~0x9000); // clock and data low

	// test: send more bits -> not working, valid transfer is 24 bits only
	// mask <<= 8; 
	// outbuf <<= 8; // left aligned, shift the data, too -> not working

	//printf("outbuf3: %x\r\n", outbuf);
	//printf("lmh=%x\r\n", lmh_buf);
	while (mask)
	{
		outbuf &= ~0x9000L; // clock low, data low and t.b.d.
		// set data line to bit value
		if (lmh_buf & mask)
		{
			outbuf |= 0x1000L; // set data bit
		}

		serdata->np_piodata = outbuf;
		serstartsw->np_piodata = 1;
		serstartsw->np_piodata = 0;
		Sleep_us(SPI_DELAY16); // delay >130us while FPGA shifts it out

		// clock high
		outbuf |= 0x8000L;
		serdata->np_piodata = outbuf;
		serstartsw->np_piodata = 1;
		serstartsw->np_piodata = 0;	
		Sleep_us(SPI_DELAY16); // delay >130us while FPGA shifts it out

		mask >>= 1; // next lower bit
	}
	
	outbuf &= ~0x9000L; // clock and data low
	serdata->np_piodata = outbuf;
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
	//printf("\r\noutbuf4: %x\r\n", outbuf);
	
	if ((15000-49*SPI_DELAY16) > SPI_DELAY16) // if there's still more time to kill than the shift time
	{
		Sleep_us(15000-49*SPI_DELAY16); // wait for SPI shifting it out, plus remaining relay settling time
	}
	else // minimum time
	{
		Sleep_us(SPI_DELAY16); // wait for SPI shifting it out
	} 


	//Clear Bits0..3 and send again to shut off driver transistors for voltage divider-relais
	// this also de-assert /CS of the LMH
	outbuf = adr_buf | (dat_buf & 0xFFF0);
	printf("outbuf5: %x\r\n\r\n", outbuf);

	serdata->np_piodata = outbuf;//TurnBits(outbuf);	
	
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
	Sleep_us(SPI_DELAY16); // wait for SPI shifting it out



}
//##############################################################################################################################################
// busy wait with microsecond resolution -> written by Jörg
void Hardware::Sleep_us(uint32_t us)
{
	// as it currently compiles, one loop iteration takes ~2 us
	// note that this is rather inaccurate, not precisely timed
	for (volatile unsigned long i=us/2; i>0; i--);
}

//##############################################################################################################################################
// BF added 16 Bit DAC support
//  Kanalnummern umstellen -> DONE
// TODO Offset Variable ersetzen durch Channel Struct
void Hardware::SetDacOffset(uint8_t channel)
{
	int32_t BufInt = 0;
	int32_t BufInt2 = 0;	
	int32_t outbuf = 0x00000000;		

/* 	BF Serial interface (SDI) specification for LTC2602/LTC2612 DAC family.
	The 4-bit command, C3-C0, is loaded first; then the 4-bit DAC address, A3-A0; and finally the 16-bit data word. The
	data word comprises the 16-, 14- or 12-bit input code, ordered MSB-to-LSB, followed by 0, 2 or 4 don’t-care bits
	(LTC2602, LTC2612 and LTC2622 respectively). 

	Data can only be transferred to the device when the CS/LD signal is low.The rising edge of CS/LD ends the data transfer and
	causes the device to carry out the action specified in the 24-bit input word.

	Command:							Address:
	C3  C2  C1  C0							A3  A2  A1  A0
	-----------------------------------------------------		-------------------------
	0   0   0   0	write to input register n			0   0   0   0	DAC A
	-----------------------------------------------------		-------------------------
	0   0   0   1	update (power up) register n			0   0   0   1	DAC B
	-----------------------------------------------------		-------------------------
	0   0   1   0	write to input register n, update all		1   1   1   1	All DACs
	-----------------------------------------------------		-------------------------
	0   0   1   1	write to and update n
	-----------------------------------------------------
	0   1   0   0	Power down n
	-----------------------------------------------------
	1   1   1   1	No operation
	-----------------------------------------------------


	Input word LTC2602:

	<C3 C2 C1 C0|A3 A2 A1 A0|D15 D14 D13 D12 D11 D10 D9 D8 D7 D6 D5 D4 D3 D2 D1 D0> 


	Input word LTC2612:

	<C3 C2 C1 C0|A3 A2 A1 A0|D13 D12 D11 D10 D9 D8 D7 D6 D5 D4 D3 D2 D1 D0 X X> 

	The input word structure is software compatible. The DAC versions can be changed
	without changing the firmware if the format is implemented in 16 bit.
*/
//printf("set DAC offset ch%d\r\n",channel);
	switch(channel)
	{
		case eCh1 :	
		{			
			BufInt = CH1_DAC_Offset & 0xFFFF;
			
			BufInt2 = 0x00310000 | BufInt;			// write and update register DAC 1-B

			outbuf = 0x60000000 | BufInt2;			// set DAC 1 base address
			
			serdata->np_piodata = outbuf;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
							
			nr_delay(10);	
						
			break;	
		}			
		case eCh2 :	
		{
			BufInt = CH2_DAC_Offset & 0xFFFF;
			
			BufInt2 = 0x00300000 | BufInt;			// write and update register DAC 1-A

			outbuf = 0x60000000 | BufInt2;			// set DAC 1 base address
			
			serdata->np_piodata = outbuf;
			
			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
							
			nr_delay(10);

			break;		
		}	
		case eCh3 :
		{			
			BufInt = CH3_DAC_Offset & 0xFFFF;

			BufInt2 = 0x00310000 | BufInt;			// write and update register DAC 2-B

			outbuf = 0x40000000 | BufInt2;			// set DAC 2 base address	
			
			serdata->np_piodata = outbuf;

			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
							
			nr_delay(10);	
						
			break;	
		}			
		case eCh4 :
		{
			BufInt = CH4_DAC_Offset & 0xFFFF;
			
			BufInt2 = 0x00300000 | BufInt;			// write and update register DAC 2-A

			outbuf = 0x40000000 | BufInt2;			// set DAC 2 base address
			
			serdata->np_piodata = outbuf;
			
			serstartsw->np_piodata = 1;
			serstartsw->np_piodata = 0;	
							
			nr_delay(10);

			break;		
		}
	}	

}


//#####################################################################################################################################################
//BF set ADC depending registers for triggering and acquisition -> old version, not used anymore due to OSOZ interface
/*
void Hardware::SetupADC(void)
{
	
	mode->np_piodata = 0x01;
		
	if (triggering == 0)	// trigger off
	{ 
		_regADC[eFPGA1].adc_ctrl &= 0xFFF1;
		ctrl_reg &= 0xC17D;  // remove holdoff and pulse bits and internal bit

		_regADC[eFPGA1].adc_ctrl |= 0x0001;
		ctrl_reg |= 0x0041;
		trig_holdoff_reg = 0x00000000;

		WriteADC(1, ctrl_reg + (_regADC[eFPGA1].adc_ctrl << 16));
	}	
	else if(triggering == 1) WriteADC(1, ctrl_reg + (_regADC[eFPGA1].adc_ctrl << 16));
	else WriteADC(1, (ctrl_reg & 0xFFFE) + (_regADC[eFPGA1].adc_ctrl << 16));		

	WriteADC(1, tb_value[MainTimebase]);	// set timebase register

	WriteADC(1, pre_reg + (channel_Adr_add12 << 16));
    	
	WriteADC(1, trg_val_CHI_reg + (trg_val_CHII_reg << 8) + (trig_range_reg << 16));
	WriteADC(1, (0xFFFFFFFF - trig_holdoff_reg));

	//BF set the grid color and pulse width
	WriteADC(1, trig_width_reg + (GridColor_Val << 26));	// ->GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
	WriteADC(1, adc_change12_reg);
	
	WriteADC(1, adc_ctr12_reg);

	mode->np_piodata = 0x00;

	nr_delay(20);

	if (NumberOfChannels == 4)
	{
		mode->np_piodata = 0x01;
		if(triggering == 0 || triggering == 3) WriteADC(3, ctrl_reg + (_regADC[eFPGA1].adc_ctrl << 16));
		else WriteADC(3, (ctrl_reg & 0xFFFE) + (_regADC[eFPGA1].adc_ctrl << 16));
	
		WriteADC(3, tb_value[MainTimebase]);	// set timebase register
		
		WriteADC(3, pre_reg + (channel_Adr_add34 << 16));		//BF add
//		WriteADC(3, pre_reg + (channel_Adr_add2 << 16));

		WriteADC(3, trg_val_CHIII_reg + (trg_val_CHIV_reg << 8) + (trig_range_reg << 16));	
		WriteADC(3, (0xFFFFFFFF - trig_holdoff_reg));
	
		WriteADC(3, trig_width_reg + (GridColor_Val << 26));	// ->GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
		WriteADC(3, adc_change34_reg);	//BF changed
		WriteADC(3, adc_ctr34_reg);
	
		mode->np_piodata = 0x00;
    	}

	//mode->np_piodata = 0x00;

}*/
//#####################################################################################################################################################
/* old assembler routine
void Hardware::WriteADC(unsigned int which, unsigned long value)
{	
	switch(which)
	{
		case 1 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 2 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 3 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
			
						ST		[%l0], %r0		
					");	
				break;
		case 4 :
				asm("		
						MOV		%r0,%i1					; Address of Buffer
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
			
						ST		[%l0], %r0		
					");	
				break;
	}
}
*/
// write a value to the FGPA capture unit
void Hardware::WriteADC(uint32_t channel, uint32_t value)
{
	volatile unsigned long* regAddr = (unsigned long *) RegADC[channel];
	*regAddr = value; // write to it
}

//#####################################################################################################################################################
/* old assembler routine
unsigned long Hardware::ReadADC(unsigned int which)
{

	switch(which)
	{
		case 1 :
				asm("		
						PFX		%hi(0x00A00000)
						MOVI	%l0,%lo(0x00A00000)
						PFX		%xhi(0x00A00000)
						MOVHI	%l0,%xlo(0x00A00000)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0
					");	
				break;
		case 2 :
				asm("		
						PFX		%hi(0x00A00010)
						MOVI	%l0,%lo(0x00A00010)
						PFX		%xhi(0x00A00010)
						MOVHI	%l0,%xlo(0x00A00010)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 3 :
				asm("		
						PFX		%hi(0x00A00020)
						MOVI	%l0,%lo(0x00A00020)
						PFX		%xhi(0x00A00020)
						MOVHI	%l0,%xlo(0x00A00020)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
		case 4 :
				asm("		
						PFX		%hi(0x00A00030)
						MOVI	%l0,%lo(0x00A00030)
						PFX		%xhi(0x00A00030)
						MOVHI	%l0,%xlo(0x00A00030)				
		
						LD		%r0,[%l0]	
		
						MOV		%i0, %r0	
					");	
				break;
	}
}
*/

// read a value from the FGPA capture unit
uint32_t Hardware::ReadADC(uint32_t channel)
{
	volatile unsigned long* regAddr = (unsigned long *) RegADC[channel];
	return *regAddr; // read from it
}
/*
//#####################################################################################################################################################
//BF -> get raw data from ADC  -  Assembler routine 
void ADC_GetRawData_ASM(uint32_t channel, unsigned long *signal, unsigned int count, unsigned char highspeed)
{

    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr1ch1n
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr1ch2n
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr1ch3n
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr1ch4n
            NOP

        lpr1ch1n:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI	%l0,%lo(0x00A00000)
            PFX		%xhi(0x00A00000)
            MOVHI	%l0,%xlo(0x00A00000)
            BR      lpr1n
            NOP

        lpr1ch2n:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI	%l0,%lo(0x00A00010)
            PFX		%xhi(0x00A00010)
            MOVHI	%l0,%xlo(0x00A00010)
            BR      lpr1n
            NOP

        lpr1ch3n:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI	%l0,%lo(0x00A00020)
            PFX		%xhi(0x00A00020)
            MOVHI	%l0,%xlo(0x00A00020)
            BR      lpr1n
            NOP

        lpr1ch4n:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI	%l0,%lo(0x00A00030)
            PFX		%xhi(0x00A00030)
            MOVHI	%l0,%xlo(0x00A00030)

	lpr1n:
            IFRZ    %i3                        	; highspeeed timebases?
            BR      lpr_slow                   	; if zero -> jump to slow tb loop
            NOP	
	
        lpr_fast:				; raw data readout loop -> copy 32 bit values to the buffer
            LD		%l2, [%l0]		; read data integer aligned from FPGA capture unit into l2 (load memory) 
            MOV		%r0, %l2  		; copy l2 to r0
            ST  	[%i1], %r0		; store integer value (4 bytes) to the buffer memory
            ADDI   	%i1, 4			; increment address counter

            SUBI	%i2, 1			; decrement integer value counter
            SKPS   	cc_z			; if argument is zero skip next instruction
            BR     	lpr_fast		; next loop
	    NOP
            BR		lpr_end			; go to the end
	    NOP

	lpr_slow:				; raw data readout loop -> copy 8 bit values to the buffer
            LD		%l2, [%l0]		; read data integer aligned from FPGA capture unit into l2 (load memory) 
            MOV		%r0, %l2  		; copy l2 to r0 in 32 bit format (only byte 0 contains data)
 	    ST8D	[%i1], %r0		; store byte 0 to the buffer memory
 	    ADDI   	%i1, 1			; increment address counter to the next byte in buffer memory

            LD		%l2, [%l0]		; read data integer aligned from FPGA capture unit into l2 (load memory) 
            FILL8	%r0, %l2  		; copy byte 0 from l2 to r0 and replicate it to byte 1 - 3
 	    ST8D	[%i1], %r0		; store byte 1 to the buffer memory
 	    ADDI   	%i1, 1			; increment address counter to the next byte in buffer memory

            LD		%l2, [%l0]		; read data integer aligned from FPGA capture unit into l2 (load memory) 
            FILL8	%r0, %l2  		; copy byte 0 from l2 to r0 and replicate it to byte 1 - 3
 	    ST8D	[%i1], %r0		; store byte 2 to the buffer memory
 	    ADDI   	%i1, 1			; increment address counter to the next byte in buffer memory

            LD		%l2, [%l0]		; read data integer aligned from FPGA capture unit into l2 (load memory) 
            FILL8	%r0, %l2  		; copy byte 0 from l2 to r0 and replicate it to byte 1 - 3
 	    ST8D	[%i1], %r0		; store byte 3 to the buffer memory
 	    ADDI   %i1, 1			; increment address counter to the next byte in buffer memory

            SUBI   %i2, 1			; decrement integer value counter
            SKPS   cc_z				; if argument is zero skip next instruction
            BR     lpr_slow			; next loop
	    NOP
 

	lpr_end:				; leave function


    ");

}
*/
//#####################################################################################################################################################
				/* ADC capture drivers */
/*
// sort, correct and recalculate ADC-values not inverted -> Assembler
// channel parameter is not used
void ADC_ProcessData_ASM(uint32_t channel, unsigned char *signal, unsigned char highspeed, unsigned int int_count, unsigned char *offset)
{

    asm("
						; preset registers with all needed values

	    LD      %l0, [%i4]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0
	    ;SEXT8   %r3				; sign extension to 32 bit r3 now contains the first offset byte

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1
	    ;SEXT8   %r4				; sign extension to 32 bit r4 now contains the second offset byte

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2
	    ;SEXT8   %r5				; sign extension to 32 bit r5 now contains the third offset byte

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3
	    ;SEXT8   %r6				; sign extension to 32 bit r6 now contains the fourth offset byte

            MOV    %l0, %i1			; address counter l0 points to the beginning of the signal buffer

            MOV	   %l1, %i3               	; copy integer counter to local register as loop counter

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            PFX     %hi(0)
            MOVI    %l4, %lo(0)			; preload local register with 0 for limiter

            IFRNZ    %i2                       	; highspeeed timebases? (if i2 = 1 -> go to main loop)
            BR      lpr1             		; jump to main loop
            NOP	

	    MOV	    %r4, %r3			; for slow timbases all bytes have to be corrected with the same
	    MOV	    %r5, %r3			; correction value (ADC 1). So we have to copy the values
	    MOV	    %r6, %r3			; to the correction registers
	    LSRI    %l1, 2			; divide counter by 4 -> number of values is 4 times less



        lpr1:				       	; main loop start

            LD	    %l2, [%l0]			; load 32 bit word from memory (signal buffer) to local register
            NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy l2 to r0	
            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0


	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
	
            SUBI   %l1, 1			; decrement integer value counter (loop counter)
            SKPS   cc_z				; check counter -> if zero skip next instruction and leave
            BR     lpr1				; next loop
            NOP	

    ");

}
*/
/*
// sort, correct and recalculate ADC-values inverted -> Assembler
// channel parameter is not used
void ADC_ProcessDataInv_ASM(uint32_t channel, unsigned char *signal, unsigned char highspeed, unsigned int int_count, unsigned char *offset, int zerolevel)
{

    asm("
						; preset registers with all needed values

	    LD      %l0, [%i4]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0
	    ;SEXT8   %r3				; sign extension to 32 bit r3 now contains the first offset byte

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1
	    ;SEXT8   %r4				; sign extension to 32 bit r4 now contains the second offset byte

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2
	    ;SEXT8   %r5				; sign extension to 32 bit r5 now contains the third offset byte

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3
	    ;SEXT8   %r6				; sign extension to 32 bit r6 now contains the fourth offset byte

            MOV	    %l1, %i3               	; copy integer counter to local register as loop counter

            MOV    %l0, %i1			; address counter l0 points to the beginning of the signal buffer

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2
	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            PFX     %hi(0)
            MOVI    %l5, %lo(0)			; preload local register with 0 for limiter


            IFRNZ    %i2                       	; highspeeed timebases? (if i2 = 1 -> go to main loop)
            BR      lprm             		; jump to main loop
            NOP	

	    MOV	    %r4, %r3			; for slow timbases all bytes have to be corrected with the same
	    MOV	    %r5, %r3			; correction value (ADC 1). So we have to copy the values
	    MOV	    %r6, %r3			; to the correction registers
	    LSRI    %l1, 2			; divide counter by 4 -> number of values is 4 times less


        lprm:				       	; main loop start

            LD	    %l2, [%l0]			; load 32 bit word from memory (signal buffer) to local register
            NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy l2 to r0	
            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction

            ; start inverting

	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0

	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0

	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction

            ; start inverting

	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0

	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back
	
            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%l0], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %l0, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
	
            SUBI   %l1, 1			; decrement integer value counter
            SKPS   cc_z				; check counter -> if zero skip next instruction and leave
            BR     lprm				; next loop
            NOP	

	
    ");

}
*/
//BF get ADC-values from capture unit and store them not inverted -> Assembler
void ADC_Capture_ASM(uint32_t channel, uint8_t *signal, uint32_t highspeed, uint32_t int_count, uint8_t *offset)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4
            NOP

        lpr_ch1:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset
            NOP

        lpr_ch2:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset
            NOP

        lpr_ch3:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset
            NOP

        lpr_ch4:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset:
						; preset registers with all needed values

	    LD      %l0, [%i4]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            MOVI    %l4, 0			; preload local register with 0 for limiter

            IFRZ    %i2                 	; highspeeed timebases?
            BR      capt_loop_slow      	; if zero -> jump to slow tb capturing
            NOP	


	capt_loop_fast:

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	
	proc_byte0: 
	    
	    NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy l2 to r0	
            ;EXT8S   %r0, 0			; extract byte 0
EXT8S   %r0, 0
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0


	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            ;EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
EXT8S   %r0, 1
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            ;EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0
EXT8S   %r0, 2
	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            ;EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
EXT8S   %r0, 3		
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i3, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0			; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	     
	    BR	    capt_end			; go to the end
	    NOP



	capt_loop_slow:

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0


	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i3, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow		; next loop
	    NOP

	capt_end:

    ");


}

//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
/*
  Special driver with corrected byte order (cbo) for TB 500MSa. Byte order is 45|01|67|23 with identical second byte (5,1,7,3). 
  The second byte is therefore not used but interpolated from the byte before and the byte after (average).  
*/ 
void ADC_CaptureCBO_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_cbo
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_cbo
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_cbo
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_cbo
            NOP

        lpr_ch1_cbo:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_cbo
            NOP

        lpr_ch2_cbo:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_cbo
            NOP

        lpr_ch3_cbo:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_cbo
            NOP

        lpr_ch4_cbo:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_cbo:
						; preset registers with all needed values

	    LD      %l2, [%l1]			; read first 32 bit fetch from FPGA capture unit into l2 -> prefetch 
	    NOT     %l2				; invert it bitwise						
						
	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3 (ADC1)	
	    EXT8S   %r3, 0			; extract byte 0

	    MOVI    %r4, 0			; preload register with 0 as start value for interpolating

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r5 (ADC3)
	    EXT8S   %r5, 2			; extract byte 2

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register l3 with 255 for limiter	

            MOVI    %l4, 0			; preload local register l4 with 0 for limiter


	
	proc_byte_cbo: 				; begin of capture loop
	
            LD      %l5, [%l1]			; read second 32 bit fetch from FPGA capture unit into l5 (load from memory address) 
	    NOT     %l5				; invert it bitwise

;------------------------------------------------------------------------------------------------------------------
						; process byte 0 of value 2 (4)
            MOV	    %r6, %l5  			; copy l2 to r0	
            EXT8S   %r6, 0			; extract byte 0

	    SUB     %r6, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r6, %l4			; set r6 to 0


	    CMP     %l3, %r6			; limiter to 255
	    IFS     cc_n			; if r6 > 255 -> r6 = 255
	    MOV     %r6, %l3			; remember byte 0(4) in r6 for later interpolating byte 5 (next byte)

						; interpolate byte (3) (the byte before -> end of loop)
ADD   %r4, %r6					; sum of byte (2) + (4) 
LSRI  %r4, 1					; divide by 2 (average)
FILL8   %r0, %r4				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter	    
    
            FILL8   %r0, %r6			; replicate byte 0 of r6 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; copy byte 0 to byte 1 of value 2 (5) -> redundant, interpolate instead 
;------------------------------------------------------------------------------------------------------------------
						; process byte 0 of value 1 (0)
            MOV     %r4, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r4, 0			; extract byte 0 to byte 0 of r4

	    SUB     %r4, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r4, %l4			; set r4 to 0

	    CMP     %l3, %r4			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r4, %l3			; store byte in r4 for later use

						; interpolate byte (5) (the byte before)
ADD   %r6, %r4					; sum of byte (4) + (0) 
LSRI  %r6, 1					; divide by 2 (average)
FILL8   %r0, %r6				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter

            FILL8   %r0, %r4			; replicate byte 0 of r4 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1 of value 1 (1)
            ;ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2 of value 2 (6) 
            MOV	    %r6, %l5  			; copy l5 to r0	
            EXT8S   %r6, 2			; extract byte 2

	    SUB     %r6, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r6, %l4			; set r0 to 0


	    CMP     %l3, %r6			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r6, %l3			; store byte in r6 for later use

						; interpolate byte (1) (the byte before)
ADD   %r4, %r6					; sum of byte (0) + (6) 
LSRI  %r4, 1					; divide by 2 (average)
FILL8   %r0, %r4				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter
	    
            FILL8   %r0, %r6			; replicate byte 0 of r6 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; copy byte (6) to byte 3 of value 2 (7)
            ;ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2 of value 1 (2)
            MOV     %r4, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r4, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r4, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r4, %l4			; set r0 to 0

	    CMP     %l3, %r4			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r4, %l3	

						; interpolate byte (7) (the byte before)
ADD   %r6, %r4					; sum of byte (6) + (2) 
LSRI  %r6, 1					; divide by 2 (average)
FILL8   %r0, %r6				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter
	    
            FILL8   %r0, %r4			; replicate byte 0 of r4 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

	    LD      %l2, [%l1]			; read first 32 bit fetch from FPGA capture unit into l2 -> prefetch 
	    NOT     %l2				; invert it bitwise						

;------------------------------------------------------------------------------------------------------------------

						; copy byte (2) to byte 3 of value 1 (3)
            ;ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 2			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction -> leave loop
 
	    BR      proc_byte_cbo		; next loop
	    NOP	



    ");


}



void ADC_CaptureCBOI_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, int32_t zerolevel)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_cboi
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_cboi
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_cboi
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_cboi
            NOP

        lpr_ch1_cboi:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_cboi
            NOP

        lpr_ch2_cboi:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_cboi
            NOP

        lpr_ch3_cboi:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_cboi
            NOP

        lpr_ch4_cboi:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_cboi:
						; preset registers with all needed values

	    LD      %l2, [%l1]			; read first 32 bit fetch from FPGA capture unit into l2 -> prefetch 
	    NOT     %l2				; invert it bitwise						
						
	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3 (ADC1)	
	    EXT8S   %r3, 0			; extract byte 0

	    ;MOV	    %r4, %l0  		; copy 32 bit offset value from l0 to r4 (ADC2)
	    ;EXT8S   %r4, 1			; extract byte 1
	    MOVI    %r4, 0			; preload register with 0

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r5 (ADC3)
	    EXT8S   %r5, 2			; extract byte 2

	    ;MOV	    %r6, %l0  		; copy 32 bit offset value from l0 to r6 (ADC4)
	    ;EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            MOVI    %l4, 0			; preload local register with 0 for limiter
            
            MOV    %l6, %i4			; copy zerolevel to local register
 	    LSLI   %l6, 1			; multiplicate with 2


	
	proc_byte_cboi: 			; begin of capture loop
	
            LD      %l5, [%l1]			; read second 32 bit fetch from FPGA capture unit into l5 (load from memory address) 
	    NOT     %l5				; invert it bitwise

;------------------------------------------------------------------------------------------------------------------
						; process byte 0 of value 2 (4)
            MOV	    %r6, %l5  			; copy l2 to r0	
            EXT8S   %r6, 0			; extract byte 0

	    SUB     %r6, %r3			; byte 0 offset adjustment -> ADC1-correction
	    
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l6            	; store doubled ZeroLevel in r2 (multiplication is done at register initialisation) 
	    SUB     %r2, %r6			; 2*ZL - Value => r2 = r2 - r6
	    MOV     %r6, %r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r6, %l4			; set r0 to 0


	    CMP     %l3, %r6			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r6, %l3			; remember byte 0(4) in r6 for later interpolating byte 5 (next byte)
	
ADD   %r4, %r6					; sum of byte (0) + (6) 
LSRI  %r4, 1					; divide by 2 (average)
FILL8   %r0, %r4				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter	    
    
            FILL8   %r0, %r6			; replicate byte 0 of r6 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; copy byte 0 to byte 1 of value 2 (5)
						
            ;ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 0 of value 1 (0)
            MOV     %r4, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r4, 0			; extract byte 0 to byte 0 of r4

	    SUB     %r4, %r3			; byte 0 offset adjustment -> ADC1-correction
	    
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l6            	; store doubled ZeroLevel in r2 (multiplication is done at register initialisation) 
	    SUB     %r2, %r4			; 2*ZL - Value => r2 = r2 - r0
	    MOV     %r4, %r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r4, %l4			; set r4 to 0

	    CMP     %l3, %r4			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r4, %l3			; store byte in r4 for later use

						; interpolate byte (5) (the byte before)
ADD   %r6, %r4					; sum of byte (4) + (0) 
LSRI  %r6, 1					; divide by 2 (average)
FILL8   %r0, %r6				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter

            FILL8   %r0, %r4			; replicate byte 0 of r4 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1 of value 1 (1)
            ;ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2 of value 2 (6) 
            MOV	    %r6, %l5  			; copy l5 to r0	
            EXT8S   %r6, 2			; extract byte 2

	    SUB     %r6, %r5			; byte 2 offset adjustment -> ADC3-correction
	    
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l6            	; store doubled ZeroLevel in r2 (multiplication is done at register initialisation) 
	    SUB     %r2, %r6			; 2*ZL - Value => r2 = r2 - r0
	    MOV     %r6, %r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r6, %l4			; set r0 to 0


	    CMP     %l3, %r6			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r6, %l3			; store byte in r6 for later use

						; interpolate byte (1) (the byte before)
ADD   %r4, %r6					; sum of byte (0) + (6) 
LSRI  %r4, 1					; divide by 2 (average)
FILL8   %r0, %r4				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter
	    
            FILL8   %r0, %r6			; replicate byte 0 of r6 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; copy byte (6) to byte 3 of value 2 (7)
            ;ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2 of value 1 (2)
            MOV     %r4, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r4, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r4, %r5			; byte 2 offset adjustment -> ADC3-correction
	    
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l6            	; store doubled ZeroLevel in r2 (multiplication is done at register initialisation) 
	    SUB     %r2, %r4			; 2*ZL - Value => r2 = r2 - r0
	    MOV     %r4, %r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r4, %l4			; set r0 to 0

	    CMP     %l3, %r4			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r4, %l3	

						; interpolate byte (7) (the byte before)
ADD   %r6, %r4					; sum of byte (6) + (2) 
LSRI  %r6, 1					; divide by 2 (average)
FILL8   %r0, %r6				; replicate the interplolated byte	    
ST8D    [%i1], %r0				; store the interpolated byte to RAM buffer
ADDI    %i1, 1					; increment address counter
	    
            FILL8   %r0, %r4			; replicate byte 0 of r4 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

	    LD      %l2, [%l1]			; read first 32 bit fetch from FPGA capture unit into l2 -> prefetch 
	    NOT     %l2				; invert it bitwise						

;------------------------------------------------------------------------------------------------------------------

						; copy byte (2) to byte 3 of value 1 (3)
            ;ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ;ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 2			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction -> leave loop
 
	    BR      proc_byte_cboi		; next loop
	    NOP	



    ");


}





//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

//BF get ADC-values from capture unit and store them inverted -> Assembler
void ADC_CaptureInv_ASM(uint32_t channel, uint8_t *signal, uint32_t highspeed, uint32_t int_count, uint8_t *offset, int32_t zerolevel)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_inv
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_inv
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_inv
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_inv
            NOP

        lpr_ch1_inv:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_inv
            NOP

        lpr_ch2_inv:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_inv
            NOP

        lpr_ch3_inv:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_inv
            NOP

        lpr_ch4_inv:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_inv:
						; preset registers with all needed values

	    LD      %l0, [%i4]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2
	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            MOVI    %l5, 0			; preload local register with 0 for limiter

            IFRZ    %i2                 	; highspeeed timebases?
            BR      capt_loop_slow_inv      	; if zero -> jump to slow tb capturing
            NOP	


	capt_loop_fast_inv:

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_inv:    
	    
            NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy l2 to r0	
            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store doubled ZeroLevel in r2 (multiplication is done at register initialisation) 
	    SUB     %r2, %r0			; 2*ZL - Value => r2 = r2 - r0

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i3, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_inv		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_inv		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

	    BR	    capt_end_inv		; go to the end
	    NOP



	capt_loop_slow_inv:

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

             ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i3, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_inv		; next loop
	    NOP

	capt_end_inv:

    ");


}
/*  This version works as the smooth/strong noise filter, the average is calculated between two or more sequenced samples 

//BF get ADC-values from capture unit, calculate average and store them not inverted. Only fast TB! -> Assembler
void ADC_CaptureAvgFast_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_favg
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_favg
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_favg
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_favg
            NOP

        lpr_ch1_favg:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_favg
            NOP

        lpr_ch2_favg:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_favg
            NOP

        lpr_ch3_favg:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_favg
            NOP

        lpr_ch4_favg:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_favg:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            MOVI    %l4, 0			; preload local register with 0 for limiter
            
	    PFX    %hi(128)
	    MOVI   %o0,%lo(128)			; preload old value register with 128 
	    
	    MOV   %o1, %o0			; preload old value register with 128 
	    MOV   %o2, %o0			; preload old value register with 128 
	    MOV   %o3, %o0			; preload old value register with 128 

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_fast_avg4      	; if 1 -> jump to deep average mode
            NOP	

            
            
	capt_loop_fast_avg2:			; normal averaging with 2 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_avg2:    
	    
            NOT     %l2				; invert it bitwise

 ;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg2		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg2		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

	    BR	    capt_end_favg		; go to the end
	    NOP



	capt_loop_fast_avg4:			; deep averaging with 4 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

	proc_byte0_avg4:    
	    
	    NOT     %l2				; invert it bitwise

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o0, %r0			; remember value
    
            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o1, %r0			; remember value
 
            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

 	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o2, %r0			; remember value
 
            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o3, %r0			; remember value
 
            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg4		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg4		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 


	capt_end_favg:

    ");


}
*/

/*  This version calculates the average between several complete acquisition runs, what provides a nice slow motion effect */ 
 
//BF get ADC-values from capture unit, calculate average and store them not inverted. Only fast TB! -> Assembler
void ADC_CaptureAvgFast_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_favg
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_favg
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_favg
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_favg
            NOP

        lpr_ch1_favg:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_favg
            NOP

        lpr_ch2_favg:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_favg
            NOP

        lpr_ch3_favg:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_favg
            NOP

        lpr_ch4_favg:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_favg:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            PFX     %hi(0)
            MOVI    %l4, %lo(0)			; preload local register with 0 for limiter

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_fast_avg4      	; if 1 -> jump to deep average mode
            NOP	


	capt_loop_fast_avg2:			; normal averaging with 2 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_avg2:
	
            NOT     %l2				; invert it bitwise

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg2		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg2		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	    BR	    capt_end_favg		; go to the end
	    NOP



	capt_loop_fast_avg4:			; deep averaging with 4 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_avg4: 
	 
            NOT     %l2				; invert it bitwise

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average


            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg4		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg4		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

	capt_end_favg:

    ");


}



/*  This version works as the smooth/strong noise filter, the average is calculated between two or more sequenced samples 
 * 
//BF get ADC-values from capture unit, calculate average and store them not inverted. Only slow TB! -> Assembler
void ADC_CaptureAvgSlow_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_savg
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_savg
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_savg
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_savg
            NOP

        lpr_ch1_savg:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_savg
            NOP

        lpr_ch2_savg:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_savg
            NOP

        lpr_ch3_savg:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_savg
            NOP

        lpr_ch4_savg:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_savg:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            PFX     %hi(0)
            MOVI    %l4, %lo(0)			; preload local register with 0 for limiter
            
	    PFX    %hi(128)
	    MOVI   %o0,%lo(128)			; preload old value register with 128 
	    
	    MOV   %o1, %o0			; preload old value register with 128 
	    MOV   %o2, %o0			; preload old value register with 128 
	    MOV   %o3, %o0			; preload old value register with 128 

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_slow_avg4      	; if 1 -> jump to deep average mode
            NOP	


	capt_loop_slow_avg2:			; normal averaging with 2 values
 
;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

 	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

 	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg2		; next loop
	    NOP
            BR	    capt_end_savg		; go to the end
	    NOP




	capt_loop_slow_avg4:

 ;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o1, %r0			; remember value
	    
            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

 	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o2, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o3, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg4		; next loop
	    NOP


	capt_end_savg:

    ");


}
*/

/*  This version calculates the average between several complete acquisition runs, what provides a nice slow motion effect */ 

//BF get ADC-values from capture unit, calculate average and store them not inverted. Only slow TB! -> Assembler
void ADC_CaptureAvgSlow_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{
    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_savg
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_savg
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_savg
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_savg
            NOP

        lpr_ch1_savg:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_savg
            NOP

        lpr_ch2_savg:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_savg
            NOP

        lpr_ch3_savg:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_savg
            NOP

        lpr_ch4_savg:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_savg:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

            PFX     %hi(0)
            MOVI    %l4, %lo(0)			; preload local register with 0 for limiter

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_slow_avg4      	; if 1 -> jump to deep average mode
            NOP	


	capt_loop_slow_avg2:			; normal averaging with 2 values

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg2		; next loop
	    NOP
            BR	    capt_end_savg		; go to the end
	    NOP




	capt_loop_slow_avg4:

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r0, %l4			; set r0 to 0

	    CMP     %l3, %r0			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r0, %l3	

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg4		; next loop
	    NOP


	capt_end_savg:

    ");


}


/*  This version works as the smooth/strong noise filter, the average is calculated between two or more sequenced samples 
 * 
//BF get ADC-values from capture unit, calculate average and store them inverted. Only fast TB! -> Assembler
void ADC_CaptureAvgInvFast_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{


    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_favgi
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_favgi
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_favgi
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_favgi
            NOP

        lpr_ch1_favgi:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_favgi
            NOP

        lpr_ch2_favgi:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_favgi
            NOP

        lpr_ch3_favgi:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_favgi
            NOP

        lpr_ch4_favgi:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_favgi:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2

	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            PFX     %hi(0)
            MOVI    %l5, %lo(0)			; preload local register with 0 for limiter

	    PFX    %hi(128)
	    MOVI   %o0,%lo(128)			; preload old value register with 128 
	    
	    MOV   %o1, %o0			; preload old value register with 128 
	    MOV   %o2, %o0			; preload old value register with 128 
	    MOV   %o3, %o0			; preload old value register with 128 
            
            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_fast_avg4i      	; if 1 -> jump to deep average mode
            NOP	


	capt_loop_fast_avg2i:			; normal averaging with 2 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address)
	    
	proc_byte0_avg2i:    
	    
            NOT     %l2				; invert it bitwise

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg2i	; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg2i		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

	    BR	    capt_end_fast_avgi		; go to the end
	    NOP



	capt_loop_fast_avg4i:			; deep averaging with 4 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_avg4i:    
	    
            NOT     %l2				; invert it bitwise

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

 	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o1, %r0			; remember values
	    
            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

  	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o2, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o3, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg4i	; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg4i		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 


	capt_end_fast_avgi:

    ");

}

*/

/*  This version calculates the average between several complete acquisition runs, what provides a nice slow motion effect */ 

//BF get ADC-values from capture unit, calculate average and store them inverted. Only fast TB! -> Assembler
void ADC_CaptureAvgInvFast_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{


    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_favgi
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_favgi
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_favgi
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_favgi
            NOP

        lpr_ch1_favgi:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_favgi
            NOP

        lpr_ch2_favgi:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_favgi
            NOP

        lpr_ch3_favgi:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_favgi
            NOP

        lpr_ch4_favgi:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_favgi:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2
	    ;SEXT8   %r5				; sign extension to 32 bit r5 now contains the third offset byte

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2

	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            PFX     %hi(0)
            MOVI    %l5, %lo(0)			; preload local register with 0 for limiter

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_fast_avg4i      	; if 1 -> jump to deep average mode
            NOP	


	capt_loop_fast_avg2i:			; normal averaging with 2 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	
	proc_byte0_avg2i:  
	    
            NOT     %l2				; invert it bitwise

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg2i	; next loop
	    ;NOP				; use delay slot to load data from capture unit
   	    BR      proc_byte0_avg2i		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 

            BR	    capt_end_fast_avgi		; go to the end
	    NOP



	capt_loop_fast_avg4i:			; deep averaging with 4 values

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
	    
	proc_byte0_avg4i:  
	
            NOT     %l2				; invert it bitwise

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------
						; process byte 0
            MOV	    %r0, %l2  			; copy new value to r0	
            EXT8S   %r0, 0			; extract byte 0
 	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 1
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average


            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 1) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 2
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 2) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
						; process byte 3
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 (our byte 3) to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_avg4i	; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_avg4i		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 


	capt_end_fast_avgi:

    ");

}




/*  This version works as the smooth/strong noise filter, the average is calculated between two or more sequenced samples  

//BF get ADC-values from capture unit, calculate average and store them inverted. Only slow TB! -> Assembler
void ADC_CaptureAvgInvSlow_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{


    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_savgi
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_savgi
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_savgi
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_savgi
            NOP

        lpr_ch1_savgi:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_savgi
            NOP

        lpr_ch2_savgi:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_savgi
            NOP

        lpr_ch3_savgi:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_savgi
            NOP

        lpr_ch4_savgi:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_savgi:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2

	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            PFX     %hi(0)
            MOVI    %l5, %lo(0)			; preload local register with 0 for limiter

	    PFX    %hi(128)
	    MOVI   %o0,%lo(128)			; preload old value register with 128 
	    
	    MOV   %o1, %o0			; preload old value register with 128 
	    MOV   %o2, %o0			; preload old value register with 128 
	    MOV   %o3, %o0			; preload old value register with 128 

            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_slow_avg4i      	; if 1 -> jump to deep average mode
            NOP	



	capt_loop_slow_avg2i:			; normal averaging with 2 values

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

             ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

	    ADD     %r0, %o0			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg2i	; next loop
	    NOP
            BR	    capt_end_savgi		; go to the end
	    NOP


	capt_loop_slow_avg4i:

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

 	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o0, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

 	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o1, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

 	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o3			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o2, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

 	    ADD     %r0, %o0			; add old value to new value
	    ADD     %r0, %o1			; add old value to new value
	    ADD     %r0, %o2			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average
	    
	    MOV     %o3, %r0			; remember value

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg4i	; next loop
	    NOP


	capt_end_savgi:

    ");

}
*/

/*  This version calculates the average between several complete acquisition runs, what provides a nice slow motion effect */ 

//BF get ADC-values from capture unit, calculate average and store them inverted. Only slow TB! -> Assembler
void ADC_CaptureAvgInvSlow_ASM(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{


    asm("
            CMPI    %i0, 0x00               ; Is it channel 1
            IFS     cc_z
            BR      lpr_ch1_savgi
            NOP

            CMPI    %i0, 0x01               ; Is it channel 2
            IFS     cc_z
            BR      lpr_ch2_savgi
            NOP

            CMPI    %i0, 0x02               ; Is it channel 3
            IFS     cc_z
            BR      lpr_ch3_savgi
            NOP

            CMPI    %i0, 0x03               ; Is it channel 4
            IFS     cc_z
            BR      lpr_ch4_savgi
            NOP

        lpr_ch1_savgi:
            PFX     %hi(0x00A00000)         ; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_savgi
            NOP

        lpr_ch2_savgi:
            PFX     %hi(0x00A00010)         ; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_savgi
            NOP

        lpr_ch3_savgi:
            PFX     %hi(0x00A00020)         ; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_savgi
            NOP

        lpr_ch4_savgi:
            PFX     %hi(0x00A00030)         ; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_savgi:
						; preset registers with all needed values

	    LD      %l0, [%i3]			; load offset values in one 32 bit fetch from memory to local register
	    MOV	    %r3, %l0  			; copy 32 bit offset value from l0 to r3	
	    EXT8S   %r3, 0			; extract byte 0

	    MOV	    %r4, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r4, 1			; extract byte 1

	    MOV	    %r5, %l0  			; copy 32 bit offset value from l0 to r4
	    EXT8S   %r5, 2			; extract byte 2

	    MOV	    %r6, %l0  			; copy 32 bit offset value from l0 to r6
	    EXT8S   %r6, 3			; extract byte 3

            MOV    %l3, %i5			; copy zerolevel to local register
 	    LSLI   %l3, 1			; multiplicate with 2

	
	    PFX    %hi(255)
	    MOVI   %l4,%lo(255)			; preload local register with 255 for limiter	
	
            PFX     %hi(0)
            MOVI    %l5, %lo(0)			; preload local register with 0 for limiter


            IFRNZ    %i4                 	; average mode = 1?
            BR      capt_loop_slow_avg4i      	; if 1 -> jump to deep average mode
            NOP	



	capt_loop_slow_avg2i:			; normal averaging with 2 values

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

             ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 1			; divide by 2 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg2i	; next loop
	    NOP
            BR	    capt_end_savgi		; go to the end
	    NOP


	capt_loop_slow_avg4i:

            LD	    %l7, [%i1]			; load 32 bit word from memory (signal buffer) to local register

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 0			; extract byte 0 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 0 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 1			; extract byte 1 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 1 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0

	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 2			; extract byte 2 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 2 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------
            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit into l2 (load from memory address) 
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
			
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
			
            ; start inverting	
            					; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %l3            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

            IFS     cc_n			; limiter -> check for negative value
	    MOV     %r2, %l5			; set r2 to 0
	
	    CMP     %l4, %r2			; limiter to 255
	    IFS     cc_n			; if r0 > 255 -> r0 = 255
	    MOV     %r2, %l4	

            MOV     %r0, %r2            	; copy result back

            ; end inverting		

            MOV	    %r7, %l7  			; copy old value to r7	
            EXT8S   %r7, 3			; extract byte 3 of old value

	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    ADD     %r0, %r7			; add old value to new value
	    LSRI    %r0, 2			; divide by 4 -> make average

            FILL8   %r0, %r0			; replicate byte 0 of r0 to byte 1 - 3 of r0
            ST8D    [%i1], %r0			; store byte 3 back to memory (signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i2, 4			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_avg4i	; next loop
	    NOP


	capt_end_savgi:

    ");

}
    



//BF get ADC-values from capture unit and store them maximum and minimum separated -> Assembler
/* 
 Registers:
 i0 - channel number 0 - 3
 i1 - sample values - minimum -> pointer to memory area
 i2 - sample values - maximum -> pointer to memory area
 i3 - timebase type -> high speed / low speed
 i4 - number of 32 bit samples to read out (int count)
 i5 - interval length (points to check for minimum and maximum)
 i6 - Framepointer -> pointer to offset 
 
 l0 - ADC offset values
 l1 - channel address
 l2 - signal value
 l3 - limiter to maximum (255)
 l4 - limiter to minimum (0)
 l5 - minimum value
 l6 - maximum value
 
 r0 - actual value
 r1 - interval counter
 r2 - 
 r3 - offset correction ADC 1
 r4 - offset correction ADC 2
 r5 - offset correction ADC 3
 r6 - offset correction ADC 4
 
 o0 - 4 x 8 bit offset vallue for preloading offset registers
 01 - 
 
*/ 
void ADC_PeakDetect_ASM(uint32_t channel, uint8_t *min, uint8_t *max, uint32_t highspeed, uint32_t int_count, uint32_t interval, uint8_t *offset)
{
	
	asm("
	    
	    pfx %hi(0x2e0)			; i6 (alias fp) has to be loaded right after register saving
            ld %l0, [%fp]			; load offset address from memory to l0
	
            CMPI    %i0, 0x00               	; Is it channel 1
            IFS     cc_z
            BR      lpr_peak_ch1
            NOP

            CMPI    %i0, 0x01               	; Is it channel 2
            IFS     cc_z
            BR      lpr_peak_ch2
            NOP

            CMPI    %i0, 0x02               	; Is it channel 3
            IFS     cc_z
            BR      lpr_peak_ch3
            NOP

            CMPI    %i0, 0x03               	; Is it channel 4
            IFS     cc_z
            BR      lpr_peak_ch4
            NOP

        lpr_peak_ch1:
            PFX     %hi(0x00A00000)         	; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_peak
            NOP

        lpr_peak_ch2:
            PFX     %hi(0x00A00010)         	; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_peak
            NOP

        lpr_peak_ch3:
            PFX     %hi(0x00A00020)         	; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_peak
            NOP

        lpr_peak_ch4:
            PFX     %hi(0x00A00030)         	; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_peak:
						; preset registers with all needed values

	    LDP     %o0,[%l0,0x0]		; get all 4 offset bytes in one 32 bit pointer fetch from memory
	    MOV	    %r3, %o0			; copy 32 bit offset value from o0 to r3
	    EXT8S   %r3, 0			; extract byte 0
	    
	    MOV	    %r4, %o0
	    EXT8S   %r4, 1			; extract byte 1
	    
	    MOV	    %r5, %o0
	    EXT8S   %r5, 2			; extract byte 2
   
	    MOV	    %r6, %o0
	    EXT8S   %r6, 3			; extract byte 3
	    
	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

	    ;PFX     %hi(0)
	    ;MOVI    %l4, %lo(0)		; preload local register with 0 for limiter
	    MOVI    %l4, 0
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	

	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
	    SUBI   %i5, 1			; correct interval length
	    MOV    %r1, %i5			; preload interval length

            IFRZ    %i3                	 	; highspeeed timebases?
            BR      capt_loop_slow_peak      	; if zero -> jump to slow tb capturing
	    NOP					; delay slot -> no operation while branching to subroutine

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	    
;               fast capture routine reading 16 kbyte sample data	    
	    
	capt_loop_fast_peak:			; data ara available in the 4 bytes of the 32 bit fetch. Byte 0 - 3 => ADC 0 - 3

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2

        proc_byte0_peak:
        
            NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
	
            MOV	    %r0, %l2  			; copy data word l2 to r0	
            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
	    
	    CMP	    %l6, %r0			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte0_peak
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
	    

;------------------------------------------------------------------------------------------------------------------
	proc_byte1_peak:			; process byte 1
	
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction

 	    CMP	    %l6, %r0			; check for maximum (r8 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (r8) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - r9 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (r9) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte1_peak
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------
	proc_byte2_peak:			; process byte 2
	
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

 	    CMP	    %l6, %r0			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - r9 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (r9) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte2_peak
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------
	proc_byte3_peak:			; process byte 3
	
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction

	    CMP	    %l6, %r0			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - r9 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (r9) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte3_peak
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_peak		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_peak		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2
	    
            BR	    capt_peak_end		; go to the end
	    NOP


;------------------------------------------------------------------------------------------------------------------
	
	store_byte0_peak:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte1_peak		; proceed with next byte
	    NOP
	

	store_byte1_peak:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte2_peak		; proceed with next byte
	    NOP
	
	store_byte2_peak:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte3_peak		; proceed with next byte
	    NOP
	
	store_byte3_peak:
	
	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction

            ;BR      capt_loop_fast_peak		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_peak		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2

	    BR	    capt_peak_end		; go to the end
	    NOP    	    


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	    
;               slow capture routine reading 4 kbyte sample data encapsulated in 16 kbyte readout data   
	    
	capt_loop_slow_peak:			; data ara available in the first byte of the 32 bit fetch

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into r0
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

	    CMP	    %l6, %r0			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte0_peak_slow
	    NOP
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_peak		; next loop
	    NOP
            BR	    capt_peak_end		; go to the end
	    NOP
	    
	    
	store_byte0_peak_slow:

	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_peak		; next loop
	    NOP
    	    
	    
	capt_peak_end:

    ");
	
	
}


/* assembler coded inverted peak detect readout */
/* 
 Registers:
 i0 - channel number 0 - 3
 i1 - sample values - minimum -> pointer to memory area
 i2 - sample values - maximum -> pointer to memory area
 i3 - timebase type -> high speed / low speed
 i4 - number of 32 bit samples to read out (int count)
 i5 - interval length (points to check for minimum and maximum)
 i6 - Framepointer -> pointer to offset 
 i7 - zerolevel
 
 l0 - ADC offset values
 l1 - channel address
 l2 - signal value
 l3 - limiter to maximum (255)
 l4 - limiter to minimum (0)
 l5 - minimum value
 l6 - maximum value
 
 r0 - actual value
 r1 - interval counter
 r2 - calculate negative value
 r3 - offset correction ADC 1
 r4 - offset correction ADC 2
 r5 - offset correction ADC 3
 r6 - offset correction ADC 4
 
 o0 - 4 x 8 bit offset vallue for preloading offset registers
 01 - zerolevel
 
*/ 
void ADC_PeakDetectInv_ASM(uint32_t channel, uint8_t *min, uint8_t *max, uint32_t highspeed, uint32_t int_count, uint32_t interval, uint8_t *offset, int32_t zerolevel)
{
 
	asm("
	    
	    pfx %hi(0x2e0)			; i6 (alias fp) has to be loaded right after register saving
            ld %l0, [%fp]			; load offset address from memory to l0
	
	    pfx %hi(0x300)			; i7 has to be loaded from memory
	    ld %o1, [%fp]			; load zerolevel from memory to r2
	
            CMPI    %i0, 0x00               	; Is it channel 1
            IFS     cc_z
            BR      lpr_peak_ch1_inv
            NOP

            CMPI    %i0, 0x01               	; Is it channel 2
            IFS     cc_z
            BR      lpr_peak_ch2_inv
            NOP

            CMPI    %i0, 0x02               	; Is it channel 3
            IFS     cc_z
            BR      lpr_peak_ch3_inv
            NOP

            CMPI    %i0, 0x03               	; Is it channel 4
            IFS     cc_z
            BR      lpr_peak_ch4_inv
            NOP

        lpr_peak_ch1_inv:
            PFX     %hi(0x00A00000)         	; load address channel 1
            MOVI    %l1,%lo(0x00A00000)
            PFX	    %xhi(0x00A00000)
            MOVHI   %l1,%xlo(0x00A00000)
            BR      reg_preset_peak_inv
            NOP

        lpr_peak_ch2_inv:
            PFX     %hi(0x00A00010)         	; load address channel 2
            MOVI    %l1,%lo(0x00A00010)
            PFX	    %xhi(0x00A00010)
            MOVHI   %l1,%xlo(0x00A00010)
            BR      reg_preset_peak_inv
            NOP

        lpr_peak_ch3_inv:
            PFX     %hi(0x00A00020)         	; load address channel 3
            MOVI    %l1,%lo(0x00A00020)
            PFX	    %xhi(0x00A00020)
            MOVHI   %l1,%xlo(0x00A00020)
            BR      reg_preset_peak_inv
            NOP

        lpr_peak_ch4_inv:
            PFX     %hi(0x00A00030)         	; load address channel 4
            MOVI    %l1,%lo(0x00A00030)
            PFX	    %xhi(0x00A00030)
            MOVHI   %l1,%xlo(0x00A00030)

	reg_preset_peak_inv:
						; preset registers with all needed values

	    LDP     %o0,[%l0,0x0]		; get all 4 offset bytes in one 32 bit pointer fetch from memory
	    MOV	    %r3, %o0			; copy 32 bit offset value from o0 to r3
	    EXT8S   %r3, 0			; extract byte 0
	    
	    MOV	    %r4, %o0
	    EXT8S   %r4, 1			; extract byte 1
	    
	    MOV	    %r5, %o0
	    EXT8S   %r5, 2			; extract byte 2
   
	    MOV	    %r6, %o0
	    EXT8S   %r6, 3			; extract byte 3
	    
	    PFX    %hi(255)
	    MOVI   %l3,%lo(255)			; preload local register with 255 for limiter	

	    ;PFX     %hi(0)
	    ;MOVI    %l4, %lo(0)			; preload local register with 0 for limiter
	    MOVI    %l4, 0
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	

	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
	    SUBI   %i5, 1			; correct interval length
	    MOV    %r1, %i5			; preload interval length
	    
    	    LSLI   %o1, 1			; multiplicate zero level with 2

            IFRZ    %i3                	 	; highspeeed timebases?
            BR      capt_loop_slow_peak_inv    	; if zero -> jump to slow tb capturing
	    NOP					; delay slot -> no operation while branching to subroutine

;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	    
;               fast capture routine reading 16 kbyte sample data	    
	    
	capt_loop_fast_peak_inv:		; data ara available in the 4 bytes of the 32 bit fetch. Byte 0 - 3 => ADC 0 - 3

            LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2

        proc_byte0_peak_inv:
        
            NOT     %l2				; invert it bitwise
;------------------------------------------------------------------------------------------------------------------
						; process byte 0
	
            MOV	    %r0, %l2  			; copy data word l2 to r0	
            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction
	    
    	    ; start inverting	
						; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %o1            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

	    CMP	    %l6, %r2			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r2     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r2, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r2     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte0_peak_inv
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
	    

;------------------------------------------------------------------------------------------------------------------
	proc_byte1_peak_inv:			; process byte 1
	
            MOV	    %r0, %l2  			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 1			; extract byte 1 to byte 0 of r0
	
	    SUB     %r0, %r4			; byte 1 offset adjustment -> ADC2-correction

   	    ; start inverting	
						; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %o1            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

	    CMP	    %l6, %r2			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r2     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r2, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r2     		; -> then copy new value to minimum buffer			
	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte1_peak_inv
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------
	proc_byte2_peak_inv:			; process byte 2
	
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 2			; extract byte 2 to byte 0 of r0

	    SUB     %r0, %r5			; byte 2 offset adjustment -> ADC3-correction

    	    ; start inverting	
						; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %o1            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

	    CMP	    %l6, %r2			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r2     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r2, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r2     		; -> then copy new value to minimum buffer			
	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte2_peak_inv
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------
	proc_byte3_peak_inv:			; process byte 3
	
            MOV     %r0, %l2 			; copy l2 to r0 again (refresh register)
            EXT8S   %r0, 3			; extract byte 3 to byte 0 of r0
			
	    SUB     %r0, %r6			; byte 3 offset adjustment -> ADC4-correction

   	    ; start inverting	
						; ZL + (ZL - Value) => 2*ZL - Value
	    MOV     %r2, %o1            	; store ZeroLevel * 2
	    SUB     %r2, %r0			; 2*ZL - Value => r2

	    CMP	    %l6, %r2			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r2     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r2, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r2     		; -> then copy new value to minimum buffer			
	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte3_peak_inv
	    ;NOP				; use delay slot for comparing
	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            ;BR      capt_loop_fast_peak_inv		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_peak_inv		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2
	    
            BR	    capt_peak_end_inv		; go to the end
	    NOP


;------------------------------------------------------------------------------------------------------------------
	
	store_byte0_peak_inv:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte1_peak_inv		; proceed with next byte
	    NOP

	store_byte1_peak_inv:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte2_peak_inv		; proceed with next byte
	    NOP
	
	store_byte2_peak_inv:

	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter
	
	    BR     proc_byte3_peak_inv		; proceed with next byte
	    NOP
	
	store_byte3_peak_inv:
	
	    ;CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction

            ;BR      capt_loop_fast_peak_inv		; next loop
	    ;NOP				; use delay slot to load data from capture unit
	    BR      proc_byte0_peak_inv		; next loop
	    LD      %l2, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into l2

	    BR	    capt_peak_end_inv		; go to the end
	    NOP    	    


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++	    
;               slow capture routine reading 4 kbyte sample data encapsulated in 16 kbyte readout data   
	    
	capt_loop_slow_peak_inv:		; data ara available in the first byte of the 32 bit fetch

;------------------------------------------------------------------------------------------------------------------

            LD      %r0, [%l1]			; read data in one 32 bit fetch from FPGA capture unit (address in l1) into r0
            NOT     %r0				; invert it bitwise

            EXT8S   %r0, 0			; extract byte 0
	
	    SUB     %r0, %r3			; byte 0 offset adjustment -> ADC1-correction

	    CMP	    %l6, %r0			; check for maximum (l6 - r0 -> check condition code)
	    IFS	    cc_n			; if max value (l6) is lower than new value (r0) 
	    MOV     %l6, %r0     		; -> then copy new value to maximum buffer l6			
				
				
	    CMP	    %r0, %l5			; check for minimum (r0 - l5 -> check condition code)
	    IFS	    cc_n			; if new value (r0) is lower than min value (l5) 
	    MOV     %l5, %r0     		; -> then copy new value to minimum buffer			

	    
	    IFRZ    %r1				; check if interval counter is zero
	    BR      store_byte0_peak_slow_inv
	    NOP
	    
	    SUBI    %r1, 1			; decrement interval counter by 1
;------------------------------------------------------------------------------------------------------------------

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_peak_inv	; next loop
	    NOP
            BR	    capt_peak_end_inv		; go to the end
	    NOP
	    
	    
	store_byte0_peak_slow_inv:

	    CMP     %l5, %l4			; limiter to 0 (l5 - 0 -> check if l5 is negative)
            IFS     cc_n			; limiter -> check for negative value
	    MOV     %l5, %l4			; set l5 to 0

	    CMP     %l3, %l6			; limiter to 255
	    IFS     cc_n			; if l6 > 255 -> l6 = 255
	    MOV     %l6, %l3	
						; store minumum
	    FILL8   %r0, %l5			; replicate byte 0 of l5 to byte 1 - 3 of r0
	    ST8D    [%i1], %r0			; store byte 0 back to memory (minimum signal buffer)
	    ADDI    %i1, 1 			; increment address counter of signal buffer to the next byte
	    
						; store maximum
	    FILL8   %r0, %l6			; replicate byte 0 of l6 to byte 1 - 3 of r0
	    ST8D    [%i2], %r0			; store byte 0 back to memory (maximum signal buffer)
	    ADDI    %i2, 1 			; increment address counter of signal buffer to the next byte
	    
	    MOV    %l5, %l3			; preload register with 255 for minimum value	
	    MOV    %l6, %l4			; preload register with 0 for maximum value
	    
    	    MOV   %r1, %i5			; load interval length to counter

            SUBI    %i4, 1			; decrement integer value counter (loop counter)
            SKPS    cc_z			; if argument is zero skip next instruction
            BR      capt_loop_slow_peak_inv		; next loop
	    NOP
    	    
	    
	capt_peak_end_inv:

    ");


}


/* C-coded peak detect readout */
void ADC_PeakDetect(uint32_t channel, uint8_t *min, uint8_t *max, uint32_t highspeed, uint32_t int_count, uint32_t interval, uint8_t *offset)
{
//test456
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register int32_t minbuff = 255;
	register int32_t maxbuff = 0;
	register uint32_t cntbuff = interval;						// interval counter
	register uint32_t indexbuff = 0;						// byte index

	// delay compensation in fast acquisition TB (1 GSa/S) -> shift buffer address 
	if(MainTimebase < 8)
	{	
		uint32_t delay = Hardware::_ChannelDelay[channel] / draw_factor;
		min += delay;						// shift buffer address (1 byte = 1nS)
		max += delay;
	}

	
	if (highspeed)									// highspeed  -> 16KB memory and all 4 ADC
	{ 
		// load ADC offsets from memory to the offset registers
		register uint32_t offset1 = offset[0];
		register uint32_t offset2 = offset[1];
		register uint32_t offset3 = offset[2];
		register uint32_t offset4 = offset[3];


		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level
			
				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}


			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = bytebuff - offset2;					// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}

			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = bytebuff - offset3;					// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}			
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = bytebuff - offset4;					// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}			
			
		}	
	}
	else										// Lowspeed -> 4kB memory and only one ADC
	{
		register int32_t offset1 = Hardware::_ADC_Offset[channel][0];

		// read byte data integer aligned from FPGA register
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains 1 byte from ADC 1
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}
		}
	}

	
}
/* C-coded inverted peak detect readout */
void ADC_PeakDetectInv(uint32_t channel, uint8_t *min, uint8_t *max, uint32_t highspeed, uint32_t int_count, uint32_t interval, uint8_t *offset, int32_t zerolevel)
{

	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register int32_t minbuff = 255;
	register int32_t maxbuff = 0;
	register uint32_t cntbuff = interval;						// interval counter
	register uint32_t indexbuff = 0;						// byte index

	// delay compensation in fast acquisition TB (1 GSa/S) -> shift buffer address 
	if(MainTimebase < 8)
	{	
		uint32_t delay = Hardware::_ChannelDelay[channel] / draw_factor;
		min += delay;						// shift buffer address (1 byte = 1nS)
		max += delay;
	}

	zerolevel = zerolevel << 1;
	
	if (highspeed)									// highspeed  -> 16KB memory and all 4 ADC
	{ 
		// load ADC offsets from memory to the offset registers
		register uint32_t offset1 = offset[0];
		register uint32_t offset2 = offset[1];
		register uint32_t offset3 = offset[2];
		register uint32_t offset4 = offset[3];


		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level
			
				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}


			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = (zerolevel - bytebuff) + offset2;			// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}

			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}			
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}			
			
		}	
	}
	else										// Lowspeed -> 4kB memory and only one ADC
	{
		register int32_t offset1 = Hardware::_ADC_Offset[channel][0];

		// read byte data integer aligned from FPGA register
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains 1 byte from ADC 1
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > maxbuff)						// check for new maximum
			maxbuff = intbuff;
			
			if (intbuff < minbuff)						// check for new minimum
			minbuff = intbuff;
			
			if (cntbuff == 1)
			{
				if (maxbuff > 255)					// limit to upper level
				maxbuff = 255;
				else if (minbuff < 0)
				minbuff = 0;						// limit to lower level

				min[indexbuff] = (uint8_t)minbuff;			// store minimum to memory in byte format
				max[indexbuff] = (uint8_t)maxbuff;			// store maximum to memory in byte format
				minbuff = 255;						// initialize minimum buffer
				maxbuff = 0;						// initialize maximum buffer
				cntbuff = interval;					// reload interval counter
				indexbuff++;						// increment memory index
			}
			else
			{	
				cntbuff--;						// decrement interval counter
			}
		}
	}

	
}


/* C-coded ADC readout -> not inverted */
void ADC_Capture(uint32_t channel, uint8_t *signal, uint32_t highspeed, uint32_t int_count, uint8_t *offset)
{
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index
	
	if (highspeed)									// highspeed  -> 16KB memory and all 4 ADC
	{ 
		// load ADC offsets from memory to the offset registers
		register uint32_t offset1 = offset[0];
		register uint32_t offset2 = offset[1];
		register uint32_t offset3 = offset[2];
		register uint32_t offset4 = offset[3];


		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = bytebuff - offset2;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = bytebuff - offset3;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = bytebuff - offset4;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
	}
	else										// Lowspeed -> 4kB memory and only one ADC
	{
		register int32_t offset1 = Hardware::_ADC_Offset[channel][0];

		// read byte data integer aligned from FPGA register
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains 1 byte from ADC 1
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index

		}
	}
	
}

/* C-coded ADC readout -> inverted */
void ADC_CaptureInv(uint32_t channel, uint8_t *signal, uint32_t highspeed, uint32_t int_count, uint8_t *offset, int32_t zerolevel)
{
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index
	
	zerolevel = zerolevel << 1;							// multiplicate with 2
	
	if (highspeed)									// highspeed  -> 16KB memory and all 4 ADC
	{ 
		// load ADC offsets from memory to the offset registers
		register uint32_t offset1 = offset[0];
		register uint32_t offset2 = offset[1];
		register uint32_t offset3 = offset[2];
		register uint32_t offset4 = offset[3];


		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			//bytebuff = (uint8_t)readbuff;
			intbuff = (zerolevel - bytebuff) + offset2;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = (zerolevel - bytebuff) + offset3;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = (zerolevel - bytebuff) + offset4;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
	}
	else										// Lowspeed -> 4kB memory and only one ADC
	{
		register int32_t offset1 = Hardware::_ADC_Offset[channel][0];

		// read byte data integer aligned from FPGA register
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains 1 byte from ADC 1
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index

		}
	}
	
	

}

/* C-coded ADC readout -> calculate average and store not inverted. Only fast TB! */
void ADC_CaptureAvgFast(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index

	// load ADC offsets from memory to the offset registers
	register uint32_t offset1 = offset[0];
	register uint32_t offset2 = offset[1];
	register uint32_t offset3 = offset[2];
	register uint32_t offset4 = offset[3];

	
	
	if (avg_mode == 0)	// average mode flat
	{ 

		register uint32_t oldvalbuff = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = bytebuff - offset2;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = bytebuff - offset3;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = bytebuff - offset4;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
	}
	else		// average mode deep
	{
		register uint32_t oldbuff1 = 128;
		register uint32_t oldbuff2 = 128;
		register uint32_t oldbuff3 = 128;
		register uint32_t oldbuff4 = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff2;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff1 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = bytebuff - offset2;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff2 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = bytebuff - offset3;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff3 = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = bytebuff - offset4;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff3;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff4 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
		
		
		
	}
	
}

/* C-coded ADC readout -> calculate average and store not inverted. Only slow TB! */
void ADC_CaptureAvgSlow(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode)
{

	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index

	// load ADC offset from memory to the offset registers
	register uint32_t offset1 = offset[0];
	
	
	if (avg_mode == 0)	// average mode flat
	{ 

		register uint32_t oldvalbuff = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
		}	
	}
	else		// average mode deep
	{
		register uint32_t oldbuff1 = 128;
		register uint32_t oldbuff2 = 128;
		register uint32_t oldbuff3 = 128;
		register uint32_t oldbuff4 = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		for(;;)
		{
			// first byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff2;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff1 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			if (int_count == 0) return;

			// second byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff2 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			if (int_count == 0) return;
			
			// third byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff3 = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			if (int_count == 0) return;
		
			// fourth byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = bytebuff - offset1;					// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff3;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff4 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			if (int_count == 0) return;
			
		}	
	
		
	}
	
	
}

/* C-coded ADC readout -> calculate average and store inverted. Only fast TB! */
void ADC_CaptureAvgInvFast(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index

	// load ADC offsets from memory to the offset registers
	register uint32_t offset1 = offset[0];
	register uint32_t offset2 = offset[1];
	register uint32_t offset3 = offset[2];
	register uint32_t offset4 = offset[3];

	zerolevel = zerolevel << 1;	
	
	if (avg_mode == 0)	// average mode flat
	{ 

		register uint32_t oldvalbuff = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = (zerolevel - bytebuff) + offset2;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = (zerolevel - bytebuff) + offset3;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = (zerolevel - bytebuff) + offset4;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
	}
	else		// average mode deep
	{
		register uint32_t oldbuff1 = 128;
		register uint32_t oldbuff2 = 128;
		register uint32_t oldbuff3 = 128;
		register uint32_t oldbuff4 = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff2;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff1 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			

			// second byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract second byte
			intbuff = (zerolevel - bytebuff) + offset2;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff2 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// third byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract third byte
			intbuff = (zerolevel - bytebuff) + offset3;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff3 = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			
			// fourth byte
			readbuff = readbuff >> 8;
			bytebuff = readbuff & 0x000000FF;				// extract fourth byte
			intbuff = (zerolevel - bytebuff) + offset4;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff3;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff4 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
		}	
		
		
		
	}
		
	
}

/* C-coded ADC readout -> calculate average and store inverted. Only slow TB! */
void ADC_CaptureAvgInvSlow(uint32_t channel, uint8_t *signal, uint32_t int_count, uint8_t *offset, uint32_t avg_mode, int32_t zerolevel)
{
	volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
	
	register int32_t intbuff;
	register uint32_t readbuff;
	register uint32_t bytebuff;
	register uint32_t indexbuff = 0;						// byte index

	// load ADC offset from memory to the offset registers
	register uint32_t offset1 = offset[0];
	
	zerolevel = zerolevel << 1;
	
	if (avg_mode == 0)	// average mode flat
	{ 

		register uint32_t oldvalbuff = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		while (--int_count)
		{
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains all 4 bytes from the 4 ADCs
			// first byte
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldvalbuff;						// add last value to new value
			intbuff = intbuff >> 1;						// calculate average
			
			oldvalbuff = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
		}	
	}
	else		// average mode deep
	{
		register uint32_t oldbuff1 = 128;
		register uint32_t oldbuff2 = 128;
		register uint32_t oldbuff3 = 128;
		register uint32_t oldbuff4 = 128;

		int_count++;								// because of below pre-decrement

		// read byte data integer aligned from FPGA register
		// byte processing with loop rollout for better performance
		for(;;)
		{
			// first byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff2;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff1 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index

			if (int_count == 0) return;

			// second byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff3;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff2 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index

			if (int_count == 0) return;
			
			// third byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff4;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff3 = intbuff;						// remember the value
		
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index
			
			if (int_count == 0) return;
			
			// fourth byte
			int_count--;
			readbuff = ~*regAddr;						// read register integer aligned and invert all bytes
											// readbuf now contains one byte from ADC 1
			bytebuff = readbuff & 0x000000FF;				// extract first byte
			intbuff = (zerolevel - bytebuff) + offset1;			// make offset correction 

			if (intbuff > 255)						// limit to upper level
			intbuff = 255;
			else if (intbuff < 0)
			intbuff = 0;							// limit to lower level

			intbuff += oldbuff1;						// add last value to new value
			intbuff += oldbuff2;
			intbuff += oldbuff3;
			intbuff = intbuff >> 2;						// calculate average
			
			oldbuff4 = intbuff;						// remember the value
			
			signal[indexbuff] = (uint8_t)intbuff;				// store byte to memory
			indexbuff++;							// increment memory index

			if (int_count == 0) return;
			
		}	
	
		
	}	
}

//#####################################################################################################################################################
// ADC driver selection
void Hardware::ADC_ReadData(uint32_t channel, unsigned char *signal, uint32_t int_count, bool invert)
{

	//channel coupling = ground -> set all values to zero		BF -> new ground function 
	if (MenuStatus[channel+1][0] == 6) //GND-coupling
	{
		for(int i=0;i<0x4000;i++) signal[i] = (unsigned char)_ADC_VirtualZero[channel];
		return;
	}

	// delay compensation in fast acquisition TB (1 GSa/S) 
	if(MainTimebase < 8)
	{	
		signal += _ChannelDelay[channel];						// shift buffer address (1 byte = 1nS)
	}





	if (MenuStatus[MENU_HARDWARE][3] == 351)//=======================================================================================================================
	{
		/* Assembler coded driver */


		if (invert)	// inverted
		{
			if (ACQ_HighSpeed)						//Highspeed  -> 16KB memory
			{
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					if (MainTimebase == 9 || MainTimebase == 10)
					ADC_CaptureCBOI_ASM(channel, signal, int_count, _ADC_Offset[channel], _ADC_VirtualZero[channel]);	
					else	
					ADC_CaptureInv_ASM(channel, signal, 1, int_count, _ADC_Offset[channel], _ADC_VirtualZero[channel]); 
				}
				else
				{
					ADC_CaptureAvgInvFast_ASM(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average, _ADC_VirtualZero[channel]); 
				}
			}
			else								//Lowspeed   -> 4KB memory
			{ 
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_CaptureInv_ASM(channel, signal, 0, int_count, _ADC_Offset[channel], _ADC_VirtualZero[channel]); 
				}
				else
				{
					ADC_CaptureAvgInvSlow_ASM(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average, _ADC_VirtualZero[channel]); 
				}
			}

		}
		else		// not inverted
		{
			if (ACQ_HighSpeed)						//Highspeed  -> 16KB memory
			{
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					if (MainTimebase == 9 || MainTimebase == 10)
					ADC_CaptureCBO_ASM(channel, signal, int_count, _ADC_Offset[channel]);	
					else	
					ADC_Capture_ASM(channel, signal, 1, int_count, _ADC_Offset[channel]); 
					
					
				}
				else
				{
					ADC_CaptureAvgFast_ASM(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average); 
				}
			}
			else											//Lowspeed   -> 4KB memory
			{ 
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_Capture_ASM(channel, signal, 0, int_count, _ADC_Offset[channel]); 
				}
				else
				{
					ADC_CaptureAvgSlow_ASM(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average); 
				}
			}

		}


	}
	else if (MenuStatus[MENU_HARDWARE][3] == 352)//===================================================================================================================
	{
		// readout routine with quick and dirty 32 bit integer fetch -> no byte overflow protection

		volatile uint32_t* regAddr = (uint32_t *) RegADC[channel];
		uint32_t read_out_cnt = int_count + 1;						// because of below pre-decrement
		
		
		// The Signal comes head over heals -> so we have to invert it for correct
		// display. Therefor we only have to adjust the virtual zero in inverted mode.
		if (invert)
		{
			unsigned char adc_v_zero = _ADC_VirtualZero[channel] << 1;
			unsigned long adc_v_zero32 = 0;
	
			// shift 8 bit virtual ADC-zero byte for byte into 32 bit integer
			adc_v_zero32 = (int)adc_v_zero;
			adc_v_zero32 = adc_v_zero32 << 8;
			adc_v_zero32 = adc_v_zero32 | (int)adc_v_zero;
			adc_v_zero32 = adc_v_zero32 << 8;
			adc_v_zero32 = adc_v_zero32 | (int)adc_v_zero;
			adc_v_zero32 = adc_v_zero32 << 8;
			adc_v_zero32 = adc_v_zero32 | (int)adc_v_zero;
	
	
			if (ACQ_HighSpeed)								// Highspeed  -> 16KB memory and all 4 ADC
			{ 
				unsigned long *uint32_buffer = (unsigned long *) signal;		// point with 32 bit integer to the signal buffer
				int *adc_offs = (int *) _ADC_Offset[channel];				// assign 32 bit integer pointer to offset bytes
				int offset = *adc_offs;
	
				// read byte data integer aligned from FPGA register
				while (--read_out_cnt)
				{
					*uint32_buffer++ = adc_v_zero32 + (*regAddr + offset);		// make offset correction for all 4 bytes in one step
				}									// and copy bytes integer aligned into the signal buffer
			}
			else										// Lowspeed -> 4kB memory and only one ADC
			{
				char offset = _ADC_Offset[channel][0];
	
				// read byte data integer aligned from FPGA register
				while (--read_out_cnt)
				{
					*signal++ = adc_v_zero + (unsigned char) *regAddr + offset;	// make offset correction for all 4 bytes in one step
				}									// and copy the first byte into the signal buffer
			}
		}
		else
		{
			if (ACQ_HighSpeed)								// Highspeed  -> 16KB memory and all 4 ADC
			{ 
				unsigned long *uint32_buffer = (unsigned long *) signal;		// point with 32 bit integer to the signal buffer
				int *adc_offs = (int *) _ADC_Offset[channel];				// assign 32 bit integer pointer to offset bytes
				int offset = *adc_offs;
	
				// read byte data integer aligned from FPGA register
				while (--read_out_cnt)
				{
					*uint32_buffer++ = ~*regAddr - offset;				// make offset correction for all 4 bytes in one step
				}									// and copy bytes integer aligned into the signal buffer
			}
			else										// Lowspeed -> 4kB memory and only one ADC
			{
				char offset = _ADC_Offset[channel][0];;
				// read byte data integer aligned from FPGA register
				while (--read_out_cnt)
				{
					*signal++ = ~(unsigned char) *regAddr - offset; 		// make offset correction for all 4 bytes in one step
				}									// and copy the first byte into the signal buffer
			}
		}
	}
	else//=============================================================================================================================================================
	{	// Standard driver (350)
		/* C-coded drivers as default */

		if (invert)	// inverted
		{
			if (ACQ_HighSpeed)						//Highspeed  -> 16KB memory
			{
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_CaptureInv(channel, signal, 1, int_count, _ADC_Offset[channel], _ADC_VirtualZero[channel]); 
				}
				else
				{
					ADC_CaptureAvgInvFast(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average, _ADC_VirtualZero[channel]); 
				}
			}
			else								//Lowspeed   -> 4KB memory
			{ 
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_CaptureInv(channel, signal, 0, int_count, _ADC_Offset[channel], _ADC_VirtualZero[channel]); 
				}
				else
				{
					ADC_CaptureAvgInvSlow(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average, _ADC_VirtualZero[channel]); 
				}
			}

		}
		else	// not inverted
		{
			if (ACQ_HighSpeed)						//Highspeed  -> 16KB memory
			{
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_Capture(channel, signal, 1, int_count, _ADC_Offset[channel]);
				}
				else
				{
					ADC_CaptureAvgFast(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average); 
				}
			}
			else											//Lowspeed   -> 4KB memory
			{ 
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_OFF)		//Average  off?
				{
					ADC_Capture(channel, signal, 0, int_count, _ADC_Offset[channel]); 
				}
				else
				{
					ADC_CaptureAvgSlow(channel, signal, int_count, _ADC_Offset[channel], ACQ_Average); 
				}
			}

		}
   
	}
 
}

//#####################################################################################################################################################
void Hardware::DoEnableADCInterrupt(void)							// Enable ADC service routine
{
	acq_ready->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	acq_ready->np_piodirection = 0;								// set bit to input
	acq_ready->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_data_acq_interrupt_irq,ISR_ADC_INT,(int)acq_ready);		// Install ISR for ADC
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt enabled.\n"); 							// print on console
#endif
}
//#####################################################################################################################################################
void Hardware::DoDisableADCInterrupt(void)							// Disable ADC service routine
{
	
	nr_installuserisr(na_data_acq_interrupt_irq,0,0); 				// Install empty routine for adc irq
	acq_ready->np_piointerruptmask = 0x00;							// disable all IRQs
	
#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nADC interrupt disabled.\n"); 							// print on console
#endif	
}
//#####################################################################################################################################################
	//--------------------------------------------------------------------------------------
	//        	 ultra slow timebase mode (roll mode / shift mode)
	//--------------------------------------------------------------------------------------
	//  				USTB-engine V2.1
	//--------------------------------------------------------------------------------------
inline void Handle_USTB(void)							// ADC handler for ultra slow TB
{

	//if (UI_request && !ZL_changed)	return;			// BF add  don't handle ADC if user interface must be handled first except zero level adjustment

	//if (RC_request)	return;					// BF signal recall is requested -> don't handle ADC

	if (MenuStatus[MENU_TRIGGERSUB][1] > 119)			//acquisition event occured
	{
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
		{ LED_ON[3] = 1; }					//Channel 4 LED on
		else 
		{ LED_ON[11] = 1; }					//right LED (red) on 
		Hardware::Send_LED();
	}


	data_adr->np_piodata = 0x01;

	//BF set buffer start address
	Hardware::WriteADC(eCh1, 0);	
	Hardware::WriteADC(eCh2, 0);
	
	if (NumberOfChannels == 4)
	{				
		Hardware::WriteADC(eCh3, 0);
		Hardware::WriteADC(eCh4, 0);
	}

	data_adr->np_piodata = 0x00;

	//-------------------------------------------------------
	//		Signal Acquisition
	//-------------------------------------------------------
	if (Channel[eCh1].active)
	{
		//channel coupling = ground -> set all values to zero	
		if (MenuStatus[MENU_CHANNEL1][0] == 6) //GND-coupling
		{ 
			for(int i=0;i<32;i++) SIGNAL1_USTB[i] = (unsigned char)Hardware::_ADC_VirtualZero[eCh1];
			Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL1][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh1], SIGNAL1_USTB, S1Ptr);
		}
		else
		{
			Hardware::ADC_ReadData(eCh1, SIGNAL1_USTB, 32, MenuStatus[MENU_CHANNEL1][2] - BTN_OFF);
			Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL1][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh1], SIGNAL1_USTB, S1Ptr);
		}
	}
	
	if (Channel[eCh2].active)
	{
		//channel coupling = ground -> set all values to zero	
		if (MenuStatus[MENU_CHANNEL2][0] == 6) //GND-coupling
		{ 
			for(int i=0;i<32;i++) SIGNAL2_USTB[i] = (unsigned char)Hardware::_ADC_VirtualZero[eCh2];
			Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL2][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh2], SIGNAL2_USTB, S2Ptr);
		}
		else
		{
			Hardware::ADC_ReadData(eCh2, SIGNAL2_USTB, 32, MenuStatus[MENU_CHANNEL2][2] - BTN_OFF);
			Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL2][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh2], SIGNAL2_USTB, S2Ptr);
		}
	}	
	
	if (NumberOfChannels == 4)
	{	
		if (Channel[eCh3].active == 1)
		{
			//channel coupling = ground -> set all values to zero	
			if (MenuStatus[MENU_CHANNEL3][0] == 6) //GND-coupling
			{ 
				for(int i=0;i<32;i++) SIGNAL3_USTB[i] = (unsigned char)Hardware::_ADC_VirtualZero[eCh3];
				Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL3][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh3], SIGNAL3_USTB, S3Ptr);
			}
			else
			{
				Hardware::ADC_ReadData(eCh3, SIGNAL3_USTB, 32, MenuStatus[MENU_CHANNEL3][2] - BTN_OFF);
				Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL3][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh3], SIGNAL3_USTB, S3Ptr);
			}
		}
	
		if (Channel[eCh4].active == 1)
		{
			//channel coupling = ground -> set all values to zero	
			if (MenuStatus[MENU_CHANNEL4][0] == 6) //GND-coupling
			{ 
				for(int i=0;i<32;i++) SIGNAL4_USTB[i] = (unsigned char)Hardware::_ADC_VirtualZero[eCh4];
				Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL4][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh4], SIGNAL4_USTB, S4Ptr);
			}
			else
			{
				Hardware::ADC_ReadData(eCh4, SIGNAL4_USTB, 32, MenuStatus[MENU_CHANNEL4][2] - BTN_OFF);
				Signal::USTB_insertSample(MenuStatus[MENU_CHANNEL4][2] - BTN_OFF, (unsigned char)Hardware::_ADC_VirtualZero[eCh4], SIGNAL4_USTB, S4Ptr);
			}
		}
	}	

	//printf("Acquisition ready!\r\n");

	//printf("MemStartOffs: %d  MemoryEnd: %d  MemWinStart: %d  USTB_idx: %d\r",MemStartOffs, MemoryEnd, MemWinStart, USTB_idx);

	//-------------------------------------------------------
	//		Math calculation
	//-------------------------------------------------------
	if (Channel[eChM].active)
	{
		if (Channel[eCh1].active && Channel[eCh2].active)
		{
			//---------------------------------------------
			//         MATH function multiply
			//---------------------------------------------
			if (MenuStatus[MENU_MATH][2] == BTN_ON)      		// multiply 
			{	
				//set global math scaling and offset for drawing routine
				math_scale = math_mul_scale - 166;
				Math_Offset = Math_Mul_Offset;
				
				//calculate main math signal
				Signal::calcMathMul(USTB_idx, USTB_idx+1, draw_factor, S1Ptr, S2Ptr, SMPtr);
			}	//multiply end
	
			//---------------------------------------------
			//         MATH function subtract
			//---------------------------------------------
			else if (MenuStatus[MENU_MATH][3] == BTN_ON)           	// subtract
			{	
				//set global math scaling and offset for drawing routine
				math_scale = math_sub_scale - 150;
				Math_Offset = Math_Sub_Offset;

				//calculate main math signal
				Signal::calcMathSub(USTB_idx, USTB_idx+1, draw_factor, S1Ptr, S2Ptr, SMPtr);
			}	//subtract end
	
			//---------------------------------------------
			//         MATH function add
			//---------------------------------------------
			else if (MenuStatus[MENU_MATH][4] == BTN_ON)           	// add
			{
				//set global math scaling and offset for drawing routine
				math_scale = math_add_scale - 150;
				Math_Offset = Math_Add_Offset;
				
				//calculate main math signal
				Signal::calcMathAdd(USTB_idx, USTB_idx+1, draw_factor, S1Ptr, S2Ptr, SMPtr);
			}	//add end
		}
		else if ((!Channel[eCh1].active && Channel[eCh2].active) || (!Channel[eCh2].active && Channel[eCh1].active))
		{ SMPtr[USTB_idx] = ADC_ZERO;	 }
	}

	//-------------------------------------------------------
	//		Time parameter control
	//-------------------------------------------------------

	// set time pointer to new position
	if (USTB_Dir == USTB_FORWARD)								// direction = forward
	{
		if (USTB_Mode == USTB_ROLL)							// roll mode
		{	
			if(USTB_idx >= MemoryEnd)						// check for time pointer overflow
			{ 
				USTB_idx = MemStartOffs; MemWinStart = MemStartOffs+1;   	// jump to start for circular buffering (roll mode)

				if (SingleShot)
				{ UserIF::Buttonhandler(BTN_STOP); }				// set to stop mode
			}
			else
			{ USTB_idx ++;}								//increment time pointer

			if (USTB_Disp == USTB_PERM && MemWinStart+GRID_WIDTH == USTB_idx-1)	// adjust memory window -> shift window right
			{ MemWinStart += draw_factor;}	
			else if (USTB_Disp == USTB_STEP && MemWinStart+GRID_WIDTH == USTB_idx-1)
			{ MemWinStart += (GRID_WIDTH * draw_factor); }
	
			if (MemWinStart > MemoryEnd-GRID_WIDTH) MemWinStart = MemoryEnd-GRID_WIDTH;	// limiter

			Trig_Pos_Mem = USTB_idx;						// adjust pre trigger sign to actual USTB index position	
		}
		else										// shift mode
		{
			USTB_EOSignal++;

			if (USTB_EOSignal >= MemoryEnd)						// end of 16k reached?
			{
//printf("end of 16k signal reached\n\r");	
				USTB_EOSignal = MemStartOffs;
				if (SingleShot)							// check single mode
				{ UserIF::Buttonhandler(BTN_STOP); }				// set to stop mode
			}

			S1Ptr--; S2Ptr--; S3Ptr--; S4Ptr--; SMPtr--;				// increment memory pointer

			if(S1Ptr <= SHIFT_OFFS1)						// check for memory pointer overflow
			{ Signal::USTB_resetShiftBuffer(); }					// reset buffers and pointers
			

		}

		//printf("MemStartOffs: %d  MemoryEnd: %d  MemWinStart: %d  USTB_idx: %d   ",MemStartOffs, MemoryEnd, MemWinStart, USTB_idx);

	}
	else											// direction = reverse
	{
		if (USTB_Mode == USTB_ROLL)							// roll mode
		{
			if(USTB_idx <= MemStartOffs)						// check for time pointer overflow
			{ 
				USTB_idx = MemoryEnd; MemWinStart = MemoryEnd - GRID_WIDTH; 	// jump to end for circular buffering (roll mode)
				if (SingleShot)
				{ UserIF::Buttonhandler(BTN_STOP); }				// set to stop mode
			}
			else
			{ USTB_idx --;}								//decrement time pointer

			if (USTB_Disp == USTB_PERM && MemWinStart == USTB_idx+1)		// adjust memory window -> shift window left
			{ MemWinStart -= draw_factor;}	
			else if (USTB_Disp == USTB_STEP && MemWinStart == USTB_idx+1)
			{ MemWinStart -= (GRID_WIDTH * draw_factor); }
	
			if (MemWinStart < MemStartOffs) MemWinStart = MemStartOffs;		// limiter

			Trig_Pos_Mem = USTB_idx;						// adjust pre trigger sign to actual USTB index position
		}
		else										// shift mode
		{
			USTB_EOSignal--;

			if (USTB_EOSignal <= MemStartOffs)					// end of 16k reached?
			{
//printf("end of 16k signal reached\n\r");	
				USTB_EOSignal = MemoryEnd;
				if (SingleShot)							// check single mode
				{ UserIF::Buttonhandler(BTN_STOP); }				// set to stop mode
			}

			S1Ptr++; S2Ptr++; S3Ptr++; S4Ptr++; SMPtr++;				// increment memory pointer

			if(S1Ptr >= SIGNAL1)							// check for memory pointer overflow
			{ Signal::USTB_resetShiftBuffer(); }					// reset buffers and pointers
		}


	}
	Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
	//Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactorDel) - ((float) Cursor_Delayed_1 * (ZoomFactor / ZoomFactorDel)));


	LED_ON[11] = 0;										//right LED (red) off -> data acquisition ready
	if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[3] = 0; }				//Channel 4 LED off
	Hardware::Send_LED();

	ACQ_NewData = 1;		//New signal data acquired
	ADC_DataAvailable = 0;

//printf("Acquisition ready\r\n");
 
}
//#####################################################################################################################################################
void Hardware::ISR_ADC_INT(int context)						// ADC interrupt subroutine
{
	ADC_Started = false;
	
	acq_ready->np_pioedgecapture = 0;
	
	ADC_DataAvailable = 1;
//printf("ADC ready   ");
	
	if (USTB_Mode != USTB_OFF)
	Handle_USTB();
}
//#####################################################################################################################################################
int Hardware::Read_IRQ(void)
{
    return acq_ready->np_piodata;
}
//#####################################################################################################################################################
void Hardware::Handle_ADC(void)								// ADC handler
{
	uint32_t buffer_addr = 0;	
	uint32_t buffer_start;
	

	if (UI_request && !ZL_changed)	return;						// add  don't handle ADC if user interface must be handled first except zero level adjustment

	if (RC_request)	return;								// signal recall is requested -> don't handle ADC

 	if (USTB_Mode != USTB_OFF) return;						// USTB is handled in an own inline handler routine
/*Test Test
	//if (TriggerWay == TRIG_PULS)	// special handling for pulse width trigger to force retriggering in "Normal Trigger" mode
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)
	{
		if (!ADC_DataAvailable	)						// only if no acquisition has been triggered  
		{
			if (TRG_NoEventCounter > 20)					// check for timeout
			{
				Start_Record();
				TRG_NoEventCounter = 0;
//Test Test				
				LED_ON[11] = 0;						// right LED (red) off -> no triggerevent 
				if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)		// channel mapping?
				{ LED_ON[3] = 0; }					// channel 4 LED off
				
				if(MenuStatus[MENU_TRIGGERSUB][0] == 116)		// Tek
				{
					LED_ON[9] = 1;							// left LED 1 (green) on -> Trigger is armed 
					if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 1; }	// mapped channel 3 LED on
				}

				Send_LED();				
//Test Test			
			}
			else
			{ TRG_NoEventCounter++; }					// increase counter if no event occured
		}
		else
		{ TRG_NoEventCounter = 0; }						// if acquisition data is available -> reset no event counter
	}	
*/	
	if (!ADC_DataAvailable && MenuStatus[MENU_UTILITY][4] == BTN_OFF)		// check if acquistion is done, if no new data is available 
	{ 										// check if test signal is active -> else return
		//if (TriggerWay == TRIG_PULS)	// special handling for pulse width trigger to force retriggering in "Normal Trigger" mode
		if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)			// special procedure for NORMAL trigger
		{
			if (TRG_NoEventCounter > 20)					// check for timeout
			{
				Start_Record();
				TRG_NoEventCounter = 0;
				
				LED_ON[11] = 0;						// right LED (red) off -> no triggerevent 
				if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)		// channel mapping?
				{ LED_ON[3] = 0; }					// channel 4 LED off
				
				if(MenuStatus[MENU_TRIGGERSUB][0] == 116)		// Tek
				{
					LED_ON[9] = 1;							// left LED 1 (green) on -> Trigger is armed 
					if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 1; }	// mapped channel 3 LED on
				}

				Send_LED();				
			}
			else
			{ TRG_NoEventCounter++; }					// increase counter if no event occured
		}
	
		return; 
	}
	
	TRG_NoEventCounter = 0;								// if acquisition data is available -> reset no event counter
	

// _|	++++++++++++++++++++++++++
	data_adr->np_piodata = 0x01;							// send readout buffer config pulse start (rising edge)

//Test Test
if(MenuStatus[MENU_TRIGGERSUB][0] != 116)					// if not Tek -> switch off trigger armed indicator	
{
	LED_ON[9] = 0;									// left LED 1 (green) off -> Trigger is not armed 
	if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 0; }			// mapped channel 3 LED off
}

	//-------------------------------------------------------
	//		(Pre) Trigger Control
	//-------------------------------------------------------
	AutoFreeRun = false;

	// get start address of readout buffer
	if (_TriggerSource == eTrigCh3 || _TriggerSource == eTrigCh4)	
	{ buffer_addr = ReadADC(eCh3); if ((buffer_addr & 0x0000FFFF) == 0x00000000) { AutoFreeRun = true; }}
	else 
	{ buffer_addr = ReadADC(eCh1); if ((buffer_addr & 0x00001000) == 0x00001000) { AutoFreeRun = true; }}

	//printf("buffer_addr =  %x & 0x00001000 = %x \r", buffer_addr, buffer_addr & 0x00001000);	

	// calc buffer address with pretrigger offset
	if (AutoFreeRun == true)	// no trigger event occured auto timeout had been reached
	{ 
		if ((buffer_addr & 0x00000FFF) == 0x00000000)
		{
			if (ACQ_HighSpeed){ buffer_start = (buffer_addr & 0x00000FFF) + (_regADC[eFPGA1].pre >> 1); buffer_start &= 0xFFFFFFFE; }	// 16Kbyte -> set to even address
			else buffer_start = (buffer_addr & 0x00000FFF) + _regADC[eFPGA1].pre;	//  4Kbyte
		}
		else
		{	
			if (ACQ_HighSpeed){ buffer_start = (_regADC[eFPGA1].pre >> 1); buffer_start &= 0xFFFFFFFE; }		// 16Kbyte -> set to even address
			else buffer_start = _regADC[eFPGA1].pre;			//  4Kbyte
		}

		LED_ON[11] = 0;								// right LED (red) off -> no triggerevent 
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)				// channel mapping?
		{ LED_ON[3] = 0; }							// channel 4 LED off
	}
	else if (ACQ_HighSpeed)	// trigger event occured -> 16Kbyte
	{ 
		buffer_start = (((buffer_addr & 0x0FFF) - (_regADC[eFPGA1].pre >> 1)) & 0x00000FFF);// + (BufferOffset >> 3) ;
		buffer_start &= 0xFFFFFFFE;	// set to even address

		if (MenuStatus[MENU_TRIGGERSUB][1] == 121)				// right LED (red) on -> triggerevent
		{
			LED_ON[11] = 1;							// right LED (red) on -> triggerevent
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// channel mapping?
			{ LED_ON[3] = 1; }						// channel 4 LED on
			Send_LED();
		}
	}	
	else	// trigger event occured -> 4KB memory
	{ 
		buffer_start = (((buffer_addr & 0x0FFF) - _regADC[eFPGA1].pre) & 0x00000FFF);// + BufferOffset;

		if (MenuStatus[MENU_TRIGGERSUB][1] == 121)				// right LED (red) on -> triggerevent
		{
			LED_ON[11] = 1;							// right LED (red) on -> triggerevent
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// channel mapping?
			{ LED_ON[3] = 1; }						// channel 4 LED on
			Send_LED();
		}
	}										// trigger event occured

	//buffer_start &= 0xFFFFFFFE;							// set to even address
	
	
	WriteADC(eCh1, buffer_start);							// set buffer start address channel 1
	WriteADC(eCh2, buffer_start);							// set buffer start address channel 2
	
	if (NumberOfChannels == 4)
	{				
		WriteADC(eCh3, buffer_start);						// set buffer start address channel 3
		WriteADC(eCh4, buffer_start);						// set buffer start address channel 4
	}

	data_adr->np_piodata = 0x00;							// send readout buffer config pulse end (falling edge)
// |_	++++++++++++++++++++++++++
	
	if (ACQ_ManTrigg)							//manual trigger
	{
		ACQ_ManTrigg = 0;							//reset trigger flag

		if (MenuStatus[MENU_TRIGGERSUB][1] > 119)
		{
			LED_ON[11] = 1;							// right LED (red) on -> triggered
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// channel mapping?
			{ LED_ON[3] = 1; }						// channel 4 LED on
		}

		// Single green 
		LED_ON[14] = 0;
		LED_ON[15] = 1;

		Hardware::SetupTrigger();						//reset trigger to previous setting
	}

	if (SingleShot)								// handle stop/single mode
	{
		SingleShot = 0;								//-> reset single flag
		nr_delay(10);

		// Run/Stop LED red
		LED_ON[12] = 0;
		LED_ON[13] = 1;			
		
		// Single mode LED green
		LED_ON[14] = 0;
		LED_ON[15] = 1;
		if (MenuStatus[MENU_TRIGGERSUB][1] > 119)				// right LED (red) on -> triggerevent
		{
			LED_ON[11] = 1;							// right LED (red) on -> triggerevent
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// channel mapping?
			{ LED_ON[3] = 1; }						// channel 4 LED on
		}	
		
	}
	else if(!Run)								// don't read the new data when stop mode is active and no single shot is done 
	{									// but let the LED flicker in background - that's what we do here
		if (!AutoFreeRun)
		{
			nr_delay(10);							// wait until LED shift registers are ready again
			LED_ON[11] = 0;							// right LED (red) off -> triggerevent passed 
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[3] = 0; }	// mapped channel 4 LED off	
			Send_LED();							// send LED settings to shift register
		}
		Start_Record();
		return;
	}
	
	if (MenuStatus[MENU_TRIGGERSUB][1] == 120 || MenuStatus[MENU_TRIGGERSUB][1] == 122)	// LED 2 indicating triggered acquisition
	{
		if (!AutoFreeRun)
		{
			LED_ON[11] = 1;								// right LED (red) on -> triggered
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)				// map to ch3 + 4 on?
			{ LED_ON[3] = 1; }							// channel 4 LED on
		}
		
	}
	
	Send_LED();									// send all LED changes to shift register
	
	
	
	//-------------------------------------------------------
	//		Signal Acquisition
	//-------------------------------------------------------

	if(MenuStatus[MENU_UTILITY][4] == BTN_ON)					// testsignal -> no ADC readout
	{ 
		nr_delay(5);								// wait until LED shift registers are ready again
		
		if (MenuStatus[MENU_TRIGGERSUB][1] > 119 )				// LED 2 setting triggered on?
		{
			LED_ON[11] = 1;							// right LED (red) on -> triggered
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// map to ch3 + 4 on?
			{ LED_ON[3] = 1; }						// channel 4 LED on
		}
		Send_LED();								// send LED settings to shift register

		Signal::generateTestSignal();						// generate test signals, don't read data from ADC
	}
	else if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_ALT)				// alternating trigger
	{
		ADC_ReadData(_TriggerSource, &Signal[_TriggerSource][0], ReadoutLength, MenuStatus[_TriggerSource+1][2] - BTN_OFF);
	}
	else										// standard trigger setting
	{
		if (Channel[eCh1].active)
		{ ADC_ReadData(eCh1, &Signal[eCh1][0], ReadoutLength, MenuStatus[MENU_CHANNEL1][2] - BTN_OFF); }
		
		if (Channel[eCh2].active)
		{ ADC_ReadData(eCh2, &Signal[eCh2][0], ReadoutLength, MenuStatus[MENU_CHANNEL2][2] - BTN_OFF); }	
		
		if (NumberOfChannels == 4)
		{	
			if (Channel[eCh3].active)
			{ ADC_ReadData(eCh3, &Signal[eCh3][0], ReadoutLength, MenuStatus[MENU_CHANNEL3][2] - BTN_OFF); }
			
			if (Channel[eCh4].active)
			{ ADC_ReadData(eCh4, &Signal[eCh4][0], ReadoutLength, MenuStatus[MENU_CHANNEL4][2] - BTN_OFF); }
		}	
	}




	//printf("Acquisition ready!\r\n");

	//----------------------------------------------------------------------------------
	//				Pretrigger Compensation
	//----------------------------------------------------------------------------------
	if (_TriggerSource > eTrigCh4)//external
	{ PreTrigComp = ExtTrigOffset[MainTimebase]; }	//BF #022
	else if (AutoFreeRun == false)
	{ PreTrigComp = TriggerCorrection(_TriggerSource, MenuStatus[MENU_TRIGGEREDGE][0] - 2, Trig_Pos_Mem); }
	else											//no trigger event occured -> set offset to zero
	{ PreTrigComp = 0; }


	//----------------------------------------------------------------------------------
	//			Combi Trigger Calculation
	//----------------------------------------------------------------------------------
	//added by Stefan for combi-trigger	
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_COMB && CombiTriggerStatus >= 1)		//combi-trigger -> auto-mode enabled
	{
		//search for signal crossing triggervalue - calc borders
		uint32_t min=0,max=0;
		static uint32_t oldMin=0,oldMax=0;
		uint8_t *pSignal=0;
		int32_t tvalue=0;
		
		if (CombiTriggerStatus == 1)							//if first time triggered by auto after switching to auto, reset oldMin,oldMax
		{
			oldMin=255;
			oldMax=0;
			CombiTriggerStatus=2;
		}
		
		//calc border for searching min and max in signal
		int32_t start = (int32_t) MemWinStart + PreTrigComp;
		if (start < 0) start = 0;
		
		int32_t stop = start + ((GRID_WIDTH + 30) * draw_factor);
		if (stop > TrigPosMax){stop = TrigPosMax;}

		switch (_TriggerSource)
		{
			case eTrigCh1:
			{	
				pSignal = SIGNAL1;
				tvalue = (int32_t)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH1])+ADC_ZERO;
				break;
			}
			case eTrigCh2:
			{	
				pSignal = SIGNAL2;
				tvalue = (int32_t)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH2])+ADC_ZERO;
				break;
			}
			case eTrigCh3:
			{
				pSignal = SIGNAL3;
				tvalue = (int32_t)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH3])+ADC_ZERO;
				break;
			}
			case eTrigCh4:
			{
				pSignal = SIGNAL4;
				tvalue = (int32_t)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH4])+ADC_ZERO;
				break;
			}
		}

		Signal::calcMinMax(start,stop,1,pSignal,&min,&max);	
		
		if (((oldMin<tvalue) && (max>tvalue)) || ((oldMax>tvalue) && (min<tvalue)) || (min<tvalue && max>tvalue))
		{
			//triggervalue crossed--> enable normal-mode
			_regADC[0].ctrl &= 0xFFBF;		// activate normal-mode
			_regADC[1].ctrl &= 0xFFBF;		// activate normal-mode
			CombiTriggerWaitTime = 0;		// reset time-measurement
			CombiTriggerStatus   = 0;		// reset co-trigger-status to normal-mode
			CaptureSetupADC();			// write shadow register to hardware
		}
		oldMax=max;
		oldMin=min;
		
	}
	else			//combi-trigger -> normal-mode
	{ CombiTriggerWaitTime = 0; }	//reset time, because trigger-event occured within 500ms


	if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_ALT) 			//if alternating trigger is active -> switch to next channel
	{ SetupTrigger(); }


	// -> ready, restart ADC and wait for the next event
	Start_Record();

//----------------------------------------------------------------	
//                         Trigger LED	
//----------------------------------------------------------------
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_FREE)		// no triggering
	{	
		LED_ON[9] = 0;							// left LED 1 (green) off -> Trigger is not armed 
		if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
		{ LED_ON[2] = 0; }						// mapped channel 3 LED off	

		LED_ON[11] = 0;							//right LED (red) off -> no triggerevent 
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			//channel LED active as trigger indicator? 
		{ LED_ON[3] = 0; }						//channel 4 LED off
	}
	else if (Run)								// trigger and run mode are active
	{	
		if(MenuStatus[MENU_TRIGGERSUB][1] != 122)			// if not Tek -> switch off trigger indicator (red)
		{	
			LED_ON[11] = 0;							//right LED (red) off -> no triggerevent 
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			//channel LED active as trigger indicator? 
			{ LED_ON[3] = 0; }						//channel 4 LED off
		}
		
		
		if (MenuStatus[MENU_TRIGGERSUB][0] == 115)			// trigger wait on (armed)
		{
			LED_ON[9] = 1; 							// left LED (green) on -> Trigger is armed 
			if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)			// channel mapping?
			{ LED_ON[2] = 1; }						// channel 3 LED on
		}	
		else if (MenuStatus[MENU_TRIGGERSUB][0] == 116)			// Tek -> green LED is XOR coupled to red LED
		{
			if (LED_ON[11])							// Tek -> trigger armed (green) is XOR to trigger indicator (red)
			{ 
				LED_ON[9] = 0;								// left LED 1 (green) off -> Trigger is not armed 
				if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 0; }		// mapped channel 3 LED off	
			}
			else
			{
				LED_ON[9] = 1;								// left LED 1 (green) on -> Trigger is armed 
				if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 1; }		// mapped channel 3 LED on	
			}	
		}
	}	
	Send_LED();

	FFT_NewData = 1; 		//new data for FFT available
	ACQ_NewData = 1;		//New signal data acquired

}


//#####################################################################################################################################################
void Hardware::Handle_Peak(void)						// ADC handler
{
	uint32_t buffer_addr = 0;	
	uint32_t buffer_start;


	if (UI_request && !ZL_changed)	return;						// don't handle ADC if user interface must be handled first except zero level adjustment

	if (RC_request)	return;								// signal recall is requested -> don't handle ADC

 	if (USTB_Mode != USTB_OFF) return;						// USTB is handled in an own inline handler routine


	if (TriggerWay == TRIG_PULS)							// special handling for pulse width trigger to force retriggering in "Normal Trigger" mode
	{
		if (ADC_DataAvailable == 0)						// only if no acquisition has been triggered  
		{
			if (TRG_NoEventCounter > 20)					// check for timeout
			{
				Start_Record();
				TRG_NoEventCounter = 0;
			}
			else
			{ TRG_NoEventCounter++; }					// increase counter if no event occured
		}
		else
		{ TRG_NoEventCounter = 0; }						// if acquisition data is available -> reset no event counter
	}	
	
	if (!ADC_DataAvailable && MenuStatus[MENU_UTILITY][4] == BTN_OFF) return;	// check if acquistion is done, if no new data is available or test signal is active -> return

	data_adr->np_piodata = 0x01;							// send readout buffer config pulse

	LED_ON[9] = 0;									// left LED 1 (green) off -> Trigger is not armed 
	if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[2] = 0; }			// mapped channel 3 LED off


	//-------------------------------------------------------
	//		(Pre) Trigger Control
	//-------------------------------------------------------
	AutoFreeRun = false;

	//BF get start address of readout buffer
	if (_TriggerSource == eTrigCh3 || _TriggerSource == eTrigCh4)	
	{ buffer_addr = ReadADC(eCh3); if ((buffer_addr & 0x0000FFFF) == 0x00000000) { AutoFreeRun = true; }}
	else 
	{ buffer_addr = ReadADC(eCh1); if ((buffer_addr & 0x00001000) == 0x00001000) { AutoFreeRun = true; }}

	//BF calc buffer address with pretrigger offset
	if (AutoFreeRun == true)	//BF no trigger event occured
	{
		if ((buffer_addr & 0x00000FFF) == 0x00000000)
		{
			if (ACQ_HighSpeed) buffer_start = (buffer_addr & 0x00000FFF) + (_regADC[eFPGA1].pre >> 1);	// 16Kbyte
			else buffer_start = (buffer_addr & 0x00000FFF) + _regADC[eFPGA1].pre;				//  4Kbyte
		}
		else
		{	
			if (ACQ_HighSpeed) buffer_start = (_regADC[eFPGA1].pre >> 1);					// 16Kbyte
			else buffer_start = _regADC[eFPGA1].pre;							//  4Kbyte
		}
	
		LED_ON[11] = 0;							//right LED (red) off -> no triggerevent 
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[3] = 0; }	//Channel 4 LED off
	}
	else if (ACQ_HighSpeed)	// trigger event occured -> 16Kbyte
	{ 
		buffer_start = ((buffer_addr & 0x0FFF) - (_regADC[eFPGA1].pre >> 1)) & 0x00000FFF;

		if (MenuStatus[MENU_TRIGGERSUB][1] == 121)			//triggerevent on
		{
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
			{ LED_ON[3] = 1; }					//Channel 4 LED on
			else 
			{ LED_ON[11] = 1; }					//right LED (red) on -> triggerevent 
			Send_LED();
		}
	}	
	else			// trigger event occured -> 4KB memory
	{ 
		buffer_start = ((buffer_addr & 0x0FFF) - _regADC[eFPGA1].pre) & 0x00000FFF;

		if (MenuStatus[MENU_TRIGGERSUB][1] == 121)			//triggerevent on
		{
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
			{ LED_ON[3] = 1; }					//Channel 4 LED on
			else 
			{ LED_ON[11] = 1; }					//right LED (red) on -> triggerevent 
			Send_LED();
		}
	}									//BF trigger event occured

	//BF set buffer start address
	WriteADC(eCh1, buffer_start);	
	WriteADC(eCh2, buffer_start);
	
	if (NumberOfChannels == 4)
	{				
		WriteADC(eCh3, buffer_start);
		WriteADC(eCh4, buffer_start);
	}

	data_adr->np_piodata = 0x00;		// readout buffer config pulse end

	if (ACQ_ManTrigg)	//manual trigger
	{
		ACQ_ManTrigg = 0;						//reset trigger flag

		if (MenuStatus[MENU_TRIGGERSUB][1] > 119)
		{
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
			{ LED_ON[3] = 1; }					//Channel 4 LED on
			else 
			{ LED_ON[11] = 1; }					//right LED (red) on -> triggered
		}

		// Single green 
		LED_ON[14] = 0;
		LED_ON[15] = 1;

		//reset trigger to previous setting
		Hardware::SetupTrigger();
	}

	if (SingleShot == 1)							// handle stop/single mode
	{
		//printf("Single event occured\r\n"); 
		SingleShot = 0;							//-> reset single flag
		nr_delay(10);

		// Run/Stop LED red
		LED_ON[12] = 0;
		LED_ON[13] = 1;			
		
		// Single Mode LED green
		LED_ON[14] = 0;
		LED_ON[15] = 1;	
	}
			
	else if(!Run)								// don't read the new data when stop mode is active and no single shot is done 
	{									// but let the LED flicker in background - that's what we do here
		if (AutoFreeRun == false)
		{
			nr_delay(10);
			LED_ON[11] = 0;							//right LED (red) off -> triggerevent passed 
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[3] = 0; }	//Channel 4 LED	
			Send_LED();
			//data_adr->np_piodata = 0x00;
	
			//printf("Trigger event while Stop mode\r\n"); 
		}
		Start_Record();
		return;
	}
	
	if (MenuStatus[MENU_TRIGGERSUB][1] == 120 && AutoFreeRun == false)	//triggered on
	{
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
		{ LED_ON[3] = 1; }						//Channel 4 LED on
		else 
		{ LED_ON[11] = 1; }						//right LED (red) on -> triggered
	}
	Send_LED();
	
	//-------------------------------------------------------
	//		Signal Acquisition
	//-------------------------------------------------------

	
	if (MenuStatus[MENU_HARDWARE][3] == 350)	// choose normal C-coded driver
	{
	
		if (Channel[eCh1].active)
		{ 
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF)	// normal
			ADC_PeakDetect(eCh1, Minimum[eCh1], Maximum[eCh1], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh1]);
			else						// inverted
			ADC_PeakDetectInv(eCh1, Minimum[eCh1], Maximum[eCh1], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh1], _ADC_VirtualZero[eCh1]);
		}
		
		if (Channel[eCh2].active)
		{ 
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF)
			ADC_PeakDetect(eCh2, Minimum[eCh2], Maximum[eCh2], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh2]); 
			else
			ADC_PeakDetectInv(eCh2, Minimum[eCh2], Maximum[eCh2], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh2], _ADC_VirtualZero[eCh2]); 
		}	
		
		if (NumberOfChannels == 4)
		{	
			if (Channel[eCh3].active)
			{
				if (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF)
				ADC_PeakDetect(eCh3, Minimum[eCh3], Maximum[eCh3], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh3]); 
				else
				ADC_PeakDetectInv(eCh3, Minimum[eCh3], Maximum[eCh3], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh3], _ADC_VirtualZero[eCh3]);
			}
		
			if (Channel[eCh4].active)
			{ 
				if (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF)
				ADC_PeakDetect(eCh4, Minimum[eCh4], Maximum[eCh4], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh4]); 
				else
				ADC_PeakDetectInv(eCh4, Minimum[eCh4], Maximum[eCh4], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh4], _ADC_VirtualZero[eCh4]);
			}
		}
	}
	else	// if (MenuStatus[MENU_HARDWARE][3] == 350)	// choose assembler driver
	{
		uint32_t delay;
		
		if (Channel[eCh1].active)
		{ 
			if (MainTimebase < 8)
			delay = Hardware::_ChannelDelay[eCh1] / draw_factor;
			else
			delay = 0;
			
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF)	// normal
			ADC_PeakDetect_ASM(eCh1, Minimum[eCh1]+delay, Maximum[eCh1]+delay, ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh1]);
			else						// inverted
			ADC_PeakDetectInv(eCh1, Minimum[eCh1], Maximum[eCh1], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh1], _ADC_VirtualZero[eCh1]);
		}
		
		if (Channel[eCh2].active)
		{ 
			if (MainTimebase < 8)
			delay = Hardware::_ChannelDelay[eCh2] / draw_factor;
			else
			delay = 0;
			
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF)
			ADC_PeakDetect_ASM(eCh2, Minimum[eCh2]+delay, Maximum[eCh2]+delay, ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh2]); 
			else
			ADC_PeakDetectInv(eCh2, Minimum[eCh2], Maximum[eCh2], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh2], _ADC_VirtualZero[eCh2]); 
		}	
		
		if (NumberOfChannels == 4)
		{	
			if (Channel[eCh3].active)
			{
				if (MainTimebase < 8)
				delay = Hardware::_ChannelDelay[eCh3] / draw_factor;
				else
				delay = 0;

				if (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF)
				ADC_PeakDetect_ASM(eCh3, Minimum[eCh3]+delay, Maximum[eCh3]+delay, ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh3]); 
				else
				ADC_PeakDetectInv(eCh3, Minimum[eCh3], Maximum[eCh3], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh3], _ADC_VirtualZero[eCh3]);
			}
		
			if (Channel[eCh4].active)
			{ 
				if (MainTimebase < 8)
				delay = Hardware::_ChannelDelay[eCh4] / draw_factor;
				else
				delay = 0;

				if (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF)
				ADC_PeakDetect_ASM(eCh4, Minimum[eCh4]+delay, Maximum[eCh4]+delay, ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh4]); 
				else
				ADC_PeakDetectInv(eCh4, Minimum[eCh4], Maximum[eCh4], ACQ_HighSpeed, 4100, draw_factor, _ADC_Offset[eCh4], _ADC_VirtualZero[eCh4]);
			}
		}
	
	}
	
	
	
	//printf("Acquisition ready!\r\n");

	//----------------------------------------------------------------------------------
	//				Pretrigger Compensation
	//----------------------------------------------------------------------------------
	if (_TriggerSource > eTrigCh4)//external
	{ PreTrigComp = ExtTrigOffset[MainTimebase]; }	//BF #022
	//else if (AutoFreeRun == false)
	//{ PreTrigComp = 0; } //TriggerCorrection(_TriggerSource, MenuStatus[MENU_TRIGGEREDGE][0] - 2, Trig_Pos_Mem); }
	else											//no trigger event occured -> set offset to zero
	{ PreTrigComp = 0; }


	//----------------------------------------------------------------------------------
	//			Combi Trigger Calculation
	//----------------------------------------------------------------------------------
	//added by Stefan for combi-trigger	
	if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_COMB && CombiTriggerStatus >= 1)		//combi-trigger -> auto-mode enabled
	{
		//search for signal crossing triggervalue - calc borders
		uint32_t min=0,max=0;
		static uint32_t oldMin=0,oldMax=0;
		uint8_t *pSignal=0;
		int32_t tvalue=0;
		
		if (CombiTriggerStatus == 1)							//if first time triggered by auto after switching to auto, reset oldMin,oldMax
		{
			oldMin=255;
			oldMax=0;
			CombiTriggerStatus=2;
		}
		
		//calc border for searching min and max in signal
		int32_t start = (int32_t) MemWinStart + PreTrigComp;
		if (start < 0) start = 0;
		
		int32_t stop = start + ((GRID_WIDTH + 30) * draw_factor);
		if (stop > TrigPosMax)
		{ stop = TrigPosMax; }

		switch (_TriggerSource)
		{
			case eTrigCh1:
			{	
				pSignal = Maximum[eCh1];
				tvalue = (int32_t)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH1])+ADC_ZERO;
				break;
			}
			case eTrigCh2:
			{	
				pSignal = Maximum[eCh2];
				tvalue = (int32_t)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH2])+ADC_ZERO;
				break;
			}
			case eTrigCh3:
			{
				pSignal = Maximum[eCh3];
				tvalue = (int32_t)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH3])+ADC_ZERO;
				break;
			}
			case eTrigCh4:
			{
				pSignal = Maximum[eCh4];
				tvalue = (int32_t)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH4])+ADC_ZERO;
				break;
			}
		}

		Signal::calcMinMax(start,stop,1,pSignal,&min,&max);	
		
		if (((oldMin < tvalue) && (max > tvalue)) || ((oldMax > tvalue) && (min < tvalue)) || (min < tvalue && max > tvalue))
		{
			//triggervalue crossed--> enable normal-mode
			_regADC[0].ctrl &= 0xFFBF;		// activate normal-mode
			_regADC[1].ctrl &= 0xFFBF;		// activate normal-mode
			CombiTriggerWaitTime = 0;		// reset time-measurement
			CombiTriggerStatus = 0;			// reset co-trigger-status to normal-mode
			CaptureSetupADC();			// write shadow register to hardware
		}
		oldMax = max;
		oldMin = min;
		
	}
	else			//combi-trigger -> normal-mode
	{ CombiTriggerWaitTime = 0; }	//reset time, because trigger-event occured within 500ms


	// -> ready, restart ADC and wait for the next event
	Start_Record();

	if (MenuStatus[MENU_TRIGGERSUB][0] == 115 && Run)			//trigger wait on
	{
		if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
		{ LED_ON[2] = 1; }						//Channel 3 LED on
		else 
		{ LED_ON[9] = 1; }						//left LED (green) on -> Trigger is armed 
	}

	LED_ON[11] = 0;								//right LED (red) off -> no triggerevent 
	if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON){ LED_ON[3] = 0; }		//Channel 4 LED

	Send_LED();

	ACQ_NewData = 1;		//New signal data acquired

}

//#####################################################################################################################################################
//BF new fix for trigger calculating by Stefan
//BF ->  The pretrigger has an time offset of 70 at high speed TB and 40 at low speed TB. This routine calculates the correction dynamically.
int Hardware::TriggerCorrection(trigSrc_t src, unsigned char negativ, int TriggerPos)
{
	int ix, foundat = 0, start, range;
	int tl_buf = 0;

	switch(src)
	{
		case eTrigCh1 : tl_buf = (int)((float)(Trigger_Pos_CH1-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH1])+ADC_ZERO; break;//Stefan
		case eTrigCh2 : tl_buf = (int)((float)(Trigger_Pos_CH2-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH2])+ADC_ZERO; break;
		case eTrigCh3 : tl_buf = (int)((float)(Trigger_Pos_CH3-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH3])+ADC_ZERO; break;
		case eTrigCh4 : tl_buf = (int)((float)(Trigger_Pos_CH4-GRID_HEIGHT/2)/ScaleFactor[Selected_Voltage_CH4])+ADC_ZERO; break;
		default : return 0;
	}

	start = TriggerPos;			// set start point near to the real triggerevent
	foundat = TriggerPos + 20;		// default correction is 20
	range = TriggerPos + 50;//300;		// set search range
	
	if (range > TrigPosMax) range = TrigPosMax;

	//start searching for the next edge in range
	if (negativ)				//falling edge
	{
		switch(src)
		{
			case eTrigCh1 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL1[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh2 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL2[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh3 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL3[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh4 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL4[ix] > tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
		}

	}
	else				//rising edge
	{
		switch(src)
		{
			case eTrigCh1 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL1[ix] < tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh2 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL2[ix] < tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh3 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL3[ix] < tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
			case eTrigCh4 :
			{
				for (ix = start; ix < range; ix++)
				{
					if (SIGNAL4[ix] < tl_buf)
					{
						foundat = ix;
						break;
					}
				}
				break;
			}
		}

	}
		
	return foundat - TriggerPos;


}
//#####################################################################################################################################################
//Auto scale
int Hardware::AutoScale(uint32_t slow_tb)
{
	int subrc1 = 0, subrc2=0, subrc3=0, subrc4=0;
	uint32_t lGainIdx_bak;
	//char Trigger_Source_bak;

	//Run_bak        = Run;
	//SingleShot_bak = SingleShot;
	lGainIdx_bak   = GainIdx;

	Run = 1;
	SingleShot = 0;
	//GainIdx    = 1;			//force pre amp to 1.25
	//AS_request = 1;
	
	LED_ON[12] = 1;	// Run/Stop green
	LED_ON[13] = 0; // single off

	// show popup with message and progress indicator
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 0);	// draw popup
	if (slow_tb) Display::TextOut12x9("Autoscale TB range 500ms - 10&s", 200, 192, 1, UI_Plane2);
	else Display::TextOut12x9("Autoscale TB range 2ms - 2ns", 200, 192, 1, UI_Plane2);
	Display::Rect(200, 220, 240, 20, 1, UI_Plane1);		// draw white box
	Display::Rect(200, 220, 20, 20, 1, UI_Plane2);		// draw black box as progress indicator

	//Stop_Record();			
	//for(int timeout=0;(timeout < 500) && acq_ready->np_piodata == 0x01;timeout++)
	//nr_delay(5);
	
	if (USTB_Mode != USTB_OFF)	//was USTB mode active?
	{
		Hardware::Stop_Timer2();

		//deactivate roll/shift mode and backup setting in menu
		USTB_Mode_bak = USTB_Mode;
		USTB_Mode = USTB_OFF;					//switch off USTB mode
	}

	DoDisableUARTInterrupt();
	DoDisableADCInterrupt();
	DoDisableKeyInterrupt();
	DoDisableRotInterrupt();
	
	ADC_DataAvailable = 0;
	acq_ready->np_pioedgecapture = 0;

	//switch trigger to Auto
	MenuStatus[MENU_TRIGGERMODE][0] = TRIG_COMB;  	//set trigger combi mode
	Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);
	HoldOff.Write_Value(0.0);			// holdoff off
	HoldOff_Value = 0;
	MenuStatus[MENU_TRIGGEREDGE][0] = 2;		// rising
	TriggerWay = TRIG_EDGE;				// trigger edge
	LED_ON[8] = 1;					// edge on
	LED_ON[10] = 0;					// puls off

	Send_LED();

	//Trigger_Source_bak      = Selected_Trigger_Source;

	MenuStatus[MENU_CHANNEL1][0] = 7;	// AC
	MenuStatus[MENU_CHANNEL2][0] = 7;	// AC
	MenuStatus[MENU_CHANNEL3][0] = 7;	// AC
	MenuStatus[MENU_CHANNEL4][0] = 7;	// AC

	MenuStatus[MENU_CHANNEL1][1] = BTN_OFF;	// BW
	MenuStatus[MENU_CHANNEL2][1] = BTN_OFF;	// BW
	MenuStatus[MENU_CHANNEL3][1] = BTN_OFF;	// BW
	MenuStatus[MENU_CHANNEL4][1] = BTN_OFF;	// BW

	SetSwitches(eCh1, -1);			// set coupling

	if (slow_tb) MainTimebase = 20;	
	else MainTimebase = 14;	

	// find matching voltage ranges
	if (Channel[eCh1].active) FindVoltage(eCh1);
	Display::Rect(220, 220, 40, 20, 1, UI_Plane2);		// draw black box as progress indicator

	if (Channel[eCh2].active) FindVoltage(eCh2);
	Display::Rect(260, 220, 40, 20, 1, UI_Plane2);		// draw black box as progress indicator

	if (Channel[eCh3].active) FindVoltage(eCh3);
	Display::Rect(300, 220, 40, 20, 1, UI_Plane2);		// draw black box as progress indicator

	if (Channel[eCh4].active) FindVoltage(eCh4);
	Display::Rect(340, 220, 40, 20, 1, UI_Plane2);		// draw black box as progress indicator

	// find matching timebase
	if (MenuStatus[MENU_AUTOSCALE][3]==280) 					//search at trigger source
	{
		FindTimebase(_TriggerSource,slow_tb);
		subrc1 = 1; subrc2 = 1; subrc3 = 1; subrc4 = 1;
	}
	else										// search in channel order for new trigger source
	{
		// find matching timebase
		if (Channel[eCh1].active) subrc1 = FindTimebase(eCh1,slow_tb);
		if ((Channel[eCh2].active && subrc1==-1) || (Channel[eCh2].active && !Channel[eCh1].active)) subrc2 = FindTimebase(eCh2,slow_tb);
		if ((Channel[eCh3].active && subrc2==-1) || (Channel[eCh3].active && !Channel[eCh2].active)) subrc3 = FindTimebase(eCh3,slow_tb);
		if ((Channel[eCh4].active && subrc3==-1) || (Channel[eCh4].active && !Channel[eCh3].active)) subrc4 = FindTimebase(eCh4,slow_tb);
	}

	//if no signal is found anywhere -> reset to old triggersource
	if ((subrc1<1) && (subrc2<1) && (subrc3<1) && (subrc4<1)) //|| Selected_Trigger_Source == 0 )
	{
		TriggerWay = TRIG_EDGE;							// edge triggering
		//MenuStatus[MENU_TRIGGEREDGE][1] = 136 + Selected_Trigger_Source;	// source menu
		Display::MenuPopupInit(28, MENU_TRIGGEREDGE, 137);
	}

	Display::Rect(380, 220, 60, 20, 1, UI_Plane2);

	Display::RecalcTimeParameters();

	acq_ready->np_pioedgecapture = 0;

	MenuStatus[MENU_CHANNEL1][0] = 8;	// DC
	MenuStatus[MENU_CHANNEL2][0] = 8;	// DC
	MenuStatus[MENU_CHANNEL3][0] = 8;	// DC
	MenuStatus[MENU_CHANNEL4][0] = 8;	// DC

	SetSwitches(eCh1, -1);			// set coupling
	
	Display::DRAWROUNDBUTTON(190, 180, 260, 80, 0, 1);				// delete popup
	Display::Rect(200, 220, 240, 20, 0, UI_Plane1);					// remove white box
	Display::Rect(200, 190, 240, 52, 0, UI_Plane2);					// remove indicator and text
	//for (int i=Display_Line_Adresses[190]; i < Display_Line_Adresses[241]; i++)	// delete progress indicator and text
	//{ UI_Plane2[i] = 0; UI_Plane1[i] = 0;}	

	DispatchTraces();

	TRIG_AutoPretrigger();

	DoEnableRotInterrupt();
	DoEnableKeyInterrupt();
	DoEnableADCInterrupt();
	DoEnableUARTInterrupt();

	nr_delay(50);
	SetupTrigger();				// write trigger settings to hardware
	
	TimebaseChanged = 1;
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	TriggerWayChanged = 1;
	VoltageChangedCh1 = 1;	
	VoltageChangedCh2 = 1;	
	VoltageChangedCh3 = 1;	
	VoltageChangedCh4 = 1;	
	
	GainIdx = lGainIdx_bak;
		
	Display::StatusUpdate();

	Display::MenuInit();

	if (Memory_Window_visible)
        Display::CloseMemoryBrowser();		//close memory window

	if (Cursor_Enabled)
	{
		Display::CALCCURSORDATA();
		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	if (QM_Enabled)
	{
		Display::CALCQMDATA();
		Menu_Changed = 1;
	}

	if (_TriggerSource < eTrigExt)
	{
		//start_acq->np_piodata = 0x01;				//start record Port On
		//start_acq->np_piodata = 0x00;				//start record Port Off
		Start_Record();

		//wait for ADC
		//for(short timeout=0;(timeout < 200) && acq_ready->np_piodata == 0x01;timeout++)
		for(short timeout=0;(timeout < 200) && ADC_DataAvailable == 0;timeout++)
		nr_delay((MainTimebase+1)*2);

		data_adr->np_piodata = 0x01;			// send readout buffer config pulse start (rising edge)
		
		ReadADC(eCh1);	
		WriteADC(eCh1, 0);
		WriteADC(eCh2, 0);
	
		if (NumberOfChannels > 2)
		{
			ReadADC(eCh3);
			WriteADC(eCh3, 0);
			WriteADC(eCh4, 0);
		}

		data_adr->np_piodata = 0x00;			// send readout buffer config pulse end (falling edge)
	
		ADC_ReadData(_TriggerSource, Signal[_TriggerSource], 4100, MenuStatus[_TriggerSource+1][2] - BTN_OFF);
	
		TRIG_AutoLevel();
		timer_rotary_busy->np_timercontrol = ((timer_rotary_busy->np_timercontrol & 3) + np_timercontrol_stop_mask);	// Stop Timer, disable interrupt
		timer_rotary_busy->np_timerstatus  = 0;										// clear the ISR
	}
	
	Display::DRAW_ALL_CURSOR();

	Start_Record();

	ConfigChanged = 0;
	AS_request = 0;
	TriggerLevelActive = 0;

    	return 0;
}
//#####################################################################################################################################################
// Kanalnummern umstellen -> DONE
// TODO Signal Pointer auf Struct umstellen
int Hardware::FindTimebase(uint8_t channel, uint32_t slow_tb)
{
	int32_t ix, edges=0, max_cnt, cnt = 0, cnt2 = 0;
	int32_t intfactor;
	int32_t max_tb = 25;	//500ms
	
	uint8_t buf_min;
	uint8_t buf_max;
	uint8_t buf_byte;
	uint8_t buf_arr[600];
	uint8_t avrg = 0;
	
	int8_t voltage=0;

/*
	if (slow_tb)
	printf("\r\nStart searching slow timebase channel %d\r\n", channel);
	else
	printf("\r\nStart searching timebase channel %d\r\n", channel);
*/
	
	switch(channel)
	{
		case eCh1: voltage = Selected_Voltage_CH1 - 3; break;
		case eCh2: voltage = Selected_Voltage_CH2 - 3;break; 
		case eCh3: voltage = Selected_Voltage_CH3 - 3;break;
		case eCh4: voltage = Selected_Voltage_CH4 - 3;break;
	}

	if(voltage < e10mV) voltage = e10mV;

	// set voltage range
	SetSwitches(channel, voltage);
	nr_delay(200);	//wait for capacitor

	max_cnt = 0;
	
	// slow TB?
	if (slow_tb){ max_tb = 25; MainTimebase = 21; }			// start with 20ms -> range is 500ms - 10µs	
	else{ max_tb = 18; MainTimebase = 8; }//11; }				// start with 10µs -> range is 2ms - 2ns

	//triggering = 0;			// switch off trigger
	CaptureTrigSetMode(eTrigFreerun);	// switch off trigger
			
	for(;;)
	{
		max_cnt++;

		if (MainTimebase <= 8) // 1GSa/s
		{ _regADC[eFPGA1].pre = 0x002D; }
		else if (MainTimebase == 9)
		{ _regADC[eFPGA1].pre = 0x003C; }
		else if (MainTimebase == 10)
		{ _regADC[eFPGA1].pre = 0x0055; }
		else if (MainTimebase == 11)
		{ _regADC[eFPGA1].pre = 0x0120; }
		else if (MainTimebase == 12)
		{ _regADC[eFPGA1].pre = 0x0120; }
		else if (MainTimebase > 12 && MainTimebase < 25)
		{ _regADC[eFPGA1].pre = 0x0110; }

		_regADC[eFPGA2].pre = _regADC[eFPGA1].pre;
		
		CaptureSetupADC();					// write shadow registers to hardware (pre_reg and TB)
		nr_delay(50);

		start_acq->np_piodata = 0x01;				//start record pulse high
		start_acq->np_piodata = 0x00;				//start record pulse low
	
		//wait for ADC
		int timeout;
		for(timeout=0;(timeout < 200) && acq_ready->np_piodata == 0x01;timeout++)
		nr_delay((MainTimebase+1)*2);
	
		if (timeout >= 200 ){ printf("Timeout\r\n"); continue; }

		data_adr->np_piodata = 0x01;
	
		ReadADC(eCh1);	
		WriteADC(eCh1, 0);
		WriteADC(eCh2, 0);
	
		if (NumberOfChannels > 2)
		{
			ReadADC(eCh3);
			WriteADC(eCh3, 0);
			WriteADC(eCh4, 0);
		}
		
		data_adr->np_piodata = 0x00;

		ADC_ReadData(channel, Signal[channel], 600, 0); // -> lPtrSignal also possible, points to the same memory 

		buf_byte = 0;
	
		// draw factor
		intfactor = (int) ZoomFactorTable[MainTimebase];
		if (intfactor <= 0) intfactor = 1;

		// get minima and maxima
		buf_min = 255;
		buf_max = 0;

		for (ix=150, cnt=0; cnt < 600; cnt++, ix+=intfactor)
		{
			buf_byte = Signal[channel][ix];
			buf_arr[cnt] = buf_byte;
			if (buf_min > buf_byte) buf_min = buf_byte;
			if (buf_max < buf_byte) buf_max = buf_byte;
		}
		
		edges = 0;	
	
		// signal found?
		if ( (buf_max - buf_min) > 10 )
		{
			// calculate average
			avrg = (unsigned char) (((int) buf_min + (int) buf_max) >> 1);
	
			// search signal edges
			for (ix=3; ix < 597; ix++)
			{
				//printf("buf_arr[%d] %d",ix, buf_arr[ix]);
				if ((buf_arr[ix - 3] > avrg + 1) && (buf_arr[ix + 3] < avrg - 1)) { /*printf("rising edge->%d\r\n",ix);*/ edges++; ix+=10;  }	// rising edge
				if ((buf_arr[ix - 3] < avrg - 1) && (buf_arr[ix + 3] > avrg + 1)) { /*printf("falling edge->%d\r\n",ix);*/ edges++; ix+=10;  } 	// falling edge
				//printf("\r\n");
			}
		}	

		//printf("TimeBase %d Zoom %d Edges %d avrg %d bmin %d bmax %d\r\n", MainTimebase, intfactor, edges, avrg, buf_min, buf_max);

		if ((edges < 3 && !slow_tb) || (edges < 4 && slow_tb))//4		// go to next slower TB if less than 1 period is on the screen
		{
			MainTimebase++;
			CaptureSetupADC();					// write shadow registers to hardware
		}
		else if (MainTimebase == 4 && edges > 8)//6			// check if interpolation is needed for very high frequencies
		{
			if (edges > 40)
			{
				//printf("\r\nStarting HF search\r\n");

				// search HF signal edges
				for (ix=3, edges=0; ix < 597; ix++)
				{
					//printf("buf_arr[%d] %d",ix, buf_arr[ix]);
					if ((buf_arr[ix - 2] > avrg + 1) && (buf_arr[ix + 2] < avrg - 1)) { /*printf("rising edge->%d\r\n",ix);*/ edges++; ix+=4;  }	// rising edge
					if ((buf_arr[ix - 2] < avrg - 1) && (buf_arr[ix + 2] > avrg + 1)) { /*printf("falling edge->%d\r\n",ix);*/ edges++; ix+=4;  } 	// falling edge
					//printf("\r\n");
				}

				if (edges > 100)
				{
					//printf("\r\nStarting UHF search\r\n");
	
					// search HF signal edges
					for (ix=3, edges=0; ix < 597; ix++)
					{
						//printf("buf_arr[%d] %d",ix, buf_arr[ix]);
						if ((buf_arr[ix - 1] > avrg + 1) && (buf_arr[ix + 1] < avrg - 1)) { /*printf("rising edge->%d\r\n",ix);*/ edges++; ix+=2;  }	// rising edge
						if ((buf_arr[ix - 1] < avrg - 1) && (buf_arr[ix + 1] > avrg + 1)) { /*printf("falling edge->%d\r\n",ix);*/ edges++; ix+=2;  } 	// falling edge
						//printf("\r\n");
					}
				}
			}

			if (edges < 15)
			{ MainTimebase = 3; }
			else if (edges < 30)
			{ MainTimebase = 2; }
			else if (edges < 80)
			{ MainTimebase = 1; }
			else 
			{ MainTimebase = 0; }

			intfactor = 0;
			//printf("TimeBase %d Zoom %d Edges %d avrg %d bmin %d bmax %d\r\n", MainTimebase, intfactor, edges, avrg, buf_min, buf_max);

			break;
		}
		else if (MainTimebase > 4 && edges > 8)				// go to next faster TB if more than 3 periods are on the screen
		{
			MainTimebase--;
//			timebase_reg = tb_value[MainTimebase];

			CaptureSetupADC();					// write shadow registers to hardware
		}
		else
		{ break;}

		if (MainTimebase == max_tb) { edges = -1; break; }	// no matching TB found

		if (max_cnt >= 10) { edges = -1; break; }		// no matching TB found
    	}

	// signal found?
	if ( edges < 0 && (buf_max - buf_min) < 15)	// nothing found
	{
		if (slow_tb)
		MainTimebase = 18;	// 200µs
		else
		MainTimebase = 4;	// 50ns

//		timebase_reg = tb_value[MainTimebase];
		edges = -1;
		//printf("No Signal found -> ");
		intfactor = 1;
	}
	else						// search was successfull
	{
		TriggerWay = TRIG_EDGE;					// edge triggering
		MenuStatus[MENU_TRIGGEREDGE][1] = 137 + channel;	// set trigger in source menu
		//SetupTrigger();					// write trigger settings to hardware -> done by caller!
		Display::MenuPopupInit(28, MENU_TRIGGEREDGE, 137);
	}
	//printf("Set Timebase %d Zoom %d channel %d\r\n", MainTimebase, lIntFactor, channel);


	// reset voltage range to previous setting
	switch(channel)
	{
		case eCh1: SetSwitches(channel, Selected_Voltage_CH1); break;
		case eCh2: SetSwitches(channel, Selected_Voltage_CH2); break;
		case eCh3: SetSwitches(channel, Selected_Voltage_CH3); break;
		case eCh4: SetSwitches(channel, Selected_Voltage_CH4); break;
	}	//5V

	return edges;
}
//#####################################################################################################################################################

// TODO Kanalnummern umstellen
// TODO Channeldaten auf Struct umstellen
int Hardware::FindVoltage(uint8_t channel)
{
	int32_t ix, cnt, intfactor, range = e10V;
	int16_t volt_delta, volt_max; //topV, bottomV;

	uint8_t buf_min = 0, buf_max = 0, buf_delta;
	uint8_t buf_byte = 0;

	int16_t scr_max = 0, scr_min = 0, scr_delta = 0;

    	//printf("\r\nStart searching range channel %d\r\n", channel);

	//Stop_Record();

	// thresholds due to the new DC offset adjusting -> now converted to screen values
	switch(Channels_Active)
	{
		case 1  : volt_delta = 150; volt_max = GRID_HEIGHT; break;
		case 2  : volt_delta = 75;  volt_max = GRID_HEIGHT/2; break;
		case 3  : volt_delta = 70;  volt_max = GRID_HEIGHT/3; break;
		default : volt_delta = 50;  volt_max = GRID_HEIGHT/4;
	}


	//printf("Switch off triggering\r\n");
	CaptureTrigSetMode(eTrigFreerun);	// switch off trigger and write shadow registers to hardware
	nr_delay(50);	

	for(;;)	//endless loop -> start with Volt = 11 -> 5V
	{
		if (range > e10mV) { range--; }//printf("decrement volt %d\n", volt); }
		else break;
	
		//printf("Set switches to voltage range %d\r\n", range);
		SetSwitches(channel, range);				// set new voltage range

		// adjust zero
		if( range == e1V || range == e100mV || range == e10mV || range == e1mV)//1 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][0];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][0];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][0];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][0];
		}
		else if( range == e2V || range == e200mV || range == e20mV || range == e2mV)//2 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][1];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][1];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][1];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][1];
		}
		else if( range == e5V || range == e500mV || range == e50mV || range == e5mV)//5 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][2];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][2];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][2];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][2];
		}

		SetDacOffset(channel);	

		nr_delay(50);	


		// start ADC
		//printf("Start ADC\r\n");
		start_acq->np_piodata = 0x01;				//start record Port On
		start_acq->np_piodata = 0x00;				//start record Port Off	
	
		//while (acq_ready->np_piodata == 0x01 && !ADC_DataAvailable) {}
		//wait for ADC
		uint32_t timeout;
		for(timeout=0;(timeout < 200) && acq_ready->np_piodata == 0x01;timeout++)
		nr_delay((MainTimebase+1)*2);
	
		if (timeout >= 200 ){ printf("Timeout\r\n"); continue; }

		data_adr->np_piodata = 0x01;
	
		ReadADC(eCh1);
		WriteADC(eCh1, 0);	
		WriteADC(eCh2, 0);	
	
		if (NumberOfChannels > 2)
		{
			ReadADC(eCh3);
			WriteADC(eCh3, 0);	
			WriteADC(eCh4, 0);	
		}
		
		data_adr->np_piodata = 0x00;
	
		ADC_ReadData(channel, Signal[channel], 600 , 0);

	
		// draw factor
		intfactor = (int32_t) ZoomFactorTable[MainTimebase];
		if (intfactor <= 0) intfactor = 1;
	
		buf_min = 255;
		buf_max = 0;

		// get minimum and maximum
		//printf("Get minima and maxima\r\n");
		for (ix=150, cnt=0; cnt < 600 ; cnt++, ix+=intfactor)
		{
			buf_byte = Signal[channel][ix];

			if (buf_min > buf_byte)	{ buf_min = buf_byte; }
			if (buf_max < buf_byte)	{ buf_max = buf_byte; }
		}
		//if ((buf_min < topV) || (buf_max > bottomV) || (abs(buf_max - buf_min) > deltaV)) break;
		
		scr_max = ScaleLookupTable[buf_max][ScaleIndexTable[range]];
		scr_min = ScaleLookupTable[buf_min][ScaleIndexTable[range]];
		//scr_delta = (short)abs((int)(scr_max - scr_min));
		scr_delta = scr_max - scr_min;
		//printf("Min %d  Max %d  Delta %d  Thrhld %d  Volt %d \r\n", scr_min, scr_max, scr_delta, deltaV, volt);

		if (scr_delta > volt_delta) break;
	}

	// limiter -> check if range is too small	
	if (scr_delta > volt_max && range < e5V)
	{
		range++; //printf("Limiter -> switch back to volt %d\r\n",volt);

		SetSwitches(channel, range);				// set new voltage range
		// adjust zero
		if( range == e1V || range == e100mV || range == e10mV || range == e1mV)//1 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][0];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][0];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][0];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][0];
		}
		else if( range == e2V || range == e200mV || range == e20mV || range == e2mV)//2 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][1];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][1];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][1];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][1];
		}
		else if( range == e5V || range == e500mV || range == e50mV || range == e5mV)//5 V
		{
			CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][2];
			CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][2];
			CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][2];
			CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][2];
		}

		SetDacOffset(channel);	

		nr_delay(50);	

	 }

	// if lowest voltage range is reached without finding a signal -> switch back to old range
	if ( range == e10mV && (buf_min > 115) && (buf_max < 140))
	{
		switch(channel)
		{
			case eCh1 : range = Selected_Voltage_CH1; SetSwitches(channel, Selected_Voltage_CH1); break;
			case eCh2 : range = Selected_Voltage_CH2; SetSwitches(channel, Selected_Voltage_CH2); break;	
			case eCh3 : range = Selected_Voltage_CH3; SetSwitches(channel, Selected_Voltage_CH3); break;
			case eCh4 : range = Selected_Voltage_CH4; SetSwitches(channel, Selected_Voltage_CH4); break;
		}
		//printf("No Signal found -> set to old voltage range\r\n ");
	}	


	switch(channel)
	{
		case eCh1 : Selected_Voltage_CH1 = range;  VoltageChangedCh1 = 1; Display::DRAWSTATUS(1, 0); break;	// Draw Voltage Channel 1
		case eCh2 : Selected_Voltage_CH2 = range;  VoltageChangedCh2 = 1; Display::DRAWSTATUS(2, 0); break;	// Draw Voltage Channel 2
		case eCh3 : Selected_Voltage_CH3 = range;  VoltageChangedCh3 = 1; Display::DRAWSTATUS(3, 0); break;	// Draw Voltage Channel 3
		case eCh4 : Selected_Voltage_CH4 = range;  VoltageChangedCh4 = 1; Display::DRAWSTATUS(4, 0); break;	// Draw Voltage Channel 4
	}


}

//##########################################################################################################################################################
/* VSync ISR, measured to happen every 208425 cycles = 16674 us = 59,974 Hz
  (even without LCD DMA enabled). This can be used for several time functions.
  So here we find some routines for delay, periodic events and simple time measuring.
*/
void Hardware::EnableVSyncInterrupt(void)							// Enable VSync service routine
{

	read_vsync->np_pioedgecapture = 0x00; 							// clear existing IRQ conditions
	read_vsync->np_piodirection = 0;							// set bit to input
	read_vsync->np_piointerruptmask = 0x01;							// enable interrupt

	nr_installuserisr(na_read_vsync_irq,ISR_VSync,(int)read_vsync);				// Install ISR for ReadVSync

	//printf("read_vsync interrupt enabled.\n"); 						// print debug information on console
	

}

void Hardware::DisableVSyncInterrupt(void)							// DisableVSync service routine
{
	nr_installuserisr(na_read_vsync_irq,0,0); 						// Install empty routine for VSync irq
	read_vsync->np_piointerruptmask = 0x00;							// disable all IRQs
}

/* here are implemented 3 delay timer and 2 periodic timer. Also available is a counter for
   the VSync events which can be used for simple time measuring. A delayed timer event or 
   a periodic timer event triggers the execution of a function. The pointer to the function
   will be loaded to the specific execution handler of the according timer.
*/
void Hardware::ISR_VSync(int context)								// VSync interrupt subroutine
{
 
	_VSyncCounter--;					// count down the main counter
	_DelayTimer[0]--;					// count down the timer 1
	_DelayTimer[1]--;					// count down the timer 2
//not in use	_DelayTimer[2]--;					// count down the timer 3
	_PeriodicTimer--;					// count down the periodic event timer 1
//not in use	_PeriodicTimer[1]--;					// count down the periodic event timer 2		
	
	/* delay handling */
	
	//Delay Timer 1
	if (_DelayTimer[0] == 0)				// delay timer event occured?
	{
		if (_DelayHdl[0] != NULL)				// execution request?
		{	
			OpSys::_ExecHdl[0] = _DelayHdl[0];				
			_DelayHdl[0] = NULL;
		}
	}

	//Delay Timer 2
	if (_DelayTimer[1] == 0)				// delay timer event occured?
	{
		if (_DelayHdl[1] != NULL)				// execution request?
		{	
			OpSys::_ExecHdl[1] = _DelayHdl[1];				
			_DelayHdl[1] = NULL;
		}
	}
/* not used at this time
 	//Delay Timer 3
	if (_DelayTimer[2] == 0)				// delay timer event occured?
	{
		if (_DelayHdl[2] != NULL)				// execution request?
		{	
			OpSys::_ExecHdl[2] = _DelayHdl[2];				
			_DelayHdl[2] = NULL;
		}
	}	
*/	
	
	
	/* execution handler 4 + 5 are reserved for periodic events */

	
	
	
	/* periodic event handling */	
	
	// Periodic Timer 1
	if (_PTimerValue != 0)						// periodic timer 1 active?
	{
		if (_PeriodicTimer == 0)					// periodic timer event occured?
		{
			//if (_PeriodicHdl != NULL)				// execution request?
			{
				OpSys::_ExecHdl[3] = _PeriodicHdl;	   	//load first periodic task to fourth exec handler
			}
						
			_PeriodicTimer = _PTimerValue;				//reload periodic timer value
		}
	}
	
/*not used at this time	
	// Periodic Timer 2
	if (_PTimerValue[1] != 0)					// periodic timer 2 active?
	{
		if (_PeriodicTimer[1] == 0)					// periodic timer event occured?
		{
			if (_PeriodicHdl != NULL)				// execution request?
			{
				OpSys::_ExecHdl[4] = _PeriodicHdl[1];	   	//load second periodic task to fifth exec handler
			}
						
			_PeriodicTimer[1] = _PTimerValue[1];			//reload periodic timer value
		}
	}	
*/	
	
	read_vsync->np_pioedgecapture = 0;			// clear IRQ conditions	
	//printf("read_vsync interrupt occured\r\n");
	//printf("VSync counter: %d\r\n",_VSyncCnt);
}

// set the delay counter 1 (60 => 1s) and set handle for execution queue
void Hardware::SetDelayTimer1(uint32_t timer, void (* hdl)(void))	
{

	//if (hdl != NULL && _DelayHdl[0] == NULL)		// check if handle is in use
	{
		_DelayHdl[0] = hdl;
		_DelayTimer[0] = timer;
	}
}

// set the delay counter 2 (60 => 1s) and set handle for execution queue
void Hardware::SetDelayTimer2(uint32_t timer, void (* hdl)(void))	
{

	//if (hdl != NULL && _DelayHdl[1] == NULL)		// check if handle is in use
	{
		_DelayHdl[1] = hdl;
		_DelayTimer[1] = timer;
	}
}

// set the delay counter 3 (60 => 1s) and set handle for execution queue
void Hardware::SetDelayTimer3(uint32_t timer, void (* hdl)(void))	
{

	//if (hdl != NULL && _DelayHdl[2] == NULL)		// check if handle is in use
	{
		_DelayHdl[2] = hdl;
		_DelayTimer[2] = timer;
	}
}

// set the periodic counter value (60 => 1s) and set handle for execution queue
void Hardware::SetPeriodicTimer(uint32_t timer, void (* hdl)(void))	
{
	if (hdl != NULL && _PeriodicHdl == NULL)		// check if handle is in use
	{
		_PeriodicHdl   = hdl;				// pointer to periodic function
		_PeriodicTimer = timer;				// load counter
		_PTimerValue   = timer;				// load counter buffer
	}
}

// clear the periodic counter value and clear handle
void Hardware::ClearPeriodicTimer(void)	
{
	_PeriodicHdl = NULL;
	_PeriodicTimer = 0;
	_PTimerValue   = 0;
}

// read actual counter value 
uint32_t Hardware::ReadVSync(void)	
{
	return _VSyncCounter;
}

// load actual counter value to counter buffer
void Hardware::ResetStopWatch(void)
{
	_VSyncBuffer = _VSyncCounter;					// get actual counter value
}

// calculate elapsed time and give it back in 1/60s format
uint32_t Hardware::ReadStopWatch(void)
{
	if (_VSyncCounter < _VSyncBuffer)				// calculate elapsed time 
	{ return _VSyncBuffer - _VSyncCounter; }			// return time in 1/60s
	else
	{ return 0xFFFFFFFF - _VSyncCounter + _VSyncBuffer; }
}




//##########################################################################################################################################################
/* BF copy buffer planes to display planes (channel planes). 
   This is necessary, because direct writing and deleting in the channel planes causes
   a flickering signal. To avoid this the signal is written into the buffer plane first
   and then copied to the channel plane.
*/
void Hardware::TransferPlanes(void)
{
	int cnt;
	
	if (MenuPopupActive > -1) return;
	
	if (UpdateMarkerPlane)
	{
	 	TransferPlanes_asm_persistant(0x008CABE4, 0x009D9DF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
		UpdateMarkerPlane = false;
	}
	
	if (UpdateMenuTextPlane)
	{
		if ((QM_Enabled == 1) || (Cursor_Enabled == 1))				//BF add by Guido
		{ TransferDataPlane_asm_persistant(0x008DBB24, 0x00970F30); }		//BF add by Guido	
		else
		{ TransferDataPlane_asm_persistant(0x008DC254, 0x00971660); }		//BF -> fixed by Guido 			

		UpdateMenuTextPlane = false;	
	}
	
	//if (Splash_drawed) return;
	
	if (MenuStatus[MENU_DISPLAY][0] == 360)	//if persistent is off -> delete channel plane and copy buffer plane
	{
	
		switch(ClearPlane)
		{ 
			case 0x00 : break;
			//only channel planes	-> offset from plane start address is 5F0
			case 0x01 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	//copy Buffer_Plane1 to Channel_Plane1
			case 0x02 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	//copy Buffer_Plane2 to Channel_Plane2
			case 0x03 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2); break;	//copy Buffer_1 to Channel_1 and Buffer_2 to Channel_2
			case 0x04 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	//copy Buffer_Plane3 to Channel_Plane3
			case 0x05 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;	//copy Buffer_1 to Channel_1 and Buffer_2 to Channel_2
			case 0x06 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break;	//copy Buffer_1 to Channel_1 and Buffer_3 to Channel_3	
			case 0x07 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3); break;
			case 0x08 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	//copy Buffer_Plane4 to Channel_Plane4
			case 0x09 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;
			case 0x0A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
			case 0x0B : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3); break;
			case 0x0C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break;	
			case 0x0D : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;
			case 0x0E : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3); break;
		
			case 0x0F :
			{
				TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
				TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);			//copy to all channel planes
				break;
			}
		
			// additional math plane
			case 0x10 : TransferPlanes_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break;	//copy Buffer_PlaneM to Channel_Math_Plane	
			case 0x11 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
			case 0x12 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;	
			case 0x13 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3); break;	
			case 0x14 : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;
			case 0x15 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;	
			case 0x16 : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3); break;
		
			case 0x17 :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);			//copy to math plane and 3 channel planes
				break;
			}
		
			case 0x18 : TransferPlanes_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2); break;		
			case 0x19 : TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		
			case 0x1A : TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;		
		
			case 0x1B :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1C : TransferPlanes_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3); break;	
		
			case 0x1D :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1E :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1F :
			{
				TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
				TransferPlanes_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);			//copy to math plane and all channel planes
				break;
			}  		
		} 
	}
	else	// persistent is on -> copy buffer planes without deleting channel planes to keep the old trace
	{	
		switch(ClearPlane)
		{
			case 0x00 : break;
			case 0x01 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	//copy Buffer_Plane1 to Channel_Plane1
			case 0x02 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	//copy Buffer_Plane2 to Channel_Plane2
			case 0x03 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2);break;	//copy Buffer_1 to Channel_1 and Buffer_2 to Channel_2
			case 0x04 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	//copy Buffer_Plane3 to Channel_Plane3	
			case 0x05 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;	//copy Buffer_1 to Channel_1 and Buffer_2 to Channel_2
			case 0x06 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2);break;	//copy Buffer_1 to Channel_1 and Buffer_3 to Channel_3	
			case 0x07 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3);break;
			case 0x08 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;	//copy Buffer_Plane4 to Channel_Plane4
			case 0x09 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
			case 0x0A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
			case 0x0B : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);break;
			case 0x0C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);break;
			case 0x0D : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;
			case 0x0E : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);break;
		
			case 0x0F :
			{
				TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
				TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
				break;
			}
		
			case 0x10 : TransferPlanes_asm_persistant(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);break;
			case 0x11 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
			case 0x12 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
			case 0x13 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);break;
			case 0x14 : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
			case 0x15 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;
			case 0x16 : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);break;
		
			case 0x17 :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
				break;
			}
		
			case 0x18 : TransferPlanes_asm_persistant(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);break;
			case 0x19 : TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;
			case 0x1A : TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;
		
			case 0x1B :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1C : TransferPlanes_asm_persistant(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);break;
		
			case 0x1D :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1E :
			{
				TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
				TransferPlanes_asm_persistant(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
				break;
			}
		
			case 0x1F :
			{
				TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
				TransferPlanes_asm_persistant(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
				break;
			}
		}
	}


       	Display::DRAWSIGNS();				// draw zero markers
       	if (Menu_Changed){ Display::UpdateMenu(); }	// redraw buttons


//BF test 	
	if(!UI_request)	ZL_changed = 0;
	
	VS_TrigLevelChanged = 0;	//reset triggerlevel change flag
	VS_ZeroLevelChanged = 0;	//reset zerolevel change flag
//test end

	//BF test ClearPlane &= 0xE0;
	//ClearPlane = 0xE0;	
    	ClearPlane = 0;
    	
    	
	//reset_watchdog->np_piodata = 0x01;								// Enable WatchDog	

}
//##########################################################################################################################################################
void Hardware::ClearPlanes(void)
{
//	reset_watchdog->np_piodata = 0x00;								// Disable WatchDog
	
	if (Channel[eCh1].active == 1) DrawPlane |= 0x01;	
	if (Channel[eCh2].active == 1) DrawPlane |= 0x02;
	
	if (Channel[eCh3].active == 1) DrawPlane |= 0x04;
	if (Channel[eCh4].active == 1) DrawPlane |= 0x08;
	
	if (Channel[eChM].active == 1) DrawPlane |= 0x10;

	ClearPlane = DrawPlane | RemovePlane;
	DrawPlane = 0;
   	   	
	//printf("ClearPlane = %x\r\n");

	switch(ClearPlane)
	{
		case 0x01 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x02 :
		{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x03 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x00000000, 0x00000000, 2); break; }
		case 0x04 :
		{ TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
		case 0x05 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break; }
		case 0x06 :
		{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x00000000, 0x00000000, 2); break; }
		case 0x07 :
		{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 3); break; }	
		case 0x08 :
	    	{ TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1); break; }
        	case 0x09 :
	    	{ TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break; }
        	case 0x0A :
	    	{ TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2); break; }
		case 0x0B :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0C :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000, 2);
		break;	
			}
		case 0x0D :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0E :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 3);
		break;
			}
		case 0x0F :
		{
		TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
		break;
			}     	
		case 0x10 :
		{
		TransferPlanes_clear_asm(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 1);
		break;	
			}
		case 0x11 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;
			}
		case 0x12 :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;	
			}
		case 0x13 :
		{  	
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x14 :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;
			}
		case 0x15 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x16 :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009311F0, 0x009B45F0, 3);
		break;
			}
		case 0x17 :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 4);
		break;		
			}
		case 0x18 :
		{
		TransferPlanes_clear_asm(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 0x00000000, 0x00000000, 2);
		break;		
			}                                        		
		case 0x19 :
		{
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;		
			}               		
		case 0x1A :
		{
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;		
			}
		case 0x1B :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);	
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x009569F0, 0x009AAFF0, 4);
		break;		
			}
		case 0x1C :
		{
		TransferPlanes_clear_asm(0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0, 3);
		break;	
			}
		case 0x1D :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
		break;
			}
		case 0x1E :
		{
		TransferPlane_Set_Buffer_Adr(0x009311F0, 0x009B45F0, 0x00000000, 0x00000000);
		TransferPlanes_clear_asm(0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 0x009569F0, 0x009AAFF0, 4);
		break;	
			}           		
		case 0x1F :
		{
		TransferPlane_Set_Buffer_Adr(0x009569F0, 0x009AAFF0, 0x009311F0, 0x009B45F0);
		TransferPlanes_clear_asm(0x0093A7F0, 0x0098EDF0, 0x00943DF0, 0x009983F0, 0x0094D3F0, 0x009A19F0, 5);
		break;
			}		
	}	
	

	ClearPlane &= 0xE0;	
}
//##########################################################################################################################################################
//BF changed by Guido for the bigger grid size
void Hardware::TransferDataPlane_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1)
{
	if ((QM_Enabled == 1) || (Cursor_Enabled == 1))
	{
		asm("
            		PFX	    %hi(1460)                	; //Set Counter 	BF-> 1460 for cursor data
            		MOVI	%l1,%lo(1460)			; 

            		loopmtpp1:
            		LD     %l0, [%i0]                  	; //Load Buffer Data to %r0 	
            		ST     [%i1], %l0                  	; //Store it to Plane

            		ADDI   %i0, 4               		; //Add Address Counter
            		ADDI   %i1, 4	
	
            		SUBI   %l1, 1              		; //Decrement Line Counter
            		SKPS   cc_z
            		BR     loopmtpp1
            		NOP 	
        		");
	}
	else
	{
		asm("
            		PFX	    %hi(1000)                	; //Set Counter 	BF-> change from 1460 to 1000 for new grid size to avoid pixel error
            		MOVI	%l1,%lo(1000)			; //BF-> new value calculated by Guido

            		loopmtpp1_a:
            		LD     %l0, [%i0]                  	; //Load Buffer Data to %r0 	
            		ST     [%i1], %l0                  	; //Store it to Plane

            		ADDI   %i0, 4               		; //Add Address Counter
            		ADDI   %i1, 4	
	
            		SUBI   %l1, 1              		; //Decrement Line Counter
            		SKPS   cc_z
            		BR     loopmtpp1_a
            		NOP 	
        		");
	}
}

void Hardware::TransferPlane_Set_Buffer_Adr(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2)
{
    asm("
            MOV		%r4,%i0	
            MOV		%r5,%i1

            MOV		%r6,%i2
            MOV		%r7,%i3
        ");
}

void Hardware::TransferPlanes_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp3
                    NOP 	
                ");
            break;
        }

	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                    ST     [%i0], %l2                        ; Clear Buffer

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                    ST     [%i2], %l2                        ; Clear Buffer

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                    ST     [%i4], %l2                        ; Clear Buffer

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                    ST     [%r4], %l2                        ; Clear Buffer

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                    ST     [%r6], %l2                        ; Clear Buffer
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_asm_persistant(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp1:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)
	
                    looptpp2:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)
	
                    looptpp3:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp4:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    looptpp5:
                    LD     %l0, [%i0]                        ; Load Buffer Data to %r0 	
                    ST     [%i1], %l0                        ; Store it to Plane

                    LD     %l0, [%i2]                        ; Load Buffer Data to %r0
                    ST     [%i3], %l0                        ; Store it to Plane

                    LD     %l0, [%i4]                        ; Load Buffer Data to %r0
                    ST     [%i5], %l0                        ; Store it to Plane

                    LD     %l0, [%r4]                        ; Load Buffer Data to %r0
                    ST     [%r5], %l0                       ; Store it to Plane

                    LD     %l0, [%r6]                        ; Load Buffer Data to %r0
                    ST     [%r7], %l0                       ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpp5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::TransferPlanes_clear_asm(unsigned long Buffer_Adr1, unsigned long Plane_Adr1, unsigned long Buffer_Adr2, unsigned long Plane_Adr2, unsigned long Buffer_Adr3, unsigned long Plane_Adr3, unsigned char count)
{
	switch(count)
	{
	    case 1 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc1:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc1
                    NOP 	
                ");
            break;
        }
	    case 2 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc2:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane
                                                              	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc2
                    NOP 	
                ");
            break;
        }

	    case 3 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc3:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane
                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc3
                    NOP 	
                ");
            break;
        }
	    case 4 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc4:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane
                          	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc4
                    NOP 	
                ");
            break;
        }                        	
	    case 5 :
	    {
	        asm("
                    PFX	    %hi(8060)                         ; Set Counter
                    MOVI	%l1,%lo(8060)

                    PFX	    %hi(0)                            ; Set Clear register
                    MOVI	%l2,%lo(0)
                    PFX	    %xhi(0)
                    MOVHI	%l2,%xlo(0)	
	
                    looptpc5:
                    ST     [%i0], %l2                        ; Clear Buffer
                    ST     [%i1], %l2                        ; Store it to Plane

                    ST     [%i2], %l2                        ; Clear Buffer
                    ST     [%i3], %l2                        ; Store it to Plane

                    ST     [%i4], %l2                        ; Clear Buffer
                    ST     [%i5], %l2                        ; Store it to Plane

                    ST     [%r4], %l2                        ; Clear Buffer
                    ST     [%r5], %l2                        ; Store it to Plane

                    ST     [%r6], %l2                        ; Clear Buffer
                    ST     [%r7], %l2                        ; Store it to Plane

                                                               	
                    ADDI   %i0, 4                            ; Add Address Counter
                    ADDI   %i1, 4	

                    ADDI   %i2, 4
                    ADDI   %i3, 4	

                    ADDI   %i4, 4
                    ADDI   %i5, 4	

                    ADDI   %r4, 4
                    ADDI   %r5, 4	
	
                    ADDI   %r6, 4
                    ADDI   %r7, 4		
	
                    SUBI   %l1, 1                            ; Decrement Line Counter
                    SKPS   cc_z
                    BR     looptpc5
                    NOP 	
                ");
            break;
        }
    }
}

void Hardware::Planes_clear_asm(unsigned long Buffer_Adr1)
{
	asm("
            PFX	    %hi(8060)                         ; Set Counter
            MOVI	%l1,%lo(8060)

            PFX	    %hi(0)                            ; Set Clear register
            MOVI	%l2,%lo(0)
            PFX	    %xhi(0)
            MOVHI	%l2,%xlo(0)	
	
        looptpcc1:
            ST     [%i0], %l2                        ; Clear Buffer

            ADDI   %i0, 4                            ; Add Address Counter
	
            SUBI   %l1, 1                            ; Decrement Line Counter
            SKPS   cc_z
            BR     looptpcc1
            NOP 	
        ");
}

void Hardware::Planes_clear_asm_all(unsigned char count, unsigned long Buffer_Adr1, unsigned long Buffer_Adr2, unsigned long Buffer_Adr3, unsigned long Buffer_Adr4, unsigned long Buffer_Adr5)
{
    switch(count)
    {
        case 1 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc21:
                ST     [%i1], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc21
                NOP 	
            ");
            break;
        }
        case 2 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc22:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc22
                NOP 	
            ");
            break;
        }
        case 3 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc23:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc23
                NOP 	
            ");
            break;
        }
        case 4 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc24:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc24
                NOP 	
            ");
            break;
        }
        case 5 :
        {
	       asm("
                PFX	    %hi(8060)                         ; Set Counter
                MOVI	%l1,%lo(8060)

                PFX	    %hi(0)                            ; Set Clear register
                MOVI	%l2,%lo(0)
                PFX	    %xhi(0)
                MOVHI	%l2,%xlo(0)	
	
            looptpcc25:
                ST     [%i1], %l2                        ; Clear Buffer
                ST     [%i2], %l2                        ; Clear Buffer
                ST     [%i3], %l2                        ; Clear Buffer
                ST     [%i4], %l2                        ; Clear Buffer
                ST     [%i5], %l2                        ; Clear Buffer

                ADDI   %i1, 4                            ; Add Address Counter
                ADDI   %i2, 4                            ; Add Address Counter
                ADDI   %i3, 4                            ; Add Address Counter
                ADDI   %i4, 4                            ; Add Address Counter
                ADDI   %i5, 4                            ; Add Address Counter
            	
                SUBI   %l1, 1                            ; Decrement Line Counter
                SKPS   cc_z
                BR     looptpcc25
                NOP 	
            ");
            break;
        }
    }
}
/*BF not used	
void Hardware::DoEnableLogicAnalyserInterrupt(void)							// Enable service routine
{
	la_interrupt->np_pioedgecapture = 0x00; 							// clear all existing IRQ conditions
	la_interrupt->np_piodirection = 0x00;								// set all bits to input
	la_interrupt->np_piointerruptmask = 0x01;							// enable Button IRQs
	la_interrupt->np_piodata = 0;

	nr_installuserisr(na_la_interrupt_irq,ISR_LogicAnalyser,(int)la_interrupt);	// Install ISR for parallel I/Os

#ifdef _Debug_IRQ_
	if (Debug_Mode) printf("\nLogicAnalyser interrupt enabled.\n"); 						// print on console
#endif	
}
*/

/*BF not used	
void Hardware::DoDisableLogicAnalyserInterrupt(void)						// Disable parallel I/O service routine
{
	nr_installuserisr(na_la_interrupt_irq,0,0); 				// Install empty routine for pio irq
	la_interrupt->np_piointerruptmask = 0x00;						// disable all IRQs
}
*/

/*BF not used
void Hardware::ISR_LogicAnalyser(int context)
{
	char la_data_cnt;
	
	tc_test_var2++;

	la_gate->np_piodata = 0x01;
	
	for (la_data_cnt = 0; la_data_cnt < 32; la_data_cnt++)
	{
		la_pulse->np_piodata = 0x01;
		
		LogicData[la_data_cnt] = la_data-> np_piodata;
		
		la_pulse->np_piodata = 0x00;		
	}	
	
	la_gate->np_piodata = 0x00;
	
    la_interrupt->np_pioedgecapture = 0; 								// clear IRQ conditions		

	//if (USB_Data_Trans == 1)
	{
		send_buffer[0] = 3;						// Command Write Data
		send_buffer[1] = 20;
		send_buffer[2] = 1;
		
		CommIF::SendData(send_buffer);	
	}
#ifdef _Debug_IRQ_	
	if (Debug_Mode) printf("\nLogicAnalyser interrupt received\n");
#endif	
}
*/

//##########################################################################################################################################################
//BF added
// Calculate ADC offset for specified channel
void Hardware::Calc_ADC_Offset(uint32_t channel)
{
	int32_t adc1 = 0, adc2 = 0, adc3 = 0, adc4 = 0;
	int32_t ix = 0, ref; 
	
	printf("\r\nChannel %d start calibrating ADC offsets\r\n", channel);

	switch(channel)
	{
		case eCh1:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 100; ix < 2100; ix+=4)
			{ adc1 += SIGNAL1[ix];adc2 += SIGNAL1[ix+1];adc3 += SIGNAL1[ix+2];adc4 += SIGNAL1[ix+3];}
			break;	
		}
		case eCh2:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 100; ix < 2100; ix+=4)
			{ adc1 += SIGNAL2[ix];adc2 += SIGNAL2[ix+1];adc3 += SIGNAL2[ix+2];adc4 += SIGNAL2[ix+3];}
			break;	
		}
		case eCh3:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 100; ix < 2100; ix+=4)
			{ adc1 += SIGNAL3[ix];adc2 += SIGNAL3[ix+1];adc3 += SIGNAL3[ix+2];adc4 += SIGNAL3[ix+3];}
			break;	
		}
		case eCh4:
		{
			//get sum of values separate for each of the four ADCs
			for (ix = 100; ix < 2100; ix+=4)
			{ adc1 += SIGNAL4[ix];adc2 += SIGNAL4[ix+1];adc3 += SIGNAL4[ix+2];adc4 += SIGNAL4[ix+3];}
			break;	
		}
	}

	//calculate average for each ADC	
	ix = ix >> 2;	

	adc1 /= ix;
	adc2 /= ix;
	adc3 /= ix;
	adc4 /= ix;

	//get ADC with smallest offset as  zero reference 
	ref = adc1;
	if( adc2 < ref ) ref = adc2;
	if( adc3 < ref ) ref = adc3;
	if( adc4 < ref ) ref = adc4;
	
	//calculate offsets
        _ADC_Offset[channel][0] = (unsigned char) (adc1 - ref);
	_ADC_Offset[channel][1] = (unsigned char) (adc2 - ref);
	_ADC_Offset[channel][2] = (unsigned char) (adc3 - ref);
	_ADC_Offset[channel][3] = (unsigned char) (adc4 - ref);

	printf("ADC 1 Offset = %d\r\n",_ADC_Offset[channel][0]);
	printf("ADC 2 Offset = %d\r\n",_ADC_Offset[channel][1]);
	printf("ADC 3 Offset = %d\r\n",_ADC_Offset[channel][2]);
	printf("ADC 4 Offset = %d\r\n",_ADC_Offset[channel][3]);


}
//##########################################################################################################################################################
//BF added
//Calculate DAC offset correction for specified channel
int Hardware::Calc_DAC_Correction(uint32_t channel, int32_t *Correction)
{

	//-------------------------------------------------------------------------------------------
	// BF new calibration	
	//------------------------------------------------------------------------------------------
//	printf("\r\nChannel %d start calibrating DAC zero\r\n", channel);
//	printf("DAC correction old  = %d\r\n", *Correction);

	int32_t ADC_sum = 0;
	int32_t ADC_diff;
	int32_t ix = 0, lvoltage_range = 0; 
	
	switch(channel)
	{
		case eCh1:	// channel 1
		{
			//get sum of values
			for (ix = 100; ix < 500; ix++)
			{ ADC_sum += SIGNAL1[ix]; }
			lvoltage_range = Selected_Voltage_CH1;
			break;	
		}
		case eCh2:	// channel 2
		{
			//get sum of values
			for (ix = 100; ix < 500; ix++)
			{ ADC_sum += SIGNAL2[ix]; }
			lvoltage_range = Selected_Voltage_CH2;	
			break;	
		}
		case eCh3:	// channel 3
		{
			//get sum of values
			for (ix = 100; ix < 500; ix++)
			{ ADC_sum += SIGNAL3[ix]; }
			lvoltage_range = Selected_Voltage_CH3;	
			break;	
		}
		case eCh4:	// channel 4
		{
			//get sum of values
			for (ix = 100; ix < 500; ix++)
			{ ADC_sum += SIGNAL4[ix]; }
			lvoltage_range = Selected_Voltage_CH4;	
			break;	
		}
	}

	//get average offset of each ADC-set
	ADC_sum /= 400;
	printf("Channel %d: ADC average value  = %d   ", channel, ADC_sum);

	//calculate offset from zero
	ADC_diff = ADC_sum - ADC_ZERO;
//	printf("ADC offset         = %d\r\n", ADC_diff);

	
	//approximate correction value
	switch(lvoltage_range)
	{
		/*case 0: *Correction -= ADC_diff * 6; break;//  1 mV
		case 1: *Correction -= ADC_diff * 14; break;//  2 mV
		case 2: *Correction -= ADC_diff * 27; break;//  5 mV
		case 3: *Correction -= ADC_diff * 6; break;// 10 mV
		case 4: *Correction -= ADC_diff * 14; break;// 20 mV
		case 5: *Correction -= ADC_diff * 27; break;// 50 mV
		case 6: *Correction -= ADC_diff * 6; break;//100 mV
		case 7: *Correction -= ADC_diff * 14; break;//200 mV
		case 8: *Correction -= ADC_diff * 27; break;//500 mV */
		case e1V: *Correction -= (int32_t)((float)ADC_diff * DAC_ScaleFactorTable[0][GainIdx] * ScaleFactorTable[0][GainIdx]); break;//1 V
		case e2V: *Correction -= (int32_t)((float)ADC_diff * DAC_ScaleFactorTable[1][GainIdx] * ScaleFactorTable[0][GainIdx]); break;//2 V
		case e5V: *Correction -= (int32_t)((float)ADC_diff * DAC_ScaleFactorTable[2][GainIdx] * ScaleFactorTable[1][GainIdx]); break;//5 V
	}

//	printf("DAC Correction new  = %d\r\n", Correction[0]);
printf("Diff  = %d\r\n", ADC_diff);
	return ADC_diff;

}
//##########################################################################################################################################################
//BF added
//Calibrate all ADCs2 => 500MS is a pseudo 16K mode with true 8K samples
void Hardware::Calibrate_ADC_ZeroOffsets(void)
{

	int32_t ch_del_bak[4];

/*
	char lChannel_1_bak, lChannel_2_bak, lChannel_3_bak, lChannel_4_bak;
	//char lCH1_VR_bak,lCH2_VR_bak, lCH3_VR_bak, lCH4_VR_bak;
	long int lTB_reg_bak;


	Display::DRAWROUNDBUTTON(200, 180, 240, 80, 0, 0);
	Display::TextOut12x9("Calibrating ADC Offsets.", 217, 192, 1, UI_Plane2);
	Display::TextOut12x9("All inputs must be removed!", 217, 212, 1, UI_Plane2);
	Display::TextOut12x9("This may take some seconds...", 217, 232, 1, UI_Plane2);
*/

	//backup BF  #001 
	ch_del_bak[eCh1] = _ChannelDelay[eCh1];
	ch_del_bak[eCh2] = _ChannelDelay[eCh2];
	ch_del_bak[eCh3] = _ChannelDelay[eCh3];
	ch_del_bak[eCh4] = _ChannelDelay[eCh4];

//	Channel delay correction must be reset for correct ADC adjustment  BF  #001 
	_ChannelDelay[eCh1] = 0;
	_ChannelDelay[eCh2] = 0;
	_ChannelDelay[eCh3] = 0;
	_ChannelDelay[eCh4] = 0;
/*
	lCH1_VR_bak = Selected_Voltage_CH1;
	lCH2_VR_bak = Selected_Voltage_CH2;
	lCH3_VR_bak = Selected_Voltage_CH3;
	lCH4_VR_bak = Selected_Voltage_CH4;

	Selected_Voltage_CH1 = 11;	// 5V
	Selected_Voltage_CH2 = 11;	// 5V
	Selected_Voltage_CH3 = 11;	// 5V
	Selected_Voltage_CH4 = 11;	// 5V
*/
/*
	//backup settings and activate channels
	lChannel_1_bak = Channel[eCh1].active; Channel[eCh1].active = 1;
	lChannel_2_bak = Channel[eCh2].active; Channel[eCh2].active = 1;
	lChannel_3_bak = Channel[eCh3].active; Channel[eCh3].active = 1;
	lChannel_4_bak = Channel[eCh4].active; Channel[eCh4].active = 1;

	lTB_reg_bak  = timebase_reg;	//backup timebase
	timebase_reg = 0xFFFFFFFF;      //set real timebase 50ns (1GSa/s)
*/
	SetSwitches(eCh1, 11);	// 5V
	SetSwitches(eCh2, 11);	// 5V
	SetSwitches(eCh3, 11);	// 5V
	SetSwitches(eCh4, 11);	// 5V

	_regADC[eFPGA1].pre = 0x002D;
	_regADC[eFPGA2].pre = 0x002D;

	//disable triggersource and triggering
	//triggering = 0;	
	CaptureTrigSetMode(eTrigFreerun);	// switch off trigger and write shadow registers to hardware
	nr_delay(50);	

	start_acq->np_piodata = 0x01;				//start record Port On
	start_acq->np_piodata = 0x00;				//start record Port Off

	//wait for ADC
	int timeout;
	for(timeout=0;(timeout < 100) && acq_ready->np_piodata == 0x01;timeout++)
	nr_delay(30);

	if (timeout >= 100 ){ printf("Timeout\r\n"); }
	
	data_adr->np_piodata = 0x01;

	ReadADC(eCh1);	
	WriteADC(eCh1, 0);
	WriteADC(eCh2, 0);

	if (NumberOfChannels > 2)
	{
		ReadADC(eCh3);
		WriteADC(eCh3, 0);
		WriteADC(eCh4, 0);
	}
	
	data_adr->np_piodata = 0x00;
	
	//read signal and calibrate ADC-offsets
	//reset offsets channel 1
	_ADC_Offset[eCh1][0] = 0;
	_ADC_Offset[eCh1][1] = 0;
	_ADC_Offset[eCh1][2] = 0;
	_ADC_Offset[eCh1][3] = 0;
	
	//ADC_ReadData(eCh1, SIGNAL1, 560, false); 
	ADC_Capture_ASM(eCh1, SIGNAL1, 1, 560, _ADC_Offset[eCh1]);
	Calc_ADC_Offset(eCh1);
	
	//reset offsets channel 2
	_ADC_Offset[eCh2][0] = 0;
	_ADC_Offset[eCh2][1] = 0;
	_ADC_Offset[eCh2][2] = 0;
	_ADC_Offset[eCh2][3] = 0;
	
	//ADC_ReadData(eCh2, SIGNAL2, 560, false);
	ADC_Capture_ASM(eCh2, SIGNAL2, 1, 560, _ADC_Offset[eCh2]);
	Calc_ADC_Offset(eCh2);

	if (NumberOfChannels == 4)
	{
		//reset offsets channel 3
		_ADC_Offset[eCh3][0] = 0;
		_ADC_Offset[eCh3][1] = 0;
		_ADC_Offset[eCh3][2] = 0;
		_ADC_Offset[eCh3][3] = 0;
		
		//ADC_ReadData(eCh3, SIGNAL3, 560, false);
		ADC_Capture_ASM(eCh3, SIGNAL3, 1, 560, _ADC_Offset[eCh3]);
		Calc_ADC_Offset(eCh3);

		//reset offsets channel 4
		_ADC_Offset[eCh4][0] = 0;
		_ADC_Offset[eCh4][1] = 0;
		_ADC_Offset[eCh4][2] = 0;
		_ADC_Offset[eCh4][3] = 0;
		
		//ADC_ReadData(eCh4, SIGNAL4, 560, false);
		ADC_Capture_ASM(eCh4, SIGNAL4, 1, 560, _ADC_Offset[eCh4]);
		Calc_ADC_Offset(eCh4);
	}	

/* -> all done in zero offset calibration routine!	
	//Save new values to flash
   	AMDFlash::Write_Protected_Flash();

	//restore settings
	Channel[eCh1].active = lChannel_1_bak;
	Channel[eCh2].active = lChannel_2_bak;
	Channel[eCh3].active = lChannel_3_bak;
	Channel[eCh4].active = lChannel_4_bak;
*/
/*
	Selected_Voltage_CH1 = lCH1_VR_bak;
	Selected_Voltage_CH2 = lCH2_VR_bak;
	Selected_Voltage_CH3 = lCH3_VR_bak;
	Selected_Voltage_CH4 = lCH4_VR_bak;
*/
/*
	//restore timebase settings
	timebase_reg = lTB_reg_bak; //tb_value[RealTimebase];

	SetSwitches(eCh1, Selected_Voltage_CH1);
	SetSwitches(eCh2, Selected_Voltage_CH2);
	SetSwitches(eCh3, Selected_Voltage_CH3);
	SetSwitches(eCh4, Selected_Voltage_CH4);

	SetupTrigger();	//setup ADC control registers
*/
	//restore BF  #001 
	_ChannelDelay[eCh1] = ch_del_bak[eCh1];
	_ChannelDelay[eCh2] = ch_del_bak[eCh2];
	_ChannelDelay[eCh3] = ch_del_bak[eCh3];
	_ChannelDelay[eCh4] = ch_del_bak[eCh4];

/*
	//wait a little bit
	nr_delay(100);	

	if(Run) Start_Record();
	else ADC_DataAvailable = 0;

	//Delete popup
	Display::DRAWROUNDBUTTON(200, 180, 240, 80, 0, 1);
	Display::TextOut12x9("Calibrating ADC Offsets.", 217, 192, 0, UI_Plane2);
	Display::TextOut12x9("All inputs must be removed!", 217, 212, 0, UI_Plane2);
	Display::TextOut12x9("This may take some seconds...", 217, 232, 0, UI_Plane2);

*/


}
//##########################################################################################################################################################
//BF added
//Calibrate DACs for all channels and all voltage ranges
void Hardware::Calibrate_DAC_ZeroOffsets(void)
{
	uint32_t TB_bak;
	uint32_t lVoltRange;
	uint32_t lCH1_VR_bak,lCH2_VR_bak, lCH3_VR_bak, lCH4_VR_bak;
	int32_t ch_del_bak[4];
	uint32_t lChannel_1_bak, lChannel_2_bak, lChannel_3_bak, lChannel_4_bak;

	int32_t lDiff[4][3];

	unsigned char *signal[4] = {SIGNAL1, SIGNAL2, SIGNAL3, SIGNAL4};


	// initialize array
	for (int i=0;i<4;i++)
	{ for(int j=0;j<3;j++){ lDiff[i][j] = 0xFFFF; }}


	Display::DRAWROUNDBUTTON(200, 180, 240, 80, 0, 0);
	Display::TextOut12x9("Calibrating Offsets.", 217, 192, 1, UI_Plane2);
	Display::TextOut12x9("All inputs must be removed!", 217, 212, 1, UI_Plane2);
	Display::TextOut12x9("This may take some seconds...", 217, 232, 1, UI_Plane2);

	DoDisableUARTInterrupt();
	DoDisableADCInterrupt();
	DoDisableKeyInterrupt();
	DoDisableRotInterrupt();


	// Backup actual values

	//backup BF  #001 
	ch_del_bak[eCh1] = _ChannelDelay[eCh1];
	ch_del_bak[eCh2] = _ChannelDelay[eCh2];
	ch_del_bak[eCh3] = _ChannelDelay[eCh3];
	ch_del_bak[eCh4] = _ChannelDelay[eCh4];

//	Channel delay correction must be reset for correct ADC adjustment  BF  #001 
	_ChannelDelay[eCh1] = 0;
	_ChannelDelay[eCh2] = 0;
	_ChannelDelay[eCh3] = 0;
	_ChannelDelay[eCh4] = 0;

	lCH1_VR_bak = Selected_Voltage_CH1;
	lCH2_VR_bak = Selected_Voltage_CH2;
	lCH3_VR_bak = Selected_Voltage_CH3;
	lCH4_VR_bak = Selected_Voltage_CH4;

	lChannel_1_bak = Channel[eCh1].active;
	lChannel_2_bak = Channel[eCh2].active;
	lChannel_3_bak = Channel[eCh3].active;
	lChannel_4_bak = Channel[eCh4].active;

	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	//set DAC correction to default
	DAC_Correction[CalSet][eCh1][0] = 400;
	DAC_Correction[CalSet][eCh1][1] = 520;
	DAC_Correction[CalSet][eCh1][2] = 400;
	
	DAC_Correction[CalSet][eCh2][0] = 400;
	DAC_Correction[CalSet][eCh2][1] = 520;
	DAC_Correction[CalSet][eCh2][2] = 400;

	if (NumberOfChannels == 4)
	{
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

		DAC_Correction[CalSet][eCh3][0] = 400;
		DAC_Correction[CalSet][eCh3][1] = 520;
		DAC_Correction[CalSet][eCh3][2] = 400;
		
		DAC_Correction[CalSet][eCh4][0] = 400;
		DAC_Correction[CalSet][eCh4][1] = 520;
		DAC_Correction[CalSet][eCh4][2] = 400;
	}

	TB_bak  = MainTimebase;		//backup timebase
        MainTimebase = 4;   		//set timebase 50ns (1GSa/s)

	//pre_reg = 0x002D;

	// calibrate ADC offsets first
	Calibrate_ADC_ZeroOffsets();		// shadow registers are written to hardware here!

	// range loop for 1V / 2V / 5V
	for(lVoltRange = 9; lVoltRange <= 11; lVoltRange++)
	{
printf("\n\r**************** Voltage Range %d ********************\n\r",lVoltRange);
		
		Selected_Voltage_CH1 = lVoltRange;	//needed for calibration subroutine
		Selected_Voltage_CH2 = lVoltRange;	//needed for calibration subroutine
		
		SetSwitches(eCh1, lVoltRange);	
		SetSwitches(eCh2, lVoltRange);

		if (NumberOfChannels == 4)
		{	
			Selected_Voltage_CH3 = lVoltRange;	//needed for calibration subroutine
			Selected_Voltage_CH4 = lVoltRange;	//needed for calibration subroutine
			
			SetSwitches(eCh3, lVoltRange);
			SetSwitches(eCh4, lVoltRange);
		}

		nr_delay(100);
	
		//make several calibration runs to approximate zero
		for(int32_t i=0; i<10; i++)
		{
			//check if calibration is done
			if(NumberOfChannels == 4)
			{ if(lDiff[eCh1][lVoltRange-9] == 0 && lDiff[eCh2][lVoltRange-9] == 0 && lDiff[eCh3][lVoltRange-9] == 0 && lDiff[eCh4][lVoltRange-9] == 0){printf("Range %d calibration complete\n\r",lVoltRange); break; }}
			else
			{ if(lDiff[eCh1][lVoltRange-9] == 0 && lDiff[eCh2][lVoltRange-9] == 0) {printf("Range %d calibration complete\n\r",lVoltRange); break; } }

			printf("Calibration run %d\n\r",i+1);

			// set DAC to scale middle and set default offset correction
			switch(lVoltRange)
			{
				case e1V://1 V
				{
					CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][0];
					CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][0];
					CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][0];
					CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][0];
					//printf("\n\n\r*** Voltage Range 1V ***\n\r");
					break;
				}
				case e2V://2 V
				{
					CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][1];
					CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][1];
					CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][1];
					CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][1];
					//printf("\n\n\r*** Voltage Range 2V ***\n\r");
					break;
				}
				case e5V://5 V
				{
					CH1_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh1][2];
					CH2_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh2][2];
					CH3_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh3][2];
					CH4_DAC_Offset = DAC_MIDSCALE + DAC_Correction[CalSet][eCh4][2];
					//printf("\n\n\r*** Voltage Range 5V ***\n\r");
					break;
				}
			}

			SetDacOffset(eCh1);	
			SetDacOffset(eCh2);	

			if (NumberOfChannels == 4)
			{				
				SetDacOffset(eCh3);	
				SetDacOffset(eCh4);	
			}

			nr_delay(50);	

			start_acq->np_piodata = 0x01;				//start record Port On
			start_acq->np_piodata = 0x00;				//start record Port Off
		
			//wait for ADC
			int32_t timeout;
			for(timeout=0;(timeout < 100) && acq_ready->np_piodata == 0x01;timeout++)
			nr_delay(30);
		
			if (timeout >= 100 ){ printf("Timeout\r\n"); continue; }
		
			data_adr->np_piodata = 0x01;
		
			ReadADC(eCh1);	
			WriteADC(eCh1, 0);
			WriteADC(eCh2, 0);
		
			if (NumberOfChannels > 2)
			{
				ReadADC(eCh3);
				WriteADC(eCh3, 0);
				WriteADC(eCh4, 0);
			}
			
			data_adr->np_piodata = 0x00;
			
			// calibrate each channel
			for (uint32_t channel = 0; channel < NumberOfChannels ; channel++)
			{
				if(lDiff[channel][lVoltRange-9] == 0) continue;

				//read signal and calibrate DAC-offsets
				//ADC_ReadData(channel, signal[channel], 2400, false);
				ADC_Capture_ASM(channel, signal[channel], 1, 2400, _ADC_Offset[channel]);

				lDiff[channel][lVoltRange-9] = Calc_DAC_Correction(channel, &DAC_Correction[CalSet][channel][lVoltRange-9]);	
			}

		}	//for loop calbration runs end
	
	}	//for loop voltage ranges end


	//restore timebase
	MainTimebase = TB_bak;

	//restore voltage ranges
	Selected_Voltage_CH1 = lCH1_VR_bak;
	Selected_Voltage_CH2 = lCH2_VR_bak;
	Selected_Voltage_CH3 = lCH3_VR_bak;
	Selected_Voltage_CH4 = lCH4_VR_bak;

	SetSwitches(eCh1, Selected_Voltage_CH1);
	SetSwitches(eCh2, Selected_Voltage_CH2);
	SetSwitches(eCh3, Selected_Voltage_CH3);
	SetSwitches(eCh4, Selected_Voltage_CH4);

	//activate settings
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_2();
	if (NumberOfChannels == 4)
	{	
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_3();
	
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_4();
	}
	//SetupTrigger();	//setup ADC control registers -> is done in channel zero handler above

	Channel[eCh1].active = lChannel_1_bak;
	Channel[eCh2].active = lChannel_2_bak;
	Channel[eCh3].active = lChannel_3_bak;
	Channel[eCh4].active = lChannel_4_bak;

	//restore channel delay BF  #001 
	_ChannelDelay[eCh1] = ch_del_bak[eCh1];
	_ChannelDelay[eCh2] = ch_del_bak[eCh2];
	_ChannelDelay[eCh3] = ch_del_bak[eCh3];
	_ChannelDelay[eCh4] = ch_del_bak[eCh4];

	
	//Save new values to flash
	AMDFlash::WriteCalibration();

	DoEnableRotInterrupt();
	DoEnableKeyInterrupt();
	DoEnableADCInterrupt();
	DoEnableUARTInterrupt();

	Display::CalcPreTriggerPos();

	if(Run) Start_Record();
	else ADC_DataAvailable = 0;

	//Delete popup
	Display::DRAWROUNDBUTTON(200, 180, 240, 80, 0, 1);
	Display::TextOut12x9("Calibrating Offsets.", 217, 192, 0, UI_Plane2);
	Display::TextOut12x9("All inputs must be removed!", 217, 212, 0, UI_Plane2);
	Display::TextOut12x9("This may take some seconds...", 217, 232, 0, UI_Plane2);


}
//##########################################################################################################################################################
void Hardware::FFT_Set_Channel(unsigned char backup)
{
	//Hardware::Stop_Record();

	if (backup)
	{
		//printf("- FFT Backup Channels\r\n");

		//Backup channel status
		ChannelStatusOld[eChM] = Channel[eChM].active;
		ChannelStatusOld[eCh1] = Channel[eCh1].active;
		ChannelStatusOld[eCh2] = Channel[eCh2].active;
		if(NumberOfChannels == 4)
		{
			ChannelStatusOld[eCh3] = Channel[eCh3].active;	
			ChannelStatusOld[eCh4] = Channel[eCh4].active;
		}
		else
		{
			ChannelStatusOld[eCh3] = Channel[eCh3].active = 0;	
			ChannelStatusOld[eCh4] = Channel[eCh4].active = 0;
		}

/*
		//Backup triggersetting and force auto mode	
		FFT_TriggerMode_bak = MenuStatus[MENU_TRIGGERMODE][0];	// remember the trigger setting
		MenuStatus[MENU_TRIGGERMODE][0] = 92;			//set trigger auto mode (or combi???)
		Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);	//BF #007
		TriggerLevelChanged = 1;
		TriggerModeChanged = 1;
		SetupTrigger();
*/	}

	// which channel has to be active?
	switch(MenuStatus[MENU_FFT][0])	//FFT source
	{
		case 137: Channel[eCh1].active = 1;	Channel[eCh2].active = 0; Channel[eCh3].active = 0; Channel[eCh4].active = 0;
				LED_ON[0] = 1; LED_ON[1] = 0; LED_ON[2] = 0; LED_ON[3] = 0; break;	
		case 138: Channel[eCh1].active = 0;	Channel[eCh2].active = 1; Channel[eCh3].active = 0; Channel[eCh4].active = 0;
				LED_ON[0] = 0; LED_ON[1] = 1; LED_ON[2] = 0; LED_ON[3] = 0; break;	
		case 139: Channel[eCh1].active = 0;	Channel[eCh2].active = 0; Channel[eCh3].active = 1; Channel[eCh4].active = 0;
				LED_ON[0] = 0; LED_ON[1] = 0; LED_ON[2] = 1; LED_ON[3] = 0; break;	
		case 140: Channel[eCh1].active = 0;	Channel[eCh2].active = 0; Channel[eCh3].active = 0; Channel[eCh4].active = 1;
				LED_ON[0] = 0; LED_ON[1] = 0; LED_ON[2] = 0; LED_ON[3] = 1; break;	
	}

	UserIF::UpdateChannel(eCh1, Channel[eCh1].active);
	UserIF::UpdateChannel(eCh2, Channel[eCh2].active);
	UserIF::UpdateChannel(eCh3, Channel[eCh3].active);
	UserIF::UpdateChannel(eCh4, Channel[eCh4].active);
	SetupTrigger();

	Channel[eChM].active = 0; 					//switch off math function	
	LED_ON[4] = 0;

	Send_LED();

	Display::MenuPopupInit(29, MENU_FFT, 137);			// 29 FFT Source

	ConfigChanged = true;						//Save new values to flash

	Signal::FFT_buildScaleLookupTable();

	// Remove all Signals which where active before
	if(ChannelStatusOld[eCh1])RemovePlane |= 0x01;
	if(ChannelStatusOld[eCh2])RemovePlane |= 0x02;
	if(ChannelStatusOld[eCh3])RemovePlane |= 0x04;
	if(ChannelStatusOld[eCh4])RemovePlane |= 0x08;
	RemovePlane |= 0x1F;

	ClearPlanes();

	// force new output in statusbar
	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;

	Display::StatusUpdate();
	
	//if(!Run)SingleShot = 1;
	//Hardware::Start_Record();

}
//##########################################################################################################################################################
void Hardware::FFT_Restore_Channels(void)
{
	//printf("- FFT Restore Channels\r\n");

	//Hardware::Stop_Record();

	//restore channel setting
	Channel[eChM].active = ChannelStatusOld[eChM];
	Channel[eCh1].active = ChannelStatusOld[eCh1];
	Channel[eCh2].active = ChannelStatusOld[eCh2];
	if(NumberOfChannels == 4)
	{
		Channel[eCh3].active = ChannelStatusOld[eCh3];	
		Channel[eCh4].active = ChannelStatusOld[eCh4];
	}
	else
	{
		ChannelStatusOld[eCh3] = Channel[eCh3].active = 0;	
		ChannelStatusOld[eCh4] = Channel[eCh4].active = 0;
	}


	// set LED
	if (Channel[eCh1].active) LED_ON[0] = 1;
	else LED_ON[0] = 0;

	// set LED
	if (Channel[eCh2].active) LED_ON[1] = 1;
	else LED_ON[1] = 0;

	// set LED
	if (Channel[eCh3].active) LED_ON[2] = 1;
	else LED_ON[2] = 0;

	// set LED
	if (Channel[eCh4].active) LED_ON[3] = 1;
	else LED_ON[3] = 0;

	// set LED
	if (Channel[eChM].active) LED_ON[4] = 1;
	else LED_ON[4] = 0;

	Send_LED();

	// Remove Signals of inactive channels
	if(!Channel[eCh1].active)RemovePlane |= 0x01;
	if(!Channel[eCh2].active)RemovePlane |= 0x02;
	if(!Channel[eCh3].active)RemovePlane |= 0x04;
	if(!Channel[eCh4].active)RemovePlane |= 0x08;

	ClearPlanes();

/*
	//restore triggermode
	MenuStatus[MENU_TRIGGERMODE][0] = FFT_TriggerMode_bak;	
	Display::MenuPopupInit(9, MENU_TRIGGERMODE, 92);	//BF #007
	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;
	SetupTrigger();
*/

	UserIF::UpdateChannel(eCh1, Channel[eCh1].active);
	UserIF::UpdateChannel(eCh2, Channel[eCh2].active);
	UserIF::UpdateChannel(eCh3, Channel[eCh3].active);
	UserIF::UpdateChannel(eCh4, Channel[eCh4].active);
	SetupTrigger();


/*BF not needed, because it is done in RefreshScreen() 
	// force new output in statusbar
	VoltageChangedCh1 = 1;
	VoltageChangedCh2 = 1;
	VoltageChangedCh3 = 1;
	VoltageChangedCh4 = 1;
	
	Display::StatusUpdate();
*/



}
//##########################################################################################################################################################
void Hardware::Reset_To_Default(void)
{
	printf("- Reset to Default\r\n");

	//Hardware::Stop_Record();

	Hardware::Set_Vars_Default();

	Hardware::TRIG_AutoPretrigger();

   	Display::RecalcTimeParameters();
	
	Signal::BuildScaleLookupTable();	// has to be done before DAC setting (OnZero)
	Signal::FFT_buildScaleLookupTable();	// has to be done after building normal scale lookup
	
	Display::MenuInit();
	
	UserIF::UpdateChannel(eCh1, 1); 	
	UserIF::UpdateChannel(eCh2, 1);

	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	RotarySteps = 0;
	UserIF::ON_Zero_Channel_2();

	SetSwitches(eCh1, Selected_Voltage_CH1);
	SetSwitches(eCh2, Selected_Voltage_CH2);

	if (NumberOfChannels == 4)
	{

		UserIF::UpdateChannel(eCh3, 1);	
		UserIF::UpdateChannel(eCh4, 1);
	
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_3();
		RotarySteps = 0;
		UserIF::ON_Zero_Channel_4();

		SetSwitches(eCh3, Selected_Voltage_CH3);
		SetSwitches(eCh4, Selected_Voltage_CH4);

	}

	UserIF::UpdateChannel(eChM, Channel[eChM].active); 

	Send_LED();
	Display::CALCPRETRIGGER();
	SetupTrigger();
	
	Display::DrawInitialScreen();

	Display::DRAW_ALL_CURSOR();

	Hardware::Start_Record();

}
//##########################################################################################################################################################
void Hardware::Restore_From_Flash(void)
{
	uint32_t ch1_bak, ch2_bak, ch3_bak, ch4_bak;
	unsigned char fft_mode_bak = Signal::_FFT_Mode;

	printf("- Restore settings from flash\r");

	Set_Vars_Default();

	AMDFlash::ReadConfig();

	if (config_loaded == false)
	{ 
		Reset_To_Default(); 
		AMDFlash::WriteConfigBackup();
		return;
	}	// emergency exit

	// set grid colour
	if (ColorPalette>9) ColorPalette = 0;

	//prepare FFT-mode
	if(Signal::_FFT_Mode != FFT_OFF)
	{ Signal::FFT_buildTrigoTables(); Signal::FFT_buildScaleLookupTable();}

	Signal::BuildScaleLookupTable();	// has to be done before DAC setting (OnZero)
	Signal::FFT_buildScaleLookupTable();	// has to be done after building normal scale lookup
	
	Send_LED();	

	TriggerLevelChanged = 1;
	TriggerModeChanged = 1;	
	TriggerWayChanged = 1;
	TimebaseChanged = 1;

	MenuAktive = 1;

	Cursor_Data_First_Draw = 0;
	Quick_Measure_First_Draw = 0;

/*	if (MainTimebase < 11)			//set high speed flag before calculating time parameters
	ACQ_HighSpeed = 1;
	else
	ACQ_HighSpeed = 0;
	
	Display::RecalcTimeParameters();

	Display::CALCPRETRIGGER();
//BF add
	if (USTB_Mode == USTB_OFF)
	{
		S1Ptr = SIGNAL1;		// adjust signal pointer to 16k signal buffers
		S2Ptr = SIGNAL2;
		S3Ptr = SIGNAL3;
		S4Ptr = SIGNAL4;
		SMPtr = SIGNALM;
	}
	else					//prepare USTB-mode at start 
	{
		Signal::USTB_clearBuffer();	//clear all buffers and adjust pointer
		Reset_Timer2();
	}
//BF add
*/
	//backup channel status
	ch1_bak = Channel[eCh1].active;
	ch2_bak = Channel[eCh2].active;
	ch3_bak = Channel[eCh3].active;
	ch4_bak = Channel[eCh4].active;

	Signal::_FFT_Mode = FFT_OFF;								//FFT has to be switched off to process zero level handler

	//channels have to be active to activate new settings
	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	SetSwitches(eCh1, Selected_Voltage_CH1);

	UserIF::ON_Zero_Channel_2();
	SetSwitches(eCh2, Selected_Voltage_CH2);
	
	if (NumberOfChannels == 4)
	{
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

	      	UserIF::ON_Zero_Channel_3();
		SetSwitches(eCh3, Selected_Voltage_CH3);

		UserIF::ON_Zero_Channel_4();
		SetSwitches(eCh4, Selected_Voltage_CH4);
	}

//	SetupTrigger();										//set ADC depending registers

	//restore channel status
	Channel[eCh1].active = ch1_bak;
	Channel[eCh2].active = ch2_bak;
	Channel[eCh3].active = ch3_bak;
	Channel[eCh4].active = ch4_bak;

	Signal::_FFT_Mode = fft_mode_bak;							// restore FFT mode

	Display::MenuInit();		//BF #005

	if (MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+1) || MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+2))
	{ FilterType = PRO; }
	else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+2) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+6))
	{ FilterType = IIR; }
	else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+5) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+9))
	{ FilterType = FIR; }



//	Memory_Window_visible = 0; 

	Display::DrawInitialScreen();

//	Display::DRAW_ALL_CURSOR();

	Menu_Changed = 1;
	Menu_First_Draw = 1;
	
	
	UserIF::ON_Timebase();				// setup all time parameters 

	ResetTimer3(RegTimerRotDelay);			// close memory window after timeout if browse is off

	Display::SetPersistMode();			// initialize persistent timer etc.
	
	
	printf("- Restore settings from flash           - done\r\n");


}
//##########################################################################################################################################################
//BF new Startup initialization
void Hardware::Start_Up(void)
{
	uint32_t ch1_bak, ch2_bak, ch3_bak, ch4_bak;
	unsigned char fft_mode_bak = Signal::_FFT_Mode;
	unsigned long *trigotab_flash = (unsigned long) nasys_main_flash + TRIGOTAB01; // point to table address
	

	printf("- Starting up\r");

	
	//--------------------------------------------------------------
	// 	preset configuration if flash is not valid 
	//--------------------------------------------------------------
	if(FlashPreset != 0x57)
	{
		printf("\nStart up: Presetting Flash\r\n");

		//FlashPreset = (char)tc_dev_subversion;
		FlashPreset = 0x57;

		AMDFlash::ReadProtReg();

		QP_mode = 0;					//BF #006
		MenuStatus[MENU_QUICKPRINT][5] = 185;		//BF-Version of Screenshot
		MenuStatus[MENU_QP_USB][5]     = 185;		//BF-Version of Screenshot

		FFT_grid = 0;
		DrawMono = 0;
		ColorPalette = 0;

		CalSet = 0;
		MenuStatus[MENU_UTILITY][3] = 264;				// standard calibration set
	
	//      init extended utility menu
		MenuStatus[MENU_EXTUTILS][0] = 203;
		MenuStatus[MENU_EXTUTILS][1] = 203;
	
		if (NumberOfChannels == 4)
		{
			MenuStatus[MENU_EXTUTILS][2] = 203;
			MenuStatus[MENU_EXTUTILS][3] = 203;
		}
		else
		{
			MenuStatus[MENU_EXTUTILS][2] = INACTIVE;		// for 2 Channel version set inactive
			MenuStatus[MENU_EXTUTILS][3] = INACTIVE;		// for 2 Channel version set inactive
		}

		MenuStatus[MENU_TIMEBASE][0] = BTN_ON;				// Main
		MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;				// Delayed
		MenuStatus[MENU_TIMEBASE][2] = BTN_OFF;				// XY-Mode
		MenuStatus[MENU_TIMEBASE][3] = BTN_OFF;
		MenuStatus[MENU_TIMEBASE][4] = BTN_OFF;
		MenuStatus[MENU_USTB][0] = USTB_ROLL;                     	// Roll-Mode forward
		MenuStatus[MENU_USTB][1] = USTB_PERM;				// Permanent window shift
		MenuStatus[MENU_USTB][2] = USTB_16KB;				// Buffer size 16KB
		MenuStatus[MENU_DISPLAY][0]  = 360;				// Display - Persistent Off
		MenuStatus[MENU_DISPLAY][2]  = 136;				// Display - Grid - 100%
		MenuStatus[MENU_DISPLAY][4]  = DRAW_FAST;			// Display - Draw Mode
		MenuStatus[MENU_DISPLAY][3] = 320;				// no display -> all channels off
		for(int i=0;i<4;i++)NoDisplay[i] = 0;				// no display -> all channels off

		MenuStatus[MENU_DISPL_SETUP][0]  = 300;				// grid color
		MenuStatus[MENU_DISPL_SETUP][1]  = 248;				// grid layout
		MenuStatus[MENU_DISPL_SETUP][2]  = 330;				// status layout
		MenuStatus[MENU_DISPL_SETUP][3]  = 240;				// no QM-cursors
		DrawMono = 0;

		USTB_Mode = USTB_OFF;
		USTB_Dir  = USTB_FORWARD;
		USTB_Disp = USTB_PERM;

		// Acquire
		MenuStatus[MENU_ACQUIRE][0] = LOGA_OFF;				// Acquire - Logic Processor 	-> off
		MenuStatus[MENU_ACQUIRE][1] = AVRG_OFF;				// Acquire - Average		-> off
		MenuStatus[MENU_ACQUIRE][2] = FILT_OFF;				// Acquire - Noise Filter 	-> off
		MenuStatus[MENU_ACQUIRE][3] = 42;				// Acquire - Interpolation	-> Linear
		ACQ_Average = 0;
		Display::MenuPopupInit(21, MENU_ACQUIRE, AVRG_OFF); 
		Display::MenuPopupInit(22, MENU_ACQUIRE, FILT_OFF); 
		Display::MenuPopupInit(23, MENU_ACQUIRE, 42); 
		Display::MenuPopupInit(47, MENU_ACQUIRE, LOGA_OFF); 

		MenuStatus[MENU_TRIGGERMODE][0] = TRIG_AUTO;			//set new trigger auto mode

		MenuStatus[MENU_TRIGGERSUB][0] = 114;				// LED 1
		MenuStatus[MENU_TRIGGERSUB][1] = 119;				// LED 2
		MenuStatus[MENU_TRIGGERSUB][2] = BTN_OFF;			// map LED to Ch 3/4
		MenuStatus[MENU_TRIGGERSUB][3] = 124;				// Single Trigger setting
		MenuStatus[MENU_TRIGGERSUB][4] = 272;				// Pre Trigger setting -> Left Edge

		MenuStatus[MENU_TRIGGEREDGE][1] = 137;				//trigger source is channel 1
		MenuStatus[MENU_TRIGGEREDGE][2] = INACTIVE;			//ext. trigger popup is inactive
		MenuStatus[MENU_TRIGGEREDGE][3] = INACTIVE;			//TV trigger popup is inactive

		MenuStatus[MENU_AUTOSCALE][3] = 281;				// Autoscale setup TB search -> all channels

		MenuStatus[MENU_QUICKMEASURE][0] = 27;	
		MenuStatus[MENU_QUICKMEASURE][1] = 52;
		MenuStatus[MENU_QUICKMEASURE][2] = 52;

		Channel[eChM].active = 0;                       		// Math channel off
		// not used MenuStatus[MENU_MATH][1] = BTN_OFF;               		// 
		MenuStatus[MENU_MATH][2] = BTN_OFF;                		// math 1*2 off
		MenuStatus[MENU_MATH][3] = BTN_ON;                		// math 1-2 on
		MenuStatus[MENU_MATH][4] = BTN_OFF;                		// math 1+2 off

		MenuPopupStatus[8][0] = 3;	              			//BF popup for external trigger
		MenuPopupStatus[8][1] = 2;
		MenuPopupStatus[8][2] = 2;

		MenuPopupStatus[11][0] = 3;              			//BF popup for TV trigger
		MenuPopupStatus[11][1] = 2;

		Cursor_Vertical_Position_TY_1 = 100;	
		Cursor_Vertical_Position_TY_2 = 400;	
	
		Cursor_Vertical_Position_XY_1 = 100;
		Cursor_Vertical_Position_XY_2 = 300;
	
		Cursor_Vertical_Position_FFT_1 = 125;
		Cursor_Vertical_Position_FFT_2 = 475;

		SavePointer = 1;

	} //preset end
	

	
	// color palette limiter
	if (ColorPalette > 9) ColorPalette = 0;

	//prepare FFT-mode
	Signal::FFT_buildTrigoTables();

	// create FIR lookup table
	Signal::FIR_buildNoiseFilterLookupTable();
	Signal::FIR_buildSincLookupTable();

	Setup_Interrupts();								//enable all interupts

 	// get number of active channels for global use -> Math channel has to be handled seperately
	//Channels_Active = Channel[eCh1].active + Channel[eCh2].active + Channel[eCh3].active + Channel[eCh4].active;

	//backup channel status
	ch1_bak = Channel[eCh1].active;
	ch2_bak = Channel[eCh2].active;
	ch3_bak = Channel[eCh3].active;
	ch4_bak = Channel[eCh4].active;

	Signal::BuildScaleLookupTable();	// has to be done before DAC setting (OnZero)
	Signal::FFT_buildScaleLookupTable();	// has to be done after building normal scale lookup
	
	Signal::_FFT_Mode = FFT_OFF;						//FFT has to be switched off to process zero level handler

	//channels have to be active to activate new settings
	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	SetSwitches(eCh1, Selected_Voltage_CH1);

	UserIF::ON_Zero_Channel_2();
	SetSwitches(eCh2, Selected_Voltage_CH2);
	
	if (NumberOfChannels == 4)
	{
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

	      	UserIF::ON_Zero_Channel_3();
		SetSwitches(eCh3, Selected_Voltage_CH3);

		UserIF::ON_Zero_Channel_4();
		SetSwitches(eCh4, Selected_Voltage_CH4);
	}

	//restore channel status
	Channel[eCh1].active = ch1_bak;
	Channel[eCh2].active = ch2_bak;
	Channel[eCh3].active = ch3_bak;
	Channel[eCh4].active = ch4_bak;

	Signal::_FFT_Mode = fft_mode_bak;					// restore FFT mode

	AMDFlash::WriteConfigBackup();						// actualize backup config sector to latest configuration
	
	MenuStatus[MENU_DISPL_FFT][2] = MenuStatus[MENU_DISPLAY][2];
	Display::MenuInit();					//BF #005

	/* check for FFT tables in flash - this has to be done only one time */

	// checksum ok? Else write tables to flash.
	if (trigotab_flash[0] != TRIGO_CHECKSUM)
	{	
		AMDFlash::WriteTrigoTables();
		
		Signal::FFT_buildTrigoTables();		// prepare FFT-mode
	}
	
	Send_LED();	
	
	Menu_Changed = 1;

	Display::DrawInitialScreen();

	// set filter type
	if (MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+1) || MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+2))
	{ FilterType = PRO; }
	else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+2) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+6))
	{ FilterType = IIR; }
	else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+5) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+9))
	{ FilterType = FIR; }

	SingleShot = 0;
	Run = 1;						// always start in run mode

	//OpSys::InitExecQueue();	// not used at this time
	OpSys::InitQueue();		// initialize the simple queue

	UserIF::UpdateChannel(eCh1, Channel[eCh1].active);
	UserIF::UpdateChannel(eCh2, Channel[eCh2].active);
	if (NumberOfChannels == 4)
	{
		UserIF::UpdateChannel(eCh3, Channel[eCh3].active);
		UserIF::UpdateChannel(eCh4, Channel[eCh4].active);
	}

	RotarySteps = 0;
	UserIF::ON_Timebase();				// setup all time parameters 

	ResetTimer3(RegTimerRotDelay);			// close memory window after timeout if browse is off

	Display::SetPersistMode();			// initialize persistent timer etc.
	
	//printf("- Startup preparation                   - done\r\n");
	printf("- Starting up                           - done\r\n\n");


	printf("----------------------------------------------\r\n");
	printf("Version : %1i.%1i.BF.%1i.%1i%s\r\n", tc_version, tc_subversion, tc_dev_version, tc_dev_subversion, tc_compilation);
	printf("Hardware: %X.%c%c\r\n", tc_hw_version, tc_production_lot1, tc_production_lot2);
	printf("Serial  : %06d%02d%1X%1X\r\n", tc_serial, ((tc_shipment_date & 0x0000FF00) >> 8), ((tc_shipment_date & 0x000000F0) >> 4), (tc_shipment_date & 0x0000000F));	
	if (tc_hw_modif == 656 || tc_hw_modif == 653)									// LB-Mod (OPA656) or OPA653 Mod
	printf("Model   : W%04dA / OPA%03d Mod / %d Channels \r\n", tc_model, tc_hw_modif, NumberOfChannels);
	else if (tc_hw_modif == 6518)											// addon PCB with LMH6518
	printf("Model   : W%04dA / LMH%03d Mod / %d Channels \r\n", tc_model, tc_hw_modif, NumberOfChannels);	
	else	
	printf("Model   : W%04dA / %d Channels \r\n", tc_model, NumberOfChannels);					// normal factory version
	printf("----------------------------------------------\r\n\n");


	// check if logic processor has to be started
	LA_active = 0;

	if (MenuStatus[MENU_ACQUIRE][0] != LOGA_OFF)
	{
		// restore voltage ranges
		Selected_Voltage_CH1 = Selected_Voltage_CH1_bak;
		Selected_Voltage_CH2 = Selected_Voltage_CH2_bak;
		Selected_Voltage_CH3 = Selected_Voltage_CH3_bak;
		Selected_Voltage_CH4 = Selected_Voltage_CH4_bak;

		// restore trigger settings
		Trigger_Pos_CH1 = Trigger_Pos_CH1_bak;
		Trigger_Pos_CH2 = Trigger_Pos_CH2_bak;
		Trigger_Pos_CH3 = Trigger_Pos_CH3_bak;
		Trigger_Pos_CH4 = Trigger_Pos_CH4_bak;

		Signal::LOGA_LogicProcessor();
	}




//Hardware::Reset_To_Default();

}
//##########################################################################################################################################################
//BF test the LED for function
void Hardware::LED_FunctionTest(char tmode)
{
	unsigned char x;

	int led_bak[16];

	//printf("Testing LEDs\r");


	switch (tmode)
	{
		case 0: // quick test
		{
			for(x=0;x<16;x++)	//switch all LEDs on 	
			{ LED_ON[x] = 1; }
		
			Send_LED();
			break;
		}

		case 1: // extended LED test
		{
			for(x=0;x<16;x++)	//backup LED status and switch all LEDs off 	
			{ led_bak[x] = LED_ON[x]; LED_ON[x] = 0; }
		
			Send_LED();
			nr_delay(50);		//wait until shift registers are ready
		
			for(char i=0;i<4;i++)
			{
				for(x=0;x<16;x++)	//switch all LEDs on 	
				{ LED_ON[x] = 1; }
			
				Send_LED();
				nr_delay(500);		//let the LED shine a moment
			
			
				for(x=0;x<16;x++)	//switch all LEDs off	
				{ LED_ON[x] = 0; }
			
				Send_LED();
				nr_delay(500);		//wait a little moment
			}
		
			for(char i=0;i<4;i++)
			{
				LED_ON[12] = 1;		//Run/Stop green
				LED_ON[13] = 0;	
				LED_ON[14] = 1;		//Single red
				LED_ON[15] = 0;
				Send_LED();
				nr_delay(500);		//let the LED shine a moment
	
				LED_ON[12] = 0;	
				LED_ON[13] = 1;		//Run/Stop red
				LED_ON[14] = 0;		
				LED_ON[15] = 1;		//Single green
				Send_LED();
				nr_delay(500);		//let the LED shine a moment
			}


			for(x=0;x<16;x++)	// restore LED status
			{ LED_ON[x] = led_bak[x]; }
		
			Send_LED();
			nr_delay(50);		//wait until shift registers are ready

			break;
		}
	}

	//printf("Testing LEDs				- done\r\n");

}
//##########################################################################################################################################################
// TODO Channeldaten auf Struct umstellen
void Hardware::CenterTrace(uint8_t channel)
{
	RotarySteps = 0;

	if (Signal::_FFT_Mode != FFT_OFF) return;

	if(XY_Mode)
	{
		//set zerolevels to the middle of the grid
		switch(channel)
		{
			case eCh1:
			{
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelXYCH1;		//keep triggerlevel
				ZeroLevelCH1 = GRID_HEIGHT / 2;
				ZeroLevelCH1_Old = ZeroLevelCH1;
				Virtual_ZeroLevelXYCH1 = 0;
				UserIF::ON_Zero_Channel_1();
				break;
			}
	
			case eCh2:
			{
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelXYCH2;		//keep triggerlevel
				ZeroLevelCH2 = GRID_HEIGHT / 2;
				ZeroLevelCH2_Old = ZeroLevelCH2;
				Virtual_ZeroLevelXYCH2 = 0;
				UserIF::ON_Zero_Channel_2();
				break;
			}
	
			case eCh3:
			{
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelXYCH3;		//keep triggerlevel
				ZeroLevelCH3 = GRID_HEIGHT / 2;
				ZeroLevelCH3_Old = ZeroLevelCH3;
				Virtual_ZeroLevelXYCH3 = 0;
				UserIF::ON_Zero_Channel_3();
				break;
			}
	
			case eCh4:
			{
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelXYCH4;		//keep triggerlevel
				ZeroLevelCH4 = GRID_HEIGHT / 2;
				ZeroLevelCH4_Old = ZeroLevelCH4;
				Virtual_ZeroLevelXYCH4 = 0;
				UserIF::ON_Zero_Channel_4();
				break;
			}
		}

	}
	else
	{
		//set zerolevels to the middle of the grid
		switch(channel)
		{
			case eCh1:
			{
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelCH1;		//keep triggerlevel
				ZeroLevelCH1 = GRID_HEIGHT / 2;
				ZeroLevelCH1_Old = ZeroLevelCH1;
				Virtual_ZeroLevelCH1 = 0;
				UserIF::ON_Zero_Channel_1();
				break;
			}
	
			case eCh2:
			{
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelCH2;		//keep triggerlevel
				ZeroLevelCH2 = GRID_HEIGHT / 2;
				ZeroLevelCH2_Old = ZeroLevelCH2;
				Virtual_ZeroLevelCH2 = 0;
				UserIF::ON_Zero_Channel_2();
				break;
			}
	
			case eCh3:
			{
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelCH3;		//keep triggerlevel
				ZeroLevelCH3 = GRID_HEIGHT / 2;
				ZeroLevelCH3_Old = ZeroLevelCH3;
				Virtual_ZeroLevelCH3 = 0;
				UserIF::ON_Zero_Channel_3();
				break;
			}
	
			case eCh4:
			{
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelCH4;		//keep triggerlevel
				ZeroLevelCH4 = GRID_HEIGHT / 2;
				ZeroLevelCH4_Old = ZeroLevelCH4;
				Virtual_ZeroLevelCH4 = 0;
				UserIF::ON_Zero_Channel_4();
				break;
			}
		}
	}
	//Hardware::SetupTrigger();

}
//##########################################################################################################################################################
// not used actually
int GetDC_Offset(int8_t channel)
{
	uint8_t buf_byte = 0, adc_min = 255 , adc_max = 0;
	uint8_t avrg = 0;
	uint8_t adc_zero = 0;

	int32_t offset = 0, diff;
	uint32_t range = 0;

	
	switch(channel)
	{
		case eCh1: adc_zero = Hardware::_ADC_VirtualZero[channel]; range = Selected_Voltage_CH1; break;
		case eCh2: adc_zero = Hardware::_ADC_VirtualZero[channel]; range = Selected_Voltage_CH2;break;
		case eCh3: adc_zero = Hardware::_ADC_VirtualZero[channel]; range = Selected_Voltage_CH3;break;
		case eCh4: adc_zero = Hardware::_ADC_VirtualZero[channel]; range = Selected_Voltage_CH4;break;
	}

	for (uint32_t ix=150; ix < 3800; ix++)
	{
		buf_byte = Signal[channel][ix];
		if (adc_min > buf_byte) adc_min = buf_byte;
		if (adc_max < buf_byte) adc_max = buf_byte;
	}

	// calculate average
	avrg = (unsigned char) (((int) adc_min + (int) adc_max) >> 1);

	diff = avrg - adc_zero;

	// calculate offset
	if (avrg < adc_zero-15 || avrg > adc_zero+15)
	{
		offset = (int)((float)(diff) * ScaleFactor[range]);
		//offset = (int)ScaleLookupTable[diff][ScaleIndexTable[range]];	// <- try this! maybe ADC_Zero must be considered
	}

	//printf("\r\nChannel %d ADCzero %d AVRG %d ADCmin %d ADCmax %d ->Offset %d", channel, lADC_Zero, avrg, adc_min, adc_max, offset);

	//if (offset == 0)printf("   -> no Offset", channel);

	//printf("\r\n");

/*
	// calculate offset
	if (avrg > lADC_Zero-5 &&  avrg < lADC_Zero+5)
	{ return 0; }						// no DC offset
	else if(adc_max > lADC_Zero-5)
	{ offset = -50; }					// shift zero level down
	else if(adc_min < lADC_Zero+5)
	{ offset = 50; }					// shift zero level up

	if(Channels_Active == 1)
	{ offset *= 3;}
	else if(Channels_Active == 2)
	{ offset = offset<<1;}
*/



	return offset;

}

//##########################################################################################################################################################
void Hardware::DispatchTraces(void)
{

	int  lTopPos = 0, lBotPos = 0;
	int lVZL1_Old,lVZL2_Old,lVZL3_Old,lVZL4_Old;

	int lDC_Offset1=0, lDC_Offset2=0, lDC_Offset3=0, lDC_Offset4=0;

	if (Signal::_FFT_Mode != FFT_OFF) return;
	if (XY_Mode) return;


	ZeroLevelCH1_Old = ZeroLevelCH1;
	ZeroLevelCH2_Old = ZeroLevelCH2;
	ZeroLevelCH3_Old = ZeroLevelCH3;
	ZeroLevelCH4_Old = ZeroLevelCH4;

	lVZL1_Old = Virtual_ZeroLevelCH1;
	lVZL2_Old = Virtual_ZeroLevelCH2;
	lVZL3_Old = Virtual_ZeroLevelCH3;
	lVZL4_Old = Virtual_ZeroLevelCH4;

	if (Channel[eChM].active || (Channels_Active > 2))
	{
		//lTopPos = (int)(GRID_HEIGHT / 5.333);			//10% line
		lTopPos = (int)(GRID_HEIGHT / 8);			// first div line
		lBotPos = (int)((GRID_HEIGHT / 8) * 7);			// last div line
		//lBotPos = (int)(GRID_HEIGHT - (GRID_HEIGHT / 5.333));	//90% line
	}
	else
	{
		lTopPos = (int)(GRID_HEIGHT / 4);		// 1/4 grid height
		lBotPos = (int)((GRID_HEIGHT / 4) * 3);		// 3/4 grid height
	}
/*
	// check for DC offset like digital signals
	if (Channel[eCh1].active) lDC_Offset1 = GetDC_Offset(eCh1);
	if (Channel[eCh2].active) lDC_Offset2 = GetDC_Offset(eCh2);
	if (Channel[eCh3].active) lDC_Offset3 = GetDC_Offset(eCh3);
	if (Channel[eCh4].active) lDC_Offset4 = GetDC_Offset(eCh4);
*/
	switch(Channels_Active)
	{
		case 1:	// center trace with DC offset
		{
			if (Channel[eCh1].active)
			{
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelCH1 - lDC_Offset1;		//keep triggerlevel
				ZeroLevelCH1 = GRID_HEIGHT / 2;
				ZeroLevelCH1_Old = ZeroLevelCH1;
				Virtual_ZeroLevelCH1 = -lDC_Offset1;
				UserIF::ON_Zero_Channel_1();
			}

			if (Channel[eCh2].active)
			{
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelCH2 - lDC_Offset2;		//keep triggerlevel
				ZeroLevelCH2 = GRID_HEIGHT / 2;
				ZeroLevelCH2_Old = ZeroLevelCH2;
				Virtual_ZeroLevelCH2 = -lDC_Offset2;
				UserIF::ON_Zero_Channel_2();
			}

			if (Channel[eCh3].active)
			{
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelCH3 - lDC_Offset3;		//keep triggerlevel
				ZeroLevelCH3 = GRID_HEIGHT / 2;
				ZeroLevelCH3_Old = ZeroLevelCH3;
				Virtual_ZeroLevelCH3 = -lDC_Offset3;
				UserIF::ON_Zero_Channel_3();
			}

			if (Channel[eCh4].active)
			{
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelCH4 - lDC_Offset4;		//keep triggerlevel
				ZeroLevelCH4 = GRID_HEIGHT / 2;
				ZeroLevelCH4_Old = ZeroLevelCH4;
				Virtual_ZeroLevelCH4 = -lDC_Offset4;
				UserIF::ON_Zero_Channel_4();
			}


			return;
		}

		case 2:
		{
			if (Channel[eCh1].active && Channel[eCh2].active)
			{
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH2 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
			}
			else if (Channel[eCh1].active && Channel[eCh3].active)
			{	
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH3 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
			}
			else if (Channel[eCh1].active && Channel[eCh4].active)
			{	
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}
			else if (Channel[eCh2].active && Channel[eCh3].active)
			{	
				ZeroLevelCH2 = lTopPos;
				ZeroLevelCH3 = lBotPos;
				
				Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
			}
			else if (Channel[eCh2].active && Channel[eCh4].active)
			{	
				ZeroLevelCH2 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}
			else if (Channel[eCh3].active && Channel[eCh4].active)
			{	
				ZeroLevelCH3 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}


			break;
		}

		case 3:
		{
		
			if (Channel[eChM].active)
			{
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH2 = (int)((GRID_HEIGHT / 8) * 3);			//third div
				ZeroLevelCH3 = (int)((GRID_HEIGHT / 8) * 5);			//fifth div
				ZeroLevelCH4 = lBotPos;
	
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//means that VZero = 0 is the middle of the grid
				Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;	
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;
	
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}	
			else if (!Channel[eCh1].active)
			{
				ZeroLevelCH2 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;	//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel

				UserIF::ON_Zero_Channel_2();
				UserIF::ON_Zero_Channel_4();

 				CenterTrace(eCh3);
				return;
			}
			else if (!Channel[eCh2].active)
			{
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;		//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;		//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel

				UserIF::ON_Zero_Channel_1();
				UserIF::ON_Zero_Channel_4();

 				CenterTrace(eCh3);
				return;
			}
			else if (!Channel[eCh3].active)
			{
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH4 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2);		//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2);		//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1 - lDC_Offset1;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4 - lDC_Offset4;	//keep triggerlevel

				UserIF::ON_Zero_Channel_1();
				UserIF::ON_Zero_Channel_4();

 				CenterTrace(eCh2);
				return;
			}
			else if (!Channel[eCh4].active)
			{
				ZeroLevelCH1 = lTopPos;
				ZeroLevelCH3 = lBotPos;
				
				Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;		//Virtual zeroes are related to 1/2 grid height,
				Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;		//means that VZero = 0 is the middle of the grid

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel

				UserIF::ON_Zero_Channel_1();
				UserIF::ON_Zero_Channel_3();

				CenterTrace(eCh2);
				return;
			}
			
			break;

		}

		case 4:
		{
			ZeroLevelCH1 = lTopPos;
			ZeroLevelCH2 = (int)((GRID_HEIGHT / 8) * 3);			//third div
			ZeroLevelCH3 = (int)((GRID_HEIGHT / 8) * 5);			//fifth div
			ZeroLevelCH4 = lBotPos;

			Virtual_ZeroLevelCH1 = ZeroLevelCH1 - (GRID_HEIGHT / 2) - lDC_Offset1;	//Virtual zeroes are related to 1/2 grid height,
			Virtual_ZeroLevelCH2 = ZeroLevelCH2 - (GRID_HEIGHT / 2) - lDC_Offset2;	//means that VZero = 0 is the middle of the grid
			Virtual_ZeroLevelCH3 = ZeroLevelCH3 - (GRID_HEIGHT / 2) - lDC_Offset3;	
			Virtual_ZeroLevelCH4 = ZeroLevelCH4 - (GRID_HEIGHT / 2) - lDC_Offset4;

			Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL1_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
			Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL2_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
			Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL3_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
			Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL4_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel

			break;

		}



	}

	if (Channel[eCh1].active) UserIF::ON_Zero_Channel_1();
	if (Channel[eCh2].active) UserIF::ON_Zero_Channel_2();
	if (Channel[eCh3].active) UserIF::ON_Zero_Channel_3();
	if (Channel[eCh4].active) UserIF::ON_Zero_Channel_4();

	//Hardware::SetupTrigger();




}
//##########################################################################################################################################################
//BF 
void Hardware::TRIG_AutoLevel(void)
{
	int lScaleIndex = 0;

	unsigned char lMaxValue = 0, lMinValue = 255;
	int lMeanValue =  ADC_ZERO;
	int lSignalEnd;


	if (MainTimebase < 11) lSignalEnd = 16000;	//16K
	else lSignalEnd = 4000;				// 4K


/*
	
	Start_Record();

	//wait for ADC
	for(int timeout = 0;(timeout < 100) && !ADC_DataAvailable;timeout++)
	nr_delay(10);

	//if no new data is available send error message
	if (ADC_DataAvailable == 0)
	{ printf("\r\nTimeout Error, no new Data available\r\n");  }

	//reset availability flag	
	ADC_DataAvailable = 0;
*/

	// which channel is trigger source?
	switch(_TriggerSource)
	{
		case eTrigCh1:
		{

			//read signal and calculate 50% trigger level
			//ReadOut_Signal(1);


			//find maxima and minima
			for (int i = 100; i<lSignalEnd ;i++)
			{
				if (SIGNAL1[i] > lMaxValue) lMaxValue = SIGNAL1[i];
				if (SIGNAL1[i] < lMinValue) lMinValue = SIGNAL1[i];
			}

			//calculate 50%
			lMeanValue = (int)(lMaxValue + lMinValue) >> 1;

			//printf("Mean %d = (Max %d + Min %d)/2\r\n",lMeanValue,lMaxValue,lMinValue);

			lScaleIndex = ScaleIndexTable[Selected_Voltage_CH1];

			if (MenuStatus[MENU_CHANNEL1][2] == BTN_ON)	//Inverted Signal	BF
			{ Trigger_Pos_CH1 = (GRID_HEIGHT / 2) + Virtual_ZeroLevelCH1 + (Virtual_ZeroLevelCH1 - ScaleLookupTable[lMeanValue][lScaleIndex]); }
			else
			{ Trigger_Pos_CH1 = (GRID_HEIGHT / 2) + ScaleLookupTable[lMeanValue][lScaleIndex]; }

			if (Trigger_Pos_CH1 > GRID_HEIGHT){ Trigger_Pos_CH1 = GRID_HEIGHT; }
			if (Trigger_Pos_CH1 < 0){ Trigger_Pos_CH1 = 0; }
			break;
		}

		case eTrigCh2:
		{
			//find maxima and minima
			for (int i = 100; i<lSignalEnd ;i++)
			{
				if (SIGNAL2[i] > lMaxValue) lMaxValue = SIGNAL2[i];
				if (SIGNAL2[i] < lMinValue) lMinValue = SIGNAL2[i];
			}

			//calculate 50%
			lMeanValue = (int)(lMaxValue + lMinValue) >> 1;

			lScaleIndex = ScaleIndexTable[Selected_Voltage_CH2];

			if (MenuStatus[MENU_CHANNEL2][2] == BTN_ON)	//Inverted Signal	BF
			{ Trigger_Pos_CH2 = (GRID_HEIGHT / 2) + Virtual_ZeroLevelCH2 + (Virtual_ZeroLevelCH2 - ScaleLookupTable[lMeanValue][lScaleIndex]); }
			else
			{ Trigger_Pos_CH2 = (GRID_HEIGHT / 2) + ScaleLookupTable[lMeanValue][lScaleIndex]; }

			if (Trigger_Pos_CH2 > GRID_HEIGHT){ Trigger_Pos_CH2 = GRID_HEIGHT; } 
			if (Trigger_Pos_CH2 < 0){ Trigger_Pos_CH2 = 0; }

			break;
		}

		case eTrigCh3:
		{
			//find maxima and minima
			for (int i = 100; i<lSignalEnd ;i++)
			{
				if (SIGNAL3[i] > lMaxValue) lMaxValue = SIGNAL3[i];
				if (SIGNAL3[i] < lMinValue) lMinValue = SIGNAL3[i];
			}

			//calculate 50%
			lMeanValue = (int)(lMaxValue + lMinValue) >> 1;

			lScaleIndex = ScaleIndexTable[Selected_Voltage_CH3];

			if (MenuStatus[MENU_CHANNEL3][2] == BTN_ON)	//Inverted Signal	BF
			{ Trigger_Pos_CH3 = (GRID_HEIGHT / 2) + Virtual_ZeroLevelCH3 + (Virtual_ZeroLevelCH3 - ScaleLookupTable[lMeanValue][lScaleIndex]); }
			else
			{ Trigger_Pos_CH3 = (GRID_HEIGHT / 2) + ScaleLookupTable[lMeanValue][lScaleIndex]; }

			if (Trigger_Pos_CH3 > GRID_HEIGHT){ Trigger_Pos_CH3 = GRID_HEIGHT; }  
			if (Trigger_Pos_CH3 < 0){ Trigger_Pos_CH3 = 0; }

			break;
		}

		case eTrigCh4:
		{
			//find maxima and minima
			for (int i = 100; i<lSignalEnd ;i++)
			{
				if (SIGNAL4[i] > lMaxValue) lMaxValue = SIGNAL4[i];
				if (SIGNAL4[i] < lMinValue) lMinValue = SIGNAL4[i];
			}

			//calculate 50%
			lMeanValue = (int)(lMaxValue + lMinValue) >> 1;

			lScaleIndex = ScaleIndexTable[Selected_Voltage_CH4];

			if (MenuStatus[MENU_CHANNEL4][2] == BTN_ON)	//Inverted Signal	BF
			{ Trigger_Pos_CH4 = (GRID_HEIGHT / 2) + Virtual_ZeroLevelCH4 + (Virtual_ZeroLevelCH4 - ScaleLookupTable[lMeanValue][lScaleIndex]); }
			else
			{ Trigger_Pos_CH4 = (GRID_HEIGHT / 2) + ScaleLookupTable[lMeanValue][lScaleIndex]; }

			if (Trigger_Pos_CH4 > GRID_HEIGHT){ Trigger_Pos_CH4 = GRID_HEIGHT; }  
			if (Trigger_Pos_CH4 < 0){ Trigger_Pos_CH4 = 0; }

			break;
		}

		case eTrigExt:	{ return; }	// external

		case eTrigTV:	{ return; }	// TV

	}

	SetupTrigger();

	Display::DRAWSTATUS(6, 1);			// Draw Trigger Level
	VS_TrigLevelChanged = (char)(_TriggerSource + 1);
	
	Hardware::ResetTimer3(RegTimerRotDelay);
	TriggerLevelActive = 1;

//	Start_Record();


}
//##########################################################################################################################################################
void Hardware::TRIG_AutoPretrigger(void)
{

	if (MenuStatus[MENU_TRIGGERSUB][4] == 272)
	{
		MemWinStart  = MemStartOffs;				// memory window to start of memory
		Trig_Pos_Mem = MemWinStart;				// trigger to the left edge
	}
	else if (MenuStatus[MENU_TRIGGERSUB][4] == 273)
	{
		MemWinStart  = MemStartOffs;				// memory window to start of memory
		Trig_Pos_Mem = MemWinStart + (int)(50 * ZoomFactor);	// trigger to the first div
	}
	else if (MenuStatus[MENU_TRIGGERSUB][4] == 274)
	{
		MemWinStart  = MemStartOffs;				// memory window to start of memory
		Trig_Pos_Mem = MemWinStart + (SignalMemSize/2);		// center trigger
	}
	else if (MenuStatus[MENU_TRIGGERSUB][4] == 275)
	{
		MemWinStart = (MemoryEnd>>1) - (SignalMemSize>>1);	// center memory window
		Trig_Pos_Mem = MemWinStart + (SignalMemSize>>1);	// center trigger
	}
	else if (MenuStatus[MENU_TRIGGERSUB][4] == 276)
	{	MemWinStart = Trig_Pos_Mem - (SignalMemSize>>1); }	// keep time value and center the memory window

	// right edge limiter
	if ((MemWinStart + SignalMemSize) > MemoryEnd) { MemWinStart = MemoryEnd - SignalMemSize; }

	// left edge limiter
        if (MemWinStart < MemStartOffs) { MemWinStart  = MemStartOffs; }

	// right edge limiter
        if (Trig_Pos_Mem > TrigPosMax) { Trig_Pos_Mem = TrigPosMax; }


	// left edge limiter
        if (Trig_Pos_Mem < MemStartOffs) { Trig_Pos_Mem = MemStartOffs; }


	Display::CalcPreTriggerPos();
	Display::CALCPRETRIGGER();
	
	//Hardware::SetReadoutLength();

	CaptureSetupADC();		// write shadow registers to hardware
}

//##########################################################################################################################################################
/**********************************************************************************************************************************************************/
				/* new capture trigger API from OSOZ */


/* 
Hardware interface for capture+trigger setup:
After setting na_data_adr->np_piodata, 8 registers (32bit words) get written to the FPGA.
This register set seems organized as follows:

Word0  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
             AS          M4 M3 M2 M1 T4 T3       C4 C3 C2 C1       HO EN SM BG IN ZL MA AM ?? ??    RI IN SL
              ^---------------_regADC[FPGAx].adc_ctrl----------------^   ^-----------------ctrl_reg------------------^
/auto slope  AS
master bits              M4 M3 M2 M1
trigger disable                      T4 T3 ?? ??
trigger source                                   C4 C3 C2 C1
holdoff                                                            HO
pulse width?                                                          EN SM BG IN
  (enable, smaller, bigger, in range)
zero line adjust?                                                                 ZL
master? free run? zero line search?                                                  MA
auto /normal                                                                            AM
rise /fall                                                                                          RI
intern /extern                                                                                         IN
select 0 /1                                                                                               SL

default:
	_regADC[eFPGA1].adc_ctrl = 0x01C0;
	ctrl_reg = 0x00A3;
             0  0  0  0  0  0  0  1  1  1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1  0  1  0  0  0  1  1
             AS          M4 M3 M2 M1 T4 T3       C4 C3 C2 C1       HO EN SM BG IN ZL MA AM ?? ??    RI IN SL


       
Word1  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
              ^---------------------------------------timebase_reg----------------------------------------^
1's complement of subsampling value


Word2  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
              0  1  0  1  1  1  1  1  0  0  0  0  1  0  1  0  ^--------------pre-trigger value------------^
              ^-------------channel_Adr_add12--------------^  ^------------------pre_reg------------------^
filter magic                    0x5F0A
magic channel_Adr_add12: 0x5F0A
magic channel_Adr_add34: 0xAF5F


Word3  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
              ^----------------pulse range----------------^   ^--Ch2 trig. level--^   ^--Ch1 trig. level--^
              ^--------------trig_range_reg---------------^   ^--trg_val_CHII_reg-^   ^--trg_val_CHI_reg--^


Word4  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
              ^-------------------------------------~trig_holdoff_reg-------------------------------------^
holdoff value ^-------------------------------------------------------------------------------------------^


Word5  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
             B1 B0 G1 G0 R1 R0        ^------unused-------^   ^----------------pulse width----------------^
              ^GridColor_Val^                                 ^--------------trig_width_reg---------------^


Word6  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
                               ?? ??
              ^-------------------------------------adc_change12_reg--------------------------------------^
magic adc_change12_reg: 0x2020F00
magic adc_change34_reg: 0x202C00A


Word7  Bit# |31 30 29 28 27 26 25 24|23 22 21 20 19 18 17 16|15 14 13 12 11 10 09 08|07 06 05 04 03 02 01 00|
              ^---------------------------------------   dummy     ---------------------------------------^
dummy: 0
*/
				
				
				
// write shadow register set to serial spi registers, use loop roll out to make it better readable				
void Hardware::CaptureSetupADC(void)
{	
	_regADC[eFPGA1].timebase = RegTimebaseTable[MainTimebase];				// set timebase shadow register with value from timebase table
	
	// first FPGA
	mode->np_piodata = 0x01;
		
	WriteADC(eCh1, _regADC[eFPGA1].regword[0]);					// 1. 32 bit -> ctrl_reg + adc_ctrl

	WriteADC(eCh1, _regADC[eFPGA1].regword[1]);					// 2. 32 bit -> timebase register

	WriteADC(eCh1, _regADC[eFPGA1].regword[2]);					// 3. 32 bit -> pretrigger + channel_Adr_add12
    	
	WriteADC(eCh1, _regADC[eFPGA1].regword[3]); 					// 4. 32 bit -> trigger value channel 1 + channel 2 + trigger range

	WriteADC(eCh1, _regADC[eFPGA1].regword[4]);					// 5. 32 bit -> trigger holdoff

	WriteADC(eCh1, _regADC[eFPGA1].regword[5]);					// 6. 32 bit -> trigger width + GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
	WriteADC(eCh1, _regADC[eFPGA1].regword[6]);					// 7. 32 bit -> adc_change12_reg 
	
	WriteADC(eCh1, _regADC[eFPGA1].regword[7]);					// 8. 32 bit -> unused dummy register

	mode->np_piodata = 0x00;

	//nr_delay(20);

	if (NumberOfChannels == 4)							// second FPGA
	{
		_regADC[eFPGA2].timebase = _regADC[eFPGA1].timebase;			// set timebase shadow register with value from timebase table
		
		mode->np_piodata = 0x01;
		
		WriteADC(eCh3,_regADC[eFPGA2].regword[0]);				// 1. 32 bit -> ctrl_reg + adc_ctrl
			
		WriteADC(eCh3, _regADC[eFPGA2].regword[1]);				// 2. 32 bit -> timebase register
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[2]);				// 3. 32 bit -> pretrigger + channel_Adr_add34

		WriteADC(eCh3, _regADC[eFPGA2].regword[3]); 				// 4. 32 bit -> trigger value channel 3 + channel 4 + trigger range	
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[4]);				// 5. 32 bit -> trigger holdoff
	
		WriteADC(eCh3, _regADC[eFPGA2].regword[5]);				// 6. 32 bit -> trigger width + GridColorArray[4]
	
		WriteADC(eCh3, _regADC[eFPGA2].regword[6]);				// 7. 32 bit -> adc_change34_reg 
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[7]);				// 8. 32 bit -> unused dummy register
	
		mode->np_piodata = 0x00;
    	}			
				
}				

// write to SPI shift register
static inline volatile void ShiftWrite(unsigned int shiftreg)
{
	if (Hardware::_regExtTrgSetup != shiftreg)
	{
		//regvalue &= 0x0FFFFFFF; 			// clear address bits
		shiftreg |= 0x20000000;				// set address bits to external trigger
	
		Hardware::_regExtTrgSetup = shiftreg;		// copy value to register shadow
		
		serdata->np_piodata = shiftreg;			// write value to hardware
		serstartsw->np_piodata = 1;
		serstartsw->np_piodata = 0;	
	}
}	
				
// set the type of trigger event (edge, pulse)
void Hardware::CaptureTrigSetType(trigType_t ttype)
{
	switch (ttype)
	{
		case eTrigEdge:					// edge triggering (falling, rising)
		{
			_regADC[eFPGA1].ctrl &= 0xE0FF;			// disable pulsewidth, reset pulse selection bits and ZL bit FPGA 1
			_regADC[eFPGA2].ctrl &= 0xE0FF;			// disable pulsewidth, reset pulse selection bits and ZL bit FPGA 2
			break;
		}
		
		case eTrigPulse:				// pulse width triggering
		{
			//_regADC[eFPGA1].ctrl |= 0x1000;			// enable pulsewidth FPGA 1
			//_regADC[eFPGA2].ctrl |= 0x1000;			// enable pulsewidth FPGA 2

			_regADC[eFPGA1].ctrl |= 0x1002;			// enable pulsewidth FPGA 1 + internal Trigger! JK
			_regADC[eFPGA2].ctrl |= 0x1002;			// enable pulsewidth FPGA 2
			break;
		}
	}
	
	//CaptureSetupADC();					// write shadow to hardware
	
}


// set the source for signal trigger events (channel 1 - 4, extern, line, TV)
void Hardware::CaptureTrigSetSource(trigSrc_t tsrc)
{
	_regADC[eFPGA1].ctrl &= 0xFFFE;					// delete select bit
	_regADC[eFPGA2].ctrl &= 0xFFFE;					// delete select bit

	_regADC[eFPGA1].adc_ctrl &= 0xF0F0;				// reset source channels and masterbits FPGA 1
	_regADC[eFPGA2].adc_ctrl &= 0xF0F0;				// reset source channels and masterbits FPGA 2
	
	switch (tsrc)
	{
		case eTrigCh1:					// set channel 1 as source
		{
			_regADC[eFPGA1].ctrl |= 0x0003;			// internal source + SL bit FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0002;			// internal source FPGA 2	
			_regADC[eFPGA1].adc_ctrl |= 0x0101;		// set source channel 1 FPGA 1
			_regADC[eFPGA2].adc_ctrl |= 0x0101;		// set source channel 1 FPGA 2
			break;
		}
		
		case eTrigCh2:					// set channel 2 as source
		{
			_regADC[eFPGA1].ctrl |= 0x0003;			// internal source + SL bit FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0002;			// internal source FPGA 2	
			_regADC[eFPGA1].adc_ctrl |= 0x0102;		// set source channel 2 FPGA 1
			_regADC[eFPGA2].adc_ctrl |= 0x0102;		// set source channel 2 FPGA 2
			break;
		}
		
		case eTrigCh3:					// set channel 3 as source
		{
			_regADC[eFPGA1].ctrl |= 0x0002;			// internal source FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0003;			// internal source + SL bit FPGA 2	
			_regADC[eFPGA1].adc_ctrl |= 0x0104;		// set source channel 3 FPGA 1
			_regADC[eFPGA2].adc_ctrl |= 0x0104;		// set source channel 3 FPGA 2
			break;
		}
		
		case eTrigCh4:					// set channel 4 as source
		{
			_regADC[eFPGA1].ctrl |= 0x0002;			// internal source FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0003;			// internal source + SL bit FPGA 2
			_regADC[eFPGA1].adc_ctrl |= 0x0108;		// set source channel 4 FPGA 1
			_regADC[eFPGA2].adc_ctrl |= 0x0108;		// set source channel 4 FPGA 2
			break;
		}
		
		case eTrigExt:					// set external trigger jack as source
		{
			_regADC[eFPGA1].ctrl &= 0xFFFD;			// external source FPGA 1
			_regADC[eFPGA2].ctrl &= 0xFFFD;			// external source FPGA 2
			break;
		}
		
		case eTrigTV:					// set external source for TV trigger 
		{
			_regADC[eFPGA1].ctrl &= 0xFFFD;			// external source FPGA 1
			_regADC[eFPGA2].ctrl &= 0xFFFD;			// external source FPGA 2
			break;
		}
	
	}

	CaptureSetupADC();					// write shadow to hardware
}


/* !!!!!!! old method! Please use the new API below !!!!!!!!!!!! */
/*
// set the subsource for the external trigger
void Hardware::CaptureTrigSetExtSource(trigExtSrc_t tsrc)
{
	unsigned int regSpiTrigger;

	//SwitchesTB &= 0xFFCF;					// reset subsource bits 6 + 7
	SwitchesTB &= 0x3A;					// reset subsource bits 6 + 7 and sync bits 0 + 1
	
	switch (tsrc)
	{
		case eTrigExtLFR:				// source is external trigger jack with low frequency rejection
		{
			SwitchesTB |= 0x80;
			break;
		}
		
		case eTrigExtHFR:				// source is external trigger jack with high frequency rejection
		{
			SwitchesTB |= 0xC0;
			break;
		}
		
		case eTrigExtLin: 				// source is power line signal
		{
			SwitchesTB |= 0x40;
			break;
		}
	}

	regSpiTrigger = 0x20000000 | (unsigned int)SwitchesTB;	// set address bits and source bits
	
	serdata->np_piodata = regSpiTrigger;			// write shadow to hardware
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	
}
*/
/* new OSOZ API from trigger.c */

// how should the external trigger be used
void Hardware::TriggerSetExtSrc(trigExtSel_t select)
{
	unsigned int regval = _regExtTrgSetup;  // get actual setting from shadow
	
	//printf("external Trigger Src = %d   _regExtTrgSetup = %8x", select, _regExtTrgSetup);
	
	regval &= 0x3C; // clear select bits 7+6 and sync bits 0+1
	
	//printf("   delete regval = %8x\r\n",regval);
	
	if (select <= 3)
	{	// matches hardware values up to here
		regval |= (unsigned int)select << 6;
		//printf("(select << 6 = %8x",(unsigned int)select << 6);
	}
	// else TV trigger is zero, handled below
	
	if (select == eTrigSrcVSync)
	{
		regval |= 0x01; // bit 0 selects VSync
	}
	else if (select == eTrigSrcCSync)
	{
		regval |= 0x02; // bit 1 selects CSync
	}
	// else none

	//printf("   new regval = %8x\r\n",regval);
	ShiftWrite(regval);
}

/* !!!!!!! old method! Please use the new API below !!!!!!!!!!!! */
/*
// set the coupling for external trigger source (AC, DC)
void Hardware::CaptureTrigSetExtCoupling(trigExtCpl_t tcpl)
{
	int regSpiTrigger;
	
	switch (tcpl)
	{
		case eTrigExtAC:				// external trigger AC coupled
		{
			SwitchesTB &= 0xFB;
			break;
		}
		
		case eTrigExtDC:				// external trigger DC coupled
		{
			SwitchesTB |= 0x04;
			break;
		}
	}

	regSpiTrigger = 0x20000000 | (int)SwitchesTB;		// set address bits and source bits
	
	serdata->np_piodata = regSpiTrigger;			// write shadow to hardware
	serstartsw->np_piodata = 1;
	serstartsw->np_piodata = 0;	

}
*/
/* new OSOZ API from trigger.c */
// set AC/DC coupling of external trigger
void Hardware::TriggerSetExtCoupling(trigExtCoupling_t coupling)
{
	unsigned int regval = _regExtTrgSetup;  // get actual setting from shadow
	unsigned int mask = 0x04;

	// TODO: check polarity -> checked, is ok (BF)
	if (coupling == eTrigCoupleDC)
	{
		regval |= mask;
	}
	else // if (coupling == eTrigCoupleAC)
	{
		regval &= ~mask;
	}

	ShiftWrite(regval);
}


/* new OSOZ API from trigger.c */

// set comparison level of external trigger (generated by a PWM signal)
//void Hardware::TriggerSetExtLevel(unsigned int level)
static inline volatile void TriggerSetExtLevel(unsigned int level)
{
	/* Hardware works as follows:
	 * the FPGA generates a 500Hz PWM, pulse width depending on an (8bit) register value
	 * register = 0: minimum low time ... register = 254: minimum high time
	 * register = 255: static high
	 * So we "warp" the range by 1 to include the static high
	 * (note: the later hardware inverts and filters the pulses into a voltage)
	 */
	Hardware::_regExtTrgLvl = (level - 1) & 0xFF;	// write warped level to register shadow
	
	serdata->np_piodata = Hardware::_regExtTrgLvl;	// write value to pwm hardware serial register
	serstartpwm->np_piodata = 1;			// send write pulse
	serstartpwm->np_piodata = 0;			// write pulse off

}


// set the trigger mode (auto, normal)
void Hardware::CaptureTrigSetMode(trigMode_t tmode)
{
	switch (tmode)
	{							
		case eTrigFreerun:				// no triggering, signal acquisition is running free
		{
			_regADC[eFPGA1].adc_ctrl &= 0xFFF0;		// reset channel bits FPGA 1
			_regADC[eFPGA2].adc_ctrl &= 0xFFF0;		// reset channel bits FPGA 2
			
			_regADC[eFPGA1].adc_ctrl |= 0x0001;		// set channel 1 bit FPGA 1
			_regADC[eFPGA2].adc_ctrl |= 0x0001;		// set channel 1 bit FPGA 2
			
			_regADC[eFPGA1].ctrl &= 0xFFFD;			// reset IN bit FPGA 1
			_regADC[eFPGA2].ctrl &= 0xFFFD;			// reset IN bit FPGA 2

			_regADC[eFPGA1].ctrl |= 0x0041;			// set auto and SL bit FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0041;			// set auto and SL bit FPGA 2
			break;
		}
		
		case eTrigAuto:					// auto trigger
		{
			_regADC[eFPGA1].ctrl |= 0x0040;			// set trigger mode auto FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0040;			// set trigger mode auto FPGA 2
			break;
		}
		
		case eTrigNorm:					// normal trigger
		{
			_regADC[eFPGA1].ctrl &= 0xFFBF;			// set trigger mode normal FPGA 1
			_regADC[eFPGA2].ctrl &= 0xFFBF;			// set trigger mode normal FPGA 2
			break;
		}
		
		
	}

	CaptureSetupADC();						// write shadow to hardware
}

// set the trigger level, relevant for internal and external trigger 
void Hardware::CaptureTrigSetLevel(trigSrc_t tsrc, unsigned char level)
{
	switch (tsrc)
	{
		case eTrigCh1:
		{
			_regADC[eFPGA1].trg_val[0] = 0xFF - level;	// set trigger level for channel 1 in FPGA 1
			//CaptureSetupADC();				// write shadow to hardware
			break;
		}
		
		case eTrigCh2:
		{
			_regADC[eFPGA1].trg_val[1] = 0xFF - level;	// set trigger level for channel 2 in FPGA 1
			//CaptureSetupADC();				// write shadow to hardware
			break;
		}

		case eTrigCh3:
		{
			_regADC[eFPGA2].trg_val[0] = 0xFF - level;	// set trigger level for channel 3 in FPGA 2
			//CaptureSetupADC();				// write shadow to hardware
			break;
		}
		
		case eTrigCh4:
		{
			_regADC[eFPGA2].trg_val[1] = 0xFF - level;	// set trigger level for channel 4 in FPGA 2
			//CaptureSetupADC();				// write shadow to hardware
			break;
		}
		
		case eTrigExt:
		{
			TriggerSetExtLevel((unsigned int)level);
			
			//serdata->np_piodata = _regExtTrgLvl;		// write value to pwm hardware serial register
			//serstartpwm->np_piodata = 1;			// send write pulse
			//serstartpwm->np_piodata = 0;			// write pulse off
			break;
		}
		
		case eTrigTV:
		{	
			TriggerSetExtLevel((unsigned int)level);
			
			//serdata->np_piodata = _regExtTrgLvl;		// write value to pwm hardware serial register
			//serstartpwm->np_piodata = 1;			// send write pulse
			//serstartpwm->np_piodata = 0;			// write pulse off
			break;
		}
		
	}
	
}

// set the trigger edge, relevant for internal level (and pulse?) trigger, external trigger
void Hardware::CaptureTrigSetEdge(trigEdgeSel_t tedge)
{
	switch (tedge)
	{
		case eEdgeFall:					// falling edge
		{
			_regADC[eFPGA1].ctrl &= 0xFFFB;			// reset rising bit FPGA 1
			_regADC[eFPGA2].ctrl &= 0xFFFB;			// reset rising bit FPGA 2
			break;
		}
		
		case eEdgeRise:					// rising edge
		{
			_regADC[eFPGA1].ctrl |= 0x0004;			// set rising bit FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0004;			// set rising bit FPGA 2
			break;
		}
	}
	
	//CaptureSetupADC();						// write shadow to hardware

}


// set the pulse trigger qualifier and timing
// min / max are absolut time values with resolution 1 LSB = 8ns
// SM bit in the control register has no effect, so we use the in range bit with interchanged
// width and range registers. Width register has to be set to minumum (that is 1 -> 0 is not working)
// and the range register has to be filled with the upper threshold value.
// For in range triggering the rising bit has to be set! Larger than works also with falling edge.
void Hardware::CaptureTrigSetPulse(trigPulseSel_t select, unsigned short min, unsigned short max)
{
	_regADC[eFPGA1].ctrl &= 0xF0FF;					// reset pulse selection bits FPGA 1
	_regADC[eFPGA2].ctrl &= 0xF0FF;					// reset pulse selection bits FPGA 2
	
	switch (select)
	{
		case ePulseSmaller:				// trigger if pulse width is smaller than threshold
		{
			_regADC[eFPGA1].ctrl |= 0x0804;			// set IR and RI bit FPGA 1 -> this differs from register description!
			_regADC[eFPGA2].ctrl |= 0x0804;			// set IR and RI bit FPGA 2 -> this differs from register description!
			
			// min <==> lower threshold -> don't care
			//_regADC[eFPGA1].trig_width = 1;			// set width register FPGA 1 with the minimum value -> zero does not work!
			//_regADC[eFPGA2].trig_width = 1;			// set width register FPGA 2 with the minimum value -> zero does not work!
			_regADC[eFPGA1].trig_width = 4;			// set width register FPGA 1 with the minimum value -> zero does not work! JK  min = 32ns!!sicher
			_regADC[eFPGA2].trig_width = 4;			// set width register FPGA 2 with the minimum value -> zero does not work! JK  min = 16ns!!
			// max <==> upper threshold
			_regADC[eFPGA1].trig_range = (unsigned int)max;	// set range register with maximum value FPGA 1
			_regADC[eFPGA2].trig_range = (unsigned int)max;	// set range register with maximum value FPGA 2

			break;
		}
		
		case ePulseLarger:				// trigger if pulse width is larger than threshold
		{
			_regADC[eFPGA1].ctrl |= 0x0204;			// set BG and RI bit FPGA 1
			_regADC[eFPGA2].ctrl |= 0x0204;			// set BG and RI bit FPGA 2

			// min <==> lower threshold
			if ( min < 4 ) min = 4;   // JK  16ns min
			_regADC[eFPGA1].trig_width = (unsigned int)min;	// set width register FPGA 1 with the minimum value 
			_regADC[eFPGA2].trig_width = (unsigned int)min;	// set width register FPGA 2 with the minimum value 
			// max <==> upper threshold -> don't care
			_regADC[eFPGA1].trig_range = 0;			// reset range register FPGA 1
			_regADC[eFPGA2].trig_range = 0;			// reset range register FPGA 2	
			
			break;
		}

		case ePulseBetween:				// trigger if pulse width is between values
		{
			_regADC[eFPGA1].ctrl |= 0x0804;			// set IR and RI bit FPGA 1 -> this differs from register description!
			_regADC[eFPGA2].ctrl |= 0x0804;			// set IR and RI bit FPGA 2 -> this differs from register description!

			// min <==> lower threshold
			// max <==> upper threshold
			if ( min < 4 ) min = 4;   // JK  16ns min
			_regADC[eFPGA1].trig_width = (unsigned int)min;	// set width register FPGA 1 with the minimum value 
			_regADC[eFPGA2].trig_width = (unsigned int)min;	// set width register FPGA 2 with the minimum value 
			// range = difference between lower and upper threshold
			if ( (max-min) < 1 ) max = min + 1; // JK  8ns > difference
			_regADC[eFPGA1].trig_range = (unsigned int)(max - min); // set range register FPGA 1 to difference between maximum and minimum
			_regADC[eFPGA2].trig_range = (unsigned int)(max - min); // set range register FPGA 2 to difference between maximum and minimum

			break;
		}
	}
	
	//CaptureSetupADC();						// write shadow to hardware

}				


// set the trigger holdoff time, intentional re-arming delay time
// holdoff is an absolut time values with resolution 1 LSB = 8ns. => lt. Beschreibung 16ns .. 100ms JK
// The holdoff register has to be loaded with the inverted value
void Hardware::CaptureTrigSetHoldoff(unsigned int holdoff)
{
	//if (holdoff > 0)
	if (holdoff > 2)    // JK min 16ns	
	{
		_regADC[eFPGA1].ctrl |= 0x2000;				// set holdoff bit FPGA 1
		_regADC[eFPGA2].ctrl |= 0x2000;				// set holdoff bit FPGA 2
	}
	else
	{
		_regADC[eFPGA1].ctrl &= 0xDFFF;				// reset holdoff bit FPGA 1
		_regADC[eFPGA2].ctrl &= 0xDFFF;				// reset holdoff bit FPGA 2
	}
	
	_regADC[eFPGA1].trig_holdoff = 0xFFFFFFFF - holdoff;		// set inverted holdoff value FPGA 1
	_regADC[eFPGA2].trig_holdoff = 0xFFFFFFFF - holdoff;		// set inverted holdoff value FPGA 2
		
	//CaptureSetupADC();					// write shadow to hardware
	
}






// set the timebase
// note: delayed by upper layer, won't get changed during capture
// Nios hardware behaviour: sample rate is halved for hardware value 1...4 in each step,
// from then on the divider is incremented by 8 for each step
// subsampling = 1,2,4,8,16 for 1GSa,500MSa,250MSa,125Msa,62.5MSa (exponential range)
// subsampling = 32, 40, 48, ... for 1GSa/subsampling (linear area)
/* 
   the driver is not working correctly!!!
   2 => 500MS is a pseudo 16K mode with true 8K samples
   4 => 250MS is a pseudo 16K mode with true 8K samples
   32 = 40 = 48 => 25MSa
*/
void Hardware::CaptureSetTimebase(uint32_t subsampling)
{
	uint32_t hwVal;
	
	uint32_t samplestep, timebase, adc;

	if (subsampling <= 32) // exponential area
	{
		uint32_t mask = 1<<5; // find highest bit
		hwVal = 5; // 2**5 = 32

		while (!(mask & subsampling))
		{	// find power of 2
			hwVal--;
			mask >>= 1;
		}
		
		if (hwVal < 2) // 4 ADC mode
		{
			hwVal++; // make subsampling 1 or 2 from exponent 0 or 1
			samplestep = 1;
			adc = 4;
		}
		else // single ADC mode
		{
			hwVal--; // reduce to re-use 1 or 2 with single ADC
			samplestep = 4;
			adc = 1;
		}
	}
	else // linear area
	{
		hwVal = subsampling / 8;
		samplestep = 4; // always single ADC
		adc = 1;
	}

	_regADC[eFPGA1].timebase = -hwVal;
	_regADC[eFPGA2].timebase = _regADC[eFPGA1].timebase;
	
	//SetupADC(); // write shadow to hardware
/*	
		// first FPGA
	mode->np_piodata = 0x01;
		
	WriteADC(eCh1, _regADC[eFPGA1].regword[0]);					// 1. 32 bit -> ctrl_reg + adc_ctrl

	WriteADC(eCh1, _regADC[eFPGA1].regword[1]);					// 2. 32 bit -> timebase register

	WriteADC(eCh1, _regADC[eFPGA1].regword[2]);					// 3. 32 bit -> pretrigger + channel_Adr_add12
    	
	WriteADC(eCh1, _regADC[eFPGA1].regword[3]); 					// 4. 32 bit -> trigger value channel 1 + channel 2 + trigger range

	WriteADC(eCh1, _regADC[eFPGA1].regword[4]);					// 5. 32 bit -> trigger holdoff

	WriteADC(eCh1, _regADC[eFPGA1].regword[5]);					// 6. 32 bit -> trigger width + GridColorArray[4] = {0x00, 0x15, 0x2A, 0x3F};
	
	WriteADC(eCh1, _regADC[eFPGA1].regword[6]);					// 7. 32 bit -> adc_change12_reg 
	
	WriteADC(eCh1, _regADC[eFPGA1].regword[7]);					// 8. 32 bit -> unused dummy register

	mode->np_piodata = 0x00;

	//nr_delay(20);

	if (NumberOfChannels == 4)							// second FPGA
	{
		_regADC[eFPGA2].timebase = tb_value[MainTimebase];			// set timebase shadow register with value from timebase table
		
		mode->np_piodata = 0x01;
		
		WriteADC(eCh3,_regADC[eFPGA2].regword[0]);				// 1. 32 bit -> ctrl_reg + adc_ctrl
			
		WriteADC(eCh3, _regADC[eFPGA2].regword[1]);				// 2. 32 bit -> timebase register
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[2]);				// 3. 32 bit -> pretrigger + channel_Adr_add34

		WriteADC(eCh3, _regADC[eFPGA2].regword[3]); 				// 4. 32 bit -> trigger value channel 3 + channel 4 + trigger range	
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[4]);				// 5. 32 bit -> trigger holdoff
	
		WriteADC(eCh3, _regADC[eFPGA2].regword[5]);				// 6. 32 bit -> trigger width + GridColorArray[4]
	
		WriteADC(eCh3, _regADC[eFPGA2].regword[6]);				// 7. 32 bit -> adc_change34_reg 
		
		WriteADC(eCh3, _regADC[eFPGA2].regword[7]);				// 8. 32 bit -> unused dummy register
	
		mode->np_piodata = 0x00;
    	}			
	
*/	
	
	
	printf("\r\nTB subsampling: %d\r\n", subsampling);
	printf("TB samplestep: %d\r\n", samplestep);
	printf("TB interleaved ADC: %d\r\n", adc);
	printf("TB register: %X\r\n\r\n", _regADC[eFPGA1].timebase);
	
}




/**********************************************************************************************************************************************************/

//##########################################################################################################################################################
// set the readout length for reading from the serial ADC interface, data are coming in 32 bit format,
// so readout length must be number of bytes / 4
/*
void Hardware::SetReadoutLength(void)
{

	// not in use!!! //
	BufferOffset = 0;
	ReadoutLength = 4100;
	return;
	
	BufferOffset = 0;					// no offset for FFT and XY-Mode
	
	if (Signal::_FFT_Mode != FFT_OFF)
	{	
		
		if (Signal::_FFT_Mode == FFT_512)
		{
			if (MainTimebase < 11)	// 16Kbyte
				ReadoutLength = 160;
			else				
				ReadoutLength = 640;

		}
		else if (Signal::_FFT_Mode == FFT_1K)
		{
			if (MainTimebase < 11)	// 16Kbyte
				ReadoutLength = 320;
			else				
				ReadoutLength = 1280;
			
		}
		else if (Signal::_FFT_Mode == FFT_2K)
		{
			if (MainTimebase < 11)	// 16Kbyte
				ReadoutLength = 640;
			else				
				ReadoutLength = 2400;
			
		}
		else
		{
			if (MainTimebase < 11)	// 16Kbyte
				ReadoutLength = 1280;
			else				
				ReadoutLength = 4100;
			
		}
		
		//ReadoutLength = 4100;
	}	
//	else if (MainTimebase < 11)	// 16Kbyte
// 	  ReadoutLength = 4100;//4096;
	else				// 4Kbyte + 16 byte to avoid errors at signal end
	{
		if (ACQ_HighSpeed && !LA_active)
		{
			if (Trig_Pos_Mem > MemWinStart)
			{
				BufferOffset = MemWinStart - MemStartOffs;		// ADC read out offset
				ReadoutLength = ReadoutLengthTable[MainTimebase] + (Trig_Pos_Mem >> 2); //4100;
			}
			else
			{
				BufferOffset = Trig_Pos_Mem - MemStartOffs;		// ADC read out offset
				ReadoutLength = ReadoutLengthTable[MainTimebase] + (MemWinStart >> 2); //4100;
			}
			
			if (ReadoutLength > 4100)
			ReadoutLength = 4100;
		}
		else
		{
			BufferOffset = 0;
			ReadoutLength = 4100;
		}
	}
	
}
*/
//##########################################################################################################################################################
/* not used -> has been written for the case that not always the full signal is read from ADC  (for performance optimization)
void Hardware::GetFullSignal(void)
{
	uint32_t buffer_addr = 0;	
	uint32_t buffer_start;
	
	if (MainTimebase > 10) return;				// only needed for the fast timebases
	
	for(uint32_t i=0;ADC_Started && i < 1000000;i++);	// check if ADCs are busy and wait
	
	data_adr->np_piodata = 0x01;				// send readout buffer config pulse

	//-------------------------------------------------------
	//		(Pre) Trigger Control
	//-------------------------------------------------------
	AutoFreeRun = false;

	//BF get start address of readout buffer
	if (_TriggerSource == eTrigCh3 || _TriggerSource == eTrigCh4)	
	{ buffer_addr = ReadADC(eCh3); if ((buffer_addr & 0x0000FFFF) == 0x00000000) { AutoFreeRun = true; }}
	else 
	{ buffer_addr = ReadADC(eCh1); if ((buffer_addr & 0x00001000) == 0x00001000) { AutoFreeRun = true; }}

	//BF calc buffer address with pretrigger offset
	if (AutoFreeRun == true)	//BF no trigger event occured
	{
		if ((buffer_addr & 0x00000FFF) == 0x00000000)
		{
			if (MainTimebase < 11) buffer_start = (buffer_addr & 0x00000FFF) + (_regADC[eFPGA1].pre >> 1); 	// 16Kbyte
			else buffer_start = (buffer_addr & 0x00000FFF) + _regADC[eFPGA1].pre;				//  4Kbyte
		}
		else
		{	
			if (MainTimebase < 11) buffer_start = _regADC[eFPGA1].pre >> 1;		// 16Kbyte
			else buffer_start = _regADC[eFPGA1].pre;				//  4Kbyte
		}
	}
	else if (MainTimebase < 11)	// trigger event occured -> 16Kbyte
	{ 
		buffer_start = (((buffer_addr & 0x0FFF) - (_regADC[eFPGA1].pre >> 1)) & 0x00000FFF) ;
	}	
	else	// trigger event occured -> 4KB memory
	{ 
		buffer_start = (((buffer_addr & 0x0FFF) - _regADC[eFPGA1].pre) & 0x00000FFF);
	}									//BF trigger event occured
	
	//BF set buffer start address
	WriteADC(eCh1, buffer_start);	
	WriteADC(eCh2, buffer_start);
	
	if (NumberOfChannels == 4)
	{				
		WriteADC(eCh3, buffer_start);
		WriteADC(eCh4, buffer_start);
	}

	data_adr->np_piodata = 0x00;	// readout buffer config pulse end
	
	if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_ALT)			//alternating trigger
	{
		ADC_ReadData(_TriggerSource, Signal[_TriggerSource], 4100, MenuStatus[_TriggerSource+1][2] - BTN_OFF);
	}
	else
	{
		if (Channel[eCh1].active)
		{ ADC_ReadData(eCh1, SIGNAL1, 4100, MenuStatus[MENU_CHANNEL1][2] - BTN_OFF); }
		
		if (Channel[eCh2].active)
		{ ADC_ReadData(eCh2, SIGNAL2, 4100, MenuStatus[MENU_CHANNEL2][2] - BTN_OFF); }	
		
		if (NumberOfChannels == 4)
		{	
			if (Channel[eCh3].active)
			{ ADC_ReadData(eCh3, SIGNAL3, 4100, MenuStatus[MENU_CHANNEL3][2] - BTN_OFF); }
		
			if (Channel[eCh4].active)
			{ ADC_ReadData(eCh4, SIGNAL4, 4100, MenuStatus[MENU_CHANNEL4][2] - BTN_OFF); }
		}	
	}
	
	S1Ptr = SIGNAL1;
	S2Ptr = SIGNAL2;
	S3Ptr = SIGNAL3;
	S4Ptr = SIGNAL4;

	
}
*/
