
#include "opsys_t.h"
#include "hardware_t.h"

//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class OpSys
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

/* declare class attributes */

 //void (* OpSys::_ExecQueue[QUEUE_LENGTH])(void);
// queue_t OpSys::_ExecQueue[QUEUE_LENGTH];			// queue with execution priority
 void (* OpSys::_ExecHdl[5])(void);				// simple queue with 5 tasks
 
 
 /* implement class methods */
/* 
//##########################################################################################################################################################
// ! clear execution queue
void OpSys::InitExecQueue(void)
{
#ifdef OPSYS_DEBUG
	printf("\n\r** Init Exec Queue **\n\r");
#endif	

	for (int i = 0; i < QUEUE_LENGTH; i++)
	{ 
		_ExecQueue[i].hdl = NULL;
		_ExecQueue[i].prio = 0;
	}
}	
	

//##########################################################################################################################################################
// ! push execution handle into execution queue
// ! return value is 1 if operation was successfull and 0 if queue overflow occured
int OpSys::PushExecHdl(void (* hdl)(void), unsigned int prio)
{
	unsigned int exidx;
	
	
	// high priority requests have to be executed as fast as possible. We search for the
	// queue entry which is nearest to execution with lower priority to insert the new
	// task here and shift back all other tasks. This may be an UI request for example.
	if (prio == ePrioHigh)
	{
		// get first handle with lower priority, zero handle has to be ignored because it
		// may be executed just at this moment!
		for (exidx = 1; exidx < QUEUE_LENGTH && _ExecQueue[exidx].prio == prio; exidx++);

		// check for queue overflow
		if (exidx == QUEUE_LENGTH)
		{
			// queue overflow
			printf("\r\nQueue Overflow!\r\n");
			ExecMonitor();
			for(;;);
			return 0;	
		}
		
		// shift queue back and insert the high priority handle
		for (int i = QUEUE_LENGTH - 2; i >= exidx ; i--)
		{
			if (_ExecQueue[i].hdl != NULL) 
			{ _ExecQueue[i+1] = _ExecQueue[i]; } 
		}
		
		_ExecQueue[exidx].hdl = hdl;
		_ExecQueue[exidx].prio = prio;
#ifdef OPSYS_DEBUG		
	printf("\r\nPush execution handle %d: %8x -> prio %d\r\n",exidx, _ExecQueue[exidx].hdl, _ExecQueue[exidx].prio);
#endif	
		return 1;
	}
	// medium priority requests have to be assigned to the next free task near to
	// execution. This is in most cases a task of the normal processing chain.
	else if (prio == ePrioMedium)
	{
		// get first empty handle at the end of the queue
		for (exidx = 0; exidx < QUEUE_LENGTH && _ExecQueue[exidx].hdl != NULL; exidx++);
		
		// check for queue overflow
		if (exidx == QUEUE_LENGTH)
		{
			// queue overflow
			printf("\r\nQueue Overflow!\r\n");
			ExecMonitor();
			for(;;);
			return 0;	
		}
		
		// check for duplicates
		if (exidx > 0)
		{
			if (_ExecQueue[exidx - 1].hdl == hdl) return 0;
		}
		
		// add new handle to execution queue
		if (_ExecQueue[exidx].hdl == NULL)
		{	
			_ExecQueue[exidx].hdl = hdl;
			_ExecQueue[exidx].prio = prio;
#ifdef OPSYS_DEBUG		
	printf("\r\nPush execution handle %d: %8x -> prio %d\r\n",exidx, _ExecQueue[exidx].hdl, _ExecQueue[exidx].prio);
#endif	
			return 1;
		}
	}
	// low priority requests are appended to the end of the queue although there may be empty
	// tasks before. They can be used by higher priority tasks before. The low priority
	// task is executed latest after one queue length. This is for example a flash write request.
	// If the end of the queue is already in use shift forward the last entry one place if there
	// is an empty place before. Otherwise the new request will be ignored.
	else
	{
		exidx = QUEUE_LENGTH - 1;	// end of the queue 
		
		if (_ExecQueue[exidx].hdl == NULL)
		{
			_ExecQueue[exidx].hdl = hdl;
			_ExecQueue[exidx].prio = prio;
#ifdef OPSYS_DEBUG			
	printf("\r\nPush execution handle %d: %8x -> prio %d\r\n",exidx, _ExecQueue[exidx].hdl, _ExecQueue[exidx].prio);
#endif
			return 1;
		}
		else if (_ExecQueue[exidx-1].hdl == NULL)
		{
			_ExecQueue[exidx-1] = _ExecQueue[exidx];
			
			_ExecQueue[exidx].hdl = hdl;
			_ExecQueue[exidx].prio = prio;
#ifdef OPSYS_DEBUG			
	printf("\r\nPush execution handle %d: %8x -> prio %d\r\n",exidx, _ExecQueue[exidx].hdl, _ExecQueue[exidx].prio);
#endif
		}
		else
		{
			// queue overflow
			printf("\r\nQueue Overflow!\r\n");
			ExecMonitor();
			for(;;);
			return 0;	
		}

		
	}
	
	// queue overflow
	return 0;
}


//##########################################################################################################################################################
// ! execution handler, processes the execution queue and starts the handles
void OpSys::ExecHandler(void)
{
//printf("\n\r** Start Execution Handler **\n\r");
	
	unsigned int exidx=0, j;

	queue_t buffer;
	
	for(;;)
	{							
	
		// execute the zero handle
		if (_ExecQueue[0].hdl != NULL)			// check if handle points to executable code
		{ 
			// check if next handle is the same, to avoid executing 
			// the same handle two times directly after another
			// if so -> skip actual handle and pop it out
			if (_ExecQueue[1].hdl != _ExecQueue[0].hdl)
			{
#ifdef OPSYS_DEBUG
	printf("\r\nExecute handle: %d: %8x(%d)",exidx, _ExecQueue[0].hdl, _ExecQueue[0].prio);
#endif
				(* _ExecQueue[0].hdl)(); 			// execute always the first handle in the queue (zero handle)
			}
		}
		
		// shift the queue and pop out the executed handle -> first in first out
		for (j = 1; j < QUEUE_LENGTH; j++)		
		{			
			//_ExecQueue[j-1].hdl = _ExecQueue[j].hdl;
			//_ExecQueue[j-1].prio = _ExecQueue[j].prio;
			_ExecQueue[j-1] = _ExecQueue[j];
		}	
		
		j--;						// set index back to last handle
		_ExecQueue[j].prio = 0;
		_ExecQueue[j].hdl = NULL;			// initialize last handle

#ifdef OPSYS_DEBUG		
	OpSys::ExecMonitor();
#endif		
	}
		
}	

//##########################################################################################################################################################
// ! execution handler, processes the execution queue and starts the handles
void OpSys::ExecMonitor(void)
{

	printf("\n\r** Execution Queue Monitor **\n\r\n\r");
	
	for (int i = 0; i < QUEUE_LENGTH; i++)
	 printf("handle %d: %8x -> prio %d\r\n",i, _ExecQueue[i].hdl, _ExecQueue[i].prio);
	
	
	
}	

//##########################################################################################################################################################
// ! start main processing chain
void OpSys::StartProcessChain(void)
{
	
	InitExecQueue();
	
	Hardware::Start_Record();
	
}	
*/
//##########################################################################################################################################################

/* functions for the simple execution queue without execution priority */

// ! init single execution function
void OpSys::InitSingle(int task)
{
	_ExecHdl[task] = NULL;
}	

//##########################################################################################################################################################
// ! init the simple queue
void OpSys::InitQueue(void)
{
	for(int i=0;i<5;i++)
	_ExecHdl[i] = NULL;
}	

//##########################################################################################################################################################
// set handle for execution queue
void OpSys::LoadExecHandler(void (* hdl)(void))	
{

	for(int i=0;i<5;i++)
	{
		if (OpSys::_ExecHdl[i] == NULL)		   	// load task if handler is available
		{
			OpSys::_ExecHdl[i] = hdl;
			break;
		}
	}	

}

//##########################################################################################################################################################
// ! execute single function
void OpSys::ExecSingle(int task)
{
	
	if (_ExecHdl[task] != NULL)	// execution only if handler points to executable code
	{
		(* _ExecHdl[task])();	// execute pointer destination
		_ExecHdl[task] = NULL;	// initialize exec handler
	}

}	

