
#ifndef opsys_t_h
#define opsys_t_h

#include "nios.h"

#define QUEUE_LENGTH	9

// switch on opsys debugging
//#ifndef OPSYS_DEBUG
//#define OPSYS_DEBUG
//#endif

typedef	struct	 //!< type of execution queue with priority
{	
	void (* hdl)(void);	//!< execution handle
	unsigned int prio;	//!< execution priority
	
} queue_t;


typedef enum
{
	ePrioHigh = 3, //!< highest execution priority
	ePrioMedium = 2,  //!< medium execution priority
	ePrioLow = 1,  //!< lowest execution priority
} exPrio_t;



/*
	Main operation system functions
*/

class OpSys
{
	protected:
	
	//static void (* _ExecQueue[QUEUE_LENGTH])(void);				// simple execution queue
//	static queue_t _ExecQueue[QUEUE_LENGTH];					// queue with execution priority
	
	public:	
	/* execution queue for dynamically request handling */	
	static void (* _ExecHdl[5])(void);							// simple queue with 5 single execution handles
	
	
/*	static void InitExecQueue(void);	
		
	static int PushExecHdl(void (* hdl)(void), unsigned int prio);	
		
	static void ExecHandler(void);	
	
	static void ExecMonitor(void);

	static void StartProcessChain(void);
*/	
	static void InitSingle(int task);
	
	static void InitQueue(void);
	
	static void LoadExecHandler(void (* hdl)(void));
	
	static void ExecSingle(int task);							// execute single handle as member function
	
};


// ! execute single handle as inline function to avoid overhead
inline void inlExecSingle(int task)
{
	if (OpSys::_ExecHdl[task] != NULL)
	{
		(* OpSys::_ExecHdl[task])();
		OpSys::_ExecHdl[task] = NULL;
	}
}	


#endif //opsys_t_h
