

#include "tc_vars.h"


// Constants

// Versions numbers
unsigned long tc_varstart		= 0xAABBCCDD;		// Kennung Varstart
unsigned long tc_version		= 0x00000001;		// Base Factory version 	1 
unsigned long tc_subversion		= 0x00000002;		// Base Factory subversion 	2
unsigned long tc_dev_version		= 0x00000007;		// Developer version
unsigned long tc_dev_subversion		= 0x0000000A;		// Developer subversion
char	      tc_compilation[20] 	= {"  "};		// Compilation
unsigned long tc_hw_modif	  	= 0x00000000;		// hardware modification
unsigned long tc_hw_version     	= 0x00000000;		// FPGA version 


unsigned long tc_model 			= 0x00000000;		// 2012, 2022 , 2014, 2024
unsigned long tc_serial 		= 0x00000000;		// 1
unsigned long tc_production_lot1 	= 0x00000020;		// E
unsigned long tc_production_lot2 	= 0x00000020;		// E
unsigned long tc_shipment_date 		= 0x00000000;		// 2C7

const unsigned char btnUnpushed		= 0x00;
const unsigned char btnPushed 		= 0x01;

const unsigned char btnDraw		= 0x00;
const unsigned char btnRemove 		= 0x01;

const unsigned long BitMasks[32] = {	0x7FFFFFFF, 0xBFFFFFFF, 0xDFFFFFFF, 0xEFFFFFFF,
					0xF7FFFFFF, 0xFBFFFFFF, 0xFDFFFFFF, 0xFEFFFFFF,
					0xFF7FFFFF, 0xFFBFFFFF, 0xFFDFFFFF, 0xFFEFFFFF,
					0xFFF7FFFF, 0xFFFBFFFF, 0xFFFDFFFF, 0xFFFEFFFF,
					0xFFFF7FFF, 0xFFFFBFFF, 0xFFFFDFFF, 0xFFFFEFFF,
					0xFFFFF7FF, 0xFFFFFBFF, 0xFFFFFDFF, 0xFFFFFEFF,
					0xFFFFFF7F, 0xFFFFFFBF, 0xFFFFFFDF, 0xFFFFFFEF,
					0xFFFFFFF7, 0xFFFFFFFB, 0xFFFFFFFD, 0xFFFFFFFE};
								
const unsigned long BitMasks2[32] = {	0x80000000, 0x40000000, 0x20000000, 0x10000000,
					0x08000000, 0x04000000, 0x02000000, 0x01000000,
					0x00800000, 0x00400000, 0x00200000, 0x00100000,
					0x00080000, 0x00040000, 0x00020000, 0x00010000,
					0x00008000, 0x00004000, 0x00002000, 0x00001000,
					0x00000800, 0x00000400, 0x00000200, 0x00000100,
					0x00000080, 0x00000040, 0x00000020, 0x00000010,
					0x00000008, 0x00000004, 0x00000002, 0x00000001};

// Constants
const int DrawOffsetX 		= GRID_XOFFS;				// Draw Offset from Left
const int DrawOffsetY 		= GRID_YOFFS;				// Draw Offset from Top
const int DrawXYOffsetX1 	= GRID_YOFFS + (GRID_XY / 2);		//59;	//?????	// Draw Offset from Top
const int DrawXYOffsetX2 	= GRID_XY_XOFFS + (GRID_XY / 2);	//541;	//?????	// Draw Offset from Left


channelData_t Channel[5];



//-----------------------------------------------------------------------------------------------------
uint8_t test_sw1 = 0;					//BF Test Funktion 11 S -> switch to C-routines
uint8_t test_sw2 = 0;					//BF Test Funktion 20 Y	
uint8_t test_sw3 = 1;					//BF Test Funktion 21 X 

uint8_t test_channel = 1;
//uint32_t test_values  = 0;
//uint32_t  test_offs_a  = 0;
//uint32_t  test_offs_b  = 0;
//uint32_t  test_div_a   = 1;
//uint32_t  test_div_b   = 1;
uint32_t FrameCount   = 0;


//--------------------------------------------------------------------------------------------------------
uint32_t DottedGrid = 0;					// switch solid/dotted grid
unsigned char FFT_grid    = 0;					// switch frequency div
volatile uint32_t UI_request  = 0;				// flag for user interface activity
unsigned char QP_request  = 0;					// flag Quick Print requested
unsigned char QP_mode     = 1;					// 0->BF-version / 1->OS-version / 2->USB-Export / (remote control -> shift + T)


unsigned char FlashPreset = 0;					// Flash presetting flag

uint32_t CRS_Delta  = 1;					// delta cursor on/off
uint32_t AS_request = 0;					// auto scale requested
uint32_t RC_request = 0;					// signal recall requested
uint32_t RC_overlay = 0;					// recall overlay mode active
uint32_t RC_user_if = 0;					// flag for user interface activity in Overlay mode
uint32_t LA_active = 0;						// logic analyzer mode active

volatile uint32_t ZL_changed  = 0;					// OnZero Channel -> only draw signal with changed zerolevel

uint32_t ACQ_NewData = 0;
uint32_t ACQ_Average = 0;					// Average mode
uint32_t ACQ_ManTrigg = 0;					// Flag manual trigger 
uint32_t ACQ_HighSpeed = 0;					// ADC running in high speed mode
uint32_t ACQ_PeakDetect = 0;					// Acquisition mode is peak detect

volatile uint8_t UART_NewData = 0;
volatile int8_t UART_RXData   = -1;
volatile uint32_t UART_RXFlag = 0;				//KB Quick Print USB-export
volatile uint8_t UartRxGuiCmd = 0;                 		//#FW# Hardware::ISR_UART has filled UartRxGuiBuf
uint8_t UartRxGuiBuf[UARTRXGUISIZE];    			//#FW# Buffer for GUI-Commands

unsigned char DrawMono = 0;					// flag for drawing monochrome
unsigned char NoDisplay[4] = {0,0,0,0};

int CalSet = 0;
float PreTrigger = 0;

uint32_t TRG_NoEventCounter = 0;

//--------------------------------------------------------------------------------------------------------

unsigned long timer_counter_value = 1;
unsigned long timer_counter_max   = 1;

int timer_reload_low  = 0;
int timer_reload_high = 0;



const uint32_t RegTimerRotDelay     = 25000000;//40000000;	// BF changed		25000000;	// Rotary change timer
//const int TimerSecPeriod     = 12500000;							// button pushed time
const int TimerSecPeriod     = 8500000;							// button pushed time

                
const uint32_t RegTimebaseTable[36] = 
{
	/*-------16Kb--------*/
	0xFFFFFFFF,		//	 0 -> 2 ns
	0xFFFFFFFF,		//	 1 -> 5 ns
	0xFFFFFFFF,		//	 2 -> 10 ns
	0xFFFFFFFF,		//	 3 -> 20 ns
	0xFFFFFFFF,		//	 4 -> 50 ns
	0xFFFFFFFF,		//	 5 -> 100 ns
	0xFFFFFFFF,		//	 6 -> 200 ns
	0xFFFFFFFF,		//	 7 -> 500 ns
	0xFFFFFFFF,		//	 8 -> 1 µs
	/*-------16Kb(8Kb)--------*/
	0xFFFFFFFE,		//	 9 -> 2 µs (500MSa/S)
	0xFFFFFFFD,		//	10 -> 5 µs (250MSa/S)
	/*-------4Kb--------*/
	//0xFFFFFFFC,		//	11 -> 10 µs (25MSa/S)
	0xFFFFFFFB,		//	11 -> 10 µs (25MSa/S)
	//0xFFFFFFFA,		//	11 -> 10 µs (25MSa/S)
	0xFFFFFFF3,		//	12 -> 20 µs
	0xFFFFFFE7,		//	13 -> 50 µs
	0xFFFFFFCE,		//	14 -> 100 µs
	0xFFFFFF83,		//	15 -> 200 µs
	0xFFFFFF06,		//	16 -> 500 µs
	0xFFFFFE0C,		//	17 -> 1 ms
	0xFFFFFB1E,		//	18 -> 2 ms
	0xFFFFF63C,		//	19 -> 5 ms
	0xFFFFEC78,		//	20 -> 10 ms
	0xFFFFCF2C,		//	21 -> 20 ms
	0xFFFF9E58,		//	22 -> 50 ms
	0xFFFF3CB0,		//	23 -> 100 ms
	0xFFFE17B8,		//	24 -> 200 ms
	0xFFFC2F70,		//	25 -> 500 ms
	/*------- USTB -----*/
	0xFFFFFFFF,		//	26 -> 1 s [USTB]
	0xFFFFFFFF,		//	27 -> 2 s [USTB]
	0xFFFFFFFF,		//	28 -> 5 s [USTB]
	0xFFFFFFFF,		//	29 -> 10 s [USTB]
	0xFFFFFFFF,		//	30 -> 20 s [USTB]
	0xFFFFFFFF,		//	31 -> 50 s [USTB]
	0xFFFFFFFF,		//	32 -> 100 s [USTB]
	0xFFFFFFFF,		//	33 -> 200 s [USTB]
	0xFFFFFFFF,		//	34 -> 500 s [USTB]
	0xFFFFFFFF		//	35 -> 1000 s [USTB]
};
	
	
/* Old values before USTB
                                    0xFFFC2F70,		//	500 mS
                                    0xFFF85EE0,		//	1 S
                                    0xFFECED30,		//	2 S
				    0xFFD9Da60,		//	5 S	
				    0xFFB3B4C0,		//	10 S
				    0xFF4143E0,		//	20 S
				    0xFFFFFFFF,		//	50 S
				    0xFFFFFFFF,		//	100 S
				    0xFFFFFFFF};	//	200 S

*/

// BF add
//constants for ultra slow timebase mode	   1 channel 2 channel 3 channel 4 channel
const unsigned long int USTB_timer_value[11] = {    125000,	//500 mS	Ta = 10ms -> not used
						    250000, 	//1 S		Ta = 20ms -> USTB starts here!!
                                                    500000,	//2 S		Ta = 40ms
	 				           1250000,	//5 S		Ta = 100ms
                                                   2500000,	//10 S		Ta = 200ms
                                                   5000000,	//20 S		Ta = 400ms
                                                  12500000,	//50 S		Ta = 1s
                                                  25000000,	//100 S		Ta = 2s
                                                  50000000,	//200 S		Ta = 4s
                                                 125000000,	//500 S		Ta = 10s
                                                 250000000};	//1000 S	Ta = 20s
/*
const unsigned long int USTB_timer_value[11][4] = {{   100000,   100000,   100000,   100000 },	//500 mS	Ta = 10ms -> not used
						   {   200000,   180000,   172000,   175000 },	//1 S		Ta = 20ms -> USTB starts here!!
                                                   {   500000,   495000,   428000,   399000 },	//2 S		Ta = 40ms
	 				           {  1250000,  1250000,  1250000,  1250000 },	//5 S		Ta = 100ms
                                                   {  2500000,  2500000,  2500000,  2500000 },	//10 S		Ta = 200ms
                                                   {  5000000,  5000000,  5000000,  5000000 },	//20 S		Ta = 400ms
                                                   { 12500000, 12500000, 12500000, 12500000 },	//50 S		Ta = 1s
                                                   { 25000000, 25000000, 25000000, 25000000 },	//100 S		Ta = 2s
                                                   { 50000000, 50000000, 50000000, 50000000 },	//200 S		Ta = 4s
                                                   {125000000,125000000,125000000,125000000 },	//500 S		Ta = 10s
                                                   {250000000,250000000,250000000,250000000 }};	//1000 S	Ta = 20s

*/
const int ExtTrigOffset[36] = 
{
	/*-------16Kb--------------*/
	170,		//	2 ns
	170,		//	5 ns
	170,		//	10 ns
	170,		//	20 ns
	170,		//	50 ns
	165,		//	100 ns
	165,		//	200 ns
	140,		//	500 ns
	160,		//	1 µs
	160,		//	2 µs
	160,		//	5 µs
	/*-------4Kb---------------*/
	40,		//	10 µs
	40,		//	20 µs
	40,		//	50 µs
	40,		//	100 µs
	40,		//	200 µs
	40,		//	500 µs
	40,		//	1 ms
	40,		//	2 ms
	40,		//	5 ms
	40,		//	10 ms
	40,		//	20 ms
	40,		//	50 ms
	40,		//	100 ms
	40,		//	200 ms
	40,		//	500 ms
	/*------- USTB --------------*/
	0,		//	1 s
	0,		//	2 s
	0,		//	5 s
	0,		//	10 s
	0,		//	20 s
	0,		//	50 s
	0,		//	100 s
	0,		//	200 s
	0,		//	500 s
	0		//	1000 s
};
				  
// number of 32 bit ADC readout values depending on timebase
// -> must be dividable by 4 in the 4KB timebases, otherwise system crashes!
const uint32_t ReadoutLengthTable[36] =
{ 
	/*-------16Kb--------------*/
	300,		//	2 ns
	300,		//	5 ns
	300,		//	10 ns
	300,		//	20 ns
	400,		//	50 ns
	600,		//	100 ns
	1000,		//	200 ns
	2000,		//	500 ns
	3050,		//	1 µs
	3050,		//	2 µs
	4100,		//	5 µs
	/*-------4Kb---------------*/
	4100,		//	10 µs
	4100,		//	20 µs
	4100,		//	50 µs
	4100,		//	100 µs
	4100,		//	200 µs
	4100,		//	500 µs
	4100,		//	1 ms
	4100,		//	2 ms
	4100,		//	5 ms
	4100,		//	10 ms
	4100,		//	20 ms
	4100,		//	50 ms
	4100,		//	100 ms
	4100,		//	200 ms
	4100,		//	500 ms
	/*------- USTB --------------*/
	32,		//	1 s
	32,		//	2 s
	32,		//	5 s
	32,		//	10 s
	32,		//	20 s
	32,		//	50 s
	32,		//	100 s
	32,		//	200 s
	32,		//	500 s
	32		//	1000 s
};

uint32_t ReadoutLength;
//uint32_t BufferOffset;

				  
//--------------------------------------------------------------------------------------------------
//BF range factors for math signal 

const unsigned int math_voltage_factor[2][18] =
					    {{   1,       2,       3,	//  1mV,   2mV,   5mV 
                                                10,      20,      31,	// 10mV,  20mV,  50mV 
                                               100,     197,     308,	//100mV, 200mV, 500mV
                                              1000,    1970,    3079,	//  1V,    2V,    5V
                                             10000,   19700,   30790,   // 10V,   20V,   50V
                                            100000,  197000,  307900 },	//100V,  200V,  500V

					     {   1,       2,       3,	//  1mV,   2mV,   5mV 
                                                 8,      16,      31,	// 10mV,  20mV,  50mV 
                                                80,     159,     308,	//100mV, 200mV, 500mV
                                               806,    1586,    3079,	//  1V,    2V,    5V
                                              8064,   15861,   30790,   // 10V,   20V,   50V
                                             80640,  158615,  307900 }};//100V,  200V,  500V

// for rescaling math multiplication voltage factors
const 		int math_rescale[2][18] =    {{	20000,   19700,   15395,	//  1mV,   2mV,   5mV 
		 			      	20000,   19700,   15395,	// 10mV,  20mV,  50mV 
				     	      	20000,   19700,   15395,	//100mV, 200mV, 500mV
						20000,   19700,   15395,	//  1V,    2V,    5V
						20000,   19700,   15395,	// 10V,   20V,   50V
						20000,   19700,   15395 },	//100V,  200V,  500V

					       {16128,  15861,   15395,	//  1mV,   2mV,   5mV 
				     		16128,  15861,   15395,	// 10mV,  20mV,  50mV 
				     		16128,  15861,   15395,	//100mV, 200mV, 500mV
				     		16128,  15861,   15395,	//  1V,    2V,    5V
				     		16128,  15861,   15395,	// 10V,   20V,   50V
			             		16128,  15861,   15395 }};	//100V,  200V,  500V


const unsigned int predivisor[10] = { 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000 }; //BF probe division

//------------------------------------------------------------------------------------------------------

unsigned char ColorPalette = 0; 
				//	     black  33%   66%   100%
const unsigned char GridColorArray[10][4] = {{0x00, 0x15, 0x2A, 0x3F},	//white					     
					     {0x00, 0x01, 0x02, 0x03},	//red					     
					     {0x00, 0x04, 0x08, 0x0C},	//green					     
					     {0x00, 0x05, 0x0A, 0x0F},	//yellowconst unsigned int Splash_Logo_PosX = 275;
					     {0x00, 0x10, 0x20, 0x30},	//deep blueconst unsigned int Splash_Logo_PosY = 60;
					     {0x00, 0x14, 0x18, 0x2C},	//light blue
					     {0x00, 0x11, 0x12, 0x13},	//violetconst unsigned int Splash_Data_PosX = 200;
					     {0x00, 0x16, 0x17, 0x2B},	//pinkconst unsigned int Splash_Data_PosY = 200;
					     {0x00, 0x06, 0x0B, 0x1B},	//orange
					     {0x00, 0x15, 0x1A, 0x3F}};	//test white
					     

const int Splash_Logo_PosX = 275;
const int Splash_Logo_PosY = 60;

const int Splash_Data_PosX = 200;
const int Splash_Data_PosY = 200;					     
					     
//----------------------------------------------------------------------------------------
//		Filter
unsigned char FilterType = 1;					// type of noise filter -> 1 = proprietary / 2 = IIR  / 3 = FIR

//----------------------------------------------------------------------------------------

int32_t SignalMemSize = 600;	//BF #023
int32_t MemStartOffs = 50;
int32_t MemoryEnd  = 16000;
int32_t TrigPosMax = 4000;

//BF needed for calculation of triggerposition in memory window and 
//   draw factor calculation -> Hardware::RecalcTimeParameters()
const float ZoomFactorTable[36] = {  0.04,	//   2nS
				     0.10,	//   5nS
				     0.20,	//  10nS
				     0.40,	//  20nS
				     1.00,	//  50nS
				     2.00,	// 100nS
				     4.00,	// 200nS
				    10.00,	// 500nS
				    20.00,	//   1µS
				    20.00,	//   2µS
				    25.00,	//   5µS
				     5.00,	//  10µS
				     4.00,	//  20µS
				     5.00,	//  50µS
				     5.00,	// 100µS
				     4.00,	// 200µS
				     5.00,	// 500µS
				     5.00,	//   1mS
				     4.00,	//   2mS
				     5.00,	//   5mS
				     5.00,	//  10mS
				     4.00,	//  20mS
				     5.00,	//  50mS
				     5.00,	// 100mS
				     4.00,	// 200mS
				     5.00,	// 500mS
				     1.00,	//   1S
				     1.00,	//   2S
				     1.00,	//   5S
				     1.00,	//  10S
				     1.00,	//  20S
				     1.00,	//  50S
				     1.00,	// 100S
				     1.00,	// 200S
				     1.00,	// 500S
				     1.00};	//1000S

//BF #003 Delayed end timebase (MainTimebase - DelayedTimebase - 1)
const char Dm_Sel_Tb_End[26] =   {-1,	//   2nS -> n.a.
				   0,	//   5nS -> 2ns
				   1,	//  10nS -> 2ns
				   2,	//  20nS -> 2ns
			           3,	//  50nS -> 2ns
				   4,	// 100nS -> 2ns
				   4,	// 200nS -> 5ns
				   5,	// 500nS -> 5ns
				   5,	//   1µS -> 10ns
				   3,	//   2µS -> 
				   3,	//   5µS ->
				   1,	//  10µS ->
				   1,	//  20µS ->
				   1,	//  50µS ->
				   1,	// 100µS ->
				   1,	// 200µS ->
				   1,	// 500µS
				   1,	//   1mS
				   1,	//   2mS
				   1,	//   5mS
				   1,	//  10mS
				   1,	//  20mS
				   1,	//  50mS
				   1,   // 100mS
				   1,	// 200mS
				   1};	// 500mS



float ZoomFactor = 1;
float ZoomFactor_old = 1;
float ZoomFactorDel = 1;

//BF corrected register values for external trigger level #019
const int ExtTriggerLevel[103] = {0x40, 0x41, 0x42, 0x43,0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4A, 0x4B, 0x4C, 0x4D, 0x4E, 0x4F,
				  0x50, 0x51, 0x52, 0x53,0x54, 0x55, 0x56, 0x57, 0x58, 0x59, 0x5A, 0x5B, 0x5C, 0x5D, 0x5E, 0x5F,
				  0x60, 0x61, 0x62, 0x63,0x64, 0x65, 0x66, 0x67, 0x68, 0x69, 0x6A, 0x6B, 0x6C, 0x6D, 0x6E, 0x6F,
				  0x70, 0x71, 0x72, 0x73,0x74, 0x75, 0x76, 0x77, 
				  0x80,             0x83,0x84, 0x85, 0x86, 0x87, 0x88, 0x89, 0x8A, 0x8B, 0x8C, 0x8D, 0x8E, 0x8F,
				  0x90, 0x91, 0x92, 0x93,0x94, 0x95, 0x96, 0x97, 0x98, 0x99, 0x9A, 0x9B, 0x9C, 0x9D, 0x9E, 0x9F,
				  0xA0, 0xA1, 0xA2, 0xA3,0xA4, 0xA5, 0xA6, 0xA7, 0xA8, 0xA9, 0xAA, 0xAB, 0xAC, 0xAD, 0xAE, 0xAF,
				  0xB0};


/*BF del
const int Extern_Trigger_Values[33] = {0x40, 0x44, 0x48, 0x4C, 0x50, 0x54, 0x58, 0x5C, 0x60, 0x64, 0x68, 0x6C, 0x70, 0x74, 0x78, 0x7C,
                                       0x80, 0x84, 0x88, 0x8C, 0x90, 0x94, 0x98, 0x9C, 0xA0, 0xA4, 0xA8, 0xAC, 0xB0, 0xB4, 0xB8, 0xBC, 0xC0};
*/

/* del a factor  is used instead
//BF corrected values for external trigger level display output #019
const float ExtTriggerDispl[103] ={-11.300,-11.100,-10.900,-10.700,-10.500,-10.300,-10.150,-10.000, -9.800, -9.500, -9.200, -9.000, -8.800, -8.600, -8.400, -8.200,
				  -8.000, -7.800, -7.600, -7.400, -7.200, -7.000, -6.800, -6.600, -6.400, -6.200, -6.000, -5.800, -5.600, -5.400, -5.200, -5.000,
				  -4.750, -4.550, -4.350, -4.150, -3.950, -3.750, -3.550, -3.350, -3.150, -2.950, -2.750, -2.550, -2.340, -2.130, -1.930, -1.740,
				  -1.540, -1.300, -1.150, -0.950, -0.750, -0.550, -0.350, -0.100,  
				   0.000,                  0.100,  0.300,  0.500,  0.700,  0.910,  1.100,  1.300,  1.500,  1.700,  1.900,  2.100,  2.300,  2.500,
				   2.700,  2.900,  3.100,  3.300,  3.500,  3.700,  3.900,  4.100,  4.300,  4.500,  4.700,  4.900,  5.100,  5.300,  5.500,  5.700,
				   5.900,  6.100,  6.300,  6.500,  6.700,  6.900,  7.100,  7.300,  7.500,  7.700,  7.900,  8.100,  8.300,  8.500,  8.700,  8.900,
				   9.210};

*/				   
				   
/*BF del
const float Extern_Trigger_Strs[33] = {-2.5, -2.4, -2.2, -2.0, -1.8, -1.6, -1.5, -1.4, -1.3, -1.1, -1.0, -0.9, -0.8, -0.6, -0.4, -0.2,
                                        0.0,  0.2,  0.4,  0.6,  0.8,  0.9,  1.0,  1.1,  1.3,  1.4,  1.5,  1.6,  1.8,  2.0,  2.2,  2.4,  2.5};
*/
                                         
unsigned long tc_test_var = 0x00000000;
unsigned long tc_test_var2 = 0x00000000;

// testdata

unsigned char DrawSignal = 1;

unsigned char keyboard_found = 0;
unsigned long slope_value = 0;

double Test_Slip = 192.0;
int Test_Range = 1;

bool Transfer_man_data = false;
/*
0 = undetected
1 = no keyboard
2 = Power on Boot
3 = Reset on Boot
4 = Keyboard detected
*/

unsigned long *prog_flash_adr;
unsigned long prog_flash_adress;
unsigned char prog_flash_length;
unsigned long prog_flash_offset;
unsigned char Flash_Read_Buffer[1024];
unsigned long Flash_Protect_Buffer[128];
	
uint32_t config_loaded = false;

volatile uint32_t ConfigChanged = 0;

unsigned char GridColorArrayPos = 3;

unsigned char WT_Logo_Color_Val = 0x31;		//0x10 / 0x21 / 0x31 

//BF  ++++++++++++++++++++++  delete 
int TestInt = 0;
long TestLong = 0;

unsigned char Test_Mode      = false;
unsigned char ADC_Debug_Mode = false;     	// If true then printf ADC Debug information
unsigned char Debug_Mode     = false;         	// If true then printf Debug information
unsigned char Command_Mode   = false;         	// If true then printf Command information

//BF+++++++++++++++++++++++ delete

bool screen_sel = 0;
bool screen_sel_old = 1;

//unsigned char Splash_drawed = false;


volatile uint32_t ADC_Started = false;
uint8_t AutoFreeRun = false;

int HoldOff_Value = 0;
int HoldOff_Expo = 1;   //ns
int HoldOff_Steps = 8;

int Pulse11_Value = 16;
int Pulse11_Expo = 1;   //ns
int Pulse11_Steps = 8;

int Pulse12_Value = 8;
int Pulse12_Expo = 1;   //ns
int Pulse12_Steps = 8;

int Pulse21_Value = 16;
int Pulse21_Expo = 1;   //ns
int Pulse21_Steps = 8;

int Pulse22_Value = 16;
int Pulse22_Expo = 1;   //ns
int Pulse22_Steps = 8;

int math_scale     = 11;	//BF added -> 5V default
int math_mul_scale = 177;	//BF -> 5V
int math_sub_scale = 161;	//BF -> 5V 
int math_add_scale = 161;	//BF -> 5V

//BF added for new offset calculation
int Math_Offset     = 0;
int Math_Mul_Offset = 0;
int Math_Sub_Offset = 0;
int Math_Add_Offset = 0;

char Selected_Voltage_CH1_bak = 0;
char Selected_Voltage_CH2_bak = 0;
char Selected_Voltage_CH3_bak = 0;
char Selected_Voltage_CH4_bak = 0;

int ZeroLevelCH1_bak = 0;
int ZeroLevelCH2_bak = 0;
int ZeroLevelCH3_bak = 0;
int ZeroLevelCH4_bak = 0;

int Virtual_ZeroLevelCH1_bak = 0;
int Virtual_ZeroLevelCH2_bak = 0;
int Virtual_ZeroLevelCH3_bak = 0;
int Virtual_ZeroLevelCH4_bak = 0;

//BF added 
int ZeroLevelCH1_Main_bak = 0;
int ZeroLevelCH2_Main_bak = 0;
int ZeroLevelCH3_Main_bak = 0;
int ZeroLevelCH4_Main_bak = 0;
int Virtual_ZeroLevelCH1_Main_bak = 0;
int Virtual_ZeroLevelCH2_Main_bak = 0;
int Virtual_ZeroLevelCH3_Main_bak = 0;
int Virtual_ZeroLevelCH4_Main_bak = 0;

/*BF del -> integrated in new zero shift
//ADC-correction
int  alpha[4] = {0, 0, 0, 0};			// Y = beta * X + alpha	
float beta[4] = {1, 1, 1, 1};			// alpha -> zero offset, beta -> gain
*/


int Trigger_Pos_CH1_bak = 0;								// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2_bak = 0;								// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3_bak = 0;								// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4_bak = 0;

int AC_CH1_bak = 0;
int AC_CH2_bak = 0;
int AC_CH3_bak = 0;
int AC_CH4_bak = 0;

int draw_start  = 0;
int draw_factor = 0;
int draw_dm_ixstart = 0;
int draw_dm_ixfactor = 0;
int MainTimebase_bak;
uint32_t Run_bak;
int SingleShot_bak;

//int Rot_Time = 0;


//char testtoggle =0;


//BF new correction array
//  DAC_Correction[Set 1-4][Channel 1-4][VoltRange 1-3];
int DAC_Correction[4][4][3] = {{{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}},
			       {{400,520,400}, {400,520,400}, {400,520,400}, {400,520,400}}};


//--------------------------------------------------------------------------------------
// BF add
// Variables for new ultra slow timebase mode

short USTB_Mode     = 0;			//0 -> off , 1 -> roll mode, 2 -> shift mode
short USTB_Mode_bak = 0;
short USTB_Dir      = USTB_FORWARD;		//buffer storing direction
//short USTB_Dir_bak  = USTB_FORWARD;
short USTB_Disp     = USTB_PERM;		//display mode (permanent/step)
unsigned char USTB_NewData  = 0;		//flag to show if new data is available
int  USTB_idx               = 0;		//pointer to the actual time positien
int  USTB_EOSignal          = 0;		//end of signal

//--------------------------------------------------------------------------------------

int LED_ON[16];
//int LED_Buf = 0;

int Display_Line_Adresses[480];
//BF del not used int Display_Line_Adresses2[480];

//int *Display_Line_Adresses = (int *) 0x008DCA74;
//int *Display_Line_Adresses2 = (int *) 0x008DCE34;




///BF old USB functions -> can be deleted in future #017
volatile unsigned char uart2_buffer[64];
volatile unsigned char send_buffer[64];
//volatile char uart2_count;

//BF new designed USB functions #017
volatile int8_t UART2_rx_cnt;
volatile uint8_t UART2_rx_buffer[64];
volatile uint8_t UART2_tx_buffer[64];


// For clearing Channel and Math Plane Bit 1 - 5
uint8_t ClearPlane  = 0x00;
uint8_t DrawPlane   = 0x00;
uint8_t RemovePlane = 0x00;

uint32_t UpdateMarkerPlane = true;
uint32_t UpdateMenuTextPlane = true;


// Rotary
volatile int32_t RotaryDirection = 0;
volatile int32_t RotarySteps = 0;
int32_t RotaryDirectionMemPulse = 1;
int32_t RotarySwitch = 0;

volatile int32_t KeyboardMem = 0;
volatile int32_t KeyboardChanged = 0;

volatile int32_t ADC_DataAvailable = 0;

unsigned short SwitchesCH1;
unsigned short SwitchesCH2;
unsigned short SwitchesCH3;
unsigned short SwitchesCH4;

unsigned short SwitchesLMH[4]; 		//Jörg -> analog to SwitchesCHx

// Signal pointer
unsigned char *S1Ptr = 0;
unsigned char *S2Ptr = 0;
unsigned char *S3Ptr = 0;
unsigned char *S4Ptr = 0;
unsigned char *SMPtr = 0;

unsigned char *Signal[5];		// pointer to signals as array of pionters
uint8_t * Minimum[4];			// pointer to peak detect minimum memory
uint8_t * Maximum[4];			// pointer to peak detect maximum memory

unsigned long *Buffer_Mark1Plane = (unsigned long *) 0x008CA5F4; //0x008D3BF4;
unsigned long *Buffer_UI2Plane = (unsigned long *) 0x008D3BF4;

//BF not used unsigned char *SIGNAL_IntBuf = (unsigned char *) 0x008DD1F4;

// BF add QM changed by Stefan
int32_t *SIGNAL_Histo = (int32_t *) 0x008DD320;					//BF -> used for QM calculation

//----------------------------------------------------------------------------------------------------------------------------
// memory area 6000 Byte wide [0x008DDD20 - 0x008DF48F] for buffering interpolation and USTB values
unsigned char *SIGNAL1_Intpolate = (unsigned char *) 0x008DDD20;   	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL2_Intpolate = (unsigned char *) 0x008DE1D0;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL3_Intpolate = (unsigned char *) 0x008DE680;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL4_Intpolate = (unsigned char *) 0x008DEB30;	// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNALM_Intpolate = (unsigned char *) 0x008DEFE0;	// BF -> shared memory for Interpolation 1200 Byte

unsigned char *SIGNAL1_USTB = (unsigned char *) 0x008DDD20;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL2_USTB = (unsigned char *) 0x008DE1D0;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL3_USTB = (unsigned char *) 0x008DE680;   		// BF -> shared memory for USTB mode 1200 Byte
unsigned char *SIGNAL4_USTB = (unsigned char *) 0x008DEB30;   		// BF -> shared memory for USTB mode 1200 Byte
//unsigned char *SIGNALM_USTB = (unsigned char *) 0x008DEFE0;   		// BF -> shared memory for USTB mode 1200 Byte


//------------------------------------------------------------------------------------------------------------------------------
// memory area 6000 Byte wide [0x008DF490 - 0x008E0C0F] for buffering interpolation values
unsigned char *SIGNAL1_Intpolate_delayed = (unsigned char *) 0x008DF490;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL2_Intpolate_delayed = (unsigned char *) 0x008DF940;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL3_Intpolate_delayed = (unsigned char *) 0x008DFDF0;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNAL4_Intpolate_delayed = (unsigned char *) 0x008E02A0;// BF -> shared memory for Interpolation 1200 Byte
unsigned char *SIGNALM_Intpolate_delayed = (unsigned char *) 0x008E0750;// BF -> shared memory for Interpolation 1200 Byte



//-------------------------------------------------------------------------------------------------------------------------------

//BF -> used for overlay mode, peak detect maximum and fft values
unsigned char *SIGNAL1_Buffer = (unsigned char *) 0x008E0C00;	//BF -> 16384 Byte
unsigned char *SIGNAL2_Buffer = (unsigned char *) 0x008E4C00;	//BF -> 16384 Byte
unsigned char *SIGNAL3_Buffer = (unsigned char *) 0x008E8C00;	//BF -> 16384 Byte
unsigned char *SIGNAL4_Buffer = (unsigned char *) 0x008ECC00;	//BF -> 16384 Byte

//int *freq_re = (int *) 0x008E0C00	//4096 * 4 byte = 16384 byte -> shared memory for frequency values real -> declared local
//int *freq_im = (int *) 0x008E8C00;	//4096 * 4 byte = 16384	byte -> shared memory forFrequency values imaginary -> declared local

//-----------------------------------------------------------------------------------------------------------------------------

// BF free memory  16K [0x008F0C00 - 0x008F4BFF]
//int *tab    = (int *) 0x008F0C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F1C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F2C00;		//1024 * 4 = 4096	
//int *tab    = (int *) 0x008F3C00;		//1024 * 4 = 4096	

//-----------------------------------------------------------------------------------------------------------------------------
// ****** not used anymore *******
//BF -> read out buffer for reading ADC values in format long and char
// needs a little bit more than 16384 in normal TB, so the memory area
// below is overwritten sometimes (read out count is 5004 x 4 bytes in slow TB).
// This is no problem, because the memory area below is used for USTB
// only (read out count is 128). 
// Address is used hard coded in assembler routine READADC_ALL()!!! 
//unsigned long *readout_sigbuf = (unsigned long *) 0x008F4C00;			//16384 byte - 16k
//unsigned char *readout_sigbuf_char = (unsigned char *) 0x008F4C00;

//unsigned long *readout_sigbuf = (unsigned long *) 0x00917440;			//16384 byte - 16k
//unsigned char *readout_sigbuf_char = (unsigned char *) 0x00917440;

//------------------------------------------------------------------------------------------------------------------------------
//BF 0x008F8C00 - 0x00908C00  64k shared memory area -> can be used as memory for multiple purposes

// 0x008F8C00 - 0x008FCC00	-> 16384 byte - 16k
// 0x008FCC00 - 0x00900C00	-> 16384 byte - 16k
// 0x00900C00 - 0x00904C00	-> 16384 byte - 16k
// 0x00904C00 - 0x00908C00	-> 16384 byte - 16k

// FIR temporary buffer shared with USTB shift -> USTB and FIR filter are never active at the same time!
uint8_t *FIR_Buffer = (unsigned char *) 0x008F8C00;


// BF reserved when USTB is active! buffer for USTB shift / roll mode 
unsigned char *SHIFT_OFFS1 = (unsigned char *) 0x008F8C00;	//shift buffer 16k for channel 1 
unsigned char *SHIFT_OFFS2 = (unsigned char *) 0x008FCC00;	//shift buffer 16k for channel 2 
unsigned char *SHIFT_OFFS3 = (unsigned char *) 0x00900C00;	//shift buffer 16k for channel 3 
unsigned char *SHIFT_OFFS4 = (unsigned char *) 0x00904C00;	//shift buffer 16k for channel 4 
unsigned char *SHIFT_OFFSM = (unsigned char *) 0x00908C00;	//shift buffer 16k for math channel

unsigned char *ROLL_OFFS1 = (unsigned char *) 0x008F8C00;	//roll buffer 32k for channel 1 
unsigned char *ROLL_OFFS2 = (unsigned char *) 0x00900C00;	//roll buffer 32k for channel 2 

//-------------------------------------------------------------------------------------------------------------------------------
//BF 0x00908C00 - 0x0091CC00  80k shared memory area -> can be used as memory for multiple purposes

// also used for peak detect minimum

// BF complete 80k reserved when USTB is active!
unsigned char *ROLL_OFFS3 = (unsigned char *) 0x00908C00;	//roll buffer 32k for channel 3 
unsigned char *ROLL_OFFS4 = (unsigned char *) 0x00910C00;	//roll buffer 32k for channel 4 
unsigned char *ROLL_OFFSM = (unsigned char *) 0x00918C00;	//roll buffer 32k for channel math 

//BF -> low pass filtering in normal TB (shared memory)
unsigned char *Filter1_Buffer = (unsigned char *) 0x00908C00;	//BF -> 16384 Byte
unsigned char *Filter2_Buffer = (unsigned char *) 0x0090CC00;	//BF -> 16384 Byte
unsigned char *Filter3_Buffer = (unsigned char *) 0x00910C00;	//BF -> 16384 Byte
unsigned char *Filter4_Buffer = (unsigned char *) 0x00914C00;	//BF -> 16384 Byte
unsigned char *CopyBuffer     = (unsigned char *) 0x00918C00;	//BF -> 16384 Byte

//-------------------------------------------------------------------------------------------------------------------------------

//signal buffer
unsigned char *SIGNAL1 = (unsigned char *) 0x0091CC00;		//BF -> 16384 Byte
unsigned char *SIGNAL2 = (unsigned char *) 0x00920C00;		//BF -> 16384 Byte
unsigned char *SIGNAL3 = (unsigned char *) 0x00924C00;		//BF -> 16384 Byte
unsigned char *SIGNAL4 = (unsigned char *) 0x00928C00;		//BF -> 16384 Byte
unsigned char *SIGNALM = (unsigned char *) 0x0092CC00;		//BF -> 16384 Byte
int *SPECTRUM = (int *) 0x0092CC00;				// shared memory with math channel 

//-------------------------------------------------------------------------------------------------------------------------------

// buffer for the signal display layer 
unsigned long *Buffer_PlaneM = (unsigned long *) 0x00930C00; 		// 38400(char) = 9600(long) = 80 byte * 480 
unsigned long *Buffer_Plane1 = (unsigned long *) 0x0093A200;
unsigned long *Buffer_Plane2 = (unsigned long *) 0x00943800;
unsigned long *Buffer_Plane3 = (unsigned long *) 0x0094CE00;
unsigned long *Buffer_Plane4 = (unsigned long *) 0x00956400;


unsigned long *Planes = (unsigned long *) 0x0095FA00;			//Planes base address -> 16 * 38400 = 614400 byte = 153600(long)
unsigned long *UI_Plane1 = (unsigned long *) 0x0095FA00;		//white
unsigned long *UI_Plane2 = (unsigned long *) 0x00969000;		//black -> text plane
unsigned long *UI_Plane3 = (unsigned long *) 0x00972600;		//beige
unsigned long *UI_Plane4 = (unsigned long *) 0x0097BC00;		//yellow
unsigned long *UI_Plane5 = (unsigned long *) 0x00985200;		//dark gray

// signal display layer
unsigned long *Channel_Plane1 = (unsigned long *) 0x0098E800;		// yellow
unsigned long *Channel_Plane2 = (unsigned long *) 0x00997E00;		// green
unsigned long *Channel_Plane3 = (unsigned long *) 0x009A1400;		// blue
unsigned long *Channel_Plane4 = (unsigned long *) 0x009AAA00;		// red
unsigned long *Channel_Math_Plane = (unsigned long *) 0x009B4000;	// violet

// memory space for three buffer planes -> not displayed
unsigned long *Copy_Plane1 = (unsigned long *) 0x009BD600;
unsigned long *Copy_Plane2 = (unsigned long *) 0x009C6C00;
unsigned long *Copy_Plane3 = (unsigned long *) 0x009D0200;

unsigned long *Marker_Plane1 = (unsigned long *) 0x009D9800;		//light red
unsigned long *Marker_Plane2 = (unsigned long *) 0x009E2E00;		//light red

unsigned long *Grid_Plane = (unsigned long *) 0x009EC400;

//-------------------------------------------------------------------------------------------------------------------------------

//BF test for checking memory
//unsigned long *Dummy_Address = (unsigned long *) 0x009F5A00;


//Plane addresses with changed format
//long v_Buffer_PlaneM = 0x00930C00;
long v_Buffer_Plane1 = 0x0093A200;
long v_Buffer_Plane2 = 0x00943800;
long v_Buffer_Plane3 = 0x0094CE00;
long v_Buffer_Plane4 = 0x00956400;

long v_Channel_Plane1 = 0x0098E800;
long v_Channel_Plane2 = 0x00997E00;
long v_Channel_Plane3 = 0x009A1400;
long v_Channel_Plane4 = 0x009AAA00;
//long v_Channel_Math_Plane = 0x009B4000;

unsigned long *Text_Plane = (unsigned long *) 0x00969000;	// pointer to UI_Plane2 (black)


// BF QM thresholds
int32_t thres_type[5] = {0,0,0,0,0};
int32_t thres_low[5] = {0,0,0,0,0};
int32_t thres_mdl[5] = {0,0,0,0,0};
int32_t thres_up[5] = {0,0,0,0,0};

float thres_low_abs[5] = {0,0,0,0,0};
float thres_mdl_abs[5] = {0,0,0,0,0};
float thres_up_abs[5] = {0,0,0,0,0};

// BF add QM changed by Stefan
int32_t SIGNAL_MIN[5]={0,0,0,0,0};
int32_t SIGNAL_MDL[5] = {0,0,0,0,0};
int32_t SIGNAL_MAX[5] = {0,0,0,0,0};
int32_t SIGNAL_BASE[5] = {0,0,0,0,0};
int32_t SIGNAL_TOP[5] = {0,0,0,0,0};
int32_t SIGNAL_AVG[5] = {0,0,0,0,0};
int32_t SIGNAL_AVG_CNT[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_POSITIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_POSITIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_POSITIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_POSITIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_POSITIV_1[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_NEGATIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_NEGATIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_NEGATIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_NEGATIV_1[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_NEGATIV_1[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_POSITIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_POSITIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_POSITIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_POSITIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_POSITIV_2[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_NEGATIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_NEGATIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_NEGATIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_NEGATIV_2[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_NEGATIV_2[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_POSITIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_POSITIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_POSITIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_POSITIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_POSITIV_LAST[5] = {0,0,0,0,0};

int32_t SIGNAL_THRES_PRE_NEGATIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_LOW_NEGATIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_MDL_NEGATIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_UP_NEGATIV_LAST[5] = {0,0,0,0,0};
int32_t SIGNAL_THRES_OVER_NEGATIV_LAST[5] = {0,0,0,0,0};


int32_t DelayedTimebase;						// Selected Timebase in delayed mode
int dmode_Cursor_Vertical_Position1_Old;
int dmode_Cursor_Vertical_Position2_Old;
int dmode_QM_Vertical_Position1_Old;
int dmode_QM_Vertical_Position2_Old;
int dmode_Window_Offset_Pos;
int dmode_Window_Offset_Pos_Old;

float Timebase_Ratio = 1.0;

int Cursor_Delayed_1     = 180;
int Cursor_Delayed_2     = 420;
int Cursor_Delayed_Size  = 300;
int Cursor_Delayed_1_Old = 180;
int Cursor_Delayed_2_Old = 420;

unsigned char buf_arr[600];

//------------------------------------------------------------------------------------------------------------------

unsigned int GainIdx = 1;	//BF Index 0-4 to choose the preamp gain below

//BF floating point scale factor is used for amplitude calculation
				//   gain 1.25  LB-Mod  OPA653  24.9/180 Addon PCB	200 Ohm
const float ScaleFactorTable[2][5] = { 	{2.620, 1.995,  2.042,   3.450,  1.822},    // 1er/2er
					{2.100, 1.616,  1.654,   2.750,  1.799} };  // 5er					


float ScaleFactor[16];
	    
//BF scale index for 1er/2er ranges (index 0) and 5er ranges (index 1)
char ScaleIndexTable[16] = { 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0, 0, 1, 0 };


// lookup values for 1er/2er ranges scale index 0, 5er ranges - scale index 1
// will be initialized at startup sequence
int32_t ScaleLookupTable[260][3];

// scaling correction factor for each FFT mode
//		FFT_MAGN / FFT_PHAS / FFT_REAL / FFT_IMAG / FFT_REIM /  FFT_PWSP / FFT_PWDN
float FFT_ScaleCorrection[16][7] = {{ 1.100, 1.000, 1.000, 1.000, 1.000, 0.200, 1.000 },  //  1mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  2mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  5mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 10mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 20mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  // 50mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //100mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //200mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //500mV
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.500, 1.000 },  //  1V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.550, 1.000 },  //  2V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 0.650, 1.000 },  //  5V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  10V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  20V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 },  //  50V
				    { 1.100, 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 }}; //  100V

// FFT lookup values -> will be initialized at startup sequence
short FFT_ScaleLookupTable[256];


//BF scale factors for zero shift in zero level handler -> UserIF::ON_Zero_Channel_x()
		
				// 	gain 1.25 LB_Mod  OPA653  24.9/180 Addon PCB	
const float DAC_ScaleFactorTable[3][5] = {{ 2.480,  2.520,  3.100,  2.480, 16.361 },	// 1er ranges
					  { 4.940,  5.050,  6.100,  4.940, 30.503 },	// 2er ranges
					  {12.360, 12.550, 15.100, 12.360, 76.505 }};	// 5er ranges
					 


float DAC_ScaleFactor[3];

//--------------------------------------------------------------------------------------------------------------------------------
/* FIR sinc interpolation */

int32_t FIR_SincLookup[256][5][9];
const int16_t FIR_Coeff[5][9] = {{   9, -12,  18, -34, 244,  48, -22,  14, -10},
				 {  16, -21,  30, -52, 211, 105, -42,  26, -19},
				 {  18, -23,  32, -54, 163, 163, -54,  32, -23},
				 {  15, -19,  26, -42, 105, 211, -52,  30, -21},
				 {   8, -10,  14, -22,  48, 244, -34,  18, -12}};



//--------------------------------------------------------------------------------------------------------------
//BF -> declarations for Math FFT function
unsigned char MATH_Mode = MATH_OFF; 

//unsigned char FFT_Mode = FFT_OFF; 
unsigned char FFT_NewData = 0;
//BF not needed anymore int FFT_Scale  = 2;		// scaling will be made in drawing routine

int FFT_NormENBW;		//Equivalent Noise Bandwidth normed to delta frequency in dB


//int FFT_Win512[512];

short FFT_TriggerMode_bak;

//char FFTToggle  = 0;						// for switching between Scale and Offset
//FloatStr FFT_Scale_Str;					//create FloatStr instance
//FloatStr FFT_Offset_Str;					//create FloatStr instance

float FFT_ENBW[6] = { 1.000, 1.000, 1.000, 1.000, 1.000, 1.000 };

unsigned char FFT_Layout = 0; 
FloatStr FFT_Status_Str;




//logarithm table for log10(x) prescaled to integer screen size with factor 153,9  
short int iLog10[481] = {   0,  0, 46, 73, 93,107,120,130,139,147,
			  154,160,166,171,176,181,185,189,193,197,
			  200,203,206,209,212,215,218,220,222,225,
			  227,229,231,233,235,237,239,241,243,245,
			  246,248,250,251,253,254,256,257,258,260,
			  261,262,264,265,266,268,269,270,271,272,
			  273,274,276,277,278,279,280,281,282,283,
			  284,285,286,286,287,288,289,290,291,292,
			  293,293,294,295,296,297,297,298,299,300,
			  300,301,302,303,303,304,305,305,306,307,
			  307,308,309,309,310,311,311,312,313,313,
			  314,314,315,316,316,317,317,318,318,319,
			  320,320,321,321,322,322,323,323,324,324,
			  325,325,326,326,327,327,328,328,329,329,
			  330,330,331,331,332,332,333,333,334,334,
			  335,335,335,336,336,337,337,338,338,338,
			  339,339,340,340,340,341,341,342,342,342,
			  343,343,344,344,344,345,345,346,346,346,
			  347,347,347,348,348,349,349,349,350,350,
			  350,351,351,351,352,352,352,353,353,353,
			  354,354,354,355,355,355,356,356,356,357,
			  357,357,358,358,358,359,359,359,359,360,
			  360,360,361,361,361,362,362,362,362,363,
			  363,363,364,364,364,364,365,365,365,366,
			  366,366,366,367,367,367,368,368,368,368,
			  369,369,369,369,370,370,370,370,371,371,
			  371,371,372,372,372,373,373,373,373,374,
			  374,374,374,374,375,375,375,375,376,376,
			  376,376,377,377,377,377,378,378,378,378,
			  379,379,379,379,379,380,380,380,380,381,
			  381,381,381,381,382,382,382,382,383,383,
			  383,383,383,384,384,384,384,384,385,385,
			  385,385,386,386,386,386,386,387,387,387,
			  387,387,388,388,388,388,388,389,389,389,
			  389,389,390,390,390,390,390,391,391,391,
			  391,391,391,392,392,392,392,392,393,393,
			  393,393,393,394,394,394,394,394,394,395,
			  395,395,395,395,396,396,396,396,396,396,
			  397,397,397,397,397,397,398,398,398,398,
			  398,398,399,399,399,399,399,399,400,400,
			  400,400,400,400,401,401,401,401,401,401,
			  402,402,402,402,402,402,403,403,403,403,
			  403,403,404,404,404,404,404,404,405,405,
			  405,405,405,405,405,406,406,406,406,406,
			  406,407,407,407,407,407,407,407,408,408,
			  408,408,408,408,408,409,409,409,409,409,
			  409,409,410,410,410,410,410,410,410,411,
			  411,411,411,411,411,411,412,412,412,412,
			  412 };


//BF del short LogicData[32];

//BF not used char USB_Connected = false;
char USB_Data_Trans;
char USB_SendAllData;
char USB_At_Startup = false;
char USB_OnlyTrigger;

char USB_Data_Requested = false;

char RS232_Data_Requested = false;
unsigned char RS232_ContData_ReqMask = 0;
char RS232_ScreenShot_Requested = false;

uint32_t Run;
uint32_t SingleShot = 0;
volatile uint32_t ButtonChanged = 0;

char SavePointer = 1;
short led_status;									// Stores the LED Port Bits;
char ScreenShotActive;									// is 1 when sending screen shot

char PopUpPosition;
char PopupTimeCounter;									// Counter for Popup Pulldown

char TriggerLevelChanged = 1;								// Was Triggerlevel changed
char TriggerModeChanged = 1;								// Was Triggermode changed
char TriggerWayChanged = 1;								// Was Triggerway changed
char TimebaseChanged = 1;								// Was Timebase changed

volatile uint32_t TriggerLevelActive = 0;						// Is triggerlevel line drawing active?
char TimeOffsetActive = 0;								// Is Time_Offset selected ?
char StatusBtnRemove = 0;								// remove button
char VoltageChangedCh1 = 1;								// Voltage changed
char VoltageChangedCh2 = 1;								// Voltage changed
char VoltageChangedCh3 = 1;								// Voltage changed
char VoltageChangedCh4 = 1;								// Voltage changed
int32_t VS_ZeroLevelChanged = 0;							//BF -> change flag for Zero sign drawing
int32_t VS_TrigLevelChanged = 0;							//BF -> change flag for Zero sign drawing

uint32_t NumberOfChannels = 4;

uint32_t Channels_Active;

uint32_t ChannelStatusOld[5];

int32_t VirtualTimebase;									// Virtual Timebase -> in Stop mode 
int32_t MainTimebase;										// Timebase Index
						
char XY_Mode = 0;     										// Selected Normal or XY-Mode
//  0 - Normal , 1 = XY-Mode

int32_t PreTrigComp;										// Pretrigger compensation

/** New Trigger Values**/
int Trig_Pos_Mem           = 300;                                     				// Store the Triggerposition in Memory
int Trig_Pos_Display       = 300;                                 				// Store the Triggerposition on Display
int Trig_Pos_Display_dmode = 300;                           					// Store the Triggerposition on Display in delayed mode
int MemWinStart           = -300;                    						// Memory Windows start offset
int32_t PeakMemOffs = 0;


int Trig_Pos_Mem_old           = 300;                                     			// Store the Triggerposition in Memory
int Trig_Pos_Display_old       = 300;                                 				// Store the Triggerposition on Display
int Trig_Pos_Display_dmode_old = 300;                           				// Store the Triggerposition on Display in delayed mode
int MemWinStart_old           = -300;                                    			// Memory Windows start offset

// delayed fehlt noch


char TriggerWay;
char TriggerWay_bak;										// Stores the way to trigger
// 1 - Edge / 2 - Pulse / 3 - Pattern / 4 - More

//char TriggerSource;										// Stores the active trigger channel
//char Selected_Trigger_Source_Old;								// Stores the Channel who Trigger Old
// 1 - 4 Channels / 5 - External / 6 - Line



volatile uint32_t CombiTriggerWaitTime = 0; 							//needed for combi-trigger; measures time in ms, since last trigger
volatile uint32_t CombiTriggerStatus = 0;							//0=normal-Mode, 1=AutoMode-first-time, 2=AutoMode-FreeRun
volatile uint32_t CombiTimingCounter;

//char TiggerLevelLine;										// If 1 then Draw Trigger Level Line
int Trigger_Pos_CH1;										// Stores the Trigger Position on Channel 1
int Trigger_Pos_CH2;										// Stores the Trigger Position on Channel 2
int Trigger_Pos_CH3;										// Stores the Trigger Position on Channel 3
int Trigger_Pos_CH4;										// Stores the Trigger Position on Channel 4
int Trigger_Pos_CHE;										// Stores the Trigger Position on External

int Trigger_Pos_CH1_Old;									// Stores the old Trigger Position on Channel 1
int Trigger_Pos_CH2_Old;									// Stores the old Trigger Position on Channel 2
int Trigger_Pos_CH3_Old;									// Stores the old Trigger Position on Channel 3
int Trigger_Pos_CH4_Old;									// Stores the old Trigger Position on Channel 4
int Trigger_Pos_CHE_Old;									// Stores the old Trigger Position on External

// ZeroLine in virtual screen with hight 0 - 16383 pixels 8192 is middle
int Virtual_ZeroLevelCH1;
int Virtual_ZeroLevelCH2;
int Virtual_ZeroLevelCH3;
int Virtual_ZeroLevelCH4;

//BF -> 0 - 400 pixels, 200 is middle now!
int ZeroLevelCH1;
int ZeroLevelCH2;
int ZeroLevelCH3;
int ZeroLevelCH4;

int Virtual_ZeroLevelXYCH1;
int Virtual_ZeroLevelXYCH2;
int Virtual_ZeroLevelXYCH3;
int Virtual_ZeroLevelXYCH4;

int ZeroLevelCH1_Old;
int ZeroLevelCH2_Old;
int ZeroLevelCH3_Old;
int ZeroLevelCH4_Old;

char Selected_Voltage_CH1;								// Selected Voltage_CH1
char Selected_Voltage_CH2;								// Selected Voltage_CH2
char Selected_Voltage_CH3;								// Selected Voltage_CH3
char Selected_Voltage_CH4;								// Selected Voltage_CH4

char SelectedCursor;										// Which Cursor is selected
char SelectedCursorOld;										// Which Cursor was selected

char Cursor_Enabled;
char Cursor_Enabled_Old;
char CursorChanged;										// Was Cursor changed

char Cursor_XY_Selected;									// 0 = X selected, 1 = Y selected
char Cursor_XY_Selected_Old;									// 0 = X selected, 1 = Y selected

char Cursor_Both_Selected;
char Cursor_Both_Selected_Old;

char Cursor_Horizontal_Active; 									// 0 = Off
char Cursor_Horizontal_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected

												// 4 = Active and both selected

long Cursor_Horizontal_Position_Real1;								// Store Real Cursor Position
long Cursor_Horizontal_Position_Real2;								// Store Real Cursor Position

long Cursor_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long Cursor_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char Cursor_Vertical_Active;									// 0 = Off
char Cursor_Vertical_Active_Old;								// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
//long Cursor_Vertical_Position1;								// Store Cursor vertical I position
//long Cursor_Vertical_Position2;								// Store Cursor vertical II position
												// 4 = Active and both selected

//long Cursor_Vertical_Position_Real1;								// Store Real Cursor Position
//long Cursor_Vertical_Position_Real2;								// Store Real Cursor Position

//long Cursor_Vertical_Position1_Old;								// Store old Cursor vertical I position
//long Cursor_Vertical_Position2_Old;								// Store old Cursor vertical II position

long Cursor_Vertical_Position_TY_1;								// Store Cursor Position
long Cursor_Vertical_Position_TY_2;								// Store Cursor Position

long Cursor_Vertical_Position_XY_1;								// Store Cursor Position
long Cursor_Vertical_Position_XY_2;								// Store Cursor Position

long Cursor_Vertical_Position_FFT_1;								// Store Cursor Position
long Cursor_Vertical_Position_FFT_2;								// Store Cursor Position


long Cursor_Vertical_Position1_Old;								// Store old Cursor vertical I position
long Cursor_Vertical_Position2_Old;								// Store old Cursor vertical II position

char Cursor_Data_Draw_Pos = 0;									// Stores the draw position of the cursor data
char Cursor_Data_First_Draw = 0;								// Is it draw first time ?

char QM_Enabled;
char QM_Enabled_Old;
char QM_Changed[3];										// Was quick measurment changed
char QM_Type[3];                                   					        // What type of measurment (look 1313 -> 52 ...
//char QM_Type_Old[3];                                      					// What type of measurment (look 1313 -> 52 ...
char QM_Channel[3];                                         					// measurement slot
char QM_Second_Channel[3];									// For delay / phase measurment
char QM_CHI_Edge[3];                                        					// For delay  measurment // 1 = positiv , 2 = negativ
char QM_CHII_Edge[3];                                       					// For delay  measurment // 1 = positiv , 2 = negativ

short QM_Source;										// main QM source channel

char BufPre[30];
char BufUnit[10];
char BufReturn[30];

char QM_V_A_Buf[1];
char QM_H_A_Buf[1];
    
char QM_Horizontal_Active; 									// 0 = Off
char QM_Horizontal_Active_Old;							     		// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Horizontal_Position_Real1;								// Store Real Cursor Position
long QM_Horizontal_Position_Real2;								// Store Real Cursor Position

long QM_Horizontal_Position1_Old;								// Store old Cursor horizontal I position
long QM_Horizontal_Position2_Old;								// Store old Cursor horizontal II position

char QM_Vertical_Active;									// 0 = Off
char QM_Vertical_Active_Old;									// 1 = Active and one selected
												// 2 = Active and two selected
												// 3 = Active and none selected
												// 4 = Active and both selected

long QM_Vertical_Position_Real1;								// Store Real Cursor Position
long QM_Vertical_Position_Real2;								// Store Real Cursor Position

long QM_Vertical_Position1_Old;									// Store old Cursor vertical I position
long QM_Vertical_Position2_Old;									// Store old Cursor vertical II position

char Quick_Measure_Data_Draw_Pos = 0;								// Stores the draw position of the cursor data
char Quick_Measure_First_Draw = 0;								// Is it draw first time ?

char Quick_Measure_Threshold_btn_select;

//Memory Browser depended
char Memory_Window_visible = false;
int mb_window_start_old = 0;
int mb_window_stop_old = 0;
int mb_window_trigger_old = 0;
int mb_window_cursor1_old = 0;
int mb_window_cursor2_old = 0;


/*   Create FloatStr objects   */
FloatStr Pulse11;
FloatStr Pulse21;
FloatStr Pulse12;
FloatStr Pulse22;

FloatStr Cursor_Delta_X;	
FloatStr Cursor_Delta_1X;
FloatStr Cursor_Delta_XY_X;
FloatStr Cursor_Delta_Y;

FloatStr FFT_Cursor_Delta_X;	
FloatStr FFT_Cursor_Delta_1X;
//FloatStr FFT_Cursor_Delta_XY_X;
FloatStr FFT_Cursor_Delta_Y;

FloatStr Cursor_Vertical_Pos_1_Str;
FloatStr Cursor_Vertical_Pos_2_Str;

FloatStr FFT_Cursor_Vertical_Pos_1_Str;
FloatStr FFT_Cursor_Vertical_Pos_2_Str;

FloatStr Cursor_Vertical_Pos_XY_1_Str;
FloatStr Cursor_Vertical_Pos_XY_2_Str;
/*
FloatStr FFT_Cursor_Vertical_Pos_XY_1_Str;
FloatStr FFT_Cursor_Vertical_Pos_XY_2_Str;
*/	
FloatStr Cursor_Horizontal_Pos_1_Str;
FloatStr Cursor_Horizontal_Pos_2_Str;

FloatStr FFT_Cursor_Horizontal_Pos_1_Str;
FloatStr FFT_Cursor_Horizontal_Pos_2_Str;


FloatStr QM_Slot1;
FloatStr QM_Slot2;
FloatStr QM_Slot3;

FloatStr QM_Threshold_lower;
FloatStr QM_Threshold_middle;
FloatStr QM_Threshold_upper;

//BF del FloatStr Math_Offset;

FloatStr Math_Offset_mul;
FloatStr Math_Offset_sub;
FloatStr Math_Offset_add;

FloatStr Zero_Level1_Str;
FloatStr Zero_Level2_Str;
FloatStr Zero_Level3_Str;
FloatStr Zero_Level4_Str;

FloatStr Trigger_Level_Str;
FloatStr Trigger_ExtLevel_Str;

//FloatStr Timebase_Offset_Str;  // unused
FloatStr Trigger_Offset_Str;
FloatStr HoldOff;


//********************************************************************************************************************************************************************************************************************************


						//***************************************************
						//                     Menu
						//***************************************************

unsigned char MenuBtnFocus[32];					// focus for one of the 6 buttons in every menu

char MenuPopupChanged = 0;					// When 1 then is changed
char MenuPopupActive = -1;					// Stores the actual Menupopup

char MenuItemChanged[6] = {0, 0, 0, 0, 0, 0};
char MenuItemPushed[6] = {0, 0, 0, 0, 0, 0};			// When Menuitem is pushed

char MenuAktive = 1;                        			// flag for menu status
char MenuAktive_old = 1;                                   	// backup for active flag

int MenuPopupX;							// used for drawing popups -> store data global for next function
int MenuPopupY;							// used for drawing popups -> store data global for next function
int MenuPopupSizeX;						// used for drawing popups -> store data global for next function
int MenuPopupSizeY;						// used for drawing popups -> store data global for next function

int MenuTimeCounter;						// Counter for Menu Pulldown

char MenuItemCount;						// Store the count of the Menuitems
char MenuOldItemCount;						// Store the count of the old Menuitems


// New Menu Vars
char New_Menu     = -1;
char Active_Menu  = -1;
char Menu_Changed = -1;
char Menu_First_Draw = 1;


//BF -> horizontal (X) drawing offset for button text (first line -> caption)
//  -> a Value greater than 0 displays the button in the menu
unsigned short MenuItemDef[32][6] ={{30,28,22, 7,10, 0},	// 00 ACQUIRE : Logic /Average / Noise Filter / Interpolation
				    {25,21,30,26,25,20},	// 01 CHANNEL I   : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {25,21,30,26,25,20},	// 02 CHANNEL II  : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {25,21,30,26,25,20},	// 03 CHANNEL III : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {25,21,30,26,25,20},	// 04 CHANNEL IV  : Coupling / BW Limit / Invert / Probe / Center Channel / Dispatch Channels
				    {10,32,36, 5, 5,30},	// 05 Display : Persist / Clear Display / Grid / No Display / Draw Mode / Setup Submenu
 				    {27,22,20, 5,10,30},	// 06 Utility : About Oszi / Default Setup / Calibrate Offsets / Calbration Set / Test Signal / More
				    {31,31,23,20, 0, 0},	// 07 Service : Start User Cal / Start Self Test / User Cal Status / RS-232 Setup
				    {30,33,29,25,32,22},	// 08 Save / Recall : Memory / Save / Recall Trace / Overlay /Clear Display /Restore settings
				    { 5, 5, 5,10,35,16},	// 09 Display submenu
				    {36,23,37,37,23,25},	// 10 Timebase : Main / Delayed / X - Y / FFT / Browse / USTB-submenu
				    { 0, 0, 0, 0, 0, 0},	// 11 Delayed Timebase :
				    {22,13,26,26,26,30},	// 12 Trigger Mode : Mode / Coupling / Auto Level / Holdoff / External Probe	BF deactivated Reject #019
				    {20,20,10,20, 6, 6},	// 13 Trigger sub menu: LED1 / LED2 / LED map to Ch3+4 / Force Trigger / Pre Trigger Setup / Trigger Level Setup
				    {26,11,15,19,26,26},	// 14 Trigger Edge : Rising / Falling / Trigger 1-4 / Extern/Line / TV CH1 / PreTrigger / Auto Level
				    {11,32,13,36,36,26},	// 15 Pulse Width : Source / Pulse / Dir / Lower / Bigger
				    {11,41,41,41,41,35},	// 16 Cursor X : Source, X1, X2, Y1, Y2, X1X2/Y1Y2
				    {25,25,25,25,30, 2},	// 17 Quick Print : BMP / PGM / CSV / ASCII / n.a / Destination 
				    { 2,10,35,10,20,40},	// 18 Hardware Settings #004 ADC-Register / Pre Amp Gain / ADC Driver / LED Test 
				    {11,34,23,31,20,12},	// 19 Quick Measurment : Source, Select, Measure Delay, Clear Meas, Settings, Thresholds
				    {11,26,11,26,18,16},	// 20 QM Settings Delay : Source, Edge, Source, Edge, Measure Delay
				    {11, 0,11, 0,18,16},	// 21 QM Settings Phase : Source, Edge, Source, Edge, Measure Delay
				    {11,11,36,36,36,16},	// 22 QM Thresholds : Source , Type, Lower, Middle, Upper
				    {31,25,20, 7, 0, 0},	// 23 Autoscale : Undo / Search Slow / Save / Setup
				    {31,22,21,31,28, 0},	// 24 Trigger Mode TV : Mode, Pos / Neg , Standard, Mode, Count
				    {22,22,22,22,15,40},	// 25 Extended Utilities CH1...CH4 delay, Hardware Menu   BF #001 #004
				    {32,28,35,35,35, 0},	// 26 Math : Scale /   / 1 * 2 / 1 - 2 / 1 + 2
				    {30,30,30,30, 0,31},	// 27 FFT Settings : Source / Window / Mode / Length
				    {27,32,36,25, 0,30},	// 28 Display FFT 
				    {32, 0, 0, 0, 0,16},	// 29 Math Settings -> not used anymore
				    {15,15,15, 0, 0,16},	// 30 USTB
				    {25,25,25, 0, 0, 2}};	// 31 Quick Print USB-Export


// BF menu button text -> first line (caption)
unsigned char MenuItem[32][6][16] = {{{"Logic"},{"Average"},{"Noise Filter"},{"Interpolation"},{"Peak Detect"},{""}},	//  0 ACQUIRE
				     {{"Coupling"},{"BW Limit"},{"Invert"},{"Probe ["},{"Center"},{"Dispatch"}},	//  1 CHANNEL 1
				     {{"Coupling"},{"BW Limit"},{"Invert"},{"Probe \\"},{"Center"},{"Dispatch"}},	//  2 CHANNEL 2
				     {{"Coupling"},{"BW Limit"},{"Invert"},{"Probe ]"},{"Center"},{"Dispatch"}},	//  3 CHANNEL 3
				     {{"Coupling"},{"BW Limit"},{"Invert"},{"Probe ^"},{"Center"},{"Dispatch"}},	//  4 CHANNEL 4
				     {{"{ Persistent"},{"Clear"},{"Grid"},{"{No Display"},{"{Draw Mode"},{"Setup"}},    //  5 DISPLAY
				     {{"About"},{"Default"},{"Calibrate"},{"{Calibration"},{"Test Signal"},{"More"}},	//  6 Utility 
				     {{"Start"},{"Start"},{"User Cal"},{"RS-232"},{""},{""}},				//  7 Service Menu n.a.
				     {{"Memory"},{"Save"},{"Recall"},{"Overlay"},{"Clear"},{"Restore"}},		//  8 Save / Recall
				     {{"{Grid Color"},{"{Grid Lines"},{"{  Status"},{"QM Cursors"},{"OSS"},{""}},	//  9 Display Setup Submenu
				     {{"Main"},{"Delayed"},{"X - Y"},{"FFT"},{"Browse"},{"USTB"}},			// 10 Timebase 
				     {{""},{""},{""},{""},{""},{""}},							// 11 n.a.
				     {{"{   Mode"},{"{ Coupling"},{"Trigger"},{"Holdoff"},{"Probe `"},{"More"}},	// 12 Trigger Mode
				     {{"{ LED 1"},{"{ LED 2"},{"Ch 3/4 LED"},{"{ Force"},{"{Pre Trigger"},{"{Trig Level"}},// 13 Trigger sub menu
				     {{"}         ~"},{"{ Source"},{"{ External"},{"{ TV  ["},{"Adjust"},{"PreTrig"}},	// 14 Edge 
//BF -> no negative Pulse	     {{"{ Source"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"@ t"}}, 		// 15 Pulse Width
				     {{"{ Source"},{Space, Space, Space, Space, Pos_Pulse, Space, Space, Space, Space, Space},{Big_Smaller, Space, Space, Space, Space, Big_Bigger, Space, Space, Space, Space, Big_Bigger, Big_Smaller},{Big_Smaller},{Big_Bigger},{"PreTrig"}},			// 15 Pulse Width
				     {{"{  Source"},{"X1"},{"X2"},{"Y1"},{"Y2"},{"X1   X2"}}, 				// 16 Cursor X
				     {{"Save to"},{"Save to"},{"Save to"},{"Save to"},{"Send"},{"{ Destination"}}, 	// 17 Quick Print 
				     {{"{ ADC Setup"},{"{ Pre Gain"},{"Gain"},{"ADC Driver"},{"LED Test"},{""}}, 	// 18 Hardware #004
				     {{"{ Source"},{"Select:"},{"Measure"},{"Clear"},{"Setting"},{"Thresholds"}},	// 19 Quick Measurment
				     {{"{ Source1"},{"}        ~"},{"{ Source2"},{"}        ~"},{"Measure"},{""}},	// 20 Quick Measurment Delay Settings
				     {{"{ Source1"},{""},{"{ Source2"},{""},{"Measure"},{""}},		                // 21 Quick Measurment Phase Settings
				     {{"{ Source"},{"{ Type"},{"Lower"},{"Middle"},{"Upper"},{""}},			// 22 Quick Measurment Thresholds
				     {{"Undo"},{"Search"},{"Save new"},{"{ TB Search"},{""},{""}},		        // 23 Autoscale
				     {{"Mode"},{Pos_Pulse, Space, Space, Space, Space, Space, Space, Space, Space, Space, Neg_Pulse},{"Standard"},{"Mode"},{""},{""}},	// 24 Trigger Mode TV
				     {{"CH1 Delay"},{"CH2 Delay"},{"CH3 Delay"},{"CH4 Delay"},{"Hardware"},{""}},	// 25 Extended Utilities BF #001
				     {{"Scale"},{"Offset"},{"1  *  2"},{"1  -  2"},{"1  +  2"},{""}},  			// 26 Math	
				     {{"Source"},{"Window"},{"Mode"},{"Length"},{""},{""}},              		// 27 FFT Settings
				     {{"Persist"},{"Clear"},{"Grid"},{"Switch"},{"Display"},{"Setup"}},			// 28 Display FFT 
				     {{"Scale"},{"Offset"},{""},{""},{""},{""}},					// 29 Math Settings
				     {{"{  Mode"},{"{ Display"},{"{ Buffer"},{""},{""},{""}},				// 30 USTB
				     {{"Save to"},{"Save to"},{"Save to"},{""},{""},{"{ Destination"}}};		// 31 Quick Print USB-export

unsigned char MenuEdgeBufText[7] = 	{"{     "};


// [MenuData] //BF -> print offset in pixel for second line in menu button		
unsigned short MenuDataDef[370] = {36, 36, 21, 61,				//   0
				   41, 41, 					//   4
				   31, 36, 36, 					//   6
				   36, 36, 					//   9
				   36, 36, 					//  11
				   36, 36, 36, 36, 36, 				//  13
				   22, 16,  8, 					//  18
				   19, 19, 19,					//  21
				   19, 20, 23,					//  24
				   50, 46, 46, 46, 33,				//  27
				   23, 24, 26,					//  32
				   31, 20, 26,					//  35
				   21, 21, 28, 27,				//  38
				   27, 20, 15,					//  42
				   15, 35, 15, 15,				//  45
				   40, 15, 10,					//  49	//  QM Thresholds -> 27 Type
				   16, 28, 10, 22,				//  52	//  4 Quick Measurement Select	
				   14, 18, 18,					//  56	//  4 Quick Measurement Select	
				   13, 30, 30,					//  59	//  4 Quick Measurement Select
				   20, 35, 25, 25,				//  62	//  4 Quick Measurement Select
				   15, 15, 25, 25,				//  66	// 31 FFT Mode
				   8,  5,  5,  5,				//  70  // 31 FFT Mode
				   46, 46, 46, 46, 43, 43, 43,			//  74
				   40, 40, 40, 36, 36,				//  81
				   36, 36, 30,					//  86
				   24, 24,					//  89
				   25, 31, 26, 26,				//  91  // 9 Trigger Mode
				   25, 25, 20, 20,				//  95
				   22, 25,					//  99	// 23 Autoscale
				   31, 31, 31,					// 101
				   31, 31, 31,					// 104
				   31, 31, 31,					// 107
				   31, 31, 31, 31,				// 110
				   35, 20, 35, 20, 20,				// 114	// LED 1 green
				   35, 20, 15, 35, 20,				// 119	// LED 2 red
				   35,  5,  8, 35,				// 124 // Trigger submenu - Force Trigger
				   15, 15, 30, 15, 15,				// 128	//BF External Trigger + TV Trigger #019
				   41, 37, 36, 33, 				// 133
				   45, 41, 41, 41, 32, 32, 35,			// 137	// Trigger Source BF #019
				   25, 29, 29, 36,	              	  	// 144
				   36, 36, 36, 30, 30,	               	 	// 148	// BF Quick Print
				   33, 32, 32, 31, 30,	                	// 153	
				   30, 42, 41, 41, 39,	                	// 158	
				   38, 38, 36, 34, 33,	                	// 163	
				   33, 32, 31, 31, 25,	                	// 168	
				   24, 24, 40, 39, 39,	                	// 173	
				   35, 34, 34, 32, 21,	                	// 178	
				   25, 13, 40, 15, 0,	                	// 183	// BF #006
				   20, 25, 32, 20, 25,	                	// 188	// BF print offset for new entries in Utility menu (188, 189, 190, 191 )
				   15, 20, 21, 21, 15 ,				// 193 	// FFT -> items für the windows
				   15, 21, 20, 27, 25,				// 198  
				   30, 30, 30, 30, 30, 30, 30,			// 203 	//BF #001
				   30, 30, 30, 25, 25, 25, 25,			// 210 	//BF #001
				   25, 25, 25,  0,  0,	0, 			// 217 	//BF #001
				   25, 13, 13, 25, 25, 25, 25,			// 223 	//BF #002
				   25, 17, 20, 20,  5,  			// 230 	//BF #004
				    0,  0,  0,  0,  0, 				// 235 	//BF #004
				//---------------------------------------------------------------------------------------
				    0,  0,  0,  0,  0,  0,  0,  0,		// 240  reserved for special functions
				//---------------------------------------------------------------------------------------
				   //35, 22, 22, 10, 10, 10,  			// 248       Noise Filter
				   30, 25,  0,  0,  0,  0,			// 248 - 253 Grid Layout

				   35, 35, 30, 0, 0,  0,  0,  0,  0,  0,	// 254	     Average
				   15,  7, 30, 30,				// 264	     Calibration Set
				   30, 36,  0,  0,				// 268	     UC Quick Print 
				   15, 15, 10,  5, 10,  5,  0,  0,		// 272 	     Pre Trigger Setting
				    8,  8,  0,  0,				// 280	     Autoscale setup
				    7,  7, 10, 10,				// 284	     USTB Mode
				   13, 18,  0,  0,				// 288	     USTB Display
				   10, 15, 30,  0,				// 292	     Draw Mode
				   30, 25, 25,  0,				// 296       USTB Buffer Size
				   25, 35, 28, 25, 35, 35, 20, 35, 23, 33, 0,	// 300 - 310 Grid Color
	
				   //30, 25,  0,  0,  0,  0,  0,  0,  0,	// 311 - 319 Grid Layout
				   35, 22, 22, 10, 10, 10, 10, 10, 10,  	// 311 - 319 Noise Filter	

				   40, 45, 45, 35, 45, 45, 35,  0,  0,  0,	// 320 - 329 Channel no display
				   15, 18, 10, 25, 15, 10, 10, 10, 10,  0,	// 330 - 339 Status / Menu layout
				   40, 20, 15, 10, 10, 10, 20,  0,  0,  0,	// 340 - 349 Logic
				   17, 10,  5,  0,  0,  0,			// 350 - 355 ADC Driver
				   12, 15,  0,  0,				// 356 - 359 Trigger Level Settings
				   38, 42, 35, 42, 38, 38,  38,  25,  0,  0	// 360 - 369 Display - Persistent
			};






// Button text second line	   // [MenuStatusNr] [Länge]
char MenuData[370][16] =  {	"   ", {Menu_Select}, {Menu_Select}, {Menu_Select},
				"On", "Off", 								// 4
				"GND", "AC", "DC", 							// 6
				"20MHz", "100MHz", 							// 9
				"2 x 2", "12 x 12", 							// 11
				"128KB", "32KB", "8KB", "1KB", "X - Y",					// 13
				"Started", "Quick Help", "Oscilloscope", 				// 18
				"Channel 1", "Channel 2", "Channel 3",					// 21
				"Channel 4", "Channels", "Hex",						// 24
				"1", "2", "3", "4", "Math", 						// 27
				"Left", "Center", "Right",						// 32
				"Delay", "Measure", "Display",						// 35
				"Trigger", " ", "Status", "Recall",					// 38
				"Linear", "sin(x)/x", " ",						// 42	// Interpolation
				"Character", "Y1   Y2", "Autoscale", "Settings",			// 45
				"%", "Absolute", " ",			        			// 49	//  QM Thresholds -> 27 Type
				"Average", "Delay", "Duty Cycle", "Fall Time",				// 52	//  4 Quick Measurement Select
				"Frequency", "Maximum", "Minimum", 		    			// 56	//  4 Quick Measurement Select
				"Peak-Peak", "Period", "Phase",						// 59	//  4 Quick Measurement Select
				"Rise Time", "RMS", "+ Width", "- Width",         			// 62	//  4 Quick Measurement Select
				"Magnitude", "Phase", "Real", "Imaginary",        			// 66	// 31 FFT Mode
				 "Real+Imag", "Power Spec", "Power Dens", "",				// 70	// 31 FFT Mode
				"1", "2", "4", "8", "16", "32", "64",					// 74
				"128", "256", "512", "1024", "2048",					// 81
				"4096", "8192", "16384",						// 86
				"External", "Line", 							// 89
				"Free Run", "Auto", "Normal", "Combi",					// 91	// 9 Trigger Mode
				"DC (ext)", "AC (ext)", "LF Reject", "HF Reject",			// 95	// 12 Trigger Coupling
				"Slow TB", "Setting",							// 99	// 23 Autoscale
				"0.1 : 1", "0.2 : 1", "0.5 : 1",					// 101
				"1 : 1", "2 : 1", "5 : 1",			        		// 104
				"10 : 1", "20 : 1", "50 : 1",						// 107
				"100 : 1", "200 : 1", "500 : 1", "1000 : 1",				// 110
				"Off", "Trig wait", "Tek", " ", " ", 					// 114	// LED 1 green
				"Off", "Triggered", "Trig Event", "Tek", " ",				// 119	// LED 2 red
				"Off", "Double Push", "Single Push", "",				// 124	// Trigger submenu - Force Trigger
				"LF Reject", "HF Reject", "Line", "Vert Sync", "Comp Sync",		// 128	//BF External Trigger + TV Trigger #019
				"0 %", "33 %", "66 %", "100 %",						// 133
				 "1", "2", "3", "4", "ALT", "EXT", "TV",				// 137	//BF Trigger Source #019
                           	" ", "Setup", "Trace", "Busy", 						// 144
                           	"BMP", "PPM", "CSV", "ASCII", "not used",				// 148
				"10mV/", "20mV/", "50mV/", "100mV/", "200mV/",				// 153
				"500mV/", "1V/", "2V/", "5V/", "10V/",		    			// 158
				"20V/", "50V/", "100V/", "1mV/", "2mV/",				// 163
				"5mV/", "10mV/", "20mV/", "50mV/", "100mV/",				// 168
				"200mV/", "500mV/", "1V/", "2V/", "5V/",				// 173
				"10V/", "20V/", "50V/", "100V/", "",					// 178
				"Layout", "Auto Level", "PC", "USB-Host", "",				// 183	//BF #006
				"Offsets", "Window", "Grid", " ", " ", 					// 188  
				"Rectangle","von Hann","Blackman","Poisson","Kaiser 3.0",		// 193 -> BF added new items
				"Gauss 2.5","FlatTop","Hamming","Harris","Nuttall",			// 198
				" 0ns", " 1ns", " 2ns", " 3ns", " 4ns", " 5ns", " 6ns",			// 203	//BF #001
				" 7ns", " 8ns", " 9ns", "10ns", "11ns", "12ns", "13ns",			// 210	//BF #001
				"14ns", "15ns", "16ns", "", "", "",					// 217	//BF #001
				"Factory", "High Freq 1", "High Freq 2", "Test 1", "Test 2",		// 223	//BF #002
				"Test 4","Test 5",							// 228	//BF #002
				"Factory", "LB-Mod", "OPA653", "24.9/180", "Add-On PCB",		// 230	Hardware Gain //BF #004
				"", "", "", "", "",							// 235	//BF #004
				//----------------------------------------------------------------------------------------------------------------------------
				"", "", "", "", "", "", "", "",						// 240 - 247	reserved for special functions -> don't use
				//----------------------------------------------------------------------------------------------------------------------------
				"Solid", "Dotted", "", "", "", "", 					// 248 - 253 Grid Layout
				"Off", "Flat", "Deep", "", "", "", "", "",	"", "",			// 254	// Average
				"Standard", "Active Probe", "Set 3", "Set 4", 				// 264	// Calibration Set
				"Color", "B/W", "", "",							// 268	// UC Quick Print
				"Left Edge", "First Div", "Grid Middle", "Trace Middle", "Keep Value", "Keep + Follow", "", "",	// 272    Pre Trigger Setting
				"Trig. Source", "All Channels", "", "",					// 280
				"Roll Forward", "Roll Reverse", "Shift Forw", "Shift Revs",		// 284	//USTB Mode
				"Permanent", "Stepwise", "", "", 					// 288	//USTB Display Mode
				"Fast Vector", "Accurate", "Points", "",				// 292	//Draw Mode
				"8KB", "16KB", "32KB", "",						// 296 - 299 USTB Buffer Size
				"White", "Red", "Green", "Yellow", "Blue", "Teal", "Magenta", "Pink", "Orange", "Gray", "",	// 300 - 310 Grid Color	
				"Off", "Smooth", "Strong", "IIR 1 Stage", "IIR 2 Stage", "IIR 3 Stage", // 311 - 319 Noise Filter
				"FIR 1 ", "FIR 2 ", "FIR 3 ",
				"Off", "1", "2", "1 + 2", "3", "4", "3 + 4", "", "", "", 		// 320 - 329 Channel no display	
				"Standard", "Mono Grid", "Mono Beige", "Yellow", "Light Red", "Neon Yellow", "Neon Green", "Neon Blue", "Neon Red", "", // 330 - 339 Status / Menu layout	
				"Off", "TTL 5V", "CMOS 5V", "LVTTL 3.3V", "CMOS 2.5V", "CMOS 1.8V", "RS232", "", "", "",// 340 - 349  Logic	
				"Standard", "Assembler", "Quick+Dirty ", "", "", "",			// 350 - 355 ADC Driver
				"Fix Position", "Constant", "", "",					// 356 - 359 Trigger Level Settings
				"Off", "1s", "2.5s", "5s", "10s", "25s", "50s", "Infinity", "", ""	// 360 - 369 Display - Persistent
			};



//BF start entries for buttons second line [MenuNr][Button(ItemNr)]	
//BF entry must be the index of the second line entry (from MenuData[][] above)!	
short MenuStatus[32][6] = {{ 340, 254, 311,  42, 240,   0}, 	//  0 Acquire
			   {   8, 240, 240, 104,  21,  25}, 	//  1 Channel 1
			   {   8, 240, 240, 104,  22,  25}, 	//  2 Channel 2
			   {   8, 240, 240, 104,  23,  25}, 	//  3 Channel 3
			   {   8, 240, 240, 104,  24,  25}, 	//  4 Channel 4
			   { 360,  37, 136, 320, 292, 242}, 	//  5 Display
			   {  20, 145, 188, 264, 240, 242}, 	//  6 Utility
			   {   0,   0,   0,   0,   0,   0}, 	//  7 Service n.a.
		 	   {   0, 146, 146, 146,  37,  48}, 	//  8 Save / Recall BF -> new overlay function
			   { 300, 248, 330, 240, 240, 243}, 	//  9 Display Setup Submenu
			   { 241, 240, 240, 240, 240, 242}, 	// 10 Timebase: Main / Delayed / XY / FFT / USTB / Browse
			   {   0,   0,   0,   0,   0,   0}, 	// 11 Delayed Timebase Menu n.a.
			   {  91,  95, 184,   0, 104, 242}, 	// 12 Trigger Mode / Coupling
			   { 114, 119, 240, 124, 272, 356}, 	// 13 Trigger sub menu
			   {   2, 137, 128, 131, 189,   0}, 	// 14 Edge  BF new external Trigger #019	
			   { 137,   1,   3,   0,   0,   0}, 	// 15 Pulse Width	#019
			   {  27,   0,   0,   0,   0,  46}, 	// 16 Cursor
			   { 148, 149, 150, 151,  36, 185}, 	// 17 Quick Print, Send Measure -> 36
			   { 223, 230,   0, 350,   0, 243},	// 18 Hardware #004
			   {  27,  52,  52,  36, 242, 242},	// 19 Quick Measurment
			   {  27,   2,  28,   2,  53, 243},	// 20 QM Delay Settings n.a.
			   {  27,   0,  28,   0,  61, 243},	// 21 QM Phase Settings	n.a.	
			   {  27,  49,   0,   0,   0, 243}, 	// 22 QM Thresholds	
			   {  47,  99, 100, 280,   0,   0},	// 23 Autoscale
			   {  93,   2, 114, 119,   0,   0},	// 24 Trigger Mode TV
			   { 203, 203, 203, 203, 242, 243},	// 25 Extended Utilities BF #001 #004
			   {   0,   0, 240, 241, 240,   0},	// 26 Math
			   { 137, 193,  66,  83,   0, 243},	// 27 FFT Settings
 			   { 240,  37, 136, 190, 183, 242}, 	// 28 Display FFT 
			   {   0,   0,   0,   0,   0, 243}, 	// 29 Math Settings
			   { 284, 288, 296,   0,   0, 243}, 	// 30 USTB: Mode / Display / Buffer
			   { 268, 269, 150,   0,   0, 185}}; 	// 31 Quick Print USB-Export

//BF Special function codes for menu status to display diffent signs in the second line of the button

								//   0 empty
								//   1 Ok sign middle
								//   2 Ok sign left
								//   3 Ok sign right
								// 240 Unchecked Checkbox
								// 241 Checked Checkbox
								// 242 Menu Down Arrow
								// 243 Menu Up Arrow
								// 244 Menu Down Arrow Grayed
								// 245 Menu Up Arrow Grayed
								// 246 Menu Grayed
								// 247 Sub Menu


// BF status of entries in menu popup list
// 0 = Not displayed / 1 = Deactive (grayed) / 2 = Available / 3 = Selected
short MenuPopupStatus[51][22] = {{ 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  0 Draw Mode
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  1 Cursor Source
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  2 Autoscale Setup
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  3 Quick Measurement Source
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  4 Quick Measurement Select
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  5 Quick Measurement Delay Settings Source1
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  6 Quick Measurement Delay Settings Source2
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  7 Trigger Source Pulse Width
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  8 Trigger Edge External setting
				 { 2, 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	//  9 Trigger Mode (Auto/Normal/Combi)
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 10 Trigger Coupling
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 11 Trigger Edge TV
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 12 Single Trigger Setting
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 13 Channel 1 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 14 Channel 2 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 15 Channel 3 Coupling
				 { 2, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 16 Channel 4 Coupling
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 17 LED 1 Function (green)
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 18 LED 2 Function (red)
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 19 Calibration Set
				 { 3, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 20 Pre Trigger Setting
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 21 Average
				 { 3, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 22 Filter setting
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 23 Interpolation setting
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 24 Quick Measurement Phase Settings Source1
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 25 Quick Measurement Phase Settings Source2
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 26 Quick Measurement Threshold Source
				 { 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 27 Quick Measurement Threshold Type (Percent , Absolute)
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 28 Trigger Edge Source #019
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 29 FFT Source
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 30 FFT Window
				 { 3, 1, 2, 2, 2, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 31 FFT Mode
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 32 FFT Length
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 33 More Utilities - CH1 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 34 More Utilities - CH2 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 35 More Utilities - CH3 Delay BF #001
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0}, 	// 36 More Utilities - CH4 Delay BF #001
				 { 3, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 37 Hardware - ADC Register setting BF #002 #004
				 { 3, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 38 Hardware - Pre Amp Gain BF #004
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 39 Quick Print - Destination
				 { 3, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 40 USTB mode 
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 41 USTB display mode
				 { 3, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 42 USTB buffer size
				 { 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 43 Grid Color
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 44 Grid Layout
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 45 Channel no display
				 { 3, 2, 2, 2, 2, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 46 Status / Menu layout
				 { 3, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 47 Acquire - Logic
				 { 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 48 Hardware - ADC Driver
				 { 3, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 	// 49 Display - Persistent
				 { 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}}; 	// 50 Trigger Submenu - Trigger Level Settings



// Button position / number of entries in menu popup lists
unsigned short MenuPopupDef[51][2] =	{{4, 3},        //  0 Draw Mode
				       	 {0, 5},      	//  1 Cursor Source
					 {3, 2},	//  2 Autoscale Setup
				 	 {0, 5},	//  3 Quick Measurement Source
					 {1,14},	//  4 Quick Measurement Select
					 {0, 5},	//  5 Quick Measurement Delay Settings Source1
					 {2, 5},	//  6 Quick Measurement Delay Settings Source2
					 {0, 4},	//  7 Trigger Source Pulse Width
					 {2, 3},	//  8 Trigger Edge External setting
					 {0, 4},	//  9 Trigger Mode (Auto/Normal/Combi)
					 {1, 2},	// 10 Trigger Coupling
					 {3, 2},	// 11 Trigger Edge TV
					 {3, 3},	// 12 Single Trigger Setting
					 {0, 3},	// 13 Channel 1 Coupling
					 {0, 3},	// 14 Channel 2 Coupling
					 {0, 3},	// 15 Channel 3 Coupling
					 {0, 3},	// 16 Channel 4 Coupling
					 {0, 3},	// 17 LED 1 Function (green)
					 {1, 4},	// 18 LED 2 Function (red)
					 {3, 4},	// 19 Calibration Set
					 {4, 6},	// 20 Pre Trigger Setting
					 {1, 3},	// 21 Average
					 {2, 6},	// 22 Filter setting
					 {3, 2},	// 23 Interpolation setting
					 {0, 5},	// 24 Quick Measurement Phase Settings Source1
					 {2, 5},	// 25 Quick Measurement Phase Settings Source2
					 {0, 5},	// 26 Quick Measurement Threshold Source
					 {1, 2},	// 27 Quick Measurement Threshold Type (Percent , Absolute)
					 {1, 7},	// 28 Trigger Edge Source #019
					 {0, 4},	// 29 FFT Source
					 {1,10},	// 30 FFT Window
					 {2, 7},	// 31 FFT Mode
					 {3, 4},	// 32 FFT Length
					 {0,17},	// 33 More Utilities - CH1 Delay BF #001
					 {1,17},	// 34 More Utilities - CH2 Delay BF #001
					 {2,17},	// 35 More Utilities - CH3 Delay BF #001
					 {3,17},	// 36 More Utilities - CH4 Delay BF #001
					 {0, 7},	// 37 Hardware - ADC Register setting BF #002 #004
					 {1, 5},	// 38 Hardware - Pre Amp Gain BF #004
					 {5, 2},	// 39 Quick Print - Destination
					 {0, 4},	// 40 USTB mode 
					 {1, 2},	// 41 USTB display mode
					 {2, 3},	// 42 USTB buffer size
					 {0,10},	// 43 Grid Color
					 {1, 2},	// 44 Grid Layout
					 {3, 7},	// 45 Channel no display
					 {2, 5},	// 46 Status / Menu layout
					 {0, 7},	// 47 Acquire - Logic
					 {3, 3},	// 48 Hardware - ADC Driver
					 {0, 8},	// 49 Display - Persistent
					 {5, 2}};	// 50 Trigger Submenu - Trigger Level Settings


//BF entries for menu popup lists
// Caption	/ Items ->
char MenuPopupText[51][23][20] = 
{
{{"Draw Mode"}, {"Fast Vector"}, {"Accurate"}, {"Points"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 0 Draw Mode
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 1 Cursor Source
{{"TB Search"}, {"Trig. Source"}, {"All Channels"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 2 Autoscale Setup
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 3 Quick Measurement Source
{{"Select Measurement"}, {"Average"}, {"Delay"}, {"Duty Cycle"}, {"Fall Time"}, {"Frequency"}, {"Maximum"}, {"Minimum"}, {"Peak-Peak"}, {"Period"}, {"Phase"}, {"Rise Time"}, {"RMS"}, {"+ Width"}, {"- Width"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},                                                                                                                                			// 4 Quick Measurement Select
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			// 5 QM Delay Settings Source1
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},                       // 6 QM Delay Settings Source2
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},				// 7 Trigger Source Pulse Width
{{"External"}, {"LF Reject"}, {"HF Reject"}, {"Line"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 8 External Trigger Setting
{{"Mode"}, {"Free Run"}, {"Auto"}, {"Normal"}, {"Combi"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		// 9 Trigger Mode
{{"Coupling"}, {"DC (ext)"}, {"AC (ext)"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},				//10 Trigger Coupling
{{"TV  ["}, {"Vert Sync"}, {"Comp Sync"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//11 TV Trigger
{{"Force Trigger"}, {"Off"}, {"Double Push"}, {"Single Push"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//12 Force Trigger
{{"Coupling"}, {"GND"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//13 Channel 1 Coupling
{{"Coupling"}, {"GND"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//14 Channel 2 Coupling
{{"Coupling"}, {"GND"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//15 Channel 3 Coupling
{{"Coupling"}, {"GND"}, {"AC"}, {"DC"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//16 Channel 4 Coupling
{{"LED 1"}, {"Off"}, {"Trig wait"}, {"Tek"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//17 LED 1 Function (green)
{{"LED 2"}, {"Off"}, {"Triggered"}, {"Trig Event"}, {"Tek"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//18 LED 2 Function (red)
{{"Calibration"}, {"Standard"}, {"Active Probe"}, {"Set 3"}, {"Set 4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//19 Calibration Set
{{"Pre Trigger"}, {"Left Edge"}, {"First Div"}, {"Grid Middle"}, {"Trace Middle"}, {"Keep Value"}, {"Keep + Follow"},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""},{""}},//20 Pre Trigger Setting
{{"Average"}, {"Off"}, {"Flat"}, {"Deep"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//21 Average
{{"Noise Filter"}, {"Off"}, {"FIR Smooth"}, {"FIR Strong"}, {"IIR 1 Stage"}, {"IIR 2 Stage"}, {"IIR 3 Stage"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//22 Filter
{{"Interpolation"}, {"Linear"}, {"sin(x)/x"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//23 Interpolation
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//24 QM Phase settings source 1
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//25 QM Phase settings source 2
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Math"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//26 QM Threshold Source
{{"Type"}, {"Percent"}, {"Absolute"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},			//27 QM Threshold Type(%, Absolute)
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {"Alternate"}, {"External"}, {"TV"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	//28 Trigger Source Edge menu
{{"Source"}, {"1"}, {"2"}, {"3"}, {"4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},				//29 FFT Source
{{"Windows"}, {"Rectangle"}, {"von Hann"}, {"Blackman"}, {"Poisson"}, {"Kais.-Bess."}, {"Gauss 2.5"}, {"FlatTop"}, {"Hamming"}, {"Blm-Harris"}, {"Blm-Nuttall"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}}, //30 FFT window
{{"FFT-Mode"}, {"Magnitude"}, {"Phase"}, {"Real"}, {"Imag"}, {"Real+Imag"}, {"Power Spec"}, {"Power Dens"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	 //31 FFT mode
{{"FFT-Length"}, {" 512"}, {"1024"}, {"2048"}, {"4096"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}}, 		//32 FFT length
{{"CH1 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//33 BF #001
{{"CH2 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//34 BF #001
{{"CH3 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//35 BF #001
{{"CH4 Delay"}, {" 0ns"}, {" 1ns"}, {" 2ns"}, {" 3ns"}, {" 4ns"}, {" 5ns"}, {" 6ns"}, {" 7ns"}, {" 8ns"}, {" 9ns"}, {"10ns"}, {"11ns"}, {"12ns"}, {"13ns"}, {"14ns"}, {"15ns"}, {"16ns"},{""},{""},{""},{""},{""}},//36 BF #001
{{"ADC-Setup"}, {"Factory"}, {"High Freq 1"}, {"High Freq 2"}, {"Test 1"}, {"Test 2"}, {"Test 3"}, {"Test 4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},//37 BF #002 #004
{{"Pre Gain"}, {"Factory"}, {"LB-Mod"},  {"OPA653"}, {"24.9/180"}, {"Add-On PCB"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},//38 Menu Hardware Gain BF #004
{{"Destination"}, {"PC"}, {"USB-Host"},  {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},		//39 Quick Print Destination
{{"USTB Mode "}, {"Roll Forw"}, {"Roll Rev"}, {"Shift Forw"}, {"Shift Rev"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 40 USTB mode
{{"USTB Display "}, {"Permanent"}, {"Stepwise"}, {" "}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 41 USTB display mode
{{"Buffer Size "}, {"8KB"}, {"16KB"}, {"32KB (Roll)"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 42 USTB buffer size
{{"Grid Color"}, {"White"}, {"Red"}, {"Green"}, {"Yellow"}, {"Blue"}, {"Teal"}, {"Magenta"}, {"Pink"}, {"Orange"}, {"Gray"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 43 Grid Color
{{"Grid Layout"}, {"Solid Lines"}, {"Dotted Lines"}, {" "}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 44 Grid Layout
{{"No Display"}, {"Off"}, {"Channel 1"}, {"Channel 2"}, {"Ch 1 + 2"}, {"Channel 3"}, {"Channel 4"}, {"Ch 3 + 4"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 45 Channel no display
{{"Status Layout"}, {"Standard"}, {"Mono Grid"}, {"Mono Beige"}, {"Mono Yellow"}, {"Mono Red"}, {"Neon Yellow"}, {"Neon Green"}, {"Neon Blue"}, {"Neon Red"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},// 46 Status / Menu layout
{{"Digital Logic"}, {"Off"}, {"TTL 5V"}, {"CMOS 5V"}, {"LVTTL 3.3V"}, {"CMOS 2.5V"}, {"CMOS 1.8V"}, {"RS232"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 47 Logic
{{"ADC Driver"}, {"Standard"}, {"Assembler"}, {"Quick + Dirty"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 48 ADC Driver
{{"Persistent"}, {"Off"}, {"1s"}, {"2.5s"}, {"5s"}, {"10s"}, {"25s"}, {"50s"}, {"Infinity"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 49 Display - Persistent
{{"Trigger Level"}, {"Fix Position"}, {"Constant"}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}},	// 50 Trigger Submenu - Trigger Level Settings

};

//********************************************************************************************************************************************************************************************************************************

	
//char SampleRateData[15][10] = {"4.00kSa/s", "10.0kSa/s", "20.0kSa/s", "40.0kSa/s", "100kSa/s", "200kSa/s", "400kSa/s", "1.00MSa/s", "2.00MSa/s", "4.00MSa/s", "10.0MSa/s", "20.0MSa/s", "25.0MSa/s", "100MSa/s", "200MSa/s"};

//BF del char Stringlist[1][32] = {"Sample Rate = "};
	
	
//BF del char PatternStatus[5] = {3, 3, 3, 3, 3};
																

//BF not used unsigned char TriggerData[11][12] = {"+ Extern", "- Extern", "+ LF Reject", "-LF Reject", "+ HF Reject", "- HF Reject", 
//								     "+ Line", "- Line", "TV VS", "TV Odd", "TV Even"};

		
unsigned short TimebaseDataDef[36] = {	10, 10,  7,  6,  6,  2,  1,  1,
				      	11, 10, 10,  7,  6,  6,  2,  1,  1,
					10,  9,  9,  5,  4,  4,  1,  0,  0,
					12, 11, 11,  8,  7,  7,  3,  3,  3,  1};


unsigned char TimebaseData[36][10] = 	{{'2', S_nS, S_Slash},
					 {'5', S_nS, S_Slash},
					 {'1', '0', S_nS, S_Slash},
					 {'2', '0', S_nS, S_Slash},
					 {'5', '0', S_nS, S_Slash},
					 {'1', '0', '0', S_nS, S_Slash},
					 {'2', '0', '0', S_nS, S_Slash},
					 {'5', '0', '0', S_nS, S_Slash},
					 {'1', S_uS, S_Slash},
					 {'2', S_uS, S_Slash},
					 {'5', S_uS, S_Slash},
					 {'1', '0', S_uS, S_Slash},
					 {'2', '0', S_uS, S_Slash},
					 {'5', '0', S_uS, S_Slash},
					 {'1', '0', '0', S_uS, S_Slash},
					 {'2', '0', '0', S_uS, S_Slash},
					 {'5', '0', '0', S_uS, S_Slash},
					 {'1', S_mS, S_Slash},
					 {'2', S_mS, S_Slash},
					 {'5', S_mS, S_Slash},
					 {'1', '0', S_mS, S_Slash},
					 {'2', '0', S_mS, S_Slash},
					 {'5', '0', S_mS, S_Slash},
					 {'1', '0', '0', S_mS, S_Slash},
					 {'2', '0', '0', S_mS, S_Slash},
					 {'5', '0', '0', S_mS, S_Slash},
					 {'1', S_S, S_Slash},
					 {'2', S_S, S_Slash},
					 {'5', S_S, S_Slash},
					 {'1', '0', S_S, S_Slash},
					 {'2', '0', S_S, S_Slash},
					 {'5', '0', S_S, S_Slash},
					 {'1', '0', '0', S_S, S_Slash},
					 {'2', '0', '0', S_S, S_Slash},
					 {'5', '0', '0', S_S, S_Slash},
					 {'1', '0', '0', '0', S_S, S_Slash}};

//BF new TB values
// used in Display::MEASURETIME() and Display::CALCCURSORDATA()
float TimeBaseFactor[36] = {	0.00004,	//   2 	ns
			      	0.0001,		//   5 	ns
			      	0.0002,		//  10 	ns
			      	0.0004,		//  20 	ns
			       	0.001,		//  50 	ns
				0.002,		// 100 	ns
				0.004,		// 200 	ns
				0.01,		// 500 	ns		
				0.02,		//   1 	µs
				0.04,		//   2 	µs
				0.1,		//   5 	µs
				0.2,		//  10 	µs
				0.4,		//  20 	µs
				1,		//  50 	µs
				2,		// 100 	µs
				4,		// 200 	µs
			       10,		// 500 	µs
			       20,		//   1 	ms
			       40,		//   2 	ms
			      100,		//   5 	ms
			      200,		//  10 	ms
			      400,		//  20 	ms
			     1000,		//  50 	ms
			     2000,		// 100 	ms
			     4000,		// 200 	ms
			    10000,		// 500 	ms
			    20000,		//   1 	s
			    40000,		//   2 	s
			   100000,		//   5 	s
			   200000,		//  10 	s
			   400000,		//  20 	s
			  1000000,		//  50 	s
			  2000000,		// 100  s
			  4000000,		// 200  s
			 10000000,		// 500  s
			 20000000		//1000  s
		};

// BF new sample rate value for pretrigger calculation and FFT
int SampleRate[36] = {	1000000000,		//   2 	ns - 1GSa
			1000000000,		//   5 	ns - 1GSa
			1000000000,		//  10 	ns - 1GSa
			1000000000,		//  20 	ns - 1GSa
			1000000000,		//  50 	ns - 1GSa
			1000000000,		// 100 	ns - 1GSa
			1000000000,		// 200 	ns - 1GSa
			1000000000,		// 500 	ns - 1GSa	
			1000000000,		//   1 	µs - 1GSa
			 500000000,		//   2 	µs - 500MSa
			 250000000,		//   5 	µs - 250MSa
			  25000000,		//  10 	µs - 25MSa
			  10000000,		//  20 	µs - 10MSa
			   5000000,		//  50 	µs - 5MSa
			   2500000,		// 100 	µs - 2.5MSa
			   1000000,		// 200 	µs - 1MSa
			    500000,		// 500 	µs - 500KSa
			    250000,		//   1 	ms - 250KSa
			    100000,		//   2 	ms - 100KSa
			     50000,		//   5 	ms - 50KSa
			     25000,		//  10 	ms - 25KSa
			     10000,		//  20 	ms - 10KSa
			      5000,		//  50 	ms - 5KSa
			      2500,		// 100 	ms - 2,5KSa
			      1000,		// 200 	ms - 1KSa
			       500,		// 500 	ms - 500Sa
			       250,		//   1 	s  - 250Sa 
			       100,		//   2 	s  - 100Sa
				50,		//   5 	s  - 50Sa
				25,		//  10 	s  - 25Sa
				10,		//  20 	s  - 10Sa
				 5,		//  50 	s  - 5Sa
				 2,		// 100 	s  - 2,5Sa
				 1,		// 200 	s  - 1Sa 
				 1,
				 1
 			};

// BF Text offset for top status line	
unsigned short SampleRateDataDef[36] = {20, 20, 20, 20, 20, 20, 20, 20,	
                                        20,  0,  0, 10, 10, 15,  0, 20,
                                         0,  0,  0, 10, 10, 10, 15,  5,
                                        15,  5, 15, 15, 15, 20, 10, 20, 15, 15 , 15, 11 };
		
unsigned char SampleRateData[36][11] = {{"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "}, {"1 GSa/s "},					//interpolated / normal
                                        {"1 GSa/s "}, {"500 MSa/s "}, {"250 MSa/s "}, {"25 MSa/s "}, {"10 MSa/s "}, {"5 MSa/s "}, {"2.5 MSa/s "}, {"1 MSa/s "},				//normal
                                        {"500 kSa/s "}, {"250 kSa/s "}, {"100 kSa/s "}, {"50 kSa/s "}, {"25 kSa/s "}, {"10 kSa/s "}, {"5 kSa/s "}, {"2.5 kSa/s "},			//normal
                                        {"1 kSa/s "}, {"500 Sa/s "}, {"50 Sa/s "}, {"25 Sa/s "}, {"10 Sa/s "}, {"5 Sa/s "}, {"2.5 Sa/s "}, {"1 Sa/s "}, {"1 Sa/2s "},			//USTB
					{"1 Sa/4s "}, {"1 Sa/10s "}, {"1 Sa/20s "}};													//USTB
/*
// BF #003 extended printout matrix		
const short TimebaseData_Matrix[36][5][10] = {{{'2', S_nS, S_Slash}, {'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}},                             // 2 ns
                                              {{'5', S_nS, S_Slash}, {'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}},                   // 5 ns
                                              {{'1', '0', S_nS, S_Slash}, {'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}},         // 10 ns
                                              {{'2', '0', S_nS, S_Slash}, {'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}},    // 20 ns
                                              {{'5', '0', S_nS, S_Slash}, {'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}},         // 50 ns
                                              {{'1', '0', '0', S_nS, S_Slash}, {'2', '0', '0', S_nS, S_Slash}, {'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}},              // 100 ns
                                              {{'2', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}},                                  // 200 ns
                                              {{'5', '0', '0', S_nS, S_Slash}, {'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}},                             // 500 ns
                                              {{'1', S_uS, S_Slash}, {'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}},                                  // 1 �s
                                              {{'2', S_uS, S_Slash}, {'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}},                             // 2 �s
                                              {{'5', S_uS, S_Slash}, {'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}},                   // 5 �s
                                              {{'1', '0', S_uS, S_Slash}, {'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}},         // 10 �s
                                              {{'2', '0', S_uS, S_Slash}, {'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}},    // 20 �s
                                              {{'5', '0', S_uS, S_Slash}, {'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}},         // 50 �s
                                              {{'1', '0', '0', S_uS, S_Slash}, {'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}},              // 100 �s
                                              {{'2', '0', '0', S_uS, S_Slash}, {'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}},                        // 200 �s
                                              {{'5', '0', '0', S_uS, S_Slash}, {'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}},                             // 500 �s
                                              {{'1', S_mS, S_Slash}, {'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}},                                  // 1 ms
                                              {{'2', S_mS, S_Slash}, {'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}},                             // 2 ms
                                              {{'5', S_mS, S_Slash}, {'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}},                   // 5 ms
                                              {{'1', '0', S_mS, S_Slash}, {'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}},         // 10 ms
                                              {{'2', '0', S_mS, S_Slash}, {'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}},    // 20 ms
                                              {{'5', '0', S_mS, S_Slash}, {'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}},          // 50 ms
                                              {{'1', '0', '0', S_mS, S_Slash}, {'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}},                // 100 ms
                                              {{'2', '0', '0', S_mS, S_Slash}, {'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}},                           // 200 ms
                                              {{'5', '0', '0', S_mS, S_Slash}, {'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}},                                 // 500 ms
                                              {{'1', S_S, S_Slash}, {'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}},                                       // 1 s
                                              {{'2', S_S, S_Slash}, {'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}},                                  // 2 s
                                              {{'5', S_S, S_Slash}, {'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}},                        // 5 s
                                              {{'1', '0', S_S, S_Slash}, {'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}},              // 10 s
                                              {{'2', '0', S_S, S_Slash}, {'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}},         // 20 s
                                              {{'5', '0', S_S, S_Slash}, {'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}}, // 50 s
                                              {{'1', '0', '0', S_S, S_Slash}, {'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }},       		// 100 s
                                              {{'2', '0', '0', S_S, S_Slash}, {'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }, { }}, 						// 200 s
                                              {{'5', '0', '0', S_S, S_Slash}, {'1', '0', '0', '0', S_S, S_Slash}, { }, { }, { }}, 									// 500 s
                                              {{'1', '0', '0', '0', S_S, S_Slash}, { }, { }, { }, { }}}; 												// 1000 s

*/


//BF changed #003 new reduced table for delayed factor
const float Timebase_Delayed_Factor_Table[26]    =  {           2,
                                                     		5,
                                                     	       10,
                                                     	       20,
                                                               50,
                                                              100,
                                                              200,
                                                              500,
                                                             1000,
                                                             2000,
                                                             5000,
                                                            10000,
                                                            20000,
                                                            50000,
                                                           100000,
                                                           200000,
                                                           500000,
                                                          1000000,
                                                          2000000,
                                                          5000000,
                                                         10000000,
                                                         20000000,
                                                         50000000,
                                                        100000000,
                                                        200000000,
                                                        500000000 };

//Voltage ratio
const float VoltFactor[19] = { 0.001,	//  1mV
			       0.002,	//  2mV
			       0.005,	//  5mV
			       0.01,	// 10mV
			       0.02,	// 20mV
			       0.05,	// 50mV
			       0.1,	//100mV
			       0.2,	//200mV
			       0.5,	//500mV
			       1.0,	//  1V
			       2.0,	//  2V
			       5.0,	//  5V
			      10.0,	// 10V
			      20.0,	// 20V
			      50.0,	// 50V
			     100.0, 	//100V
			     200.0, 	//200V
			     300.0, 	//500V
			    1000.0};   //1000V



const char VoltageData[11][5] =  {{S_uV, S_Slash},
				  {S_mV, S_Slash},
				  {S_V, S_Slash},
				  {S_kV, S_Slash},
	 			  {S_uA, S_Slash},
				  {S_mA, S_Slash},
				  {S_A, S_Slash},
				  {S_kA, S_Slash},
				  {},
				  {}, {}};

// for direct calculation from screen position to voltage
const float ScreenScaleFactor[16] = { 0.00002,	//  1mV
				      0.00004,	//  2mV
				      0.0001,	//  5mV
				      0.0002,	// 10mV
				      0.0004,	// 20mV
				      0.001,	// 50mV
				      0.002,	//100mV
				      0.004,	//200mV
				      0.01,	//500mV
				      0.02,	//  1V
				      0.04,	//  2V
				      0.1,	//  5V
				      0.2,	// 10V
				      0.4,	// 20V
				      1.0,	// 50V
				      2.0 };	//100V


//FONT 10x9 BITMAPS ...........................................................
unsigned char FONT10X9[100][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
								  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!)
								
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;34 (") 
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;35 (#) #
						
        						 {0xF8,0x03,0x18,0x00,0x60,0x00,0x80,0x01,0x60,0x00,0x18,0x00,0xF8,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;36 ($) kleines gro�es M
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;37 (%) 
								
        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;38 (&) �
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;39 (')
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;41  ) 
								
        						 //{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  	//	  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) 
						  	{0x24,0x01,
							 0xA8,0x00,
							 0x70,0x00,
							 0xFC,0x01,
							 0x70,0x00,
							 0xA8,0x00,
							 0x24,0x01,
							 0x00,0x00,
							 0x80,0x80,
							 0x80,0x80,
							 0x80,0x80,
							 0x80,0x80,
							 0x80,0x80,
							 0x80,0x80}, //   ;42 (*) *
							 
							{0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						
		   						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;44 (,)
						
		        				 {0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -
						  	 //{0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x00,
						  	//	  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;45 (-) -	  
						
        						 {0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;46 (.) .
						
        						 {0x00,0x03,0xE0,0x00,0x1C,0x00,0x03,0x00,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
						
        						 {0xFE,0x01,0xFF,0x03,0x01,0x02,0x01,0x02,0xFF,0x03,0xFE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;48 (0) 0
						
		        				 {0x0C,0x00,0x06,0x00,0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;49 (1) 1
						
        						 {0x02,0x03,0x83,0x03,0xE1,0x02,0x71,0x02,0x3F,0x02,0x0E,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;50 (2) 2
						
        						 {0x02,0x01,0x03,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;51 (3) 3
											
        						 {0xC0,0x00,0xB0,0x00,0x8C,0x00,0xFF,0x03,0xFF,0x03,0x80,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;52 (4) 4
						
		        				 {0x1C,0x01,0x1F,0x03,0x0B,0x02,0x09,0x02,0xF9,0x03,0xF1,0x01,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;53 (5) 5
								
        						 {0xFC,0x01,0xFE,0x03,0x11,0x02,0x11,0x02,0xF3,0x03,0xE2,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;54 (6) 6
						
        						 {0x01,0x00,0x81,0x03,0xF1,0x03,0x7D,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;55 (7) 7
						
        						 {0xEE,0x01,0xFF,0x03,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;56 (8) 8
						
		        				 {0x1E,0x01,0x3F,0x03,0x21,0x02,0x21,0x02,0xFF,0x01,0xFE,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;57 (9) 9
						
        						 {0x18,0x03,0x18,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;58 (:) :
						
        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   ;59 (;) Menu Hacken
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;60 (<)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;61 (=) 
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;62 (>)
						
        						 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;63 (?)
						
		        				 {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;64 (@) 
						
        						 {0x00,0x03,0xE0,0x03,0xFC,0x00,0x9F,0x00,0x83,0x00,0x9F,0x00,0xFC,0x00,
						  		  0xE0,0x03,0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0xFF,0x03,0xEE,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;66 (B) B
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x01,0x02,0x03,0x03,
						  		  0x02,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x03,0xFF,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,0xFC,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x02,0x11,0x02,0x11,0x02,0x01,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x03,0xFF,0x03,0x11,0x00,0x11,0x00,0x11,0x00,0x01,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;70 (F) F
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x21,0x02,0x21,0x02,0xE3,0x03,
						  		  0xE2,0x01,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;71 (G) G
						
		        				 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x10,0x00,0x10,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;73 (I) I
						
        						 {0x80,0x01,0x80,0x03,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x03,0xFF,0x03,0x30,0x00,0x1C,0x00,0xFE,0x00,0xE3,0x03,0x01,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x03,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x03,0xFF,0x03,0x0F,0x00,0xFC,0x01,0x80,0x03,0xFC,0x01,0x0F,0x00,
						  		  0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x03,0xFF,0x03,0x0E,0x00,0x38,0x00,0xE0,0x00,0xFF,0x03,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;78 (N) N
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x01,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x21,0x00,0x3F,0x00,0x1E,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;80 (P) P
						
        						 {0xFC,0x00,0xFE,0x01,0x03,0x03,0x01,0x02,0x81,0x02,0x03,0x03,0xFE,0x01,
						  		  0xFC,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x03,0xFF,0x03,0x21,0x00,0x21,0x00,0x61,0x00,0xFF,0x01,0x9E,0x03,
						  		  0x00,0x02,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x0E,0x01,0x1F,0x03,0x39,0x02,0x31,0x02,0x71,0x02,0xE3,0x03,0xC2,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x01,0xFF,0x03,0x00,0x02,0x00,0x02,0x00,0x02,0xFF,0x03,0xFF,0x01,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x1F,0x00,0xFC,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xFC,0x00,
						  		  0x1F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x03,0x00,0x7F,0x00,0xFC,0x03,0x80,0x03,0xF8,0x03,0x7F,0x00,0x07,0x00,
						  		  0x7F,0x00,0xF8,0x03,0x80,0x03,0xFC,0x03,0x7F,0x00,0x03,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x03,0x87,0x03,0xFC,0x00,0x78,0x00,0xFC,0x00,0x87,0x03,0x03,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x03,0x00,0x07,0x00,0x1C,0x00,0xF8,0x03,0xF8,0x03,0x1C,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x01,0x03,0x81,0x03,0xE1,0x02,0x79,0x02,0x1D,0x02,0x07,0x02,0x03,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e
						
        						 {0x90,0x01,0xC8,0x03,0x68,0x02,0x28,0x02,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x03,0xFF,0x03,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0x18,0x03,0x10,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xFF,0x03,0xFF,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xF0,0x01,0xF8,0x03,0x48,0x02,0x48,0x02,0x78,0x03,0x70,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x08,0x00,0xFE,0x03,0xFF,0x03,0x09,0x00,0x01,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xF0,0x09,0xF8,0x13,0x08,0x12,0x10,0x11,0xF8,0x1F,0xF8,0x0F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x03,0xFF,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x03,0xFB,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x10,0x00,0x10,0xFB,0x1F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x03,0xFF,0x03,0x60,0x00,0xF0,0x01,0x98,0x03,0x08,0x02,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x03,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF8,0x03,0x10,0x00,
						  		  0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x03,0xF8,0x03,0x10,0x00,0x08,0x00,0xF8,0x03,0xF0,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x1F,0xF8,0x1F,0x10,0x01,0x08,0x02,0xF8,0x03,0xF0,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xF0,0x01,0xF8,0x03,0x08,0x02,0x10,0x01,0xF8,0x1F,0xF8,0x1F,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x03,0xF8,0x03,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x30,0x01,0x78,0x03,0x68,0x02,0xC8,0x02,0xD8,0x03,0x90,0x01,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x08,0x00,0xFC,0x01,0xFE,0x03,0x08,0x02,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x01,0xF8,0x03,0x00,0x02,0x00,0x01,0xF8,0x03,0xF8,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;117 (u)  u

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x00,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;118 (v)  v

        						 {0x18,0x00,0xF8,0x00,0xE0,0x03,0x80,0x03,0xF0,0x01,0x38,0x00,0xF0,0x01,
						  		  0x80,0x03,0xE0,0x03,0xF8,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;119 (w)  w

        						 {0x18,0x03,0xB8,0x03,0xE0,0x00,0xE0,0x00,0xB8,0x03,0x18,0x03,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;120 (x)  x

        						 {0x18,0x10,0xF8,0x10,0xE0,0x1F,0x00,0x1F,0xE0,0x07,0xF8,0x00,0x18,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;121 (y)  y

        						 {0x08,0x03,0xC8,0x03,0xE8,0x02,0x38,0x02,0x18,0x02,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;122 (z)  z 
						
        						 {0x10,0x00,0x18,0x00,0xFC,0x01,0xFE,0x01,0xFC,0x01,0x18,0x00,0x10,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;123 ({)  Big Arrow Up

        						 {0x20,0x00,0x60,0x00,0xFE,0x00,0xFE,0x01,0xFE,0x00,0x60,0x00,0x20,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;124 (|)  Big Arrow Down

        						 {0x20,0x00,0x30,0x00,0x38,0x00,0xFD,0x00,0x39,0x01,0x31,0x02,0x21,0x04,
						  		  0x01,0x04,0x01,0x04,0x01,0x04,0x01,0x04,0x02,0x02,0x04,0x01,0xF8,0x00}, //   ;125 (})  Cycle Arrow

								 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;126 (~) 
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;127 (�)
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;128
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;129
								
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;130
						
        						 {0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}};//    ;131
						

						

/*	Font 12x9 (16x12) bitmaps (key labels, status line etc.)					  	
						  	     hex		   bit pattern				letter bitmap			normaly not used       	every unused column is marked 
						  	 {0x81,0x80,	  1	1000 0001 1000 0000		1/1 1/2 1/3 1/4 1/5 1/6 1/7 1/8 1/9 | 1/10 1/11 1/12 1/13 1/14	with 0x80 in the second byte
							  0x81,0x80,	  2	1000 0001 1000 0000						    |
							  0x81,0x80,	  3	1000 0001 1000 0000						    | only for oversize width
							  0x00,0x00,	  4	0000 0000 0000 0000	Byte 1					    | and special characters
							  0x00,0x00,	  5	0000 0000 0000 0000						    | like delta etc.
							  0x80,0x00,	  6	1000 0000 0000 0000						    |
							  0x80,0x00,	  7	1000 0000 0000 0000						    |
							  0x80,0x00,	  8	1000 0000 0000 0000		8/1 8/2 8/3 8/4 8/5 8/6 8/7 8/8 8/9 | 8/10 8/11 8/12 8/13 8/14            
							  0x00,0x00,      9	0000 0000 0000 0000 		1/1 1/2 1/3 1/4 1/5 1/6 1/7 1/8 1/9 | 1/10 1/11 1/12 1/13 1/14
							  0x00,0x80,	 10	1000 0000 1000 0000						    |
							  0x00,0x80,	 11	1000 0000 1000 0000						    |
							  0x00,0x80,	 12	1000 0000 1000 0000	Byte 2	____________________________________|__________________________
							  0x00,0x80,	 13	1000 0000 1000 0000		5/1 5/2 5/3 5/4 5/5 5/6 5/7 5/8 5/9 | 5/10 5/11 5/12 5/13 5/14
							  0x00,0x80	 14	1000 0000 1000 0000		normaly bit 5 - 8 are not used = 0  |
					}, 		   B1	B2	Byte	1111 1111 2222 2222		except p,y,g,q			    |
									Bit	8765 4321 8765 4321		8/1 8/2 8/3 8/4 8/5 8/6 8/7 8/8 8/9 | 8/10 8/11 8/12 8/13 8/14
*/								
unsigned char FONT12X9[120][28]={{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
								  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;32 (BLANK)   3 Pixel Space
								
		        				 {0xFF,0x0D,0xFF,0x0D,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;33 (!) !
								
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x0F,0x00,0x00,0x00,
						  		  0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;34 (") "
						
        						 {0x40,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,0xC8,0x01,0x78,0x00,0x4E,0x00,
						  		  0x08,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;35 (#) #
						
        						 {0xF0,0x0F,0xF0,0x0F,0xF0,0x00,0xC0,0x07,0x00,0x0E,0xC0,0x07,0xF0,0x00,
						  		  0xF0,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;36 ($) kleines gro�es M f�r Main Timebase
						
		        				 //{0x0E,0x00,0x1F,0x00,0x11,0x00,0x1F,0x06,0x8E,0x07,0xE0,0x01,0x78,0x00,
						  	//	  0x9E,0x03,0xC7,0x07,0x41,0x04,0xC0,0x07,0x80,0x03,0x00,0x00,0x80,0x80}, //   ;37 (%) %
						  	{0x0E,0x00,
							 0x1F,0x00,
							 0x11,0x00,
							 0x1F,0x06,
							 0x8E,0x07,
							 0xE0,0x01,
							 0x78,0x00,
							 0x9E,0x03,
							 0xC7,0x07,
							 0x41,0x04,
							 0xC0,0x07,
							 0x80,0x03,
							 0x00,0x00,
							 0x00,0x80}, //   ;37 (%) %	  
								
        						 {0xF8,0x7F,0xF8,0x7F,0x00,0x04,0x00,0x0C,0x00,0x06,0xF8,0x0F,0xF8,0x0F,
						  		  0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;38 (&) �
						
        						 {0x0F,0x00,0x0F,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;39 (') '
						
        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x01,0x40,0x00,0x00,0x00,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;40  (  
						
		        				 {0x00,0x00,0x01,0x40,0x0F,0x78,0xFE,0x3F,0xF0,0x07,0x00,0x00,0x00,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;41  ) 

        						 //{0x50,0x00,0x50,0x00,0x38,0x00,0x50,0x00,0x50,0x00,0x00,0x00,0x00,0x80,
						  	//	  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;42 (*) *
						  	{0x24,0x01,
							 0xA8,0x00,
							 0x70,0x00,
							 0xFC,0x01,
							 0x70,0x00,
							 0xA8,0x00,
							 0x24,0x01,
							 0x00,0x00,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80}, //   ;42 (*) *
						
        						 //{0x10,0x00,0x10,0x00,0x7C,0x00,0x7C,0x00,0x10,0x00,0x10,0x00,0x00,0x00,
						  	//	  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;43 (+) +
						  	{0xC0,0x00,
							 0xC0,0x00,
							 0xC0,0x00,
							 0xF8,0x07,
							 0xF8,0x07,
							 0xC0,0x00,
							 0xC0,0x00,
						  	 0xC0,0x00,
							 0x00,0x00,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80,
							 0x00,0x80}, //   ;43 (+) +
							 
		   						 {0x00,0x4C,0x00,0x3C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;44 (,) ,
						
		        				 {0xC0,0x00,
							  0xC0,0x00,
							  0xC0,0x00,
							  0xC0,0x00,
							  0xC0,0x00,
							  0xC0,0x00,
							  0xC0,0x00,
						  	  0x00,0x00,
							  0x00,0x00,
							  0x00,0x80,
							  0x00,0x80,
							  0x00,0x80,
							  0x00,0x80,
							  0x00,0x80}, //   ;45 (-) -	  

        						 {0x00,0x0C,0x00,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;46 (.) .
						
        						 {0x00,0x00,0x00,0x0E,0xF8,0x0F,0xFF,0x01,0x07,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;47 (/) /
					
        						 {0xFC,0x03,0xFE,0x07,0x07,0x0E,0x03,0x0C,0x03,0x0C,0x07,0x0E,0xFE,0x07,
						  		  0xFC,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;48 (0) 0
						
		        				 {0x18,0x00,0x0C,0x00,0x06,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;49 (1) 1
						
        						 {0x0C,0x0C,0x0E,0x0E,0x07,0x0F,0x83,0x0D,0xC3,0x0D,0xE3,0x0C,0x7E,0x0C,
						  		  0x1C,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;50 (2) 2
						
        						 {0x04,0x03,0x06,0x07,0x03,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xFF,0x07,
						  		  0xCE,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;51 (3) 3
											
        						 {0x80,0x03,0xC0,0x03,0x70,0x03,0x38,0x03,0x0E,0x03,0xFF,0x0F,0xFF,0x0F,
						  		  0x00,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;52 (4) 4
						
		        				 {0x78,0x03,0x7F,0x07,0x3F,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0E,0xE3,0x07,
								  0xC0,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;53 (5) 5
								
        						 {0xF8,0x01,0xFE,0x07,0x67,0x0E,0x33,0x0C,0x33,0x0C,0x73,0x0C,0xE7,0x07,
						  		  0xC6,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;54 (6) 6
						
        						 {0x03,0x00,0x03,0x00,0x03,0x0F,0xE3,0x0F,0xFB,0x01,0x1F,0x00,0x07,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;55 (7) 7
						
        						 {0x9C,0x03,0xFE,0x07,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0xFE,0x07,
						  		  0x9C,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;56 (8) 8
						
		        				 {0x3C,0x06,0x7E,0x0E,0xE3,0x0C,0xC3,0x0C,0xC3,0x0C,0x67,0x0E,0xFE,0x07,
						  		  0xF8,0x01,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;57 (9) 9
						
        						 {0x00,0x00,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;58 (:) :
														
        						 {0x18,0x4C,0x18,0x3C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;59 (;) ;
						
		        				 {0x40,0x00,0xE0,0x00,0xE0,0x00,0xB0,0x01,0xB0,0x01,0x18,0x03,0x18,0x03,
								  0x0C,0x06,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;60 (<) <
						
        						 {0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,0xB0,0x01,
						  		  0xB0,0x01,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;61 (=) =
						
        						 {0x0C,0x06,0x18,0x03,0x18,0x03,0xB0,0x01,0xB0,0x01,0xE0,0x00,0xE0,0x00,
						  		  0x40,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;62 (>) >
						
        						 {0x18,0x00,0x1C,0x00,0x0E,0x00,0x86,0x1B,0xC6,0x1B,0xE6,0x00,0x7C,0x00,
						  		  0x38,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;63 (?) ?

		        				 {0x00,0x0C,0x00,0x0F,0xC0,0x0F,0xF0,0x0C,0x3C,0x0C,0x0F,0x0C,0x3C,0x0C,
								  0xF0,0x0C,0xC0,0x0F,0x00,0x0F,0x00,0x0C,0x00,0x00,0x00,0x80,0x80,0x80}, //   ;64 (@) Delta
						
        						 {0x00,0x08,0x00,0x0F,0xE0,0x07,0xF8,0x01,0x9E,0x01,0x86,0x01,0x9E,0x01,
						  		  0xF8,0x01,0xE0,0x07,0x00,0x0F,0x00,0x08,0x00,0x00,0x00,0x80,0x80,0x80}, //   ;65 (A) A
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0xFF,0x0C,0xDE,0x07,0x80,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;66 (B) B
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x07,0x0E,0x0E,0x07,0x04,0x02,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;67 (C) C
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;68 (D) D
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,0x63,0x0C,
						  		  0x63,0x0C,0x63,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;69 (E) E
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,
						  		  0x03,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;70 (F) F
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0xC3,0x0C,0xC3,0x0C,
						  		  0xC7,0x0E,0xCE,0x07,0xC4,0x03,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;71 (G) G
						
		        				 {0x00,0x00,0xFF,0x0F,0xFF,0x0F,0x60,0x00,0x60,0x00,0x60,0x00,0x60,0x00,
						  		  0x60,0x00,0x60,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x80,0x80}, //   ;72 (H) H
						
        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,
						  		  0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;73 (I) I
						
        						 {0x00,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0E,0xFF,0x07,0xFF,0x03,
						  		  0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;74 (J) J
						
        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x00,0x60,0x00,0x30,0x00,0x78,0x00,0xEC,0x01,
						  		  0x86,0x07,0x03,0x0E,0x01,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;75 (K) K
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0C,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;76 (L) L
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0F,0x00,0xFC,0x00,0xE0,0x07,0x00,0x0F,0xE0,0x07,
						  		  0xFC,0x00,0x0F,0x00,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x80,0x80}, //   ;77 (M) M
						
        						 {0xFF,0x0F,0xFF,0x0F,0x0E,0x00,0x1C,0x00,0x70,0x00,0xE0,0x00,0x80,0x03,
						  		  0x00,0x07,0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;78 (N) N
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0C,0x03,0x0C,0x03,0x0C,
						  		  0x06,0x06,0xFE,0x07,0xF8,0x01,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;79 (O) O
						
		        				 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0x63,0x00,0x77,0x00,
						  		  0x3E,0x00,0x1C,0x00,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80,0x80,0x80}, //   ;80 (P) P
						
        						 {0xF8,0x01,0xFE,0x07,0x06,0x06,0x03,0x0C,0x03,0x0D,0x03,0x0F,0x03,0x06,
						  		  0x06,0x0E,0xFE,0x1F,0xF8,0x11,0x00,0x00,0x00,0x80,0x80,0x80,0x80,0x80}, //   ;81 (Q) Q
						
        						 {0xFF,0x0F,0xFF,0x0F,0x63,0x00,0x63,0x00,0x63,0x00,0xE3,0x00,0xE3,0x01,
						  		  0xB7,0x07,0x3E,0x0F,0x1C,0x0C,0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;82 (R) R
						
        						 {0x1C,0x03,0x3E,0x07,0x33,0x0E,0x73,0x0C,0x63,0x0C,0x63,0x0C,0xE7,0x0E,
						  		  0xCE,0x07,0x8C,0x03,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;83 (S) S
						
		        				 {0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x0F,0xFF,0x0F,0x03,0x00,
						  		  0x03,0x00,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;84 (T) T
						
        						 {0xFF,0x03,0xFF,0x07,0x00,0x0E,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x0C,
						  		  0x00,0x0E,0xFF,0x07,0xFF,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;85 (U) U
						
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
						  		  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;86 (V) V
						
        						 {0x1F,0x00,0xFE,0x00,0xE0,0x0F,0x00,0x0F,0xF8,0x0F,0xFF,0x00,0x07,0x00,
						  		  0xFF,0x00,0xF8,0x0F,0x00,0x0F,0xE0,0x0F,0xFC,0x01,0x1F,0x00,0x00,0x00}, //   ;87 (W) W
						
		        				 {0x03,0x0C,0x07,0x0E,0x9E,0x07,0xF8,0x01,0xF0,0x00,0xF8,0x01,0x9E,0x07,
						  		  0x07,0x0E,0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;88 (X) X
						
        						 {0x07,0x00,0x1E,0x00,0x38,0x00,0xE0,0x0F,0xE0,0x0F,0x38,0x00,0x1E,0x00,
						  		  0x07,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;89 (Y) Y
						
        						 {0x03,0x0E,0x83,0x0F,0xC3,0x0D,0xF3,0x0C,0x3B,0x0C,0x1F,0x0C,0x07,0x0C,
						  		  0x03,0x0C,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;90 (Z) Z
						
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x22,0x08,0x12,0x08,0xFA,0x0B,0x02,0x08,
						  		  0x02,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;91 ([) 1 small One
						  		
        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x0A,0x0A,0x0B,0x8A,0x0A,0x4A,0x0A,
						  		  0x32,0x0A,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;92 (\) 2 small Two

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x12,0x09,0x0A,0x0A,0x4A,0x0A,0x4A,0x0A,
						  		  0xB2,0x09,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;93 (]) 3 small Three

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0xC2,0x08,0xA2,0x08,0x92,0x08,0xFA,0x0B,
						  		  0x82,0x08,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;94 (^) 4 small Four
						         /*
								 {0xFC,0x00,0x02,0x01,0x79,0x02,0x85,0x02,0x85,0x02,0x85,0x02,0x85,0x02,
						  		  0x49,0x02,0x02,0x01,0xFC,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_) � copywrite
								 */
								 {0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,0x00,0x03,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;95 (_)  _

        						 {0xF8,0x03,0x04,0x04,0x02,0x08,0x1A,0x0B,0xA2,0x08,0x42,0x08,0xA2,0x08,
						  		  0x1A,0x0B,0x02,0x08,0x04,0x04,0xF8,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   ;96 (`)  e small e

        						 {0x30,0x07,0xB8,0x0F,0x98,0x0D,0xD8,0x0C,0xD8,0x0C,0xF8,0x07,0xF0,0x0F,
						  		  0x00,0x08,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;97 (a)  a

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;98 (b)  b

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0x30,0x06,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;99 (c)  c

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xFF,0x0F,
						  		  0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;100 (d)  d

        						 {0xE0,0x03,0xF0,0x07,0xD8,0x0E,0xD8,0x0C,0xD8,0x0C,0xF0,0x06,0xE0,0x02,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;101 (e)  e

        						 {0x18,0x00,0xFE,0x0F,0xFF,0x0F,0x1B,0x00,0x1B,0x00,0x03,0x00,0x00,0x00,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;102 (f)  f

        						 {0xE0,0x33,0xF0,0x77,0x38,0x6E,0x18,0x6C,0x18,0x6C,0x30,0x66,0xF8,0x7F,
						  		  0xF8,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;103 (g)  g

        						 {0xFF,0x0F,0xFF,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;104 (h)  h

        						 {0xFB,0x0F,0xFB,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;105 (i)  i

        						 {0x00,0x60,0x00,0x60,0xFB,0x7F,0xFB,0x3F,0x00,0x00,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;106 (j)  j

        						 {0xFF,0x0F,0xFF,0x0F,0xC0,0x01,0xE0,0x00,0xF0,0x03,0x18,0x0F,0x08,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;107 (k)  k

        						 {0xFF,0x0F,0xFF,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;108 (l)  l

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,
						  		  0x30,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,0xF0,0x0F,0x00,0x00,0x00,0x80}, //   ;109 (m)  m

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x18,0x00,0xF8,0x0F,
						  		  0xF0,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;110 (n)  n

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;111 (o)  o

        						 {0xF8,0x7F,0xF8,0x7F,0x30,0x06,0x18,0x0C,0x18,0x0C,0x38,0x0E,0xF0,0x07,
						  		  0xE0,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;112 (p)  p

        						 {0xE0,0x03,0xF0,0x07,0x38,0x0E,0x18,0x0C,0x18,0x0C,0x30,0x06,0xF8,0x7F,
						  		  0xF8,0x7F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;113 (q)  q

        						 {0xF8,0x0F,0xF8,0x0F,0x30,0x00,0x18,0x00,0x18,0x00,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;114 (r)  r

        						 {0x70,0x06,0xF8,0x0E,0xD8,0x0C,0xD8,0x0D,0x98,0x0D,0xB8,0x0F,0x30,0x07,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;115 (s)  s

        						 {0x18,0x00,0xFE,0x07,0xFF,0x0F,0x18,0x0C,0x18,0x0C,0x00,0x00,0x00,0x80,
						  		  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;116 (t)  t

        						 {0xF8,0x07,0xF8,0x0F,0x00,0x0C,0x00,0x0C,0x00,0x0C,0x00,0x06,0xF8,0x0F,
						  		  0xF8,0x0F,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;117 (u)  u

        						 {0x38,0x00,0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;118 (v)  v

        						 {0x18,0x00,0xF8,0x01,0xE0,0x0F,0x00,0x0E,0xC0,0x0F,0xF8,0x01,0x38,0x00,
						  		  0xF8,0x01,0xC0,0x0F,0x00,0x0E,0xE0,0x0F,0xF8,0x01,0x18,0x00,0x00,0x00}, //   	;119 (w)  w

        						 {0x18,0x0C,0x38,0x0E,0xF0,0x07,0xC0,0x01,0xF0,0x07,0x38,0x0E,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;120 (x)  x

        						 {0x18,0x00,0x78,0x60,0xE0,0x63,0x80,0x7F,0x00,0x3E,0x80,0x0F,0xE0,0x03,
						  		  0x78,0x00,0x18,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;121 (y)  y

        						 {0x18,0x0C,0x18,0x0F,0x98,0x0F,0xD8,0x0D,0xF8,0x0C,0x78,0x0C,0x18,0x0C,
						  		  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;122 (z)  z 
								
								 {0x80,0x00,0xC0,0x00,0xE0,0x00,0xF0,0x00,0xF8,0x00,0xF0,0x00,0xE0,0x00,
								  0xC0,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;123 ({)  	Arrow Up
								
								 {0x08,0x00,0x18,0x00,0x38,0x00,0x78,0x00,0xF8,0x00,0x78,0x00,0x38,0x00,
								  0x18,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;124 (|)  	Arrow Down

        						 {0x00,0x08,0x00,0x08,0xC0,0x08,0xF0,0x08,0xFF,0x0F,0xF1,0x00,0xC1,0x00,
								  0x01,0x00,0x01,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;125 (})  	Rising Edge
					
								 {0x01,0x00,0x01,0x00,0x31,0x00,0xF1,0x00,0xFF,0x0F,0xF0,0x08,0x30,0x08,
								  0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;126 (~)	Falling Edge

        						 {0x00,0x78,0xF0,0x7F,0xFF,0x07,0x0F,0x00,0x00,0x00,0x00,0x80,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;127 (DEL) / for per Division
								
		        				 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x02,0x7C,0x01,0x60,0x7F,0x7C,0x7F,0x1F,
								  0x02,0x03,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x00,0x00,0x80}, //   	;128 (�)  milli Volt per Division
															
        						 {0x03,0x00,0x0F,0x00,0x7C,0x00,0xF0,0x01,0x80,0x0F,0x00,0x0E,0x80,0x0F,
								  0xF0,0x01,0x7C,0x00,0x0F,0x00,0x03,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;129 (?)  Volt per Division
								
        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7E,0x32,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;130 (�) ns per Division
						
        						 {0x00,0x00,0x00,0x00,0x7F,0xC4,0x7F,0xDB,0x10,0xDB,0x1F,0xDB,0x1F,0x23,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;131 (�)  �s per Division								

        						 {0x00,0x00,0x7F,0x26,0x7F,0x6F,0x02,0x4D,0x01,0x59,0x7F,0x7B,0x7F,0x32,
								  0x02,0x00,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;132 (�) ms per Division
						
        						 {0x00,0x00,0xC0,0x04,0xE0,0x0D,0xA0,0x09,0x20,0x0B,0x60,0x0F,0x40,0x06,
								  0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80},//    	;133 (�)  s per Division								

        						 {0x20,0x00,0xA0,0x00,0xB8,0x02,0xA8,0x00,0x28,0x00,0x08,0x00,0x7F,0x00,
								  0x3E,0x00,0x1C,0x00,0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80},//    	;134 (�) Ground Sign

        						 {0x00,0x00,0xC0,0x00,0xE0,0x01,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;135 (�) List Count Dot

        						 {0xF0,0x07,0xFE,0x3F,0x0F,0x78,0x41,0x41,0x60,0x03,0x70,0x07,0x60,0x03,
								  0x41,0x41,0x0F,0x78,0xFE,0x7F,0xF0,0x07,0x00,0x00,0x00,0x80,0x00,0x80}, //	;136 (�) Channel Zerolevel Symbol

        						 {0x80,0x00,0xC0,0x01,0x80,0x03,0x00,0x07,0x00,0x0E,0x00,0x07,0x80,0x03,
						  		  0xE0,0x00,0x70,0x00,0x38,0x00,0x1C,0x00,0x0E,0x00,0x07,0x00,0x02,0x00}, //   	;137 (�) Menu Hacken

        						 {0x00,0x30,0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x03,0x00,
								  0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x00,0x00,0x80}, //   	;138 (�) positive Pulse

        						 {0x03,0x00,0x03,0x00,0xFF,0x3F,0xFF,0x3F,0x00,0x30,0x00,0x30,0x00,0x30,
								  0x00,0x30,0xFF,0x3F,0xFF,0x3F,0x03,0x00,0x03,0x00,0x00,0x00,0x00,0x80}, //   	;139 (�) negative Pulse

        						 {0x80,0x00,0xC0,0x01,0xC0,0x01,0x60,0x03,0x60,0x03,0x30,0x06,0x30,0x06,
								  0x18,0x0C,0x18,0x0C,0x0C,0x18,0x0C,0x18,0x04,0x10,0x00,0x00,0x00,0x80}, //   	;140 (�) gro�es kleiner als
								
        						 {0x04,0x10,0x0C,0x18,0x0C,0x18,0x18,0x0C,0x18,0x0C,0x30,0x06,0x30,0x06,
								  0x60,0x03,0x60,0x03,0xC0,0x01,0xC0,0x01,0x80,0x00,0x00,0x00,0x00,0x80},// 	;141 (?) gro�es gr��er als

        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x00,0x60,0x03,0x7F,0x1F,0x7F,0x7C,
								  0x40,0x60,0x20,0x7C,0x7F,0x1F,0x7F,0x03,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;142 (�) � Volt per Division
								
        						 {0x00,0x00,0x7F,0x03,0x7F,0x1F,0x1C,0x7C,0x36,0x60,0x63,0x7C,0x41,0x1F,
								  0x00,0x03,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   	;143 (?) kilo Volt per Division
								
        						 {0x00,0x00,0x00,0x00,0x80,0x00,0xC0,0x30,0x60,0x3C,0x7F,0x0F,0x7F,0x0B,
								  0x40,0x0F,0x20,0x3C,0x7F,0x30,0x7F,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;144 (?) � Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x02,0x0F,0x01,0x0B,0x7F,0x0F,0x7F,0x3C,
								  0x02,0x30,0x01,0x00,0x7F,0x00,0x7E,0x00,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;145 (�) milli Ampere per Division
								
        						 {0x00,0x10,0x00,0x1E,0xC0,0x0F,0xF8,0x03,0x3E,0x03,0x06,0x03,0x3E,0x03,
								  0xF8,0x03,0xC0,0x0F,0x00,0x1E,0x00,0x10,0x00,0x00,0x00,0x80,0x00,0x80}, //   	;146 (�) Ampere per Division
								
        						 {0x00,0x00,0x7F,0x30,0x7F,0x3C,0x1C,0x0F,0x36,0x0B,0x63,0x0F,0x41,0x3C,
								  0x00,0x30,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;147 (�) kilo Ampere per Division

        						 {0x03,0x00,0x03,0x00,0x03,0x00,0xFF,0x03,0xFF,0x03,0x03,0x00,0x03,0x00,
								  0xF3,0x1F,0xE0,0x0F,0xC0,0x07,0x80,0x03,0x00,0x01,0x00,0x00,0x00,0x80}, //    ;148 (�) Trigger Sign

        						 {0x08,0x00,0x0C,0x00,0x0E,0x00,0xFF,0x01,0xFF,0x01,0x0E,0x00,0x0C,0x00,
								  0x08,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //    ;149 (�) Overvoltage
								
        						 {0x20,0x00,0x60,0x00,0xE0,0x00,0xFF,0x01,0xFF,0x01,0xE0,0x00,0x60,0x00,
								  0x20,0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}, //   ;150 (�) Undervoltage

        						 {0xC6,0x00,0xE7,0x00,0xF3,0x00,0xFB,0x00,0xDF,0x00,0xCE,0x00,0x00,0x00,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								      /*
        						 {0x66,0x00,0x73,0x00,0x7B,0x00,0x6F,0x00,0x66,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								     */
                                  /*
        						 {0x42,0x00,0x61,0x00,0x51,0x00,0x49,0x00,0x46,0x00,0x00,0x00,0x00,0x80,
								  0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80,0x00,0x80}}; //   ;151 (�) Square �
								 */
								  
								  //    ;152 (�)
								  //    ;153 (�)
								  //    ;154 (�)
								  //    ;155 (�)
								  //    ;156 (�)
								  //    ;157 (?)
								  //    ;158 (�)
								  //    ;159 (�)
								  //    ;160 ( )

unsigned char bitbmBigArrowUp[] = { 32, 13,
								0x00, 0x01, 0x00, 0x00,
								0x00, 0x07, 0xC0, 0x00,
								0x00, 0x1F, 0xF0, 0x00,
								0x00, 0x7F, 0xFC, 0x00,
								0x01, 0xFF, 0xFF, 0x00,
								0x07, 0xFF, 0xFF, 0xC0, 
								0x1F, 0xFF, 0xFF, 0xF0,
								0x7F, 0xFF, 0xFF, 0xFC, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x0F, 0xE0, 0x00,
								0x00, 0x1F, 0xF0, 0x00,
								0x00, 0x3F, 0xF8, 0x00};
					

unsigned char bitbmBigArrowDown[] = { 32, 13,
								0x00, 0x3F, 0xF8, 0x00, 
								0x00, 0x1F, 0xF0, 0x00, 
								0x00, 0x0F, 0xE0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x7F, 0xFF, 0xFF, 0xFC, 
								0x1F, 0xFF, 0xFF, 0xF0, 
								0x07, 0xFF, 0xFF, 0xC0, 
								0x01, 0xFF, 0xFF, 0x00, 
								0x00, 0x7F, 0xFC, 0x00, 
								0x00, 0x1F, 0xF0, 0x00, 
								0x00, 0x07, 0xC0, 0x00, 
								0x00, 0x01, 0x00, 0x00};
						
unsigned char bitbmCycleArrow[] = { 16, 14,
								0x00, 0x60, 
								0x10, 0x70, 
								0x10, 0x18, 
								0x38, 0x0C, 
								0x38, 0x06, 
								0x7C, 0x06, 
								0x7C, 0x06, 
								0xFE, 0x06, 
								0xFE, 0x06, 
								0x38, 0x06, 
								0x38, 0x0C, 
								0x1C, 0x18, 
								0x07, 0xF0, 
								0x01, 0xE0};
						
unsigned char bitbmSelectCycleArrow[] = { 24, 14, 
								0x00, 0x06, 0x00, 
								0x10, 0x17, 0x00, 
								0x10, 0x11, 0x80, 
								0x38, 0x38, 0xC0, 
								0x38, 0x38, 0x60, 
								0x7C, 0x7C, 0x60, 
								0x7C, 0x7C, 0x60, 
								0xFE, 0xFE, 0x60, 
								0xFE, 0xFE, 0x60, 
								0x38, 0x00, 0x60, 
								0x38, 0x00, 0xC0, 
								0x1C, 0x01, 0x80, 
								0x07, 0xFF, 0x00, 
								0x01, 0xFE, 0x00};
										
unsigned char bitbmTimebaseOffset[] = { 16, 12, 
								0x07, 0xFF, 
								0x07, 0xFF, 
								0x07, 0xFF, 
								0x07, 0x00, 
								0x07, 0x00, 
								0x07, 0x00, 
								0x7F, 0xF0, 
								0x3F, 0xE0, 
								0x1F, 0xC0, 
								0x0F, 0x80, 
								0x07, 0x00, 
								0x02, 0x00};
										
unsigned char bitbmSubMenu[] = { 40, 13, 
								 0x00, 0x00, 0x00, 0x10, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0xEF, 0x7C, 0xE7, 0x9F, 0xC0, 
								 0x46, 0x39, 0xCF, 0x3F, 0x80, 
								 0x00, 0x13, 0x9E, 0x7F, 0x00, 
								 0x00, 0x17, 0x3C, 0xFE, 0x00, 
								 0x00, 0x00, 0x00, 0x1C, 0x00, 
								 0x00, 0x00, 0x00, 0x18, 0x00, 
								 0x00, 0x00, 0x00, 0x10, 0x00};						

// BF added new GND symbol on the left side
unsigned char bitbm_GND[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								//GND symbol
								0x02, 0x00,
								0x0F, 0x90,
								0x00, 0x10,
								0x07, 0x00,
								0x00, 0x00,						
								0x02, 0x00};


// BF corrected channel 1 sign
unsigned char bitbmCH1[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x03, 0x00,
								0x05, 0x00,
								0x01, 0x00,
								0x01, 0x00,						
								0x01, 0x10,
								0x01, 0x18,
								0x00, 0x1C,
								0x07, 0xFE,//0x03, 0xFE, middle
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};

// BF corrected ground sign on the right side							
unsigned char bitbmCH1_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0x20,
								0x00, 0x60,
								0x00, 0xA0,
								0x00, 0x20,
								0x00, 0x20,	
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
/* BF -> not used at this time								
unsigned char bitbmCH1_XY[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x10,
								0x02, 0x38,
								0x06, 0x7C,
								0x0A, 0xFE,
								0x02, 0x10,						
								0x02, 0x10,
								0x02, 0x10,
								0x02, 0x7C,
								0x00, 0x00,
								0x00, 0x38,
								0x00, 0x00,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};	
*/							
// BF corrected channel 2 sign
unsigned char bitbmCH2[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x01, 0x00,
								0x02, 0x00,						
								0x04, 0x10,
								0x0F, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side									
unsigned char bitbmCH2_gnd[] = { 16, 29,
								0x00, 0x00,
								0x01, 0xE0,
								0x00, 0x10,
								0x00, 0x10,
								0x00, 0x20,
								0x00, 0x40,						
								0x08, 0x80,
								0x19, 0xF0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
// BF corrected channel 3 sign
unsigned char bitbmCH3[] = { 16, 16,
								0x00, 0x00,
								0x07, 0x00,
								0x08, 0x80,
								0x00, 0x80,
								0x03, 0x00,
								0x00, 0x80,						
								0x08, 0x90,
								0x07, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side	
unsigned char bitbmCH3_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0xE0,
								0x01, 0x10,
								0x00, 0x10,
								0x00, 0x60,
								0x00, 0x10,						
								0x09, 0x10,
								0x18, 0xE0,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
// BF corrected channel 4 sign
unsigned char bitbmCH4[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x80,
								0x02, 0x80,
								0x04, 0x80,
								0x08, 0x80,
								0x0F, 0xC0,						
								0x00, 0x90,
								0x00, 0x98,
								0x00, 0x1C,
								0x07, 0xFE,
								0x00, 0x1C,
								0x00, 0x18,
								0x00, 0x10,
								0x00, 0x00,
								0x00, 0x00,						
								0x00, 0x00};
// BF corrected ground sign on the right side	
unsigned char bitbmCH4_gnd[] = { 16, 29,
								0x00, 0x00,
								0x00, 0x60,
								0x00, 0xA0,
								0x01, 0x20,
								0x02, 0x20,
								0x03, 0xF0,						
								0x08, 0x20,
								0x18, 0x20,
								0x38, 0x00,
								0x7F, 0xC0,
								0x38, 0x40,
								0x19, 0xF0,
								0x08, 0x00,
								0x00, 0xE0,
								0x00, 0x00,						
								0x00, 0x40,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
						
unsigned char bitbmMin[] = { 16, 16,
								0x01, 0x00,
								0x01, 0x00,
								0x03, 0x80,
								0x03, 0x80,
								0x07, 0xC0,
								0x07, 0xC0,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
                                						
unsigned char bitbmMax[] = { 16, 16,
								0x00, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x01, 0x00,
								0x07, 0xC0,
								0x07, 0xC0,
								0x03, 0x80,
								0x03, 0x80,
								0x01, 0x00,
								0x01, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

// BF corrected trigger symbol	
unsigned char bitbmTrigger[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x10,
								0x7C, 0x18,
								0x10, 0x1C,
								0x17, 0xFE,
								0x10, 0x1C,
								0x10, 0x18,
								0x10, 0x10,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
/*	
unsigned char bitbmTrigger[] = { 16, 16,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x7C, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};
*/
unsigned char bitbmTrigAVG[] = { 16, 16,
								0x00, 0x40,
								0x0E, 0x80,
								0x11, 0x00,
								0x22, 0x80,
								0x24, 0x80,
								0x28, 0x80,
								0x11, 0x10,
								0x2E, 0x18,
								0x40, 0x1C,
								0x07, 0xFE,
								0x7C, 0x1C,
								0x10, 0x18,
								0x10, 0x10,
								0x10, 0x00,
								0x10, 0x00,
								0x10, 0x00};
                                                                						
unsigned char bitbmCoppAC[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};

// BF corrected DC sign								
unsigned char bitbmCoppDC[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00, 
								0x30, 0x00, 
								0x10, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
// BF corrected DC/INV sign								
unsigned char bitbmCoppInv[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x30, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};								
// BF corrected DC/BW sign
unsigned char bitbmCoppLimit[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00,
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00};								
                                   						
unsigned char bitbmCoppACInv[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x30, 0x00,
								0x10, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x00, 0x00, 
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};                                   						
						
unsigned char bitbmCoppACLimit[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00, 
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,
								0x00, 0x00,                                 								
								0x00, 0x00};								
// BF corrected DC/INV/BW sign						
unsigned char bitbmCoppInvLimit[] = { 16, 29,
								0x07, 0x86, 
								0x04, 0x49, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x04, 0x50, 
								0x14, 0x49, 
								0x37, 0xC6, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0,
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,                                 								
								0x00, 0x00};								
								
														
unsigned char bitbmCoppFull[] = { 16, 29,
								0x01, 0x06, 
								0x02, 0x89, 
								0x02, 0x90, 
								0x02, 0x90, 
								0x04, 0x50, 
								0x07, 0xD0, 
								0x14, 0x49, 
								0x34, 0x46, 
								0x70, 0x00, 
								0xFF, 0xF8,//0xFF, 0xC0, 
								0x70, 0x00,
								0x37, 0x22,
								0x14, 0xA2,
								0x04, 0xA2,
								0x07, 0xAA,
								0x04, 0xAA,
								0x04, 0xAA,
								0x04, 0x94,
								0x07, 0x14,								
								0x00, 0x00,
								0x59, 0x42,
								0x59, 0x42,
								0x55, 0x42,
								0x55, 0x24,
								0x55, 0x24,
								0x55, 0x24,
								0x53, 0x24,
								0x53, 0x18,
								0x00, 0x00};								
							
unsigned char bitbmStopTrigger[] = { 24, 17,
								0x00, 0x7F, 0x00,
								0x00, 0x80, 0x80,
								0x01, 0x7F, 0x40,
								0x02, 0xFF, 0xA0,
								0x05, 0xFF, 0xD0,
								0x0B, 0xFF, 0xE8,
								0x14, 0x8B, 0x34,
								0x15, 0xD5, 0x54,
								0x14, 0xD5, 0x34,
								0x16, 0xD5, 0x74,
								0x14, 0xDB, 0x74,
								0x0B, 0xFF, 0xE8,
								0x05, 0xFF, 0xD0,
								0x02, 0xFF, 0xA0,
								0x01, 0x7F, 0x40,
								0x00, 0x80, 0x80,
								0x00, 0x7F, 0x00};

/*BF not used							
unsigned char bitbmStopTrigger_stop[] = { 24, 5,
								0x03, 0x74, 0xE0,
								0x02, 0x2A, 0xA0,
								0x03, 0x2A, 0xE0,
								0x01, 0x2A, 0x80,
								0x03, 0x24, 0x80};										
*/
unsigned char bitbmWTAG[] =    {88, 87,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFC, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x00, 0x00,
								0x00, 0x00, 0x1F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFE, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x3F, 0xFF, 0xC0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0x1F, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x0F, 0xFF, 0xF0, 0x00,
								0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xF8, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x07, 0xFF, 0xFC, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x07, 0xFF, 0xFE, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x03, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x80, 0x01, 0xFF, 0xFF, 0x00,
								0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0x00, 0x01, 0xFF, 0xFF, 0x80,
								0x00, 0xF0, 0x7F, 0xFF, 0xFF, 0xFF, 0x03, 0x81, 0xFF, 0xFF, 0xC0,
								0x01, 0xF8, 0x3F, 0xFF, 0xFF, 0xFF, 0x0F, 0xE0, 0xFF, 0xFF, 0xC0,
								0x03, 0xFC, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xE0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x1F, 0xF0, 0xFF, 0xFF, 0xE0,
								0x07, 0xFE, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0xFF, 0xFF, 0xF0,
								0x0F, 0xFF, 0x1F, 0xFF, 0xFF, 0xFE, 0x3F, 0xF8, 0x7F, 0xFF, 0xF0,
								0x0F, 0xFF, 0x0F, 0xFF, 0xFF, 0xFC, 0x7F, 0xF8, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFC, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0x7F, 0xFE, 0x7F, 0xFF, 0xF8,
								0x1F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x7F, 0xFF, 0xFC,
								0x3F, 0xFF, 0x8F, 0xFF, 0xFF, 0xFC, 0xFF, 0xFE, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xC7, 0xFF, 0xFF, 0xF8, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFC,
								0x3F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x3F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xE7, 0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF7, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0x7F, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFE,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF3, 0xFF, 0xFF, 0xE3, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xFB, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xC7, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF,
								0xFF, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xEF, 0xFF, 0xFF,
								0x7F, 0xFF, 0xF9, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFF,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xCF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0xDF, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x7F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE7, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xE3, 0xFF, 0xFE,
								0x3F, 0xFF, 0xFC, 0xFF, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x9F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x3F, 0xFF, 0xFE, 0x7F, 0xFF, 0x1F, 0xFF, 0xFF, 0xF3, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x7F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF1, 0xFF, 0xFC,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFF, 0x3F, 0xFF, 0xFF, 0xF0, 0xFF, 0xF8,
								0x1F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFE, 0x3F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0xFF, 0xF8,
								0x0F, 0xFF, 0xFF, 0x1F, 0xFE, 0x3F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x0F, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xF8, 0x7F, 0xF0,
								0x07, 0xFF, 0xFF, 0x0F, 0xFC, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x07, 0xFF, 0xFF, 0x87, 0xF8, 0x7F, 0xFF, 0xFF, 0xFC, 0x3F, 0xE0,
								0x03, 0xFF, 0xFF, 0x83, 0xF0, 0xFF, 0xFF, 0xFF, 0xFC, 0x1F, 0xC0,
								0x01, 0xFF, 0xFF, 0x81, 0xE0, 0xFF, 0xFF, 0xFF, 0xFE, 0x0F, 0x80,
								0x01, 0xFF, 0xFF, 0x80, 0x00, 0xFF, 0xFF, 0xFF, 0xFE, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0xFF, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x7F, 0xFF, 0xC0, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x3F, 0xFF, 0xE0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x1F, 0xFF, 0xF0, 0x03, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00,
								0x00, 0x0F, 0xFF, 0xF0, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x07, 0xFF, 0xF8, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x03, 0xFF, 0xFC, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00,
								0x00, 0x01, 0xFF, 0xFE, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00,
								0x00, 0x00, 0x3F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFC, 0x00, 0x00,
								0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00,
								0x00, 0x00, 0x07, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xE0, 0x00, 0x00,
								0x00, 0x00, 0x01, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x80, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x0F, 0xFF, 0xFF, 0xFF, 0xF8, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x03, 0xFF, 0xFF, 0xFF, 0xC0, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x3F, 0xFF, 0xFE, 0x00, 0x00, 0x00, 0x00,
								0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x80, 0x00, 0x00, 0x00, 0x00};







// ===========================================================
// Parameters for Each Peripheral, Excerpted From The PTF File



// ------------------
// Parameters for altera_nios named cpu

// CPU_Architecture     = nios_32             
// mstep                = 1                   
// multiply             = 0                   
// rom_decoder          = 1                   
// wvalid_wr            = 0                   
// num_regs             = 256                 
// do_generate          = 1                   
// include_debug        = 0                   
// include_trace        = 0                   
// reset_slave          = boot_monitor_rom/s1 
// reset_offset         = 0x0                 
// vecbase_slave        = ext_ram/s1          
// vecbase_offset       = 0x03ff00            
// support_interrupts   = 1                   
// implement_forward_b1 = 0                   
// support_rlc_rrc      = 0                   
// advanced             = 1                   
// CONSTANTS            = 
// mainmem_slave        = ext_ram/s1          
// datamem_slave        = ext_ram/s1          
// maincomm_slave       = uart1/s1            
// debugcomm_slave      = uart2_debug/s1      
// germs_monitor_id     = std_32_2.0          


// ------------------
// Parameters for altera_avalon_onchip_memory named boot_monitor_rom

// Writeable              = 0     
// Size_Value             = 1     
// Size_Multiple          = 1024  
// Contents               = blank 
// Shrink_to_fit_contents = 0     
// CONTENTS               = srec  


// ------------------
// Parameters for altera_avalon_uart named uart1

// baud             = 115200   
// data_bits        = 8        
// fixed_baud       = 1        
// parity           = N        
// stop_bits        = 2        
// use_cts_rts      = 0        
// use_eop_register = 0        
// sim_true_baud    = 0        
// sim_char_stream  = g40000\n 


// ------------------
// Parameters for altera_avalon_pio named seven_seg_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named speed_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_timer named timer1

// always_run           = 0     
// fixed_period         = 0     
// snapshot             = 1     
// period               = 1     
// period_units         = msec  
// reset_output         = 0     
// timeout_pulse_output = 0     
// mult                 = 0.001 


// ------------------
// Parameters for altera_avalon_pio named led_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named button_pio

// has_tri   = 0    
// has_out   = 0    
// has_in    = 1    
// edge_type = ANY  
// irq_type  = EDGE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named lcd_pio

// has_tri   = 1    
// has_out   = 0    
// has_in    = 0    
// edge_type = NONE 
// irq_type  = NONE 
// capture   = 0    


// ------------------
// Parameters for altera_avalon_pio named direction_pio

// has_tri   = 0    
// has_out   = 1    
// has_in    = 0    
// capture   = 0    
// edge_type = NONE 
// irq_type  = NONE 


// ------------------
// Parameters for altera_avalon_uart named uart2_debug

// baud             = 115200 
// data_bits        = 8      
// fixed_baud       = 1      
// parity           = N      
// stop_bits        = 1      
// use_cts_rts      = 0      
// use_eop_register = 0      
// sim_true_baud    = 0      
// sim_char_stream  = 


// ------------------
// Parameters for altera_nios_dev_board_sram32 named ext_ram

// sram_memory_size  = 256  
// sram_memory_units = 1024 
// sram_data_width   = 32   
// CONTENTS          = srec 


// ------------------
// Parameters for altera_nios_dev_board_flash named ext_flash

// CONTENTS = srec 


// end of file


/* BF
//Macros defined in CDK -> Excalibur

#define nm_mult(_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("usr0 %0,%2 ; does mult" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})


#define nm_math(_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("mov %%r0,%2\n\tusr1 %0 ; does math" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})



#define nm_math_pfx(_p,_x,_y) ({\
	int __x = (_x), __y = (_y);\
	asm volatile("mov %%r0,%2\n\tpfx " #_p "\n\tusr1 %0 ; does math" \
	: "=r" (__x) \
	: "0" (__x), "r" (__y));\
	__x;\
	})


*/
