
#include "floatstr_t.h"
#include <stdio.h>
#include <stdint.h>
#include <nios.h>

#define Space			32

#define S_Slash 		127
#define S_uV 			142
#define S_mV 			128
#define S_V  			129	
#define S_kV  			143	
#define S_uA 			144
#define S_mA 			145
#define S_A  			146	
#define S_kA 			147
#define S_nS 			130	
#define S_uS 			131	
#define S_mS 			132
#define S_S  			133
#define Ground_Sign		134
#define Text_Count_Dot		135
#define Zero_Level_Sym		136
#define Menu_Select		137

#define Pos_Pulse		138
#define Neg_Pulse		139
#define Big_Smaller		140
#define Big_Bigger		141

#define Trigger_Sign		148
#define OverVolt_Sign		149
#define UnderVolt_Sign		150
#define Square_Sign    		151

#define PI 3.14159265358979323
//#define M_PI 3.14159265358979323846264338327

#define	STX			0x02
#define	ETX			0x03

#define SPI_DELAY16     175     // >150 us for shifting out a 16 bit value 

// BF insert
//#define FFT_LENGTH 		1024 //512  	 	// number of digitized values
//#define FFT_LEVEL 		10   //9         	// number of butterfly levels 10 = ld(1024)
#define FFT_OFF			0		// FFT mode - not active
#define FFT_MAGN		1		// FFT mode - Magnitude in linear division
#define FFT_PHAS		2		// FFT mode - Phase
#define FFT_REAL		3		// FFT mode - Real part
#define FFT_IMAG		4		// FFT mode - Imaginary part
#define FFT_REIM		5		// FFT mode - Real + Imaginary
#define FFT_PWSP		6		// FFT mode - Power Spectrum in logarithmic division
#define FFT_PWDN		7		// FFT mode - Power Density Spectrum in logarithmic division

#define FFT_512			512
#define FFT_1K			1024
#define FFT_2K			2048
#define FFT_4K			4096

#define FFT_INTFACT		32768   //1024	//256

#define MATH_OFF		0		// MATH mode - not active
#define MATH_FFT		1		// MATH mode - FFT
#define MATH_MUL		2		// MATH mode - multiply
#define MATH_SUB		3		// MATH mode - subtract
#define MATH_ADD		4		// MATH mode - add

#define DRAW_FAST		292		// Draw Mode - fast pixel connection
#define DRAW_ACC		293		// Draw Mode - accurate line function with Bresenham algorithm
#define DRAW_PIX		294		// Draw Mode - pixel only

#define SQRT_PREC		10
#define SQRT_ITER		42      	// Max iterations
#define SQRT_EPS		1       	// Precision

#define USTB_OFF		0		// USTB mode - not active
#define USTB_ROLL		284		// USTB mode - roll mode
#define USTB_SHIFT		286		// USTB mode - shift mode
#define USTB_FORWARD		0		// USTB direction - forward
#define USTB_REVERSE		1		// USTB direction - reverse 
#define USTB_PERM		288		// USTB display mode - permanent
#define USTB_STEP		289		// USTB display mode - stepwise 
#define USTB_8KB		296		// USTB buffer size
#define USTB_16KB		297		// USTB buffer size
#define USTB_32KB		298		// USTB buffer size

#define TRIG_FREE		91
#define TRIG_AUTO		92
#define TRIG_NORM		93
#define TRIG_COMB		94

#define TRIG_EDGE		1
#define TRIG_PULS		2
#define TRIG_PATT		3



#define TRIG_CH1		137
#define TRIG_CH2		138
#define TRIG_CH3		139
#define TRIG_CH4		140
#define TRIG_ALT		141		// edge trigger only
#define TRIG_EXT		142		// for pulse 141
#define TRIG_TV			143		// edge trigger only


#define ADD_ON			234

#define AVRG_OFF		254
#define AVRG_2			255
#define AVRG_4			256

#define FILT_OFF		311
#define PRO			1
#define IIR			2
#define FIR			3




#define LOGA_OFF		340
#define LOGA_TTL		341
#define LOGA_CMOS		342
#define LOGA_LVTTL		343
#define LOGA_CM25		344
#define LOGA_CM18		345
#define LOGA_RS232		346

#define OFF			0
#define ON			1

#define BTN_STOP		37
#define BTN_SINGLE		38
#define BTN_OFF			240
#define BTN_ON			241
#define DOWN_ARROW		242
#define UP_ARROW		243
#define DOWN_ARROW_INACTIVE	244
#define UP_ARROW_INACTIVE	245
#define INACTIVE		246
#define NONE			91

#define GRID_HEIGHT		400
#define GRID_ZERO		GRID_HEIGHT/2
#define GRID_WIDTH		600
#define GRID_XY			400
#define GRID_XY_XOFFS		120
#define GRID_XOFFS		20
#define GRID_YOFFS		20
#define GRID_XOFFS_FFT		3	// BF 64
#define GRID_YOFFS_FFT		20
#define GRID_HEIGHT_FFT		400
#define GRID_WIDTH_FFT		512
#define TOP_PLANE_MIN		0
#define TOP_PLANE_MAX		360
#define GRID_PLANE_MIN		360	//400	//380
#define GRID_PLANE_MAX		8480	//8440	//8500	//8120
#define BOTT_PLANE_MIN		8480	//8500	//8140
#define BOTT_PLANE_MAX		9600
#define SCR_PLANE_MIN		0
#define SCR_PLANE_MAX		9600

#define BLOCKSIZE 		2048			// KB screenshot export function

#define TRIGO_CHECKSUM	(unsigned long)	0x55AA55AA


//! voltage ranges
typedef enum
{
	e1mV, //!< 1 mV/div
	e2mV, //!< 2 mV/div
	e5mV, //!< 5 mV/div
	e10mV, //!< 10 mV/div
	e20mV, //!< 20 mV/div
	e50mV, //!< 50 mV/div
	e100mV, //!< 100 mV/div
	e200mV, //!< 200 mV/div
	e500mV, //!< 500 mV/div
	e1V, //!< 1 V/div
	e2V, //!< 2 V/div
	e5V, //!< 5 V/div
	e10V, //!< 10 V/div
	e20V, //!< 20 V/div
	e50V, //!< 50 V/div
	e100V, //!< 100 V/div
} voltageRange_t;




//! channel number 
typedef enum
{
	eCh1, //!< channel 1
	eCh2, //!< channel 2
	eCh3, //!< channel 3
	eCh4, //!< channel 4
	eChM, //!< math channel
} channelNum_t;


//! general channel data
typedef struct
{
	uint32_t active;
	uint32_t voltrange;
	uint32_t coupling;
	uint32_t bwlimit;
	uint32_t invert;
	int32_t triggerLevel;		// trigger screen position
	int32_t triggerLevelOld;	// old trigger screen position
	int32_t zeroLevel;		// zero line screen position
	int32_t zeroVirtualLevel;
	int32_t zeroVirtualLevelOld;
	int32_t zeroVirtualLevelXY;
	int32_t DAC_Offset;
	uint16_t switches;
	float vargain;
	/* change flags */
	//uint32_t flgNewRange;
	
	unsigned char *signal;		// pointer to the signal buffer
	
} channelData_t;

//! math channel data
typedef struct
{
	uint32_t active;
	uint32_t voltrange;
	int32_t zerolevel;		// zero line screen position
	int32_t virtualzero;
	//virtual zero old
	//virtual zero xy
	
	/* change flags */
	uint32_t flgNewRange;
	
	unsigned char *signal;
	
} mathData_t;



extern channelData_t Channel[5];


// Constants
extern unsigned long tc_varstart ;;		// Kennung Varstart
extern unsigned long tc_version ;;		// Factory version 			//BF changed
extern unsigned long tc_subversion ;;		// Factory subversion 			//BF changed
extern unsigned long tc_dev_version ;;		// Developer version			//BF changed
extern unsigned long tc_dev_subversion ;;	// Developer subversion			//BF changed
extern char	     tc_compilation[20];
extern unsigned long tc_hw_modif;		// hardware modification
extern unsigned long tc_hw_version ;;		// FPGA version 		
extern unsigned long tc_model ;;		// 2012, 2022 , 2014, 2024
extern unsigned long tc_serial ;;		// 1
extern unsigned long tc_production_lot1 ;;	// E
extern unsigned long tc_production_lot2 ;;	// E
extern unsigned long tc_shipment_date ;;	// 2C7


extern const unsigned char btnUnpushed		;;
extern const unsigned char btnPushed 		;;
extern const unsigned char btnDraw			;;
extern const unsigned char btnRemove 		;;
extern const unsigned long BitMasks[32] ;
extern const unsigned long BitMasks2[32] ;
// Constants
extern const int DrawOffsetX ;;									// Draw Offset from Left
extern const int DrawOffsetY ;;									// Draw Offset from Top
extern const int DrawXYOffsetX1 ;;								// Draw Offset from Top
extern const int DrawXYOffsetX2 ;;								// Draw Offset from Left
//extern int PreReg_Offset ;;									// Signal Offset , half Signal

extern unsigned long timer_counter_value ;;
extern unsigned long timer_counter_max ;;
extern int timer_reload_low ;;
extern int timer_reload_high ;;

extern const uint32_t RegTimerRotDelay;								// Rotary change timer
extern const int TimerSecPeriod     ;;								// button pushed time	

// BF add
// Constant for new ultra slow timebase mode
extern const uint32_t RegTimebaseTable[36];
extern const unsigned long int USTB_timer_value[11];

extern const int ExtTrigOffset[36];

extern const uint32_t ReadoutLengthTable[36];						// number of 32 bit ADC readout values depending on timebase
extern uint32_t ReadoutLength;
//extern uint32_t BufferOffset;								// offset from buffer start address


extern const unsigned int predivisor[10];		//BF probe division
extern const unsigned int math_voltage_factor[2][18];; 	//BF math voltage factors
extern const int math_rescale[2][18];		// math multiplication rescaling
//extern const unsigned int math_voltage_div[18] ;; 	//BF math voltage divisor

extern unsigned char ColorPalette; 
extern const unsigned char GridColorArray[10][4] ;;
extern const int Splash_Logo_PosX ;;
extern const int Splash_Logo_PosY ;;
extern const int Splash_Data_PosX ;;
extern const int Splash_Data_PosY ;;

//-----------------------------------------------------
//		filter
extern unsigned char FilterType;					// type of noise filter

//-----------------------------------------------------


//BF del extern const short SignalStartStop[36][2];
//BF del #023 extern const short SignalSize[34];
extern int SignalMemSize;			//BF #023
extern int MemStartOffs;
extern int MemoryEnd;
extern int TrigPosMax;

extern const float ZoomFactorTable[36];;
extern const char Dm_Sel_Tb_End[26];;		//BF #003
extern float ZoomFactor;
extern float ZoomFactor_old;
extern float ZoomFactorDel;
//extern const float OffsetFactorTable[36];
//extern float OffsetFactor;


//extern const float PreTrigger_Offset_Table[32][5];
extern const short Zoom_Index_Table[32][5] ;
extern const int ExtTriggerLevel[103] ;		//BF #019
//extern const float ExtTriggerDispl[103] ;	//BF #019


//--------------------------------------------------------------------------------------
extern uint32_t DottedGrid;					// switch grid
extern unsigned char FFT_grid;					//BF switch frequency div
extern volatile uint32_t UI_request;				//flag for request on user interface
extern unsigned char QP_request;				//Quick Print request
extern unsigned char QP_mode ;					// 0->BF-version / 1->OS-version / 2->USB-Export / (remote control -> shift + T)
extern uint32_t CRS_Delta;					// delta cursor on/off
extern uint32_t AS_request;					// auto scale requested
extern uint32_t RC_request;					// signal recall requested
extern uint32_t RC_overlay;					// recall overlay mode active
extern uint32_t RC_user_if;					// flag for user interface activity in Overlay mode
extern uint32_t LA_active;

extern volatile uint32_t ZL_changed;				// OnZero Channel

extern uint32_t ACQ_NewData;
extern uint32_t ACQ_Average;					// Average mode
extern uint32_t ACQ_ManTrigg;
extern uint32_t ACQ_HighSpeed;					// ADC running in high speed mode
extern uint32_t ACQ_PeakDetect;					// Acquisition mode is peak detect

extern unsigned char FlashPreset;				// Flash presetting flag

extern volatile uint8_t UART_NewData;;
extern volatile int8_t UART_RXData;;
extern volatile uint32_t UART_RXFlag;				//KB Quick Print USB-export
extern volatile uint8_t UartRxGuiCmd;                 		//#FW# Hardware::ISR_UART has filled UartRxGuiBuf
#define MAXTIMEBASEVAL  31
#define UARTRXGUISIZE   8                       		//Length of a GUI-Command
extern uint8_t UartRxGuiBuf[UARTRXGUISIZE];  		  	//#FW# Buffer for GUI-Commands

extern unsigned char DrawMono;					// flag for drawing monochrome
extern unsigned char NoDisplay[4];

extern int CalSet;
extern float PreTrigger;

extern uint32_t TRG_NoEventCounter;

//------------------------------------------------------------------------------------
//only for test purposes
extern uint8_t test_sw1;					
extern uint8_t test_sw2; 					//BF for testing drawing
extern uint8_t test_sw3;					//BF for testing drawing

extern uint8_t test_channel;
//extern uint32_t test_values;
//extern uint32_t  test_offs_a;
//extern unsigned int  test_offs_b;
//extern unsigned int  test_zero_a;
//extern unsigned int  test_zero_b;
//extern unsigned int  test_div_a;
//extern unsigned int  test_div_b;
//extern unsigned int  test_rel_a;
//extern unsigned int  test_rel_b;
extern unsigned int  FrameCount;




//---------------------------------------------------------------------------------------
extern unsigned long tc_test_var ;;
extern unsigned long tc_test_var2 ;;

extern unsigned char DrawSignal;
extern unsigned char keyboard_found ;;
extern unsigned long slope_value ;;
extern double Test_Slip;
extern int Test_Range;
extern bool Transfer_man_data;

extern unsigned long *prog_flash_adr;
extern unsigned long prog_flash_adress;
extern unsigned char prog_flash_length;
extern unsigned long prog_flash_offset;
extern unsigned char Flash_Read_Buffer[1024];
extern unsigned long Flash_Protect_Buffer[128];
extern uint32_t config_loaded;

extern volatile uint32_t ConfigChanged;
extern unsigned char GridColorArrayPos;

extern unsigned char WT_Logo_Color_Val;		//0x10 / 0x21 / 0x31 
//BF del extern int Testint ;;
//BF del extern long Testlong ;;
//BF del extern unsigned char Test_Mode ;;

extern unsigned char ADC_Debug_Mode ;;     // If true  printf ADC Debug information
extern unsigned char Debug_Mode ;;         // If true  printf Debug information
extern unsigned char Command_Mode ;;         // If true printf Command information

extern volatile uint32_t ADC_Started;
extern uint8_t AutoFreeRun;

extern int HoldOff_Value ;;
extern int HoldOff_Expo ;;   //ns
extern int HoldOff_Steps ;;
extern int Pulse11_Value ;;
extern int Pulse11_Expo ;;   //ns
extern int Pulse11_Steps ;;
extern int Pulse12_Value ;;
extern int Pulse12_Expo ;;   //ns
extern int Pulse12_Steps ;;
extern int Pulse21_Value ;;
extern int Pulse21_Expo ;;   //ns
extern int Pulse21_Steps ;;
extern int Pulse22_Value ;;
extern int Pulse22_Expo ;;   //ns
extern int Pulse22_Steps ;;

//BF new offset calculation
extern int Math_Offset ;;
extern int Math_Mul_Offset ;;
extern int Math_Sub_Offset ;;
extern int Math_Add_Offset ;;
//BF del extern float Math_Off_Mul_Value ;;
//extern int Math_Off_Mul_Value_int ;;
//extern int Math_Off_Mul_Expo ;;   //ns
//extern float Math_Off_Mul_Steps ;;
//BF del extern float Math_Off_Sub_Value ;;
//extern int Math_Off_Sub_Value_int ;;
//extern int Math_Off_Sub_Expo ;;   //ns
//extern float Math_Off_Sub_Steps ;;
//BF del extern float Math_Off_Add_Value ;;
//extern int Math_Off_Add_Value_int ;;
//extern int Math_Off_Add_Expo ;;   //ns
//extern float Math_Off_Add_Steps ;;

extern char Selected_Voltage_CH1_bak;
extern char Selected_Voltage_CH2_bak;
extern char Selected_Voltage_CH3_bak;
extern char Selected_Voltage_CH4_bak;

extern int ZeroLevelCH1_bak;
extern int ZeroLevelCH2_bak;
extern int ZeroLevelCH3_bak;
extern int ZeroLevelCH4_bak;
extern int Virtual_ZeroLevelCH1_bak;
extern int Virtual_ZeroLevelCH2_bak;
extern int Virtual_ZeroLevelCH3_bak;
extern int Virtual_ZeroLevelCH4_bak;
//BF added
extern int ZeroLevelCH1_Main_bak;
extern int ZeroLevelCH2_Main_bak;
extern int ZeroLevelCH3_Main_bak;
extern int ZeroLevelCH4_Main_bak;
extern int Virtual_ZeroLevelCH1_Main_bak;
extern int Virtual_ZeroLevelCH2_Main_bak;
extern int Virtual_ZeroLevelCH3_Main_bak;
extern int Virtual_ZeroLevelCH4_Main_bak;
/*BF del 
//ADC-correction
extern int  alpha[4];				// Y = beta * X + alpha	
extern float beta[4];				// alpha -> zero offset, beta -> gain
*/

extern int Trigger_Pos_CH1_bak ;										// Stores the Trigger Position on Channel 1
extern int Trigger_Pos_CH2_bak ;										// Stores the Trigger Position on Channel 2
extern int Trigger_Pos_CH3_bak ;										// Stores the Trigger Position on Channel 3
extern int Trigger_Pos_CH4_bak ;
//extern int Timebase_Offset_Pos_bak ;;
//extern int Trigger_Offset_Pos_bak ;;	//BF del not used
extern int AC_CH1_bak ;;
extern int AC_CH2_bak ;;
extern int AC_CH3_bak ;;
extern int AC_CH4_bak ;;

extern int draw_start ;;
extern int draw_factor ;;
extern int draw_dm_ixstart ;;
extern int draw_dm_ixfactor ;;
extern int MainTimebase_bak;
extern uint32_t Run_bak;
extern int SingleShot_bak;

//extern char testtoggle ;;
extern int CH1_DAC_Offset ;;
extern int CH2_DAC_Offset ;;
extern int CH3_DAC_Offset ;;
extern int CH4_DAC_Offset ;;

extern int DAC_Correction[4][4][3];;	//BF added

//--------------------------------------------------------------------------------------
// BF add
// Variables for new ultra slow timebase mode

extern short USTB_Mode;;	
extern short USTB_Mode_bak;;	
extern short USTB_Dir;			// buffer storing direction
//extern short USTB_Dir_bak;
extern short USTB_Disp;			// display mode (permanent/step)
extern unsigned char USTB_NewData;;
extern int  USTB_idx ;;
extern int  USTB_EOSignal;		//end of signal

//--------------------------------------------------------------------------------------

extern int LED_ON[16];
//extern int LED_Buf ;;
extern int Display_Line_Adresses[480];

//BF old USB functions -> can be deleted in future #017
extern volatile unsigned char uart2_buffer[64];
extern volatile unsigned char send_buffer[64];
//extern volatile char uart2_count;

//BF new designed USB functions #017
extern volatile int8_t UART2_rx_cnt;
extern volatile uint8_t UART2_rx_buffer[64];
extern volatile uint8_t UART2_tx_buffer[64];


extern uint8_t ClearPlane;
extern uint8_t DrawPlane;
extern uint8_t RemovePlane;

extern uint32_t UpdateMarkerPlane;
extern uint32_t UpdateMenuTextPlane;

extern volatile int32_t RotaryDirection;
extern volatile int32_t RotarySteps;
extern int32_t RotaryDirectionMemPulse;
extern int32_t RotarySwitch;


extern volatile int32_t KeyboardMem;
extern volatile int32_t KeyboardChanged;
extern volatile int32_t ADC_DataAvailable;


extern unsigned short SwitchesCH1;
extern unsigned short SwitchesCH2;
extern unsigned short SwitchesCH3;
extern unsigned short SwitchesCH4;

extern unsigned short SwitchesLMH[4]; 		//Jörg -> analog to SwitchesCHx

// Signal pointer
extern unsigned char *S1Ptr;
extern unsigned char *S2Ptr;
extern unsigned char *S3Ptr;
extern unsigned char *S4Ptr;
extern unsigned char *SMPtr;

extern unsigned char *Signal[5];

extern uint8_t * Minimum[4];			// pointer to peak detect minimum memory
extern uint8_t * Maximum[4];			// pointer to peak detect maximum memory

extern unsigned long *Buffer_Mark1Plane ;; //0x008D3BF4;
extern unsigned long *Buffer_UI2Plane ;;

//extern unsigned char *SIGNAL_IntBuf ;;	//BF reactivated for tests

// BF add QM changed by Stefan
extern int32_t *SIGNAL_Histo ;;   // double used for Rollmode. No Interpolation for rollmode

//---------------------------------------------------------------------------
extern unsigned char *SIGNAL1_Intpolate;   
extern unsigned char *SIGNAL2_Intpolate;
extern unsigned char *SIGNAL3_Intpolate;
extern unsigned char *SIGNAL4_Intpolate;
extern unsigned char *SIGNALM_Intpolate;
extern unsigned char *SIGNAL1_USTB;   
extern unsigned char *SIGNAL2_USTB;
extern unsigned char *SIGNAL3_USTB;
extern unsigned char *SIGNAL4_USTB;
//extern unsigned char *SIGNALM_USTB;
//---------------------------------------------------------------------------

extern unsigned char *SIGNAL1_Intpolate_delayed ;;
extern unsigned char *SIGNAL2_Intpolate_delayed ;;
extern unsigned char *SIGNAL3_Intpolate_delayed ;;
extern unsigned char *SIGNAL4_Intpolate_delayed ;;
extern unsigned char *SIGNALM_Intpolate_delayed ;;
//---------------------------------------------------------------------------


//BF -> used for overlay mode
extern unsigned char *SIGNAL1_Buffer ;;
extern unsigned char *SIGNAL2_Buffer ;;
extern unsigned char *SIGNAL3_Buffer ;;
extern unsigned char *SIGNAL4_Buffer ;;

extern unsigned long *readout_sigbuf ;;
extern unsigned char *readout_sigbuf_char ;;

//extern int *tab ;;		//1024 * 4 = 4096
//extern int *tab ;;		//1024 * 4 = 4096	
//extern int *tab ;;		//1024 * 4 = 4096	
//extern int *tab ;;		//1024 * 4 = 4096

extern uint8_t *FIR_Buffer;

extern unsigned char *SHIFT_OFFS1;	//shift buffer 16k for channel 1 
extern unsigned char *SHIFT_OFFS2;	//shift buffer 16k for channel 2 
extern unsigned char *SHIFT_OFFS3;	//shift buffer 16k for channel 3 
extern unsigned char *SHIFT_OFFS4;	//shift buffer 16k for channel 4 
extern unsigned char *SHIFT_OFFSM;	//shift buffer 16k for channel math 

extern unsigned char *ROLL_OFFS1;	//roll buffer 32k for channel 1 
extern unsigned char *ROLL_OFFS2;	//roll buffer 32k for channel 2 
extern unsigned char *ROLL_OFFS3;	//roll buffer 32k for channel 3 
extern unsigned char *ROLL_OFFS4;	//roll buffer 32k for channel 4 
extern unsigned char *ROLL_OFFSM;	//roll buffer 32k for channel math 


//BF -> buffer for low pass filtering
extern unsigned char *Filter1_Buffer;
extern unsigned char *Filter2_Buffer;
extern unsigned char *Filter3_Buffer;
extern unsigned char *Filter4_Buffer;
extern unsigned char *CopyBuffer;

// signal buffer
extern unsigned char *SIGNAL1 ;;
extern unsigned char *SIGNAL2 ;;
extern unsigned char *SIGNAL3 ;;
extern unsigned char *SIGNAL4 ;;
extern unsigned char *SIGNALM ;;
extern int *SPECTRUM ;;


extern unsigned long *Buffer_PlaneM ;;
extern unsigned long *Buffer_Plane1 ;;
extern unsigned long *Buffer_Plane2 ;;
extern unsigned long *Buffer_Plane3 ;;
extern unsigned long *Buffer_Plane4 ;;
extern unsigned long *Planes ;;
extern unsigned long *UI_Plane1 ;;
extern unsigned long *UI_Plane2 ;;
extern unsigned long *UI_Plane3 ;;
extern unsigned long *UI_Plane4 ;;
extern unsigned long *UI_Plane5 ;;
extern unsigned long *Channel_Plane1 ;;
extern unsigned long *Channel_Plane2 ;;
extern unsigned long *Channel_Plane3 ;;
extern unsigned long *Channel_Plane4 ;;
extern unsigned long *Channel_Math_Plane ;;
extern unsigned long *Copy_Plane1;
extern unsigned long *Copy_Plane2;
extern unsigned long *Copy_Plane3;
extern unsigned long *Marker_Plane1 ;;
extern unsigned long *Marker_Plane2 ;;
extern unsigned long *Grid_Plane ;;

//extern unsigned long *Dummy_Address ;;//BF testing memory

//extern long v_Buffer_PlaneM ;;
extern long v_Buffer_Plane1 ;;
extern long v_Buffer_Plane2 ;;
extern long v_Buffer_Plane3 ;;
extern long v_Buffer_Plane4 ;;
extern long v_Channel_Plane1 ;;
extern long v_Channel_Plane2 ;;
extern long v_Channel_Plane3 ;;
extern long v_Channel_Plane4 ;;
//extern long v_Channel_Math_Plane ;;

extern unsigned long *Text_Plane;


// BF QM thresholds
extern int32_t thres_type[5];
extern int32_t thres_low[5];
extern int32_t thres_mdl[5];
extern int32_t thres_up[5];

extern float thres_low_abs[5];
extern float thres_mdl_abs[5];
extern float thres_up_abs[5];


// BF add QM changed by Stefan
extern int32_t SIGNAL_MIN[5] ;;
extern int32_t SIGNAL_MDL[5] ;;
extern int32_t SIGNAL_MAX[5] ;;
extern int32_t SIGNAL_BASE[5] ;;
extern int32_t SIGNAL_TOP[5] ;;
extern int32_t SIGNAL_AVG[5] ;;
extern int32_t SIGNAL_AVG_CNT[5] ;;
extern int32_t SIGNAL_THRES_LOW[5] ;;
extern int32_t SIGNAL_THRES_MDL[5] ;;
extern int32_t SIGNAL_THRES_UP[5] ;;
extern int32_t SIGNAL_THRES_PRE_POSITIV_1[5] ;;
extern int32_t SIGNAL_THRES_LOW_POSITIV_1[5] ;;
extern int32_t SIGNAL_THRES_MDL_POSITIV_1[5] ;;
extern int32_t SIGNAL_THRES_UP_POSITIV_1[5] ;;
extern int32_t SIGNAL_THRES_OVER_POSITIV_1[5] ;;
extern int32_t SIGNAL_THRES_PRE_NEGATIV_1[5] ;;
extern int32_t SIGNAL_THRES_LOW_NEGATIV_1[5] ;;
extern int32_t SIGNAL_THRES_MDL_NEGATIV_1[5] ;;
extern int32_t SIGNAL_THRES_UP_NEGATIV_1[5] ;;
extern int32_t SIGNAL_THRES_OVER_NEGATIV_1[5] ;;
extern int32_t SIGNAL_THRES_PRE_POSITIV_2[5] ;;
extern int32_t SIGNAL_THRES_LOW_POSITIV_2[5] ;;
extern int32_t SIGNAL_THRES_MDL_POSITIV_2[5] ;;
extern int32_t SIGNAL_THRES_UP_POSITIV_2[5] ;;
extern int32_t SIGNAL_THRES_OVER_POSITIV_2[5] ;;
extern int32_t SIGNAL_THRES_PRE_NEGATIV_2[5] ;;
extern int32_t SIGNAL_THRES_LOW_NEGATIV_2[5] ;;
extern int32_t SIGNAL_THRES_MDL_NEGATIV_2[5] ;;
extern int32_t SIGNAL_THRES_UP_NEGATIV_2[5] ;;
extern int32_t SIGNAL_THRES_OVER_NEGATIV_2[5] ;;
extern int32_t SIGNAL_THRES_PRE_POSITIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_LOW_POSITIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_MDL_POSITIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_UP_POSITIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_OVER_POSITIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_PRE_NEGATIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_LOW_NEGATIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_MDL_NEGATIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_UP_NEGATIV_LAST[5] ;;
extern int32_t SIGNAL_THRES_OVER_NEGATIV_LAST[5] ;;


extern int32_t DelayedTimebase;	
extern int dmode_Cursor_Vertical_Position1_Old;
extern int dmode_Cursor_Vertical_Position2_Old;
extern int dmode_QM_Vertical_Position1_Old;
extern int dmode_QM_Vertical_Position2_Old;
extern int dmode_Window_Offset_Pos;
extern int dmode_Window_Offset_Pos_Old;
extern float Timebase_Ratio ;;
extern int Cursor_Delayed_1 ;;
extern int Cursor_Delayed_2 ;;
extern int Cursor_Delayed_Size ;;
extern int Cursor_Delayed_1_Old ;;
extern int Cursor_Delayed_2_Old ;;

extern unsigned int GainIdx;			//BF added
extern const float ScaleFactorTable[2][5];		
extern float ScaleFactor[16];
extern char ScaleIndexTable[16];		//BF added
extern int32_t ScaleLookupTable[260][3];	//BF added
extern float FFT_ScaleCorrection[16][7];	//BF added
extern short FFT_ScaleLookupTable[256];		//BF added

extern const float DAC_ScaleFactorTable[3][5] ;	
extern float DAC_ScaleFactor[3] ;	

//-------------------------------------------------------------------------
/* FIR sinc interpolation */
extern int32_t FIR_SincLookup[256][5][9];
extern const int16_t FIR_Coeff[5][9];


//-------------------------------------------------------------------------


// Math FFT variables
extern unsigned char MATH_Mode;

//extern unsigned char FFT_Mode;; 
extern unsigned char FFT_NewData;
//BF not needed anymore extern int FFT_Scale;;
extern int FFT_NormENBW;		//Equivalent Noise Bandwidth normed to delta frequency in dB
extern unsigned char FFT_Layout;;
extern short FFT_TriggerMode_bak;

extern float FFT_ENBW[6];

//extern char FFTToggle;;                                       		// for switching between Scale and Offset
//extern FloatStr FFT_Scale_Str;
//extern FloatStr FFT_Offset_Str;
extern FloatStr FFT_Status_Str;

extern short int iLog10[481];;


/* BF insert end */
//---------------------------------------------------------------------------
//BF del extern short LogicData[32];
//BF not used extern char USB_Connected ;;
extern char USB_Data_Trans;
extern char USB_SendAllData;
extern char USB_At_Startup ;;
extern char USB_OnlyTrigger;
extern char USB_Data_Requested ;;

extern unsigned char RS232_ContData_ReqMask;
extern char RS232_Data_Requested;
extern char RS232_ScreenShot_Requested;

extern uint32_t Run;
extern uint32_t SingleShot;
extern volatile uint32_t ButtonChanged;

extern char SavePointer ;;
extern short led_status;											// Stores the LED Port Bits;
extern char ScreenShotActive;										// is 1 when sending screen shot

extern char PopUpPosition;
extern char PopupTimeCounter;										// Counter for Popup Pulldown

extern char TriggerLevelChanged ;;								// Was Triggerlevel changed
extern char TriggerModeChanged ;;								// Was Triggermode changed
extern char TriggerWayChanged ;;								// Was Triggerway changed
extern char TimebaseChanged;									// Was Timebase changed

extern volatile uint32_t TriggerLevelActive;							// Is Triggerlevel selected ?
extern char TimeOffsetActive ;;									// Is Time_Offset selected ?
extern char StatusBtnRemove ;;									// remove button
extern char VoltageChangedCh1 ;;								// Voltage changed
extern char VoltageChangedCh2 ;;								// Voltage changed
extern char VoltageChangedCh3 ;;								// Voltage changed
extern char VoltageChangedCh4 ;;								// Voltage changed

extern int32_t VS_ZeroLevelChanged;								// Zerolevel change flag
extern int32_t VS_TrigLevelChanged;								// Triggerlevel change flag


extern uint32_t NumberOfChannels;

extern uint32_t Channels_Active;

extern uint32_t ChannelStatusOld[5];

extern int32_t VirtualTimebase;										
extern int32_t MainTimebase;										// Timebase Index
     								
extern char XY_Mode;											// Selected Normal or XY-Mode

extern int32_t PreTrigComp;										// Pretrigger compensation

extern int Trig_Pos_Mem ;;                                     						// Store the Triggerposition in Memory
extern int Trig_Pos_Display ;;                                 						// Store the Triggerposition on DisplayCoC
extern int Trig_Pos_Display_dmode ;;                           						// Store the Triggerposition on Display in delayed mode
extern int MemWinStart ;;                                    						// Store the Trigger Memory Offset
extern int32_t PeakMemOffs;



extern int Trig_Pos_Mem_old ;;                                     					// Store the Triggerposition in Memory
extern int Trig_Pos_Display_old ;;                                 					// Store the Triggerposition on Display
extern int Trig_Pos_Display_dmode_old ;;                           					// Store the Triggerposition on Display in delayed mode
extern int MemWinStart_old ;;                                    					// Store the Trigger Memory Offset
extern char TriggerWay;											// Stores the way to trigger
extern char TriggerWay_bak;	

extern volatile uint32_t CombiTriggerWaitTime;
extern volatile uint32_t CombiTriggerStatus;
extern volatile uint32_t CombiTimingCounter;

extern int Trigger_Pos_CH1;										// Stores the Trigger Position on Channel 1
extern int Trigger_Pos_CH2;										// Stores the Trigger Position on Channel 2
extern int Trigger_Pos_CH3;										// Stores the Trigger Position on Channel 3
extern int Trigger_Pos_CH4;										// Stores the Trigger Position on Channel 4
extern int Trigger_Pos_CHE;										// Stores the Trigger Position on External
extern int Trigger_Pos_CH1_Old;									// Stores the old Trigger Position on Channel 1
extern int Trigger_Pos_CH2_Old;									// Stores the old Trigger Position on Channel 2
extern int Trigger_Pos_CH3_Old;									// Stores the old Trigger Position on Channel 3
extern int Trigger_Pos_CH4_Old;									// Stores the old Trigger Position on Channel 4
extern int Trigger_Pos_CHE_Old;									// Stores the old Trigger Position on External

extern int Virtual_ZeroLevelCH1;
extern int Virtual_ZeroLevelCH2;
extern int Virtual_ZeroLevelCH3;
extern int Virtual_ZeroLevelCH4;
extern int ZeroLevelCH1;
extern int ZeroLevelCH2;
extern int ZeroLevelCH3;
extern int ZeroLevelCH4;
extern int Virtual_ZeroLevelXYCH1;
extern int Virtual_ZeroLevelXYCH2;
extern int Virtual_ZeroLevelXYCH3;
extern int Virtual_ZeroLevelXYCH4;
extern int ZeroLevelCH1_Old;
extern int ZeroLevelCH2_Old;
extern int ZeroLevelCH3_Old;
extern int ZeroLevelCH4_Old;

extern char Selected_Voltage_CH1;									// Selected Voltage_CH1
extern char Selected_Voltage_CH2;									// Selected Voltage_CH2
extern char Selected_Voltage_CH3;									// Selected Voltage_CH3
extern char Selected_Voltage_CH4;									// Selected Voltage_CH4

extern char SelectedCursor;										// Which Cursor is selected
extern char SelectedCursorOld;										// Which Cursor was selected
extern char Cursor_Enabled;
extern char Cursor_Enabled_Old;
extern char CursorChanged;											// Was Cursor changed
extern char Cursor_XY_Selected;									// 0 ;
extern char Cursor_XY_Selected_Old;								// 0 ;
extern char Cursor_Both_Selected;
extern char Cursor_Both_Selected_Old;
extern char Cursor_Horizontal_Active; 								// 0 ;
extern char Cursor_Horizontal_Active_Old;							// 1 ;
extern long Cursor_Horizontal_Position_Real1;						// Store Real Cursor Position
extern long Cursor_Horizontal_Position_Real2;						// Store Real Cursor Position
extern long Cursor_Horizontal_Position1_Old;						// Store old Cursor horizontal I position
extern long Cursor_Horizontal_Position2_Old;						// Store old Cursor horizontal II position
extern char Cursor_Vertical_Active;								// 0 ;
extern char Cursor_Vertical_Active_Old;							// 1 ;

//extern long Cursor_Vertical_Position_Real1;						// Store Real Cursor Position
//extern long Cursor_Vertical_Position_Real2;						// Store Real Cursor Position
//extern long Cursor_Vertical_Position1_Old;						// Store old Cursor vertical I position
//extern long Cursor_Vertical_Position2_Old;						// Store old Cursor vertical II position

extern long Cursor_Vertical_Position_TY_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_TY_2;						// Store Cursor Position
extern long Cursor_Vertical_Position_XY_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_XY_2;						// Store Cursor Position
extern long Cursor_Vertical_Position_FFT_1;						// Store Cursor Position
extern long Cursor_Vertical_Position_FFT_2;						// Store Cursor Position
extern long Cursor_Vertical_Position1_Old;						// Store old Cursor vertical I position
extern long Cursor_Vertical_Position2_Old;						// Store old Cursor vertical II position
extern char Cursor_Data_Draw_Pos ;;							// Stores the draw position of the cursor data
extern char Cursor_Data_First_Draw ;;							// Is it draw first time ?
extern char QM_Enabled;
extern char QM_Enabled_Old;
extern char QM_Changed[3];											// Was quick measurment changed
extern char QM_Type[3];                                            	// What type of measurment (look 1313 -> 52 ...
//extern char QM_Type_Old[3];                                        	// What type of measurment (look 1313 -> 52 ...
extern char QM_Channel[3];                                         	// source channel per measurement slot
extern char QM_Second_Channel[3];                                 	// For delay / phase measurment
extern char QM_CHI_Edge[3];                                        	// For delay  measurment // 1 ;
extern char QM_CHII_Edge[3];                                       	// For delay  measurment // 1 ;
extern short QM_Source;							// main QM source channel
extern char BufPre[30];
extern char BufUnit[10];
extern char BufReturn[30];
extern char QM_V_A_Buf[1];
extern char QM_H_A_Buf[1];
extern char QM_Horizontal_Active; 								     // 0 ;
extern char QM_Horizontal_Active_Old;							     // 1 ;
extern long QM_Horizontal_Position_Real1;						// Store Real Cursor Position
extern long QM_Horizontal_Position_Real2;						// Store Real Cursor Position
extern long QM_Horizontal_Position1_Old;						// Store old Cursor horizontal I position
extern long QM_Horizontal_Position2_Old;						// Store old Cursor horizontal II position
extern char QM_Vertical_Active;								// 0 ;
extern char QM_Vertical_Active_Old;							// 1 ;
extern long QM_Vertical_Position_Real1;						// Store Real Cursor Position
extern long QM_Vertical_Position_Real2;						// Store Real Cursor Position
extern long QM_Vertical_Position1_Old;							// Store old Cursor vertical I position
extern long QM_Vertical_Position2_Old;							// Store old Cursor vertical II position
extern char Quick_Measure_Data_Draw_Pos ;;								// Stores the draw position of the cursor data
extern char Quick_Measure_First_Draw ;;							// Is it draw first time ?
extern char Quick_Measure_Threshold_btn_select;
extern char Memory_Window_visible ;;
extern int mb_window_start_old ;;
extern int mb_window_stop_old ;;
extern int mb_window_trigger_old ;;
extern int mb_window_cursor1_old ;;
extern int mb_window_cursor2_old ;;
extern int math_mul_scale ;;
extern int math_sub_scale ;;
extern int math_add_scale ;;
extern int math_scale ;;

extern FloatStr Pulse11;
extern FloatStr Pulse21;
extern FloatStr Pulse12;
extern FloatStr Pulse22;

extern FloatStr Cursor_Delta_X;	
extern FloatStr Cursor_Delta_1X;
extern FloatStr Cursor_Delta_XY_X;
extern FloatStr Cursor_Delta_Y;
extern FloatStr Cursor_Vertical_Pos_1_Str;
extern FloatStr Cursor_Vertical_Pos_2_Str;
extern FloatStr Cursor_Vertical_Pos_XY_1_Str;
extern FloatStr Cursor_Vertical_Pos_XY_2_Str;
extern FloatStr Cursor_Horizontal_Pos_1_Str;
extern FloatStr Cursor_Horizontal_Pos_2_Str;

extern FloatStr FFT_Cursor_Delta_X;	
extern FloatStr FFT_Cursor_Delta_1X;
extern FloatStr FFT_Cursor_Delta_Y;
extern FloatStr FFT_Cursor_Vertical_Pos_1_Str;
extern FloatStr FFT_Cursor_Vertical_Pos_2_Str;
extern FloatStr FFT_Cursor_Horizontal_Pos_1_Str;
extern FloatStr FFT_Cursor_Horizontal_Pos_2_Str;

extern FloatStr QM_Slot1;
extern FloatStr QM_Slot2;
extern FloatStr QM_Slot3;
extern FloatStr QM_Threshold_lower;
extern FloatStr QM_Threshold_middle;
extern FloatStr QM_Threshold_upper;
//BF del extern FloatStr Math_Offset;
extern FloatStr Math_Offset_mul;
extern FloatStr Math_Offset_sub;
extern FloatStr Math_Offset_add;

extern FloatStr Zero_Level1_Str;
extern FloatStr Zero_Level2_Str;
extern FloatStr Zero_Level3_Str;
extern FloatStr Zero_Level4_Str;

extern FloatStr Trigger_Level_Str;
extern FloatStr Trigger_ExtLevel_Str;

//extern FloatStr Timebase_Offset_Str;  // unused
extern FloatStr Trigger_Offset_Str;
extern FloatStr HoldOff;


//---------------------------------------------------------------------------------------------
//         Menu
extern unsigned char MenuBtnFocus[32];					// focus for one of the 6 buttons in every menu

extern char MenuPopupChanged ;;									// When 1 then is changed
extern char MenuPopupActive ;;									// Stores the actual Menupopup

extern char MenuItemChanged[6] ;;
extern char MenuItemPushed[6] ;;								// When Menuitem is pushed drawed

extern char MenuAktive ;;                                        				// When Menu was deaktive
extern char MenuAktive_old ;;                                    				// When Menu was deaktive

extern int MenuPopupX;										// used for drawing popups -> store data global for next function
extern int MenuPopupY;										// used for drawing popups -> store data global for next function
extern int MenuPopupSizeX;									// used for drawing popups -> store data global for next function
extern int MenuPopupSizeY;									// used for drawing popups -> store data global for next function


extern int MenuTimeCounter;									// Counter for Menu Pulldown
extern char MenuItemCount;									// Store the count of the Menuitems
extern char MenuOldItemCount;									// Store the count of the old Menuitems
extern char New_Menu ;;
extern char Active_Menu ;;
extern char Menu_Changed ;;
extern char Menu_First_Draw;

extern unsigned short MenuItemDef[32][6];
//BF not used extern unsigned char MenuItem151[16] ;
extern unsigned char MenuItem[32][6][16];
extern unsigned char MenuEdgeBufText[7];
extern unsigned short MenuDataDef[370];
extern char MenuData[370][16] ;
extern short MenuStatus[32][6] ;
extern short MenuPopupStatus[51][22] ;	
extern unsigned short MenuPopupDef[51][2];
extern char MenuPopupText[51][23][20];
//----------------------------------------------------------------------------------------------

//extern char SampleRateData[15][10] ;;
//BF del extern char Stringlist[1][32] ;;
//BF del extern char PatternStatus[5] ;;

//BF del extern unsigned char TriggerData[11][12] ;
extern unsigned short TimebaseDataDef[36] ;
extern unsigned char TimebaseData[36][10] ;

extern float TimeBaseFactor[36];				//BF new TB values
extern int SampleRate[36];					//BF new sample rate values

extern unsigned short SampleRateDataDef[36] ;
extern unsigned char SampleRateData[36][11] ;
//extern const short TimebaseData_Matrix[36][5][10] ;
extern const float Timebase_Delayed_Factor_Table[26];	//BF #003
//extern const unsigned short VoltageDataDef[11] ;; BF del

extern const float VoltFactor[19];
extern const char VoltageData[11][5] ;

extern const float ScreenScaleFactor[16];

extern unsigned char FONT10X9[100][28];
extern unsigned char FONT12X9[120][28];
extern unsigned char bitbmBigArrowUp[] ;
extern unsigned char bitbmBigArrowDown[] ;
extern unsigned char bitbmCycleArrow[] ;
extern unsigned char bitbmSelectCycleArrow[] ;
extern unsigned char bitbmTimebaseOffset[] ;
extern unsigned char bitbmSubMenu[] ;
extern unsigned char bitbm_GND[];
extern unsigned char bitbmCH1[] ;
extern unsigned char bitbmCH1_gnd[] ;
//extern unsigned char bitbmCH1_XY[] ;
extern unsigned char bitbmCH2[] ;
extern unsigned char bitbmCH2_gnd[] ;
extern unsigned char bitbmCH3[] ;
extern unsigned char bitbmCH3_gnd[] ;
extern unsigned char bitbmCH4[] ;
extern unsigned char bitbmCH4_gnd[] ;
extern unsigned char bitbmMin[] ;
extern unsigned char bitbmMax[] ;
extern unsigned char bitbmTrigger[] ;
extern unsigned char bitbmTrigAVG[] ;
extern unsigned char bitbmCoppAC[] ;
extern unsigned char bitbmCoppDC[] ;
extern unsigned char bitbmCoppInv[] ;
extern unsigned char bitbmCoppLimit[] ;
extern unsigned char bitbmCoppLimit[] ;
extern unsigned char bitbmCoppACInv[] ;
extern unsigned char bitbmCoppACLimit[] ;
extern unsigned char bitbmCoppInvLimit[] ;
extern unsigned char bitbmCoppFull[] ;
extern unsigned char bitbmStopTrigger[] ;
//BF not used extern unsigned char bitbmStopTrigger_stop[] ;
extern unsigned char bitbmWTAG[] ;

extern bool screen_sel;
extern bool screen_sel_old;


// support_interrupts   ;
// CONSTANTS            ;
// sim_extern char_stream  ;
// sim_extern char_stream  ;

/*******************************************************************************************************************************************/

// fast unsigned 16 bit MSTEP multiplication
static inline int umul16(unsigned short mul1, unsigned short mul2)
{
	register int res asm("o3");
	
	asm volatile (" 
			MOV %%r0,%0 \n
			SWAP %%r0 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MOV %%o3,%%r0;
			" 
			: 
			: "r" (mul1) , "r" (mul2)
			: "o3", "r0"
		);
	
	return res;
}


// fast signed 16 bit MSTEP multiplication
static inline int smul16(short mul1, short mul2)
{
	register int res asm("o3");

	asm volatile (" 
			MOV %%r0,%0 \n
			LSLI %%r0,16 \n
			MOV %%r1,%1 \n
			LSLI %%r1,16 \n
			
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			MSTEP %1 \n
			
			SKP0 %0,31 \n
			SUB %%r0,%%r1 \n
			SKP0 %%r1,31 \n
			ADD %%r0,%1 \n

			MOV %%o3,%%r0;
			" 
			: 
			: "r" (mul1) , "r" (mul2)
			: "o3", "r0" , "g1"
		);
	
	return res;
}



/* Function:    ShiftAndRound
 * Description: Shifts a value (to divide) and takes care of the last
 *              removed bit (0.5) so we round values and don't cut
 *              them
 * Parameters:  Number: Value to be divided
 *              Bits: Number of bits to shift
 * Returnvalue: Number shiftet to right by Bits bits and rounded
 * Written:     20100630 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 */

static inline unsigned int ShiftAndRound (
        unsigned int Number,
        short BitsToShift) {

    unsigned int LastDigit = 0;

    if (BitsToShift) {
        BitsToShift -= 1;
        if (BitsToShift) {
            Number >>= BitsToShift;
        }
        LastDigit = Number & 0x01;
        Number >>= 1;
        Number += LastDigit;
    }
    return Number;
}




/* Function:    MultiplyFloatInt
 * Description: Multiply float and int and return int (unsigned).
 *              No conversion (int)((float)INT * float) is needed.
 *              The range is 2^-10 to 2^14
 * Parameters:  FactorInt: Integer (unsigned) - integer factor
 *              FactorFloat: float factor - sign will be dropped(!)
 * Returnvalue: unsigned integer from multiplication
 * Written:     20100701 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 * Todo:        Assembler Makro - to put it in an central place!!!
 */
static inline unsigned int MultiplyFloatInt (
        unsigned int FactorInt,
        float FactorFloat
        ) {

    unsigned int exponent;
    unsigned int add_me;
    unsigned int mantissa;
    unsigned int *convert;
    unsigned int *puffer;


    convert = (unsigned int *)&FactorFloat;
    puffer = (unsigned int *)&FactorFloat;
    mantissa = ((*convert & 0x007fffff) | 0x00800000);
    exponent = (*convert >> 23) & 0xff;

    // These are our exponents and values - as expected 
    // Now convert these guys to fixed point (if possible)
    //
    if (exponent >= 117) {
        exponent -= 117;    // 10 bits spare
        if (exponent < 24) {
            mantissa >>=(23-exponent);
            mantissa *= FactorInt;
            mantissa >>= 9;
            add_me = (mantissa &0x01);
            mantissa >>= 1;
            mantissa += add_me;
        } else {
            mantissa = 0xffffffff;
        }
    } else {
        mantissa = 0x00000000;
    }

    return mantissa;
}

/* Function:    Math_Sqrt
 * Description: Get the square root of an integer
 * Parameters:  Radikand: Integer - the number to calculate the root from
 * Returnvalue: Radix: Integer - the radix of the radikant
 * Written:     20100717 - rowue
 * Tested:      Yes
 * Reviewed:    No
 * Remarks:     inline
 * Todo:        Assembler Makro - to put it in an central place!!!
 */
static inline unsigned int Math_Sqrt (
        unsigned int Radikand) {

    int Bits;
    int i;
    int SecNumber;
    int Sqrt;
    int Eps;
    int yn;
    int Counter = 0;

    Bits = 0;

    SecNumber = Radikand;
    if (!(Radikand)) {      // TODO: Check for overrun
        Sqrt = 0;
    } else {
        while (SecNumber) {
            SecNumber >>= 1;
            Bits += 1;
        }
    
        Bits = ShiftAndRound (Bits, 1);
        Sqrt = ShiftAndRound (Radikand, Bits);
    
        yn = Radikand/Sqrt;
    
        Eps = 42;   // Sqrt can be lower than yn in the first iteration
    
        while ((Eps > SQRT_EPS) && (Counter < SQRT_ITER)) {
            Sqrt = ShiftAndRound (Sqrt + yn, 1);
            yn = Radikand/Sqrt;
            Eps = Sqrt - yn;
            Counter++;
        }
    }
    return Sqrt;

    /* What's the joke on this?
     * sqrt(a) = a^{0.5} -> sqrt(2^n) = 2^{n/2}
     *
     * the use of the hedon scheme is caused by cut-off errors
     *
     */
}



//BF calculate square root
static inline int iSqrt(int op)
{
	int l,r;
	// and square root
	for( l = 0,r = 1 ; l <= SQRT_PREC; l++)			// r = sqrt(v)
	r = (r + (op / r)) >> 1;

	return r;

}

//##########################################################################################################################################################
// BF function for sending float values via printf() to RS232, resolving the problem of systemcrash in open source FW
// when using the printf() directly

static void floatprintf(float fvalue)
{
	long int pre, aft,factor;
	int i;
	
	if (fvalue == 0)
	{ printf("0.000"); return;}

	//calculating pre FP value
	pre = (long int)fvalue;
	if(pre == 0 && fvalue < 0)	//negativ
		printf("-%d.",pre);
	else
		printf("%d.",pre);
		
	//get leading zero
	if((fvalue - pre) != 0) //check if numbers after FP exist
	{
		for(factor = 10, i= 0 ;0 == (long int)((fvalue - pre) * factor) && i<11; factor*=10, i++)
		{ printf("0"); }
	}
	else
	{	
		printf("000");
		return;
	}
	
	//calc after FP value, minimum 3 numbers after FP
	aft = (long int)((fvalue - pre) * factor * 100);
	
	if(aft < 0)	//kill sign
	{ aft *= -1; }

	printf("%d",aft);

	if(i >= 11)
	printf("overflow");

}


//##########################################################################################################################################################
// function for converting a float value to a character string
static void ftostr(char *str, unsigned int dec, float fvalue)
{
	float fbuf;
		
	int pre, aft,factor;
	int i,z;

	char s_aft[20];

	if (fvalue == 0)
	{ 
		str[0] = 0x30;			// zero in front of decimal point
		str[1] = 0x2E;			// decimal point
		
		for(i = 0, z = 0; i < dec; i++)
		{ str[i+2] =  0x30; }		// zero behind decimal point
		
		str[i+2] = 0;			// EOS
		
		return;
	}

	// get value in front of the decimal point
	pre = (int)fvalue;			//calculating pre FP value
	
	// get value behind the decimal point
	fbuf = fvalue - (float)pre;
	
	if((fbuf) != 0) 			//check if numbers after FP exist
	{
		for(factor = 10, aft = 0, i = 0, z = 0; i < dec; factor*=10, i++)
		{ 
			aft = (int)((float)fbuf * (float)factor);
			
			if (aft == 0) 		// get leading decimal zeroes
			{	
				s_aft[i] = 0x30;
				z++;
			}
			
		}
	
		if(aft < 0)			//kill sign
		{ aft *= -1; }

		sprintf(&s_aft[z], "%d",aft);
	}
	else
	{	
		for (i=0;i<dec;i++)
		s_aft[i] = 0x30;
		
		s_aft[i] = 0; // EOS
	}
	
	sprintf(str, "%d.%s",pre, s_aft);

	/* ende */
}






