
#include "hardware_t.h"
#include "tc_vars.h"
#include "flash_t.h"
#include "display_t.h"
//#include "math.h"
#include "signal_t.h"
#include "commif_t.h"
#include "userif_t.h"
#include "nios.h"


//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
// 							Class UserIF
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


/*  Class Attributes  */







//######################################################################################################################################################
void UserIF::Keyboard_Interface(void)
{

//-----------------------------------------------------------------------------------------------------	
//			handle remote inputs received from UART via RS232

	UI_request = 0;				//reset UI-request
	ButtonChanged = CommIF::handleInChar(UART_RXData);

//----------------------------------------------------------------------------------------------------	
//			handle keyboard inputs
//----------------------------------------------------------------------------------------------------	


	if (KeyboardChanged == 0) return;
	KeyboardChanged = 0;

	ButtonChanged = 1;  //BF -> kann weg??	
			
	if      ((KeyboardMem & 0x00080000) == 0x00) {Buttonhandler(30); RC_user_if = 1; }	// Function Button 1
	else if ((KeyboardMem & 0x00040000) == 0x00) {Buttonhandler(31); RC_user_if = 1; }	// Function Button 2
	else if ((KeyboardMem & 0x00020000) == 0x00) {Buttonhandler(32); RC_user_if = 1; }	// Function Button 3
	else if ((KeyboardMem & 0x00010000) == 0x00) {Buttonhandler(33); RC_user_if = 1; }	// Function Button 4
	else if ((KeyboardMem & 0x00400000) == 0x00) {Buttonhandler(34); RC_user_if = 1; }	// Function Button 5
	else if ((KeyboardMem & 0x00100000) == 0x00) {Buttonhandler(35); RC_user_if = 1; }	// Function Button 6
	
	else if ((KeyboardMem & 0x00200000) == 0x00) { Buttonhandler(1); RC_user_if = 1; }	// Channel 1 Button
	else if ((KeyboardMem & 0x00800000) == 0x00) { Buttonhandler(2); RC_user_if = 1; }	// Channel 2 Button
	else if ((KeyboardMem & 0x01000000) == 0x00) { Buttonhandler(3); RC_user_if = 1; }	// Channel 3 Button 
	else if ((KeyboardMem & 0x02000000) == 0x00) { Buttonhandler(4); RC_user_if = 1; }	// Channel 4 Button		
	else if ((KeyboardMem & 0x04000000) == 0x00) { Buttonhandler(26); RC_user_if = 1; }	// Channel Math Button		// Shortcut 
//	else if ((KeyboardMem & 0x06000000) == 0x00) Buttonhandler(26, 0);			// Channel Math Button
	
	else if ((KeyboardMem & 0x00008000) == 0x00) Buttonhandler(23);			// Auto Scale
	else if ((KeyboardMem & 0x00000100) == 0x00) { Buttonhandler(8); RC_user_if = 1; }	// Save/Recall
	else if ((KeyboardMem & 0x00000800) == 0x00) { Buttonhandler(17); RC_user_if = 1; }	// Quick Print
	else if ((KeyboardMem & 0x00002000) == 0x00) Buttonhandler(6);				// Utility
	else if ((KeyboardMem & 0x00000001) == 0x00) Buttonhandler(15);			// Pulse Width
	
//	else if ((KeyboardMem & 0x00000020) == 0x00) Buttonhandler(-1, 0);	// Not used
//	else if ((KeyboardMem & 0x00000002) == 0x00) Buttonhandler(-1, 0);	// Not used
	else if ((KeyboardMem & 0x00004000) == 0x00) { Buttonhandler(16); RC_user_if = 1; }	// Cursor
	else if ((KeyboardMem & 0x00000200) == 0x00) { Buttonhandler(19); RC_user_if = 1; }	// Quick Messurement 	// Kurz geschlossen
	else if ((KeyboardMem & 0x00000400) == 0x00) { Buttonhandler(0); RC_user_if = 1; }	// Acquire				//
	else if ((KeyboardMem & 0x00001000) == 0x00) { Buttonhandler(5); RC_user_if = 1; }	// Display
	else if ((KeyboardMem & 0x00000010) == 0x00) Buttonhandler(14);			// Edge
	else if ((KeyboardMem & 0x00000040) == 0x00) Buttonhandler(12);			// Trigger Mode /Coupling
	
	else if ((KeyboardMem & 0x00000080) == 0x00) Buttonhandler(10);			// Mode Button (Main/Delayed)
	else if ((KeyboardMem & 0x00000004) == 0x00) { Buttonhandler(37); RC_user_if = 1; }	// Run / Stop Button
	else if ((KeyboardMem & 0x00000008) == 0x00) Buttonhandler(38);			// Single Button


}

//######################################################################################################################################################
//Main button handler
void UserIF::Buttonhandler(int MenuKey)							// Button Handler
{
	
	switch(MenuKey)
	{			
		//--------------------------------------------
		// Acquire Button pushed	
		//--------------------------------------------
		case 0:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
						
			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;
			MenuAktive = 1;
			
			if (USTB_Mode == USTB_OFF) { Hardware::Set_LED(5); }
			else { MenuAktive = 0; Hardware::Reset_LED(5); }
			
			break;	
		}	
		
		//--------------------------------------------
		// Channel 1 Button pushed
		//--------------------------------------------	
		case 1:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			if (Signal::_FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 137;				// channel 1
				Hardware::FFT_Set_Channel(0);				// set active channel without backup
			
				//Display::FFT_DrawStatus(0);				//draw FFT values in status area
				
				Menu_Changed = 1;
				return;
			}

			//button switch logic
			if (Active_Menu == MenuKey)	// menu channel 1 active?
			{
                		if (!Channel[eCh2].active && !Channel[eCh3].active && !Channel[eCh4].active) break;

				UpdateChannel(eCh1, !Channel[eCh1].active);
				VoltageChangedCh1 = 1;
			}
			else if (!Channel[eCh1].active)	// menu not active -> channel 1 active?
			{ UpdateChannel(eCh1, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_1(); }


			//BF changed for channel 3 + 4 support in XY-mode
			if (!Channel[eCh1].active)	//channel 1 switched off
			{	
				//If XY-Mode is active, at least channel 3 + 4 must be active - else don't switch off channel 1
				if ((MenuStatus[MENU_TIMEBASE][2] == BTN_ON)  && !(Channel[eCh3].active && Channel[eCh4].active))
				{ UpdateChannel(eCh1, 1); }

				RemovePlane |= 0x01;
				Hardware::Hardware::ClearPlanes();
				UpdateChannel(eChM, Channel[eChM].active);
			}

			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
			Display::OssSingle( eOssCh1, 1, 1);	
			
			New_Menu = 1;
			Menu_Changed = 1;
			
			if (Channel[eCh1].active)
			{
				LED_ON[5] = 1;
				MenuAktive = 1;
			}
			else
			{
				LED_ON[5] = 0;
				MenuAktive = 0;
			}
			Hardware::Send_LED();	
			break;	
		}
		
		//--------------------------------------------
		// Channel 2 Button pushed	
		//--------------------------------------------
		case 2:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			if (Signal::_FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 138;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);		//draw FFT values in status area
				
				Menu_Changed = 1;
				return;
			}

			//button switch logic		
			if (Active_Menu == MenuKey)
			{
                		if (!Channel[eCh1].active && !Channel[eCh3].active && !Channel[eCh4].active) break;

				UpdateChannel(eCh2, !Channel[eCh2].active);
	
				VoltageChangedCh2 = 1;
			}
			else if (!Channel[eCh2].active)	// menu not active -> channel 2 active?
			{ UpdateChannel(eCh2, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_2(); }
			
			//BF changed for channel 3 + 4 support in XY-mode
			if (!Channel[eCh2].active)	//channel 2 switched off
            		{
				//If XY-Mode is active, at least channel 3 + 4 must be active - else switch on channel 2
				if ((MenuStatus[MENU_TIMEBASE][2] == 241) && !(Channel[eCh3].active && Channel[eCh4].active))
				{ UpdateChannel(eCh2, 1); }
		 		RemovePlane |= 0x02;
                		Hardware::ClearPlanes();
				UpdateChannel(eChM, Channel[eChM].active);
			}

			if (Cursor_Enabled) Display::CALCCURSORDATA();
							
			Display::StatusUpdate();				
			Display::OssSingle( eOssCh2, 1, 1);	
			
            		New_Menu = 2;
			Menu_Changed = 1;
			
			if (Channel[eCh2].active)
			{
				LED_ON[1] = 1;
				LED_ON[5] = 1;
				MenuAktive = 1;
			}
			else
			{
				LED_ON[1] = 0;
				LED_ON[5] = 0;
				MenuAktive = 0;
			}
			Hardware::Send_LED();	

			break;	
		}
		
		//--------------------------------------------
		// Channel 3 Button pushed	
		//--------------------------------------------
		case 3:
		{
			if (NumberOfChannels == 2) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			if (Signal::_FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 139;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);	//draw FFT values in status area
				
				Menu_Changed = 1;
				return;
			}
			
			//button switch logic	
			if (Active_Menu == MenuKey)
			{
                		if (!Channel[eCh1].active && !Channel[eCh2].active && !Channel[eCh4].active) break;

				UpdateChannel(eCh3, !Channel[eCh3].active);
				VoltageChangedCh3 = 1;
			}
			else if (!Channel[eCh3].active)	// menu not active -> channel 3 active?
			{ UpdateChannel(eCh3, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_3(); }
			

			//BF changed for channel 3 + 4 support in XY-mode
			if (!Channel[eCh3].active)	//channel 3 switched off
			{
				//If XY-Mode is active, at least channel 1 + 2 must be active - else switch off XY-Mode
				if ((MenuStatus[MENU_TIMEBASE][2] == 241) && !(Channel[eCh1].active && Channel[eCh2].active))
				{ UpdateChannel(eCh3, 1); }
				
				RemovePlane |= 0x04;
				Hardware::ClearPlanes();
			}

			if (Cursor_Enabled) Display::CALCCURSORDATA();
				
			Display::StatusUpdate();
			Display::OssSingle( eOssCh3, 1, 1);	
			
           		New_Menu = 3;
			Menu_Changed = 1;
			
			if (Channel[eCh3].active)
			{
				LED_ON[2] = 1;
				LED_ON[5] = 1;
				MenuAktive = 1;
			}
			else
			{
				LED_ON[2] = 0;
				LED_ON[5] = 0;
				MenuAktive = 0;
			}
			Hardware::Send_LED();	

			break;	
		}
		
		//--------------------------------------------
		// Channel 4 Button pushed	
		//--------------------------------------------
		case 4:
		{
			if (NumberOfChannels == 2) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	//close any popups

			if (Signal::_FFT_Mode != FFT_OFF)
			{
				MenuStatus[MENU_FFT][0] = 140;
				Hardware::FFT_Set_Channel(0);		// set active channel without backup
			
				Display::FFT_DrawStatus(0);		//draw FFT values in status area

				Menu_Changed = 1;
				return;
			}
			
			//button switch logic
			if (Active_Menu == MenuKey)
			{
                		if (!Channel[eCh1].active && !Channel[eCh2].active && !Channel[eCh3].active) break;

				UpdateChannel(eCh4, !Channel[eCh4].active);
				VoltageChangedCh4 = 1;
			}
			else if (!Channel[eCh4].active)	// menu not active -> channel 4 active?
			{ UpdateChannel(eCh4, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_4(); }
			
			//BF changed for channel 3 + 4 support in XY-mode
			if (!Channel[eCh4].active)	//channel 4 switched off
			{
				//If XY-Mode is active, at least channel 1 + 2 must be active - else switch on channel
				if ((MenuStatus[MENU_TIMEBASE][2] == BTN_ON) && !(Channel[eCh1].active && Channel[eCh2].active))
				{ UpdateChannel(eCh4, 1); }
				
				RemovePlane |= 0x08;
				Hardware::ClearPlanes();
			}

			if (Cursor_Enabled) Display::CALCCURSORDATA();
			
			Display::StatusUpdate();
			Display::OssSingle( eOssCh4, 1, 1);	
			
            		New_Menu = 4;
			Menu_Changed = 1;
			
			if (Channel[eCh4].active)
			{
				LED_ON[3] = 1;
				LED_ON[5] = 1;
				MenuAktive = 1;
			}
			else
			{
				LED_ON[3] = 0;
				LED_ON[5] = 0;
				MenuAktive = 0;
			}
			Hardware::Send_LED();	
	
			break;	
		}
		
		//--------------------------------------------
		// Display Button pushed	
		//--------------------------------------------
		case 5:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_TIMEBASE][3] == BTN_ON){ New_Menu = MENU_DISPL_FFT; }
			else {New_Menu = MENU_DISPLAY;}

			Menu_Changed = 1;
			MenuAktive = 1;

			Hardware::Set_LED(5);
			
			break;	
		}
		
		//--------------------------------------------
		// Utility Button pushed	
		//--------------------------------------------
		case 6:
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 6;
			Menu_Changed = 1;
			MenuAktive = 1;
			
			Hardware::Reset_LED(5);
			
			break;	
		}

/* BF function not implemented yet		
		//--------------------------------------------
		// Service Button pushed	//BF doesn't exist
		//--------------------------------------------
		case 7:
		{	
			break;	
		}
*/		
		//--------------------------------------------
		// Save / Recall Button pushed	
		//--------------------------------------------
		case 8:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
						
			New_Menu = 8;
			Menu_Changed = 1;
			
			if (ACQ_PeakDetect)
			{	
				MenuAktive = 0;
				Hardware::Reset_LED(5);
			}
			else
			{
				MenuAktive = 1;
				Hardware::Set_LED(5);
			}
			
			break;	
		}
		
		//--------------------------------------------
		// Print Menu Button pushed	BF -> not used
		//--------------------------------------------
/*		case 9:
		{		
			break;	
		}
*/		
		//--------------------------------------------------------
		// Main/Delay Button pushed	(Timebase menu)
		//--------------------------------------------------------
		case 10:
		{	
			if (Active_Menu == MENU_TIMEBASE) return;				// if menu is already active -> do nothing

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		// close any open popup menu
			
			//No delayed mode for timebase 2ns and USTB-timebases -> gray out
			if (MainTimebase == 0)                            //  || USTB_Mode != USTB_OFF) -> is done in TB handler
			{ MenuStatus[MENU_TIMEBASE][1] = INACTIVE; }	
			else
			{	// restore delayed button
				if(MenuStatus[MENU_TIMEBASE][0] == BTN_ON || MenuStatus[MENU_TIMEBASE][2] == BTN_ON || MenuStatus[MENU_TIMEBASE][3] == BTN_ON)	// if any other button is active
				MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;												// set button off
				else
				MenuStatus[MENU_TIMEBASE][1] = BTN_ON;												// set button on
			}

			New_Menu     = MENU_TIMEBASE;
			Menu_Changed = 1;
			MenuAktive = 1;

			Hardware::Reset_LED(5);

			break;	
		}		
		
		//--------------------------------------------
		// Trigger Mode / Coupling Button
		//--------------------------------------------
		case 12: 
		{ 	

			if (RC_overlay) return;	
			if (RC_request) return;	
		
			//if(FFT_Mode != FFT_OFF) return;
			//if(USTB_Mode != USTB_OFF) return;

			//BF  Toggle trigger mode	#025	
			if (Active_Menu == 12)
			{
				//BF add -> lock trigger mode popup because no triggering should be active at USTB
				if (USTB_Mode != USTB_OFF) { return; }

				F1_Btnhandler();	// if menu is active  -> switch trigger mode
				return;
			}
			else
			{ LED_ON[5] = 1; }

			New_Menu = 12;
			Menu_Changed = 1;
			MenuAktive = 1;
	
			Hardware::Send_LED();
			
			break;
		}		
		
		//--------------------------------------------	
		// Edge Trigger Menu Button pushed	
		//--------------------------------------------
		case 14:
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	
	
			if (USTB_Mode != USTB_OFF)
			{ 
				New_Menu = 14;
				Menu_Changed = 1;
				LED_ON[5] = 0;
				LED_ON[8] = 1;
				LED_ON[10] = 0;
				Hardware::Send_LED();
				return;
			}

//{INSERT nevm 03.03.2011
			if (Active_Menu == 14)
			{
				F1_Btnhandler();
				return;
			}
//INSERT}

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = 14;
			Menu_Changed = 1;
			MenuAktive = 1;

			LED_ON[5] = 1;
			LED_ON[8] = 1;
			LED_ON[10] = 0;
			Hardware::Send_LED();

			if (TriggerWay == TRIG_EDGE) return;
	
			TriggerWay = TRIG_EDGE;
            		TriggerWayChanged = 1;
            		Display::StatusUpdate();
		
			Hardware::SetupTrigger();

			ConfigChanged = 1;

			break;	
		}
		
		//--------------------------------------------
		// Pulse Width Trigger Menu Button pushed	
		//--------------------------------------------
		case 15:
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	

			if (USTB_Mode != USTB_OFF)
			{ 
				New_Menu = 14;
				Menu_Changed = 1;
				LED_ON[5] = 0;
				LED_ON[8] = 0;
				LED_ON[10] = 1;
				Hardware::Send_LED();
				return;
			}

//{INSERT nevm 03.03.2011
			if (Active_Menu == 15)
			{
				F3_Btnhandler();
				return;
			}
//INSERT}
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		
		
            		New_Menu = 15;
			Menu_Changed = 1;
			MenuAktive = 1;

			LED_ON[5]  = 1;
			LED_ON[8]  = 0;
			LED_ON[10] = 1;	
            		Hardware::Send_LED();	

			if (TriggerWay == TRIG_PULS) return;

			TriggerWay = TRIG_PULS;		
            		TriggerWayChanged = 1;
            		Display::StatusUpdate();			
			
            		Hardware::SetupTrigger();

			ConfigChanged = 1;

			break;	
		}		
		
		//--------------------------------------------
		// Cursor Menu Button pushed	
		//--------------------------------------------
		case 16:
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			

			if (Cursor_Enabled && (Active_Menu == MenuKey) && CRS_Delta)	//cursor where active til now
			{
				//switch off cursors
                		Cursor_Enabled_Old = Cursor_Enabled;
                		Cursor_Enabled = false;
				Cursor_Data_First_Draw = 0;

				Display::DrawCursorDeltaValues(0);			// remove the cursor data

				LED_ON[5] = 0;
				LED_ON[6] = 0;
		
				Hardware::Send_LED();			
				
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 0;
				
				if(XY_Mode)//set cursor source channels active
				{
					if(MenuPopupStatus[1][0] == 1 && Channel[eCh1].active) MenuPopupStatus[1][0] = 2;
					if(MenuPopupStatus[1][1] == 1 && Channel[eCh2].active) MenuPopupStatus[1][1] = 2;
					if(MenuPopupStatus[1][2] == 1 && Channel[eCh3].active) MenuPopupStatus[1][3] = 2;
					if(MenuPopupStatus[1][3] == 1 && Channel[eCh4].active) MenuPopupStatus[1][4] = 2;
				} 

				Display::DRAW_ALL_CURSOR();
			}
			else								//cursor where switched off til now
			{
				if (Active_Menu == MenuKey)
				{
					//switch on cursors
					if(CRS_Delta)		//BF new two step logic for delta cursor
					CRS_Delta = 0;
					else
					CRS_Delta = 1;
				}

				LED_ON[5] = 1;
				LED_ON[6] = 1;
							
				if (QM_Enabled)
				{
					QM_Enabled_Old = QM_Enabled;
					QM_Enabled = false;
					Quick_Measure_First_Draw = 0;
	
					Display::DrawCursorDeltaValues(0);	// remove the cursor data
	
					LED_ON[7] = 0;
							
					Menu_Changed = 1;
					Display::CALCQMDATA();
				}	
		
				Cursor_Vertical_Active   = 1;
				Cursor_Horizontal_Active = 3;
		
				Hardware::Send_LED();	
		
				Cursor_Enabled_Old = Cursor_Enabled;
				Cursor_Enabled = true;
				
				Cursor_Data_First_Draw = 1;
				
				CursorChanged = 1;
				CursorChanged = 4;
				
				if(XY_Mode)//set cursor source channels inactive
				{
					MenuPopupStatus[1][1] = 1; MenuPopupStatus[1][3] = 1; 	//gray out channel 2+4

					if(!Channel[eCh1].active || !Channel[eCh2].active)
					{ MenuPopupStatus[1][0] = 1; }				//gray out channel 1

					if(!Channel[eCh3].active || !Channel[eCh4].active)
					{ MenuPopupStatus[1][2] = 1; }				//gray out channel 3
				} 

				if(Signal::_FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();
				
				Display::DRAW_ALL_CURSOR();

						
				New_Menu = 16;
				Menu_Changed = 1;
				MenuAktive = 1;
			}

			UpdateMenuTextPlane = true;
			ConfigChanged = 1;

			break;	
		}

		//--------------------------------------------
		// Quick Print Button pushed
		//--------------------------------------------
		//BF -> new two step logic
		//BF QP pushed once -> print menu
		//BF QP pushed twice -> direct screenshot

		case 17: 
		{
			if(QP_request > 2) { QP_request = 0; return; }

			QP_request ++;
			if(QP_request == 1)				// first push
			{ nr_delay(1000); Keyboard_Interface();}	// recursive call

			if(QP_request == 1)				// call print menu at single push
			{
				if (QP_mode == 0)
				{ New_Menu = MENU_QUICKPRINT; }		// to PC
				else if (QP_mode == 1)
				{ New_Menu = MENU_QP_USB; }		// to USB-Host

				Menu_Changed = 1;
				MenuAktive = 1;

				Hardware::Reset_LED(5);
				QP_request = 0;
				return;
			}
			else if (QP_request == 2)			// direct screenshot at double push
			{
				if (QP_mode == 0)
				{ CommIF::SCREENSHOT('S'); } 		// save to BMP in compatibility mode
				else if (QP_mode == 1)
				{ CommIF::UC_SCREENSHOT(); } 		// save to USB / SD-card 

				QP_request = 0;
				Menu_Changed = 0;
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }// close popup
				return;
			}
			return;
		}
		
		//--------------------------------------------
		// Quick Measure Button pushed
		//--------------------------------------------
		case 19:
		{ 	
             		if (XY_Mode) return;
			if (Signal::_FFT_Mode != FFT_OFF) return;
			if (USTB_Mode != USTB_OFF) return; 			//-> QM corrupts USTB-timing

 			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if ((QM_Enabled) && (Active_Menu == MenuKey))		// QM was active -> switch off QM
			{
				Display::DisableQM();
				
				MenuAktive   = 0;
			}
			else							// switch on QM
			{ 	
				Display::EnableQM();

				MenuAktive   = 1;
				UpdateMenuTextPlane = true;
			}
			
			Display::DRAW_ALL_CURSOR();

			New_Menu = 19;
			Menu_Changed = 1;

			ConfigChanged = 1;
			
			break;
		}
		
		//--------------------------------------------
		// Autoscale Button pushed
		//--------------------------------------------
		case 23:
		{	
			if (RC_overlay) return;	
			if (RC_request) return;	
			if (Signal::_FFT_Mode != FFT_OFF) return;	//BF no AutoScale if FFT is active

			if(AS_request > 2) { AS_request = 0; return; }

			if (AS_request == 0)	// save actual setting
			{ AMDFlash::WriteConfigBackup(); }

			AS_request ++;
			if(AS_request == 1)				// first push
			{ nr_delay(1000); Keyboard_Interface();}	// recursive call

 			if(AS_request == 1)				// start fast autoscale at single push
			{ Hardware::AutoScale(0); }			// fast TB
			else if (AS_request == 2)			// start slow autoscale at double push
			{ Hardware::AutoScale(1); }			// slow TB
		
			New_Menu = MENU_AUTOSCALE;
			Menu_Changed = 1;
			MenuAktive = 1;

			Hardware::Reset_LED(5);

			break;
        	}

		//--------------------------------------------
		// Math Button pushed
		//--------------------------------------------
		case 26:
		{		
            		if (XY_Mode) return;
			if (Signal::_FFT_Mode != FFT_OFF) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			// toggle math menu status
			if ((Active_Menu == MenuKey) && Channel[eChM].active)
			{							
				if (Channel[eChM].active) Channel[eChM].active = 0;
				else Channel[eChM].active = 1;
			}
			else 
			{ Channel[eChM].active = 1; }

 			if (Channel[eChM].active)
            		{
				// Math with only one channel makes no sense
				if(!Channel[eCh1].active){ UpdateChannel(eCh1, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_1(); }	
				if(!Channel[eCh2].active){ UpdateChannel(eCh2, 1); RotarySteps = 0; UserIF::ON_Zero_Channel_2(); }	
				LED_ON[0] = 1;
				LED_ON[1] = 1;
				LED_ON[4] = 1;			// switch on LED
				LED_ON[5] = 1;
				MenuAktive = 1;			// activate buttons
            		}
			else if (!Channel[eChM].active)
            		{
				LED_ON[4] = 0;			// switch off LED
				LED_ON[5] = 0;
				MenuAktive = 0;			// grey out the buttons
		
				RemovePlane |= 0x10;
				Hardware::ClearPlanes();
            		}

			UpdateChannel(eChM, Channel[eChM].active);

			Hardware::Send_LED();

			ConfigChanged = true; 	

           		New_Menu = MENU_MATH;
			Menu_Changed = 1;

			break;	
		}
		
		//--------------------------------------------
		// Function Button 1 pushed
		//--------------------------------------------
		case 30 :
		{
			// Button handler for function button 1 	BF new function
			F1_Btnhandler();
			break;
		}	

		//--------------------------------------------
		// Function Button 2 pushed
		//--------------------------------------------
		case 31 :
		{
			// Button handler for function button 2 	BF new function
			F2_Btnhandler();
			break;
		}

		//--------------------------------------------	
		// Function Button 3
		//--------------------------------------------
		case 32 :
		{
			// Button handler for function button 3 	BF new function
			F3_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 4
		//--------------------------------------------
		case 33 :
		{
			// Button handler for function button 4 	BF new function
			F4_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 5
		//--------------------------------------------
		case 34 :
		{
			// Button handler for function button 5 	BF new function
			F5_Btnhandler();
			break;
		}
		
		//--------------------------------------------
		// Function Button 6
		//--------------------------------------------
		case 35 :
		{		
			// Button handler for function button 6 	BF new function
			F6_Btnhandler();
			break;
		}
		
		//--------------------------------------------
        	// Run / Stop Button pushed
		//--------------------------------------------
		case 37 :
		{	
			if (Run)	// Run mode was active (normal operating) -> now switching to Stop mode
			{
				Run = 0;		// stop acquisition
				SingleShot = 0;		// initialize single shot

				// Run/Stop to red
				LED_ON[12] = 0;
				LED_ON[13] = 1;
				// Single green
				LED_ON[14] = 0;
				LED_ON[15] = 1;

				if (USTB_Mode == USTB_OFF)					// normal acquisition mode
				{
					Hardware::CaptureTrigSetMode(eTrigNorm);			// force to normal trigger for event recognizing in background
					Display::DRAWSTATUS(7, 0);					// draw stop sign
				}
				else								// ultra slow acquisition
				{
					Hardware::Stop_Timer2();
					Hardware::Stop_Record();
					Display::DRAWSTATUS(6, 0);					// draw stop sign
				}

				VirtualTimebase = 0;			//BF #023
				
				//if (!RC_request)							// if recall is requested the signal must not be read again
				//Hardware::GetFullSignal();						// read full signal length for scrolling 
			}
			else		// Stop mode was active (no signal acquisition) -> now switching back to Run mode
			{
				Run        = 1;
				SingleShot = 0;

				VirtualTimebase = 0;			//BF #023
				TimebaseChanged = 1;			//BF #023
				Display::RecalcTimeParameters();	//BF #023

				if (!RC_request)							// coming back from signal recall?
				{
					if (USTB_Mode == USTB_OFF)					// normal timebase?
					{
						Menu_Changed        = 1;
						TriggerLevelChanged = 1;
						
						Hardware::SetupTrigger();				// restore trigger setting
					}
	
					Display::DRAW_ALL_CURSOR();
				}
				

				// Run/Stop green
				LED_ON[12] = 1;
				LED_ON[13] = 0;
				// Single off/green
				LED_ON[14] = 0;
				if (MenuStatus[MENU_TRIGGERSUB][3] == 126)				// direct manual trigger
				LED_ON[15] = 1;
				else
				LED_ON[15] = 0;
				
				if (USTB_Mode == USTB_OFF)					// normal TB
				{
					TriggerModeChanged = 1;						// remove stop sign
					Hardware::Start_Record();
				}
				else								// ultra slow TB
				{
					TriggerLevelChanged = 1;					// remove stop sign
					LED_ON[15] = 1;
					ADC_DataAvailable = 0;
					if (RC_request) Signal::USTB_clearBuffer();			// restart with cleared buffers	
					Hardware::Reset_Timer2();
				}
			}
			
			Display::StatusUpdate();							// remove stop sign and display trigger mode
			Hardware::Send_LED();

			RC_request = 0;
			RC_overlay = 0;

			break;
        	}

		//--------------------------------------------
        	// Single Button pushed
		//--------------------------------------------
		case 38 :
		{	
			if (RC_overlay) return;	
		
			if (RC_request) return;	

			//if (Signal::_FFT_Mode != FFT_OFF) return;	

			if (USTB_Mode != USTB_OFF)							// special single shot function for USTB
			{										// which forces one buffer fill up and then stop
				if (!Run)
				{ Run = 1; Hardware::Reset_Timer2(); }					// restart acquisition after stop mode

				// Run/Stop green
				LED_ON[12] = 1;
				LED_ON[13] = 0;

				if (SingleShot)
				{
					// Single green
					LED_ON[14] = 0;
					LED_ON[15] = 1;
					SingleShot = 0;
				}
				else
				{
					// Single orange
					LED_ON[14] = 1;
					LED_ON[15] = 1;
					SingleShot = 1;
					Signal::USTB_clearBuffer();					// restart with cleared buffers
				}
				Hardware::Send_LED();
				
				return;
			}

			// force single push
			if (Run && MenuStatus[MENU_TRIGGERSUB][3] == 126)				// force manual trigger (single push)
			{
				//if (MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)			// makes sense only in normal mode
				{
					// Single orange
					LED_ON[14] = 1;
					LED_ON[15] = 1;

					Hardware::Send_LED();
		
					Hardware::CaptureTrigSetMode(eTrigFreerun);			// Switch off trigger 
					Hardware::Start_Record();
					
					ACQ_ManTrigg = 1;
				}
				
				return;
			}
			// force double push
			if (SingleShot && MenuStatus[MENU_TRIGGERSUB][3] == 125)			// force manual trigger after double push
			{
				Hardware::CaptureTrigSetMode(eTrigFreerun);				// Switch off trigger 
				Hardware::Start_Record();

				ACQ_ManTrigg = 1;

				return;
			}

			
			if (Run)									// DSO is running -> switch to single shot mode directly
			{
				Run = 0;								// switch to stop mode
				VirtualTimebase = 0;			//BF #023
			}

			// Run / Stop off
			LED_ON[12] = 0;
			LED_ON[13] = 0;
	
			// Single orange
			LED_ON[14] = 1;
			LED_ON[15] = 1;

			if (MenuStatus[MENU_TRIGGERSUB][0] == 115)
			{
				if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
				{ LED_ON[2]  = 1; }							//CH3 LED (blue) on -> Trigger is armed 
				else 
				{ LED_ON[9] = 1; } 							//left LED (green) on -> Trigger is armed 	
			}

			LED_ON[11] = 0;									//right LED (red) off -> no triggerevent 
			
			if(MenuStatus[MENU_TRIGGERSUB][2] == BTN_ON)
			{ LED_ON[3] = 0; }								//Channel 4 LED off

			Hardware::Send_LED();

			SingleShot = 1;
		
			Hardware::CaptureTrigSetMode(eTrigNorm);					// force to normal trigger
			
			Menu_Changed = 1;
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;

			//Hardware::SetupTrigger();	
			Display::StatusUpdate();

			nr_delay(50);	//BF test 
			
			// BF -> old coding 
			if (ADC_Started == false) { Hardware::Start_Record(); }

			break;
		}
	
		//--------------------------------------------
		// Test Funktion 0 Q
		//--------------------------------------------
		case 40 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 0 (Q)  adjusting ADC zero offsets\r\n");
			
			for (uint32_t ix = 0; ix < 100; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\r\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				nr_delay(10);
			}

			printf("\r\nSetting ADC offsets\r\n\r\n");

/*	
			TestVar++;
			if(TestVar > 25) TestVar = 0;
			switch(TestVar)
			{	
				case 0: {Hardware::_ADC_Offset[test_channel-1][0] = 0;Hardware::_ADC_Offset[test_channel-1][1] = 0;Hardware::_ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 1: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
				case 2: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				case 3: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
				case 4: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 5: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
				case 6: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				case 7: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
				case 8: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 9: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
				case 10: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				case 11: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 1; break;}
				case 12: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 13: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 1; break;}
				case 14: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				
				case 15: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 16: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 17: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				case 18: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 0; break;}
				case 19: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 2;ADC_Offset[test_channel-1][3] = 0; break;}
				case 20: {ADC_Offset[test_channel-1][0] = 2;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 0; break;}
				case 21: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}
				case 22: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 1;ADC_Offset[test_channel-1][3] = 2; break;}
				case 23: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 1;ADC_Offset[test_channel-1][2] = 2;ADC_Offset[test_channel-1][3] = 2; break;}
				case 24: {ADC_Offset[test_channel-1][0] = 1;ADC_Offset[test_channel-1][1] = 0;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}
				case 25: {ADC_Offset[test_channel-1][0] = 0;ADC_Offset[test_channel-1][1] = 2;ADC_Offset[test_channel-1][2] = 0;ADC_Offset[test_channel-1][3] = 2; break;}
			
			//	case 26: { printf("\r\nAuto calibrating ADC voltage offsets\r\n\r\n");Calibrate_ADC(test_channel); break;}
			
			}			
					
			printf("Channel %d ADC offset = %d %d %d %d\n", test_channel, ADC_Offset[test_channel-1][0],
										      ADC_Offset[test_channel-1][1],
										      ADC_Offset[test_channel-1][2],
										      ADC_Offset[test_channel-1][3]);
*/
			printf("****************************************************************************************\n");
			break;
		}
	
		//--------------------------------------------
		// Test Funktion 1 W
		//--------------------------------------------
		case 41 :
		{	
			printf("****************************************************************************************\n");
			printf("Test function 1 decrement zeroes (shift + W)\n");
			
			// Guido: make testfunction work for the selected testchannel:
			switch (test_channel)
			{

				case 1:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
						nr_delay(10);
					}

					printf("CH1 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH1);
					printf("CH1 Zero Level         = %d\n\n", ZeroLevelCH1);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH1)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] --; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] --; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] --; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] --; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] --; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] --; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] --; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] --; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] --; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] --; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] --; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] --; break;//5 V
					}
			
					printf("CH1 DAC correction 1   = %d\n", DAC_Correction[CalSet][test_channel-1][0]);
					printf("CH1 DAC correction 2   = %d\n", DAC_Correction[CalSet][test_channel-1][1]);
					printf("CH1 DAC correction 3   = %d\n", DAC_Correction[CalSet][test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 2:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
						nr_delay(10);
					}

					printf("CH2 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH2);
					printf("CH2 Zero Level         = %d\n\n", ZeroLevelCH2);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH2)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] --; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] --; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] --; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] --; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] --; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] --; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] --; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] --; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] --; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] --; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] --; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] --; break;//5 V
					}
			
					printf("CH2 DAC correction 1   = %d\n", DAC_Correction[CalSet][test_channel-1][0]);
					printf("CH2 DAC correction 2   = %d\n", DAC_Correction[CalSet][test_channel-1][1]);
					printf("CH2 DAC correction 3   = %d\n", DAC_Correction[CalSet][test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 3:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
						nr_delay(10);
					}

					printf("CH3 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH3);
					printf("CH3 Zero Level         = %d\n\n", ZeroLevelCH3);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH3)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] --; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] --; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] --; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] --; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] --; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] --; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] --; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] --; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] --; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] --; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] --; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] --; break;//5 V
					}
			
					printf("CH3 DAC correction 1   = %d\n", DAC_Correction[CalSet][test_channel-1][0]);
					printf("CH3 DAC correction 2   = %d\n", DAC_Correction[CalSet][test_channel-1][1]);
					printf("CH3 DAC correction 3   = %d\n", DAC_Correction[CalSet][test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 4:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
						nr_delay(10);
					}

					printf("CH4 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH4);
					printf("CH4 Zero Level         = %d\n\n", ZeroLevelCH4);
					
					printf("decrementing zero correction\n\n");
					switch(Selected_Voltage_CH4)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] --; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] --; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] --; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] --; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] --; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] --; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] --; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] --; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] --; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] --; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] --; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] --; break;//5 V
					}
			
					printf("CH4 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH4 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH4 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
			}
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 2 E
		//--------------------------------------------
		case 42 :
		{	
			printf("****************************************************************************************\n");
			printf("Test function 2 increment zeroes (shift + E)\n");

			// Guido: make testfunction work for the selected testchannel:
			switch (test_channel)
			{

				case 1:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
						nr_delay(10);
					}

					printf("CH1 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH1);
					printf("CH1 Zero Level         = %d\n\n", ZeroLevelCH1);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH1)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] ++; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] ++; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-1] ++; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] ++; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] ++; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-3] ++; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] ++; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] ++; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-6] ++; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] ++; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] ++; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH1-9] ++; break;//5 V
					}
			
					printf("CH1 DAC correction 1   = %d\n", DAC_Correction[CalSet][test_channel-1][0]);
					printf("CH1 DAC correction 2   = %d\n", DAC_Correction[CalSet][test_channel-1][1]);
					printf("CH1 DAC correction 3   = %d\n", DAC_Correction[CalSet][test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 2:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
						nr_delay(10);
					}

					printf("CH2 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH2);
					printf("CH2 Zero Level         = %d\n\n", ZeroLevelCH2);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH2)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] ++; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] ++; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-1] ++; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] ++; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] ++; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-3] ++; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] ++; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] ++; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-6] ++; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] ++; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] ++; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH2-9] ++; break;//5 V
					}
			
					printf("CH2 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH2 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH2 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 3:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
						nr_delay(10);
					}

					printf("CH3 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH3);
					printf("CH3 Zero Level         = %d\n\n", ZeroLevelCH3);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH3)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] ++; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] ++; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-1] ++; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] ++; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] ++; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-3] ++; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] ++; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] ++; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-6] ++; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] ++; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] ++; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH3-9] ++; break;//5 V
					}
			
					printf("CH3 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH3 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH3 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
				case 4:
				{
					for (uint32_t ix = 0; ix < 100; ix+=4)
					{
						printf("S1_%d : %3d %3d %3d %3d\n", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
						nr_delay(10);
					}

					printf("CH4 Virtual Zero Level = %d\n", Virtual_ZeroLevelCH4);
					printf("CH4 Zero Level         = %d\n\n", ZeroLevelCH4);
					
					printf("incrementing zero correction\n\n");
					switch(Selected_Voltage_CH4)
					{
						case 0: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] ++; break;//  1 mV
						case 1: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] ++; break;//  2 mV
						case 2: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-1] ++; break;//  5 mV
						case 3: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] ++; break;// 10 mV
						case 4: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] ++; break;// 20 mV
						case 5: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-3] ++; break;// 50 mV
						case 6: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] ++; break;//100 mV
						case 7: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] ++; break;//200 mV
						case 8: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-6] ++; break;//500 mV
						case 9: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] ++; break;// 1 V
						case 10: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] ++; break;//2 V
						case 11: DAC_Correction[CalSet][test_channel-1][Selected_Voltage_CH4-9] ++; break;//5 V
					}
			
					printf("CH4 DAC correction 1   = %d\n", DAC_Correction[test_channel-1][0]);
					printf("CH4 DAC correction 2   = %d\n", DAC_Correction[test_channel-1][1]);
					printf("CH4 DAC correction 3   = %d\n", DAC_Correction[test_channel-1][2]);
			
					printf("****************************************************************************************\n");
					break;			
				}
			}
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 3 R
		//--------------------------------------------
		case 43 :
		{	
			printf("****************************************************************************************\r\n");
			printf("\r\nTest function 3 USTB buffer test (shift + R)\r\n");
			
			printf("MemStartOffset %d   USTB_idx %d\r\n",MemStartOffs, USTB_idx);
			for (int i=MemStartOffs;i<=USTB_idx+10;i++)
			{ printf("%d   %d\r\n",i, S1Ptr[i]); }

			//printf("* adc_change12_reg :  %8x    * adc_change34_reg : %8x *\r\n", adc_change12_reg, adc_change34_reg);
			printf("****************************************************************************************\r\n");


			break;
		}
		
		//--------------------------------------------
		// Test Funktion 4 T
		//--------------------------------------------
		case 44 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 4 - switch screenshot mode - (shift + T)\r\n");	
	
			//switch Quick Print mode
			if (QP_mode == 0) QP_mode = 1;
			else if (QP_mode == 1) QP_mode = 2;
			else QP_mode = 0;
			
			printf("\nQP_mode = %d\n", QP_mode);
			printf("****************************************************************************************\r\n");

			
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 5 Z
		//--------------------------------------------
		case 45 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 5 - switch testchannel - (shift + Z)\r\n");	

			//test channel
			test_channel++;
			if (test_channel > NumberOfChannels) test_channel = 1;
			if (test_channel < 1) test_channel = 1;
			printf("\nTest channel = %d\n", test_channel);
			printf("****************************************************************************************\r\n");

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 6 U
		//--------------------------------------------
		case 46 :
		{		
			printf("\r\n****************************************************************************************\r\n");
			printf("Test function 6 - print ADC values with decimation factor - (shift + U)\r\n");	
			
			//print signal values
			for (uint32_t x=0,ix=draw_start; x < 600; x++, ix += draw_factor)
			{
				printf("idx %d: S1 %3d  S2 %3d  Math %3d\r\n", ix, SIGNAL1[ix], SIGNAL2[ix], SIGNALM[ix]);
				//nr_delay(10);
			}

			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 7 I
		//--------------------------------------------
		case 47 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 7 - Transfer USB Data - (shift + I)\r\n");	


			if (USB_Data_Requested && Transfer_man_data)
			{ USB_Data_Requested = 0; Transfer_man_data = 0; printf("USB Transfer switched off\n\r"); }	
			else
			{ USB_Data_Requested = 1; Transfer_man_data = 1; printf("USB Transfer switched on\n\r"); }	
			
			USB_OnlyTrigger = false;

			break;

			printf("\r\n****************************************************************************************\r\n");

		}
		
		//--------------------------------------------
		// Test Funktion 8 O
		//--------------------------------------------
		case 48 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Hidden function 8 - set modification and save protected config data - (shift + O)\r\n");	
			
			
			
			if (MenuStatus[MENU_HARDWARE][1] == 230 ) 	// Factory
			{
				tc_hw_modif = 0;		   	// hardware modification
				
				if (NumberOfChannels == 4 )
				{	
					//tc_model    = 2024;
				}
				else
				{
					//tc_model    = 2022;
				}
			}

			
			
			if (MenuStatus[MENU_HARDWARE][1] == 231 ) 	// LB-Mod
			{
				tc_hw_modif = 656;		   	// hardware modification
				
				if (NumberOfChannels == 4 )
				{	
					tc_model    = 2024;
				}
				else
				{
					tc_model    = 2022;
				}
			}

			
			if (MenuStatus[MENU_HARDWARE][1] == 232 ) 	// OPA653 Mod
			{
				tc_hw_modif = 653;		   	// hardware modification
				
				if (NumberOfChannels == 4 )
				{	
					tc_model    = 2034;
				}
				else
				{
					tc_model    = 2032;
				}
			}

			if (MenuStatus[MENU_HARDWARE][1] == 233 ) 	// 24.5 Ohm Mod
			{
				tc_hw_modif = 0;		   	// hardware modification
				
				if (NumberOfChannels == 4 )
				{	
					tc_model    = 2024;
				}
				else
				{
					tc_model    = 2022;
				}
			}
			
			if (MenuStatus[MENU_HARDWARE][1] == 234 ) 	// LMH6518 Mod
			{
				tc_hw_modif = 6518;		   	// hardware modification
				
				if (NumberOfChannels == 4 )
				{	
					tc_model    = 2034;
				}
				else
				{
					tc_model    = 2032;
				}
			}
			
			
			
			AMDFlash::WriteProtectedSector();	
			
			printf("\r\nProtected Flash has been updated!\r\n");
			
			if (tc_hw_modif == 656 || tc_hw_modif == 653)									// LB-Mod (OPA656) or OPA653 Mod
			printf("Model   : W%04dA / OPA%03d Mod / %d Channels \r\n", tc_model, tc_hw_modif, NumberOfChannels);
			else if (tc_hw_modif == 6518)											// addon PCB with LMH6518
			printf("Model   : W%04dA / LMH%03d Mod / %d Channels \r\n", tc_model, tc_hw_modif, NumberOfChannels);	
			else	
			printf("Model   : W%04dA / %d Channels \r\n", tc_model, NumberOfChannels);					// normal factory version
			

			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 9 P
		//--------------------------------------------
		case 49 :
		{
			printf("****************************************************************************************\r\n");
			printf("Hidden function 9 - set back model to 100MHz (W201x) - (shift + P)\r\n");	

			if (NumberOfChannels == 4 )
			{	
				tc_model    = 2014;
			}
			else
			{
				tc_model    = 2012;
			}
		
			AMDFlash::WriteProtectedSector();	
			
			printf("\r\nProtected Flash has been updated!\r\n");
			
			printf("Model   : W%04dA / OPA%03d Mod / %d Channels \r\n", tc_model, tc_hw_modif, NumberOfChannels);
			
			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 10 A
		//--------------------------------------------
		case 50 :
		{	
            		printf("****************************************************************************************\r\n");
			printf("Test function 10 (A) - display ADC-values - \r\n");

			
/*			//print signal values channel 1
			for (uint32_t ix = 0; ix < 600; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d\r\n", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				//nr_delay(10);
			}
*/			
			
			printf("            Channel 1                    Channel 2                  Channel 3                    Channel 4 \r\n");
			for (uint32_t ix = 0; ix < 2000; ix+=4)
			{
				printf("S1_%d : %3d %3d %3d %3d    ", ix, SIGNAL1[ix], SIGNAL1[ix + 1], SIGNAL1[ix + 2], SIGNAL1[ix + 3]);
				printf("S2_%d : %3d %3d %3d %3d    ", ix, SIGNAL2[ix], SIGNAL2[ix + 1], SIGNAL2[ix + 2], SIGNAL2[ix + 3]);
				if (NumberOfChannels == 4)
				{
					printf("S3_%d : %3d %3d %3d %3d    ", ix, SIGNAL3[ix], SIGNAL3[ix + 1], SIGNAL3[ix + 2], SIGNAL3[ix + 3]);
					printf("S4_%d : %3d %3d %3d %3d    ", ix, SIGNAL4[ix], SIGNAL4[ix + 1], SIGNAL4[ix + 2], SIGNAL4[ix + 3]);
				}
				printf("\n");
				//nr_delay(10);
			}
			printf("\n");
			//printf("Draw factor            = %d\r\n\r\n", draw_factor);
		
			//printf("CH1 alpha correction   = %d\r\n", alpha[0]);
			//printf("CH1 beta correction    =  ");floatprintf(beta[0]);printf("\r\n\r\n");
			
			//printf("CH2 alpha correction   = %d\r\n", alpha[1]);
			//printf("CH2 beta correction    =  ");floatprintf(beta[1]);printf("\r\n\r\n");
			//printf("ZeroLevelCH1            = %d\n", ZeroLevelCH1);
			//printf("Virtual_ZeroLevelCH1    = %d\n\n", Virtual_ZeroLevelCH1);

			printf("Voltage range CH1       = %d\n", Selected_Voltage_CH1);
			printf("Voltage range CH2       = %d\n", Selected_Voltage_CH2);

			if (NumberOfChannels == 4)
			{
				printf("Voltage range CH3       = %d\n", Selected_Voltage_CH3);
				printf("Voltage range CH4       = %d\n", Selected_Voltage_CH4);
			}
			printf("\n");
			printf("CH1 ADC1 Voltage offset = %d\r\n",Hardware::_ADC_Offset[0][0]);
			printf("CH1 ADC2 Voltage offset = %d\r\n",Hardware::_ADC_Offset[0][1]);
			printf("CH1 ADC3 Voltage offset = %d\r\n",Hardware::_ADC_Offset[0][2]);
			printf("CH1 ADC4 Voltage offset = %d\r\n\r\n",Hardware::_ADC_Offset[0][3]);
			
			printf("CH2 ADC1 Voltage offset = %d\r\n",Hardware::_ADC_Offset[1][0]);
			printf("CH2 ADC2 Voltage offset = %d\r\n",Hardware::_ADC_Offset[1][1]);
			printf("CH2 ADC3 Voltage offset = %d\r\n",Hardware::_ADC_Offset[1][2]);
			printf("CH2 ADC4 Voltage offset = %d\r\n\r\n",Hardware::_ADC_Offset[1][3]);
			
			if (NumberOfChannels == 4)
			{
				printf("CH3 ADC1 Voltage offset = %d\r\n",Hardware::_ADC_Offset[2][0]);
				printf("CH3 ADC2 Voltage offset = %d\r\n",Hardware::_ADC_Offset[2][1]);
				printf("CH3 ADC3 Voltage offset = %d\r\n",Hardware::_ADC_Offset[2][2]);
				printf("CH3 ADC4 Voltage offset = %d\r\n\r\n",Hardware::_ADC_Offset[2][3]);
				
				printf("CH4 ADC1 Voltage offset = %d\r\n",Hardware::_ADC_Offset[3][0]);
				printf("CH4 ADC2 Voltage offset = %d\r\n",Hardware::_ADC_Offset[3][1]);
				printf("CH4 ADC3 Voltage offset = %d\r\n",Hardware::_ADC_Offset[3][2]);
				printf("CH4 ADC4 Voltage offset = %d\r\n\r\n",Hardware::_ADC_Offset[3][3]);
			}


			printf("CH1 DAC correction 1   = %d\n", DAC_Correction[0][0]);
			printf("CH1 DAC correction 2   = %d\n", DAC_Correction[0][1]);
			printf("CH1 DAC correction 3   = %d\n", DAC_Correction[0][2]);
			
			printf("CH2 DAC correction 1   = %d\n", DAC_Correction[1][0]);
			printf("CH2 DAC correction 2   = %d\n", DAC_Correction[1][1]);
			printf("CH2 DAC correction 3   = %d\n", DAC_Correction[1][2]);
			
			if (NumberOfChannels == 4)
			{
				printf("CH3 DAC correction 1   = %d\n", DAC_Correction[2][0]);
				printf("CH3 DAC correction 2   = %d\n", DAC_Correction[2][1]);
				printf("CH3 DAC correction 3   = %d\n", DAC_Correction[2][2]);
	
				printf("CH4 DAC correction 1   = %d\n", DAC_Correction[3][0]);
				printf("CH4 DAC correction 2   = %d\n", DAC_Correction[3][1]);
				printf("CH4 DAC correction 3   = %d\n", DAC_Correction[3][2]);
			}
			printf("\r\n****************************************************************************************\r\n");
            		break;
		}
		
		//--------------------------------------------
		// Test Funktion 11 S
		//--------------------------------------------
		case 51 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 11 (S) - test switch 1 on/off - \r\n");
			
			//toggle test switch
			if(test_sw1){ test_sw1 = 0; printf("Test switch 1 is off"); }
			else { test_sw1 = 1; printf("Test switch 1 is on"); }

			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 12 D
		//--------------------------------------------
		case 52 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 12 (D) - Test delay() funktion- \r\n");
			
			// test delay function
			
			printf("\r\n\r\n0 seconds elapsed");

			for (uint32_t cnt=0;cnt<60;cnt++)
			{
				nr_delay(1000);
				printf("\r%d seconds elapsed",cnt);
			}
			printf("\r\n****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 13 F
		//--------------------------------------------
		case 53 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 13 (F) - Get Flash ID - (shift + F)\r\n\r\n");
			
			uint16_t flash_id = AMDFlash::GetDeviceID();
			
			printf("Flash ID : %04X\r\n\r\n", flash_id);
			
			printf("First Byte - JEDEC Manufacturer ID\r\n");
			printf("0x01 - AMD\r\n");
			printf("0xC2 - Macronix\r\n\r\n");  

			printf("Second Byte - Device ID\r\n");
			printf("0x93 - 29LV065D 64 Megabit (8 M x 8-Bit) CMOS 3.0 Volt-only Uniform Sector Flash Memory\r\n\r\n");
		
			printf("****************************************************************************************\r\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 14 G
		//--------------------------------------------
		case 54 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 14 (G) - switch gain - \r\n");

			GainIdx++;

			if(GainIdx > 4) GainIdx = 0;

			if (Channel[eCh1].active) Hardware::SetSwitches(eCh1, Selected_Voltage_CH1);
			if (Channel[eCh2].active) Hardware::SetSwitches(eCh2, Selected_Voltage_CH2);
			if (Channel[eCh3].active) Hardware::SetSwitches(eCh3, Selected_Voltage_CH3);
			if (Channel[eCh4].active) Hardware::SetSwitches(eCh4, Selected_Voltage_CH4);
			MenuStatus[MENU_HARDWARE][1] = GainIdx + 230;			//Set gain menu 

			printf("Gain Index = %d\r\n", GainIdx);

			printf("****************************************************************************************\r\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 15 H/h
		//--------------------------------------------
		case 55 :
		{	
	
			printf("\r\n");
			printf("***************************************************************************\r\n");
			printf("* Keyboard Commands : Menus                                               *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Channel 1     : i  *  Mode / Timebase : b * Display      : d * File : f *\r\n");
			printf("* Channel 2     : j  *  Cursor          : c * Trigger Edge : e *          *\r\n");
			printf("* Channel 3     : k  *  Quick Measure   : q * Mode / Coup  : t *          *\r\n");
			printf("* Channel 4     : l  *  Quick Meas Sett : w * Pulse Width  : p *          *\r\n");
			printf("* Channel Math  : o  *  Acquire         : a * Utility      : u *          *\r\n");
			printf("***************************************************************************\r\n");
			printf("* Extended Commands : Help Keys                                           *\r\n");
			printf("***************************************************************************\r\n");
			printf("* This Help Screen  : h / Shift + H * Test switch 2          : Shift + Y  *\r\n");
			printf("* Test delay function   : Shift + D * Test switch 3          : Shift + X  *\r\n");
			printf("* Get flash ID          : Shift + F * Manual DAC calibration : Shift + W  *\r\n");
			printf("* Test switch 1         : Shift + S * Manual DAC calibration : Shift + E  *\r\n");
			printf("* not available         : Shift + R * Set Model to 100MHZ    : Shift + P  *\r\n");
			printf("* Manual ADC calibration: Shift + Q * Trigger USB transfer   : Shift + I  *\r\n");
			printf("* Switch test channel   : Shift + Z * not available          : Shift + M  *\r\n");
			printf("* Switch gain index     : Shift + G * Reset all test values  : Shift + J  *\r\n");
			printf("* Start frame counter   : Shift + K * Stop frame counter     : Shift + L  *\r\n");
			printf("* Quick Print mode      : Shift + T * Display ADC values     : Shift + A  *\r\n");
			printf("* Plane color demo      : Shift + C * Write trigo tables     : Shift + N  *\r\n");
			printf("* Show variables        : ,         * Switch FFT status displ: Shift + V  *\r\n");
			//printf("*                   :     !         *                        : -          *\r\n");
			//printf("* M-Factor CHI + 10 :     Shift + 2 * M-Factor CHI - 10      : Shift + 3  *\r\n");
			printf("* Show ADC values + Math: Shift + U * Display ADC offsets    : =          *\r\n");
			printf("* Change Model          : Shift + O * not available          : Shift + Ö  *\r\n");
			printf("*  not available        : x         *                                     *\r\n");
			printf("*  not available        : z         *                                     *\r\n");
			printf("*-------------------------------------------------------------------------*\r\n");
			//printf("* All test switches off:                                                  *\r\n");
			printf("* Test switch 1 on     : n.a					          *\r\n");
			printf("* Test switch 2 on     : n.a    					  *\r\n");
			printf("* Test switch 3 on     : n.a.						  *\r\n");
			printf("*                                                                         *\r\n");
		//            printf("* Timebase manipulation : Press ShiftKey +                                *\r\n");
		//            printf("*      1       2       3     4    5    6    7      8      9         0     *\r\n");
		//            printf("* -0x10000 -0x1000 -0x100 -0x10 -0x1 +0x1 +0x10 +0x100 +0x1000 +0x100000  *\r\n");
			printf("***************************************************************************\r\n");
			printf("\r\n");

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 16 J (shift + J)
		//--------------------------------------------
		case 56 :
		{		
			//Reset test values
			test_channel = 1;
			//test_offs_a  = 0;
			//test_offs_b  = 0;
			//test_zero_a  = 0;
			//test_zero_b  = 0;
			//test_div_a   = 1;
			//test_div_b   = 1;
			//test_rel_a   = 0;
			//test_rel_b   = 0;
			FrameCount   = 0;
			printf("\r\nTest values resetted\n\r");

			//printf("ctr %x actr %x tb %x pr %x tvr1 %x tvr2 %x trr %x trw %x tp1 %i adc_ch %x \r\n", ctrl_reg, adc_ctrl_reg, timebase_reg, pre_reg, trg_val_CHI_reg, trg_val_CHII_reg, trig_range_reg, trig_width_reg, Trigger_Pos_CH1, adc_change12_reg);

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 17 K (shift + K)
		//--------------------------------------------
		case 57 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Hidden function 17 - Start Frame Counter - (shift + K)\r\n\r\n");	

			printf("actual frame count = %d\r\n",FrameCount);
			printf("reset frame counter                                     - done\r\n",FrameCount);
			printf("reset stop watch                                        - done\r\n");
			
			printf("frame counter is running...\r\n\r\n");

			printf("****************************************************************************************\r\n");

			FrameCount   = 0;
			Hardware::ResetStopWatch();
			
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 18 L (shift + L)
		//--------------------------------------------
		case 58 :
		{
			printf("****************************************************************************************\r\n");
			printf("Hidden function 18 - Stop Frame Counter - (shift + L)\r\n\r\n");	

			uint32_t timer = Hardware::ReadStopWatch();
			float    fvalue = timer / 60; 
			
			printf("frame count       = %d\r\n",FrameCount);
			printf("elapsed time      = ");
			floatprintf(fvalue);
			printf("s\r\n");
			
			fvalue = FrameCount / fvalue;
			
			printf("frames per second = ");
			floatprintf(fvalue);
			printf("f/s\r\n");

			
			printf("\r\n****************************************************************************************\r\n");
		
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 19 Ö
		//--------------------------------------------
		case 59 :
		{
			printf("****************************************************************************************\r\n");
			printf("Test function 19 - Timebases - (shift + Ö)\r\n\r\n");	
			
			
			// set the timebase
			// note: delayed by upper layer, won't get changed during capture
			// Nios hardware behaviour: sample rate is halved for hardware value 1...4 in each step,
			// from then on the divider is incremented by 8 for each step
			// subsampling = 1,2,4,8,16 for 1GSa,500MSa,250MSa,125Msa,62.5MSa (exponential range)
			// subsampling = 32, 40, 48, ... for 1GSa/subsampling (linear area)
                        Hardware::CaptureSetTimebase(2);
			
						
			
			printf("****************************************************************************************\r\n");
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 20 Y
		//--------------------------------------------
		case 60 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 20 (Y) - test switch 2 on/off - \r\n");
			
			//toggle test switch
			if(test_sw2){ test_sw2 = 0; printf("Test switch 2 is off\r\n"); }
			else { test_sw2 = 1; printf("Test switch 2 is on\r\n"); }

			printf("****************************************************************************************\r\n");
			
			//Display::ColorDemo5();
			break;
		}	
		
		//--------------------------------------------
		// Test Funktion 21 X
		//--------------------------------------------
		case 61 :
		{
			printf("****************************************************************************************\r\n");
			printf("Test function 21 (X) - test switch 3 on/off - \r\n");
			
			//toggle test switch
			if(test_sw3){ test_sw3 = 0; printf("Test switch 3 is off\r\n"); }
			else { test_sw3 = 1; printf("Test switch 3 is on\r\n"); }

			printf("****************************************************************************************\r\n");
			
			//Display::ColorDemo6();
			break;	
		}	

		//--------------------------------------------
		// Test Funktion 22 C
		//--------------------------------------------
		case 62 :
		{		
			//test_values = 1;

			Display::ColorDemo2();
			//CommIF::SCREENSHOT();
			//while (1 != 0);
			break;
		}	

		//--------------------------------------------
		// Test Funktion 23 V
		//--------------------------------------------
		case 63 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Test function 23 (Shift + V) - switch FFT status variant - \r\n");

			if (FFT_Layout){ FFT_Layout = false; printf("Status layout with yellow background\r\n");}
			else { FFT_Layout = true; printf("Status layout black design\r\n"); }
			printf("****************************************************************************************\r\n");
				
			Display::RefreshScreen();	
            		ConfigChanged = true;		

			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 24 B
		//--------------------------------------------
		case 64 :
		{		
			if (Command_Mode) Command_Mode = false;
			else Command_Mode = true;
		
			if (Debug_Mode)
			{
				if (Command_Mode) printf("Command Mode enabled\n");
				else printf("Command Mode disabled\n");
			}
		
			ConfigChanged = true;
			break;
		} 

		//--------------------------------------------	
		// Test Funktion 25 N
		//--------------------------------------------
		case 65 :
		{	
			printf("****************************************************************************************\r\n");
			printf("Hidden function 25 - Write Trigo Tables - (shift + N)\r\n\r\n");	

			printf("This can take a view minutes, please wait. Don't switch off the DSO!\r\n\r\n");
			//printf("Writing trigonometric tables to flash...");
						
			AMDFlash::WriteTrigoTables();
			Signal::FFT_buildTrigoTables();		// prepare FFT-mode
			
			//printf("Writing trigonometric tables to flash              - done");

			printf("Reset or restart the DSO now!\r\n\r\n");
			
			printf("\r\n****************************************************************************************\r\n");
			
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 26 M
		//--------------------------------------------
		case 66 :
		{	
	
			printf("****************************************************************************************\r\n");
			printf("Test function 26 - Timebases - (shift + M)\r\n\r\n");	
			
			
			// set the timebase
			// note: delayed by upper layer, won't get changed during capture
			// Nios hardware behaviour: sample rate is halved for hardware value 1...4 in each step,
			// from then on the divider is incremented by 8 for each step
			// subsampling = 1,2,4,8,16 for 1GSa,500MSa,250MSa,125Msa,62.5MSa (exponential range)
			// subsampling = 32, 40, 48, ... for 1GSa/subsampling (linear area)
			
			printf("\r\n1GSa");
			Hardware::CaptureSetTimebase(1); 
			printf("\r\n500MSa");
			Hardware::CaptureSetTimebase(2);
			printf("\r\n250MSa");
                        Hardware::CaptureSetTimebase(4);
			printf("\r\n125MSa");
			Hardware::CaptureSetTimebase(8);	
			printf("\r\n62,5MSa");
			Hardware::CaptureSetTimebase(16);
			printf("\r\n31,25GSa");
			Hardware::CaptureSetTimebase(32);
			printf("\r\n25GSa");
			Hardware::CaptureSetTimebase(40);
			printf("\r\n20.8GSa");
			Hardware::CaptureSetTimebase(48);
			
			printf("****************************************************************************************\r\n");
			break;
 
		}
		
		//--------------------------------------------
		// Test Funktion 27 ;
		//--------------------------------------------
		case 67 :
		{	
			for (uint32_t ix = 0; ix < 3; ix++)
			{
				printf("QMT %2i = %2i QMC = %2i QMCC = %2i QMSC = %2i QMEI = %2i QMEII = %2i\n", ix, QM_Type[ix], QM_Channel[ix], QM_Changed[ix], QM_Second_Channel[ix], QM_CHI_Edge[ix], QM_CHII_Edge[ix]);
			}
  	
			break;
		}		
		
		//--------------------------------------------
		// Test Funktion 28 :
		//--------------------------------------------
		case 68 :
		{	
		
			for (uint32_t ix = 0; ix < 32; ix++)
			{
				printf("M %2i =", ix);
		
				for (uint32_t ix2 = 0; ix2 < 6; ix2++)
				{
					printf("  I %i : %3i", ix2, MenuStatus[ix][ix2]);
		
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 69 < , >
		//--------------------------------------------
		case 69 :
		{	
			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("*                      Variables and Registers                              *\r\n");
			printf("*****************************************************************************\r\n");
			printf("* tc_hw_version           : %8x  * Flash ID                 :  %4x    *\r\n", tc_hw_version, AMDFlash::GetDeviceID());	
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Channel[eCh1].active    : %5d     * Channel[eCh2].active     : %5d    *\r\n", Channel[eCh1].active, Channel[eCh2].active);
			printf("* Channel[eCh3].active    : %5d     * Channel[eCh4].active     : %5d    *\r\n", Channel[eCh3].active, Channel[eCh4].active);
			printf("* ChannelStatusOld[eCh1]  : %5d     * ChannelStatusOld[eCh2]   : %5d    *\r\n", ChannelStatusOld[eCh1], ChannelStatusOld[eCh2]);
			printf("* ChannelStatusOld[eCh3]  : %5d     * ChannelStatusOld[eCh4]   : %5d    *\r\n", ChannelStatusOld[eCh3], ChannelStatusOld[eCh4]);
			printf("* Gain Index              : %5d     * Debug Mode               : %5d    *\r\n", GainIdx, Debug_Mode);
			printf("* Channels_Active         : %5d     * ADC Debug Mode           : %5d    *\r\n", Channels_Active, ADC_Debug_Mode);
			printf("* Active_Menu             : %5d     * New_Menu                 : %5d    *\r\n", Active_Menu, New_Menu);
			printf("* Zoom Factor (table)     : "); floatprintf(ZoomFactorTable[MainTimebase]);
			printf("     * Zoom factor delayed      : "); floatprintf(ZoomFactorDel);printf("    *\r\n");
			printf("* SingleShot              : %5d     * Run                      : %5d    *\r\n", SingleShot, Run);
			printf("* ADC_DataAvailable       : %5d     *                          :          *\r\n", ADC_DataAvailable);
			printf("* KeyboardChanged        : %5d     * ZoomFactor               : ", KeyboardChanged); floatprintf(ZoomFactor); printf("    *\r\n");
			printf("* S1Ptr                   : %8x  * S2Ptr                    : %8x *\r\n", S1Ptr, S2Ptr);
			printf("* S3Ptr                   : %8x  * S4Ptr                    : %8x *\r\n", S3Ptr, S4Ptr);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("*              FPGA 1                 *              FPGA 2                 *\r\n");
			printf("* _regADC[F1].ctrl        :  %4x     * _regADC[F2].ctrl         :  %4x    *\r\n", Hardware::_regADC[eFPGA1].ctrl, Hardware::_regADC[eFPGA2].ctrl);
			printf("* _regADC[F1].adc_ctrl    :  %4x     * _regADC[F2].adc_ctrl     :  %4x    *\r\n", Hardware::_regADC[eFPGA1].adc_ctrl, Hardware::_regADC[eFPGA2].adc_ctrl);
			printf("* _regADC[F1].channel_Adr :  %4x     * _regADC[F2].channel_Adr  :  %4x    *\r\n", Hardware::_regADC[eFPGA1].channel_Adr, Hardware::_regADC[eFPGA2].channel_Adr);
			printf("* _regADC[F1].trg_val[0]  :  %2x       * _regADC[F2].trg_val[0]   :  %2x      *\r\n", Hardware::_regADC[eFPGA1].trg_val[0], Hardware::_regADC[eFPGA2].trg_val[0]);
			printf("* _regADC[F1].trg_val[1]  :  %2x       * _regADC[F2].trg_val[1]   :  %2x      *\r\n", Hardware::_regADC[eFPGA1].trg_val[1], Hardware::_regADC[eFPGA2].trg_val[1]);
			printf("* _regADC[F1].trig_width  :  %4x     * _regADC[F2].trig_width   :  %4x    *\r\n", Hardware::_regADC[eFPGA1].trig_width, Hardware::_regADC[eFPGA2].trig_width);
			printf("* _regADC[F1].trig_range  :  %4x     * _regADC[F2].trig_range   :  %4x    *\r\n", Hardware::_regADC[eFPGA1].trig_range, Hardware::_regADC[eFPGA2].trig_range);
			printf("* _regADC[F1].adc_change  : %8x  * _regADC[F2].adc_change   : %8x *\r\n", Hardware::_regADC[eFPGA1].adc_change, Hardware::_regADC[eFPGA2].adc_change);
			printf("* _regADC[F1].timebase    : %8x  * _regADC[F2].timebase     : %8x *\r\n", Hardware::_regADC[eFPGA1].timebase, Hardware::_regADC[eFPGA2].timebase);
			printf("* _regADC[].trig_holdoff  : %8x  * _regADC[].pre            :  %4x    *\r\n", Hardware::_regADC[eFPGA1].trig_holdoff, Hardware::_regADC[eFPGA1].pre);
			printf("* _regADC[F1].grid_color  :  %2x       *                                     *\r\n", Hardware::_regADC[eFPGA1].grid_color);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* SwitchesCH1             :  %4x     * SwitchesCH3              :  %4x    *\r\n", SwitchesCH1, SwitchesCH3);
			printf("* SwitchesCH2             :  %4x     * SwitchesCH4              :  %4x    *\r\n", SwitchesCH2, SwitchesCH4);
			//printf("* SwitchesTB              :  %4x     * _regExtTrgLvl            : %8x *\r\n", SwitchesTB, Hardware::_regExtTrgLvl);
			printf("* _regExtTrgSetup         : %8x  * _regExtTrgLvl            : %8x *\r\n", Hardware::_regExtTrgSetup, Hardware::_regExtTrgLvl);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* MainTimebase            : %5d     * TB Register Value        : %8x *\r\n", MainTimebase, RegTimebaseTable[MainTimebase]);
			printf("* DelayedTimebase         : %5d     * Frame Count              : %5d    *\r\n",DelayedTimebase, FrameCount );
			printf("* VirtualTimebase         : %5d     ",VirtualTimebase); printf("* Timebase_Ratio           : "); floatprintf(Timebase_Ratio);printf("    *\r\n");
			printf("* Cursor_Delayed_1        : %5d     *                                     *\r\n", Cursor_Delayed_1);
			printf("* Cursor_Delayed_2        : %5d     * Cursor_Delayed_Size      : %5d    *\r\n", Cursor_Delayed_2, Cursor_Delayed_Size);
			printf("* dmode_Window_Offset_Pos : %5d     *                                     *\r\n", dmode_Window_Offset_Pos);
			printf("* draw_start              : %5d     * draw_dm_ixstart          : %5d    *\r\n", draw_start, draw_dm_ixstart);
			printf("* draw_factor             : %5d     * draw_dm_ixfactor         : %5d    *\r\n", draw_factor, draw_dm_ixfactor);
			printf("* MemStartOffs            : %5d     * MemoryEnd                : %5d    *\r\n", MemStartOffs, MemoryEnd);
			printf("* MemWinStart             : %5d     * SignalMemSize            : %5d    *\r\n", MemWinStart, SignalMemSize);
			printf("* USTB EOSignal           : %5d     * USTB Index               : %5d    *\r\n", USTB_EOSignal, USTB_idx);
			printf("* Trig_Pos_Mem            : %5d     * Trig_Pos_Display         : %5d    *\r\n", Trig_Pos_Mem, Trig_Pos_Display);
			printf("* Trig_Pos_Mem_old        : %5d     * Trig_Pos_Display_old     : %5d    *\r\n", Trig_Pos_Mem_old, Trig_Pos_Display_old);
			printf("* TrigPosMax              : %5d     *                          : %5d    *\r\n", TrigPosMax, 0);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* _TriggerSource          : %5d     * Average                  : %5d    *\r\n", Hardware::_TriggerSource, ACQ_Average);
			printf("* TriggerWay              : %5d     *                                     *\r\n",TriggerWay);
			printf("* Trigger_Pos_CH1         : %5d     * Trigger_Pos_CH3          : %5d    *\r\n", Trigger_Pos_CH1, Trigger_Pos_CH3);
			printf("* Trigger_Pos_CH2         : %5d     * Trigger_Pos_CH4          : %5d    *\r\n", Trigger_Pos_CH2, Trigger_Pos_CH4);
			printf("* Trigger_Pos_CHE         : %5d     * PreTrigComp              : %5d    *\r\n", Trigger_Pos_CHE ,PreTrigComp);
			printf("* HoldOff_Value           : %5d     * HoldOff                  : %5d    *\r\n", HoldOff_Value, (unsigned int)(HoldOff.Read_Value() * 125000000));
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* Selected_Voltage_CH1    : %5d     * CH1_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH1, CH1_DAC_Offset);
			printf("* Selected_Voltage_CH2    : %5d     * CH2_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH2, CH2_DAC_Offset);
			printf("* Selected_Voltage_CH3    : %5d     * CH3_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH3, CH3_DAC_Offset);
			printf("* Selected_Voltage_CH4    : %5d     * CH4_DAC_Offset           : %5d    *\r\n", Selected_Voltage_CH4, CH4_DAC_Offset);
			printf("* CH1 DAC correction 1    : %5d     * CH3 DAC correction 1     : %5d    *\r\n", DAC_Correction[CalSet][0][0], DAC_Correction[CalSet][2][0]);
			printf("* CH1 DAC correction 2    : %5d     * CH3 DAC correction 2     : %5d    *\r\n", DAC_Correction[CalSet][0][1], DAC_Correction[CalSet][2][1]);
			printf("* CH1 DAC correction 3    : %5d     * CH3 DAC correction 3     : %5d    *\r\n", DAC_Correction[CalSet][0][2], DAC_Correction[CalSet][2][2]);
			printf("* CH2 DAC correction 1    : %5d     * CH4 DAC correction 1     : %5d    *\r\n", DAC_Correction[CalSet][1][0], DAC_Correction[CalSet][3][0]);
			printf("* CH2 DAC correction 2    : %5d     * CH4 DAC correction 2     : %5d    *\r\n", DAC_Correction[CalSet][1][1], DAC_Correction[CalSet][3][1]);
			printf("* CH2 DAC correction 3    : %5d     * CH4 DAC correction 3     : %5d    *\r\n", DAC_Correction[CalSet][1][2], DAC_Correction[CalSet][3][2]);
			printf("* CH1 ADC 1 Offset        : %5d     * CH3 ADC 1 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[0][0], Hardware::_ADC_Offset[2][0]);
			printf("* CH1 ADC 2 Offset        : %5d     * CH3 ADC 2 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[0][1], Hardware::_ADC_Offset[2][1]);
			printf("* CH1 ADC 3 Offset        : %5d     * CH3 ADC 3 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[0][2], Hardware::_ADC_Offset[2][2]);
			printf("* CH1 ADC 4 Offset        : %5d     * CH3 ADC 4 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[0][3], Hardware::_ADC_Offset[2][3]);
			printf("* CH2 ADC 1 Offset        : %5d     * CH4 ADC 1 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[1][0], Hardware::_ADC_Offset[3][0]);
			printf("* CH2 ADC 2 Offset        : %5d     * CH4 ADC 2 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[1][1], Hardware::_ADC_Offset[3][1]);
			printf("* CH2 ADC 3 Offset        : %5d     * CH4 ADC 3 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[1][2], Hardware::_ADC_Offset[3][2]);
			printf("* CH2 ADC 4 Offset        : %5d     * CH4 ADC 4 Offset         : %5d    *\r\n", Hardware::_ADC_Offset[1][3], Hardware::_ADC_Offset[3][3]);
			printf("*                         : %5d     * ADC ReadoutLength        : %5d    *\r\n", 0, ReadoutLength);
			printf("* ------------------------------------*-------------------------------------*\r\n");
			printf("* ADC_VirtualZero_CH1     : %5d     * ADC_VirtualZero_CH3      : %5d    *\r\n", Hardware::_ADC_VirtualZero[0], Hardware::_ADC_VirtualZero[2]);
			printf("* ADC_VirtualZero_CH2     : %5d     * ADC_VirtualZero_CH4      : %5d    *\r\n", Hardware::_ADC_VirtualZero[1], Hardware::_ADC_VirtualZero[3]);
			printf("* Virtual_ZeroLevelCH1    : %5d     * Virtual_ZeroLevelCH3     : %5d    *\r\n", Virtual_ZeroLevelCH1, Virtual_ZeroLevelCH3);
			printf("* Virtual_ZeroLevelCH2    : %5d     * Virtual_ZeroLevelCH4     : %5d    *\r\n", Virtual_ZeroLevelCH2, Virtual_ZeroLevelCH4);
			printf("* ZeroLevelCH1            : %5d     * ZeroLevelCH3             : %5d    *\r\n", ZeroLevelCH1, ZeroLevelCH3);
			printf("* ZeroLevelCH2            : %5d     * ZeroLevelCH4             : %5d    *\r\n", ZeroLevelCH2, ZeroLevelCH4);
			printf("* CursVertPos_TY_1        : %5d     * CursVertPos_TY_2         : %5d    *\r\n", Cursor_Vertical_Position_TY_1, Cursor_Vertical_Position_TY_2);
			printf("* CursVertPos_XY_1        : %5d     * CursVertPos_XY_2         : %5d    *\r\n", Cursor_Vertical_Position_XY_1, Cursor_Vertical_Position_XY_2);
			printf("* CursVertPos_FFT_1       : %5d     * CursVertPos_FFT_2        : %5d    *\r\n", Cursor_Vertical_Position_FFT_1, Cursor_Vertical_Position_FFT_2);
			printf("* CursHorPos Real1        : %5d     * CursHorPos Real2         : %5d    *\r\n", Cursor_Horizontal_Position_Real1, Cursor_Horizontal_Position_Real2);
			printf("*****************************************************************************\r\n");
			printf("\n");

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 70 .
		//--------------------------------------------
		case 70 :
		{		

			printf("\r\n");
			printf("*****************************************************************************\r\n");
			printf("* Interrupts                          *                                     *\r\n");
			printf("*****************************************************************************\r\n");		
			printf("* ADC Interrupt Edge      : %5d     * Keyboard IRQ Edge        : %5d    *\r\n", acq_ready->np_pioedgecapture, key_int->np_pioedgecapture);
			printf("* ADC Interrupt           : %5d     * Keyboard IRQ             : %5d    *\r\n", acq_ready->np_piodata, acq_ready->np_piodata);
		//            printf("*                                    *                                    *\n");
			printf("*****************************************************************************\r\n");
			printf("\r\n");
		
			break;
		}

		//--------------------------------------------
		// Test Funktion 71 -
		//--------------------------------------------
		case 71 :
		{	/*	
			xm = 100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 100 x 20 = %d\n", res_xm);
	
			xm = -100;
			ym = 20;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -100 x 20 = %d\n", res_xm);		
	
			xm = 54;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult 74 x 55 = %d\n", res_xm);
			
			xm = -74;
			ym = 55;
			res_xm = nm_mult(xm, ym);
	
			printf("mult -54 x 55 = %d\n", res_xm);		
			*/
			break;
		}

		//--------------------------------------------
		// Test Funktion 31 !
		//--------------------------------------------
		case 80 :
		{		

			
			
			
			
			
			
			
			break;
		}
		
		//--------------------------------------------
		// Test Funktion 31 "
		//--------------------------------------------
		case 81 :
		{		
			Hardware::_regADC[eFPGA1].pre--;
			Hardware::_regADC[eFPGA2].pre--;
		
			Hardware::CaptureSetupADC();	
			
			printf("Hardware::_regADC[eFPGA1].pre : %i\n", Hardware::_regADC[eFPGA1].pre);

			break;
		}

		//--------------------------------------------
		// Test Funktion 32 §
		//--------------------------------------------
		case 82 :
		{		
			Hardware::_regADC[eFPGA1].pre++;
			Hardware::_regADC[eFPGA2].pre++;
		
			Hardware::CaptureSetupADC();	
			
			printf("Hardware::_regADC[eFPGA1].pre : %i\n", Hardware::_regADC[eFPGA1].pre);

			break;
		}

		//--------------------------------------------
		// Test Funktion 33 $
		//--------------------------------------------
		case 83 :
		{	

			break;
		}
		
		//--------------------------------------------
		// Test Funktion 34 %
		//--------------------------------------------
		case 84 :
		{		

			break;
		}

		//--------------------------------------------
		// Test Funktion 35 &
		//--------------------------------------------
		case 85 :
		{		
			if (XY_Mode) XY_Mode = 0;
			else XY_Mode = 1;
				
			printf("Display Mode %d\n", XY_Mode);

			break;
		}

		//--------------------------------------------
		// Test Funktion 36 /
		//--------------------------------------------
		case 86 : //free
		{		
		
		
			//printf("Test Pre Reg manipulation\n");

			break;
		}

		//--------------------------------------------
		// Test Funktion 37 (
		//--------------------------------------------
		case 87 :
		{	
			printf("MenuPopupStatus\n");
			for (uint32_t ix2 = 0; ix2 < 30; ix2++)
			{
				printf("MPS[%2d] : ", ix2);
				
				for (uint32_t ix = 0; ix < 21; ix++)
				{
					printf("%2d ", MenuPopupStatus[ix2][ix]);
				}
				printf("\n");
			}

			break;
		}

		//--------------------------------------------
		// Test Funktion 38 )
		//--------------------------------------------
		case 88 :
		{	
			uint32_t ix;
			ix = (int) (Pulse11.Read_Value() * 100000000);			
			printf("PV 11 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse11_Value, Pulse11_Steps, Pulse11_Expo);
			ix = (int) (Pulse12.Read_Value() * 100000000);			
			printf("PV 12 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse12_Value, Pulse12_Steps, Pulse12_Expo);
		
			ix = (int) (Pulse21.Read_Value() * 100000000);			
			printf("PV 21 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse21_Value, Pulse21_Steps, Pulse21_Expo);
			ix = (int) (Pulse22.Read_Value() * 100000000);			
			printf("PV 22 RV : % d Va : %d St : %d Ex : %d\n", ix, Pulse22_Value, Pulse22_Steps, Pulse22_Expo);

			break;
		}

		//--------------------------------------------
		// Test Funktion 39 =
		//--------------------------------------------
		case 89 :
		{
			printf("****************************************************************************************\r\n");
			printf("Test function 39 (=) - Test MSTEP multiplication - \r\n");
			
			unsigned char mul1 = 11;
			unsigned char mul2 = 7;
			int res = 0;
			
						printf("\n\r");
			printf("mul1 = %d  mul2 = %d\n\r", mul1, mul2);
			printf("res = umul16(mul1, mul2)\n\r");
			
			/* calculate */
			res = umul16(mul1, mul2);
			/* calc end */
			
			printf("mul1 = %d  mul2 = %d  res = %d\n\r", mul1, mul2, res);

			printf("res = mul1 * mul2\n\r");
			
			/* calculate */
			res = mul1 * mul2;
			/* calc end */

			printf("mul1 = %d  mul2 = %d  res = %d\n\r", mul1, mul2, res);
			
			printf("*****************************************************************************\n");
			printf("\n");

			break;
		}  	
	
		//--------------------------------------------
		// Test Funktion 40 x
		//--------------------------------------------
		case 91 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 40 (x) - free - \r\n");
			
			

			printf("\r\n****************************************************************************************\r\n");
			
			
			break;
		}
		//--------------------------------------------
		// Test Funktion 41 z
		//--------------------------------------------
		case 92 :
		{		
			printf("****************************************************************************************\r\n");
			printf("Test function 41 (z) - free - \r\n");
			
		
			

			printf("\r\n****************************************************************************************\r\n");
			
			
			break;
		}





	}
	//if (Splash_drawed == false)
	UpdateMenuTextPlane = true;
}	

//######################################################################################################################################################
// BF insert
//Function button 1 pushed
void UserIF::F1_Btnhandler(void)					// Button Handler for function button
{ 
	short pos = 0;

#ifdef _Debug_		
       	printf("F1 Btn start\n");
#endif

	//BF del if(DrawMono==0){ MenuItemPushed[0] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer

//	if (ZeroPopupChanged > 0) Hardware::ResetTimer3();

	if ((Active_Menu == 1) && (!Channel[eCh1].active)) return;
	if ((Active_Menu == 2) && (!Channel[eCh2].active)) return;
	if ((Active_Menu == 3) && (!Channel[eCh3].active)) return;
	if ((Active_Menu == 4) && (!Channel[eCh4].active)) return;
	if ((Active_Menu == 26) && (!Channel[eChM].active)) return;	// BF del ???

	if ((Active_Menu == 16) && (!Cursor_Enabled)) return;
	if ((Active_Menu == 19) && (!QM_Enabled)) return;
	if ((Active_Menu == 20) && (!QM_Enabled)) return;
	if ((Active_Menu == 21) && (!QM_Enabled)) return;
	if ((Active_Menu == 22) && (!QM_Enabled)) return;

	MenuItemChanged[0] = MenuAktive;
	Menu_Changed = MenuAktive;

	switch(Active_Menu)
	{
		// Acquire -> Logic Analyser 
		case 0 :
		{	
			if (USTB_Mode != USTB_OFF) return;
			if (XY_Mode) return;
			if (Signal::_FFT_Mode != FFT_OFF) return;
			//if(!Run) return;

			pos = -1;
			MenuPopupStep(47, &MenuStatus[MENU_ACQUIRE][0], &pos, &pos, MENU_ACQUIRE, LOGA_OFF, 2);

			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;

			if (MenuBtnFocus[MENU_ACQUIRE] != 0)
			{
				MenuBtnFocus[MENU_ACQUIRE] = 0;
				Display::DrawMenuItem(MENU_ACQUIRE,0, 1);//, 0);					// change arrow to active
				Display::DrawMenuItem(MENU_ACQUIRE,1, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_ACQUIRE,2, 1);//, 0);					// change arrow to inactive
				//not used until now! Display::DrawMenuItem(MENU_ACQUIRE,3, 1, 0);					// change arrow to inactive
			}

			//Signal::LOGA_LogicProcessor();	-> called in UpdateMenu() for acivation delay
			Hardware::SetDelayTimer1(60, &Signal::LOGA_LogicProcessor);	// load logic processor to execution queue
			
			Display::OssSingle(eOssLogA, 1, 1);	// process on screen status

			break;	
		}				

		// Channel 1 -> Coupling
		case 1 :
		{

			if (!Channel[eCh1].active) return;
			
			//if (MenuPopupActive != 13)
			{
				MenuPopupStatus[13][0] = 2;				// GND off
				
				if (MenuStatus[MENU_CHANNEL1][0] == 8)
				{	
					MenuStatus[MENU_CHANNEL1][0] = 7;		// AC
					MenuPopupStatus[13][1] = 3;
					MenuPopupStatus[13][2] = 2;
				}
				else
				{
					MenuStatus[MENU_CHANNEL1][0] = 8;		// DC
					MenuPopupStatus[13][1] = 2;
					MenuPopupStatus[13][2] = 3;
				}
			
			}
			//pos = -1;
			//MenuPopupStep(13, &MenuStatus[MENU_CHANNEL1][0], &pos, &pos, 1, 6, 2);

			MenuBtnFocus[MENU_CHANNEL1] = 0;				// set focus to the coupling button			
			New_Menu = MENU_CHANNEL1;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;						// draw probe button arrowcycle grey

			Hardware::SetSwitches(eCh1, -1);
			Display::OssSingle( eOssCh1, 1, 1);	

			break;
		}

		// Channel 2 -> Coupling
		case 2 :
		{
			if (!Channel[eCh2].active) return;

			//if (MenuPopupActive != 14)
			{
				MenuPopupStatus[14][0] = 2;
				
				if (MenuStatus[MENU_CHANNEL2][0] == 8)			// GND off
				{	
					MenuStatus[MENU_CHANNEL2][0] = 7;		// AC
					MenuPopupStatus[14][1] = 3;
					MenuPopupStatus[14][2] = 2;
				}
				else
				{
					MenuStatus[MENU_CHANNEL2][0] = 8;		// DC
					MenuPopupStatus[14][1] = 2;
					MenuPopupStatus[14][2] = 3;
				}
			
			}
			//pos = -1;
			//MenuPopupStep(14, &MenuStatus[MENU_CHANNEL2][0], &pos, &pos, 1, 6, 2);

			MenuBtnFocus[MENU_CHANNEL2] = 0;				// set focus to the coupling button			
			New_Menu = MENU_CHANNEL2;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;						// draw probe button arrowcycle grey
			
			Hardware::SetSwitches(eCh2, -1);
			Display::OssSingle( eOssCh2, 1, 1);	

			break;
		}

		// Channel 3 -> Coupling
		case 3 :
		{
			if (!Channel[eCh3].active) return;
			
			//if (MenuPopupActive != 15)
			{
				MenuPopupStatus[15][0] = 2;
				
				if (MenuStatus[MENU_CHANNEL3][0] == 8)			// GND off
				{	
					MenuStatus[MENU_CHANNEL3][0] = 7;		// AC
					MenuPopupStatus[15][1] = 3;
					MenuPopupStatus[15][2] = 2;
				}
				else
				{
					MenuStatus[MENU_CHANNEL3][0] = 8;		// DC
					MenuPopupStatus[15][1] = 2;
					MenuPopupStatus[15][2] = 3;
				}
			
			}
			//pos = -1;
			//MenuPopupStep(15, &MenuStatus[MENU_CHANNEL3][0], &pos, &pos, 1, 6, 2);
			
			MenuBtnFocus[MENU_CHANNEL3] = 0;				// set focus to the coupling button			
			New_Menu = MENU_CHANNEL3;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;						// draw probe button arrowcycle grey

			Hardware::SetSwitches(eCh3, -1);
			Display::OssSingle( eOssCh3, 1, 1);	

			break;
		}

		// Channel 4 -> Coupling
		case 4 :
		{
			if (!Channel[eCh4].active) return;
			
			//if (MenuPopupActive != 16)
			{
				MenuPopupStatus[16][0] = 2;				// GND off
				
				if (MenuStatus[MENU_CHANNEL4][0] == 8)			
				{	
					MenuStatus[MENU_CHANNEL4][0] = 7;		// AC
					MenuPopupStatus[16][1] = 3;
					MenuPopupStatus[16][2] = 2;
				}
				else
				{
					MenuStatus[MENU_CHANNEL4][0] = 8;		// DC
					MenuPopupStatus[16][1] = 2;
					MenuPopupStatus[16][2] = 3;
				}
			
			}
			//pos = -1;
			//MenuPopupStep(16, &MenuStatus[MENU_CHANNEL4][0], &pos, &pos, 1, 6, 2);
			
			MenuBtnFocus[MENU_CHANNEL4] = 0;				// set focus to the coupling button			
			New_Menu = MENU_CHANNEL4;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;						// draw probe button arrowcycle grey

			Hardware::SetSwitches(eCh4, -1);
			Display::OssSingle(eOssCh4, 1, 1);	

			break;
		}						

		// Display -> Persistent
		case 5 :
		{
			pos = -1;
			MenuPopupStep(49, &MenuStatus[MENU_DISPLAY][0], &pos, &pos, MENU_DISPLAY, 360, 2);	//...step to next entry

			MenuStatus[MENU_DISPL_FFT][0] =	MenuStatus[MENU_DISPLAY][0];		// synchronize menus
			
			Display::SetPersistMode();
		
			New_Menu = 5;
			Menu_Changed = 1;
	
			break;
		}		

		// Utility - About Oscilloscope	
		case 6 :
		{		
			Hardware::ClearPlanes();
			Display::DRAW_SPLASH();

			Hardware::DoDisableRotInterrupt();

			for(;KeyboardChanged==0;);		// wait for any user input

			Hardware::DoEnableRotInterrupt();

			//Display::REMOVE_SPLASH();
			//Splash_drawed = false;
			KeyboardChanged = 0;
			UI_request = 0;
			
			Display::DrawInitialScreen();		// splash is active (utility menue) delete splash and redraw the screen	
			
			Display::DRAW_ALL_CURSOR();

			Menu_Changed = 1;			// draw button menu
			New_Menu = MENU_UTILITY;
			break;
		}		

		// Save recall -> Memory place
		case 8 : 
		{
			// do nothing
			Menu_Changed = 0;
			UI_request = 0;
			KeyboardChanged = 0;
			MenuBtnFocus[8] = 0;				// set focus to the first button
			break;
		}
		
		// Display Setup Submenu - Grid Color
		case 9 :
		{	
			pos = -1;
			MenuPopupStep(43, &MenuStatus[MENU_DISPL_SETUP][0], &pos, &pos, MENU_DISPL_SETUP, 300, 2);	//...step to next entry

			ColorPalette = MenuStatus[MENU_DISPL_SETUP][0] - 300;

			Hardware::_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::CaptureSetupADC();		
			nr_delay(50);

			New_Menu = MENU_DISPL_SETUP;
			Menu_Changed = 1;

			break;
		}					
		

		// Timebase -> Main
		case 10 :
		{			
			if (MenuStatus[MENU_TIMEBASE][0] == BTN_ON) return;	//Check if main mode is active

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			ConfigChanged = 1;					

			if (USTB_Mode != USTB_OFF) { Signal::USTB_clearBuffer(); }
		
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)		//Delayed mode active?
			{			
				MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;		//switch delayed mode off
				MenuItemChanged[1] = 1;				//redraw delayed button
			}
			else if (MenuStatus[MENU_TIMEBASE][2] == BTN_ON)	//XY-mode active?	
			{
				MenuStatus[MENU_TIMEBASE][2]  = BTN_OFF;	//switch XY-mode off
				MenuItemChanged[2] = 1;				//redraw XY-button

				XY_Mode = 0; 					//switch XY-mode off, needed in On_Zero

				//BF added for restoring zero levels
				ZeroLevelCH1 = ZeroLevelCH1_Main_bak;
				ZeroLevelCH2 = ZeroLevelCH2_Main_bak;
				ZeroLevelCH3 = ZeroLevelCH3_Main_bak;
				ZeroLevelCH4 = ZeroLevelCH4_Main_bak;
				
				Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_Main_bak;
				Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_Main_bak;
				Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_Main_bak;
				Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_Main_bak;

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelXYCH1 + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelXYCH2 + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelXYCH3 + Virtual_ZeroLevelCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelXYCH4 + Virtual_ZeroLevelCH4;	//keep triggerlevel

				RotarySteps = 0; UserIF::ON_Zero_Channel_1();
				RotarySteps = 0; UserIF::ON_Zero_Channel_2();

				if (NumberOfChannels == 4)
				{
					RotarySteps = 0; UserIF::ON_Zero_Channel_3();
					RotarySteps = 0; UserIF::ON_Zero_Channel_4();
				}

				if(Cursor_Enabled)//set cursor source channels active
				{
					if(MenuPopupStatus[1][0] == 1 && Channel[eCh1].active) MenuPopupStatus[1][0] = 2;
					if(MenuPopupStatus[1][1] == 1 && Channel[eCh2].active) MenuPopupStatus[1][1] = 2;
					if(MenuPopupStatus[1][2] == 1 && Channel[eCh3].active) MenuPopupStatus[1][3] = 2;
					if(MenuPopupStatus[1][3] == 1 && Channel[eCh4].active) MenuPopupStatus[1][4] = 2;
				} 

			}
			else if (MenuStatus[MENU_TIMEBASE][3] == BTN_ON)						//FFT-mode active?	
			{
				MenuStatus[MENU_TIMEBASE][4]  = BTN_OFF;						//activate browse button -> set to off
				MenuStatus[MENU_TIMEBASE][3]  = BTN_OFF;						//switch FFT-mode off
				MenuItemChanged[3] = 1;									//redraw FFT button
				MenuItemChanged[4] = 1;									//redraw browse button

				Signal::_FFT_Mode = FFT_OFF;

				// switch back to old settings
				Display::FFT_DrawStatus(1);								//clear UI-Planes	
				Hardware::FFT_Restore_Channels();							//restore channel setting
				Hardware::Zero_Levels_Restore();							//restore Zerolevels
			}

			MenuStatus[MENU_TIMEBASE][0] = BTN_ON;								//switch main mode on
		
			TimebaseChanged     = 1;
			TriggerWayChanged   = 1;
			TriggerModeChanged  = 1;
			TriggerLevelChanged = 1;

			Display::RecalcTimeParameters();
			//Hardware::SetReadoutLength(); // is done abve in RecalcTimeParameters()
			//Hardware::SetupTrigger();
			
			Display::RefreshScreen();
						
			New_Menu     = MENU_TIMEBASE;
			Menu_Changed = 1;
			Hardware::ClearPlanes();
			
			Display::DRAW_ALL_CURSOR();	
			
			break;		
		}

		// Trigger Mode / Coupling -> Mode 
		case 12 :
		{
			pos = -1;
			MenuPopupStep(9, &MenuStatus[MENU_TRIGGERMODE][0], &pos, &pos, 12, TRIG_FREE, 2);	

			New_Menu = 12;
			Menu_Changed = 1;
			TriggerLevelChanged = 1;
			TriggerModeChanged = 1;
	
			Hardware::SetupTrigger();
			
			Display::StatusUpdate();

			if (MenuStatus[MENU_TRIGGERSUB][3] == 126 && MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)	// direct manual trigger
			LED_ON[15] = 1;		//single button green
			else
			LED_ON[15] = 0;		//single button off

			Hardware::Send_LED();
			
			break;
		}			

		// Trigger sub menu -> LED 1
		case 13 :
		{		
			pos = -1;
			MenuPopupStep(17, &MenuStatus[MENU_TRIGGERSUB][0], &pos, &pos, MENU_TRIGGERSUB, 114, 2);

			if (Channel[eCh3].active) LED_ON[2] = 1; else  LED_ON[2] = 0;	// correct mapped LED

			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;

			break;	
		}	


		// Edge -> Rising/Falling
		case 14 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TRIGGEREDGE][0] == 2) MenuStatus[MENU_TRIGGEREDGE][0] = 3;
			else MenuStatus[MENU_TRIGGEREDGE][0] = 2;
			
			Hardware::SetupTrigger();
			
			New_Menu = 14;
			Menu_Changed = 1;

			//TriggerLevelChanged = 1;
			//TriggerWayChanged = 1;

			//Display::DRAWSTATUS(6, 1);		// update trigger level
			Display::DRAWSTATUS(8, 1);		// update trigger way
			//Display::StatusUpdate();

			break;	
		
		}		

		// Pulse Width -> Source
		case 15 :
		{		
			pos = -1;
			MenuPopupStep(7, &MenuStatus[MENU_PULSEWIDTH][0], &pos, &pos, 15, 137, 2);
			
			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
			
			Display::StatusUpdate();		
			
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue
			
			break;			
		}				
	
		// Cursor -> Source
		case 16 :
		{
			if (!Cursor_Enabled) return;
			if (Signal::_FFT_Mode != FFT_OFF) return;
			if (LA_active) return;

			pos = -1;
			MenuPopupStep(1, &MenuStatus[MENU_CURSOR][0], &pos, &pos, 16, 27, 2);
			Display::CALCCURSORDATA();
			
			MenuItemChanged[3] = 1;		// refresh Y1
			MenuItemChanged[4] = 1;		// refresh Y2

			CursorChanged = 3;
			New_Menu = 16;
			Menu_Changed = 1;

			break;
		}
		// Quick Print -> Save to BMP
		// BF -> new screenshot function from Niklas -> BF version
		case 17 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 17;
			Menu_Changed = 1;

			CommIF::SCREENSHOT('B');	//save to BMP
			//CommIF::SendShot();		

			break;					
		}


		// Hardware - ADC Register settings		BF #004
		case 18 :
		{	

			pos = -1;
			MenuPopupStep(37, &MenuStatus[MENU_HARDWARE][0], &pos, &pos, MENU_HARDWARE, 223, 2);

			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;

			switch(MenuStatus[MENU_HARDWARE][0])
			{
				case 223: //Factory setting	 		//BF standard factory setting causes resonance problems at high frequencies
				{ AMDFlash::ReadProtReg(); 			// W2014 => 	adc_change12_reg = 0x02020F00; 	adc_change34_reg = 0x0200000A;
										// 	    	channel_Adr_add12 = 0x5F0A;  	channel_Adr_add34 = 0x5F5F;
					//adc_change12_reg = 0x02020F00;
					//adc_change34_reg = 0x0200000A;
					break;
				}
				case 224: //High Freq 1		
				{ 
					AMDFlash::ReadProtReg();
					Hardware::_regADC[eFPGA1].adc_change = 0x01000000;		//BF  -> positive spikes but high bandwidth
					Hardware::_regADC[eFPGA2].adc_change = 0x01000000;		//BF  -> positive spikes but high bandwidth
					//channel_Adr_add12 = 0x5F0A;
					//channel_Adr_add34 = 0x5F0A;
					break;	
				}	
	
				case 225: //High Freq 2
				{
					AMDFlash::ReadProtReg();
					
					Hardware::_regADC[eFPGA1].adc_change = 0x00028000;
					Hardware::_regADC[eFPGA2].adc_change = 0x00028000;
					
					//Hardware::_regADC[eFPGA1].adc_change = 0x02020F00;
					//Hardware::_regADC[eFPGA2].adc_change = 0x02020F00;
					//Hardware::_regADC[eFPGA1].channel_Adr = 0x570A;
					//Hardware::_regADC[eFPGA2].channel_Adr = 0x570A;
					//adc_change12_reg = 0x02000000;		//BF Bit 24 for spike suppression
					//adc_change34_reg = 0x02000000;		//BF Bit 24 for spike suppression
					//adc_change12_reg = 0x20000;		//BF Falks setting -> negative spikes!!!
					//adc_change34_reg = 0x20000;		//BF Falks setting -> negative spikes!!!
					break;
			    	}	
				case 226: //Test 1
				{
					AMDFlash::ReadProtReg();
					Hardware::_regADC[eFPGA1].adc_change = 0x02020800;
					Hardware::_regADC[eFPGA2].adc_change = 0x0200000A;

					//adc_change12_reg = 0x01020800;		//BF same spikes as test 1
					//adc_change34_reg = 0x01020800;		//BF same spikes as test 1
					//channel_Adr_add12 = 0x5F0A;
					//channel_Adr_add34 = 0x5F0A;	
					break;
			   	}
				case 227: //Test 2
				{ 
					AMDFlash::ReadProtReg();
					Hardware::_regADC[eFPGA1].adc_change = 0x02020F00;
					Hardware::_regADC[eFPGA2].adc_change = 0x0200000A;

					//adc_change12_reg = 0x02020800;		//BF causes mini spikes on the rising edge 
					//adc_change34_reg = 0x02020800;		//BF causes mini spikes on the rising edge 
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}
				case 228: //Test 3
				{ 
					Hardware::_regADC[eFPGA1].adc_change = 0x02020F00;
					Hardware::_regADC[eFPGA2].adc_change = 0x0200000A;
					Hardware::_regADC[eFPGA1].channel_Adr = 0x5F0A;
					Hardware::_regADC[eFPGA2].channel_Adr = 0x5F5F;	
	
					//AMDFlash::ReadProtReg();
					//adc_change12_reg = 0x03020800;		//BF same spikes as test 1 and mini spikes as test 3
					//adc_change34_reg = 0x03020800;		//BF same spikes as test 1 and mini spikes as test 3
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}	
				case 229: //Test 4
				{ 
					Hardware::_regADC[eFPGA1].adc_change = 0x02020800;
					Hardware::_regADC[eFPGA2].adc_change = 0x0200000A;
					Hardware::_regADC[eFPGA1].channel_Adr = 0x5F0A;		
					Hardware::_regADC[eFPGA2].channel_Adr = 0x5F5F;	

					//adc_change12_reg = 0x00000000;		//BF negative spikes like Falks setting
					//adc_change34_reg = 0x00000000;		//BF negative spikes like Falks setting
					//channel_Adr_add12 = 0x570A;		//BF Flash Value of hardware rev.
					//channel_Adr_add34 = 0x5F5F;	
					break;
				}


			}
			//Hardware::Stop_Record();
			//nr_delay(50);

			Hardware::CaptureSetupADC();	
			nr_delay(50);

			//if (!SingleShot && Run && !AS_request && !RC_request)
			//{ Hardware::Start_Record(); } 
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	// save to calibration sector delayed
			
			break;
		}			

		
		// Quick Measurement -> Source
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;
		
			pos = -1;
			MenuPopupStep(3, &MenuStatus[MENU_QUICKMEASURE][0], &pos, &pos, MENU_QUICKMEASURE, 27, 2);
			
			QM_Source = MenuStatus[MENU_QUICKMEASURE][0];	// refresh backup value
			
			New_Menu = 19;
			Menu_Changed = 1;
			break;
		}	
		
		// Quick Measurement Delay Settings -> Source 1
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
			
			if (QM_Enabled == 0) return;
	
			pos = -1;
			MenuPopupStep(5, &MenuStatus[MENU_QMDELAY][0], &pos, &pos, 20, 27, 2);
			
			New_Menu = 20;
			Menu_Changed = 1;
			break;
		}	

		// Quick Measurement Phase Settings -> Source 1
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;
			pos = -1;
			MenuPopupStep(24, &MenuStatus[MENU_QMPHASE][0], &pos, &pos, MENU_QMPHASE, 27, 2);
			
			New_Menu = MENU_QMPHASE;
			Menu_Changed = 1;
			break;
		}	

		// Quick Measurement Thresholds -> Source
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) return;

			if (QM_Enabled == 0) return;
			
			pos = -1;
			MenuPopupStep(26, &MenuStatus[MENU_QMTHRESHOLDS][0], &pos, &pos, MENU_QMTHRESHOLDS, 27, 2);

			// update QM thresholds menu
			short QM_thr_ch = MenuStatus[MENU_QMTHRESHOLDS][0] - 27;
			QM_Threshold_lower.Write_Value(thres_low[QM_thr_ch]);	
			QM_Threshold_lower.RenderText();
			
			QM_Threshold_middle.Write_Value(thres_mdl[QM_thr_ch]);	
			QM_Threshold_middle.RenderText();
			
			QM_Threshold_upper.Write_Value(thres_up[QM_thr_ch]);	
			QM_Threshold_upper.RenderText();

			MenuStatus[MENU_QMTHRESHOLDS][1] = thres_type[QM_thr_ch];
			Display::MenuPopupInit(27, MENU_QMTHRESHOLDS, 49);

			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;

			New_Menu = MENU_QMTHRESHOLDS;
			Menu_Changed = 1;
			
			break;
		}	

		// AutoScale -> Undo
		case 23 :
		{
			if (Signal::_FFT_Mode != FFT_OFF) return;		// no autoscale in FFT-mode

			Hardware::Restore_From_Flash();

			break;
		}

		// Trigger Mode TV
		case 24 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			break;
		}

		// More Utilities - CH1 Delay			BF #001
		case 25 :
		{	

			pos = -1;
			MenuPopupStep(33, &MenuStatus[MENU_EXTUTILS][0], &pos, &pos, MENU_EXTUTILS, 203, 2);

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 0;

			if (MenuBtnFocus[MENU_EXTUTILS] != 0)	
			{
				MenuBtnFocus[MENU_EXTUTILS] = 0;
				Display::DrawMenuItem(MENU_EXTUTILS,0, 1);//, 0);					// change arrow to active
				Display::DrawMenuItem(MENU_EXTUTILS,1, 1);//, 0);					// change arrow to inactive
				if(NumberOfChannels == 4)
				{
					Display::DrawMenuItem(MENU_EXTUTILS,2, 1);//, 0);				// change arrow to inactive
					Display::DrawMenuItem(MENU_EXTUTILS,3, 1);//, 0);				// change arrow to inactive
				}

			}
			MenuItemChanged[0] = 1;
			Menu_Changed = 1;

			Hardware::_ChannelDelay[0] = MenuStatus[MENU_EXTUTILS][0] - 203;
			
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	// save to calibration sector delayed

			break;
		}					

		// Math Settings Scale
		case 26 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuBtnFocus[MENU_MATH] == 1)
			{
				MenuBtnFocus[MENU_MATH] = 0;
				MenuItemChanged[1] = 1;
				Menu_Changed = 1;
			}
			else
			{
				Menu_Changed = 0;
				MenuItemChanged[0] = 0;
			}

			break;
		}

		// FFT - Settings - source channel
		case 27 :
		{	
			pos = -1;
			MenuPopupStep(29, &MenuStatus[MENU_FFT][0], &pos, &pos, MENU_FFT, 137, 2);	//...step to next entry

			New_Menu = MENU_FFT;
			Menu_Changed = 1;

			if (MenuBtnFocus[MENU_FFT] != 0)
			{
				MenuBtnFocus[MENU_FFT] = 0;
				Display::DrawMenuItem(MENU_FFT,0, 1);					// change arrow to active
				Display::DrawMenuItem(MENU_FFT,1, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,2, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,3, 1);					// change arrow to inactive
			}
			
			Hardware::FFT_Set_Channel(0);							// set active channel without backup
			
			Display::FFT_DrawStatus(0);							// draw FFT values in status area

			break;
		}					

		// Display FFT -> Persistent
		case 28 :
		{
			pos = -1;
			MenuPopupStep(49, &MenuStatus[MENU_DISPL_FFT][0], &pos, &pos, MENU_DISPL_FFT, 360, 2);	//...step to next entry
			
			MenuStatus[MENU_DISPLAY][0] = MenuStatus[MENU_DISPL_FFT][0];		// synchronize menus
						
			Display::SetPersistMode();
		
			New_Menu = 28;
			Menu_Changed = 1;
	
			break;
		}		

		
		// not used
		case 29 :
		{
			break;
		}	

		// USTB Menu -> USTB-Mode
		case 30 :
		{
			if(USTB_Mode != USTB_OFF && Run)
			{
				Hardware::Stop_Timer2();
				Hardware::Stop_Record();
			}
			
			pos = -1;
			MenuPopupStep(40, &MenuStatus[MENU_USTB][0], &pos, &pos, MENU_USTB, 284, 2);

			// direction
			if (MenuStatus[MENU_USTB][0] == 285 || MenuStatus[MENU_USTB][0] == 287)
			USTB_Dir = USTB_REVERSE;
			else
			USTB_Dir = USTB_FORWARD;

			// correct buffer size + menu
			if (MenuStatus[MENU_USTB][0] < USTB_SHIFT) 					// -> roll mode
			{ 
				MenuPopupStatus[42][2] = 2; 						// reactivate 32KB menu item
				MenuStatus[MENU_USTB][1] = USTB_Disp;					// reactivate popup menu for window
			}
			else										// -> shift mode
			{
				if (MenuStatus[MENU_USTB][2] == USTB_32KB)				// buffer size must not exceed 16KB in shift mode
				{
					MenuStatus[MENU_USTB][2] = USTB_16KB;				// reduce to 16KB
					MenuPopupStatus[42][1] = 3;					// activate 16KB item
				}

				MenuPopupStatus[42][2] = 1;						// set 32KB menu item inactive
				MenuStatus[MENU_USTB][1] = INACTIVE;					// set popup menu for window inactive
			}


			if(USTB_Mode != USTB_OFF)							// check if USTB is just active
			{
				USTB_Mode = MenuStatus[MENU_USTB][0] - USTB_Dir;			// switch to new USTB mode

				Display::RecalcTimeParameters();					// set new parameters

				Signal::USTB_clearBuffer();
				if (Memory_Window_visible) Display::RefreshMemoryBrowser();		// if Memory Window visible redraw Memory Window
				if (Run)
				{
					Hardware::Reset_Timer2();
					Display::DRAWSTATUS(6, 1);
				}
			}

			New_Menu = MENU_USTB;
			Menu_Changed = 1;
//printf("\nUSTB_Mode: %d  USTB_Dir: %d  USTB_Disp: %d\r\n",USTB_Mode, USTB_Dir, USTB_Disp);

			break;	

		}		

		// Quick Print USB-export -> Save to color
		case 31 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
							
			New_Menu = 31;
			Menu_Changed = 1;

			CommIF::UC_SCREENSHOT();	//save to color on USB / SD-card
			break;					
		}


			
	}	

#ifdef _Debug_			
			if (Debug_Mode) printf("Function Button 1\n");		
#endif
}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 2 pushed
void UserIF::F2_Btnhandler(void)					// Button Handler for function button
{

	short pos = 0;

	//BF del if(DrawMono==0){ MenuItemPushed[1] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer

	if ((Active_Menu == 1) && (!Channel[eCh1].active)) return;
	if ((Active_Menu == 2) && (!Channel[eCh2].active)) return;
	if ((Active_Menu == 3) && (!Channel[eCh3].active)) return;
	if ((Active_Menu == 4) && (!Channel[eCh4].active)) return;
	//if ((Active_Menu == 26) && (Channel[eChM].active == false)) return;

	if ((Active_Menu == 16) && (!Cursor_Enabled)) return;
	if ((Active_Menu == 19) && (!QM_Enabled)) return;
	if ((Active_Menu == 20) && (!QM_Enabled)) return;
	if ((Active_Menu == 21) && (!QM_Enabled)) return;
	if ((Active_Menu == 22) && (!QM_Enabled)) return;

	MenuItemChanged[1] = MenuAktive;
	Menu_Changed = MenuAktive;

	switch(Active_Menu)
	{
		// Acquire -> Averaging
		case 0 :
		{
			if (USTB_Mode != USTB_OFF) return;
			if(!Run) return;

			pos = -1;
			MenuPopupStep(21, &MenuStatus[MENU_ACQUIRE][1], &pos, &pos, MENU_ACQUIRE, AVRG_OFF, 2);

			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;

			if (MenuBtnFocus[MENU_ACQUIRE] != 1)
			{
				MenuBtnFocus[MENU_ACQUIRE] = 1;
				Display::DrawMenuItem(MENU_ACQUIRE,0, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_ACQUIRE,1, 1);//, 0);					// change arrow to active
				Display::DrawMenuItem(MENU_ACQUIRE,2, 1);//, 0);					// change arrow to inactive
				//not used until now! Display::DrawMenuItem(MENU_ACQUIRE,3, 1, 0);					// change arrow to inactive
			}

			if (MenuStatus[MENU_ACQUIRE][1] == AVRG_4)
			ACQ_Average = 1;
			else
			ACQ_Average = 0;

			Display::OssSingle(eOssAvrg, 1, 1);

			break;							
		}

		// Channel 1 -> BW Limit
		case 1 :
		{
			if (!Channel[eCh1].active) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL1][1] == 240) MenuStatus[MENU_CHANNEL1][1] = 241;
			else MenuStatus[MENU_CHANNEL1][1] = 240;					
			
			Hardware::SetSwitches(eCh1, -1);
			Display::OssSingle(eOssCh1, 1, 1);	

			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 2 -> BW Limit
		case 2 :
		{
			if (!Channel[eCh2].active) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL2][1] == 240) MenuStatus[MENU_CHANNEL2][1] = 241;
			else MenuStatus[MENU_CHANNEL2][1] = 240;
			
			Hardware::SetSwitches(eCh2, -1);
			Display::OssSingle(eOssCh2, 1, 1);	

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 3 -> BW Limit
		case 3 :
		{
			if (!Channel[eCh3].active) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL3][1] == 240) MenuStatus[MENU_CHANNEL3][1] = 241;
			else MenuStatus[MENU_CHANNEL3][1] = 240;
			
			Hardware::SetSwitches(eCh3, -1);
			Display::OssSingle(eOssCh3, 1, 1);	

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}

		// Channel 4 -> BW Limit
		case 4 :
		{
			if (!Channel[eCh4].active) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL4][1] == BTN_OFF) MenuStatus[MENU_CHANNEL4][1] = BTN_ON;
			else MenuStatus[MENU_CHANNEL4][1] = BTN_OFF;
			
			Hardware::SetSwitches(eCh4, -1);
			Display::OssSingle(eOssCh4, 1, 1);	

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}		

		// Display -> Clear Display
		case 5 :
		{		
			//if ((Run == false) || (MenuStatus[MENU_DISPLAY][0] == BTN_ON))	// 360 = Persistent Off
			Hardware::ClearPlanes();
			
			if (USTB_Mode != USTB_OFF)
			{
				Signal::USTB_clearBuffer();
				if (Memory_Window_visible) Display::RefreshMemoryBrowser();		// if Memory Window visible redraw Memory Window
			}
			//New_Menu = 5;
			//Menu_Changed = 1;
			break;
		}
		
		// Utility -> Default Setup
		case 6 :
		{
			Hardware::Reset_To_Default();
			ConfigChanged = 2; 
			break;		
		}	
				
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Save
		case 8 :
		{	
			if (!MenuAktive) return;
							
			//Hardware::GetFullSignal();
			AMDFlash::SaveTrace();
			
			break;
		}
	
		// Display Setup Submenu - Grid Layout
		case 9 :
		{	
			pos = -1;
			MenuPopupStep(44, &MenuStatus[MENU_DISPL_SETUP][1], &pos, &pos, MENU_DISPL_SETUP, 248, 2);	//...step to next entry

			DottedGrid = MenuStatus[MENU_DISPL_SETUP][1] - 248;

			New_Menu = MENU_DISPL_SETUP;
			Menu_Changed = 1;

			Hardware::SetDelayTimer1(60, &Display::RefreshScreen);		// load screen refresh to execution queue -> delay 1s
			
			break;
		}					

	
		// Timebase -> Delayed Mode (function button 2)
		case 10 :
		{	
			if (USTB_Mode !=  USTB_OFF) return;				//no delayed mode for USTB

			ACQ_PeakDetect = OFF;						//switch off peak detect

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON) return;		//Check delayed mode is not active yet

			if (MainTimebase ==  0) return;					//BF #003 no delayed mode for timebase 2ns

			if (MenuStatus[MENU_TIMEBASE][0] == BTN_ON)
			{
				MenuStatus[MENU_TIMEBASE][0] = BTN_OFF;			//switch off main mode
				MenuItemChanged[0] = 1;					//redraw Main button
			}
			else if (MenuStatus[MENU_TIMEBASE][2] == BTN_ON)		//XY-mode active?
			{
				MenuStatus[MENU_TIMEBASE][2] = BTN_OFF;			//switch off XY-mode
				MenuItemChanged[2] = 1;					//redraw XY button
				XY_Mode 	             = 0;

				//BF added for restoring zero levels
				ZeroLevelCH1 = ZeroLevelCH1_Main_bak;
				ZeroLevelCH2 = ZeroLevelCH2_Main_bak;
				ZeroLevelCH3 = ZeroLevelCH3_Main_bak;
				ZeroLevelCH4 = ZeroLevelCH4_Main_bak;
				
				Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_Main_bak;
				Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_Main_bak;
				Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_Main_bak;
				Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_Main_bak;
				
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelXYCH1 + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelXYCH2 + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelXYCH3 + Virtual_ZeroLevelCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelXYCH4 + Virtual_ZeroLevelCH4;	//keep triggerlevel

				RotarySteps = 0; UserIF::ON_Zero_Channel_1();
				RotarySteps = 0; UserIF::ON_Zero_Channel_2();

				if (NumberOfChannels == 4)
				{
					RotarySteps = 0; UserIF::ON_Zero_Channel_3();
					RotarySteps = 0; UserIF::ON_Zero_Channel_4();
				}

				if(Cursor_Enabled)//set cursor source channels active
				{
					if(MenuPopupStatus[1][0] == 1 && Channel[eCh1].active) MenuPopupStatus[1][0] = 2;
					if(MenuPopupStatus[1][1] == 1 && Channel[eCh2].active) MenuPopupStatus[1][1] = 2;
					if(MenuPopupStatus[1][2] == 1 && Channel[eCh3].active) MenuPopupStatus[1][3] = 2;
					if(MenuPopupStatus[1][3] == 1 && Channel[eCh4].active) MenuPopupStatus[1][4] = 2;
				} 


			}
			else if (MenuStatus[MENU_TIMEBASE][3] == BTN_ON)						//FFT-mode active?	
			{
					MenuStatus[MENU_TIMEBASE][4]  = BTN_OFF;					//activate browse button -> set to off
					MenuStatus[MENU_TIMEBASE][3]  = BTN_OFF;					//switch FFT-mode off
					MenuItemChanged[3] = 1;								//redraw Main button
					MenuItemChanged[4] = 1;								//redraw browse button

					Signal::_FFT_Mode = FFT_OFF;

					// switch back to old settings
					Display::FFT_DrawStatus(1);							//clear UI-Planes	
					Hardware::FFT_Restore_Channels();						//restore channel setting
					Hardware::Zero_Levels_Restore();						//restore Zerolevels
			}

			MenuStatus[MENU_TIMEBASE][1] = BTN_ON;								// switch on delayed mode

			New_Menu     = MENU_TIMEBASE;
			Menu_Changed = 1;

			ConfigChanged = 1;
			
			DelayedTimebase  =  0;	//BF #003
	
			Display::RecalcTimeParameters();
			//Hardware::SetReadoutLength();		// is done above in RecalcTimeParameters()
			//Hardware::SetupADC();

			Display::RefreshScreen();
			Display::DRAW_ALL_CURSOR();
			Hardware::ClearPlanes();
				
			Display::DRAWSTATUS(0, 0);
				
			break;	
		}
	
		// Trigger Mode -> Coupling
		case 12 :
		{
			pos = -1;
			MenuPopupStep(10, &MenuStatus[MENU_TRIGGERMODE][1], &pos, &pos, 12, 95, 2);
			
			New_Menu = 12;
			Menu_Changed = 1;
			
			Hardware::SetupTrigger();	

			break;
		}

		// Trigger sub menu -> LED 2
		case 13 :
		{		
			pos = -1;
			MenuPopupStep(18, &MenuStatus[MENU_TRIGGERSUB][1], &pos, &pos, MENU_TRIGGERSUB, 119, 2);

			if (Channel[eCh4].active) LED_ON[3] = 1; else  LED_ON[3] = 0;	// correct mapped LED

			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;
			
			break;	
		}	



		// Edge -> source
		case 14 :
		{	
			//Hardware::Stop_Record();
	
			//process menu popup
			pos = -1;
			MenuPopupStep(28, &MenuStatus[MENU_TRIGGEREDGE][1], &pos, &pos, 28, 137, 2);
			
			New_Menu = Active_Menu;
			Menu_Changed = 1;

			//external trigger active?
			if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_EXT)
			{
				MenuStatus[MENU_TRIGGEREDGE][2] = 128;	//BF set External trigger menu active
				Display::MenuPopupInit(8, MENU_TRIGGEREDGE, 128);
				Display::ClearMenuItemTextAsm(2, 35040, 32);
				Display::DrawMenuItem(MENU_TRIGGEREDGE, 2, MenuAktive);//, 1);
			}
			else
			{
				if ( MenuStatus[MENU_TRIGGEREDGE][2] != INACTIVE )	//BF set External trigger menu inactive and Combi Trigger available again
				{ 
					MenuStatus[MENU_TRIGGEREDGE][2] = INACTIVE; 
					Display::ClearMenuItemTextAsm(2, 35040, 32);
					Display::DrawMenuItem(MENU_TRIGGEREDGE, 2, MenuAktive);//, 1);
				}
			}

			//TV trigger active?
			if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_TV)
			{
				MenuStatus[MENU_TRIGGEREDGE][3] = 131;	//BF set TV trigger menu active
				Display::MenuPopupInit(11, MENU_TRIGGEREDGE, 131);
				Display::ClearMenuItemTextAsm(3, 35040, 32);
				Display::DrawMenuItem(MENU_TRIGGEREDGE, 3, MenuAktive);//, 1);
			}
			else
			{
				if ( MenuStatus[MENU_TRIGGEREDGE][3] != INACTIVE )	//BF set TV trigger menu inactive and Combi Trigger available again
				{ 	
					MenuStatus[MENU_TRIGGEREDGE][3] = INACTIVE;
					Display::ClearMenuItemTextAsm(3, 35040, 32);
					Display::DrawMenuItem(MENU_TRIGGEREDGE, 3, MenuAktive);//, 1);
				}	
			}

			if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_ALT)	//Alternating Trigger
			{ Hardware::_TriggerSource = eTrigCh1; }		// -> preset trigger source

			Hardware::SetupTrigger();

			Display::DRAWSTATUS(8, 1);		// update trigger way status
			Display::DRAWSTATUS(6, 1);		// draw trigger level

			break;
		}
		
		// Pulse Width -> Pulse (positve/negative) -> not available yet
		case 15 :
		{
			break;
			/*
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_PULSEWIDTH][1] == 2) MenuStatus[MENU_PULSEWIDTH][1] = 3;
			else MenuStatus[MENU_PULSEWIDTH][1] = 2;

			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;

			Display::StatusUpdate();
			
			Hardware::SetupTrigger();
			
			break;	
			*/
		}
	
		// Cursor -> X1
		case 16 :
		{	
			if (Cursor_Enabled == 0) return;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
					
			if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
			else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
			else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
			else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
			else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
			
/*	
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			MenuItemChanged[5] = 1;	
*/
			Cursor_Vertical_Active = 1;
			Cursor_Horizontal_Active = 3;

			if(Signal::_FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();
						
			New_Menu = 16;
			Menu_Changed = 1;

			Display::DRAW_ALL_CURSOR();
			
			break;				
		}
		
		// Quick Print -> Save to PGM
		// BF -> new screenshot function from Niklas -> BF version
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			New_Menu = 17;
			Menu_Changed = 1;

			CommIF::SCREENSHOT('P');	// save to PGM

			break;					
		}	
			
		// Hardware - Pre Amp Gain		BF #004
		// set scaling factors depending on hardware
		case 18 :
		{	
			pos = -1;
			MenuPopupStep(38, &MenuStatus[MENU_HARDWARE][1], &pos, &pos, MENU_HARDWARE, 230, 2);

			GainIdx = MenuStatus[MENU_HARDWARE][1] - 230;	//set gain index to get the correct scaling

			Signal::BuildScaleLookupTable();

			if (MenuStatus[MENU_HARDWARE][1] == ADD_ON)
			{
				SwitchesCH1 = 0x0F3A;
				SwitchesCH2 = 0x003A;
				SwitchesCH3 = 0x003A;
				SwitchesCH4 = 0x003A;
			}
			else
			{
				SwitchesCH1 = 0x0F1A;
				SwitchesCH2 = 0x001A;
				SwitchesCH3 = 0x001A;
				SwitchesCH4 = 0x001A;
			}

			if (Channel[eCh1].active) Hardware::SetSwitches(eCh1, Selected_Voltage_CH1);
			if (Channel[eCh2].active) Hardware::SetSwitches(eCh2, Selected_Voltage_CH2);
			if (Channel[eCh3].active) Hardware::SetSwitches(eCh3, Selected_Voltage_CH3);
			if (Channel[eCh4].active) Hardware::SetSwitches(eCh4, Selected_Voltage_CH4);

			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;
			
			Hardware::SetDelayTimer1(120, &UserIF::DispatchGain);		// activate and save 
			
			break;
		}			
	
		// Quick Measurement -> Select
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;

			pos = -1;
			MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &pos, 19, 52, 2);
			
			// special menu settings for QM Delay/Phase
			if ((MenuStatus[MENU_QUICKMEASURE][1] == 53) || (MenuStatus[MENU_QUICKMEASURE][1] == 61))	// Delay or Phase is selected
			{
				if (MenuStatus[MENU_QUICKMEASURE][4] == DOWN_ARROW_INACTIVE)				// if submenu path inactive
				{	
					MenuStatus[MENU_QUICKMEASURE][4] = DOWN_ARROW;					// set submenu path active
					MenuStatus[MENU_QUICKMEASURE][0] = INACTIVE;
				}
						
			}
			else												// any other function is selected
			{
				if (MenuStatus[MENU_QUICKMEASURE][4] == DOWN_ARROW)					// if submenu path active
				{
					MenuStatus[MENU_QUICKMEASURE][4] = DOWN_ARROW_INACTIVE;				// set submenu path inactive
					MenuStatus[MENU_QUICKMEASURE][0] = QM_Source;					// restore main source popup menu
				}
			}

			New_Menu = MENU_QUICKMEASURE;
			Menu_Changed = 1;
			MenuAktive_old = 0;										// trigger button update
			break;
		}	
	
		// Quick Measurement Settings -> delay edge
		case 20 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_QMDELAY][1] == 2) MenuStatus[MENU_QMDELAY][1] = 3;
			else MenuStatus[MENU_QMDELAY][1] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}

		// Quick Measurement Settings -> phase edge
		case 21 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_QMPHASE][1] == 2) MenuStatus[MENU_QMPHASE][1] = 3;
			else MenuStatus[MENU_QMPHASE][1] = 2;
		
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}


		// Quick Measurement Thresholds -> type (percent / absolute)
		case 22 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) return;

			pos = -1;
			MenuPopupStep(27, &MenuStatus[MENU_QMTHRESHOLDS][1], &pos, &pos, MENU_QMTHRESHOLDS, 49, 2);

			short QM_thr_ch = MenuStatus[MENU_QMTHRESHOLDS][0] - 27;
			thres_type[QM_thr_ch] = MenuStatus[MENU_QMTHRESHOLDS][1]; 

			if (thres_type[QM_thr_ch] == 49)	// percent
			{
				QM_Threshold_lower.Init(10, 5, 93, 1, 0, 3, "", "", "%");
				QM_Threshold_middle.Init(50, 6, 94, 1, 0, 3, "", "", "%");
				QM_Threshold_upper.Init(90, 7, 95, 1, 0, 3, "", "", "%");

				QM_Threshold_lower.Write_Value((float)thres_low[QM_thr_ch]);	
				QM_Threshold_lower.RenderText();
				
				QM_Threshold_middle.Write_Value((float)thres_mdl[QM_thr_ch]);	
				QM_Threshold_middle.RenderText();
				
				QM_Threshold_upper.Write_Value((float)thres_up[QM_thr_ch]);	
				QM_Threshold_upper.RenderText();
			}
			else					// absolute
			{
				QM_Threshold_lower.Init(800, 50, 20000, 1, 2, 3, "", "", "mV");
				QM_Threshold_middle.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
				QM_Threshold_upper.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
			}


			MenuItemChanged[2] = 1;
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;

			New_Menu = MENU_QMTHRESHOLDS;
			Menu_Changed = 1;
			break;
		}


		// Autoscale -> Slow TB
		case 23 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
            		Hardware::AutoScale(1);
			
			New_Menu = 23;
			Menu_Changed = 1;
			
			break;
		}
	
	
		// Trigger Mode TV
		case 24 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_TRIGGERTV][1] == 2) MenuStatus[MENU_TRIGGERTV][1] = 3;
			else MenuStatus[MENU_TRIGGERTV][1] = 2;		
		
			New_Menu = 24;
			Menu_Changed = 1;

			break;	
		}	

		// More Utilities - CH2 Delay			BF #001
		case 25 :
		{	
			pos = -1;
			MenuPopupStep(34, &MenuStatus[MENU_EXTUTILS][1], &pos, &pos, MENU_EXTUTILS, 203, 2);

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 0;
			
			if (MenuBtnFocus[MENU_EXTUTILS] != 1)	
			{
				MenuBtnFocus[MENU_EXTUTILS] = 1;
				Display::DrawMenuItem(MENU_EXTUTILS,0, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,1, 1);//, 0);					// change arrow to active
				if(NumberOfChannels == 4)
				{
					Display::DrawMenuItem(MENU_EXTUTILS,2, 1);//, 0);				// change arrow to inactive
					Display::DrawMenuItem(MENU_EXTUTILS,3, 1);//, 0);				// change arrow to inactive
				}
			}
			MenuItemChanged[1] = 1;
			Menu_Changed = 1;

			Hardware::_ChannelDelay[1] = MenuStatus[MENU_EXTUTILS][1] - 203;
			
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	// save to calibration sector delayed

			break;
		}					


		// Math - offset
		case 26 :
		{			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuBtnFocus[MENU_MATH] == 0)
			{
				MenuBtnFocus[MENU_MATH] = 1;
				MenuItemChanged[0] = 1;
				//Menu_Changed = 1;
			}
			else
			{
				// reset offset
				if (MenuStatus[MENU_MATH][2] == BTN_ON) // function key 3 - multiply
				{
					Math_Mul_Offset = 0;
					Math_Offset_mul.Write_Value(0.00);
					Math_Offset_mul.RenderText();
				}
				else if (MenuStatus[MENU_MATH][3] == BTN_ON) // function key 4 - subtract
				{
					Math_Sub_Offset = 0;
					Math_Offset_sub.Write_Value(0.00);
					Math_Offset_sub.RenderText();
	             		}
				else if (MenuStatus[MENU_MATH][4] == BTN_ON) // add
				{
					Math_Add_Offset = 0;
					Math_Offset_add.Write_Value(0.00);
					Math_Offset_add.RenderText();	
				}

				Menu_Changed = 1;
				MenuItemChanged[1] = 1;	
			}

			break;
		}

		// FFT - Settings - Window
		case 27 :
		{
			pos = -1;
			MenuPopupStep(30, &MenuStatus[MENU_FFT][1], &pos, &pos, 27, 193, 2);
			New_Menu = MENU_FFT;
			Menu_Changed = 1; 	
			
			if (MenuBtnFocus[MENU_FFT] != 1)
			{
				MenuBtnFocus[MENU_FFT] = 1;
				Display::DrawMenuItem(MENU_FFT,0, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,1, 1);					// change arrow to active
				Display::DrawMenuItem(MENU_FFT,2, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,3, 1);					// change arrow to inactive
			}
			
			// set FFT-Window     	193 = Rect 	=> -1
			//			194 = von Hann	=> 0
			//			195 = Blackman	=> 1
			Signal::_FFT_Windex = MenuStatus[MENU_FFT][1] - 194;
			
			// create new window
			Signal::FFT_buildTrigoTables();

			Display::FFT_DrawStatus(0);

			break;
		}

		// Display FFT -> Clear Display
		case 28 :
		{		
			//if ((Run == false) || (MenuStatus[MENU_DISPL_FFT][0] != 360)) // 360 = Persistent Off
			Hardware::ClearPlanes(); 
			break;
		}



		
/* BF del not needed in new FFT 
		
		// FFT - Settings - Scale	
		case 28 :	// BF Changed case 27 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
		
			FFTToggle = 0;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;	

			New_Menu = 27;
			Menu_Changed = 1;	

			break;
		}				
*/
/* BF not used at this time
		// Math Settings Offset
		case 29 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			MathToggle = 1;
			
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;
			MenuItemChanged[1] = 1;
			
			break;
		}	
*/	

		// USTB Menu -> USTB display mode
		case 30 :
		{
			pos = -1;
			MenuPopupStep(41, &MenuStatus[MENU_USTB][1], &pos, &pos, MENU_USTB, USTB_PERM, 2);
	
			USTB_Disp = MenuStatus[MENU_USTB][1];

			if (Run && USTB_Mode != USTB_OFF) Display::DRAWSTATUS(6, 1);		// display mode in status bar

			New_Menu = MENU_USTB;
			Menu_Changed = 1;
//printf("\nUSTB_Mode: %d  USTB_Dir: %d  USTB_Disp: %d\r\n",USTB_Mode, USTB_Dir, USTB_Disp);

			break;	
		}		

		// Quick Print USB-export -> Save to B/W
		case 31 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			New_Menu = 31;
			Menu_Changed = 1;

			CommIF::UC_SCREENSHOT_BW();	// save to black and white on SD-card

			break;					
		}	

		
	}					

#ifdef _Debug_			
	if (Debug_Mode) printf("Function Button 2\n");		
#endif

}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 3 pushed
void UserIF::F3_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;

#ifdef _Debug_		
       	printf("F3 Btn start\n");
#endif	

	//BF del if(DrawMono==0){ MenuItemPushed[2] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer

	if ((Active_Menu == 1) && (!Channel[eCh1].active)) return;
	if ((Active_Menu == 2) && (!Channel[eCh2].active)) return;
	if ((Active_Menu == 3) && (!Channel[eCh3].active)) return;
	if ((Active_Menu == 4) && (!Channel[eCh4].active)) return;
	//if ((Active_Menu == 26) && (Channel[eChM].active == false)) return;

	if ((Active_Menu == 16) && (!Cursor_Enabled)) return;
	if ((Active_Menu == 19) && (!QM_Enabled)) return;
	if ((Active_Menu == 20) && (!QM_Enabled)) return;
	if ((Active_Menu == 21) && (!QM_Enabled)) return;
	if ((Active_Menu == 22) && (!QM_Enabled)) return;
	
	MenuItemChanged[2] = MenuAktive;
	Menu_Changed = MenuAktive;

	switch(Active_Menu)
	{	
		// Acquire -> Noise suppression (noise filter)
		case 0 :
		{
			if (USTB_Mode != USTB_OFF) return;
			pos = -1;
			MenuPopupStep(22, &MenuStatus[MENU_ACQUIRE][2], &pos, &pos, MENU_ACQUIRE, 311, 2);

			if (MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+1) || MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+2))
			{ FilterType = PRO; }
			else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+2) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+6))
			{ FilterType = IIR; }
			else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+5) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+9))
			{ FilterType = FIR; }

			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;

			if (MenuBtnFocus[MENU_ACQUIRE] != 2)
			{
				MenuBtnFocus[MENU_ACQUIRE] = 2;
				Display::DrawMenuItem(MENU_ACQUIRE,0, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_ACQUIRE,1, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_ACQUIRE,2, 1);//, 0);					// change arrow to active
				//not used until now Display::DrawMenuItem(MENU_ACQUIRE,3, 1, 0);					// change arrow to inactive
			}

			//if acquisision is stopped signal processing must be triggered to take effect
			if(!Run)ACQ_NewData = 1;

			Display::RecalcTimeParameters();
			Display::OssSingle(eOssFilt, 1, 1);
			
			break;							
		}


		// Channel 1 -> Invert
		case 1 :
		{
			if (!Channel[eCh1].active) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL1][2] == BTN_OFF) MenuStatus[MENU_CHANNEL1][2] = BTN_ON;
			else MenuStatus[MENU_CHANNEL1][2] = BTN_OFF;

			if (USTB_Mode != USTB_OFF)
			{ Signal::USTB_invertSignal(Hardware::_ADC_VirtualZero[0] ,S1Ptr); }
			else
			{
				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;
				
				Hardware::SetupTrigger();	
				Display::StatusUpdate();
			}
			
			New_Menu = 1;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 2 -> Invert
		case 2 :
		{
			if (Channel[eCh2].active == 0) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL2][2] == BTN_OFF) MenuStatus[MENU_CHANNEL2][2] = BTN_ON;
			else MenuStatus[MENU_CHANNEL2][2] = BTN_OFF;
			
			if (USTB_Mode != USTB_OFF)
			{ Signal::USTB_invertSignal(Hardware::_ADC_VirtualZero[1] ,S2Ptr); }
			else
			{
				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;
				
				Hardware::SetupTrigger();						
				Display::StatusUpdate();
			}

			New_Menu = 2;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 3 -> Invert
		case 3 :
		{
			if (!Channel[eCh3].active) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL3][2] == BTN_OFF) MenuStatus[MENU_CHANNEL3][2] = BTN_ON;
			else MenuStatus[MENU_CHANNEL3][2] = BTN_OFF;
			
			if (USTB_Mode != USTB_OFF)
			{ Signal::USTB_invertSignal(Hardware::_ADC_VirtualZero[2] ,S3Ptr); }
			else
			{
				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;
				
				Hardware::SetupTrigger();						
				Display::StatusUpdate();
			}

			New_Menu = 3;
			Menu_Changed = 1;
			
			break;
		}
	
		// Channel 4 -> Invert
		case 4 :
		{
			if (!Channel[eCh4].active) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (MenuStatus[MENU_CHANNEL4][2] == BTN_OFF) MenuStatus[MENU_CHANNEL4][2] = BTN_ON;
			else MenuStatus[MENU_CHANNEL4][2] = BTN_OFF;
			
			if (USTB_Mode != USTB_OFF)
			{ Signal::USTB_invertSignal(Hardware::_ADC_VirtualZero[3] ,S4Ptr); }
			else
			{
				TriggerLevelChanged = 1;
				TriggerWayChanged = 1;
				
				Hardware::SetupTrigger();						
				Display::StatusUpdate();
			}

			New_Menu = 4;
			Menu_Changed = 1;
			
			break;
		}	

		// Display -> grid intensity
		case 5 :
		{
			if (GridColorArrayPos < 3){ GridColorArrayPos++; }
			else GridColorArrayPos = 0;

			Hardware::_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::CaptureSetupADC();						// write color shadow register to hardware

			MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;
			MenuStatus[MENU_DISPL_FFT][2] = MenuStatus[MENU_DISPLAY][2];
							
			Display::Rect(240, 454, 60, 14, 0, Buffer_UI2Plane);
			Display::TextOut12x9(MenuData[MenuStatus[MENU_DISPLAY][2]], 218 + MenuDataDef[MenuStatus[MENU_DISPLAY][2]], 455, 1, Buffer_UI2Plane);
			//Menu_Changed = 1;

			break;


/* grid color	
			ColorPalette++;
			if (ColorPalette>9) ColorPalette = 0;
			
			GridColor_Val = GridColorArray[ColorPalette][GridColorArrayPos];
			Hardware::SetupADC();	
			nr_delay(5);
			break;
*/

			
		}
	
		
		// Utility -> Calibrate Offsets		-> BF added new menu function
		case 6 :
		{	
			UI_request = 0;
			
			Hardware::Calibrate_DAC_ZeroOffsets();
			break;
		}
					
		// Service
		case 7 :
		{		
			//
			break;
		}

		// Save / Recall  - > Recall Signal
		case 8 :
		{	
			if (!MenuAktive) return;
			
			AMDFlash::RecallTrace();	//BF #016
			break;
		}

		// Display Setup Submenu - Status / Menu Layout
		case 9 :
		{	
			pos = -1;
			MenuPopupStep(46, &MenuStatus[MENU_DISPL_SETUP][2], &pos, &pos, MENU_DISPL_SETUP, 330, 2);	//...step to next entry

			New_Menu = MENU_DISPL_SETUP;

			Hardware::SetDelayTimer1(60, &Display::DrawInitialScreen);	// load screen initialization to execution queue -> delay 1s
			
			break;
		}				
		// Timebase-> X-Y Mode (function button 3 pushed)
		case 10 :
		{	
			if (USTB_Mode != USTB_OFF) return;
			if (LA_active) return;	

			ACQ_PeakDetect = OFF;									//switch off peak detect
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_TIMEBASE][2] == BTN_OFF)						//Check if XY-mode is not active yet
			{
				//only if channel 1 + 2 or 3 + 4 or all are active, else switch on corresponding channel
				if (!(Channel[eCh1].active && Channel[eCh2].active) && !(Channel[eCh3].active && Channel[eCh4].active))
				{
					if (Channel[eCh1].active){ Channel[eCh2].active = 1; LED_ON[1] = 1; }
					else if (Channel[eCh2].active){ Channel[eCh1].active = 1; LED_ON[0] = 1; }
					else if (Channel[eCh3].active){ Channel[eCh4].active = 1; LED_ON[3] = 1; }
					else if (Channel[eCh4].active){ Channel[eCh3].active = 1; LED_ON[2] = 1; }
				}

				if (MenuStatus[MENU_TIMEBASE][0] == BTN_ON)
				{
					MenuStatus[MENU_TIMEBASE][0]  = BTN_OFF;					//switch off main mode
					MenuItemChanged[0] = 1;								//redraw main button
				}
				else if (MenuStatus[MENU_TIMEBASE][1]  == BTN_ON)
				{
					MenuStatus[MENU_TIMEBASE][1]  = BTN_OFF;					//switch off delayed mode
					MenuItemChanged[1] = 1;								//redraw delayed button
				}
				else if (MenuStatus[MENU_TIMEBASE][3] == BTN_ON)					//FFT-mode active?	
				{
					MenuStatus[MENU_TIMEBASE][4]  = BTN_OFF;				//activate browse button -> set to off
					MenuStatus[MENU_TIMEBASE][3]  = BTN_OFF;				//switch FFT-mode off
					MenuItemChanged[3] = 1;								//redraw FFT button
					MenuItemChanged[4] = 1;								//redraw browse button

					Signal::_FFT_Mode = FFT_OFF;

					// switch back to old settings
					Display::FFT_DrawStatus(1);						//clear UI-Planes	
					Hardware::FFT_Restore_Channels();					//restore channel setting
					Hardware::Zero_Levels_Restore();					//restore Zerolevels

					Display::RefreshScreen();
				}

				if (QM_Enabled)
				{
					QM_Enabled_Old           = QM_Enabled;
					QM_Enabled               = false;
					Quick_Measure_First_Draw = 0;
		
					Display::DrawQMData(0);		// remove QM data

					LED_ON[7] = 0;
						
					//New_Menu = 19;
					Menu_Changed = 1;
					//MenuAktive = 0;
						
					Display::CALCQMDATA();
				}

				if (Channel[eChM].active)						//Math function active?
				{
					LED_ON[4] = 0;
					Channel[eChM].active = 0;					//switch off math function
				}
	
				if (USTB_Mode != USTB_OFF)
				Signal::USTB_clearBuffer();

				Hardware::Send_LED();
		
				//BF added for restoring zero levels
				ZeroLevelCH1_Main_bak = ZeroLevelCH1;
				ZeroLevelCH2_Main_bak = ZeroLevelCH2;
				ZeroLevelCH3_Main_bak = ZeroLevelCH3;
				ZeroLevelCH4_Main_bak = ZeroLevelCH4;
				
				Virtual_ZeroLevelCH1_Main_bak = Virtual_ZeroLevelCH1;
				Virtual_ZeroLevelCH2_Main_bak = Virtual_ZeroLevelCH2;
				Virtual_ZeroLevelCH3_Main_bak = Virtual_ZeroLevelCH3;
				Virtual_ZeroLevelCH4_Main_bak = Virtual_ZeroLevelCH4;
	
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelCH1 + Virtual_ZeroLevelXYCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelCH2 + Virtual_ZeroLevelXYCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelCH3 + Virtual_ZeroLevelXYCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelCH4 + Virtual_ZeroLevelXYCH4;	//keep triggerlevel

				MenuStatus[MENU_TIMEBASE][2] = BTN_ON;					//Switch XY-mode on
				XY_Mode      = 1;

				New_Menu     = 10;
				Menu_Changed = 1;

				ConfigChanged = 1;

				//set cursor source channel popupmenu entries inactive
				MenuPopupStatus[1][1] = 1; MenuPopupStatus[1][3] = 1; 	//gray out channel 2+4

				if(!Channel[eCh1].active || !Channel[eCh2].active)
				{ MenuPopupStatus[1][0] = 1; }				//gray out channel 1

				if(!Channel[eCh3].active || !Channel[eCh4].active)
				{ MenuPopupStatus[1][2] = 1; }				//gray out channel 3
		
				RotarySteps = 0;
				if(Channel[eCh1].active && Channel[eCh2].active)
				{
					ON_Zero_Channel_1();
					ON_Zero_Channel_2();
				}
			

				if(Channel[eCh3].active && Channel[eCh4].active)
				{
					ON_Zero_Channel_3();
					ON_Zero_Channel_4();
				}

				//Hardware::SetupADC();
				
				Display::DRAWSTATUS(0, 0);
				Hardware::ClearPlanes();
			}

			Display::RecalcTimeParameters();
			
			Display::RefreshScreen();
			Display::DRAW_ALL_CURSOR();
			
			break;							
		}

	
		// Trigger Mode -> Trigger Autolevel
		case 12 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (LA_active){ MenuItemChanged[2] = 0;	Menu_Changed = 0; return; }
			Hardware::TRIG_AutoLevel();
			break;
		}

		// Trigger sub menu -> Map to LED3/4
		case 13 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_TRIGGERSUB][2] == BTN_OFF)
			{ MenuStatus[MENU_TRIGGERSUB][2] = BTN_ON; }
			else
			{
    				MenuStatus[MENU_TRIGGERSUB][2] = BTN_OFF;

				if (Channel[eCh3].active) LED_ON[2] = 1; else  LED_ON[2] = 0;
				if (Channel[eCh4].active) LED_ON[3] = 1; else  LED_ON[3] = 0;
			}
			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;
			ConfigChanged = 1;

			break;
		}

		// Edge -> External
		case 14 :
		{	
			if (MenuStatus[MENU_TRIGGEREDGE][1] != TRIG_EXT) return;	// BF only available if external source is active
			
			pos = -1;
			MenuPopupStep(8, &MenuStatus[MENU_TRIGGEREDGE][2], &pos, &pos, MENU_TRIGGEREDGE, 128, 2);
	
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;					
			
			New_Menu = 14;
			Menu_Changed = 1;

			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

			Display::StatusUpdate();
			
			break;
		}
			
		// Pulse Width -> Dir
		case 15 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (MenuStatus[MENU_PULSEWIDTH][2] == 2)
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 1;
				MenuBtnFocus[MENU_PULSEWIDTH] = 4; //PulseToggle = 2;					
			}
			else if (MenuStatus[MENU_PULSEWIDTH][2] == 1)
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 3;
				MenuBtnFocus[MENU_PULSEWIDTH] = 3; //PulseToggle = 1;			
			}
			else
			{
				MenuStatus[MENU_PULSEWIDTH][2] = 2;
				MenuBtnFocus[MENU_PULSEWIDTH] = 3; //PulseToggle = 1;
			}
					
//			printf("MenuStatus[MENU_PULSEWIDTH][2] = %d Focus = %d\n\r", MenuStatus[MENU_PULSEWIDTH][2], MenuBtnFocus[MENU_PULSEWIDTH]);
				
			MenuItemChanged[3] = 1;
			MenuItemChanged[4] = 1;
			MenuItemChanged[5] = 1;

			TriggerWayChanged = 1;
		
			New_Menu = 15;
			Menu_Changed = 1;

			Display::StatusUpdate();
			
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

			break;	
		}		
	
		// Cursor -> X2		
		case 16 :
		{
			if (Cursor_Enabled == 0) break;
			{
				if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

				if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
				else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
				else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
				else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
				else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
			
				Cursor_Vertical_Active = 2;
				Cursor_Horizontal_Active = 3;
	
				if(Signal::_FFT_Mode != FFT_OFF)
				Display::FFT_CalcCursorData();
				else
				Display::CALCCURSORDATA();

							
				New_Menu = 16;
				Menu_Changed = 1;
	
				Display::DRAW_ALL_CURSOR();
			}
			break;		
		}
		
		// Quick Print -> Save to CSV
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 17;
			Menu_Changed = 1;
			
			CommIF::DUMPCSV('C');	// save to CSV
	
			break;					
		}		

		// Hardware -> Gain
		case 18 :
		{		
			MenuBtnFocus[MENU_HARDWARE] = 2;
			
			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;
			break;	
		}	
	
		// Quick Measurement -> Add Measurement
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			Display::QM_AddMeasurement();

			New_Menu = 19;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;

			Display::CALCQMDATA();
			
			ConfigChanged = 1;
			break;
		}
		
		// Quick Measurement Delay Settings -> Source 2
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;

			pos = -1;
			MenuPopupStep(6, &MenuStatus[MENU_QMDELAY][2], &pos, &pos, 20, 27, 2);
				
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}	
		
		// Quick Measurement Phase Settings -> Source 2
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;

			pos = -1;
			MenuPopupStep(25, &MenuStatus[MENU_QMPHASE][2], &pos, &pos, 21, 27, 2);
				
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}

		// Quick Measurement Threshold -> Lower
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 1;

			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 

		// Autoscale -> Save to flash
		case 23 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
 			New_Menu = 14;		// go to edge menu
			LED_ON[5] = 1;
			LED_ON[8] = 1;
			Hardware::Send_LED();
			Menu_Changed = 1;
			ConfigChanged = 1;
			
			break;
		}


		// Trigger Mode TV
		case 24 :
		{
			pos = -1;
			MenuPopupStep(21, &MenuStatus[MENU_TRIGGERTV][2], &pos, &pos, 24, 114, 2);
				
			New_Menu = 24;
			Menu_Changed = 1;

			break;
		}

		// More Utilities - CH3 Delay			BF #001
		case 25 :
		{	
			if (NumberOfChannels == 2){return;}	//only for 4 channel version

			pos = -1;
			MenuPopupStep(35, &MenuStatus[MENU_EXTUTILS][2], &pos, &pos, MENU_EXTUTILS, 203, 2);
			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 0;

			if (MenuBtnFocus[MENU_EXTUTILS] != 2)
			{
				MenuBtnFocus[MENU_EXTUTILS] = 2;
				Display::DrawMenuItem(MENU_EXTUTILS,0, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,1, 1);//, 0);					// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,2, 1);//, 0);					// change arrow to active
				Display::DrawMenuItem(MENU_EXTUTILS,3, 1);//, 0);					// change arrow to inactive
			}
			MenuItemChanged[2] = 1;
			Menu_Changed = 1;

			Hardware::_ChannelDelay[2] = MenuStatus[MENU_EXTUTILS][2] - 203;
			
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	// save to calibration sector delayed

			break;
		}			


		// Math - 1 * 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_MATH][2] == BTN_OFF)
			{
				//switch logic
				MenuStatus[MENU_MATH][3] = BTN_OFF;
				MenuStatus[MENU_MATH][4] = BTN_OFF;
				MenuStatus[MENU_MATH][2] = BTN_ON;		//set actual button to active

				MenuItemChanged[0] = 1;				//redraw scale
				MenuItemChanged[1] = 1;				//redraw offset

				MenuItemChanged[2] = 1;				//redraw buttons
				MenuItemChanged[3] = 1;				//redraw buttons
				MenuItemChanged[4] = 1;				//redraw buttons

				//math_scale = math_mul_scale - 166;
				//Math_Offset = Math_Mul_Offset;

				New_Menu = MENU_MATH;
				Menu_Changed = 1;
			}
			
			break;
		}

		// FFT - FFT-Mode
		case 27 :
		{					
			pos = -1;
			MenuPopupStep(31, &MenuStatus[MENU_FFT][2], &pos, &pos, 27, 66, 2);
			New_Menu = 27;
			Menu_Changed = 1;
		
			if (MenuBtnFocus[MENU_FFT] != 2)
			{
				MenuBtnFocus[MENU_FFT] = 2;
				Display::DrawMenuItem(MENU_FFT,0, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,1, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,2, 1);					// change arrow to active
				Display::DrawMenuItem(MENU_FFT,3, 1);					// change arrow to inactive
			}

			Signal::_FFT_Mode = MenuStatus[MENU_FFT][2] - 65;
			
			//Signal::FFT_buildScaleLookupTable();
			Hardware::SetDelayTimer1(60, &Signal::FFT_buildScaleLookupTable);		// load table builder to execution queue -> delay 1s

			break;	
		}

		// Display FFT -> grid color
		case 28 :
		{
			if (GridColorArrayPos < 3){ GridColorArrayPos++; }
			else GridColorArrayPos = 0;

			Hardware::_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
			Hardware::CaptureSetupADC();						// write color shadow register to hardware

			MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;
			MenuStatus[MENU_DISPL_FFT][2] = MenuStatus[MENU_DISPLAY][2];
							
			Display::Rect(240, 454, 60, 14, 0, Buffer_UI2Plane);
			Display::TextOut12x9(MenuData[MenuStatus[MENU_DISPLAY][2]], 218 + MenuDataDef[MenuStatus[MENU_DISPLAY][2]], 455, 1, Buffer_UI2Plane);
			//Menu_Changed = 1;

			break;
/*
	
			ColorPalette++;
			if (ColorPalette>9) ColorPalette = 0;
			
			GridColor_Val = GridColorArray[ColorPalette][GridColorArrayPos];
			Hardware::SetupADC();	
			nr_delay(5);

			break;
*/
		}


/* BF -> not needed for the new FFT		
		
		// FFT - Settings - Offset
		case 28 :
		{					
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
	
			FFTToggle = 1;
		
			MenuItemChanged[1] = 1;
			MenuItemChanged[2] = 1;					

			New_Menu = 27;
			Menu_Changed = 1;

			break;
		}
*/


		// USTB Menu -> buffer size
		case 30 :
		{	
			if(USTB_Mode != USTB_OFF && Run)
			{
				Hardware::Stop_Timer2();
				Hardware::Stop_Record();
			}
			
			pos = -1;
			MenuPopupStep(42, &MenuStatus[MENU_USTB][2], &pos, &pos, MENU_USTB, 296, 2);
	
			if (USTB_Mode != USTB_OFF) 
			{	
				Display::RecalcTimeParameters();					// calc new buffer size parameters
				
				Signal::USTB_clearBuffer();

				if (Memory_Window_visible) Display::RefreshMemoryBrowser();		// if Memory Window visible redraw Memory Window
				
				if (Run)
				{
					Hardware::Reset_Timer2();
					Display::DRAWSTATUS(6, 1);
				}
			}	
										
			New_Menu = MENU_USTB;
			Menu_Changed = 1;
//printf("\nUSTB_Mode: %d  USTB_Dir: %d  USTB_Disp: %d\r\n",USTB_Mode, USTB_Dir, USTB_Disp);

			break;	
		}		

		// Quick Print USB-Host export -> Save to CSV
		case 31 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 31;
			Menu_Changed = 1;
			
			CommIF::UC_DUMPCSV();	// save to CSV on SD card or USB-stick
	
			break;					
		}		



	}

#ifdef _Debug_						
			if (Debug_Mode) printf("Function Button 3\n");
#endif
}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 4 pushed
void UserIF::F4_Btnhandler(void)					// Button Handler for function button
{
			
	short pos = 0;

#ifdef _Debug_		
       	printf("F4 Btn start\n");
#endif	
	
	//BF del if(DrawMono==0){ MenuItemPushed[3] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer3();
	
	if ((Active_Menu == 1) && (!Channel[eCh1].active)) return;
	if ((Active_Menu == 2) && (!Channel[eCh2].active)) return;
	if ((Active_Menu == 3) && (!Channel[eCh3].active)) return;
	if ((Active_Menu == 4) && (!Channel[eCh4].active)) return;
	//if ((Active_Menu == 26) && (Channel[eChM].active == false)) return;
				
	if ((Active_Menu == 16) && (!Cursor_Enabled)) return;
	if ((Active_Menu == 19) && (!QM_Enabled)) return;
	if ((Active_Menu == 20) && (!QM_Enabled)) return;
	if ((Active_Menu == 21) && (!QM_Enabled)) return;
	if ((Active_Menu == 22) && (!QM_Enabled)) return;

	MenuItemChanged[3] = MenuAktive;
	Menu_Changed = MenuAktive;

	
	switch(Active_Menu)
	{				
		// Acquire -> Interpolation
		case 0 :
		{
			if (USTB_Mode != USTB_OFF) return;
			
			pos = -1;
			MenuPopupStep(23, &MenuStatus[MENU_ACQUIRE][3], &pos, &pos, MENU_ACQUIRE, 42, 2);

			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;
			
			if (MainTimebase < 4)					// in interpolated TB change on screen status
			{ Display::OssSingle(eOssIpol, 1, 1); }
			
		/*	if (AcquirePopupSelect != 3)
			{
				AcquirePopupSelect = 3;
				//Display::DrawMenuItem(MENU_ACQUIRE,1, 1, 0);					// change arrow to inactive
				//Display::DrawMenuItem(MENU_ACQUIRE,2, 1, 0);					// change arrow to inactive
				//Display::DrawMenuItem(MENU_ACQUIRE,3, 1, 0);					// change arrow to active
			}
		*/
			//if (MenuStatus[MENU_ACQUIRE][3]==43) Signal::FIR_buildSincLookupTable();		// calculate new lookup table for sinc interpolation
			
			if(!Run)ACQ_NewData = 1;								//if acquisision is stopped signal processing must be triggered to take effect

			break;							
		}

		// channel 1 -> probe
		case 1 :
		{
			MenuBtnFocus[MENU_CHANNEL1] = 3;	// set focus to probe button
			New_Menu = MENU_CHANNEL1;
			Menu_Changed = 1;
			MenuItemChanged[0] = 1;			// draw coupling button arrowcycle grey
			
			break;
		}
		
		// channel 2 -> probe
		case 2 :
		{
			MenuBtnFocus[MENU_CHANNEL2] = 3;	// set focus to probe button
			New_Menu = MENU_CHANNEL2;
			Menu_Changed = 2;
			MenuItemChanged[0] = 1;			// draw coupling button arrowcycle grey

			break;
		}
		
		// channel 3 -> probe
		case 3 :
		{
			MenuBtnFocus[MENU_CHANNEL3] = 3;	// set focus to probe button
			New_Menu = MENU_CHANNEL3;
			Menu_Changed = 3;
			MenuItemChanged[0] = 1;			// draw coupling button arrowcycle grey

			break;
		}
		
		// channel 4 -> probe
		case 4 :
		{
			MenuBtnFocus[MENU_CHANNEL4] = 3;	// set focus to probe button
			New_Menu = MENU_CHANNEL4;
			Menu_Changed = 4;
			MenuItemChanged[0] = 1;			// draw coupling button arrowcycle grey

			break;
		}
	
		
		// Display -> channel no display	
		case 5 :
		{
			pos = -1;
			MenuPopupStep(45, &MenuStatus[MENU_DISPLAY][3], &pos, &pos, MENU_DISPLAY, 320, 2);
			
			for(int i=0;i<4;i++)NoDisplay[i] = 0;				// all channels off

			switch (MenuStatus[MENU_DISPLAY][3])
			{
				case 320: break;					// off
				case 321: NoDisplay[0] = 1; break;			// channel 1
				case 322: NoDisplay[1] = 1; break;			// channel 2
				case 323: NoDisplay[0] = 1; NoDisplay[1] = 1; break;	// channel 1 + 2
				case 324: NoDisplay[2] = 1; break;			// channel 3
				case 325: NoDisplay[3] = 1; break;			// channel 4
				case 326: NoDisplay[2] = 1; NoDisplay[3] = 1; break;	// channel 3 + 4
			}

			New_Menu = MENU_DISPLAY;
			Menu_Changed = 1;
			break;
		}	
		


		// Utility -> Calibration Set		-> BF added new menu function
		case 6 :
		{	
			pos = -1;
			MenuPopupStep(19, &MenuStatus[MENU_UTILITY][3], &pos, &pos, MENU_UTILITY, 264, 2);

			CalSet = MenuStatus[MENU_UTILITY][3] - 264;

			// save to calibration sector delayed -> has to be done before On_Zero to avoid VSync overflow
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	
			
			// activate new settings
			RotarySteps = 0;
			ON_Zero_Channel_1();

			RotarySteps = 0;
			UserIF::ON_Zero_Channel_2();

			if (NumberOfChannels == 4)
			{
				RotarySteps = 0;
				UserIF::ON_Zero_Channel_3();
				
				RotarySteps = 0;
				UserIF::ON_Zero_Channel_4();
			}
			
			// setup trigger explicit because of vsync overflow above
			Hardware::SetupTrigger();
			
			New_Menu = MENU_UTILITY;
			Menu_Changed = 1;
			
			break;	
		}
	
		// Service - RS-232 Setup
		case 7 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}	

		// Save / Recall -> overlay	#013
		case 8 :
		{	
			if (!MenuAktive) return;
			if (LA_active) return;
			AMDFlash::RecallOverlay();

			break;
		}	
	

		// Display Setup -> QM-Cursors on/off
		case 9 :
		{
			if ( MenuStatus[MENU_DISPL_SETUP][3] == BTN_ON )
				MenuStatus[MENU_DISPL_SETUP][3] = BTN_OFF;
			else
				MenuStatus[MENU_DISPL_SETUP][3] = BTN_ON;

			break;
		}	

		// Timebase Menu -> FFT
		case 10 :
		{
			if (USTB_Mode != USTB_OFF) return;
			if (LA_active) return;

			ACQ_PeakDetect = OFF;										//switch off peak detect
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	

			Menu_Changed = 1;

			LED_ON[7] = 0;											// switch off QM LED
			LED_ON[5] = 1;											// switch on main wheel LED
			Hardware::Send_LED();
					
			if (MenuStatus[MENU_TIMEBASE][3] == BTN_ON)							// FFT mode switched on?
			{ New_Menu = MENU_FFT; return; }								// -> leave here and don't execute next part

			if (Memory_Window_visible) 									// if the browser window is open ... close
			{ Display::CloseMemoryBrowser(); }								// close browser window	
		
			// switch off Main, delayed and XY
			if (MenuStatus[MENU_TIMEBASE][0] == BTN_ON)
			{
				MenuStatus[MENU_TIMEBASE][0]  = BTN_OFF;						//switch off main mode
				MenuItemChanged[0] = 1;									//redraw main button
			}
			else if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
			{
				MenuStatus[MENU_TIMEBASE][1]  = BTN_OFF;						//switch off delayed mode
				MenuItemChanged[1] = 1;									//redraw delayed button
			}
			else if (MenuStatus[MENU_TIMEBASE][2] == BTN_ON)						//XY-mode active?	
			{
				MenuStatus[MENU_TIMEBASE][2]  = BTN_OFF;						//switch XY-mode off
				MenuItemChanged[2] = 1;									//redraw XY button
				XY_Mode = 0; 										//switch XY-mode off, needed in On_Zero

				//BF added for restoring zero levels
				ZeroLevelCH1 = ZeroLevelCH1_Main_bak;
				ZeroLevelCH2 = ZeroLevelCH2_Main_bak;
				ZeroLevelCH3 = ZeroLevelCH3_Main_bak;
				ZeroLevelCH4 = ZeroLevelCH4_Main_bak;
				
				Virtual_ZeroLevelCH1 = Virtual_ZeroLevelCH1_Main_bak;
				Virtual_ZeroLevelCH2 = Virtual_ZeroLevelCH2_Main_bak;
				Virtual_ZeroLevelCH3 = Virtual_ZeroLevelCH3_Main_bak;
				Virtual_ZeroLevelCH4 = Virtual_ZeroLevelCH4_Main_bak;

				Trigger_Pos_CH1 = Trigger_Pos_CH1 - Virtual_ZeroLevelXYCH1 + Virtual_ZeroLevelCH1;	//keep triggerlevel
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - Virtual_ZeroLevelXYCH2 + Virtual_ZeroLevelCH2;	//keep triggerlevel
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - Virtual_ZeroLevelXYCH3 + Virtual_ZeroLevelCH3;	//keep triggerlevel
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - Virtual_ZeroLevelXYCH4 + Virtual_ZeroLevelCH4;	//keep triggerlevel

				RotarySteps = 0; UserIF::ON_Zero_Channel_1();
				RotarySteps = 0; UserIF::ON_Zero_Channel_2();

				if (NumberOfChannels == 4)
				{
					RotarySteps = 0; UserIF::ON_Zero_Channel_3();
					RotarySteps = 0; UserIF::ON_Zero_Channel_4();
				}

				if(Cursor_Enabled)//set cursor source channels active
				{
					if(MenuPopupStatus[1][0] == 1 && Channel[eCh1].active) MenuPopupStatus[1][0] = 2;
					if(MenuPopupStatus[1][1] == 1 && Channel[eCh2].active) MenuPopupStatus[1][1] = 2;
					if(MenuPopupStatus[1][2] == 1 && Channel[eCh3].active) MenuPopupStatus[1][3] = 2;
					if(MenuPopupStatus[1][3] == 1 && Channel[eCh4].active) MenuPopupStatus[1][4] = 2;
				} 
			}

			MenuStatus[MENU_TIMEBASE][4] = INACTIVE;							// gray out browse button
			MenuItemChanged[5] = 1;										// redraw browse button

			Hardware::FFT_Set_Channel(1);									// set active channel with backup
			
			Hardware::Zero_Levels_Center();									// set zerolevels to the middle of the grid 

			MenuStatus[MENU_TIMEBASE][3] = BTN_ON;								// switch on FFT button
			Signal::_FFT_Mode = MenuStatus[MENU_FFT][2] - 65;							// setting FFT-mode must be done after switching zero levels!

			if(QM_Enabled)
			{
				QM_Enabled = 0;										// no QM support for FFT til now -> later
				Display::DrawQMData(0);									// remove QM data
			}

			Display::RecalcTimeParameters();
			//Hardware::SetReadoutLength();		// is done above in RecalcTimeParameters()
			Display::RefreshScreen();
			
			Display::DRAW_ALL_CURSOR();
			New_Menu = MENU_FFT;
			ConfigChanged = 1;										// Save new values to flash
		}

		break;	
					
		// Trigger Mode  -> Holdoff
		case 12 :
		{
			int32_t buf_int;

			if (LA_active) return;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
		
			//if (EdgeToggle == 0)	// holdoff button active?
			if (MenuBtnFocus[MENU_TRIGGERMODE] == 3)	// holdoff button active?
			{		

				buf_int = (int) (HoldOff.Read_Value() * 100000000);

	//printf("                                  buf_int : %d  Direction: %d \r",buf_int, RotaryDirection_mem_pulse);	

				if (RotaryDirectionMemPulse == 1)	// direction to higher values
				{	
					if (buf_int == 0)
					{
						HoldOff.Write_Value(0.000000120);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 8;//40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int >= 1) && (buf_int < 100))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1000;//1;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
					else if ((buf_int >= 100) && (buf_int < 1000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10000;//10;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
					else if ((buf_int >= 1000) && (buf_int < 10000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100000;//100;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
					else if ((buf_int >= 10000) && (buf_int < 100000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else if ((buf_int >= 100000) && (buf_int < 1000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else if ((buf_int >= 1000000) && (buf_int < 10000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 8;  //40;
						HoldOff_Expo = 1;
						ConfigChanged = 1; 
					}
				}
				else 	                 		// direction to lower values	
				{
					if (buf_int == 0)
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100000;//100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3; //4;
					}
					else if (buf_int == 4)
					{
						HoldOff.Write_Value(0);
		
						HoldOff_Value = 0;
						HoldOff_Steps = 8; //40;
						HoldOff_Expo = 1;
						ConfigChanged = 1; 
					}
					else if (buf_int == 12)
					{
						HoldOff.Write_Value(0.000000040);
		
						HoldOff_Value = 40;
						HoldOff_Steps = 8;  //40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 10) && (buf_int <= 100))
					{
						HoldOff.Write_Value(0.000000120);
		
						HoldOff_Value = 120;
						HoldOff_Steps = 8;  //40;
						HoldOff_Expo = 1;
					}
					else if ((buf_int > 100) && (buf_int <= 1000))
					{
						HoldOff.Write_Value(0.000001);
		
						HoldOff_Value = 1000;//1;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
					else if ((buf_int > 1000) && (buf_int <= 10000))
					{
						HoldOff.Write_Value(0.00001);
		
						HoldOff_Value = 10000;//10;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
					else if ((buf_int > 10000) && (buf_int <= 100000))
					{
						HoldOff.Write_Value(0.0001);
		
						HoldOff_Value = 100000; //100;
						HoldOff_Steps = 8;//1;
						HoldOff_Expo = 1;//2;
					}
		
					else if ((buf_int > 100000) && (buf_int <= 1000000))
					{
						HoldOff.Write_Value(0.001);
		
						HoldOff_Value = 1000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else if ((buf_int > 1000000) && (buf_int <= 10000000))
					{
						HoldOff.Write_Value(0.01);
		
						HoldOff_Value = 10000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else if ((buf_int > 10000000) && (buf_int <= 100000000))
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100000;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
					else
					{
						HoldOff.Write_Value(0.1);
		
						HoldOff_Value = 100000; //100;
						HoldOff_Steps = 1;
						HoldOff_Expo = 2;//3;
					}
				}

		
				HoldOff.RenderText();		// write value to screen

			}
	//printf("Value : %d  Expo : %d Steps : %d   \r\n", HoldOff_Value, HoldOff_Expo, HoldOff_Steps );
		
			//EdgeToggle = 0;			// set hold off button active
			MenuBtnFocus[Active_Menu] = 3;		// set focus to F4

			New_Menu = 12;			
			Menu_Changed = 1;
			MenuItemChanged[4] = 1;
	
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

			break;
		}	

		// Trigger sub menu -> Single Trigger Setting
		case 13 :
		{	
			if (USTB_Mode != USTB_OFF) return;
	
			pos = -1;
			MenuPopupStep(12, &MenuStatus[MENU_TRIGGERSUB][3], &pos, &pos, MENU_TRIGGERSUB, 124, 2);

			if (MenuStatus[MENU_TRIGGERSUB][3] == 126 && MenuStatus[MENU_TRIGGERMODE][0] == TRIG_NORM)	// direct manual trigger
			LED_ON[15] = 1;
			else
			LED_ON[15] = 0;

			Hardware::Send_LED();

			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;
			
			break;	
		}	



		// Edge -> TV
		case 14 :
		{	
			if (MenuStatus[MENU_TRIGGEREDGE][1] != TRIG_TV) return;	// BF only available if TV source is active

			pos = -1;
			MenuPopupStep(11, &MenuStatus[MENU_TRIGGEREDGE][3], &pos, &pos, 14, 131, 2);


/*BF del
			if (MenuStatus[MENU_TRIGGEREDGE][3] == 0)
			{				
				//BF del MenuItemChanged[1] = 1;
				//BF del MenuStatus[MENU_TRIGGEREDGE][1] = 0;
						
				MenuItemChanged[2] = 1;			
				MenuStatus[MENU_TRIGGEREDGE][2] = 0;	//BF set External trigger menu inactive
				
				MenuItemChanged[3] = 1;
				MenuStatus[MENU_TRIGGEREDGE][3] = 1;	//BF set TV trigger menu active
				
				New_Menu = 14;
				Menu_Changed = 1;
			}
			else
			{
				if (MenuPopupActive == 11)
				{
					if (MenuPopupStatus[11][0] == 3)	
					{
						MenuPopupStatus[11][0] = 2;
						MenuPopupStatus[11][1] = 3;
					}
					else
					{
						MenuPopupStatus[11][0] = 3;
						MenuPopupStatus[11][1] = 2;
					}
				}
			}
*/			
			TriggerLevelChanged = 1;
			TriggerWayChanged = 1;		
			//BF del Selected_Trigger_Source = 6;
			//BF del SelectedEdgeExtern = 2;               // TV CH 1	

			Display::StatusUpdate();
				
			Hardware::SetupTrigger();	
			
			break;
		} 
	
		// Pulse Width -> lower value
		case 15 :
		{	
			int32_t buf_int;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_PULSEWIDTH][2] == 1) break;

			if (MenuStatus[MENU_PULSEWIDTH][2] == 3)
			{					
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 3)  //if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse11.Read_Value() * 100000000);	
					
					if (RotaryDirectionMemPulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse11.Write_Value(0.000000016);
			
							Pulse11_Value = 16;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse11.Write_Value(0.000000104);
			
							Pulse11_Value = 104;
							Pulse11_Steps = 8;
							Pulse11_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse11.Write_Value(0.000001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse11.Write_Value(0.00001);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse11.Write_Value(0.0001);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse11.Write_Value(0.001);
			
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse11.Write_Value(0.01);
			
							Pulse11_Value = 10;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
						else
						{
							Pulse11.Write_Value(0.1);
			
							Pulse11_Value = 100;
							Pulse11_Steps = 1;
							Pulse11_Expo = 3;
						}
					}					
		
					Pulse11.RenderText();
					//trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);
				}
				else MenuBtnFocus[MENU_PULSEWIDTH] = 3; //PulseToggle = 1;
			}
			else
			{
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 3)   //if (PulseToggle == 1)
				{					
					buf_int = (int) (Pulse21.Read_Value() * 100000000);	
					
					if (RotaryDirectionMemPulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
						Pulse21.Write_Value(0.000000016);
		
						Pulse21_Value = 16;
						Pulse21_Steps = 8;
						Pulse21_Expo = 1;
						}
					}
					else 
					{
						if (buf_int == 1)
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse21.Write_Value(0.000000016);
			
							Pulse21_Value = 16;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse21.Write_Value(0.000000104);
			
							Pulse21_Value = 104;
							Pulse21_Steps = 8;
							Pulse21_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse21.Write_Value(0.000001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse21.Write_Value(0.00001);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse21.Write_Value(0.0001);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse21.Write_Value(0.001);
			
							Pulse21_Value = 1;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse21.Write_Value(0.01);
			
							Pulse21_Value = 10;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
						else
						{
							Pulse21.Write_Value(0.1);
			
							Pulse21_Value = 100;
							Pulse21_Steps = 1;
							Pulse21_Expo = 3;
						}
					}			
			
					Pulse21.RenderText();
					//trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
				}
				else MenuBtnFocus[MENU_PULSEWIDTH] = 3;   //PulseToggle = 1;
			}

			MenuItemChanged[4] = 1;								//redraw higher value button
			MenuItemChanged[5] = 1;								//redraw pretrigger button 

			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
			
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue -> delay 1s

			Display::StatusUpdate();

			break;	
		}

		// Cursor -> Y1
		case 16 :
		{	
			if (Cursor_Enabled == 0 || LA_active) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }		

			if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
			else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
			else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
			else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
			else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
		
			Cursor_Vertical_Active = 3;
			Cursor_Horizontal_Active = 1; 			

			if(Signal::_FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

							
			New_Menu = 16;
			Menu_Changed = 1;

			Display::DRAW_ALL_CURSOR();
			break;						
		}
		
		// Quick Print -> Save to ASCII -> only in BF menu
		case 17 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 17;
			//Menu_Changed = 1;
			
			CommIF::DUMPCSV('A');	// save to ASCII

			return;					
		}		

		// Hardware -> ADC Driver
		case 18 :
		{		
			pos = -1;
			MenuPopupStep(48, &MenuStatus[MENU_HARDWARE][3], &pos, &pos, MENU_HARDWARE, 350, 2);

			New_Menu = MENU_HARDWARE;
			Menu_Changed = 1;
			
			Hardware::SetDelayTimer1(60, &AMDFlash::WriteCalibration);		// save to calibration sector delayed
			break;	
		}	

		// Quick Measurement -> Clear
		case 19 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				
		
			//QM_Type_Old[0] = QM_Type[0];
			//QM_Type_Old[1] = QM_Type[1];
			//QM_Type_Old[2] = QM_Type[2];

			QM_Type[0] = 0;
			QM_Type[1] = 0;
			QM_Type[2] = 0;
	
			QM_Channel[0] = QM_Source - 26; //MenuStatus[MENU_QUICKMEASURE][0] - 26;
			QM_Channel[1] = QM_Source - 26; //MenuStatus[MENU_QUICKMEASURE][0] - 26;
			QM_Channel[2] = QM_Source - 26; //MenuStatus[MENU_QUICKMEASURE][0] - 26;

			QM_Changed[0] = 0;
			QM_Changed[1] = 0;
			QM_Changed[2] = 0;
	
			Quick_Measure_First_Draw = 1;

			New_Menu = 19;
			Menu_Changed = 1;
	
			QM_Vertical_Active = 0;
			QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();
			ConfigChanged = 1;

			break;
		}
	
		// Quick Measurement Settings -> Delay Edge
		case 20 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			if (MenuStatus[MENU_QMDELAY][3] == 2) MenuStatus[MENU_QMDELAY][3] = 3;
			else MenuStatus[MENU_QMDELAY][3] = 2;
		
			New_Menu = 20;
			Menu_Changed = 1;

			break;
		}	

		// Quick Measurement Settings -> Phase Edge
		case 21 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			if (MenuStatus[MENU_QMPHASE][3] == 2) MenuStatus[MENU_QMPHASE][3] = 3;
			else MenuStatus[MENU_QMPHASE][3] = 2;
		
			New_Menu = 21;
			Menu_Changed = 1;

			break;
		}	


		// Quick Measurement Threshold -> Middle
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 3) MenuItemChanged[4] = 1;

			Quick_Measure_Threshold_btn_select = 2;
			
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		}
	
		// Autoscale - Setup TB Search
		case 23 :
		{
			pos = -1;
			MenuPopupStep(2, &MenuStatus[MENU_AUTOSCALE][3], &pos, &pos, MENU_AUTOSCALE, 280, 2);
			
			New_Menu = MENU_AUTOSCALE;// 23
			Menu_Changed = 1;
			break;
		}		



		// Trigger Mode TV
		case 24 :
		{
			pos = -1;
			MenuPopupStep(22, &MenuStatus[MENU_TRIGGERTV][3], &pos, &pos, MENU_TRIGGERTV, 119, 2);
			
			New_Menu = MENU_TRIGGERTV;//24
			Menu_Changed = 1;
			break;
		}		

		// More Utilities - CH4 Delay			BF #001
		case 25 :
		{	
			if (NumberOfChannels == 2){return;}	//only for 4 channel version

			pos = -1;
			MenuPopupStep(36, &MenuStatus[MENU_EXTUTILS][3], &pos, &pos, MENU_EXTUTILS, 203, 2);

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 0;
	
			if (MenuBtnFocus[MENU_EXTUTILS] != 3)
			{
				MenuBtnFocus[MENU_EXTUTILS] = 3;
				Display::DrawMenuItem(MENU_EXTUTILS,0, 1);			// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,1, 1);			// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,2, 1);			// change arrow to inactive
				Display::DrawMenuItem(MENU_EXTUTILS,3, 1);			// change arrow to active
			}
			MenuItemChanged[3] = 1;
			Menu_Changed = 1;

			Hardware::_ChannelDelay[3] = MenuStatus[MENU_EXTUTILS][3] - 203;

			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);		// save to calibration sector delayed
			
			break;
		}			



		// Math  1 - 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_MATH][3] == BTN_OFF)
			{
				//switch logic
				MenuStatus[MENU_MATH][2] = BTN_OFF;
				MenuStatus[MENU_MATH][4] = BTN_OFF;
				MenuStatus[MENU_MATH][3] = BTN_ON;		//set actual button to active

				MenuItemChanged[0] = 1;				//redraw scale
				MenuItemChanged[1] = 1;				//redraw offset

				MenuItemChanged[2] = 1;				//redraw buttons
				MenuItemChanged[3] = 1;				//redraw buttons
				MenuItemChanged[4] = 1;				//redraw buttons

				//math_scale = math_sub_scale - 150;
				//Math_Offset = Math_Sub_Offset;

				New_Menu = MENU_MATH;
				Menu_Changed = 1;
			}
			break;
		}	
		
		// FFT - Settings - FFT-Length
		case 27 :
		{					
			pos = -1;
			MenuPopupStep(32, &MenuStatus[MENU_FFT][3], &pos, &pos, 27, 83, 2);
	
			New_Menu = 27;
			Menu_Changed = 1;

			if (MenuBtnFocus[MENU_FFT] != 3)
			{
				MenuBtnFocus[MENU_FFT] = 3;
				Display::DrawMenuItem(MENU_FFT,0, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,1, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,2, 1);					// change arrow to inactive
				Display::DrawMenuItem(MENU_FFT,3, 1);					// change arrow to active
			}
			
			// FFT 512
			if (MenuStatus[MENU_FFT][3] == 83)
			{ Signal::_FFT_Length = FFT_512; Signal::_FFT_Level = 9; }
			// FFT 1024
			else if (MenuStatus[MENU_FFT][3] == 84)
			{ Signal::_FFT_Length = FFT_1K; Signal::_FFT_Level = 10; }
 			// FFT 2048
			else if (MenuStatus[MENU_FFT][3] == 85)
			{ Signal::_FFT_Length = FFT_2K; Signal::_FFT_Level = 11; }
 			// FFT 4096
			else if (MenuStatus[MENU_FFT][3] == 86)
			{ Signal::_FFT_Length = FFT_4K; Signal::_FFT_Level = 12; }
 			
			//Signal::FFT_buildTrigoTables();
			Hardware::SetDelayTimer1(60, &Signal::FFT_buildTrigoTables);	// load table builder to execution queue -> delay 1s
			
			//Display::RefreshScreen();
			Display::FFT_DrawStatus(0);
			
			break;	
		}

		// Display FFT -> Switch FFT grid from dotted to solid	
		case 28 :
		{
			if(FFT_grid)
			{
				//if(dotted_grid)
				//{ dotted_grid = 0; }
				//else
				{ FFT_grid = 0;}	// switch to 12 divs	
			}
			else
			{
				//if(dotted_grid)
				{ FFT_grid = 1; } 	// switch to 8 divs
				//else
				//{ dotted_grid = 1; }
			}
			Display::RefreshScreen();

			New_Menu = Active_Menu;
			ConfigChanged = 1;

			break;
		}	


		// Quick Print -> Save to ASCII -> only in BF menu
/*		case 30 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 30;
			//Menu_Changed = 1;
			
			CommIF::DUMPCSV('A');	// save to ASCII

			break;					
		}		
*/

	}
	

#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 4\n");		
#endif


}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 5 pushed
void UserIF::F5_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;


#ifdef _Debug_		
       	printf("F5 Btn start\n");
#endif	
			
	//if(DrawMono==0){ MenuItemPushed[4] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer
//	if (ZeroPopupChanged > 0) Hardware::ResetTimer3();
			
	if ((Active_Menu == 1) && !Channel[eCh1].active) return;
	if ((Active_Menu == 2) && !Channel[eCh2].active) return;
	if ((Active_Menu == 3) && !Channel[eCh3].active) return;
	if ((Active_Menu == 4) && !Channel[eCh4].active) return;
	//if ((Active_Menu == 26) && (Channel[eChM].active == false)) return;
				
	if ((Active_Menu == 16) && !Cursor_Enabled) return;
	if ((Active_Menu == 19) && !QM_Enabled) return;
	if ((Active_Menu == 20) && !QM_Enabled) return;
	if ((Active_Menu == 21) && !QM_Enabled) return;
	if ((Active_Menu == 22) && !QM_Enabled) return;
	
	MenuItemChanged[4] = MenuAktive;
	Menu_Changed = MenuAktive;
			
	switch(Active_Menu)
	{
		// Acquire -> Peak Detect
		case 0 :
		{
			if (MenuStatus[MENU_TIMEBASE][0] == BTN_OFF)
			{
				MenuItemChanged[4] = 0;
				Menu_Changed = 0;

				return;		//Check if main mode is active
			}
			
			if (MenuStatus[MENU_ACQUIRE][4] == BTN_OFF)
			{
				if(MenuStatus[MENU_UTILITY][4] == BTN_ON)	// test signal active?
				{
					Active_Menu = MENU_UTILITY;
					F5_Btnhandler();			// switch off testsignal
					Active_Menu = MENU_ACQUIRE;
				}
				
				MenuStatus[MENU_ACQUIRE][4] = BTN_ON;
				ACQ_PeakDetect = 1;
				Hardware::SetDelayTimer1(30, &Signal::PeakDetect);
			}
			else
			{
				MenuStatus[MENU_ACQUIRE][4] = BTN_OFF;
				ACQ_PeakDetect = 0;
			}
			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;
			
			
			break;
		}
		
		// Channel 1 -> center trace
		case 1 :
		{
			Hardware::CenterTrace(eCh1);
			break;
		}	

		// Channel 2 -> center trace
		case 2 :
		{
			Hardware::CenterTrace(eCh2);
			break;
		}	

		// Channel 3 -> center trace
		case 3 :
		{
			Hardware::CenterTrace(eCh3);
			break;
		}	

		// Channel 4 -> center trace
		case 4 :
		{
			Hardware::CenterTrace(eCh4);
			break;
		}	

		// Display -> draw mode
		case 5 :
		{
			pos = -1;
			MenuPopupStep(0, &MenuStatus[MENU_DISPLAY][4], &pos, &pos, MENU_DISPLAY, DRAW_FAST, 2);
			
			New_Menu = MENU_DISPLAY;
			Menu_Changed = 1;
			break;
		}	


		//Utility -> test signal generator
		case 6 :
		{	
			if (MenuStatus[MENU_ACQUIRE][4] == BTN_ON) return;		// test signal not available for peak detect
			
			if(MenuStatus[MENU_UTILITY][4] == BTN_ON) 			// test signal active?
			{
				MenuStatus[MENU_UTILITY][4] = BTN_OFF;			// switch off the test signal and restore trigger settings
				Hardware::SetupTrigger();
				Display::DRAWSTATUS(6, 1);
				Display::DRAWSTATUS(7, 1);
				Display::DRAWSTATUS(8, 1);
				
				if (Run)
				Hardware::Start_Record();
			}
			else								// switch on the test signal and deactivate trigger
			{
				MenuStatus[MENU_UTILITY][4] = BTN_ON;
				Hardware::CaptureTrigSetMode(eTrigFreerun);
				Display::DRAWSTATUS(6, 1);
			}
			break;
		}

		//  Save / Recall - > Clear Display
		case 8 :
		{		
			if (!MenuAktive) return;
			if ((Run == false) || (MenuStatus[MENU_DISPLAY][0] == 241)) Hardware::ClearPlanes();	
			break;	
		}				
		
		// Display Sub Setup -> OSS on/off
		case 9 :
		{
			if ( MenuStatus[MENU_DISPL_SETUP][4] == BTN_ON )
			{	
				// first delete OSS
				Display::OnScreenStatus(0, 1);
				// then switch off button
				MenuStatus[MENU_DISPL_SETUP][4] = BTN_OFF;
			}
			else
			{
				// first switch on button
				MenuStatus[MENU_DISPL_SETUP][4] = BTN_ON;
				// then draw OSS
				Display::OnScreenStatus(1, 1);
			}

			break;
		}	

		//Timebase menu -> browse   BF transferred from display menu
		case 10 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//if (USTB_Mode != USTB_OFF) return;
			if (Signal::_FFT_Mode != FFT_OFF) return;	// no browsing in FFT mode
			
			if (MenuStatus[MENU_TIMEBASE][4] == BTN_ON)
			{	
				MenuStatus[MENU_TIMEBASE][4] = BTN_OFF;
				Display::CloseMemoryBrowser();		// close browser window	
				Display::DRAW_ALL_CURSOR();
			}	
			else
			{	
				MenuStatus[MENU_TIMEBASE][4] = BTN_ON;
				Display::OpenMemoryBrowser();		// open browser window
			}	
			
			New_Menu = MENU_TIMEBASE;
			Menu_Changed = 1;	

			break;

		}

		
		// Trigger Mode  -> Probe
		case 12 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			//EdgeToggle = 1;
			MenuBtnFocus[Active_Menu] = 4;		// set focus to F5

			New_Menu = 12;
			Menu_Changed = 1;
			MenuItemChanged[3] = 1;				// redraw

			break;
		}	

		// Trigger sub menu -> Auto Pre Trigger Setting
		case 13 :
		{	
			if (USTB_Mode != USTB_OFF) return;	
			pos = -1;
			MenuPopupStep(20, &MenuStatus[MENU_TRIGGERSUB][4], &pos, &pos, MENU_TRIGGERSUB, 272, 2);

			New_Menu = MENU_TRIGGERSUB;

			Hardware::TRIG_AutoPretrigger();
			Display::DRAW_ALL_CURSOR();
		
			if (!AS_request)	//not in autoscale mode
			{
				if (Memory_Window_visible) 		// if Memory Window visible
					Display::RefreshMemoryBrowser(); 	// redraw Memory Window
				else
					Display::OpenMemoryBrowser(); 	// if Memory Window not visible yet, make it visible.
			}
		
			//if acquisision is stopped, signal processing must be triggered
			if(!Run)ACQ_NewData = 1;
		
			Menu_Changed = 1;	// refresh pre trigger value output

			break;	
		}	

		
		// Edge -> Adjust Window
		case 14 :
		{			
			if (Signal::_FFT_Mode != FFT_OFF) return;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			if (USTB_Mode == USTB_OFF)
			{
				if (MenuStatus[MENU_TRIGGERSUB][4] == 272)
				{ MemWinStart  = Trig_Pos_Mem; }				// pretrigger on left edge of memory window
				else if (MenuStatus[MENU_TRIGGERSUB][4] == 273)
				{MemWinStart  = Trig_Pos_Mem - (int)(50 * ZoomFactor); }	// pretrigger on first div
				else
				{ MemWinStart = Trig_Pos_Mem - (SignalMemSize>>1); }		// center memory window to pretrigger position
			}
			else
			{ MemWinStart = Trig_Pos_Mem - (SignalMemSize>>1); }			// center memory window to pretrigger position

			// right edge limiter memory window
			if ((MemWinStart + SignalMemSize) > MemoryEnd) { MemWinStart = MemoryEnd - SignalMemSize; }
		
			// left edge limiter memory window
			if (MemWinStart < MemStartOffs) { MemWinStart  = MemStartOffs; }

			//if (USTB_Mode == USTB_OFF)
			{
				Trig_Pos_Display = (int) ((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactor);
				Trig_Pos_Display_dmode = (int) (((float)(Trig_Pos_Mem - MemWinStart) / ZoomFactorDel) - ((float) Cursor_Delayed_1 * (ZoomFactor / ZoomFactorDel)));

				Display::DRAW_ALL_CURSOR();					// draw pretrigger position due to new window position
				if (Memory_Window_visible) 					// if Memory Window visible
				Display::RefreshMemoryBrowser(); 					// redraw Memory Window
			}

			break;
		}

	
		// Pulse Width -> higher value
		case 15 :
		{	
			int32_t buf_int;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_PULSEWIDTH][2] == 2) break;

			if (MenuStatus[MENU_PULSEWIDTH][2] == 3)
			{					
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 4)   //(PulseToggle == 2)
				{					
					buf_int = (int) (Pulse12.Read_Value() * 100000000);	
					
					if (RotaryDirectionMemPulse == 1)
					{				
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
					}
					else	
					{
						if (buf_int == 1)
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse12.Write_Value(0.000000016);
			
							Pulse12_Value = 16;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse12.Write_Value(0.000000104);
			
							Pulse12_Value = 104;
							Pulse12_Steps = 8;
							Pulse12_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse12.Write_Value(0.000001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse12.Write_Value(0.00001);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse12.Write_Value(0.0001);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 2;
						}
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse12.Write_Value(0.001);
			
							Pulse12_Value = 1;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse12.Write_Value(0.01);
			
							Pulse12_Value = 10;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
						else
						{
							Pulse12.Write_Value(0.1);
			
							Pulse12_Value = 100;
							Pulse12_Steps = 1;
							Pulse12_Expo = 3;
						}
					}

					Pulse12.RenderText();
					//trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
				}
				else MenuBtnFocus[MENU_PULSEWIDTH] = 4;    //PulseToggle = 2;
			}
			else
			{
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 4)    //(PulseToggle == 2)
				{					
					buf_int = (int) (Pulse22.Read_Value() * 100000000);	
					
					if (RotaryDirectionMemPulse == 1)
					{		
						if ((buf_int >= 1) && (buf_int < 10))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int >= 10) && (buf_int < 100))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 100) && (buf_int < 1000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int >= 1000) && (buf_int < 10000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int >= 10000) && (buf_int < 100000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 100000) && (buf_int < 1000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int >= 1000000) && (buf_int < 10000000))
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
					}
					else 	
					{
						if (buf_int == 1)
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if (buf_int == 10)
						{
							Pulse22.Write_Value(0.000000016);
			
							Pulse22_Value = 16;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 10) && (buf_int <= 100))
						{
							Pulse22.Write_Value(0.000000104);
			
							Pulse22_Value = 104;
							Pulse22_Steps = 8;
							Pulse22_Expo = 1;
						}
						else if ((buf_int > 100) && (buf_int <= 1000))
						{
							Pulse22.Write_Value(0.000001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 1000) && (buf_int <= 10000))
						{
							Pulse22.Write_Value(0.00001);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
						else if ((buf_int > 10000) && (buf_int <= 100000))
						{
							Pulse22.Write_Value(0.0001);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 2;
						}
		
						else if ((buf_int > 100000) && (buf_int <= 1000000))
						{
							Pulse22.Write_Value(0.001);
			
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else if ((buf_int > 1000000) && (buf_int <= 10000000))
						{
							Pulse22.Write_Value(0.01);
			
							Pulse22_Value = 10;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
						else
						{
							Pulse22.Write_Value(0.1);
			
							Pulse22_Value = 100;
							Pulse22_Steps = 1;
							Pulse22_Expo = 3;
						}
					}		
		
					Pulse22.RenderText();
					//trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
				}
				else MenuBtnFocus[MENU_PULSEWIDTH] = 4;  //PulseToggle = 2;
			}

			MenuItemChanged[3] = 1;				//redraw
			MenuItemChanged[5] = 1;				//redraw

			New_Menu = 15;
			Menu_Changed = 1;
			TriggerWayChanged = 1;
	
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

			Display::StatusUpdate();

			break;	
		}	
	
		// Cursor -> Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0 || LA_active) break;

			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
			else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;					
			else if (Cursor_Vertical_Active_Old == 4) MenuItemChanged[5] = 1;
			else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
			else if (Cursor_Horizontal_Active_Old == 4) MenuItemChanged[5] = 1;
			
			Cursor_Vertical_Active = 3;
			Cursor_Horizontal_Active = 2;
				
			if(Signal::_FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

							
			New_Menu = 16;
			Menu_Changed = 1;

			Display::DRAW_ALL_CURSOR();

			break;			
		}
		
		// Quick Print -> Send measure
		case 17 :
		{	
			//if (!QM_Enabled && !Cursor_Enabled) return;

			New_Menu = 17;
			//Menu_Changed = 1;
			
			CommIF::DUMPMEAS('S');
			return;
		}	


		// Hardware -> LED Test
		case 18 :
		{
			Hardware::LED_FunctionTest(1);
			break;	
		}	

	
		// Quick Measurement -> Settings
		case 19 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			Hardware::Reset_LED(5);
	
			if (MenuStatus[MENU_QUICKMEASURE][1] == 53)	// delay
			{
				New_Menu = 20;
				Menu_Changed = 1;
			}
			if (MenuStatus[MENU_QUICKMEASURE][1] == 61)	// phase
			{
				New_Menu = 21;
				Menu_Changed = 1;
			}

			break;
		}
		
		// Quick Measurement Delay Settings -> Add Delay Measurement
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			Display::QM_AddMeasurement();
			New_Menu = 20;
			Menu_Changed = 1;

			//QM_Vertical_Active = 0;
			//QM_Horizontal_Active = 0;
	
			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement Phase Settings -> Add Measurement
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }				

			Display::QM_AddMeasurement();

			New_Menu = 21;
			Menu_Changed = 1;

			Display::CALCQMDATA();

			break;
		}

		// Quick Measurement Threshold -> Upper
		case 22 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if (Quick_Measure_Threshold_btn_select == 1) MenuItemChanged[2] = 1;
			else if (Quick_Measure_Threshold_btn_select == 2) MenuItemChanged[3] = 1;

			Quick_Measure_Threshold_btn_select = 3;
			New_Menu = 22;
			Menu_Changed = 1;

			break;
		} 	

		// More Utilities - go to Hardware Menu		BF #004
		case 25 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			//Hardware::Reset_LED(5);	
			//Hardware::Set_LED(5);
			
			MenuBtnFocus[MENU_HARDWARE] = 0;	// reset focus
			
			New_Menu = MENU_HARDWARE;	// 18
			Menu_Changed = 1;

			break;
		}			


		// Math  1 + 2
		case 26 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (MenuStatus[MENU_MATH][4] == BTN_OFF)
			{
				//switch logic
				MenuStatus[MENU_MATH][2] = BTN_OFF;
				MenuStatus[MENU_MATH][3] = BTN_OFF;
				MenuStatus[MENU_MATH][4] = BTN_ON;		//set actual button to active

				MenuItemChanged[0] = 1;				//redraw scale
				MenuItemChanged[1] = 1;				//redraw offset

				MenuItemChanged[2] = 1;				//redraw buttons
				MenuItemChanged[3] = 1;				//redraw buttons
				MenuItemChanged[4] = 1;				//redraw buttons

				//math_scale = math_add_scale - 150;
				//Math_Offset = Math_Add_Offset;

				New_Menu = MENU_MATH;
				Menu_Changed = 1;
			}
			break;
		}	
	
		// Display FFT  - Layout (yellow buttons vs. mono design) -> not used anymore
/*		case 28 :
		{				
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			if(FFT_Layout)
			{ Display::FFT_DrawStatus(1); FFT_Layout = 0; }
			else
			FFT_Layout = 1; 

			Display::RefreshScreen();	// draw new FFT grid area 
            		ConfigChanged = 1;	

			New_Menu = 28;
			Menu_Changed = 1;
			break;
		}
*/
		// Quick Print OS-version -> not used
/*		case 30 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 30;
			//Menu_Changed = 1;
			
			//CommIF::Save2USB();
			break;					
		}
*/
		// Quick Print USB-export -> not used
		case 31 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = 30;
			//Menu_Changed = 1;
			
			//CommIF::Save2USB();
			break;					
		}				


	}
	
#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 5\n");		
#endif			

}
// BF insert end
//######################################################################################################################################################
// BF insert
//Function button 6 pushed
void UserIF::F6_Btnhandler(void)					// Button Handler for function button
{
	short pos = 0;

#ifdef _Debug_		
       	printf("F6 Btn start\n");
#endif


	//if(DrawMono==0){ MenuItemPushed[5] = 1; Hardware::ResetTimer3(TimerSecPeriod); }	// set push timer
	//if (ZeroPopupChanged > 0) Hardware::ResetTimer3();
				
	if ((Active_Menu == 1) && !Channel[eCh1].active) return;
	if ((Active_Menu == 2) && !Channel[eCh2].active) return;
	if ((Active_Menu == 3) && !Channel[eCh3].active) return;
	if ((Active_Menu == 4) && !Channel[eCh4].active) return;
	//if ((Active_Menu == 26) && (Channel[eChM].active == false)) return;
							
	if ((Active_Menu == 16) && !Cursor_Enabled) return;
	if ((Active_Menu == 19) && !QM_Enabled) return;
	if ((Active_Menu == 20) && !QM_Enabled) return;
	if ((Active_Menu == 21) && !QM_Enabled) return;
	if ((Active_Menu == 22) && !QM_Enabled) return;

	MenuItemChanged[5] = MenuAktive;
	Menu_Changed = MenuAktive;
			
	switch(Active_Menu)
	{	

		// Channel 1 -> dispatch traces
		case 1 :
		{
			Hardware::DispatchTraces();
			break;
		}	

		// Channel 2 -> dispatch traces
		case 2 :
		{
			Hardware::DispatchTraces();
			break;
		}	

		// Channel 3 -> dispatch traces
		case 3 :
		{
			Hardware::DispatchTraces();
			break;
		}	

		// Channel 4 -> dispatch traces
		case 4 :
		{
			Hardware::DispatchTraces();
			break;
		}	

		// Display -> go to display setup submenu
		case 5 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	

			Hardware::Reset_LED(5);

			New_Menu = MENU_DISPL_SETUP;
			Menu_Changed = 1;
			break;		
		}

		// Utilities -> More		BF #001
		case 6 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			Hardware::Set_LED(5);

			New_Menu = MENU_EXTUTILS;	// 25
			Menu_Changed = 1;
			break;		
		}			


		// Save / Recall -> restore settings
		case 8 :
		{
			if (!MenuAktive) return;

			RC_overlay = 0;
			RC_request = 0;
			
			Hardware::Restore_From_Flash();
			break;
		}	

		// Display Setup Submenu -> go back to Display menu
		case 9 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	

			if (Signal::_FFT_Mode == FFT_OFF)
			New_Menu = MENU_DISPLAY;
			else
			New_Menu = MENU_DISPL_FFT;

			Hardware::Set_LED(5);

			Menu_Changed = 1;
			break;		
		}			


		// Timebase Menu -> call USTB submenu
		case 10 :
		{
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			Hardware::Reset_LED(5);

			New_Menu = MENU_USTB;	//30
			Menu_Changed = 1;
			break;		
		}		


		// Trigger Mode  -> goto Trigger sub menu
		case 12 :
		{
			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;
			Hardware::Reset_LED(5);
			
			break;
		}	

		// Trigger sub menu -> Trigger Level Setting
		case 13 :
		{
			pos = -1;
			MenuPopupStep(50, &MenuStatus[MENU_TRIGGERSUB][5], &pos, &pos, MENU_TRIGGERSUB, 356, 2);
			
			New_Menu = MENU_TRIGGERSUB;
			Menu_Changed = 1;

			break;
		}	


		// Edge -> pretrigger
		case 14 :
		{
			if (USTB_Mode != USTB_OFF) return;
			Hardware::TRIG_AutoPretrigger();
			Display::DRAW_ALL_CURSOR();
		
			if (!AS_request)	//not in autoscale mode
			{
				if (Memory_Window_visible) 		// if Memory Window visible
					Display::RefreshMemoryBrowser(); 	// redraw Memory Window
				else
					Display::OpenMemoryBrowser(); 	// if Memory Window not visible yet, make it visible.
			}
			Hardware::ResetTimer3(RegTimerRotDelay);
			//if acquisision is stopped, signal processing must be triggered
			if(!Run)ACQ_NewData = 1;
		
			Menu_Changed = 1;	// refresh pre trigger value output

			break;
		}

		// Puls Width -> pretrigger
		case 15 :
		{
			//if (PulseToggle == 3) 	// pretrigger button is active -> second push
			if (MenuBtnFocus[MENU_PULSEWIDTH] == 5) 	// pretrigger button is active -> second push
			{
				if (USTB_Mode != USTB_OFF) return;
				Hardware::TRIG_AutoPretrigger();
				Display::DRAW_ALL_CURSOR();
			
				if (!AS_request)	//not in autoscale mode
				{
				if (Memory_Window_visible) 		// if Memory Window visible
					Display::RefreshMemoryBrowser(); 	// redraw Memory Window
				else
					Display::OpenMemoryBrowser(); 	// if Memory Window not visible yet, make it visible.
				}
				Hardware::ResetTimer3(RegTimerRotDelay);
				//if acquisision is stopped, signal processing must be triggered
				if(!Run)ACQ_NewData = 1;
			}
			else			// pretrigger button is not active -> set active
			{
				//if (PulseToggle == 1) MenuItemChanged[3] = 1;				//redraw
				//else if (PulseToggle == 2) MenuItemChanged[4] = 1;			//redraw
				
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 3) MenuItemChanged[3] = 1;		// redraw F4
				else if (MenuBtnFocus[MENU_PULSEWIDTH] == 4) MenuItemChanged[4] = 1;	// redraw F5

				MenuBtnFocus[MENU_PULSEWIDTH] = 5;					// set focus to F6
			}

			New_Menu = 15;
			Menu_Changed = 1;
			//TriggerWayChanged = 1;
			//Hardware::SetupTrigger();
			//Display::StatusUpdate();


			break;
		}


		// Cursor -> X1X2/Y1Y2
		case 16 :
		{		
			if (Cursor_Enabled == 0 || LA_active) break;
			
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			if (Cursor_Vertical_Active_Old == 1) MenuItemChanged[1] = 1;
			else if (Cursor_Vertical_Active_Old == 2) MenuItemChanged[2] = 1;
			else if (Cursor_Horizontal_Active_Old == 1) MenuItemChanged[3] = 1;
			else if (Cursor_Horizontal_Active_Old == 2) MenuItemChanged[4] = 1;
		
			Cursor_Both_Selected_Old = Cursor_Both_Selected;

			if ((Cursor_Vertical_Active == 4) || (Cursor_Horizontal_Active == 4))
			{
				if (Cursor_Both_Selected == 0)
				{
					Cursor_Both_Selected = 1;
					Cursor_Vertical_Active = 3;
					Cursor_Horizontal_Active = 4;
				}
				else
				{
					Cursor_Both_Selected = 0;
					Cursor_Vertical_Active = 4;
					Cursor_Horizontal_Active = 3;
				}
			}
			else
			{
				if (Cursor_Both_Selected == 0)
				{
					Cursor_Vertical_Active = 4;
					Cursor_Horizontal_Active = 3;
				}
				else
				{
					Cursor_Vertical_Active = 3;
					Cursor_Horizontal_Active = 4;
				}
			}
				
			if(Signal::_FFT_Mode != FFT_OFF)
			Display::FFT_CalcCursorData();
			else
			Display::CALCCURSORDATA();

			New_Menu = 16;
			Menu_Changed = 1;

			Display::DRAW_ALL_CURSOR();
			break;	
		}	

		// Quick Print - destination 
		case 17 :
		{	
			pos = -1;
			MenuPopupStep(39, &MenuStatus[MENU_QUICKPRINT][5], &pos, &pos, MENU_QUICKPRINT, 185, 2);

			MenuStatus[MENU_QP_USB][5] = MenuStatus[MENU_QUICKPRINT][5];	// synchronize menus

			QP_mode = MenuStatus[MENU_QUICKPRINT][5] - 185;			// set mode

			if (QP_mode == 0)
			{ New_Menu = MENU_QUICKPRINT; }	// PC
			else if (QP_mode == 1)
			{ New_Menu = MENU_QP_USB; }	// USB-host

			Menu_Changed = 1;

			break;
		}			

		
		// Hardware -> Back to Extended Utilities		BF #004
		case 18 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			//Hardware::Set_LED(5);
			New_Menu = MENU_EXTUTILS;	// 25
			Menu_Changed = 1;
			break;		
		}			

	
		// Quick Measurement -> Thresholds
		case 19 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			// init QM thresholds menu
			short QM_thr_ch = MenuStatus[MENU_QMTHRESHOLDS][0] - 27;

			MenuStatus[MENU_QMTHRESHOLDS][1] = thres_type[QM_thr_ch];
			Display::MenuPopupInit(27, MENU_QMTHRESHOLDS, 49);

			if (thres_type[QM_thr_ch] == 49)	// percent
			{
				QM_Threshold_lower.Init(10, 5, 93, 1, 0, 3, "", "", "%");
				QM_Threshold_middle.Init(50, 6, 94, 1, 0, 3, "", "", "%");
				QM_Threshold_upper.Init(90, 7, 95, 1, 0, 3, "", "", "%");
		
				QM_Threshold_lower.Write_Value((float)thres_low[QM_thr_ch]);	
				QM_Threshold_lower.RenderText();
				
				QM_Threshold_middle.Write_Value((float)thres_mdl[QM_thr_ch]);	
				QM_Threshold_middle.RenderText();
				
				QM_Threshold_upper.Write_Value((float)thres_up[QM_thr_ch]);	
				QM_Threshold_upper.RenderText();
			}
			else					// absolute
			{
				QM_Threshold_lower.Init(800, 50, 20000, 1, 2, 3, "", "", "mV");
				QM_Threshold_middle.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
				QM_Threshold_upper.Init(1.2, 0.05, 20, 1, 2, 3, "", "", "V");
			}

			New_Menu = MENU_QMTHRESHOLDS; //22
			Menu_Changed = 1;
			break;		
		}				
			
		// Quick Measurement Delay Settings -> back to QM menu
		case 20 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
			
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			New_Menu = MENU_QUICKMEASURE; //19
			Menu_Changed = 1;
			break;		
		}
		
		// Quick Measurement Phase Settings -> back to QM menu
		case 21 :
		{	
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			Hardware::Set_LED(5);

			New_Menu = MENU_QUICKMEASURE; //19
			Menu_Changed = 1;
			break;		
		}				
		
		// Quick Measurement Thresholds
		case 22 :
		{		
			//if (MenuStatus[MENU_TIMEBASE][2] == 241) break;
		
			if (QM_Enabled == 0) break;
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }

			New_Menu = MENU_QUICKMEASURE; //19
			Menu_Changed = 1;
			break;
		}	

		// More Utilities -> Back to Utilities			BF #001
		case 25 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			Hardware::Reset_LED(5);
			New_Menu = MENU_UTILITY; //6
			Menu_Changed = 1;
			break;		
		}			

	
		// FFT settings
		case 27 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = MENU_TIMEBASE; //10
			Menu_Changed = 1;
			break;	
		}		

		// Display FFT -> display setup submenu
		case 28 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = MENU_DISPL_SETUP;
			Menu_Changed = 1;
			break;		
		}	
					
		// Math settings
		case 29 :
		{		
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }
			
			New_Menu = MENU_MATH; //26
			Hardware::Reset_LED(5);
			Menu_Changed = 1;
			break;		
		}		
		
		// USTB -> go back to Timebase menu
		case 30 :
		{	
			if (MenuPopupActive > -1) { Display::DRAWMENUPOPDOWN(); }	
			
			Hardware::Reset_LED(5);

			New_Menu = MENU_TIMEBASE;	// 10
			Menu_Changed = 1;
			break;		
		}			

		// Quick Print USB-host - destination 
		case 31 :
		{	
			pos = -1;
			MenuPopupStep(39, &MenuStatus[MENU_QP_USB][5], &pos, &pos, MENU_QP_USB, 185, 2);

			MenuStatus[MENU_QUICKPRINT][5] = MenuStatus[MENU_QP_USB][5];	// synchronize menus
			
			QP_mode = MenuStatus[MENU_QP_USB][5] - 185;			// set mode

			if (QP_mode == 0)
			{ New_Menu = MENU_QUICKPRINT; }	// PC
			else if (QP_mode == 1)
			{ New_Menu = MENU_QP_USB; }	// USB-host
			
			Menu_Changed = 1;
			
			break;
		}			
		

	}		

#ifdef _Debug_		
	if (Debug_Mode) printf("Function Button 6\n");
#endif			


}
// BF insert end
//######################################################################################################################################################

char UserIF::MenuButtonCheck(char BtnNr)
{

	char ct, found = 0;
	
	for (ct = 0; ct < 6; ct++)
	{
		if (MenuItemPushed[ct] == 1) { found = 1; MenuItemPushed[ct] = 0; }// MenuItemPushed_old[ct] = 1; }
	}
	
	//if (found){ Hardware::ResetTimer3(TimerSecPeriod); }

	if (BtnNr > -1){ MenuItemPushed[BtnNr] = 1; }

	return found;
}

//######################################################################################################################################################
// BF menu popup logic - stepping up or down
void UserIF::MenuPopupStep(int MenuPopupNr, short *MenuStatusNr, short *MenuStatusNr2, short *MenuStatusNr3, int DrawMenuNr, int start, char dir)
{
	int x, y, pos = 0;
	int newpos = 0;
	
	unsigned short count = 0;

	Hardware::ResetTimer3(RegTimerRotDelay);

	if ((MenuPopupActive > -1) && (MenuPopupActive != MenuPopupNr)) { Display::DRAWMENUPOPDOWN(); }
	
	if (MenuPopupActive == MenuPopupNr)
	{
		count = MenuPopupDef[MenuPopupActive][1];

		// resize if there are deleted entries (for two channel DSOs)
		//for (x=0,y=count;x < y;x++)	
		//if (MenuPopupStatus[PopupNr][x] == 0) count--;

		
		// search active item
		for (x = 0; x < count; x++)
		{ if (MenuPopupStatus[MenuPopupNr][x] == 3) pos = x; }
		
		//BF from top to bottom down
		if (dir == 2)
		{
			newpos = -1;
			for (x = pos; x < count; x++)
			{
				if (MenuPopupStatus[MenuPopupNr][x] == 2)
				{
					newpos = x;
					break;
				}
			}	
			
			if (newpos == -1)
			{
				for (x = 0; x < pos; x++)
				{
					if (MenuPopupStatus[MenuPopupNr][x] == 2)
					{
						newpos = x;
						break;
					}
				}
			}
		}
		else //BF from bottom up
		{
			newpos = -1;
			for (x = pos; x >= 0; x--)
			{
		//            printf("DoStep (%d) down to %d = %d\n", MenuPopupNr, x, MenuPopupStatus[MenuPopupNr][x]);
				if (MenuPopupStatus[MenuPopupNr][x] == 2)
				{
					newpos = x;
					break;
				}
			}	
			
			if (newpos == -1)
			{
		//            printf("Nothing found\n");
				for (x = count; x > pos; x--)
				{
					if (MenuPopupStatus[MenuPopupNr][x] == 2)
					{
					newpos = x;
					break;
					}
				}
			}
		}    	
	
	//    printf("Pos : %2d NewPos : %2d dir : %2d\n", pos, newpos, dir);
		
		if (newpos != -1)
		{
			MenuPopupStatus[MenuPopupNr][pos] = 2;
			MenuPopupStatus[MenuPopupNr][newpos] = 3;
			
			MenuStatusNr[0] = start + newpos;
			if (MenuStatusNr2[0] > -1) { MenuStatusNr2[0] = start + newpos; }
			if (MenuStatusNr3[0] > -1) { MenuStatusNr3[0] = start + newpos; }	
		}

	}
	Display::DRAWMENUPOPUP(MenuPopupNr);	
}		
//######################################################################################################################################################
// Update channel depending parameters and menus
// BF cleaned up unused variables
void UserIF::UpdateChannel(uint8_t channel, uint32_t active)
{
	uint32_t *ptr_active = 0;
	int32_t x= 0;
	int32_t pos = 0;
	int8_t lednr = 0;

	
	// set local pointer to channel indicator
	switch(channel)
	{
		case eCh1:
		{
			ptr_active = &Channel[eCh1].active;
			lednr = 0;
			break;
		}	
		case eCh2:
		{
			ptr_active = &Channel[eCh2].active;
			lednr = 1;
			break;
		}
		case eCh3:
		{
			ptr_active = &Channel[eCh3].active;
			lednr = 2;
			break;
		}
		case eCh4:
		{
			ptr_active = &Channel[eCh4].active;
			lednr = 3;
			break;
		}
		case eChM:
		{
			ptr_active = &Channel[eChM].active;
			lednr = 4;	
			break;
		}		
	}
	
	//-----------------------------------------------------------
	//		set channel active
	//-----------------------------------------------------------
	if (active == 1)
	{
		if (!*ptr_active) ConfigChanged = 1;				//Save new values to flash

		*ptr_active = 1;						//set actual channel active

		if (channel < eChM)			// no math channel for these popups (trigger)
		{
			// Edge Source #019
			if (MenuPopupStatus[28][channel] == 1)
			{ MenuPopupStatus[28][channel] = 2; } 		

			// Pulse Width Source BF -> MenuPopup	#019
			if (MenuPopupStatus[7][channel] == 1)
			{ MenuPopupStatus[7][channel] = 2; } 	

		}
		
		// Cursor Source
		if (MenuPopupStatus[1][channel] == 1)
		{ MenuPopupStatus[1][channel] = 2; } 		

		// Quick Measurement Source
		if (MenuPopupStatus[3][channel] == 1)
		{ MenuPopupStatus[3][channel] = 2; } 		

		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][channel] == 1)
		{ MenuPopupStatus[5][channel] = 2; } 		

		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][channel] == 1)
		{ MenuPopupStatus[6][channel] = 2; } 		

		// Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][channel] == 1)
		{ MenuPopupStatus[24][channel] = 2; } 		

		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][channel] == 1)
		{ MenuPopupStatus[25][channel] = 2; } 		

		// Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][channel] == 1)
		{ MenuPopupStatus[26][channel] = 2; } 	

		Hardware::Set_LED(lednr);
	
	}

	//-----------------------------------------------------------
	//		set channel inactive
	//-----------------------------------------------------------
	else	
	{
		if (*ptr_active) ConfigChanged = 1;					//Save new values to flash

		*ptr_active= 0;								// set actual channel inactive

		// first check if math dependent sources are affected
		if ((Channel[eChM].active) && ((channel == eCh1) || (channel == eCh2)) )
		{
			//Channel[eChM].active = 0;
			UpdateChannel(eChM, 0);
			RemovePlane |= 0x10;
			Hardware::ClearPlanes();	
			Hardware::Reset_LED(4);		
		}


		if (channel < eChM)							// no math channel for these popups (trigger)
		{
			// Edge Source BF #019
			if (MenuPopupStatus[28][channel] == 3)				//if actual channel was active source
			{	
				pos = -1;
				for (x = 0;x < 4;x++)					//search next available source
				{
					if (MenuPopupStatus[28][x] == 2)
					{ pos = x; break; }
				}
	
				if (pos > -1)
				{
					MenuPopupStatus[28][pos] = 3;
					MenuStatus[MENU_TRIGGEREDGE][1] = 137 + pos;
				}
			}
		
			MenuPopupStatus[28][channel] = 1;				//set source inactive


			// Pulse Width Source  #019
			if (MenuPopupStatus[7][channel] == 3)				//if actual channel was active source
			{		
				pos = -1;
				for (x = 0;x < 5;x++)					//search next available source
				{
					if (MenuPopupStatus[7][x] == 2)
					{ pos = x; break; }
				}
				if (pos > -1)
				{
					MenuPopupStatus[7][pos] = 3;
					MenuStatus[MENU_PULSEWIDTH][0] = 137 + pos;
				}
			}	
	
			MenuPopupStatus[7][channel] = 1;				//set source inactive
		
			TriggerWayChanged = true;	
			TriggerLevelChanged = 1;
		
			Display::StatusUpdate();
			Hardware::SetupTrigger();
		}

			
		// Cursor Source -> actual channel was source?
		if (MenuPopupStatus[1][channel] == 3)
		{	
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[1][x] == 2)
				{ pos = x; break; }

				if(XY_Mode) x++;	//in XY-Mode only channel 1 + 3 are possible sources
			}
			if (pos > -1)
			{
				MenuPopupStatus[1][pos] = 3;
				MenuStatus[MENU_CURSOR][0] = 27 + pos;
			}
		}
		
		MenuPopupStatus[1][channel] = 1;
		
		// Quick Measurement Source
		if (MenuPopupStatus[3][channel] == 3)
		{		
			pos = -1;
			for (x = 0;x < 4;x++)
			{
				if (MenuPopupStatus[3][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[3][pos] = 3;
				QM_Source = MenuStatus[MENU_QUICKMEASURE][0] = 27 + pos;
			}
		}
		
		MenuPopupStatus[3][channel] = 1;
		
		// Quick Measurement Delay Settings Source1
		if (MenuPopupStatus[5][channel] == 3)
		{		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[5][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[5][pos] = 3;
				MenuStatus[MENU_QMDELAY][0] = 27 + pos;
			}
		}
		
		MenuPopupStatus[5][channel] = 1;
		
		// Quick Measurement Delay Settings Source2
		if (MenuPopupStatus[6][channel] == 3)
		{		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[6][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[6][pos] = 3;
				MenuStatus[MENU_QMDELAY][2] = 27 + pos;
			}
		}
		
		MenuPopupStatus[6][channel] = 1;
		
        	// Quick Measurement Phase Settings Source1
		if (MenuPopupStatus[24][channel - 1] == 3)
		{		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[24][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[24][pos] = 3;
				MenuStatus[21][0] = 27 + pos;
			}
		}
		
		MenuPopupStatus[24][channel] = 1;
		
		// Quick Measurement Phase Settings Source2
		if (MenuPopupStatus[25][channel] == 3)
		{		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[25][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[25][pos] = 3;
				MenuStatus[21][2] = 27 + pos;
			}
		}
		
		MenuPopupStatus[25][channel] = 1;		
		
        	// Quick Measurement Thresholds Source
		if (MenuPopupStatus[26][channel] == 3)
		{		
			pos = -1;
			for (x = 0;x < 5;x++)
			{
				if (MenuPopupStatus[26][x] == 2)
				{ pos = x; break; }
			}
			if (pos > -1)
			{
				MenuPopupStatus[26][pos] = 3;
				MenuStatus[MENU_QMTHRESHOLDS][0] = 27 + pos;
			}
		}
		
		MenuPopupStatus[26][channel] = 1;

		Hardware::Reset_LED(lednr);

	}	

	if (Cursor_Enabled)
	{
		if(XY_Mode)//set cursor source channels 
		{
			MenuPopupStatus[1][1] = 1; MenuPopupStatus[1][3] = 1; 	//gray out channel 2+4

			if(Channel[eCh1].active && Channel[eCh2].active)
			{ if(MenuPopupStatus[1][0] == 1) MenuPopupStatus[1][0] = 2; }
			else
			{ MenuPopupStatus[1][0] = 0; }
			
			if(Channel[eCh3].active && Channel[eCh4].active)
			{ if(MenuPopupStatus[1][2] == 1) MenuPopupStatus[1][2] = 2; }
			else
			{ MenuPopupStatus[1][2] = 0; }
		} 

		CursorChanged = 3;
		Cursor_Data_First_Draw = 1;
		
		if(Signal::_FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();
	
		Display::DrawCursorDeltaValues(1);
	}

	// check measurements for changed sources
//	if (QM_Enabled==0)
//	{
//		QM_Type[0] = QM_Type_Old[0];
//		QM_Type[1] = QM_Type_Old[1];
//		QM_Type[2] = QM_Type_Old[2];
//	}	
	
	pos = -1;					// reset change flag
	for (x = 0; x < 3; x++)
	{
		if (QM_Type[x] > 0)			// main source
		{
			if ((QM_Channel[x] == 1) && !Channel[eCh1].active)
			{ QM_Type[x] = 0; QM_Channel[x] = QM_Source - 26; QM_Changed[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 2) && !Channel[eCh2].active)
			{ QM_Type[x] = 0; QM_Channel[x] = QM_Source - 26; QM_Changed[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 3) && !Channel[eCh3].active)
			{ QM_Type[x] = 0; QM_Channel[x] = QM_Source - 26; QM_Changed[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 4) && !Channel[eCh4].active)
			{ QM_Type[x] = 0; QM_Channel[x] = QM_Source - 26; QM_Changed[x] = 0; pos = 1; }
			if ((QM_Channel[x] == 5) && !Channel[eChM].active)
			{ QM_Type[x] = 0; QM_Channel[x] = QM_Source - 26; QM_Changed[x] = 0; pos = 1; }
		}

		if (QM_Type[x] == 2 || QM_Type[x] == 10) // delay and phase second source
		{
			if ((QM_Second_Channel[x] == 1) && !Channel[eCh1].active) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Second_Channel[x] == 2) && !Channel[eCh2].active) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Second_Channel[x] == 3) && !Channel[eCh3].active) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Second_Channel[x] == 4) && !Channel[eCh4].active) { QM_Type[x] = 0; pos = 1; }
			if ((QM_Second_Channel[x] == 5) && !Channel[eChM].active) { QM_Type[x] = 0; pos = 1; }
		}
	}

	if (pos == 1)					// QM type changed
	{
		Quick_Measure_First_Draw = 1;
	
		if (QM_Type[0] == 0 && QM_Type[1] == 0 && QM_Type[2] == 0)
		{ QM_Vertical_Active = 0; QM_Horizontal_Active = 0; }
		else
		{
			// shift remaining measurements to the free slots
			if (QM_Type[1] == 0)
			{ 
				QM_Type[1] = QM_Type[2]; QM_Type[2] = 0;
				QM_Channel[1] = QM_Channel[2];
				QM_Second_Channel[1] = QM_Second_Channel[2];
				QM_CHI_Edge[1] = QM_CHI_Edge[2];
				QM_CHII_Edge[1] = QM_CHII_Edge[2];
			}

			if (QM_Type[0] == 0)
			{ 
				QM_Type[0] = QM_Type[1]; QM_Type[1] = QM_Type[2]; QM_Type[2] = 0;
				QM_Channel[0] = QM_Channel[1];
				QM_Channel[1] = QM_Channel[2];
				QM_Second_Channel[0] = QM_Second_Channel[1];
				QM_Second_Channel[1] = QM_Second_Channel[2];
				QM_CHI_Edge[0] = QM_CHI_Edge[1];
				QM_CHI_Edge[1] = QM_CHI_Edge[2];
				QM_CHII_Edge[0] = QM_CHII_Edge[1];
				QM_CHII_Edge[1] = QM_CHII_Edge[2];
			}
		}

		// if QM was not active, don't restart with invalid measurements
		//QM_Type_Old[0] = QM_Type[0];
		//QM_Type_Old[1] = QM_Type[1];
		//QM_Type_Old[2] = QM_Type[2];

	}
/*
	// reset slots if QM is not active
	if (QM_Enabled==0)
	{
		QM_Type[0] = 0;
		QM_Type[1] = 0;
		QM_Type[2] = 0;
	}	
	else
	{ Display::CALCQMDATA(); }
*/
	if (QM_Enabled){ Display::CALCQMDATA(); }



	// get number of active channels for global use -> Math channel has to be handled seperately
	Channels_Active = Channel[eCh1].active + Channel[eCh2].active + Channel[eCh3].active + Channel[eCh4].active;

    //printf("********  Update channel %d done  ***********\r\n", channel);
}
//######################################################################################################################################################
// Memory browser
void UserIF::ON_MemoryPosition(void)
{
	int pos = 0;
	int cd_size_buf = (int)(Cursor_Delayed_Size >> 1);
	int rot_buf = RotarySteps;

	if (Signal::_FFT_Mode != FFT_OFF) return;

	if ((MenuStatus[MENU_TIMEBASE][1] == BTN_OFF) || (MenuStatus[MENU_TIMEBASE][1] == INACTIVE))	// Main TB
	{

/*	
		if (draw_factor < 3 || MainTimebase == 6)
		{ rot_buf =  ((rot_buf * rot_buf * rot_buf)>>1) + rot_buf; }
		else if (draw_factor > 5 )
		{ rot_buf =  ((rot_buf * rot_buf * rot_buf) / (draw_factor/5)) + rot_buf; }
		else
		{ rot_buf = (rot_buf * rot_buf) + rot_buf; }
*/	
		if (rot_buf < 11)
		{ rot_buf = (((rot_buf*rot_buf)>>1) + 1) * draw_factor; }	//flat square 0.5X²
		else
		{
			if (MainTimebase < 7 || USTB_Mode != USTB_OFF)
			rot_buf = ((rot_buf*rot_buf)<<1)*draw_factor;		//straight square 2X²
			else
			rot_buf = rot_buf*rot_buf*draw_factor;			//square X²
		}

		//printf("RotarySteps = %d  rot_buf = %d\r\n",RotarySteps, rot_buf);


		if (RotaryDirection)
		{
			if ((MemWinStart + SignalMemSize + rot_buf) < MemoryEnd)			//BF #023
			{ MemWinStart = MemWinStart + rot_buf; }
			else
			{ MemWinStart = MemoryEnd - SignalMemSize; }
		}
		else
		{
			if ((MemWinStart - rot_buf) > MemStartOffs)
			{ MemWinStart = MemWinStart - rot_buf; }
			else
			{ MemWinStart = MemStartOffs; }
		}
	
	}
	else  												// Delayed TB
	{
		if ((rot_buf > 5) && (rot_buf < 11)) rot_buf = rot_buf * 3;
		else if (rot_buf > 10) rot_buf = rot_buf * 7;	
		
		if (RotaryDirection)
		{
			if ((dmode_Window_Offset_Pos + rot_buf) < (300 - cd_size_buf)) dmode_Window_Offset_Pos += rot_buf;
			else dmode_Window_Offset_Pos = 300 - cd_size_buf;
		}
		else
		{
			if ((dmode_Window_Offset_Pos - rot_buf) > (-300 + cd_size_buf)) dmode_Window_Offset_Pos -= rot_buf;
			else dmode_Window_Offset_Pos = (-300 + cd_size_buf);
		}
	}

	Display::RecalcTimeParameters();
//BF test del	Hardware::SetupADC();
//BF test del	Display::CALCPRETRIGGER();

	if ((MenuStatus[MENU_TIMEBASE][1] == BTN_OFF) || (MenuStatus[MENU_TIMEBASE][1] == INACTIVE)) 
	{
		if (Memory_Window_visible) 		// if Memory Window visible
			Display::RefreshMemoryBrowser(); 	// redraw Memory Window
		else
			Display::OpenMemoryBrowser(); 	// if Memory Window not visible yet, make it visible.
     	}
    
	Display::DRAW_ALL_CURSOR();

	

    //Display::DRAWSTATUS(5, 1);									// Draw Pre Trigger

	//if acquisition is stopped signal processing must be triggered
	if(!Run)ACQ_NewData = 1;


}
//######################################################################################################################################################
// Trigger level
void UserIF::ON_TriggerLevel(void)
{
	
	//if (MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_TV) return;						//BF TV -> no level
	if ((MenuStatus[MENU_TRIGGEREDGE][1] == TRIG_EXT) && (MenuPopupStatus[8][2] == 3)) return; 	//BF Line -> no level
	if (XY_Mode) return;

	//if (FFT_Mode != FFT_OFF) return;	//BF test
	if (USTB_Mode != USTB_OFF) return;

	if (RC_overlay) return;	
	if (RC_request) return;	
	//if (triggering == 0) return;
/*BF del
    if ((RotarySteps > 5) && (RotarySteps < 11)) RotarySteps = RotarySteps * 3;
    else if (RotarySteps > 10) RotarySteps = RotarySteps * 7;
*/
	RotarySteps = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	//BF new square function characteristic 1/4 * X² + x

	if (RotaryDirection == 0)	//BF changed direction #019
	{
		//BF test #111 if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
			
		switch(Hardware::_TriggerSource)
		{
			case eTrigCh1: if ((Trigger_Pos_CH1 + RotarySteps) < GRID_HEIGHT){ Trigger_Pos_CH1 = Trigger_Pos_CH1 + RotarySteps; }else{ Trigger_Pos_CH1 = GRID_HEIGHT; } break;
			case eTrigCh2: if ((Trigger_Pos_CH2 + RotarySteps) < GRID_HEIGHT){ Trigger_Pos_CH2 = Trigger_Pos_CH2 + RotarySteps; }else{ Trigger_Pos_CH2 = GRID_HEIGHT; } break;
			case eTrigCh3: if ((Trigger_Pos_CH3 + RotarySteps) < GRID_HEIGHT){ Trigger_Pos_CH3 = Trigger_Pos_CH3 + RotarySteps; }else{ Trigger_Pos_CH3 = GRID_HEIGHT; } break;
			case eTrigCh4: if ((Trigger_Pos_CH4 + RotarySteps) < GRID_HEIGHT){ Trigger_Pos_CH4 = Trigger_Pos_CH4 + RotarySteps; }else{ Trigger_Pos_CH4 = GRID_HEIGHT; } break;
			case eTrigExt: 	// fall through
			case eTrigTV: if (Trigger_Pos_CHE > 0){ Trigger_Pos_CHE--; }else{ Trigger_Pos_CHE = 0; } break;
		}
	
	}
	else
	{
		//BF test #111 if (MenuButtonCheck(-1)) { New_Menu = Active_Menu; Menu_Changed = 1; }
		
		switch(Hardware::_TriggerSource)
		{
			case eTrigCh1: if ((Trigger_Pos_CH1 - RotarySteps) > 0){ Trigger_Pos_CH1 = Trigger_Pos_CH1 - RotarySteps; }else{ Trigger_Pos_CH1 = 0; } break;
			case eTrigCh2: if ((Trigger_Pos_CH2 - RotarySteps) > 0){ Trigger_Pos_CH2 = Trigger_Pos_CH2 - RotarySteps; }else{ Trigger_Pos_CH2 = 0; } break;
			case eTrigCh3: if ((Trigger_Pos_CH3 - RotarySteps) > 0){ Trigger_Pos_CH3 = Trigger_Pos_CH3 - RotarySteps; }else{ Trigger_Pos_CH3 = 0; } break;
			case eTrigCh4: if ((Trigger_Pos_CH4 - RotarySteps) > 0){ Trigger_Pos_CH4 = Trigger_Pos_CH4 - RotarySteps; }else{ Trigger_Pos_CH4 = 0; } break;
			case eTrigExt:   // fall through
			case eTrigTV: if (Trigger_Pos_CHE < 132){ Trigger_Pos_CHE++; }else{ Trigger_Pos_CHE = 132; } break;
		}
	
	}
	
	Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

	Display::DRAWSTATUS(6, 1);			// Draw Trigger Level
	VS_TrigLevelChanged = (char)(Hardware::_TriggerSource + 1);

	Hardware::ResetTimer3(RegTimerRotDelay);	// set dotted line timeout counter
	TriggerLevelActive = 1;				// activate dotted line


}

//######################################################################################################################################################
// timebase wheel handler
void UserIF::ON_Timebase(void)
{
	

	if (Signal::_FFT_Mode != FFT_OFF)	// FFT-mode active?
	{
		if (MainTimebase >= 25 && !RotaryDirection) return;			// no ultra slow timebases for FFT
	}

	if (!Run)				// stop mode active?
	{ 
		if (Signal::_FFT_Mode != FFT_OFF || USTB_Mode != USTB_OFF) return;	// no TB change in FFT-mode or USTB-mode if acquisition is stopped
	}

	if (RotarySteps != 0)
	{	
		//--------------------------------------------------------------------------------------------------------------------------
		if (RotaryDirection)	//clockwise -> decrement timebase
		{
			// Delayed Mode
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
			{
				if (DelayedTimebase < Dm_Sel_Tb_End[MainTimebase])
				{ DelayedTimebase++; }
			}
			// Main Mode
			else		
			{	  	
				if (!Run && !SingleShot)	//BF Stop / Single / Recall / Overlay
				{
					//BF #023 Lower virtual timebases are the same as the 
					//delayed timebases but with inverted sign 
					if ((VirtualTimebase >= (-1 * Dm_Sel_Tb_End[MainTimebase])) && ((MainTimebase + VirtualTimebase) > 0))
					{ VirtualTimebase--; }
				}
				else	///Run == 1 || SingleShot == 1
				{
					if (MainTimebase > 0)
					{ MainTimebase--; }
				}
			}
		}
		//--------------------------------------------------------------------------------------------------------------------------
		else	//direction is counterclockwise -> increment timebase
		{
			// Delayed Mode
			if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
			{
				if (DelayedTimebase > 0)
				{ DelayedTimebase--; }
			}  
			else	// Main Mode
			{
				if (!Run && !SingleShot)	//BF Stop / Single / Recall / Overlay
				{
					//BF #023 only for non USTB ranges, higher timebases are limited by the number of ADC-values (16384 / Zoomfactor > 600)
					if (VirtualTimebase < 0)	// in the first step only allow the lower timebases because the higher timbases are making some problems
					{ VirtualTimebase++; }
				}	
				else	//Run == 1 || SingleShot == 1
				{
					if (MainTimebase < 35)
					{ MainTimebase++; }
				}
			}		
		}
		//--------------------------------------------------------------------------------------------------------------------------
	}
	
	if (MenuStatus[MENU_DISPLAY][0] > 360) Hardware::ClearPlanes();			// reset persistent display

	if (ACQ_PeakDetect)
	{
		if (MainTimebase < 4)
			MainTimebase = 4;
		else if (MainTimebase > 25)
			MainTimebase = 25;
	}
  	
	//------------------------------------------------------------
	//BF add new ultra slow timebase mode
	//------------------------------------------------------------
	if (MainTimebase > 25) 								//new timebase > 500mS/Div? -> USTB
	{
		if(USTB_Mode == USTB_OFF)						// if USTB was not active before -> activate USTB mode
		{	// normal TB => USTB
			USTB_Mode = MenuStatus[MENU_USTB][0] - USTB_Dir;		// get the selected USTB mode from USTB menu
			
			ACQ_HighSpeed = 1;						// USTB is using the fast acquisition mode 
			
			MenuStatus[MENU_TIMEBASE][1] = INACTIVE;
			MenuStatus[MENU_TIMEBASE][2] = INACTIVE;			// gray out XY
			MenuStatus[MENU_TIMEBASE][3] = INACTIVE;			// gray out FFT
			MenuStatus[MENU_SAVE][3] = INACTIVE;				// gray out overlay button

			New_Menu = MENU_TIMEBASE;					// switch to timebase menu
			MenuAktive = 1;							// set menu active
			MenuAktive_old = 0;						// trigger button refresh
			Menu_Changed = 1;
			
			if(QM_Enabled)
			{
				QM_Enabled = 0;						// no QM because of timing problems
				Display::DrawQMData(0);					// remove QM data
			}

			LED_ON[5]  = 0;
			LED_ON[7]  = 0;	
			LED_ON[8]  = 1;
			LED_ON[9]  = 0;							//left LED (green) off -> trigger not active 
			LED_ON[10] = 0;
			LED_ON[11] = 0;							//right LED (red) off -> no acquisition event 
			LED_ON[14] = 0;							// single red off
			LED_ON[15] = 1;							// single green on

			Hardware::Send_LED();
	
			SingleShot = 0;
			TriggerModeChanged = 1;						// update status area for USTB data
			TriggerWayChanged = 1;
			TriggerLevelChanged = 1;
			Display::StatusUpdate();					// update status bar
		}
	}
	else										// new timebase is normal timebase (< 26)
	{	
		if (USTB_Mode != USTB_OFF)						// coming from USTB mode?
		{	// USTB => normal TB 
			Hardware::Stop_Timer2();

			USTB_Mode = USTB_OFF;						// switch off USTB mode
		
			MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;				// reactivate Delayed button
			MenuStatus[MENU_TIMEBASE][2] = BTN_OFF;				// reactivate XY button
			MenuStatus[MENU_TIMEBASE][3] = BTN_OFF;				// reactivate FFT button
			MenuStatus[MENU_SAVE][3] = 146;					// reactivate overlay button

			New_Menu = MENU_TIMEBASE;					// switch to timebase menu
			MenuAktive = 1;							// set menu active
			MenuAktive_old = 0;						// trigger button refresh
			Menu_Changed = 1;
			
			LED_ON[9]  = 1;							// left LED (green) on -> trigger is armed 
			LED_ON[11] = 0;							// right LED (red) on -> no triggerevent 
			LED_ON[14] = 0;							// Single off/green
			if (MenuStatus[MENU_TRIGGERSUB][3] == 126)			// direct manual trigger
			LED_ON[15] = 1;
			else
			LED_ON[15] = 0;

			Hardware::Send_LED();

			SingleShot = 0;
			TriggerModeChanged = 1;						// update status area for trigger data
			TriggerWayChanged = 1;
			TriggerLevelChanged = 1;
			Display::StatusUpdate();					// update status bar
		}
		
		if (MainTimebase < 11)
			ACQ_HighSpeed = 1;
		else
			ACQ_HighSpeed = 0;


	} 

		
	Display::DRAWSTATUS(0, 1);							// update timebase status values
	Display::RecalcTimeParameters();						// calculate time parameters and ADC readout offset
	

	//------------------------------------------------
	//         memory window
	//------------------------------------------------
	if (Signal::_FFT_Mode == FFT_OFF && !AS_request && !RC_request)	
	{
		if (Memory_Window_visible) 						// if Memory Window visible
			Display::RefreshMemoryBrowser(); 				// redraw Memory Window
		else
			Display::OpenMemoryBrowser(); 					// if Memory Window not visible yet, make it visible.
	}
	else
	{
		if (Memory_Window_visible) 
		Display::CloseMemoryBrowser();						//close memory window
	}

 	//-------------------------------------------------
	//         Cursor
	//-------------------------------------------------
	if (Cursor_Enabled)
	{
		if (Active_Menu == MENU_CURSOR)
		{ New_Menu = Active_Menu; }

		Menu_Changed = 1;
		CursorChanged = 1;
	}
	
	if(Signal::_FFT_Mode != FFT_OFF)
	{	
		Display::FFT_CalcCursorData();
		Display::FFT_DrawStatus(0);						// redraw FFT status informations 
	}	
	else
	{
		Display::CALCCURSORDATA();
	}
		
	if (ADC_Started)								//stop ADC
	{
		int32_t timeout = 0;
		
		la_pulse->np_piodata = 0x01;						//stop record Port On
		la_pulse->np_piodata = 0x00;						//stop record Port Off	

		while (acq_ready->np_piodata == 0x01 && timeout < 100)
		{nr_delay(2); timeout++;}
		ADC_Started = false;
	}

	//Hardware::SetDelayTimer2(30, &Hardware::SetupTrigger);			// load trigger setup to execution queue -> delay 0.5s
	Hardware::SetupTrigger();							//set ADC depending registers
	
	if(USTB_Mode == USTB_OFF)
	{	// normal TB
		if (MenuStatus[MENU_ACQUIRE][3]==43) Signal::FIR_buildSincLookupTable();	// calculate new lookup table for sinc interpolation

		Display::CALCPRETRIGGER();

		if(Active_Menu == MENU_TRIGGEREDGE)
		{
			// refresh pretrigger value on F-button
			Display::ClearMenuItemTextAsm(5, 36320, 16);			// clear text (old value)
			Display::DrawMenuItem(MENU_TRIGGEREDGE,5, 1);//, 0);		// write text (new value) in second button row	
			UpdateMenuTextPlane = true;					// trigger plane transfer
		}
		else if(Active_Menu == MENU_PULSEWIDTH)
		{
			// refresh pretrigger value on F-button
			Display::ClearMenuItemTextAsm(5, 36320, 16);			// clear text (old value)
			Display::DrawMenuItem(MENU_PULSEWIDTH,5, 1);//, 0);		// write text (new value) in second button row	
			UpdateMenuTextPlane = true;					// trigger plane transfer
		}

		//No delayed mode for TB 2ns
		if (MainTimebase == 0)
		{ MenuStatus[MENU_TIMEBASE][1] = INACTIVE; }	
		else
		{	// restore delayed button depending on the other buttons in the menu (radio button logic)
			if(MenuStatus[MENU_TIMEBASE][0] == BTN_ON || MenuStatus[MENU_TIMEBASE][2] == BTN_ON || MenuStatus[MENU_TIMEBASE][3] == BTN_ON)	// if any other button is active
			MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;												// set button off
			else
			MenuStatus[MENU_TIMEBASE][1] = BTN_ON;												// else set button on
		}		
		
		S1Ptr = SIGNAL1;							//set signal pointers to unfiltered signal
		S2Ptr = SIGNAL2;							//set signal pointers to unfiltered signal
		S3Ptr = SIGNAL3;							//set signal pointers to unfiltered signal
		S4Ptr = SIGNAL4;							//set signal pointers to unfiltered signal
		SMPtr = SIGNALM;
		
		if ((SingleShot || Run) && !AS_request && !RC_request)			//BF add new start/stop logic -> restart ADC only if it is really needed
		{ Hardware::Start_Record(); } 						//start normal data acquistion
		else
		{ ACQ_NewData = 1;}							//trigger signal processing
		
	}
	else										//if USTB is active, start timer controlled acquisition
	{ 	// USTB
		Signal::USTB_clearBuffer();						//clear all buffers
		Hardware::Reset_Timer2();						//start USTB data acquistion
	}

	Display::OssSingle(eOssFilt, 1, 1);
	Display::DRAW_ALL_CURSOR();
	
	if (Active_Menu == MENU_TIMEBASE)					// Main/Delayed menu active? -> if yes draw changes immediatly
	{
		New_Menu = Active_Menu;
		MenuAktive = 1;							// set menu active
		MenuAktive_old = 0;						// trigger button refresh
		Menu_Changed = 1;
	}

	//ConfigChanged = 1;								// save new settings to flash -> done in rotary ISR
}
//######################################################################################################################################################
// call wheel handler routines depending on used wheel
void UserIF::Rotary_Interface(void)
{

	if (RotarySteps == 0) return;
	
	RotaryDirectionMemPulse = RotaryDirection;							// remember direction for further use

	UI_request = 0;											//reset UI-request flag	

	//printf("Steps = %i Dir = %i \r\n", RotarySteps, RotaryDirection);

	Hardware::ResetTimer3(RegTimerRotDelay);

	if ((RotarySwitch & 0x00000001) == 0x00000001) { ON_MemoryPosition(); RC_user_if = 1; }	//memory browser
	else if ((RotarySwitch & 0x00000002) == 0x00000002) { ON_TriggerLevel(); }			//trigger level
	else if ((RotarySwitch & 0x00000004) == 0x00000004) { ON_MainWheel(); RC_user_if = 1; }	//main wheel
	else if ((RotarySwitch & 0x00000008) == 0x00000008) { ON_Timebase(); RC_user_if = 1; }
	else if ((RotarySwitch & 0x00000010) == 0x00000010 && Run) { ON_Zero_Channel_2(); }
	else if ((RotarySwitch & 0x00000020) == 0x00000020 && Run) { ON_Voltage_Channel_2(); }
	else if ((RotarySwitch & 0x00000040) == 0x00000040 && Run) { ON_Voltage_Channel_1(); }
	else if ((RotarySwitch & 0x00000080) == 0x00000080 && Run) { ON_Zero_Channel_1(); }
	else if ((RotarySwitch & 0x00000100) == 0x00000100 && Run) { ON_Zero_Channel_4(); }
	else if ((RotarySwitch & 0x00000200) == 0x00000200 && Run) { ON_Voltage_Channel_4(); }
	else if ((RotarySwitch & 0x00000400) == 0x00000400 && Run) { ON_Voltage_Channel_3(); }
	else if ((RotarySwitch & 0x00000800) == 0x00000800 && Run) { ON_Zero_Channel_3(); }
	
	RotarySteps = 0;										// reset rotary step counter

}
//##########################################################################################################################################
// Set voltage range for channel 1
void UserIF::ON_Voltage_Channel_1(void)
{

	if (!Channel[eCh1].active) return;

	// adjust voltage range
	if (RotaryDirection == 1)
	{	// switch to next lower range
		if (Selected_Voltage_CH1 == e10mV) return;		// lowest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH1 - 1) > e10mV)
		{ Selected_Voltage_CH1 --; }
		else
		{ Selected_Voltage_CH1 = e10mV; }
	}
	else
	{	// switch to next higher range
		if (Selected_Voltage_CH1 == e5V) return; 		// highest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH1 + 1) < e5V)
		{ Selected_Voltage_CH1 ++; }
		else
		{ Selected_Voltage_CH1 = e5V; }	
	}
	
	if (Cursor_Enabled)
	{
		if(Signal::_FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	
	if ((Active_Menu == MENU_CURSOR) || Active_Menu == MENU_QUICKMEASURE)
	{
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	
	Hardware::SetSwitches(eCh1, Selected_Voltage_CH1);			// set switches on the mainboard
	VoltageChangedCh1 = 1;
	
	Display::DRAWSTATUS(1, 1);					// draw voltage channel 1

	if (MenuStatus[MENU_TRIGGERSUB][5] == 356)			// trigger level constant grid position -> scaling level
	{ Display::DRAWSTATUS(6, 1); }					// display new trigger level
	else
	{ Display::TriggerLevelVoltageToPos(); }			// scale trigger level to the new range	
	
	if(Signal::_FFT_Mode != FFT_OFF)
	Signal::FFT_buildScaleLookupTable();
	
	RotarySteps = 0;						// reset step counter to prevent zero level shifting
	ON_Zero_Channel_1();
}
//##########################################################################################################################################
//set zerolevel for channel 1 (zero wheel handler)
void UserIF::ON_Zero_Channel_1(void)
{
	int buffer = RotarySteps;
	int lVirtualZero;
	int lVZL_Old;
	short lCorrect;

	
	if (!Channel[eCh1].active) return;

	if (Signal::_FFT_Mode != FFT_OFF){ RotarySteps = 0; return; }
	

	if (RotarySteps != 0)
	{
		if (RotaryDirection == 0)	//counter clockwise rotary direction 
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH1;

				if ((Virtual_ZeroLevelXYCH1 + buffer) < 4095)
				{ Virtual_ZeroLevelXYCH1 += buffer; }		
				else
				{ Virtual_ZeroLevelXYCH1 = 4095; }				// limiter

				// correct trigger level position on screen
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL_Old + Virtual_ZeroLevelXYCH1;	//keep triggerlevel

			}
			else	//Main mode TY ( moving down )
			{
				lVZL_Old = Virtual_ZeroLevelCH1;

				//if (buffer > 8)
				if (buffer > 10)
				{
					int div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH1/steps;			// in which div we are?

					if(Virtual_ZeroLevelCH1 < 0)				// negative level
					{ if ((div * steps) == Virtual_ZeroLevelCH1){div++;} }	// zero level was on grid division before -> next div
					else							// positive level
					{ div++; } 						// next grid division
					
					Virtual_ZeroLevelCH1 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH1 += buffer; }

				if (Virtual_ZeroLevelCH1 > 4095)				// limiter
				{ Virtual_ZeroLevelCH1 = 4095; } 

				// correct trigger level position on screen
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
			}


		}
		else	//clockwise rotary direction
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH1;
				
				if ((Virtual_ZeroLevelXYCH1 - buffer) > -4095)  
				{ Virtual_ZeroLevelXYCH1 -= buffer; }		
				else
				{ Virtual_ZeroLevelXYCH1 = -4095; }       			// limiter
	
				// correct trigger level position on screen
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL_Old + Virtual_ZeroLevelXYCH1;	//keep triggerlevel
			}
			else	// main mode (moving up)
			{
				lVZL_Old = Virtual_ZeroLevelCH1;

				//if (buffer > 8)
				if (buffer > 10)
				{
					int div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH1/steps;			// in which div we are? 

					if(Virtual_ZeroLevelCH1 > 0)				// positive level
					{ if ((div * steps) == Virtual_ZeroLevelCH1){div--;} }	// zero level was on grid division before -> next div
					else							// negative level	
					{ div--; } 						// next grid division
					
					Virtual_ZeroLevelCH1 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH1 -= buffer; }	
						
				if (Virtual_ZeroLevelCH1 < -4095)	 			// limiter
				{ Virtual_ZeroLevelCH1 = -4095; }

				// correct trigger level position on screen
				Trigger_Pos_CH1 = Trigger_Pos_CH1 - lVZL_Old + Virtual_ZeroLevelCH1;	//keep triggerlevel
			}

		}

		VS_ZeroLevelChanged = 1;	//flag for zero sign drawing
   		ZL_changed = 1;			//flag for signal drawing
	}

	if(LA_active) return;


	// correct trigger level registers if this is the active trigger channel
	if (Hardware::_TriggerSource == eTrigCh1)
	{ Hardware::SetDelayTimer2(30, &Hardware::SetupTrigger); }	// load trigger setup to execution queue	

	
	//---------------------------------------
	// 		setup DAC
	//---------------------------------------
	if (XY_Mode)
	{
		ZeroLevelCH1 = Virtual_ZeroLevelXYCH1 + (GRID_XY / 2);
		if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
		if (ZeroLevelCH1 > GRID_XY) ZeroLevelCH1 = GRID_XY;
		
		lVirtualZero = Virtual_ZeroLevelXYCH1;
	}
	else
	{
		ZeroLevelCH1 = Virtual_ZeroLevelCH1 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH1 < 0) ZeroLevelCH1 = 0;
		if (ZeroLevelCH1 > (GRID_HEIGHT + 1)) ZeroLevelCH1 = (GRID_HEIGHT + 1);
		
		lVirtualZero = Virtual_ZeroLevelCH1;
	}

	lCorrect = (short)Hardware::_ADC_VirtualZero[0];					// store old zero level

	Hardware::_ADC_VirtualZero[0] = (int)(ADC_ZERO + ((float)lVirtualZero / ScaleFactor[Selected_Voltage_CH1]));

	if (Hardware::_ADC_VirtualZero[0] > 255) Hardware::_ADC_VirtualZero[0] = 255;	//Limiter
	else if (Hardware::_ADC_VirtualZero[0] < 0) Hardware::_ADC_VirtualZero[0] = 0;

	switch(Selected_Voltage_CH1)
	{
		case 0: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][0]; break;//1 mV
		case 1: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][1]; break;//2 mV
		case 2: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][2]; break;//5 mV
	
		case 3: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][0]; break;//10 mV
		case 4: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][1]; break;//20 mV
		case 5: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][2]; break;//50 mV
	
		case 6: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][0]; break;//100 mV
		case 7: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][1]; break;//200 mV
		case 8: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][2]; break;//500 mV

		case 9:  CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][0]; break;// 1 V
		case 10: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][1]; break;// 2 V
		case 11: CH1_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][0][2]; break;// 5 V
	}
	
	// clip to 16 bit range
	if (CH1_DAC_Offset < 0) CH1_DAC_Offset = 0;
	else if (CH1_DAC_Offset >= 65536) CH1_DAC_Offset = 65535;

	//ADC_VirtualZero_CH1 = (CH1_DAC_Offset - DAC_MIDSCALE) >> 3;// - ADC_ZERO;



	if (USTB_Mode != USTB_OFF && RotarySteps != 0)				// zero level changed in USTB mode?
	{
		lCorrect -= (short)Hardware::_ADC_VirtualZero[0];		// get difference between old and new zero level for correction
	
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();

	    	Hardware::SetDacOffset(eCh1);

		if (USTB_Dir == USTB_FORWARD)
		{
			for (int32_t i=MemStartOffs;i<USTB_idx;i++)		// correct from start to now
			{ S1Ptr[i] -= (uint8_t)lCorrect; }

			Hardware::Start_Record(); nr_delay(10);			// spike suppression

			S1Ptr[USTB_idx-1] = S1Ptr[USTB_idx-2];

			Hardware::Reset_Timer2();

			for (int32_t i=USTB_idx;i<=MemoryEnd;i++)		// correct from now to buffer end
			{ S1Ptr[i] -= (uint8_t)lCorrect;}
		}
		else
		{
			for (int32_t i=MemoryEnd;i>USTB_idx;i--)		// correct fom buffer end to now
			{ S1Ptr[i] -= (uint8_t)lCorrect; }

			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S1Ptr[USTB_idx+1] = SIGNAL1[USTB_idx+2];

			Hardware::Reset_Timer2();
			
			for (int32_t i=USTB_idx;i>=MemStartOffs;i--)		// correct from now to start
			{ S1Ptr[i] -= (uint8_t)lCorrect;}
		}
	}
	else
	{ Hardware::SetDacOffset(eCh1); }


}
//##########################################################################################################################################
// Set voltage range for channel 2
void UserIF::ON_Voltage_Channel_2(void)
{

	if (!Channel[eCh2].active) return;

	// adjust voltage range
	if (RotaryDirection == 1)
	{	// switch to next lower range
		if (Selected_Voltage_CH2 == e10mV) return;		// lowest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH2 - 1) > e10mV)
		{ Selected_Voltage_CH2 --; }
		else
		{ Selected_Voltage_CH2 = e10mV; }
	}
	else
	{	// switch to next higher range
		if (Selected_Voltage_CH2 == e5V) return; 		// highest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH2 + 1) < e5V)
		{ Selected_Voltage_CH2 ++; }
		else
		{ Selected_Voltage_CH2 = e5V; }	
	}
	
	if (Cursor_Enabled)
	{
		if(Signal::_FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	
	if ((Active_Menu == MENU_CURSOR) || Active_Menu == MENU_QUICKMEASURE)
	{
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	
	Hardware::SetSwitches(eCh2, Selected_Voltage_CH2);			// set switches on the mainboard
	VoltageChangedCh2 = 1;
	
	Display::DRAWSTATUS(2, 1);					// draw voltage channel 1

	if (MenuStatus[MENU_TRIGGERSUB][5] == 356)			// trigger level constant grid position -> scaling level
	{ Display::DRAWSTATUS(6, 1); }					// display new trigger level
	else
	{ Display::TriggerLevelVoltageToPos(); }			// scale trigger level to the new range	
	
	if(Signal::_FFT_Mode != FFT_OFF)
	Signal::FFT_buildScaleLookupTable();
	
	RotarySteps = 0;						// reset step counter to prevent zero level shifting
	ON_Zero_Channel_2();	


}
//##########################################################################################################################################
//set zerolevel for channel 2 (zero wheel handler)
void UserIF::ON_Zero_Channel_2(void)
{
	int buffer = RotarySteps;
	int lVirtualZero;
	int lVZL_Old;	
	short lCorrect;

	
	if (!Channel[eCh2].active) return;

	if (Signal::_FFT_Mode != FFT_OFF){ RotarySteps = 0; return; }
	

	if (RotarySteps != 0)
	{

		if (RotaryDirection == 0)	//counter clockwise rotary direction 
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH2;

				if ((Virtual_ZeroLevelXYCH2 + buffer) < 4095)
				{ Virtual_ZeroLevelXYCH2 += buffer; }		
				else
				{ Virtual_ZeroLevelXYCH2 = 4095; }				// limiter

				// correct trigger level position on screen
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL_Old + Virtual_ZeroLevelXYCH2;	//keep triggerlevel

			}
			else	//Main mode TY ( moving down )
			{
				lVZL_Old = Virtual_ZeroLevelCH2;

				if (buffer > 10)						// step width grid division 
				{
					int div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH2/steps;			// in which div we are?

					if(Virtual_ZeroLevelCH2 < 0)				// negative level
					{ if ((div * steps) == Virtual_ZeroLevelCH2){div++;} }	// zero level was on grid division before -> next div
					else							// positive level
					{ div++; } 						// next grid division
					
					Virtual_ZeroLevelCH2 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH2 += buffer;
				}

				if (Virtual_ZeroLevelCH2 > 4095)				// limiter
				{ Virtual_ZeroLevelCH2 = 4095; } 

				// correct trigger level position on screen
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
			}


		}
		else	//clockwise rotary direction
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH2;
				
				if ((Virtual_ZeroLevelXYCH2 - buffer) > -4095)  
				{ Virtual_ZeroLevelXYCH2 -= buffer; }		
				else
				{ Virtual_ZeroLevelXYCH2 = -4095; }       			// limiter
	
				// correct trigger level position on screen
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL_Old + Virtual_ZeroLevelXYCH2;	//keep triggerlevel
			}
			else	// main mode (moving up)
			{
				lVZL_Old = Virtual_ZeroLevelCH2;

				if (buffer > 10)						// step width grid division 
				{
					int div, steps;

					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH2/steps;			// in which div we are? 

					if(Virtual_ZeroLevelCH2 > 0)				// positive level
					{ if ((div * steps) == Virtual_ZeroLevelCH2){div--;} }	// zero level was on grid division before -> next div
					else							// negative level	
					{ div--; } 						// next grid division
					
					Virtual_ZeroLevelCH2 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH2 -= buffer; 
				}	
						
				if (Virtual_ZeroLevelCH2 < -4095)	 			// limiter
				{ Virtual_ZeroLevelCH2 = -4095; }

				// correct trigger level position on screen
				Trigger_Pos_CH2 = Trigger_Pos_CH2 - lVZL_Old + Virtual_ZeroLevelCH2;	//keep triggerlevel
			}

		}

		VS_ZeroLevelChanged = 2;	//flag for zero sign drawing
   		ZL_changed = 2;			//flag for signal drawing
	}

	if(LA_active) return;

	// correct trigger level registers if this is the active trigger channel
	if (Hardware::_TriggerSource == eTrigCh2)
	{ Hardware::SetDelayTimer2(30, &Hardware::SetupTrigger); }	// load trigger setup to execution queue

 
	//---------------------------------------
	// 		setup DAC
	//---------------------------------------
	if (XY_Mode)
	{
   		ZeroLevelCH2 = Virtual_ZeroLevelXYCH2 + (GRID_XY / 2);
		if (ZeroLevelCH2 < 0) ZeroLevelCH2 = 0;
		if (ZeroLevelCH2 > GRID_XY) ZeroLevelCH2 = GRID_XY;

		lVirtualZero = Virtual_ZeroLevelXYCH2;
	}
	else
	{
		ZeroLevelCH2 = Virtual_ZeroLevelCH2 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH2 < 0) ZeroLevelCH2 = 0;
		if (ZeroLevelCH2 > (GRID_HEIGHT + 1)) ZeroLevelCH2 = (GRID_HEIGHT + 1);

		lVirtualZero = Virtual_ZeroLevelCH2;
	}

	lCorrect = (short)Hardware::_ADC_VirtualZero[1];					// store old zero level

	Hardware::_ADC_VirtualZero[1] = (int)(ADC_ZERO + ((float)lVirtualZero / ScaleFactor[Selected_Voltage_CH2]));

	if (Hardware::_ADC_VirtualZero[1] > 255) Hardware::_ADC_VirtualZero[1] = 255;	//Limiter
	else if (Hardware::_ADC_VirtualZero[1] < 0) Hardware::_ADC_VirtualZero[1] = 0;

	switch(Selected_Voltage_CH2)
	{
		case 0: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][0]; break;//1 mV
		case 1: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][1]; break;//2 mV
		case 2: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][2]; break;//5 mV
	
		case 3: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][0]; break;//10 mV
		case 4: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][1]; break;//20 mV
		case 5: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][2]; break;//50 mV
	
		case 6: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][0]; break;//100 mV
		case 7: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][1]; break;//200 mV
		case 8: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][2]; break;//500 mV

		case 9:  CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][0]; break;// 1 V
		case 10: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][1]; break;// 2 V
		case 11: CH2_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][1][2]; break;// 5 V
	}

	// clip to 16 bit range
	if (CH2_DAC_Offset < 0) CH2_DAC_Offset = 0;
	else if (CH2_DAC_Offset >= 65536) CH2_DAC_Offset = 65535;

	if (USTB_Mode != USTB_OFF && RotarySteps != 0)
	{
		lCorrect -= (short)Hardware::_ADC_VirtualZero[1];		// get difference between old and new zero level for correction
		
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();

	    	Hardware::SetDacOffset(eCh2);

		if (USTB_Dir == USTB_FORWARD)
		{
			for (int i=MemStartOffs;i<USTB_idx;i++)			// correct from start to now
			{ S2Ptr[i] -= (unsigned char)lCorrect; }
		
			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S2Ptr[USTB_idx-1] = S2Ptr[USTB_idx-2];

			Hardware::Reset_Timer2();

			for (int i=USTB_idx;i<=MemoryEnd;i++)			// correct from now to buffer end
			{ S2Ptr[i] -= (unsigned char)lCorrect;}
		}
		else
		{
			for (int i=MemoryEnd;i>USTB_idx;i--)			// correct fom buffer end to now
			{ S2Ptr[i] -= (unsigned char)lCorrect; }

			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S2Ptr[USTB_idx+1] = S2Ptr[USTB_idx+2];

			Hardware::Reset_Timer2();
			
			for (int i=USTB_idx;i>=MemStartOffs;i--)		// correct from now to start
			{ S2Ptr[i] -= (unsigned char)lCorrect;}
		}
	}
	else
	{ Hardware::SetDacOffset(eCh2); }
}
//##########################################################################################################################################
void UserIF::ON_Voltage_Channel_3(void)
{

	if (!Channel[eCh3].active) return;

	// adjust voltage range
	if (RotaryDirection == 1)
	{	// switch to next lower range
		if (Selected_Voltage_CH3 == e10mV) return;		// lowest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH3 - 1) > e10mV)
		{ Selected_Voltage_CH3 --; }
		else
		{ Selected_Voltage_CH3 = e10mV; }
	}
	else
	{	// switch to next higher range
		if (Selected_Voltage_CH3 == e5V) return; 		// highest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH3 + 1) < e5V)
		{ Selected_Voltage_CH3 ++; }
		else
		{ Selected_Voltage_CH3 = e5V; }	
	}
	
	if (Cursor_Enabled)
	{
		if(Signal::_FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	
	if ((Active_Menu == MENU_CURSOR) || Active_Menu == MENU_QUICKMEASURE)
	{
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	
	Hardware::SetSwitches(eCh3, Selected_Voltage_CH3);			// set switches on the mainboard
	VoltageChangedCh3 = 1;
	
	Display::DRAWSTATUS(3, 1);					// draw voltage channel 1

	if (MenuStatus[MENU_TRIGGERSUB][5] == 356)			// trigger level constant grid position -> scaling level
	{ Display::DRAWSTATUS(6, 1); }					// display new trigger level
	else
	{ Display::TriggerLevelVoltageToPos(); }			// scale trigger level to the new range	
	
	if(Signal::_FFT_Mode != FFT_OFF)
	Signal::FFT_buildScaleLookupTable();
	
	RotarySteps = 0;						// reset step counter to prevent zero level shifting
	ON_Zero_Channel_3();		
	
}
//##########################################################################################################################################
//set zerolevel for channel 3 (zero wheel handler)
void UserIF::ON_Zero_Channel_3(void)
{
	int buffer = RotarySteps;
	int lVirtualZero;
	int lVZL_Old;	
	short lCorrect;

	
	if (!Channel[eCh3].active) return;

	if (Signal::_FFT_Mode != FFT_OFF){ RotarySteps = 0; return; }
	

	if (RotarySteps != 0)
	{

		if (RotaryDirection == 0)	//counter clockwise rotary direction 
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH3;

				if ((Virtual_ZeroLevelXYCH3 + buffer) < 4095)
				{ Virtual_ZeroLevelXYCH3 += buffer; }		
				else
				{ Virtual_ZeroLevelXYCH3 = 4095; }				// limiter

				// correct trigger level position on screen
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL_Old + Virtual_ZeroLevelXYCH3;	//keep triggerlevel

			}
			else	//Main mode TY ( moving down )
			{
				lVZL_Old = Virtual_ZeroLevelCH3;

				if (buffer > 10)						// step width grid division 
				{
					int32_t div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH3/steps;			// in which div we are?

					if(Virtual_ZeroLevelCH3 < 0)				// negative level
					{ if ((div * steps) == Virtual_ZeroLevelCH3){div++;} }	// zero level was on grid division before -> next div
					else							// positive level
					{ div++; } 						// next grid division
					
					Virtual_ZeroLevelCH3 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH3 += buffer; 
				}

				if (Virtual_ZeroLevelCH3 > 4095)				// limiter
				{ Virtual_ZeroLevelCH3 = 4095; } 

				// correct trigger level position on screen
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
			}


		}
		else	//clockwise rotary direction
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH3;
				
				if ((Virtual_ZeroLevelXYCH3 - buffer) > -4095)  
				{ Virtual_ZeroLevelXYCH3 -= buffer; }		
				else
				{ Virtual_ZeroLevelXYCH3 = -4095; }       			// limiter
	
				// correct trigger level position on screen
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL_Old + Virtual_ZeroLevelXYCH3;	//keep triggerlevel
			}
			else	// main mode (moving up)
			{
				lVZL_Old = Virtual_ZeroLevelCH3;

				if (buffer > 10)						// step width grid division 
				{
					int32_t div, steps;

					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH3/steps;			// in which div we are? 

					if(Virtual_ZeroLevelCH3 > 0)				// positive level
					{ if ((div * steps) == Virtual_ZeroLevelCH3){div--;} }	// zero level was on grid division before -> next div
					else							// negative level	
					{ div--; } 						// next grid division
					
					Virtual_ZeroLevelCH3 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH3 -= buffer; 
				}	
						
				if (Virtual_ZeroLevelCH3 < -4095)	 			// limiter
				{ Virtual_ZeroLevelCH3 = -4095; }

				// correct trigger level position on screen
				Trigger_Pos_CH3 = Trigger_Pos_CH3 - lVZL_Old + Virtual_ZeroLevelCH3;	//keep triggerlevel
			}

		}

		VS_ZeroLevelChanged = 3;	//flag for zero sign drawing
   		ZL_changed = 3;			//flag for signal drawing
	}

	if(LA_active) return;

	// correct trigger level registers if this is the active trigger channel
	if (Hardware::_TriggerSource == eTrigCh3)
	{ Hardware::SetDelayTimer2(30, &Hardware::SetupTrigger);	}	// load trigger setup to execution queue

	
	//---------------------------------------
	// 		setup DAC
	//---------------------------------------
	if (XY_Mode)
	{
		ZeroLevelCH3 = Virtual_ZeroLevelXYCH3 + (GRID_XY / 2);
		if (ZeroLevelCH3 < 0) ZeroLevelCH3 = 0;
		if (ZeroLevelCH3 > GRID_XY) ZeroLevelCH3 = GRID_XY;
		
		lVirtualZero = Virtual_ZeroLevelXYCH3;
	}
	else
	{
		ZeroLevelCH3 = Virtual_ZeroLevelCH3 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH3 < 0) ZeroLevelCH3 = 0;
		if (ZeroLevelCH3 > (GRID_HEIGHT + 1)) ZeroLevelCH3 = (GRID_HEIGHT + 1);

		lVirtualZero = Virtual_ZeroLevelCH3;
	}

	lCorrect = (short)Hardware::_ADC_VirtualZero[2];					// store old zero level

	Hardware::_ADC_VirtualZero[2] = (int)(ADC_ZERO + ((float)lVirtualZero / ScaleFactor[Selected_Voltage_CH3]));

	if (Hardware::_ADC_VirtualZero[2] > 255) Hardware::_ADC_VirtualZero[2] = 255;	//Limiter
	else if (Hardware::_ADC_VirtualZero[2] < 0) Hardware::_ADC_VirtualZero[2] = 0;

	switch(Selected_Voltage_CH3)
	{
		case 0: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][0]; break;//1 mV
		case 1: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][1]; break;//2 mV
		case 2: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][2]; break;//5 mV
	
		case 3: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][0]; break;//10 mV
		case 4: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][1]; break;//20 mV
		case 5: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][2]; break;//50 mV
	
		case 6: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][0]; break;//100 mV
		case 7: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][1]; break;//200 mV
		case 8: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][2]; break;//500 mV

		case 9:  CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][0]; break;// 1 V
		case 10: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][1]; break;// 2 V
		case 11: CH3_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][2][2]; break;// 5 V
	}

	// clip to 16 bit range
	if (CH3_DAC_Offset < 0) CH3_DAC_Offset = 0;
	else if (CH3_DAC_Offset >= 65536) CH3_DAC_Offset = 65535;

	if (USTB_Mode != USTB_OFF && RotarySteps != 0)
	{
		lCorrect -= (short)Hardware::_ADC_VirtualZero[2];				// get difference between old and new zero level for correction
		
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();

	    	Hardware::SetDacOffset(eCh3);

		if (USTB_Dir == USTB_FORWARD)
		{
			for (int i=MemStartOffs;i<USTB_idx;i++)			// correct from start to now
			{ S3Ptr[i] -= (unsigned char)lCorrect; }
		
			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S3Ptr[USTB_idx-1] = S3Ptr[USTB_idx-2];

			Hardware::Reset_Timer2();

			for (int i=USTB_idx;i<=MemoryEnd;i++)			// correct from now to buffer end
			{ S3Ptr[i] -= (unsigned char)lCorrect;}
		}
		else
		{
			for (int i=MemoryEnd;i>USTB_idx;i--)			// correct fom buffer end to now
			{ S3Ptr[i] -= (unsigned char)lCorrect; }

			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S3Ptr[USTB_idx+1] = S3Ptr[USTB_idx+2];

			Hardware::Reset_Timer2();
			
			for (int i=USTB_idx;i>=MemStartOffs;i--)		// correct from now to start
			{ S3Ptr[i] -= (unsigned char)lCorrect;}
		}
	}
	else
	{ Hardware::SetDacOffset(eCh3); }

}
//##########################################################################################################################################
void UserIF::ON_Voltage_Channel_4(void)
{
	if (!Channel[eCh4].active) return;

	// adjust voltage range
	if (RotaryDirection == 1)
	{	// switch to next lower range
		if (Selected_Voltage_CH4 == e10mV) return;		// lowest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH4 - 1) > e10mV)
		{ Selected_Voltage_CH4 --; }
		else
		{ Selected_Voltage_CH4 = e10mV; }
	}
	else
	{	// switch to next higher range
		if (Selected_Voltage_CH4 == e5V) return; 		// highest range reached, nothing to do -> leave

		if ((Selected_Voltage_CH4 + 1) < e5V)
		{ Selected_Voltage_CH4 ++; }
		else
		{ Selected_Voltage_CH4 = e5V; }	
	}
	
	if (Cursor_Enabled)
	{
		if(Signal::_FFT_Mode != FFT_OFF)
		Display::FFT_CalcCursorData();
		else
		Display::CALCCURSORDATA();

		Menu_Changed = 1;
		CursorChanged = 4;
	}
	
	
	if ((Active_Menu == MENU_CURSOR) || Active_Menu == MENU_QUICKMEASURE)
	{
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	
	Hardware::SetSwitches(eCh4, Selected_Voltage_CH4);			// set switches on the mainboard
	VoltageChangedCh4 = 1;
	
	Display::DRAWSTATUS(4, 1);					// draw voltage channel 1

	if (MenuStatus[MENU_TRIGGERSUB][5] == 356)			// trigger level constant grid position -> scaling level
	{ Display::DRAWSTATUS(6, 1); }					// display new trigger level
	else
	{ Display::TriggerLevelVoltageToPos(); }			// scale trigger level to the new range	
	
	if(Signal::_FFT_Mode != FFT_OFF)
	Signal::FFT_buildScaleLookupTable();
	
	RotarySteps = 0;						// reset step counter to prevent zero level shifting
	ON_Zero_Channel_4();		
	
}
//##########################################################################################################################################
//set zerolevel for channel 4 (zero wheel handler)
void UserIF::ON_Zero_Channel_4(void)
{
	int buffer = RotarySteps;
	int lVirtualZero;
	int lVZL_Old;	
	short lCorrect;


	if (!Channel[eCh4].active) return;

	if (Signal::_FFT_Mode != FFT_OFF){ RotarySteps = 0; return; }
	

	if (RotarySteps != 0)
	{

		if (RotaryDirection == 0)	//counter clockwise rotary direction 
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH4;

				if ((Virtual_ZeroLevelXYCH4 + buffer) < 4095)
				{ Virtual_ZeroLevelXYCH4 += buffer; }		
				else
				{ Virtual_ZeroLevelXYCH4 = 4095; }				// limiter

				// correct trigger level position on screen
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL_Old + Virtual_ZeroLevelXYCH4;	//keep triggerlevel

			}
			else	//Main mode TY ( moving down )
			{
				lVZL_Old = Virtual_ZeroLevelCH4;

				if (buffer > 10)						// step width grid division 
				{
					int div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH4/steps;			// in which div we are?

					if(Virtual_ZeroLevelCH4 < 0)				// negative level
					{ if ((div * steps) == Virtual_ZeroLevelCH4){div++;} }	// zero level was on grid division before -> next div
					else							// positive level
					{ div++; } 						// next grid division
					
					Virtual_ZeroLevelCH4 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH4 += buffer;
				}

				if (Virtual_ZeroLevelCH4 > 4095)				// limiter
				{ Virtual_ZeroLevelCH4 = 4095; } 

				// correct trigger level position on screen
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}


		}
		else	//clockwise rotary direction
		{
			if (XY_Mode)	//XY-mode
			{
				buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
				lVZL_Old = Virtual_ZeroLevelXYCH4;
				
				if ((Virtual_ZeroLevelXYCH4 - buffer) > -4095)  
				{ Virtual_ZeroLevelXYCH4 -= buffer; }		
				else
				{ Virtual_ZeroLevelXYCH4 = -4095; }				// limiter
	
				// correct trigger level position on screen
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL_Old + Virtual_ZeroLevelXYCH4;	//keep triggerlevel
			}
			else	// main mode (moving up)
			{
				lVZL_Old = Virtual_ZeroLevelCH4;

				if (buffer > 10)						// step width grid division 
				{
					int div, steps;

					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = Virtual_ZeroLevelCH4/steps;			// in which div we are? 

					if(Virtual_ZeroLevelCH4 > 0)				// positive level
					{ if ((div * steps) == Virtual_ZeroLevelCH4){div--;} }	// zero level was on grid division before -> next div
					else							// negative level	
					{ div--; } 						// next grid division
					
					Virtual_ZeroLevelCH4 = div * steps;			// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					Virtual_ZeroLevelCH4 -= buffer;
				}	
						
				if (Virtual_ZeroLevelCH4 < -4095)	 			// limiter
				{ Virtual_ZeroLevelCH4 = -4095; }

				// correct trigger level position on screen
				Trigger_Pos_CH4 = Trigger_Pos_CH4 - lVZL_Old + Virtual_ZeroLevelCH4;	//keep triggerlevel
			}

		}

		VS_ZeroLevelChanged = 4;	//flag for zero sign drawing
   		ZL_changed = 4;			//flag for signal drawing
	}

	if(LA_active) return;

	// correct trigger level registers if this is the active trigger channel
	if (Hardware::_TriggerSource == eTrigCh4)
	{ Hardware::SetDelayTimer2(30, &Hardware::SetupTrigger); }	// load trigger setup to execution queue	

 
	//---------------------------------------
	// 		setup DAC
	//---------------------------------------
	if (XY_Mode)
	{
		ZeroLevelCH4 = Virtual_ZeroLevelXYCH4 + (GRID_XY / 2);
		if (ZeroLevelCH4 < 0) ZeroLevelCH4 = 0;
		if (ZeroLevelCH4 > GRID_XY) ZeroLevelCH4 = GRID_XY;

		lVirtualZero = Virtual_ZeroLevelXYCH4;
	}
	else
	{
		ZeroLevelCH4 = Virtual_ZeroLevelCH4 + (GRID_HEIGHT / 2);
		if (ZeroLevelCH4 < 0) ZeroLevelCH4 = 0;
		if (ZeroLevelCH4 > (GRID_HEIGHT + 1)) ZeroLevelCH4 = (GRID_HEIGHT + 1);

		lVirtualZero = Virtual_ZeroLevelCH4;
	}

	lCorrect = (short)Hardware::_ADC_VirtualZero[3];					// store old zero level

	Hardware::_ADC_VirtualZero[3] = (int)(ADC_ZERO + ((float)lVirtualZero / ScaleFactor[Selected_Voltage_CH4]));

	if (Hardware::_ADC_VirtualZero[3] > 255) Hardware::_ADC_VirtualZero[3] = 255;	//Limiter
	else if (Hardware::_ADC_VirtualZero[3] < 0) Hardware::_ADC_VirtualZero[3] = 0;

	switch(Selected_Voltage_CH4)
	{
		case 0: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][0]; break;//1 mV
		case 1: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][1]; break;//2 mV
		case 2: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][2]; break;//5 mV
	
		case 3: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][0]; break;//10 mV
		case 4: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][1]; break;//20 mV
		case 5: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][2]; break;//50 mV
	
		case 6: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][0]; break;//100 mV
		case 7: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][1]; break;//200 mV
		case 8: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][2]; break;//500 mV

		case 9:  CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[0]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][0]; break;// 1 V
		case 10: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[1]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][1]; break;// 2 V
		case 11: CH4_DAC_Offset = (int)((float)lVirtualZero * DAC_ScaleFactor[2]) + DAC_MIDSCALE + DAC_Correction[CalSet][3][2]; break;// 5 V
	}

	// clip to 16 bit range
	if (CH4_DAC_Offset < 0) CH4_DAC_Offset = 0;
	else if (CH4_DAC_Offset >= 65536) CH4_DAC_Offset = 65535;

	if (USTB_Mode != USTB_OFF && RotarySteps != 0)
	{
		lCorrect -= (short)Hardware::_ADC_VirtualZero[3];				// get difference between old and new zero level for correction
		
		Hardware::Stop_Timer2();
		Hardware::Stop_Record();

	    	Hardware::SetDacOffset(eCh4);

		if (USTB_Dir == USTB_FORWARD)
		{
			for (int i=MemStartOffs;i<USTB_idx;i++)			// correct from start to now
			{ S4Ptr[i] -= (unsigned char)lCorrect; }
		
			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S4Ptr[USTB_idx-1] = S4Ptr[USTB_idx-2];

			Hardware::Reset_Timer2();

			for (int i=USTB_idx;i<=MemoryEnd;i++)			// correct from now to buffer end
			{ S4Ptr[i] -= (unsigned char)lCorrect;}
		}
		else
		{
			for (int i=MemoryEnd;i>USTB_idx;i--)			// correct fom buffer end to now
			{ S4Ptr[i] -= (unsigned char)lCorrect; }

			Hardware::Start_Record(); nr_delay(10);			// spike suppression
			S4Ptr[USTB_idx+1] = S4Ptr[USTB_idx+2];

			Hardware::Reset_Timer2();
			
			for (int i=USTB_idx;i>=MemStartOffs;i--)		// correct from now to start
			{ S4Ptr[i] -= (unsigned char)lCorrect;}
		}
	}
	else
	{ Hardware::SetDacOffset(eCh4); }

	
}
//##########################################################################################################################################
void UserIF::ON_MainWheel(void)						// Main Wheel Handler
{
	bool doit = false;
	bool changing = false;
	
	short pos = 0;

	int32_t Direction = RotaryDirection;				// copy volatile memory to register
	int32_t rbuf = RotarySteps;					// copy volatile memory to register
	
	switch(Active_Menu)
	{
		// Acquire
		case 0:
		{
			if (USTB_Mode != USTB_OFF) return;
		
			pos = -1;
			
			if (MenuBtnFocus[MENU_ACQUIRE] == 0)	//Logic
			{
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(47, &MenuStatus[MENU_ACQUIRE][0], &pos, &pos, MENU_ACQUIRE, LOGA_OFF, 2); }
					else
					{ MenuPopupStep(47, &MenuStatus[MENU_ACQUIRE][0], &pos, &pos, MENU_ACQUIRE, LOGA_OFF, 1); }

					rbuf--;
				}
				//Signal::LOGA_LogicProcessor();
				Hardware::SetDelayTimer1(60, &Signal::LOGA_LogicProcessor);	// load logic processor to execution queue
				Display::OssSingle(eOssLogA, 1, 1);
			}
			else if (MenuBtnFocus[MENU_ACQUIRE] == 1)	//Average
			{
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(21, &MenuStatus[MENU_ACQUIRE][1], &pos, &pos, MENU_ACQUIRE, AVRG_OFF, 2); }
					else
					{ MenuPopupStep(21, &MenuStatus[MENU_ACQUIRE][1], &pos, &pos, MENU_ACQUIRE, AVRG_OFF, 1); }

					rbuf--;
				}
				if (MenuStatus[MENU_ACQUIRE][1] == AVRG_4)
				ACQ_Average = 1;
				else
				ACQ_Average = 0;
				
				Display::OssSingle(eOssAvrg, 1, 1);
			}
			else if (MenuBtnFocus[MENU_ACQUIRE] == 2)	//Noise Filter
			{
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(22, &MenuStatus[MENU_ACQUIRE][2], &pos, &pos, MENU_ACQUIRE, 311, 2); }
					else
					{ MenuPopupStep(22, &MenuStatus[MENU_ACQUIRE][2], &pos, &pos, MENU_ACQUIRE, 311, 1); }

					rbuf--;
				}

				if (MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+1) || MenuStatus[MENU_ACQUIRE][2] == (FILT_OFF+2))
				{ FilterType = PRO; }
				else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+2) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+6))
				{ FilterType = IIR; }
				else if (MenuStatus[MENU_ACQUIRE][2] > (FILT_OFF+5) && MenuStatus[MENU_ACQUIRE][2] < (FILT_OFF+9))
				{ FilterType = FIR; }

				//if acquisision is stopped signal processing must be triggered to take effect
				if(!Run)ACQ_NewData = 1;
				
				Display::OssSingle(eOssFilt, 1, 1);
			}
			else if (MenuBtnFocus[MENU_ACQUIRE] == 3)	//Interpolation
			{
				//TODO: -> rest of logic for popup menu
				
				Display::OssSingle(eOssIpol, 1, 1);
			}

			New_Menu = MENU_ACQUIRE;
			Menu_Changed = 1;

			Hardware::ResetTimer3(RegTimerRotDelay);

			break;
		}
		
		// Channel 1 -> probe / cpoupling
		case 1:
		{
            		if (!Channel[eCh1].active) return;

			if (MenuBtnFocus[MENU_CHANNEL1] == 0)	// focus on coupling button?
			{
				pos = -1;
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(13, &MenuStatus[MENU_CHANNEL1][0], &pos, &pos, MENU_CHANNEL1, 6, 2); }
					else
					{ MenuPopupStep(13, &MenuStatus[MENU_CHANNEL1][0], &pos, &pos, MENU_CHANNEL1, 6, 1); }

					rbuf--;
				}

				Hardware::SetSwitches(eCh1, -1);
				Display::OssSingle( eOssCh1, 1, 1);	
				
			}
			//else if (MenuBtnFocus[MENU_CHANNEL1] == 3)	// focus on probe button?
			else
			{	
				doit = true;
				changing = false;
				
				while (rbuf > 0)
				{
					switch(Direction)
					{
						case 0: if (MenuStatus[MENU_CHANNEL1][3] > 101) {MenuStatus[MENU_CHANNEL1][3]--; changing = true;} break;
						case 1: if (MenuStatus[MENU_CHANNEL1][3] < 113) {MenuStatus[MENU_CHANNEL1][3]++; changing = true;} break;
					}
					rbuf--;
				}
					
				if (changing)
				{
					Display::Rect(345, 454, 60, 14, 0, Buffer_UI2Plane);
					Display::TextOut12x9(MenuData[MenuStatus[MENU_CHANNEL1][3]], 354, 455, 1, Buffer_UI2Plane);
					Display::DRAWSTATUS(Active_Menu, 1);		
					Display::DRAWSTATUS(6, 1);	

					if (MenuStatus[MENU_CHANNEL1][3] == 104 || MenuStatus[MENU_CHANNEL1][3] == 107)
					Signal::LOGA_LogicProcessor();
				}                		
				
				if (Cursor_Enabled)
				{
					CursorChanged = 4;
					if(Signal::_FFT_Mode != FFT_OFF)
					Display::FFT_CalcCursorData();
					else
					Display::CALCCURSORDATA();
				}
				
				TriggerLevelChanged = 1;
				Display::StatusUpdate();
			}

			New_Menu = MENU_CHANNEL1;
			Menu_Changed = 1;

			break;
		}
		
		// Channel 2
		case 2:
		{
			if (!Channel[eCh2].active) return;

			if (MenuBtnFocus[MENU_CHANNEL2] == 0)	// focus on coupling button?
			{
				pos = -1;
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(14, &MenuStatus[MENU_CHANNEL2][0], &pos, &pos, MENU_CHANNEL2, 6, 2); }
					else
					{ MenuPopupStep(14, &MenuStatus[MENU_CHANNEL2][0], &pos, &pos, MENU_CHANNEL2, 6, 1); }

					rbuf--;
				}

				Hardware::SetSwitches(eCh2, -1);
				Display::OssSingle( eOssCh2, 1, 1);	
				
			}
			//else if (MenuBtnFocus[MENU_CHANNEL2] == 3)	// focus on probe button?
			else
			{	
			
				doit = true;
				
				changing = false;
				while (rbuf > 0)
				{
					switch(Direction)
					{
							case 0: if (MenuStatus[MENU_CHANNEL2][3] > 101) {MenuStatus[MENU_CHANNEL2][3]--; changing = true;} break;
							case 1: if (MenuStatus[MENU_CHANNEL2][3] < 113) {MenuStatus[MENU_CHANNEL2][3]++; changing = true;} break;
					}
					rbuf--;
				}
				
				if (changing)
				{
					Display::Rect(345, 454, 60, 14, 0, Buffer_UI2Plane);
					Display::TextOut12x9(MenuData[MenuStatus[MENU_CHANNEL2][3]], 354, 455, 1, Buffer_UI2Plane);
					Display::DRAWSTATUS(Active_Menu, 1);		
					Display::DRAWSTATUS(6, 1);

					if (MenuStatus[MENU_CHANNEL2][3] == 104 || MenuStatus[MENU_CHANNEL2][3] == 107)
					Signal::LOGA_LogicProcessor();
				}

				if (Cursor_Enabled)
				{
					CursorChanged = 4;
					if(Signal::_FFT_Mode != FFT_OFF)
					Display::FFT_CalcCursorData();
					else
					Display::CALCCURSORDATA();
				}
				TriggerLevelChanged = 1;
				Display::StatusUpdate();			

			}
			
			New_Menu = MENU_CHANNEL2;
            		Menu_Changed = 1;	

			break;
		}
		
		// Channel 3
		case 3:
		{
            		if (!Channel[eCh3].active) return;

			if (MenuBtnFocus[MENU_CHANNEL3] == 0)	// focus on coupling button?
			{
				pos = -1;
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(15, &MenuStatus[MENU_CHANNEL3][0], &pos, &pos, MENU_CHANNEL3, 6, 2); }
					else
					{ MenuPopupStep(15, &MenuStatus[MENU_CHANNEL3][0], &pos, &pos, MENU_CHANNEL3, 6, 1); }

					rbuf--;
				}

				Hardware::SetSwitches(eCh3, -1);
				Display::OssSingle( eOssCh3, 1, 1);	
				
			}
			//else if (MenuBtnFocus[MENU_CHANNEL3] == 3)	// focus on probe button?
			else
			{	
				doit = true;
							
				changing = false;
				while (rbuf > 0)
				{
					switch(Direction)
					{
							case 0: if (MenuStatus[MENU_CHANNEL3][3] > 101) {MenuStatus[MENU_CHANNEL3][3]--; changing = true;} break;
							case 1: if (MenuStatus[MENU_CHANNEL3][3] < 113) {MenuStatus[MENU_CHANNEL3][3]++; changing = true;} break;
					}
					rbuf--;
				}
				
				if (changing)
				{
					Display::Rect(345, 454, 60, 14, 0, Buffer_UI2Plane);
					Display::TextOut12x9(MenuData[MenuStatus[MENU_CHANNEL3][3]], 354, 455, 1, Buffer_UI2Plane);
					Display::DRAWSTATUS(Active_Menu, 1);		
					Display::DRAWSTATUS(6, 1);

					if (MenuStatus[MENU_CHANNEL3][3] == 104 || MenuStatus[MENU_CHANNEL3][3] == 107)
					Signal::LOGA_LogicProcessor();
				}
				
				if (Cursor_Enabled)
				{
					CursorChanged = 4;
					if(Signal::_FFT_Mode != FFT_OFF)
					Display::FFT_CalcCursorData();
					else
					Display::CALCCURSORDATA();

				}

				TriggerLevelChanged = 1;
				Display::StatusUpdate();
            		
			}
			
			New_Menu = MENU_CHANNEL3;
			Menu_Changed = 1;

			break;
		}
		
		// Channel 4
		case 4:
		{
			if (!Channel[eCh4].active) return;

			if (MenuBtnFocus[MENU_CHANNEL4] == 0)	// focus on coupling button?
			{
				pos = -1;
				while (rbuf > 0)
				{
					if (Direction == 0)
					{ MenuPopupStep(16, &MenuStatus[MENU_CHANNEL4][0], &pos, &pos, MENU_CHANNEL4, 6, 2); }
					else
					{ MenuPopupStep(16, &MenuStatus[MENU_CHANNEL4][0], &pos, &pos, MENU_CHANNEL4, 6, 1); }

					rbuf--;
				}

				Hardware::SetSwitches(eCh4, -1);
				Display::OssSingle( eOssCh4, 1, 1);	
				
			}
			//else if (MenuBtnFocus[MENU_CHANNEL4] == 3)	// focus on probe button?
			else
			{	
				doit = true;
				
				changing = false;
				while (rbuf > 0)
				{
					switch(Direction)
					{
							case 0: if (MenuStatus[MENU_CHANNEL4][3] > 101) {MenuStatus[MENU_CHANNEL4][3]--; changing = true;} break;
							case 1: if (MenuStatus[MENU_CHANNEL4][3] < 113) {MenuStatus[MENU_CHANNEL4][3]++; changing = true;} break;
					}
					rbuf--;
				}
						
				if (changing)
				{
					Display::Rect(345, 454, 60, 14, 0, Buffer_UI2Plane);
					Display::TextOut12x9(MenuData[MenuStatus[MENU_CHANNEL4][3]], 354, 455, 1, Buffer_UI2Plane);
					Display::DRAWSTATUS(Active_Menu, 1);		
					Display::DRAWSTATUS(6, 1);

					if (MenuStatus[MENU_CHANNEL4][3] == 104 || MenuStatus[MENU_CHANNEL4][3] == 107)
					Signal::LOGA_LogicProcessor();
				}
						
				if (Cursor_Enabled)
				{
					CursorChanged = 4;
					if(Signal::_FFT_Mode != FFT_OFF)
					Display::FFT_CalcCursorData();
					else
					Display::CALCCURSORDATA();

				}

				TriggerLevelChanged = 1;
				Display::StatusUpdate();	
			}
		
			New_Menu = MENU_CHANNEL4;
			Menu_Changed = 1;		

			break;
		}
		
		// Display Menu -> grid brightness
		case 5:	// -> fall through

		// Display FFT menu -> grid brightness
		case 28:
		{
			changing = false;
			
			while (rbuf > 0)
			{		
				switch(Direction)
				{
					case 0: if (GridColorArrayPos > 0){ GridColorArrayPos--; } break;
						//if (GridColor_Val > 0x00) GridColor_Val--; break;
			
					case 1:	if (GridColorArrayPos < 3){ GridColorArrayPos++; } break;
						//if (GridColor_Val < 0xFF) GridColor_Val++; break;	
				}
				rbuf--;
				changing = true;
			}			
			
			if (changing)
			{	
				Hardware::_regADC[eFPGA1].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
				Hardware::_regADC[eFPGA2].grid_color = GridColorArray[ColorPalette][GridColorArrayPos] << 2;     	// set grid color byte and shift bits to msb
				Hardware::CaptureSetupADC();						// write color shadow register to hardware
	
				MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;
				MenuStatus[MENU_DISPL_FFT][2] = MenuStatus[MENU_DISPLAY][2];
								
				Display::Rect(240, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TextOut12x9(MenuData[MenuStatus[MENU_DISPLAY][2]], 218 + MenuDataDef[MenuStatus[MENU_DISPLAY][2]], 455, 1, Buffer_UI2Plane);
			}

			break;
		}
		
		// Save / Recall Menu
		case 8:
		{		
			while (rbuf > 0)
			{				
				switch(Direction)
				{
				case 0: if (SavePointer > 1) SavePointer--; break;
				case 1: if (SavePointer < 80) SavePointer++; break;
				}
				rbuf--;
			}
		
			Display::ClearMenuItemTextAsm(0, 36320, 16);			// clear text (old value)
			Display::DrawMenuItem(MENU_SAVE,0, 1);//, 0);			// write text (new value) in second button row

			//MenuItemChanged[0] = 1;
			//New_Menu = 8;
			//Menu_Changed = 1;
		
			break;	            			
		}
		
		// Edge Mode/Coupling Menu  -> Holdoff and probe predivider ratio
		case 12:
		{
			// new encoder characteristic
			if (rbuf < 4)
			{ if (HoldOff_Expo == 1){ HoldOff_Steps = 8;} else{HoldOff_Steps = 1; } }
			else if (rbuf > 3 && rbuf < 7)
			{ HoldOff_Steps = 10; }
			else if (rbuf > 6 && rbuf < 11)
			{ HoldOff_Steps = 100; }
			else if (rbuf > 10 && rbuf < 14)
			{ HoldOff_Steps = 1000; }
			else
			{ HoldOff_Steps = 5000; }

			if (MenuBtnFocus[MENU_TRIGGERMODE] == 3) 	// holdoff button active
			{
		
				if (Direction)
				{ 
					HoldOff_Value += (HoldOff_Steps * rbuf);
					//Limiter -> maximum hold off is ca. 134ms	
					if ((HoldOff_Expo > 1) && (HoldOff_Value >= 134000))
					{ HoldOff_Expo = 2; HoldOff_Value = 134000; }
				}
				else
				{
					HoldOff_Value -= (HoldOff_Steps * rbuf);
					//Limiter	
					if ((HoldOff_Expo == 1) && (HoldOff_Value <= 0))
					{ HoldOff_Value = 0; ConfigChanged = 1; } 
				}
		
				if (HoldOff_Value >= 1000000 && HoldOff_Expo < 3)	//switch to next higher exponent
				{
					HoldOff_Value = 1000;
					HoldOff_Steps = 1;
					HoldOff_Expo++;
				}
				else if (HoldOff_Value <= 0)	//switch to next lower exponent
				{
					if (HoldOff_Expo > 2)		//switch down to µs
					{
						HoldOff_Expo--;
						HoldOff_Value = 99999;
						HoldOff_Steps = 1;
					}
					else if (HoldOff_Expo == 2)	//switch down to ns
					{
						HoldOff_Expo  = 1;
						HoldOff_Value = 992; //960;
						HoldOff_Steps = 8;   //40;
					}
				}



				switch(HoldOff_Expo)
				{
					case 1:	// 0 - 992.992 µs
					{
						//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000000);	// 10^9
						HoldOff.Write_Value((float) HoldOff_Value * 0.000000001);		// 10^9
						break;
					}
					case 2: // 1000000 µs - 150 ms
					{
						//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000000);		// 10^6	
						HoldOff.Write_Value((float) HoldOff_Value * 0.000001);			// 10^6	
						break;
					}
					case 3: // -> not needed
					{
						//HoldOff.Write_Value((float) HoldOff_Value / (float) 1000); 		// 10^3
						HoldOff.Write_Value((float) HoldOff_Value * 0.001); 			// 10^3
						break;
					}
					case 4: // -> BF not needed
					{
						HoldOff.Write_Value((float) HoldOff_Value);
						break;
					}
				}
		
				HoldOff.RenderText();									// render text string
				Display::ClearMenuItemTextAsm(3, 36320, 16);						// clear text (old value)
				Display::DrawMenuItem(MENU_TRIGGERMODE,3, 1);//, 0);					// write text (new value) in second button row

				Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);		// load trigger setup to execution queue
			}
			else if (MenuBtnFocus[MENU_TRIGGERMODE] == 4)	//probe button active
			{
				if (rbuf > 0)
				{	
					while (rbuf > 0)
					{
						switch(Direction)
						{
							case 0: if (MenuStatus[MENU_TRIGGERMODE][4] > 101) {MenuStatus[MENU_TRIGGERMODE][4]--; } break;
							case 1: if (MenuStatus[MENU_TRIGGERMODE][4] < 113) {MenuStatus[MENU_TRIGGERMODE][4]++; } break;
						}
						rbuf--;
					}
		
					Display::ClearMenuItemTextAsm(4, 36320, 16);						// clear text (old value)
					Display::DrawMenuItem(MENU_TRIGGERMODE,4, 1);//, 0);					// write text (new value) in second button row
				}
			}
			doit = false;	

			break;
		}		
			
		
		//Edge Menu -> Pre Trigger
		case 14: 
		{	
			//int lStepWidth

			if (XY_Mode) return;
			//if(FFT_Mode != FFT_OFF) return;
			if(USTB_Mode != USTB_OFF) return;
			
			//BFTEST	
			//printf("Trig_Pos_Mem : %d  Rotation buffer : %d Trig_Pos_Display : %d\r\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);
/*
			if (draw_factor < 3 || MainTimebase == 6)
			{ rbuf =  ((rbuf * rbuf * rbuf)>>1) + rbuf; }
			else if (draw_factor > 5 )
			{ rbuf =  ((rbuf * rbuf * rbuf) / (draw_factor/5)) + rbuf; }
			else
			{ rbuf = (rbuf * rbuf) + rbuf; }
*/
			if (rbuf < 11)
			{ rbuf = (((rbuf*rbuf)>>1) + 1) * draw_factor; }	//flat square 0.5X²
			else
			{
				if (MainTimebase < 7)
			 	rbuf = ((rbuf*rbuf)<<1)*draw_factor;		//straight square 2X²
				else
			 	rbuf = rbuf*rbuf*draw_factor;			//square X²
			}

			//printf("  rbuf = %d\r\n",rbuf);

			while (rbuf > 0)
			{
				if (RotaryDirection)
				{
					if (Trig_Pos_Mem < TrigPosMax)
					Trig_Pos_Mem++ ;
					else
					Trig_Pos_Mem = TrigPosMax;
				}
				else
				{
					if (Trig_Pos_Mem >= MemStartOffs) 
					Trig_Pos_Mem--;
					else
					Trig_Pos_Mem = MemStartOffs;
				}
				rbuf--;
			}	
			Display::CalcPreTriggerPos();
			Hardware::CaptureSetupADC();
				
			//printf("Trig_Pos_Mem : %d  Rotation buffer : %d Trig_Pos_Display : %d\r\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);
			
			if (Memory_Window_visible) 						// if Memory Window visible
				Display::RefreshMemoryBrowser(); 				// redraw Memory Window
			else
				Display::OpenMemoryBrowser(); 					// if Memory Window not visible yet, make it visible.
		
			Display::DRAW_ALL_CURSOR();
		
			Display::CALCPRETRIGGER();
			//Hardware::SetReadoutLength();
			
			Display::ClearMenuItemTextAsm(5, 36320, 16);		// clear text (old value)
			Display::DrawMenuItem(MENU_TRIGGEREDGE,5, 1);//, 0);	// write text (new value) in second button row

			doit = false;

			break;
		}

        	// Pulse/Width menu
		case 15:
		{
			if (MenuBtnFocus[MENU_PULSEWIDTH] == 5)  //(PulseToggle == 3)		// focus on F6 pretrigger
			{
				if (rbuf < 11)
				{ rbuf = (((rbuf*rbuf)>>1) + 1) * draw_factor; }		//flat square 0.5X²
				else
				{
					if (MainTimebase < 7)
					rbuf = ((rbuf*rbuf)<<1)*draw_factor;			//straight square 2X²
					else
					rbuf = rbuf*rbuf*draw_factor;				//square X²
				}
	
				//printf("  rbuf = %d\r\n",rbuf);
	
				while (rbuf > 0)
				{
					if (RotaryDirection)
					{
						if (Trig_Pos_Mem < TrigPosMax)
						Trig_Pos_Mem++ ;
						else
						Trig_Pos_Mem = TrigPosMax;
					}
					else
					{
						if (Trig_Pos_Mem >= MemStartOffs) 
						Trig_Pos_Mem--;
						else
						Trig_Pos_Mem = MemStartOffs;
					}
					rbuf--;
				}	
				Display::CalcPreTriggerPos();
				Hardware::CaptureSetupADC();
					
				//printf("Trig_Pos_Mem : %d  Rotation buffer : %d Trig_Pos_Display : %d\r\n", Trig_Pos_Mem, rot_buf, Trig_Pos_Display);
				
				if (Memory_Window_visible) 						// if Memory Window visible
					Display::RefreshMemoryBrowser(); 				// redraw Memory Window
				else
					Display::OpenMemoryBrowser(); 					// if Memory Window not visible yet, make it visible.
					
				Display::DRAW_ALL_CURSOR();
			
				Display::CALCPRETRIGGER();
				Display::ClearMenuItemTextAsm(5, 36320, 16);		// clear text (old value)
				Display::DrawMenuItem(MENU_PULSEWIDTH,5, 1);//, 0);	// write text (new value) in second button row
			
			}
			else if (MenuStatus[MENU_PULSEWIDTH][2] == 3)     									// pulse width range (><)
			{
		
				//printf("A Dir %d PT %d \n", Direction, PulseToggle);
				//printf("A PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
				//printf("A PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);
		
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 3)   //(PulseToggle == 1)							//lower limit (F-button 4) -> greater than...
				{
					while (rbuf > 0)
					{
						if (Direction)
						{
							if ((Pulse11_Expo == 3) && (Pulse11_Value >= 268)) break;
							// if ((Pulse12_Expo == 3) && (Pulse12_Value >= 268)) break;
							Pulse11_Value = Pulse11_Value + Pulse11_Steps;
						}
						else
						{
							if ((Pulse11_Expo == 1) && (Pulse11_Value <= 16)) break;
							Pulse11_Value = Pulse11_Value - Pulse11_Steps;
						}
			
						if (Pulse11_Value >= 1000)
						{
							Pulse11_Value = 1;
							Pulse11_Steps = 1;
							Pulse11_Expo++;
						}
						else if ((Pulse11_Value >= 100) && (Pulse11_Expo == 2))
						{ Pulse11_Steps = 1; }
						else if (Pulse11_Value <= 0)
						{
							if (Pulse11_Expo == 3)
							{
								Pulse11_Expo--;
								Pulse11_Value = 999;
								Pulse11_Steps = 1;
							}
							else if (Pulse11_Expo == 2)
							{
								Pulse11_Expo = 1;
								Pulse11_Value = 992;
								Pulse11_Steps = 8;
							}
						}
						rbuf--;
					}
		
					switch(Pulse11_Expo)											// calculate output string
					{
						case 1:
						{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000); break; }
						case 2:
						{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000); break; }
						case 3:
						{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000); break; }
					}
					Pulse11.RenderText();
					
					Display::ClearMenuItemTextAsm(3, 36320, 16);								// clear text (old value)
					Display::DrawMenuItem(MENU_PULSEWIDTH,3, 1);//, 0);								// write text (new value) in second button row

					if ((Pulse11_Value >= Pulse12_Value) && (Pulse11_Expo == Pulse12_Expo))					// check upper limit and correct it if needed
					{
						Pulse12_Value = Pulse11_Value + Pulse12_Steps;
						switch(Pulse12_Expo)
						{
							case 1:
							{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000); break; }
							case 2:
							{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);	break; }
							case 3:
							{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000); break; }
						}
						Pulse12.RenderText();
	
						Display::ClearMenuItemTextAsm(4, 36320, 16);							// clear text (old value)
						Display::DrawMenuItem(MENU_PULSEWIDTH,4, 1);//, 0);							// write text (new value) in second button row
					}

				}
				else if (MenuBtnFocus[MENU_PULSEWIDTH] == 4)									// upper limit (F-button 5) -> smaller than...
				{
					while (rbuf > 0)
					{
						if (Direction)
						{
						if ((Pulse12_Expo == 2) && (Pulse12_Value >= 524)) break;
						Pulse12_Value = Pulse12_Value + Pulse12_Steps;
						}
						else
						{
						if ((Pulse12_Expo == 1) && (Pulse12_Value <= 8)) break;
						Pulse12_Value = Pulse12_Value - Pulse12_Steps;
						}
			
						if (Pulse12_Value >= 1000)
						{
						Pulse12_Value = 1;
						Pulse12_Steps = 1;
						Pulse12_Expo++;
						}
						else if ((Pulse12_Value >= 100) && (Pulse12_Expo == 2))
						{
						Pulse12_Steps = 1;
						}
						else if (Pulse12_Value <= 0)
						{
						if (Pulse12_Expo == 3)
						{
							Pulse12_Expo--;
							Pulse12_Value = 999;
							Pulse12_Steps = 1;
						}
						else if (Pulse12_Expo == 2)
						{
							Pulse12_Expo = 1;
							Pulse12_Value = 992;
							Pulse12_Steps = 8;
						}
						}
						rbuf--;
					}
		
					switch(Pulse12_Expo)
					{
						case 1:
						{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000000); break; }
						case 2:
						{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000000);	break; }
						case 3:
						{ Pulse12.Write_Value((float) Pulse12_Value / (float) 1000); break; }
					}
					Pulse12.RenderText();

					Display::ClearMenuItemTextAsm(4, 36320, 16);								// clear text (old value)
					Display::DrawMenuItem(MENU_PULSEWIDTH,4, 1);//, 0);								// write text (new value) in second button row

					if ((Pulse11_Value >= Pulse12_Value) && (Pulse11_Expo == Pulse12_Expo))					// check lower limit and correct it if needed
					{
						Pulse11_Value = Pulse12_Value - Pulse11_Steps;
						switch(Pulse11_Expo)										// calculate output string
						{
							case 1:
							{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000000); break; }
							case 2:
							{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000000); break; }
							case 3:
							{ Pulse11.Write_Value((float) Pulse11_Value / (float) 1000); break; }
						}
						Pulse11.RenderText();
						
						Display::ClearMenuItemTextAsm(3, 36320, 16);							// clear text (old value)
						Display::DrawMenuItem(MENU_PULSEWIDTH,3, 1);//, 0);							// write text (new value) in second button row
					}

				}
		
				//trig_range_reg = (unsigned int) (Pulse12.Read_Value() / (float) 0.000000008);
				//trig_width_reg = (unsigned int) (Pulse11.Read_Value() / (float) 0.000000008);

				//printf("B PV11 %d PE11 %d PS11 %d\n", Pulse11_Value, Pulse11_Expo, Pulse11_Steps);
				//printf("B PV12 %d PE12 %d PS12 %d\n", Pulse12_Value, Pulse12_Expo, Pulse12_Steps);

			}
			else															// width (< >)
			{
				if (MenuBtnFocus[MENU_PULSEWIDTH] == 3)   //(PulseToggle == 1)							// upper limit (F-button 4) smaller than...
				{
					while (rbuf > 0)
					{
						if (Direction)
						{
						if ((Pulse21_Expo == 3) && (Pulse21_Value >= 268)) break;
						Pulse21_Value = Pulse21_Value + Pulse21_Steps;
						}
						else
						{
						if ((Pulse21_Expo == 1) && (Pulse21_Value <= 16)) break;
						Pulse21_Value = Pulse21_Value - Pulse21_Steps;
						}
			
						if (Pulse21_Value >= 1000)
						{
						Pulse21_Value = 1;
						Pulse21_Steps = 1;
						Pulse21_Expo++;
						}
						else if ((Pulse21_Value >= 100) && (Pulse21_Expo == 2))
						{
						Pulse21_Steps = 10;
						}
						else if (Pulse21_Value <= 0)
						{
						if (Pulse21_Expo > 2)
						{
							Pulse21_Expo--;
							Pulse21_Value = 999;
							Pulse21_Steps = 1;
						}
						else if (Pulse21_Expo > 1)
						{
							Pulse21_Expo = 1;
							Pulse21_Value = 992;
							Pulse21_Steps = 8;
						}
						}
						rbuf--;
					}
		
					switch(Pulse21_Expo)
					{
						case 1:
						{
						Pulse21.Write_StepSize(0.000000008);
						Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000000);
						break;
						}
						case 2:
						{
						Pulse21.Write_StepSize(0.0000001);
						Pulse21.Write_Value((float) Pulse21_Value / (float) 1000000);
						break;
						}
						case 3:
						{
						Pulse21.Write_StepSize(0.001);
						Pulse21.Write_Value((float) Pulse21_Value / (float) 1000);
						break;
						}
					}
			
					Pulse21.RenderText();
					Display::ClearMenuItemTextAsm(3, 36320, 16);									// clear text (old value)
					Display::DrawMenuItem(MENU_PULSEWIDTH,3, 1);//, 0);								// write text (new value) in second button row
			
					//trig_width_reg = (unsigned int) ((Pulse21.Read_Value() / (float) 0.000000008));
				}
				else if (MenuBtnFocus[MENU_PULSEWIDTH] == 4)										//limit 2 button (F-button 5) -> greater than...
				{
					while (rbuf > 0)
					{
						if (Direction)
						{
							if ((Pulse22_Expo == 3) && (Pulse22_Value >= 268)) break;
							Pulse22_Value = Pulse22_Value + Pulse22_Steps;
						}
						else
						{
							if ((Pulse22_Expo == 1) && (Pulse22_Value <= 16)) break;
							Pulse22_Value = Pulse22_Value - Pulse22_Steps;
						}
				
						if (Pulse22_Value >= 1000)
						{
							Pulse22_Value = 1;
							Pulse22_Steps = 1;
							Pulse22_Expo++;
						}
						else if ((Pulse22_Value >= 100) && (Pulse22_Expo == 2))
						{
							Pulse22_Steps = 10;
						}
						else if (Pulse22_Value <= 0)
						{
							if (Pulse22_Expo > 2)
							{
								Pulse22_Expo--;
								Pulse22_Value = 999;
								Pulse22_Steps = 1;
							}
							else if (Pulse22_Expo > 1)
							{
								Pulse22_Expo = 1;
								Pulse22_Value = 992;
								Pulse22_Steps = 8;
							}
						}
						rbuf--;
					}
		
					switch(Pulse22_Expo)
					{
						case 1:
						{
							Pulse22.Write_StepSize(0.000000008);
							Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000000);
							break;
						}
						case 2:
						{
							Pulse22.Write_StepSize(0.0000001);
							Pulse22.Write_Value((float) Pulse22_Value / (float) 1000000);
							break;
						}
						case 3:
						{
							Pulse22.Write_StepSize(0.001);
							Pulse22.Write_Value((float) Pulse22_Value / (float) 1000);
							break;
						}
					}
		
					Pulse22.RenderText();
					Display::ClearMenuItemTextAsm(4, 36320, 16);								// clear text (old value)
					Display::DrawMenuItem(MENU_PULSEWIDTH,4, 1);//, 0);								// write text (new value) in second button row
			
					//trig_width_reg = (unsigned int) ((Pulse22.Read_Value() / (float) 0.000000008));
				}
			}
		
			//New_Menu = 15;
			//Menu_Changed = 0;
			Hardware::SetDelayTimer2(60, &Hardware::SetupTrigger);	// load trigger setup to execution queue

			doit = false;
	
			break;
		}

		//------------------------------------------------------------------------------------------
		//				Cursor
		//------------------------------------------------------------------------------------------
		case 16: // Main Wheel -> Cursor
		{	
			int32_t lVertCursorMax;
			int32_t rot_buf;
			
			long lCursor_Vertical_Position1;
			long lCursor_Vertical_Position2;
			long lCursorDelta;

			if (!Cursor_Enabled) break;
	
			if (Signal::_FFT_Mode != FFT_OFF)
			{ lVertCursorMax = GRID_WIDTH_FFT; lCursor_Vertical_Position1 = Cursor_Vertical_Position_FFT_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_FFT_2; }
			else if (XY_Mode)
			{ lVertCursorMax = GRID_XY; lCursor_Vertical_Position1 = Cursor_Vertical_Position_XY_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_XY_2; }
			else
			{ lVertCursorMax = GRID_WIDTH; lCursor_Vertical_Position1 = Cursor_Vertical_Position_TY_1; lCursor_Vertical_Position2 = Cursor_Vertical_Position_TY_2; }

			rot_buf = ((RotarySteps * RotarySteps) >> 2) + 1; 	//BF new square function characteristic 1/4 * X² + 1
	
			if (Cursor_Horizontal_Active == 3)	
			{
				switch(Cursor_Vertical_Active)
				{
					case 1: // Cursor X1 is active
					{
						CursorChanged = 1;					
						//BF test #111 MenuButtonCheck(1);
						MenuItemChanged[1] = 1;

						switch(Direction)
						{
							case 0:
							{ lCursor_Vertical_Position1 -= rot_buf;	break; }
							case 1:
							{ lCursor_Vertical_Position1 += rot_buf;	break; }
						}

						//Limiter
						if (lCursor_Vertical_Position1 > lVertCursorMax) lCursor_Vertical_Position1 = lVertCursorMax;
						else if (lCursor_Vertical_Position1 < 0) lCursor_Vertical_Position1 = 0;	
	

						break;
					}
					case 2: // Cursor X2 is active
					{
						CursorChanged = 2;
						//BF test #111 MenuButtonCheck(2);
						MenuItemChanged[2] = 1;

						switch(Direction)
						{
							case 0:
							{	lCursor_Vertical_Position2 -= rot_buf;
								break;
							}
							case 1:
							{
								lCursor_Vertical_Position2 += rot_buf;
								break;
							}
						}

						//Limiter
						if (lCursor_Vertical_Position2 > lVertCursorMax) lCursor_Vertical_Position2 = lVertCursorMax;
						else if (lCursor_Vertical_Position2 < 0) lCursor_Vertical_Position2 = 0;

						break;
					}	
					case 4: // delta cursor X1/X2 is active
					{
						CursorChanged = 1;
	
						switch(Direction)
						{
							case 0:
							{
								lCursor_Vertical_Position1 -= rot_buf;
								lCursor_Vertical_Position2 -= rot_buf;

								break;
							}
							case 1:
							{
								lCursor_Vertical_Position1 += rot_buf;
								lCursor_Vertical_Position2 += rot_buf;

								break;
							}
						}

						//Limiter
						if (lCursor_Vertical_Position1 > lVertCursorMax) 
						{
							lCursorDelta = lCursor_Vertical_Position1 - lCursor_Vertical_Position2;
							lCursor_Vertical_Position1 = lVertCursorMax;
							lCursor_Vertical_Position2 = lCursor_Vertical_Position1 - lCursorDelta;
						}
						else if (lCursor_Vertical_Position1 < 0)
						{
							lCursorDelta = lCursor_Vertical_Position1 - lCursor_Vertical_Position2;
							lCursor_Vertical_Position1 = 0;
							lCursor_Vertical_Position2 = lCursor_Vertical_Position1 - lCursorDelta;
						}

						if (lCursor_Vertical_Position2 > lVertCursorMax) 
						{
							lCursorDelta = lCursor_Vertical_Position2 - lCursor_Vertical_Position1;
							lCursor_Vertical_Position2 = lVertCursorMax;
							lCursor_Vertical_Position1 = lCursor_Vertical_Position2 - lCursorDelta;
						}
						else if (lCursor_Vertical_Position1 < 0)
						{
							lCursorDelta = lCursor_Vertical_Position2 - lCursor_Vertical_Position1;
							lCursor_Vertical_Position2 = 0;
							lCursor_Vertical_Position1 = lCursor_Vertical_Position2 - lCursorDelta;
						}



						break;
					}	
				}
			}	
			else if (Cursor_Vertical_Active == 3)
			{
				switch(Cursor_Horizontal_Active)
				{
					case 1:		// cursor Y1 is active
					{
						CursorChanged = 4;
						//BF test #111 MenuButtonCheck(3);
						MenuItemChanged[3] = 1;
						
						switch(Direction)
						{
							case 0:
							{
								if ((Cursor_Horizontal_Position_Real1 + rot_buf) < GRID_HEIGHT)
								{ Cursor_Horizontal_Position_Real1 += rot_buf; }
								else
								{ Cursor_Horizontal_Position_Real1 = GRID_HEIGHT; }

								break;
							}							
							case 1:
							{
								if ((Cursor_Horizontal_Position_Real1 - rot_buf) > 0)
								{ Cursor_Horizontal_Position_Real1 -= rot_buf; }
								else
								{ Cursor_Horizontal_Position_Real1 = 0; }

								break;
							}
						}
						break;
					}
					case 2:		// cursor Y2 is active
					{
						CursorChanged = 5;
						//BF test #111 MenuButtonCheck(4);
						MenuItemChanged[4] = 1;
						
						switch(Direction)
						{
							case 0:
							{
								if ((Cursor_Horizontal_Position_Real2 + rot_buf) < GRID_HEIGHT)
								{ Cursor_Horizontal_Position_Real2 += rot_buf; }
								else
								{ Cursor_Horizontal_Position_Real2 = GRID_HEIGHT; }

								break;
							}							
							case 1:
							{
								if ((Cursor_Horizontal_Position_Real2 - rot_buf) > 0)
								{ Cursor_Horizontal_Position_Real2 -= rot_buf; }
								else
								{ Cursor_Horizontal_Position_Real2 = 0; }

								break;
							}
						}
						break;
					}
					case 4:		// delta cursor Y1/Y2 is active
					{
						CursorChanged = 4;
						
						switch(Direction)
						{
							case 0:
							{
								if ((Cursor_Horizontal_Position_Real1 + rot_buf) > GRID_HEIGHT) rot_buf = GRID_HEIGHT - Cursor_Horizontal_Position_Real1;
								if ((Cursor_Horizontal_Position_Real2 + rot_buf) > GRID_HEIGHT) rot_buf = GRID_HEIGHT - Cursor_Horizontal_Position_Real2;

								Cursor_Horizontal_Position_Real1 += rot_buf;
								Cursor_Horizontal_Position_Real2 += rot_buf;

								break;
							}							
							case 1:
							{
								if ((Cursor_Horizontal_Position_Real1 - rot_buf) < 0) rot_buf = Cursor_Horizontal_Position_Real1;
								if ((Cursor_Horizontal_Position_Real2 - rot_buf) < 0) rot_buf = Cursor_Horizontal_Position_Real2;

								Cursor_Horizontal_Position_Real1 -= rot_buf;
								Cursor_Horizontal_Position_Real2 -= rot_buf;

								break;
							}
						}
							break;
					}
				}			
			}
			if (Signal::_FFT_Mode != FFT_OFF)
			{ Cursor_Vertical_Position_FFT_1 = lCursor_Vertical_Position1; Cursor_Vertical_Position_FFT_2 = lCursor_Vertical_Position2; Display::FFT_CalcCursorData();}
			else if (XY_Mode)
			{ Cursor_Vertical_Position_XY_1 = lCursor_Vertical_Position1; Cursor_Vertical_Position_XY_2 = lCursor_Vertical_Position2; Display::CALCCURSORDATA();}
			else
			{ Cursor_Vertical_Position_TY_1 = lCursor_Vertical_Position1; Cursor_Vertical_Position_TY_2 = lCursor_Vertical_Position2; Display::CALCCURSORDATA();}
			
			Display::DRAW_ALL_CURSOR();					// draw the cursor lines on the new position
			Display::DrawCursorDeltaValues(1);				// write new delta cursor values on the screen
			
			for(int i=0; i<6; i++)						// write new X1/X2/Y1/Y2 values on the active button
			{
				if(MenuItemChanged[i] == 1)
				{
					Display::ClearMenuItemTextAsm(i, 36320, 16);	//clear text (old value)
					Display::DrawMenuItem(MENU_CURSOR,i, 1);//, 0);	// write text (new value) in second button row
					MenuItemChanged[i] = 0;
				}
			}

			doit = false;	

			break;	

		} // End cursor menu
		

		// Hardware -> Beta correction (Gain)
		case 18:
		{
			//if (MenuBtnFocus[MENU_HARDWARE] != 2)return;
			char txtstr[10];
			
			while (rbuf > 0)
			{
				switch(Direction)
				{
					case 0: Hardware::_Beta -= 0.001;    break;
					case 1: Hardware::_Beta += 0.001;   break;
				}
				rbuf--;
			}

			// limiter
			if (Hardware::_Beta > 2)
			Hardware::_Beta = 2;
			else if (Hardware::_Beta * 10 <= 5)
			Hardware::_Beta = 0.5;
			
			Signal::BuildScaleLookupTable();
			
			Display::ClearMenuItemTextAsm(2, 36320, 16);			// clear text (old value)
			//Display::DrawMenuItem(MENU_HARDWARE, 2, 1);//, 0);		// write text (new value) in second button row
			ftostr(txtstr, 3, Hardware::_Beta);
			Display::TextOut12x9(txtstr, 248, 455, 1, Buffer_UI2Plane); 	// Draw gain value	
			
			Hardware::SetDelayTimer1(120, &UserIF::DispatchGain);		// activate and save
			
			break;
		}

		case 19:	//MENU_QUICKMEASURE -> select
		{
			if (QM_Enabled == 0) break; 		
		
			while (rbuf > 0)
			{
				pos = -1;
				if (Direction==0)
				{ MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &pos, MENU_QUICKMEASURE, 52, 2); }
				else
				{ MenuPopupStep(4, &MenuStatus[MENU_QUICKMEASURE][1], &MenuStatus[MENU_QUICKMEASURE][2], &pos, MENU_QUICKMEASURE, 52, 1); }

				rbuf--;
			}

			// special menu settings for QM Delay/Phase
			if ((MenuStatus[MENU_QUICKMEASURE][1] == 53) || (MenuStatus[MENU_QUICKMEASURE][1] == 61))	// Delay or Phase is selected
			{
				if (MenuStatus[MENU_QUICKMEASURE][4] == DOWN_ARROW_INACTIVE)				// if submenu path inactive
				{	
					MenuStatus[MENU_QUICKMEASURE][4] = DOWN_ARROW;					// set submenu path active
					MenuStatus[MENU_QUICKMEASURE][0] = INACTIVE;
				}
						
			}
			else												// any other function is selected
			{
				if (MenuStatus[MENU_QUICKMEASURE][4] == DOWN_ARROW)					// if submenu path active
				{
					MenuStatus[MENU_QUICKMEASURE][4] = DOWN_ARROW_INACTIVE;				// set submenu path inactive
					MenuStatus[MENU_QUICKMEASURE][0] = QM_Source;					// restore main source popup menu
				}
			}

			New_Menu = MENU_QUICKMEASURE;
			Menu_Changed = 1;
			MenuAktive_old = 0;										// trigger button update
			break;
		}		

		case 22:	//MENU_QMTHRESHOLDS -> upper/middle/lower
		{
			if (QM_Enabled == 0) break;

			short QM_thr_ch = MenuStatus[MENU_QMTHRESHOLDS][0] - 27;

			while (rbuf > 0)
			{
				switch(Quick_Measure_Threshold_btn_select)
				{
					case 1:
					{
						MenuItemChanged[2] = 1;
							
						QM_Threshold_lower.DoStep(Direction);
						QM_Threshold_lower.RenderText();
						thres_low[QM_thr_ch] = (short) QM_Threshold_lower.Read_Value();
			
						if (thres_low[QM_thr_ch] > thres_mdl[QM_thr_ch])
						{ thres_mdl[QM_thr_ch] = thres_low[QM_thr_ch] + 1; QM_Threshold_middle.Write_Value((float)thres_mdl[QM_thr_ch]); QM_Threshold_middle.RenderText(); MenuItemChanged[3] = 1; }
						if (thres_mdl[QM_thr_ch] > thres_up[QM_thr_ch])
						{ thres_up[QM_thr_ch] = thres_mdl[QM_thr_ch] + 1; QM_Threshold_upper.Write_Value((float)thres_up[QM_thr_ch]); QM_Threshold_upper.RenderText(); MenuItemChanged[4] = 1; }
						break;
					}
					case 2:
					{
						MenuItemChanged[3] = 1;
			
						QM_Threshold_middle.DoStep(Direction);
						QM_Threshold_middle.RenderText();
						thres_mdl[QM_thr_ch] = (short) QM_Threshold_middle.Read_Value();

						if (thres_mdl[QM_thr_ch] >= thres_up[QM_thr_ch])
						{ thres_up[QM_thr_ch] = thres_mdl[QM_thr_ch] + 1; QM_Threshold_upper.Write_Value((float)thres_up[QM_thr_ch]); QM_Threshold_upper.RenderText(); MenuItemChanged[4] = 1; }
						if (thres_mdl[QM_thr_ch] <= thres_low[QM_thr_ch])
						{ thres_low[QM_thr_ch] = thres_mdl[QM_thr_ch] - 1; QM_Threshold_lower.Write_Value((float)thres_low[QM_thr_ch]); QM_Threshold_lower.RenderText(); MenuItemChanged[2] = 1; }
						break;
					}
					case 3:
					{
						MenuItemChanged[4] = 1;
			
						QM_Threshold_upper.DoStep(Direction);
						QM_Threshold_upper.RenderText();
						thres_up[QM_thr_ch] = (short) QM_Threshold_upper.Read_Value();

						if (thres_up[QM_thr_ch] <= thres_mdl[QM_thr_ch])
						{ thres_mdl[QM_thr_ch] = thres_up[QM_thr_ch] - 1; QM_Threshold_middle.Write_Value((float)thres_mdl[QM_thr_ch]); QM_Threshold_middle.RenderText(); MenuItemChanged[3] = 1; }
						if (thres_mdl[QM_thr_ch] <= thres_low[QM_thr_ch])
						{ thres_low[QM_thr_ch] = thres_mdl[QM_thr_ch] - 1; QM_Threshold_lower.Write_Value((float)thres_low[QM_thr_ch]); QM_Threshold_lower.RenderText(); MenuItemChanged[2] = 1; }
						break;
					}
				}
				rbuf--;
			}

			//BF del Hardware::ResetTimer3(TimerRotPeriod);
			New_Menu = 22;
			Menu_Changed = 1;

            	
			break;
		}
		

		//-----------------------------------------------------------
		// Signal delay compensation  channel 1 - 4
		//-----------------------------------------------------------
		case 25:	//MENU_EXTUTILS
		{
			if (MenuBtnFocus[MENU_EXTUTILS] == 0)
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(33, &MenuStatus[MENU_EXTUTILS][0], &pos, &pos, 25, 203, 2); }
					else
					{ MenuPopupStep(33, &MenuStatus[MENU_EXTUTILS][0], &pos, &pos, 25, 203, 1); }

					rbuf--;
				}
				Hardware::_ChannelDelay[0] = MenuStatus[MENU_EXTUTILS][0] - 203;			
			}
			else if (MenuBtnFocus[MENU_EXTUTILS] == 1)
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(34, &MenuStatus[MENU_EXTUTILS][1], &pos, &pos, 25, 203, 2); }
					else
					{ MenuPopupStep(34, &MenuStatus[MENU_EXTUTILS][1], &pos, &pos, 25, 203, 1); }

					rbuf--;
				}
				Hardware::_ChannelDelay[1] = MenuStatus[MENU_EXTUTILS][1] - 203;
			}
			else if (MenuBtnFocus[MENU_EXTUTILS] == 2)
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(35, &MenuStatus[MENU_EXTUTILS][2], &pos, &pos, 25, 203, 2); }
					else
					{ MenuPopupStep(35, &MenuStatus[MENU_EXTUTILS][2], &pos, &pos, 25, 203, 1); }

					rbuf--;
				}
				Hardware::_ChannelDelay[2] = MenuStatus[MENU_EXTUTILS][2] - 203;
			}
			else if (MenuBtnFocus[MENU_EXTUTILS] == 3)
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(36, &MenuStatus[MENU_EXTUTILS][3], &pos, &pos, 25, 203, 2); }
					else
					{ MenuPopupStep(36, &MenuStatus[MENU_EXTUTILS][3], &pos, &pos, 25, 203, 1); }

					rbuf--;
				}
				Hardware::_ChannelDelay[3] = MenuStatus[MENU_EXTUTILS][3] - 203;
			}

			New_Menu = MENU_EXTUTILS;
			Menu_Changed = 1;
			Hardware::SetDelayTimer1(120, &AMDFlash::WriteCalibration);	// save to calibration sector delayed
			
			break;
		}





		//-----------------------------------------------------------
		// Math Settings - Scale and Offset
		//-----------------------------------------------------------
		case 26:
		{		
			// set new scale factors
			if (MenuBtnFocus[MENU_MATH] == 0)
			{
				// delete second row in button
				//Display::ClearMenuItemTextAsm(0, 35040, 32);
				Display::ClearMenuItemTextAsm(0, 36320, 14);
				//Display::ClearMenuItemTextAsm(1, 36320, 14);
				
				// calculate new value
				while (rbuf > 0)
				{				
					switch(Direction)
					{
						case 0:
						{
							if (MenuStatus[MENU_MATH][2] == BTN_ON){ if (math_mul_scale > 166) math_mul_scale--; }
							else if (MenuStatus[MENU_MATH][3] == BTN_ON){ if (math_sub_scale > 153) math_sub_scale--; }
							else if (MenuStatus[MENU_MATH][4] == BTN_ON){ if (math_add_scale > 153) math_add_scale--; }
							break;
						}

						case 1:
						{
							if (MenuStatus[MENU_MATH][2] == BTN_ON){ if (math_mul_scale < 181) math_mul_scale++; }
							else if (MenuStatus[MENU_MATH][3] == BTN_ON){ if (math_sub_scale < 165) math_sub_scale++; }
							else if (MenuStatus[MENU_MATH][4] == BTN_ON){ if (math_add_scale < 165) math_add_scale++; }
							break;
						}
					}
					rbuf--;
				}
			
				// write new text in second button row
				Display::DrawMenuItem(MENU_MATH,0, 1);//, 0);	// scale
				//Display::DrawMenuItem(MENU_MATH,1, 1, 0);	// offset
				rbuf = 0;
			}

			// set new offsets
			//if (MathToggle == 1)	-> fall through
			if (MenuBtnFocus[MENU_MATH] == 1)
			{	int lgain = 0;

				if (GainIdx!=0) lgain = 1;
				Display::ClearMenuItemTextAsm(1, 36320, 14);
	
				if (MenuStatus[MENU_MATH][2] == BTN_ON) // function key 3 - multiply
				{
					if (Direction)
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
							
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Mul_Offset/steps;				// in which div we are?
		
							if(Math_Mul_Offset < 0)					// negative level
							{ if ((div * steps) == Math_Mul_Offset){div++;} }	// zero level was on grid division before -> next div
							else							// positive level
							{ div++; } 						// next grid division
							
							Math_Mul_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Mul_Offset += rbuf; }
					else
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
		
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Mul_Offset/steps;				// in which div we are? 
		
							if(Math_Mul_Offset > 0)					// positive level
							{ if ((div * steps) == Math_Mul_Offset){div--;} }	// zero level was on grid division before -> next div
							else							// negative level	
							{ div--; } 						// next grid division
							
							Math_Mul_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Mul_Offset -= rbuf; }	

					// limiter??

					Math_Offset_mul.Write_Value((float)Math_Mul_Offset * ScreenScaleFactor[math_mul_scale-166]);
					Math_Offset_mul.RenderText();

				}
				else if (MenuStatus[MENU_MATH][3] == BTN_ON) // function key 4 - subtract
				{
					//change offset value
					if (Direction)
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
							
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Sub_Offset/steps;				// in which div we are?
		
							if(Math_Sub_Offset < 0)					// negative level
							{ if ((div * steps) == Math_Sub_Offset){div++;} }	// zero level was on grid division before -> next div
							else							// positive level
							{ div++; } 						// next grid division
							
							Math_Sub_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Sub_Offset += rbuf; }
					else
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
		
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Sub_Offset/steps;				// in which div we are? 
		
							if(Math_Sub_Offset > 0)					// positive level
							{ if ((div * steps) == Math_Sub_Offset){div--;} }	// zero level was on grid division before -> next div
							else							// negative level	
							{ div--; } 						// next grid division
							
							Math_Sub_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Sub_Offset -= rbuf; }	


					// limiter??

					Math_Offset_sub.Write_Value((float)Math_Sub_Offset * ScreenScaleFactor[math_sub_scale-150]);
					Math_Offset_sub.RenderText();
	             		}
               
				else if (MenuStatus[MENU_MATH][4] == BTN_ON) // add
				{
					//change offset value
					if (Direction)
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
							
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Add_Offset/steps;				// in which div we are?
		
							if(Math_Add_Offset < 0)					// negative level
							{ if ((div * steps) == Math_Add_Offset){div++;} }	// zero level was on grid division before -> next div
							else							// positive level
							{ div++; } 						// next grid division
							
							Math_Add_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Add_Offset += rbuf; }
					else
						if (rbuf > 8)							// step width grid division 
						{
							int div, steps;
		
							if (rbuf > 12) steps = 100;				// 2 divisions	
							else steps = 50;					// 1 division	
		
							div = Math_Add_Offset/steps;				// in which div we are? 
		
							if(Math_Add_Offset > 0)					// positive level
							{ if ((div * steps) == Math_Add_Offset){div--;} }	// zero level was on grid division before -> next div
							else							// negative level	
							{ div--; } 						// next grid division
							
							Math_Add_Offset = div * steps;				// set zerolevel to next grid division
						}
						else								// step width 1 pixel 
						{ 	Math_Add_Offset -= rbuf; }	

					// limiter??

					Math_Offset_add.Write_Value((float)Math_Add_Offset * ScreenScaleFactor[math_add_scale-150]);
					Math_Offset_add.RenderText();	
		
				}

				//if (MenuStatus[MENU_MATH][2] == BTN_ON)	Display::TextOut12x9(Math_Offset_mul.Read_Text(), 129, 455, 1, Buffer_UI2Plane);
				//else if (MenuStatus[MENU_MATH][3] == BTN_ON) Display::TextOut12x9(Math_Offset_sub.Read_Text(), 129, 455, 1, Buffer_UI2Plane);
				//else if (MenuStatus[MENU_MATH][4] == BTN_ON) Display::TextOut12x9(Math_Offset_add.Read_Text(), 129, 455, 1, Buffer_UI2Plane);
				Display::DrawMenuItem(MENU_MATH,1, 1);//, 0);	// offset
			}
			
                        			
			New_Menu = 26;
			Menu_Changed = 0;
/*
printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
printf("math_sub_scale %d\n", math_sub_scale);
printf("math_add_scale %d\n", math_add_scale);
printf("math_mul_scale %d\n", math_mul_scale);

printf("Math_Off_Sub_Value %d\n", Math_Off_Sub_Value);
printf("Math_Off_Add_Value %d\n", Math_Off_Add_Value);
printf("Math_Off_Mul_Value %d\n", Math_Off_Mul_Value);
printf("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
*/
            		break;
		}//Math settings end		
		
	
		
		//-----------------------------------------------------------
		// FFT Settings - source/window/mode/length
		//-----------------------------------------------------------
		case 27:	// MENU_FFT
		{		
		
			if (MenuBtnFocus[MENU_FFT] == 0)	// source
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(29, &MenuStatus[MENU_FFT][0], &pos, &pos, MENU_FFT, 137, 2); }
					else
					{ MenuPopupStep(29, &MenuStatus[MENU_FFT][0], &pos, &pos, MENU_FFT, 137, 1); }

					rbuf--;
				}
				Hardware::FFT_Set_Channel(0);							// set active channel without backup
				Display::FFT_DrawStatus(0);							// draw FFT values in status area
			}
			else if (MenuBtnFocus[MENU_FFT] == 1)	// window
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(30, &MenuStatus[MENU_FFT][1], &pos, &pos, MENU_FFT, 193, 2); }
					else
					{ MenuPopupStep(30, &MenuStatus[MENU_FFT][1], &pos, &pos, MENU_FFT, 193, 1); }

					rbuf--;
				}
				Signal::_FFT_Windex = MenuStatus[MENU_FFT][1] - 194;
				Signal::FFT_buildTrigoTables();							// create new window
				Display::FFT_DrawStatus(0);
			}
			else if (MenuBtnFocus[MENU_FFT] == 2)	// mode
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(31, &MenuStatus[MENU_FFT][2], &pos, &pos, MENU_FFT, 66, 2); }
					else
					{ MenuPopupStep(31, &MenuStatus[MENU_FFT][2], &pos, &pos, MENU_FFT, 66, 1); }

					rbuf--;
				}
				Signal::_FFT_Mode = MenuStatus[MENU_FFT][2] - 65;
				Signal::FFT_buildScaleLookupTable();
			}
			else if (MenuBtnFocus[MENU_FFT] == 3)
			{
				while (rbuf > 0)
				{
					pos = -1;
					if (Direction == 0)
					{ MenuPopupStep(32, &MenuStatus[MENU_FFT][3], &pos, &pos, MENU_FFT, 83, 2); }
					else
					{ MenuPopupStep(32, &MenuStatus[MENU_FFT][3], &pos, &pos, MENU_FFT, 83, 1); }

					rbuf--;
				}

				// FFT 512
				if (MenuStatus[MENU_FFT][3] == 83)
				{ Signal::_FFT_Length = FFT_512; Signal::_FFT_Level = 9; }
				// FFT 1024
				else if (MenuStatus[MENU_FFT][3] == 84)
				{ Signal::_FFT_Length = FFT_1K; Signal::_FFT_Level = 10; }
				// FFT 2048
				else if (MenuStatus[MENU_FFT][3] == 85)
				{ Signal::_FFT_Length = FFT_2K; Signal::_FFT_Level = 11; }
				// FFT 4096
				else if (MenuStatus[MENU_FFT][3] == 86)
				{ Signal::_FFT_Length = FFT_4K; Signal::_FFT_Level = 12; }
				
				Signal::FFT_buildTrigoTables();
				
				//Display::RefreshScreen();
				Display::FFT_DrawStatus(0);
			}

			New_Menu = MENU_FFT;
			Menu_Changed = 1;

			break;
	
		}
		
		
		
/* BF -> transferred to 5 display menu
		// Display FFT menu -> grid brightness
		case 28:
		{
			//if (MenuItemPushed[2] == 0) doit = true;
			//MenuButtonCheck(2);
			
			changing = false;
			
			while (rbuf > 0)
			{		
				switch(Direction)
				{
					case 0: if (GridColorArrayPos > 0){ GridColorArrayPos--; } //break;
						//if (GridColor_Val > 0x00) GridColor_Val--; break;
			
					case 1:	if (GridColorArrayPos < 3){ GridColorArrayPos++; } //break;
						//if (GridColor_Val < 0xFF) GridColor_Val++; break;	
				}
				rbuf--;
				changing = true;
			}			
			
			if (changing)
			{	
				GridColor_Val = GridColorArray[ColorPalette][GridColorArrayPos];
				Hardware::SetupADC();
	
				MenuStatus[MENU_DISPLAY][2] = GridColorArrayPos + 133;
				MenuStatus[MENU_DISPL_FFT][2] = MenuStatus[MENU_DISPLAY][2];
								
				Display::Rect(240, 454, 60, 14, 0, Buffer_UI2Plane);
				Display::TextOut12x9(MenuData[MenuStatus[MENU_DISPLAY][2]], 218 + MenuDataDef[MenuStatus[MENU_DISPLAY][2]], 455, 1, Buffer_UI2Plane);
				//Menu_Changed = 1;
			}

			break;
		}
*/		
	}	//end switch	
	
	if (doit)
	{	//printf("Do it\n");
		//Hardware::ResetTimer3();
		Display::DRAWSTATUS(Active_Menu, 1);		
		Display::DRAWSTATUS(6, 1);				// Draw TriggerLevel
		
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	UpdateMenuTextPlane = true;					// trigger plane transfer

	
}//HandleMainWheel end

//##########################################################################################################################################
// Zerolevel handler for logic processing
void UserIF::ON_LogicZero(int *VirtualZero, int *ZeroLevel)
{
	int buffer = RotarySteps;
	int lVZL_Old;

	
	if (RotarySteps != 0)
	{

		if (RotaryDirection == 0)	//counter clockwise rotary direction 
		{
			
				lVZL_Old = *VirtualZero;

				if (buffer > 10)							// step width grid division 
				{
					int div, steps;
					
					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = *VirtualZero/steps;				// in which div we are?

					if(*VirtualZero < 0)					// negative level
					{ if ((div * steps) == *VirtualZero){div++;} }		// zero level was on grid division before -> next div
					else							// positive level
					{ div++; } 						// next grid division
					
					*VirtualZero = div * steps;				// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{ 	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					*VirtualZero += buffer;
				}

				if (*VirtualZero > 4095)					// limiter
				{ *VirtualZero = 4095; } 

		}
		else	//clockwise rotary direction
		{
				lVZL_Old = *VirtualZero;

				if (buffer > 10)							// step width grid division 
				{
					int div, steps;

					if (buffer > 16) steps = 100;				// 2 divisions	
					else steps = 50;					// 1 division	

					div = *VirtualZero/steps;				// in which div we are? 

					if(*VirtualZero > 0)					// positive level
					{ if ((div * steps) == *VirtualZero){div--;} }		// zero level was on grid division before -> next div
					else							// negative level	
					{ div--; } 						// next grid division
					
					*VirtualZero = div * steps;				// set zerolevel to next grid division
				}
				else								// step width 1 pixel 
				{	
					buffer = ((RotarySteps * RotarySteps) >> 2) + RotarySteps; 	// square function characteristic 1/4 * X² + x
					*VirtualZero -= buffer;
				}	
						
				if (*VirtualZero < -4095)	 				// limiter
				{ *VirtualZero = -4095; }

		}

		VS_ZeroLevelChanged = 1;	//flag for zero sign drawing
   		ZL_changed = 1;			//flag for signal drawing
	}


	//---------------------------------------
	// 		calculate zerolevel
	//---------------------------------------
	*ZeroLevel = *VirtualZero + (GRID_HEIGHT / 2);
	if (*ZeroLevel < 0) *ZeroLevel = 0;
	if (*ZeroLevel > (GRID_HEIGHT + 1)) *ZeroLevel = (GRID_HEIGHT + 1);
	


}

//######################################################################################################################################################
// Timebase wheel handler for logic processing
void UserIF::ON_LogicTB(void)
{
	int32_t rbuf = RotarySteps;

	if (rbuf > 5) rbuf = 5;

	
	if (RotaryDirection)	//clockwise -> decrement timebase
	{
		
		// Delayed Mode
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
		{

			while (rbuf > 0 && DelayedTimebase < Dm_Sel_Tb_End[MainTimebase])
			{
				DelayedTimebase++;
				rbuf--;
			}
		}
		// Main Mode
		else		
		{	  	
			if (!Run && !SingleShot)	//BF Stop / Single / Recall / Overlay
			{
				while (rbuf > 0)
				{
					//BF #023 Lower virtual timebases are the same as the 
					//delayed timebases but with inverted sign 
					if ((VirtualTimebase >= (-1 * Dm_Sel_Tb_End[MainTimebase])) && ((MainTimebase + VirtualTimebase) > 0))
					{ VirtualTimebase--; }

					rbuf--;
				}
				
			}
			else	///Run == 1 || SingleShot == 1
			{
				while (rbuf > 0 && MainTimebase > 0)
				{
					MainTimebase--;
					rbuf--;
				}
 			}
		}
	}
	else	//direction is counterclockwise -> increment timebase
	{
        	// Delayed Mode
		if (MenuStatus[MENU_TIMEBASE][1] == BTN_ON)
		{
			while (rbuf > 0 && DelayedTimebase > 0)
			{
					DelayedTimebase--;
					rbuf--;
			}
		}  
		// Main Mode
		else
		{

			if (!Run && !SingleShot)	//BF Stop / Single / Recall / Overlay
			{
				while (rbuf > 0)
				{
					//BF #023 only for non USTB ranges, higher timebases are limited by the number of ADC-values (16384 / Zoomfactor > 600)
					//if ((ZoomFactor < 20) && (MainTimebase < 23))
					if (VirtualTimebase < 0)	//BF in the first step only allow the lower timebases because the higher timbases are making some problems
					{ VirtualTimebase++; }
			
					rbuf--;
				}
			}	
			else	//Run == 1 || SingleShot == 1
			{
				while (rbuf > 0 && MainTimebase < 20)	//10ms/div
				{
					MainTimebase++;
					rbuf--;
				}
			}
		}		
	}


	if (MenuStatus[MENU_DISPLAY][0] == BTN_ON) Hardware::ClearPlanes();		// reset persistent display

	if (MainTimebase < 11)
		ACQ_HighSpeed = 1;						// fast acquisition mode 
	else
		ACQ_HighSpeed = 0;

	Display::DRAWSTATUS(0, 1);							// update timebase status values

	Display::RecalcTimeParameters();						// calculate time parameters

	//No delayed mode for timebase 2ns
	if (MainTimebase == 0)
	{ MenuStatus[MENU_TIMEBASE][1] = INACTIVE; }	
	else
	{	// restore delayed button
		if(MenuStatus[MENU_TIMEBASE][0] == BTN_ON || MenuStatus[MENU_TIMEBASE][2] == BTN_ON || MenuStatus[MENU_TIMEBASE][3] == BTN_ON)	// if any other button is active
		MenuStatus[MENU_TIMEBASE][1] = BTN_OFF;												// set button off
		else
		MenuStatus[MENU_TIMEBASE][1] = BTN_ON;												// else set button on
	}

	if (Active_Menu == MENU_TIMEBASE)						// main/delayed menu active?
	{
		New_Menu = Active_Menu;
		Menu_Changed = 1;
	}
	
	//------------------------------------------------
	//         memory window
	//------------------------------------------------
	if (!AS_request && !RC_request)	
	{
		if (Memory_Window_visible) 						// if Memory Window visible
			Display::RefreshMemoryBrowser(); 				// redraw Memory Window
		else
			Display::OpenMemoryBrowser(); 					// if Memory Window not visible yet, make it visible.
	}
	else
	{
		if (Memory_Window_visible) 
			Display::CloseMemoryBrowser();					//close memory window
	}

 	//-------------------------------------------------
	//         Cursor
	//-------------------------------------------------
	if (Cursor_Enabled)
	{
		if (Active_Menu == MENU_CURSOR)
		{ New_Menu = Active_Menu; }

		Menu_Changed = 1;
		CursorChanged = 1;
	}
	
	//MenuStatusChanged = 1;
	
	Display::CALCCURSORDATA();

	if (ADC_Started)								//stop ADC
	{
		int timeout = 0;
		
		la_pulse->np_piodata = 0x01;						//stop record Port On
		la_pulse->np_piodata = 0x00;						//stop record Port Off	

		while (acq_ready->np_piodata == 0x01 && timeout < 100)
		{nr_delay(2); timeout++;}
		ADC_Started = false;
	}

	//Hardware::SetupTrigger();							//set ADC depending registers
	//nr_delay(10);
	ConfigChanged = 1;
	
	Display::CALCPRETRIGGER();

	if(Active_Menu == MENU_TRIGGEREDGE)
	{
		// recalc pretrigger
		//Display::ClearMenuItemTextAsm(4, 36320, 14);		// clear text (old value)
		//Display::DrawMenuItem(MENU_TRIGGEREDGE,4, 1, 0);	// write text (new value) in second button row
		//UpdateMenuTextPlane = true;				// trigger plane transfer
		Menu_Changed = 1;
		MenuItemPushed[4] = 1;
	}

	Hardware::SetupTrigger();
	
	//if (!SingleShot && Run && !AS_request && !RC_request && !ADC_Started)
	if ((SingleShot || Run) && !AS_request && !RC_request)			//BF add new start/stop logic -> restart ADC only if it is really needed
	{ Hardware::Start_Record(); } 						//start normal data acquistion
	else
	{ ACQ_NewData = 1;}							//trigger signal processing
	
	Display::DRAW_ALL_CURSOR();


  	//BF test for trigger problem acq_ready->np_pioedgecapture = 0;	#018

}


//######################################################################################################################################################
// make the gain available for all channels and save to flash
void UserIF::DispatchGain(void)
{
	uint32_t ch1_bak, ch2_bak, ch3_bak, ch4_bak;
	unsigned char fft_mode_bak = Signal::_FFT_Mode;
	
	//backup channel status
	ch1_bak = Channel[eCh1].active;
	ch2_bak = Channel[eCh2].active;
	ch3_bak = Channel[eCh3].active;
	ch4_bak = Channel[eCh4].active;

	Signal::_FFT_Mode = FFT_OFF;								//FFT has to be switched off to process zero level handler
	
	Channel[eCh1].active = 1;
	Channel[eCh2].active = 1;

	RotarySteps = 0;
	UserIF::ON_Zero_Channel_1();
	UserIF::ON_Zero_Channel_2();
	
	if (NumberOfChannels == 4)
	{
		Channel[eCh3].active = 1;
		Channel[eCh4].active = 1;

	      	UserIF::ON_Zero_Channel_3();
		UserIF::ON_Zero_Channel_4();
	}

	//restore channel status
	Channel[eCh1].active = ch1_bak;
	Channel[eCh2].active = ch2_bak;
	Channel[eCh3].active = ch3_bak;
	Channel[eCh4].active = ch4_bak;

	Signal::_FFT_Mode = fft_mode_bak;							// restore FFT mode
	
	
	AMDFlash::WriteCalibration();
	
	
}	



