#ifndef userif_t_h
#define userif_t_h

#define MENU_ACQUIRE 		0 
#define MENU_CHANNEL1 		1 
#define MENU_CHANNEL2 		2 
#define MENU_CHANNEL3 		3 
#define MENU_CHANNEL4 		4 
#define MENU_DISPLAY 		5 
#define MENU_UTILITY 		6 
#define MENU_SERVICE 		7 
#define MENU_SAVE 		8 
#define MENU_DISPL_SETUP 	9 
#define MENU_TIMEBASE 		10 
#define MENU_TRIGGERMODE 	12
#define MENU_TRIGGERSUB		13 
#define MENU_TRIGGEREDGE 	14 
#define MENU_PULSEWIDTH 	15 
#define MENU_CURSOR 		16 
#define MENU_QUICKPRINT 	17 
#define MENU_HARDWARE 		18 
#define MENU_QUICKMEASURE 	19 
#define MENU_QMDELAY 		20 
#define MENU_QMPHASE  		21 
#define MENU_QMTHRESHOLDS 	22 
#define MENU_AUTOSCALE 		23 
#define MENU_TRIGGERTV 		24 
#define MENU_EXTUTILS 		25 
#define MENU_MATH 		26 
#define MENU_FFT 		27 
#define MENU_DISPL_FFT 		28 
#define MENU_MATHSETTINGS 	29 
#define MENU_USTB		30 
#define MENU_QP_USB		31 


class UserIF
{
	protected:
		
		
	public:	
	static void Buttonhandler(int MenuKey);				// Button Handler
	static void F1_Btnhandler(void);				// Button Handler for function button
	static void F2_Btnhandler(void);				// Button Handler for function button
	static void F3_Btnhandler(void);				// Button Handler for function button
	static void F4_Btnhandler(void);				// Button Handler for function button
	static void F5_Btnhandler(void);				// Button Handler for function button
	static void F6_Btnhandler(void);				// Button Handler for function button

	static char MenuButtonCheck(char BtnNr);			// Check the Menu Buttons (pushed) returns 1 if found one
	static void MenuPopupStep(int MenuPopupNr, short *MenuStatusNr, short *MenuStatusNr2, short *MenuStatusNr3, int DrawMenuNr, int start, char dir); //Updates Menupopup
	static void UpdateChannel(uint8_t channel, uint32_t active);		// Update all channel depended vars


	static void Rotary_Interface(void);                             // handle the Rotary Interupt
	static void ON_MemoryPosition(void);                            // handle the Position Wheel
	static void ON_TriggerLevel(void);                              // handle Trigger Level
	static void ON_Timebase(void);                                  // handle timebase events

   	static void ON_Voltage_Channel_1(void);                         // handle voltage range events for channel 1	
	static void ON_Zero_Channel_1(void);                            // handle zero level events for channel 1
	static void ON_Voltage_Channel_2(void);                         // handle voltage range events for channel 2
	static void ON_Zero_Channel_2(void);                            // handle zero level events for channel 2
	static void ON_Voltage_Channel_3(void);                         // handle voltage range events for channel 3
	static void ON_Zero_Channel_3(void);                            // handle zero level events for channel 3
	static void ON_Voltage_Channel_4(void);                         // handle voltage range events for channel 4
	static void ON_Zero_Channel_4(void);                            // handle zero level events for channel 4
	static void ON_MainWheel(void);                                	// handle main wheel events

	static void Keyboard_Interface(void);                           // Handle the Keyboard Interupt
	
	static void ON_LogicZero(int *VirtualZero, int *ZeroLevel);
	static void ON_LogicTB(void);
	
	static void DispatchGain(void);

};

#endif

