;*************************************************************************
.include "compat.h"	; compatibility definitions
.include "protocol.h"
;-------------------------------------------------------------------------
;				Constant definitions
;-------------------------------------------------------------------------
.equ	VERSION		= 0x0107

.equ	XTAL		= 8000000	; 8MHz, not critical 
.equ	BootDelay	= XTAL / 3	; 0.33s


.ifdef BootStart
.equ	CRC		= 17
.equ	VERIFY		= 15
.endif

.ifndef CRC
.equ	CRC		= 0
.endif

.ifndef VERIFY
.equ	VERIFY		= 0
.endif

.ifndef	ONEWIRE
.equ	ONEWIRE		= 0
.endif

.ifndef	DEBUG
.equ	DEBUG		= 0
.endif

.ifndef	SPH
.equ	MinSize		= 201
.else
.equ	MinSize		= 203
.endif

.equ	BootSize	= CRC + VERIFY + ONEWIRE + DEBUG + MinSize

.if CRC
.equ	UartLoop	= 28		; UART loop time
.else
.equ	UartLoop	= 24
.endif


.ifdef BootStart
.equ	UserFlash	= (2*BootStart)
.equ	BootFuse	= 1
.else
.equ	BootStart	= ((FlashEnd - BootSize) / PageSize * PageSize)
.equ	UserFlash	= (2*BootStart - 2)
.endif

;-------------------------------------------------------------------------
;				Using register
;-------------------------------------------------------------------------
.def	zerol		= r2
.def	zeroh		= r3
.def	baudl		= r4		; baud divider
.def	baudh		= r5
.def	crcl		= r6
.def	crch		= r7
;-------------------------------------------------------------------------
.def	a0		= r16		; working registers
.def	a1		= r17
.def	appl		= r18		; rjmp to application
.def	apph		= r19
.def	polynoml	= r20		; CRC polynom 0xA001
.def	polynomh	= r21
.def	zx		= r22		; 3 byte Z pointer

.def	twl		= r24		; wait time
.def	twh		= r25
;-------------------------------------------------------------------------
;				Using SRAM
;-------------------------------------------------------------------------
.dseg
.ifndef BufferSize
.equ	BufferSize	= PageSize
.endif
	.org		SRAM_START
PROGBUFF:		.byte 2*BufferSize
PROGBUFFEND:
.cseg
;-------------------------------------------------------------------------
;				Macros
;-------------------------------------------------------------------------
.if ONEWIRE
.macro	IOPortInit
	sbi	SRX_PORT, SRX		; weak pullup on
	cbi	SRX_DDR, SRX		; as input
.endmacro
.macro	TXD_0
	sbi	SRX_DDR, SRX		; strong pullup = 0
.endmacro
.macro	TXD_1
	cbi	SRX_DDR, SRX		; weak pullup = 1
.endmacro
.macro	SKIP_RXD_0
	sbis	SRX_PIN, SRX		; low = 1
.endmacro
.macro	SKIP_RXD_1
	sbic	SRX_PIN, SRX		; high = 0
.endmacro
.else
.macro	IOPortInit
	sbi	SRX_PORT, SRX
	sbi	STX_PORT, STX
	sbi	STX_DDR, STX
.endmacro
.macro	TXD_0
	cbi	STX_PORT, STX
.endmacro
.macro	TXD_1
	sbi	STX_PORT, STX
.endmacro
.macro	SKIP_RXD_0
	sbic	SRX_PIN, SRX
.endmacro
.macro	SKIP_RXD_1
	sbis	SRX_PIN, SRX
.endmacro
.endif


.macro	XLPM
.if FLASHEND > 0x7FFF
        elpm    @0, @1
.else
        lpm     @0, @1
.endif
.endmacro
;-------------------------------------------------------------------------
;				Debugging
;-------------------------------------------------------------------------
.macro	LED01
.if DEBUG
	sbi	DDRB, 0
.endif
.endmacro
.macro	LED00
.if DEBUG
	cbi	DDRB, 0
.endif
.endmacro
.macro	LED11
.if DEBUG
	sbi	DDRB, 1
.endif
.endmacro
.macro	LED10
.if DEBUG
	cbi	DDRB, 1
.endif
.endmacro
.macro	LED21
.if DEBUG
	sbi	DDRB, 2
.endif
.endmacro
.macro	LED20
.if DEBUG
	cbi	DDRB, 2
.endif
.endmacro
.macro	LED31
.if DEBUG
	sbi	DDRB, 3
.endif
.endmacro
.macro	LED30
.if DEBUG
	cbi	DDRB, 3
.endif
.endmacro

;-------------------------------------------------------------------------
