/***********************************************************************************
Sensirion SHTxx and FOST02 Sensor Library 0v3


***********************************************************************************/
/* Copyright Notice
 	This library for the SHT temperature and humidity sensors is based on the 
	application datasheet "Sample Code humidity sensor SHTxx" from Sensirion. 
	(c) Timo Dittmar
		(For now. If I get enough feedback and a positive answer from
		Sensirion I plan to release the code under GPL)
	Use without any warranty
*/


/* History
	Date, Version, Comment 
	2006-07-14	NA		- initial conversion from Sensirion application note
						- inserted test code
	2006-07-17	NA		- adjusted timing in measurement
						- changed data transfer in calc_sht; 
	2006-07-20	0v1rc	- included heating element code 
	2006-08-05	0v1		- Some additional cleanup
						- homogenized function names;
	2006-08-13	ov2rc		- included functions for measuring with recurring interrupt
						- fewer orthographic errors :-)
						- first implementation of crc check
	2006-08-27	0v2		- second release
	2007-08-29  Steffen.H ( mc_sho@gmx.de )  included init SCK " MAKE_SHT_SCK_PIN_OUTPUT "
	2007-08-29  Steffen.H ( mc_sho@gmx.de )  addition for FOST02/FOST02A
	          - #define FOST02 for 8bit humidity sensors measured values.
	          - #define FOST02_MAIN for Test run.
*/

#ifndef _SHT_LIB_
#define _SHT_LIB_

/* Defining the CPU frequency for the additional delay loops */
#ifndef F_CPU
	#define F_CPU 4000000
#endif 

#define CYCLES_PER_US ((F_CPU+500000)/1000000) 	// cpu cycles per microsecond
//- for FOST02 Sensor
#define FOST02
//----------------------------------------------------------------------------------
// modul-var
//----------------------------------------------------------------------------------


/* SHT SCK and DATA Port and Pin definitions */
#define SHT_DATA_PORT      PORTD 
#define SHT_SCK_PORT       PORTD
#define SHT_DATA_DDR       DDRD
#define SHT_SCK_DDR        DDRD
#define SHT_DATA_PORT_PIN  PIND //  ! the PINx register of the DATA Port ! 
#define SHT_DATA_PIN       PD6
#define SHT_SCK_PIN        PD7

/* Setting the offset of the bandgap temperature sensor according to the datasheet */
   #define SHT_TEMP_OFFSET -40  	//@ 5V
// #define SHT_TEMP_OFFSET -39.75  //@ 4V
// #define SHT_TEMP_OFFSET -39.66  //@ 3.5V
// #define SHT_TEMP_OFFSET -39.60  //@ 3V
// #define SHT_TEMP_OFFSET -39.55  //@ 2.5V

/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
/* You should not have to change anything below */
/*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

typedef union
{ unsigned int i;
float f;
} sht_value;

/* emum for switching measurement mode */
enum {TEMP,HUMI}; //

/* SHT bit and values definitions */

#define noACK 0
#define ACK 1
//adr command r/w
#define STATUS_REG_W 0x06 //000 0011 0
#define STATUS_REG_R 0x07 //000 0011 1
#define MEASURE_TEMP 0x03 //000 0001 1
#define MEASURE_HUMI 0x05 //000 0010 1
#define RESET 0x1e //000 1111 0
#define HEATER_BIT 0x04 // 00000100

/* IO Macros */

#define SET_SHT_DATA SHT_DATA_PORT |= ( 1 << SHT_DATA_PIN) 
#define CLEAR_SHT_DATA SHT_DATA_PORT &= ~( 1 << SHT_DATA_PIN)
#define SET_SHT_SCK SHT_SCK_PORT |= ( 1 << SHT_SCK_PIN)
#define CLEAR_SHT_SCK SHT_SCK_PORT &= ~( 1 << SHT_SCK_PIN)
#define MAKE_SHT_DATA_PIN_OUTPUT SHT_DATA_DDR |= ( 1 << SHT_DATA_PIN) 
#define MAKE_SHT_DATA_PIN_INPUT SHT_DATA_DDR &= ~( 1 << SHT_DATA_PIN)
#define SHT_DATA (SHT_DATA_PORT_PIN & ( 1<< SHT_DATA_PIN))
#define MAKE_SHT_SCK_PIN_OUTPUT SHT_SCK_DDR |= ( 1 << SHT_SCK_PIN)


//Function definitions
unsigned char sht_write_byte (unsigned char sht_value);
unsigned char sht_read_byte (unsigned char ack);
void sht_transstart (void);
void sht_connectionreset (void);
unsigned char sht_softreset (void);
unsigned char sht_read_statusreg(unsigned char *p_value, unsigned char *p_checksum);
unsigned char sht_write_statusreg(unsigned char *p_value);
unsigned char sht_measure(sht_value *p_sht_value, unsigned char *p_checksum, unsigned char mode);
void sht_raw_to_physical(sht_value *p_humidity ,sht_value *p_temperature);
float calc_dewpoint(float h, float t);
void sht_switch_heating_element(unsigned char onoff);

unsigned char sht_check_crc(sht_value *p_sht_value, unsigned char *p_checksum, unsigned char mode, unsigned char statusreg);

/* 	The following functions can be used if you have implemented a recurring interrupt (e.g. Timer).
	Basically they split the measurement into three chunks in order to avoid 
	the CPU burning time during the 200ms the sensor needs for the conversion.
	
*/
unsigned char _sht_begin_measurement(unsigned char mode);
unsigned char _sht_is_measurement_finished(void);
void _sht_get_measurement_data(sht_value *p_sht_value, unsigned char *p_checksum);
/*
Some Ideas for using them:
	
	void recurring_interrupt_service_routine()
	{
	...
	if (flag== MEASURING) && (sht_is_measurement_finished() == 1) flag == FINISHED; 
	...
	}
	
	void main()
	{
	unsigned char error =0;
	unsigned char checksum;
	sht_value humidity;
	...
	error += _sht_begin_measurement(SHT_HUMI);
	flag = MEASURING;
	for{;;}
		{
		if (flag == FINISHED) {
			_sht_get_measurement_data(&humidity, (unsigned char*)&checksum);
			flag = DONE;
			}
		}
	}
*/

#endif // _SHT_LIB_