#define OCR1A_P 0x2A  // port of OCR1A
#define OCR1B_P 0x28  // port of OCR1B

// state definition for servo state-machine:
#define ST_DOWN  0    // servos in start position
#define ST_GO_S1 1    // servo 1 is traveling
#define ST_WAIT  2    // Pause between Servo 1 and Servo 2
#define ST_GO_S2 3    // servo 2 is traveling
#define ST_UP    4    // servos in final position

// command definitions:
#define DIR_UP   +1   // direction "UP"
#define DIR_DOWN -1   // direction "DOWN"

// adjust commands:
#define A_NOTHING 0
#define A_SERVO1  1
#define A_SERVO2  2
#define A_TIME1   3
#define A_TIME2   4
#define A_PAUSE   5
#define A_RXUP    6
#define A_RXDOWN  7

#define EN_S1S2 ((1<<COM1A1) | (1<<COM1B1) | (1<<WGM11))  // OC1A/B clr on match, set on TOP
#define DIS_S1  (              (1<<COM1B1) | (1<<WGM11))  // OC1B clr on match, set on TOP

#define RISE_EDGE ((1<<ISC01) | (1<<ISC00))   // Rising edge of INT0 generates an interrupt request
#define FALL_EDGE ((1<<ISC01)             )   // Falling edge of INT0 generates an interrupt request

// Servo Frame-Time:
#define FRAME_TIME      20                // msec
#define FRAMES_PER_SEC (1000/FRAME_TIME)  // frames per second

// define poweroff-timeout:
#define PWOFF_TOUT      2      // seconds

// default values in case of empty EEPROM:
#define STARTDEFAULT 1000      // usec
#define ENDDEFAULT   2000      // usec
#define TIMEDEFAULT     1      // seconds
#define PAUSEDEFAULT    0      // seconds

#define SERVOMIN      750      // usec
#define SERVOMAX     2250      // usec
#define TIMEMIN         1      // frames
#define TIMEMAX       999      // frames

// adjust-increments per step:
#define ADJ_STEP        5

// tolerance for rx-switchpoints:
#define RX_TOL          3      

// minimum of valid rx-frames to switchover:
#define RX_VALID       10      // rx-frames
