/*****************************************************************************
 *                                                                           *
 *        **********                                                         *
 *       ************                                                        *
 *      ***        ***                                                       *
 *      ***   +++   ***                                                      *
 *      ***   + +   ***                                                      *
 *      ***   +                            CHIPCON CC2400                    *
 *      ***   + +   ***                  MASTER INCLUDE FILE                 *
 *      ***   +++   ***                                                      *
 *      ***       ***                                                        *
 *       ***********                                                         *
 *        *********                                                          *
 *                                                                           *
 *****************************************************************************
 * A number of helpful constants and macros are also included which can      *
 * be used to increase the legibility of your code.  						 *
 * Master Include file for CC2400DB                        					 *                                                                           *
 *****************************************************************************
 * Device:      CC2400                                                       *
 * File:		include.h					                                 *
 * Author:		MBR						                                     *
 * Target:		ATmega8						                                 *
 * Created:		2004-01-05					                                 *
 *				    			                                             *
 *****************************************************************************
 * Revision history:                                                         *
 *                                                                           *
 * $Log: include.h,v $
 * Revision 1.2  2004/01/20 15:02:21  mbr
 * Removed - stdio.h
 *
 * Revision 1.1  2004/01/07 13:06:01  tos
 * Initial version in CVS.
 *                                                       *
 *                                                                           *  
 *									                                         *	
 *                                                                           *
 ****************************************************************************/
#ifndef INCLUDE_H
#define INCLUDE_H

//-------------------------------------------------------------------------------------------------------
// Useful stuff
#define BM(n) (1 << (n))
//-------------------------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------------------------
// Standard include files (GCC)
//-------------------------------------------------------------------------------------------------------
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/iom8.h>
#include <avr/signal.h>
#include <avr/ina90.h>

//-------------------------------------------------------------------------------------------------------
// Include files for CC2400DB
//-------------------------------------------------------------------------------------------------------
#include "atmega.h"
#include "support/devboard.h"
#include "cc2400.h"
#include "support/Utility.h"

#endif
