/*
 * Decompiled with CFR 0.152.
 */
package gmann.interfaces.esplink;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Date;
import org.productivity.java.syslog4j.Syslog;
import org.productivity.java.syslog4j.SyslogConfigIF;
import org.productivity.java.syslog4j.SyslogIF;

public class EmsBus {
    private String emsServer = "192.168.254.115";
    private int emsPort = 23;
    private static String syslogServer = "192.168.254.20";
    private static int syslogPort = 514;
    private static int useSyslog = 1;
    static SyslogIF syslog;
    private Socket skt;
    private BufferedInputStream in;
    private static int socketConnectTimeout;
    private static int socketDataTimeout;
    private int debugLevel = 1;
    private static int byteCount;
    private int[] data = new int[512];
    protected static final char[] hexArray;
    private static final boolean buderusEmsCrcTable = false;
    private static final int buderusEmsPoly = 12;
    private static final int[] buderusCrcTable;

    static {
        socketConnectTimeout = 5000;
        socketDataTimeout = 30000;
        byteCount = 0;
        hexArray = "0123456789ABCDEF".toCharArray();
        int[] nArray = new int[256];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 6;
        nArray[4] = 8;
        nArray[5] = 10;
        nArray[6] = 12;
        nArray[7] = 14;
        nArray[8] = 16;
        nArray[9] = 18;
        nArray[10] = 20;
        nArray[11] = 22;
        nArray[12] = 24;
        nArray[13] = 26;
        nArray[14] = 28;
        nArray[15] = 30;
        nArray[16] = 32;
        nArray[17] = 34;
        nArray[18] = 36;
        nArray[19] = 38;
        nArray[20] = 40;
        nArray[21] = 42;
        nArray[22] = 44;
        nArray[23] = 46;
        nArray[24] = 48;
        nArray[25] = 50;
        nArray[26] = 52;
        nArray[27] = 54;
        nArray[28] = 56;
        nArray[29] = 58;
        nArray[30] = 60;
        nArray[31] = 62;
        nArray[32] = 64;
        nArray[33] = 66;
        nArray[34] = 68;
        nArray[35] = 70;
        nArray[36] = 72;
        nArray[37] = 74;
        nArray[38] = 76;
        nArray[39] = 78;
        nArray[40] = 80;
        nArray[41] = 82;
        nArray[42] = 84;
        nArray[43] = 86;
        nArray[44] = 88;
        nArray[45] = 90;
        nArray[46] = 92;
        nArray[47] = 94;
        nArray[48] = 96;
        nArray[49] = 98;
        nArray[50] = 100;
        nArray[51] = 102;
        nArray[52] = 104;
        nArray[53] = 106;
        nArray[54] = 108;
        nArray[55] = 110;
        nArray[56] = 112;
        nArray[57] = 114;
        nArray[58] = 116;
        nArray[59] = 118;
        nArray[60] = 120;
        nArray[61] = 122;
        nArray[62] = 124;
        nArray[63] = 126;
        nArray[64] = 128;
        nArray[65] = 130;
        nArray[66] = 132;
        nArray[67] = 134;
        nArray[68] = 136;
        nArray[69] = 138;
        nArray[70] = 140;
        nArray[71] = 142;
        nArray[72] = 144;
        nArray[73] = 146;
        nArray[74] = 148;
        nArray[75] = 150;
        nArray[76] = 152;
        nArray[77] = 154;
        nArray[78] = 156;
        nArray[79] = 158;
        nArray[80] = 160;
        nArray[81] = 162;
        nArray[82] = 164;
        nArray[83] = 166;
        nArray[84] = 168;
        nArray[85] = 170;
        nArray[86] = 172;
        nArray[87] = 174;
        nArray[88] = 176;
        nArray[89] = 178;
        nArray[90] = 180;
        nArray[91] = 182;
        nArray[92] = 184;
        nArray[93] = 186;
        nArray[94] = 188;
        nArray[95] = 190;
        nArray[96] = 192;
        nArray[97] = 194;
        nArray[98] = 196;
        nArray[99] = 198;
        nArray[100] = 200;
        nArray[101] = 202;
        nArray[102] = 204;
        nArray[103] = 206;
        nArray[104] = 208;
        nArray[105] = 210;
        nArray[106] = 212;
        nArray[107] = 214;
        nArray[108] = 216;
        nArray[109] = 218;
        nArray[110] = 220;
        nArray[111] = 222;
        nArray[112] = 224;
        nArray[113] = 226;
        nArray[114] = 228;
        nArray[115] = 230;
        nArray[116] = 232;
        nArray[117] = 234;
        nArray[118] = 236;
        nArray[119] = 238;
        nArray[120] = 240;
        nArray[121] = 242;
        nArray[122] = 244;
        nArray[123] = 246;
        nArray[124] = 248;
        nArray[125] = 250;
        nArray[126] = 252;
        nArray[127] = 254;
        nArray[128] = 25;
        nArray[129] = 27;
        nArray[130] = 29;
        nArray[131] = 31;
        nArray[132] = 17;
        nArray[133] = 19;
        nArray[134] = 21;
        nArray[135] = 23;
        nArray[136] = 9;
        nArray[137] = 11;
        nArray[138] = 13;
        nArray[139] = 15;
        nArray[140] = 1;
        nArray[141] = 3;
        nArray[142] = 5;
        nArray[143] = 7;
        nArray[144] = 57;
        nArray[145] = 59;
        nArray[146] = 61;
        nArray[147] = 63;
        nArray[148] = 49;
        nArray[149] = 51;
        nArray[150] = 53;
        nArray[151] = 55;
        nArray[152] = 41;
        nArray[153] = 43;
        nArray[154] = 45;
        nArray[155] = 47;
        nArray[156] = 33;
        nArray[157] = 35;
        nArray[158] = 37;
        nArray[159] = 39;
        nArray[160] = 89;
        nArray[161] = 91;
        nArray[162] = 93;
        nArray[163] = 95;
        nArray[164] = 81;
        nArray[165] = 83;
        nArray[166] = 85;
        nArray[167] = 87;
        nArray[168] = 73;
        nArray[169] = 75;
        nArray[170] = 77;
        nArray[171] = 79;
        nArray[172] = 65;
        nArray[173] = 67;
        nArray[174] = 69;
        nArray[175] = 71;
        nArray[176] = 121;
        nArray[177] = 123;
        nArray[178] = 125;
        nArray[179] = 127;
        nArray[180] = 113;
        nArray[181] = 115;
        nArray[182] = 117;
        nArray[183] = 119;
        nArray[184] = 105;
        nArray[185] = 107;
        nArray[186] = 109;
        nArray[187] = 111;
        nArray[188] = 97;
        nArray[189] = 99;
        nArray[190] = 101;
        nArray[191] = 103;
        nArray[192] = 153;
        nArray[193] = 155;
        nArray[194] = 157;
        nArray[195] = 159;
        nArray[196] = 145;
        nArray[197] = 147;
        nArray[198] = 149;
        nArray[199] = 151;
        nArray[200] = 137;
        nArray[201] = 139;
        nArray[202] = 141;
        nArray[203] = 143;
        nArray[204] = 129;
        nArray[205] = 131;
        nArray[206] = 133;
        nArray[207] = 135;
        nArray[208] = 185;
        nArray[209] = 187;
        nArray[210] = 189;
        nArray[211] = 191;
        nArray[212] = 177;
        nArray[213] = 179;
        nArray[214] = 181;
        nArray[215] = 183;
        nArray[216] = 169;
        nArray[217] = 171;
        nArray[218] = 173;
        nArray[219] = 175;
        nArray[220] = 161;
        nArray[221] = 163;
        nArray[222] = 165;
        nArray[223] = 167;
        nArray[224] = 217;
        nArray[225] = 219;
        nArray[226] = 221;
        nArray[227] = 223;
        nArray[228] = 209;
        nArray[229] = 211;
        nArray[230] = 213;
        nArray[231] = 215;
        nArray[232] = 201;
        nArray[233] = 203;
        nArray[234] = 205;
        nArray[235] = 207;
        nArray[236] = 193;
        nArray[237] = 195;
        nArray[238] = 197;
        nArray[239] = 199;
        nArray[240] = 249;
        nArray[241] = 251;
        nArray[242] = 253;
        nArray[243] = 255;
        nArray[244] = 241;
        nArray[245] = 243;
        nArray[246] = 245;
        nArray[247] = 247;
        nArray[248] = 233;
        nArray[249] = 235;
        nArray[250] = 237;
        nArray[251] = 239;
        nArray[252] = 225;
        nArray[253] = 227;
        nArray[254] = 229;
        nArray[255] = 231;
        buderusCrcTable = nArray;
    }

    public static String bytesToHex(int[] data, int offset, int count, boolean separator) {
        char[] hexChars = new char[count * 3];
        int j = 0;
        while (j < count) {
            int v = data[j + offset] & 0xFF;
            hexChars[j * 3] = hexArray[v >>> 4];
            hexChars[j * 3 + 1] = hexArray[v & 0xF];
            hexChars[j * 3 + 2] = 32;
            ++j;
        }
        return new String(hexChars);
    }

    public static String bytesToHex(int[] bytes, boolean separator) {
        return EmsBus.bytesToHex(bytes, 0, bytes.length, true);
    }

    public static String bytesToHex(int[] bytes, int offset, boolean separator) {
        return EmsBus.bytesToHex(bytes, offset, bytes.length - offset, true);
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debug) {
        this.debugLevel = debug;
    }

    public EmsBus(String emsServer, int emsPort) {
        this.emsServer = emsServer;
        this.emsPort = emsPort;
        this.skt = null;
    }

    public void open() throws IOException {
        this.skt = new Socket();
        this.skt.connect(new InetSocketAddress(this.emsServer, this.emsPort), socketConnectTimeout);
        this.skt.setSoTimeout(socketDataTimeout);
        this.in = new BufferedInputStream(this.skt.getInputStream());
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
        if (this.skt != null) {
            this.skt.close();
            this.skt = null;
        }
    }

    public boolean isConnected() {
        return this.skt != null;
    }

    private void waitForEndOfFrame() throws IOException {
        int lastC = 0;
        int c = 0;
        do {
            lastC = c;
            c = this.in.read();
            ++byteCount;
            if (c >= 0) continue;
            throw new IOException("End of input stream");
        } while (lastC != 229 && c != 26);
    }

    public int fetchByte() throws IOException {
        int _data = this.in.read();
        if (_data < 0) {
            throw new IOException("End of input stream");
        }
        ++byteCount;
        return _data & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] getTelegramm() throws IOException {
        int length;
        long sysTimestamp;
        long sntpTimestamp;
        int pkgLen;
        int payloadLength;
        try {
            if (!this.isConnected()) {
                syslog.notice("connecting to " + this.emsServer + ":" + this.emsPort);
                this.open();
            }
            try {}
            catch (SocketTimeoutException e) {
                throw new IOException("Data Timeout after " + byteCount + " bytes");
            }
        }
        catch (IOException e) {
            this.close();
            syslog.warn(String.format("connection closed: %s", e.toString()));
            byteCount = 0;
            throw e;
        }
        do {
            pkgLen = 0;
            while (pkgLen < 10) {
                this.data[pkgLen] = this.fetchByte();
                ++pkgLen;
            }
            sntpTimestamp = this.data[3] << 24 | this.data[2] << 16 | this.data[1] << 8 | this.data[0] << 0;
            sysTimestamp = this.data[7] << 24 | this.data[6] << 16 | this.data[5] << 8 | this.data[4] << 0;
            length = this.data[9] << 8 | this.data[8] << 0;
            while (pkgLen < 10 + length) {
                this.data[pkgLen] = this.fetchByte();
                ++pkgLen;
            }
            if (this.data[pkgLen - 2] != 229 && this.data[pkgLen - 1] != 26) {
                if (this.debugLevel >= 1) {
                    syslog.warn("missing end of frame signature");
                }
                this.waitForEndOfFrame();
                return null;
            }
            if (length == pkgLen - 10) continue;
            if (this.debugLevel >= 1) {
                syslog.warn(String.format("length mismatch: %d vs %d", length, pkgLen));
            }
            this.waitForEndOfFrame();
            return null;
        } while ((payloadLength = pkgLen - 14) < 3);
        int crc = EmsBus.buderusEmsCrc(this.data, 10, 10 + payloadLength);
        if (this.debugLevel >= 2 || crc != this.data[10 + payloadLength]) {
            syslog.warn(String.format("0x%08x 0x%08x %3d ", sntpTimestamp, sysTimestamp, length));
            syslog.warn(EmsBus.bytesToHex(this.data, 0, length + 10, true));
            if (crc != this.data[10 + payloadLength]) {
                syslog.warn(String.format("CRC mismatch: %02x vs %02x length %d\n", crc, this.data[10 + payloadLength], payloadLength));
            } else {
                syslog.debug(String.format("computed CRC: %02x", crc));
            }
        }
        if (crc != this.data[10 + payloadLength]) {
            this.waitForEndOfFrame();
            return null;
        }
        int[] telegram = new int[payloadLength];
        int j = 0;
        while (j < payloadLength) {
            telegram[j] = (byte)this.data[j + 10];
            ++j;
        }
        return telegram;
    }

    private static int buderusEmsCrc(int[] data2, int from, int to) {
        int crc = 0;
        int i = from;
        while (i < to) {
            int d = 0;
            if ((crc & 0x80) != 0) {
                crc ^= 0xC;
                d = 1;
            }
            crc = crc << 1 & 0xFE;
            crc |= d;
            crc = (crc ^ data2[i]) & 0xFF;
            ++i;
        }
        return crc;
    }

    public static void main(String[] args) {
        EmsBus emsBus = new EmsBus(args.length > 0 ? args[0] : "192.168.254.115", 23);
        SyslogConfigIF config = Syslog.getInstance("udp").getConfig();
        config.setHost(args.length > 1 ? args[1] : syslogServer);
        config.setPort(syslogPort);
        config.setIdent("EMSLink");
        config.setLocalName("ems-link");
        config.setSendLocalName(true);
        Syslog.createInstance("EMSBus", config);
        syslog = Syslog.getInstance("EMSBus");
        syslog.notice("starting EMSLink monitor");
        while (true) {
            try {
                while (true) {
                    int[] b;
                    if ((b = emsBus.getTelegramm()) == null) {
                        if (useSyslog == 1) continue;
                        System.out.print(new Date() + "    ");
                        System.out.print("Receive Error");
                        System.out.print('\n');
                        System.out.flush();
                        continue;
                    }
                    if (b.length <= 3) continue;
                    if (useSyslog == 1) {
                        syslog.info(EmsBus.bytesToHex(b, true));
                        continue;
                    }
                    System.out.print(new Date() + "    " + EmsBus.bytesToHex(b, true));
                    System.out.print('\n');
                    System.out.flush();
                }
            }
            catch (IOException e) {
                System.out.println(e.toString());
                syslog.warn(e.toString());
                continue;
            }
            break;
        }
    }
}

