/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server;

import org.productivity.java.syslog4j.server.SyslogServer;
import org.productivity.java.syslog4j.server.SyslogServerConfigIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.SyslogServerSessionEventHandlerIF;
import org.productivity.java.syslog4j.server.impl.event.printstream.FileSyslogServerEventHandler;
import org.productivity.java.syslog4j.server.impl.event.printstream.SystemOutSyslogServerEventHandler;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfigIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class SyslogServerMain {
    public static boolean CALL_SYSTEM_EXIT_ON_FAILURE = true;

    public static void usage(String string) {
        if (string != null) {
            System.out.println("Error: " + string);
            System.out.println();
        }
        System.out.println("Usage:");
        System.out.println();
        System.out.println("SyslogServer [-h <host>] [-p <port>] [-o <file>] [-a] [-q] <protocol>");
        System.out.println();
        System.out.println("-h <host>    host or IP to bind");
        System.out.println("-p <port>    port to bind");
        System.out.println("-t <timeout> socket timeout (in milliseconds)");
        System.out.println("-o <file>    file to write entries (overwrites by default)");
        System.out.println();
        System.out.println("-a           append to file (instead of overwrite)");
        System.out.println("-q           do not write anything to standard out");
        System.out.println();
        System.out.println("protocol     Syslog4j protocol implementation (tcp, udp, ...)");
    }

    public static Options parseOptions(String[] stringArray) {
        Options options = new Options();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n++];
            boolean bl = false;
            if ("-h".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify host with -h";
                    return options;
                }
                bl = true;
                options.host = stringArray[n++];
            }
            if ("-p".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify port with -p";
                    return options;
                }
                bl = true;
                options.port = stringArray[n++];
            }
            if ("-t".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify value (in milliseconds)";
                    return options;
                }
                bl = true;
                options.timeout = stringArray[n++];
            }
            if ("-o".equals(string)) {
                if (n == stringArray.length) {
                    options.usage = "Must specify file with -o";
                    return options;
                }
                bl = true;
                options.fileName = stringArray[n++];
            }
            if ("-a".equals(string)) {
                bl = true;
                options.append = true;
            }
            if ("-q".equals(string)) {
                bl = true;
                options.quiet = true;
            }
            if (bl) continue;
            if (options.protocol != null) {
                options.usage = "Only one protocol definition allowed";
                return options;
            }
            options.protocol = string;
        }
        if (options.protocol == null) {
            options.usage = "Must specify protocol";
            return options;
        }
        if (options.fileName == null && options.append) {
            options.usage = "Cannot specify -a without specifying -f <file>";
            return options;
        }
        return options;
    }

    public static void main(String[] stringArray) throws Exception {
        SyslogServerSessionEventHandlerIF syslogServerSessionEventHandlerIF;
        Options options = SyslogServerMain.parseOptions(stringArray);
        if (options.usage != null) {
            SyslogServerMain.usage(options.usage);
            if (CALL_SYSTEM_EXIT_ON_FAILURE) {
                System.exit(1);
            } else {
                return;
            }
        }
        if (!options.quiet) {
            System.out.println("SyslogServer " + SyslogServer.getVersion());
        }
        if (!SyslogServer.exists(options.protocol)) {
            SyslogServerMain.usage("Protocol \"" + options.protocol + "\" not supported");
            if (CALL_SYSTEM_EXIT_ON_FAILURE) {
                System.exit(1);
            } else {
                return;
            }
        }
        SyslogServerIF syslogServerIF = SyslogServer.getInstance(options.protocol);
        SyslogServerConfigIF syslogServerConfigIF = syslogServerIF.getConfig();
        if (options.host != null) {
            syslogServerConfigIF.setHost(options.host);
            if (!options.quiet) {
                System.out.println("Listening on host: " + options.host);
            }
        }
        if (options.port != null) {
            syslogServerConfigIF.setPort(Integer.parseInt(options.port));
            if (!options.quiet) {
                System.out.println("Listening on port: " + options.port);
            }
        }
        if (options.timeout != null) {
            if (syslogServerConfigIF instanceof TCPNetSyslogServerConfigIF) {
                ((TCPNetSyslogServerConfigIF)syslogServerConfigIF).setTimeout(Integer.parseInt(options.timeout));
                if (!options.quiet) {
                    System.out.println("Timeout: " + options.timeout);
                }
            } else {
                System.err.println("Timeout not supported for protocol \"" + options.protocol + "\" (ignored)");
            }
        }
        if (options.fileName != null) {
            syslogServerSessionEventHandlerIF = new FileSyslogServerEventHandler(options.fileName, options.append);
            syslogServerConfigIF.addEventHandler(syslogServerSessionEventHandlerIF);
            if (!options.quiet) {
                System.out.println((options.append ? "Appending" : "Writing") + " to file: " + options.fileName);
            }
        }
        if (!options.quiet) {
            syslogServerSessionEventHandlerIF = SystemOutSyslogServerEventHandler.create();
            syslogServerConfigIF.addEventHandler(syslogServerSessionEventHandlerIF);
        }
        if (!options.quiet) {
            System.out.println();
        }
        SyslogServer.getThreadedInstance(options.protocol);
        while (true) {
            SyslogUtility.sleep(1000L);
        }
    }

    public static class Options {
        public String protocol = null;
        public String fileName = null;
        public boolean append = false;
        public boolean quiet = false;
        public String host = null;
        public String port = null;
        public String timeout = null;
        public String usage = null;
    }
}

