/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.server.impl.net.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Iterator;
import javax.net.ServerSocketFactory;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.server.SyslogServerEventIF;
import org.productivity.java.syslog4j.server.SyslogServerIF;
import org.productivity.java.syslog4j.server.impl.AbstractSyslogServer;
import org.productivity.java.syslog4j.server.impl.net.tcp.TCPNetSyslogServerConfigIF;
import org.productivity.java.syslog4j.util.SyslogUtility;

public class TCPNetSyslogServer
extends AbstractSyslogServer {
    protected ServerSocket serverSocket = null;
    protected final AbstractSyslogServer.Sessions sessions = new AbstractSyslogServer.Sessions();
    protected TCPNetSyslogServerConfigIF tcpNetSyslogServerConfig = null;

    public void initialize() throws SyslogRuntimeException {
        this.tcpNetSyslogServerConfig = null;
        try {
            this.tcpNetSyslogServerConfig = (TCPNetSyslogServerConfigIF)((Object)this.syslogServerConfig);
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must be of type TCPNetSyslogServerConfig");
        }
        if (this.syslogServerConfig == null) {
            throw new SyslogRuntimeException("config cannot be null");
        }
        if (this.tcpNetSyslogServerConfig.getBacklog() < 1) {
            this.tcpNetSyslogServerConfig.setBacklog(50);
        }
    }

    public AbstractSyslogServer.Sessions getSessions() {
        return this.sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        super.shutdown();
        try {
            if (this.serverSocket != null) {
                if (this.syslogServerConfig.getShutdownWait() > 0L) {
                    SyslogUtility.sleep(this.syslogServerConfig.getShutdownWait());
                }
                this.serverSocket.close();
            }
            AbstractSyslogServer.Sessions sessions = this.sessions;
            synchronized (sessions) {
                Iterator iterator = this.sessions.getSockets();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Socket socket = (Socket)iterator.next();
                        socket.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    protected ServerSocketFactory getServerSocketFactory() throws IOException {
        ServerSocketFactory serverSocketFactory = ServerSocketFactory.getDefault();
        return serverSocketFactory;
    }

    protected ServerSocket createServerSocket() throws IOException {
        ServerSocket serverSocket = null;
        ServerSocketFactory serverSocketFactory = this.getServerSocketFactory();
        if (this.syslogServerConfig.getHost() != null) {
            InetAddress inetAddress = InetAddress.getByName(this.syslogServerConfig.getHost());
            serverSocket = serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog(), inetAddress);
        } else {
            serverSocket = this.tcpNetSyslogServerConfig.getBacklog() < 1 ? serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort()) : serverSocketFactory.createServerSocket(this.syslogServerConfig.getPort(), this.tcpNetSyslogServerConfig.getBacklog());
        }
        return serverSocket;
    }

    public void run() {
        try {
            this.serverSocket = this.createServerSocket();
            this.shutdown = false;
        }
        catch (SocketException socketException) {
            throw new SyslogRuntimeException(socketException);
        }
        catch (IOException iOException) {
            throw new SyslogRuntimeException(iOException);
        }
        TCPNetSyslogServer.handleInitialize(this);
        while (!this.shutdown) {
            try {
                Socket socket = this.serverSocket.accept();
                if (this.tcpNetSyslogServerConfig.getTimeout() > 0) {
                    socket.setSoTimeout(this.tcpNetSyslogServerConfig.getTimeout());
                }
                if (this.tcpNetSyslogServerConfig.getMaxActiveSockets() > 0 && this.sessions.size() >= this.tcpNetSyslogServerConfig.getMaxActiveSockets()) {
                    if (this.tcpNetSyslogServerConfig.getMaxActiveSocketsBehavior() == 1) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        socket = null;
                    } else if (this.tcpNetSyslogServerConfig.getMaxActiveSocketsBehavior() == 0) {
                        while (!this.shutdown && this.sessions.size() >= this.tcpNetSyslogServerConfig.getMaxActiveSockets() && socket.isConnected() && !socket.isClosed()) {
                            SyslogUtility.sleep(500L);
                        }
                    }
                }
                if (socket == null) continue;
                TCPNetSyslogSocketHandler tCPNetSyslogSocketHandler = new TCPNetSyslogSocketHandler(this.sessions, this, socket);
                Thread thread = new Thread(tCPNetSyslogSocketHandler);
                thread.start();
            }
            catch (SocketException socketException) {
                if (!"Socket closed".equals(socketException.getMessage())) continue;
                this.shutdown = true;
            }
            catch (IOException iOException) {}
        }
        TCPNetSyslogServer.handleDestroy(this);
    }

    public static class TCPNetSyslogSocketHandler
    implements Runnable {
        protected SyslogServerIF server = null;
        protected Socket socket = null;
        protected AbstractSyslogServer.Sessions sessions = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TCPNetSyslogSocketHandler(AbstractSyslogServer.Sessions sessions, SyslogServerIF syslogServerIF, Socket socket) {
            this.sessions = sessions;
            this.server = syslogServerIF;
            this.socket = socket;
            AbstractSyslogServer.Sessions sessions2 = this.sessions;
            synchronized (sessions2) {
                this.sessions.addSocket(socket);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            boolean bl = false;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String string = bufferedReader.readLine();
                if (string != null) {
                    AbstractSyslogServer.handleSessionOpen(this.sessions, this.server, this.socket);
                }
                while (string != null && string.length() != 0) {
                    SyslogServerEventIF syslogServerEventIF = TCPNetSyslogServer.createEvent(this.server.getConfig(), string, this.socket.getInetAddress());
                    AbstractSyslogServer.handleEvent(this.sessions, this.server, this.socket, syslogServerEventIF);
                    string = bufferedReader.readLine();
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                bl = true;
            }
            catch (SocketException socketException) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), socketException);
                if (!"Socket closed".equals(socketException.getMessage())) {
                    // empty if block
                }
            }
            catch (IOException iOException) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), iOException);
            }
            try {
                AbstractSyslogServer.handleSessionClosed(this.sessions, this.server, this.socket, bl);
                this.sessions.removeSocket(this.socket);
                this.socket.close();
                return;
            }
            catch (IOException iOException) {
                AbstractSyslogServer.handleException(this.sessions, this.server, this.socket.getRemoteSocketAddress(), iOException);
            }
        }
    }
}

