//*----------------------------------------------------------------------------
//*         ATMEL Microcontroller Software Support  -  ROUSSET  -
//*----------------------------------------------------------------------------
//* The software is delivered "AS IS" without warranty or condition of any
//* kind, either express, implied or statutory. This includes without
//* limitation any warranty or condition with respect to merchantability or
//* fitness for any particular purpose, or against the infringements of
//* intellectual property rights of others.
//*----------------------------------------------------------------------------
//* File Name           : main.c
//* Object              : main application written in C
//* 1.0 05/Jul/04 JPP   : Creation
//* 1.1 19/May/05 JPP   : Change for new LIB
//* 1.1 29/Aug/05 JPP   : Update AIC definion
//*----------------------------------------------------------------------------

// Include Standard LIB  files
#include "Board.h"
#include <stdio.h>


#define RTTC_INTERRUPT_LEVEL		0
#define PIV_200_MS 		600000		//* 200 ms for 48 MHz

// Global Variable
char message[80];
unsigned int value;

//*----------------------------------------------------------------------------
//* Function Name       : Periodic_Interval_Timer_handler
//* Object              : C handler interrupt function called by the interrupts
//*                       assembling routine
//*----------------------------------------------------------------------------
void Periodic_Interval_Timer_handler(void)
{
    unsigned int status;
    //* Interrupt Acknowledge
    status = AT91C_BASE_PITC->PITC_PIVR;
	status =status;
   AT91C_BASE_DBGU->DBGU_THR = '*';
	//* Read the output state
	if ((AT91F_PIO_GetInput(AT91C_BASE_PIOA) & LED1 ) == LED1 )   AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED1 );
    else  AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED1 );

}
//*----------------------------------------------------------------------------
//* \fn    AT91F_US_Get
//* \brief Get a Char to USART
//*----------------------------------------------------------------------------
 int AT91F_US_Get( char *val)
{
    if ((AT91F_US_RxReady((AT91PS_USART)AT91C_BASE_DBGU)) == 0) return (false);
    else
    {
	*val= AT91F_US_GetChar((AT91PS_USART)AT91C_BASE_DBGU);
        return (true);
    }
}
//*----------------------------------------------------------------------------
//* \fn    AT91F_DBGU_Printk
//* \brief This function is used to send a string through the DBGU channel (Very low level debugging)
//*----------------------------------------------------------------------------
void AT91F_DBGU_Printk(	char *buffer)
{
    while(*buffer != '\0') {
	while (!AT91F_US_TxReady((AT91PS_USART)AT91C_BASE_DBGU));
	AT91F_US_PutChar((AT91PS_USART)AT91C_BASE_DBGU, *buffer++);
    }
}

//*----------------------------------------------------------------------------
//* Function Name       : FIQ_handler
//* Object              : Irq Handler called by the FIQ interrupt with AT91
//*                       compatibility
///*----------------------------------------------------------------------------
void FIQ_handler(void)
{
    value = AT91C_BASE_PITC->PITC_PIIR;
    sprintf(message,"CPIV %d PICNT %d\n\r",(value &AT91C_PITC_CPIV),(value &AT91C_PITC_PICNT)>>20);
    AT91F_DBGU_Printk(message);
    //* Read the output state
    if ( (AT91F_PIO_GetInput(AT91C_BASE_PIOA) & LED3 ) == LED3 )
    {
        AT91F_PIO_ClearOutput( AT91C_BASE_PIOA, LED3 );
    }
    else
    {
        AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED3 );
    }

    //* while SW3 is push wait
    while ( (AT91F_PIO_GetInput(AT91C_BASE_PIOA) & SW3_MASK ) != SW3_MASK );

}

//*----------------------------------------------------------------------------
//* Function Name       : main
//* Object              : Main interrupt function
//*----------------------------------------------------------------------------
int main( void )
//* Begin
{
	char val;

    // First, enable the clock of the PIOB
    	AT91F_PMC_EnablePeriphClock ( AT91C_BASE_PMC, 1 << AT91C_ID_PIOA ) ;

   	//* then, we configure the PIO Lines corresponding to LED1 to LED8
   	//* to be outputs. No need to set these pins to be driven by the PIO because it is GPIO pins only.
    	AT91F_PIO_CfgOutput( AT91C_BASE_PIOA, LED_MASK ) ;
   	//* Clear the LED's. On the EB55 we must apply a "1" to turn off LEDs
   	   AT91F_PIO_SetOutput( AT91C_BASE_PIOA, LED_MASK ) ;
	//* Init Real Time Timer
    //* Open Timer 0 interrupt

	AT91F_AIC_ConfigureIt ( AT91C_BASE_AIC, AT91C_ID_SYS, RTTC_INTERRUPT_LEVEL,AT91C_AIC_SRCTYPE_INT_POSITIVE_EDGE, Periodic_Interval_Timer_handler);
	//* Set the interrupt mo
	AT91C_BASE_PITC->PITC_PIMR = AT91C_PITC_PITEN | AT91C_PITC_PITIEN | PIV_200_MS;  //  IRQ enable CPC
	//*  RTTC_RTAR
	AT91F_AIC_EnableIt (AT91C_BASE_AIC, AT91C_ID_SYS);



    //* Init Usart
    //* Open PIO for DBGU
        AT91F_DBGU_CfgPIO();

    //* Configure DBGU
	   AT91F_US_Configure (
		(AT91PS_USART) AT91C_BASE_DBGU,       // DBGU base address
		MCK,
		AT91C_US_ASYNC_MODE ,                 // Mode Register to be programmed
		AT91C_DBGU_BAUD ,                     // Baudrate to be programmed
		0);                                   // Timeguard to be programmed

    //* Enable Transmitter & receivier
       ((AT91PS_USART)AT91C_BASE_DBGU)->US_CR = AT91C_US_RXEN | AT91C_US_TXEN;


   //* open  FIQ interrupt
        AT91F_PIO_CfgPeriph(AT91C_BASE_PIOA,SW1_MASK,0);
	    AT91F_AIC_ConfigureIt (AT91C_BASE_AIC, AT91C_ID_FIQ, 0,AT91C_AIC_SRCTYPE_EXT_NEGATIVE_EDGE, FIQ_handler);
	    AT91F_AIC_EnableIt (AT91C_BASE_AIC, AT91C_ID_FIQ);
   //* generate FIQ interrupt by software
	    AT91F_AIC_Trig (AT91C_BASE_AIC,AT91C_ID_FIQ) ;

    //* open external PIO interrupt
    //* define switch SW3 at PIO input for interrupt IRQ loop
 	    AT91F_PIO_CfgInput(AT91C_BASE_PIOA, SW3_MASK );

    //* Infinit loop
    for (;;)
    {
    	//* Interrupt Acknowledge
    	if (AT91F_US_Get(&val))
    	{
    		value = AT91C_BASE_PITC->PITC_PIIR;
       		sprintf(message,"CPIV %d PICNT %d\n\r",(value &AT91C_PITC_CPIV),(value &AT91C_PITC_PICNT)>>20);
       		AT91F_DBGU_Printk(message);
		}
    }

//* End
}
