; ZEICHEN-DARSTELLUNG - 7-SEGMENT								
.equ ZAHL_0				=0b00111111	; 0 
.equ ZAHL_1				=0b00000110	; 1 
.equ ZAHL_2				=0b01011011	; 2 
.equ ZAHL_3				=0b01001111	; 3 
.equ ZAHL_4				=0b01100110	; 4 
.equ ZAHL_5				=0b01101101	; 5 
.equ ZAHL_6				=0b01111101	; 6 
.equ ZAHL_7				=0b00000111	; 7 
.equ ZAHL_8				=0b01111111	; 8 
.equ ZAHL_9				=0b01101111	; 9 

.equ ZEICHEN_AUS		=0b00000000	; ''
.equ ZEICHEN_PUNKT		=0b10000000	; . 
.equ ZEICHEN_VOLL		=0b11111111	; 8.
.equ ZEICHEN_MINUS		=0b01000000	; - 
.equ ZEICHEN_GRD		=0b01100011	;  

.equ ZEICHEN_A			=0b01110111	; A 
.equ ZEICHEN_B			=0b01111100	; B 
.equ ZEICHEN_C			=0b00111001	; C 
.equ ZEICHEN_D			=0b01011110	; D 
.equ ZEICHEN_E			=0b01111001	; E 
.equ ZEICHEN_F			=0b01110001	; F 
.equ ZEICHEN_H			=0b01110110	; H 
.equ ZEICHEN_L			=0b00111000	; L 
.equ ZEICHEN_N			=0b01010100	; N 
.equ ZEICHEN_O			=0b00111111	; 0 
.equ ZEICHEN_R			=0b01010000	; R 
.equ ZEICHEN_S			=0b01101101	; S 
.equ ZEICHEN_T			=0b01111000	; T 
.equ ZEICHEN_U			=0b00111110	; U 
.equ ZEICHEN_U_			=0b00011100	; u 
.equ ZEICHEN_P			=0b01110011	; P

; ##############################################################################
; ##############################################################################
; ##############################################################################
SEGMENT7_INITIALISIERUNG:
	sbi PORT_DDR_DIG_0,PIN_DIG_0
	sbi PORT_DDR_DIG_1,PIN_DIG_1
	sbi PORT_DDR_DIG_2,PIN_DIG_2
	sbi PORT_DDR_DIG_3,PIN_DIG_3

	sbi PORT_DDR_BALKEN_A,PIN_BALKEN_A
	sbi PORT_DDR_BALKEN_B,PIN_BALKEN_B
	sbi PORT_DDR_BALKEN_C,PIN_BALKEN_C
	sbi PORT_DDR_BALKEN_D,PIN_BALKEN_D
	sbi PORT_DDR_BALKEN_E,PIN_BALKEN_E
	sbi PORT_DDR_BALKEN_F,PIN_BALKEN_F
	sbi PORT_DDR_BALKEN_G,PIN_BALKEN_G
	sbi PORT_DDR_BALKEN_P,PIN_BALKEN_P

	cbi PORT_DIG_0,PIN_DIG_0
	cbi PORT_DIG_1,PIN_DIG_1
	cbi PORT_DIG_2,PIN_DIG_2
	cbi PORT_DIG_3,PIN_DIG_3


	cbi PORT_BALKEN_A,PIN_BALKEN_A	
	cbi PORT_BALKEN_B,PIN_BALKEN_B	
	cbi PORT_BALKEN_C,PIN_BALKEN_C	
	cbi PORT_BALKEN_D,PIN_BALKEN_D	
	cbi PORT_BALKEN_E,PIN_BALKEN_E	
	cbi PORT_BALKEN_F,PIN_BALKEN_F	
	cbi PORT_BALKEN_G,PIN_BALKEN_G	
	cbi PORT_BALKEN_P,PIN_BALKEN_P

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SEGMENT7_ON:
	sbi PORT_DDR_DIG_0,PIN_DIG_0
	sbi PORT_DDR_DIG_1,PIN_DIG_1
	sbi PORT_DDR_DIG_2,PIN_DIG_2
	sbi PORT_DDR_DIG_3,PIN_DIG_3
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SEGMENT7_OFF:
	cbi PORT_DDR_DIG_0,PIN_DIG_0
	cbi PORT_DDR_DIG_1,PIN_DIG_1
	cbi PORT_DDR_DIG_2,PIN_DIG_2
	cbi PORT_DDR_DIG_3,PIN_DIG_3
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SEGMENT7_DIGIT:
	; ZHLER+1		
	LDS temp,(adr_LED_DIGIT_ZAEHLER)
	inc temp
	; HELLIGKEIT	
	LDS temp1,(adr_HELL_WERT)
	; vergleich		
	cp temp,temp1
	brlo SEGMENT7_DIGIT_Z_FERTIG
	; NULL			
	clr temp
SEGMENT7_DIGIT_Z_FERTIG:
	STS(adr_LED_DIGIT_ZAEHLER),temp 
; ----------------------------------
	cbi PORT_DIG_0,PIN_DIG_0	; alle aus	
	cbi PORT_DIG_1,PIN_DIG_1
	cbi PORT_DIG_2,PIN_DIG_2
	cbi PORT_DIG_3,PIN_DIG_3
; ----------------------------------
	cpi temp,0
	breq SEGMENT7_DIGIT_0
	cpi temp,1
	breq SEGMENT7_DIGIT_1
	cpi temp,2
	breq SEGMENT7_DIGIT_2
	cpi temp,3
	breq SEGMENT7_DIGIT_3
ret
; ----------------------------------
SEGMENT7_DIGIT_0:
	LDS temp,(adr_LED_BYTE_0)
	rcall SEGMENT7_BALKEN
	sbi PORT_DIG_0,PIN_DIG_0	; an		
	ret
SEGMENT7_DIGIT_1:
	LDS temp,(adr_LED_BYTE_1)
	rcall SEGMENT7_BALKEN
	sbi PORT_DIG_1,PIN_DIG_1	; an		
	ret
SEGMENT7_DIGIT_2:
	LDS temp,(adr_LED_BYTE_2)
	rcall SEGMENT7_BALKEN
	sbi PORT_DIG_2,PIN_DIG_2	; an		
	ret
SEGMENT7_DIGIT_3:
	LDS temp,(adr_LED_BYTE_3)
	rcall SEGMENT7_BALKEN
	sbi PORT_DIG_3,PIN_DIG_3	; an		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SEGMENT7_BALKEN:
	SBRC temp,0	; Skip if Bit in Register Cleared
	cbi PORT_BALKEN_A,PIN_BALKEN_A	
	SBRS temp,0	; Skip if Bit in Register is Set
	sbi PORT_BALKEN_A,PIN_BALKEN_A	
	SBRC temp,1
	cbi PORT_BALKEN_B,PIN_BALKEN_B
	SBRS temp,1
	sbi PORT_BALKEN_B,PIN_BALKEN_B
	SBRC temp,2
	cbi PORT_BALKEN_C,PIN_BALKEN_C
	SBRS temp,2
	sbi PORT_BALKEN_C,PIN_BALKEN_C
	SBRC temp,3
	cbi PORT_BALKEN_D,PIN_BALKEN_D
	SBRS temp,3
	sbi PORT_BALKEN_D,PIN_BALKEN_D
	SBRC temp,4
	cbi PORT_BALKEN_D,PIN_BALKEN_E
	SBRS temp,4
	sbi PORT_BALKEN_D,PIN_BALKEN_E
	SBRC temp,5
	cbi PORT_BALKEN_E,PIN_BALKEN_F
	SBRS temp,5
	sbi PORT_BALKEN_E,PIN_BALKEN_F
	SBRC temp,6
	cbi PORT_BALKEN_F,PIN_BALKEN_G
	SBRS temp,6
	sbi PORT_BALKEN_F,PIN_BALKEN_G
	SBRC temp,7
	cbi PORT_BALKEN_P,PIN_BALKEN_P
	SBRS temp,7
	sbi PORT_BALKEN_P,PIN_BALKEN_P
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
