; ##############################################################################
; ##############################################################################
; ##############################################################################
;														
; ADC initialisieren mit "Free Run" und Vorteiler		
;														
; 	ADEN: ADC Enable                             		
; 	ADSC: ADC Start Conversion                   		
; 	ADFR: ADC Free Running Select                		
; 	ADIF: ADC Interrzpt Flag                     		
; 	ADIE: ADC Interrupt Enable                   		
; 	ADPS2: Vorteiler                             		
; 	ADPS2: Vorteiler                             		
; 	ADPS2: Vorteiler                             		
;														
;	ADPS2 ADPS1 ADPS0 Division Factor					
;	0 		0 	0 		2								
;	0 		0 	1 		2								
;	0 		1 	0 		4								
;	0 		1 	1 		8								
;	1 		0 	0 		16								
;	1 		0 	1	 	32								
; *	1 		1 	0 		64								
;	1 		1 	1 		128								
;														
; ADC REFERENZ																		
;																					
; REFS1 REFS0 Voltage Reference Selection											
; *0     0    AREF, Internal Vref turned off										
;  0     1    AVCC with external capacitor at AREF pin								
;  1     1    Internal 2.56V Voltage Reference with external capacitor at AREF pin	
ADC_INITIALISIERUNG:
	ldi temp, ((1<<ADEN)|(1<<ADSC)|(1<<ADFR)|(1<<ADPS2)|(1<<ADPS1)|(0<<ADPS0)) 
	out ADCSR, temp

	ldi temp, (0<<REFS1)|(0<<REFS0)|(0<<ADLAR)|(0<<MUX3)|(0<<MUX2)|(0<<MUX1)|(0<<MUX0)
	out ADMUX, temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MESSEN_0_GND:
	in temp, ADMUX
	andi temp, 0b11100000
	ori temp,0b00001111		; 0V (GND)				
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_0_L),temp1	; in SRAM speichern		
	STS(adr_ADC_0_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MESSEN_0_VBG:
	in temp, ADMUX
	andi temp, 0b11100000
	ori temp,0b00001110		; 1.23V (VBG)			
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_0_L),temp1	; in SRAM speichern		
	STS(adr_ADC_0_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 0																		
MESSEN_0:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, 0			; KANAL 0	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_0_L),temp1	; in SRAM speichern		
	STS(adr_ADC_0_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 1																		
MESSEN_1:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -1			; KANAL 1	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_1_L),temp1	; in SRAM speichern		
	STS(adr_ADC_1_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 2																		
MESSEN_2:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -2			; KANAL 2	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_2_L),temp1	; in SRAM speichern		
	STS(adr_ADC_2_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 3																		
MESSEN_3:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -3			; KANAL 3	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_3_L),temp1	; in SRAM speichern		
	STS(adr_ADC_3_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 4																		
; KTY81-22 																		
MESSEN_4:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -4			; KANAL 4	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	

	STS(adr_ADC_4_L),temp1	; in SRAM speichern		
	STS(adr_ADC_4_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 5																		
MESSEN_5:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -5			; KANAL 5	
	out ADMUX, temp

	rcall MESSEN			; OUT: TEMP1 / TEMP2	


	STS(adr_ADC_5_L),temp1	; in SRAM speichern		
	STS(adr_ADC_5_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ADC-WERT 256 mal einlesen und daraus den Mittelwert bilden					
;																				
; OUT: 	TEMP1 (low)  															
;		TEMP2																	
; 																				
MESSEN:
	push temp3					; HILFSREGISTER sichern			
	push temp4
	push temp5
	push temp6
	push temp8
;--------------------------------------------------------------------------
	; HILFSREGISTER CLEAR			
	clr temp3					
	clr temp4
	clr temp5
	clr temp6
	; SCHLEIFE initialisieren		
	clr temp8
; neuen ADC-Wert lesen	 Wert verwerfen, da meist vom vorherigem ADC-Kanal	
	sbi ADCSRA, ADIF    		; logisch "1" lscht ADIF flag !
MESSEN_w:                  
	sbis ADCSRA, ADIF			; warten bis ADIF flag gesetzt	
	rjmp MESSEN_w
; neuen ADC-Wert lesen	(Schleife - 256 mal)								
MESSEN_SCHLEIFE:                
	sbi ADCSRA, ADIF    		; logisch "1" lscht ADIF flag !
MESSEN_SCHLEIFE_w:                
	sbis ADCSR, ADIF 			; warten bis ADIF flag gesetzt	
	rjmp MESSEN_SCHLEIFE_w
; ADC einlesen:																
	in  temp1, ADCL 			; immer zuerst LOW Byte lesen
	in  temp2, ADCH 			; danach das mittlerweile gesperrte High Byte
; alle 256 ADC-Werte addieren												
	add temp4,temp1     		; addieren  						
	adc temp5,temp2     		; addieren ber Carry  				
	adc temp6,NULL    	 		; addieren ber Carry  				
	dec temp8			 		; Schleifenzhler MINUS 1			
	brne MESSEN_SCHLEIFE 		; ==> SCHLEIFE						
; MITTELWERT-BERECHNUNG	(128 addieren)										
	ldi temp,128
	add temp4,temp	     		; addieren  						
	adc temp5,NULL	     		; addieren ber Carry  				
	adc temp6,NULL    	 		; addieren ber Carry  				
; 	Ergebnis durch 256 teilen (temp5+6 nach temp1+2 kopieren)				
	mov temp1,temp5
	mov temp2,temp6
;--------------------------------------------------------------------------
	pop temp8					; Hilfsregister wieder herstellen	
	pop temp6
	pop temp5
	pop temp4
	pop temp3
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################

