; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_BEGRUESSUNG:
	ldi temp1,BYTE1(2015)
	ldi temp2,BYTE2(2015)
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	STS(adr_LED_BYTE_0), temp1	
	STS(adr_LED_BYTE_1), temp2
  	STS(adr_LED_BYTE_2), temp3
  	STS(adr_LED_BYTE_3), temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_LED_TEST:
	rcall TASTATUR_ABFRAGE
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_LED_TEST_RUN
	ret
ANZEIGE_LED_TEST_RUN:

	STS(adr_LED_BYTE_0),EINS
	STS(adr_LED_BYTE_1),NULL
	STS(adr_LED_BYTE_2),NULL
	STS(adr_LED_BYTE_3),NULL
	ldi temp,32
ANZEIGE_LED_TEST_s:
	LDS temp1,(adr_LED_BYTE_0)
	LDS temp2,(adr_LED_BYTE_1)
	LDS temp3,(adr_LED_BYTE_2)
	LDS temp4,(adr_LED_BYTE_3)
	LSL temp1
	ROL temp2
	ROL temp3
	ROL temp4
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
	rcall wait_100ms
	dec temp
	brne ANZEIGE_LED_TEST_s
	rjmp ANZEIGE_LED_TEST
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_MENUE:
	LDS temp1,(adr_MENUE)
	clr temp2
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; SPANNUNG Uges																	
ANZEIGE_UGES:
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_UGES_w

	ldi temp4, (ZEICHEN_U)
	ldi temp3, (ZEICHEN_AUS)
	ldi temp2, (ZEICHEN_AUS)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ANZEIGE_UGES_w:
	rcall wait_100ms
	rcall wait_100ms
	LDS temp1,(adr_KTY_UGES_L)
	LDS temp2,(adr_KTY_UGES_H)
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_HELLIGKEIT:
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_HELLIGKEIT_w

	ldi temp4, (ZEICHEN_H)
	ldi temp3, (ZEICHEN_E)
	ldi temp2, (ZEICHEN_L)
	ldi temp1, (ZEICHEN_L)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4

ANZEIGE_HELLIGKEIT_w:
	rcall wait_100ms
	rcall wait_100ms
	LDS temp1,(adr_HELL_WERT)
	clr temp2
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_UREF:
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_UREF_w

	ldi temp4, (ZEICHEN_R)
	ldi temp3, (ZEICHEN_E)
	ldi temp2, (ZEICHEN_F)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ANZEIGE_UREF_w:
	rcall wait_100ms
	rcall wait_100ms
	LDS temp1,(adr_KTY_UREF_L)
	LDS temp2,(adr_KTY_UREF_H)
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_R1:
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_R1_w

	ldi temp4, (ZEICHEN_R)
	ldi temp3, (ZAHL_1)
	ldi temp2, (ZEICHEN_AUS)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ANZEIGE_R1_w:
	rcall wait_100ms
	rcall wait_100ms
    LDS temp1,(adr_KTY_R1_L)
    LDS temp2,(adr_KTY_R1_H)
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_RESET:
	ldi temp4, (ZEICHEN_R)
	ldi temp3, (ZEICHEN_E)
	ldi temp2, (ZEICHEN_S)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_KALIBRIERUNG:
	ldi temp4, (ZEICHEN_C)
	ldi temp3, (ZEICHEN_A)
	ldi temp2, (ZEICHEN_L)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_ADC_0:
	ldi temp4, (ZEICHEN_A)
	ldi temp3, (ZEICHEN_D)
	ldi temp2, (ZEICHEN_C)
	ldi temp1, (ZEICHEN_AUS)

	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
	rcall wait_100ms
	rcall wait_100ms

    LDS temp1,(adr_ADC_0_L)
    LDS temp2,(adr_ADC_0_H)
	rcall ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_OFFSET:
	LDS temp,(adr_TASTE)
	tst temp
	brne ANZEIGE_OFFSET_w

	ldi temp4, (ZEICHEN_O)
	ldi temp3, (ZEICHEN_F)
	ldi temp2, (ZEICHEN_F)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
	rcall wait_100ms
	rcall wait_100ms
	rcall wait_100ms
	rcall wait_100ms
    LDS temp1,(adr_KTY_OFFSET_L)
    LDS temp2,(adr_KTY_OFFSET_H)
	rcall ANZEIGE_ZAHL_3_STELLEN_VORZEICHEN_TEMP1_TEMP2
	rcall wait_100ms
	rcall wait_100ms
ANZEIGE_OFFSET_w:
	rcall wait_100ms
	rcall wait_100ms
	rcall ANZEIGE_TEMPERATUR_KTY
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_TEMPERATUR_KTY_MAX:
	ldi temp1,LOW (1023)
	ldi temp2,HIGH(1023)	
	STS(adr_ADC_0_L),temp1	; in SRAM speichern		
	STS(adr_ADC_0_H),temp2	; in SRAM speichern		
	rcall KTY_BERECHNUNG
	rcall ANZEIGE_TEMPERATUR_KTY
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_TEMPERATUR_KTY:
    LDS temp1,(adr_KTY_TEMPERATUR_L)
    LDS temp2,(adr_KTY_TEMPERATUR_H)
	clr temp3
	clr temp4

	; negativ ?
 	tst temp2
	brmi ANZEIGE_TEMPERATUR_KTY_NEG	 	

 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	ori temp2, 0b10000000
	rcall NULLSTELLENUNTERDRUECKUNG
    ; TEMPERATUR
	STS(adr_LED_BYTE_0), temp1	
	STS(adr_LED_BYTE_1), temp2
  	STS(adr_LED_BYTE_2), temp3
  	STS(adr_LED_BYTE_3), temp4
	ret
ANZEIGE_TEMPERATUR_KTY_NEG:  
	; invertieren
	com temp1 	
	com temp2 	
	; + 1
	add temp1,EINS
	adc temp2,NULL

 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	ori temp2, 0b10000000
    ; TEMPERATUR
	STS(adr_LED_BYTE_0), temp1	
	STS(adr_LED_BYTE_1), temp2
  	STS(adr_LED_BYTE_2), temp3
  	; vorzeichen
	ldi temp4,(ZEICHEN_MINUS)
	STS(adr_LED_BYTE_3), temp4

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_AUTO:
	ldi temp4, (ZEICHEN_A)
	ldi temp3, (ZEICHEN_U_)
	ldi temp2, (ZEICHEN_T)
	ldi temp1, (ZEICHEN_O)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_RUN:
	ldi temp4, (ZEICHEN_R)
	ldi temp3, (ZEICHEN_U_)
	ldi temp2, (ZEICHEN_N)
	ldi temp1, (ZEICHEN_AUS)
	STS(adr_LED_BYTE_0),temp1
	STS(adr_LED_BYTE_1),temp2
	STS(adr_LED_BYTE_2),temp3
	STS(adr_LED_BYTE_3),temp4
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_STRICH4:
	ldi temp1,(ZEICHEN_MINUS)
	ldi temp2,(ZEICHEN_MINUS)
	ldi temp3,(ZEICHEN_MINUS)
	ldi temp4,(ZEICHEN_MINUS)
	rcall LED_AUSGABE_ZAHL_4_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_ZAHL_3_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	ldi temp4,(ZEICHEN_AUS)					; AUS	
	rcall LED_AUSGABE_ZAHL_4_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1+TEMP2															
ANZEIGE_ZAHL_3_STELLEN_VORZEICHEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
	; negativ ?
	tst temp2
	brmi ANZEIGE_ZAHL_3_STELLEN_VORZEICHEN_TEMP1_TEMP2_N
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	STS(adr_LED_BYTE_0), temp1
	STS(adr_LED_BYTE_1), temp2
	STS(adr_LED_BYTE_2), temp3
	ldi temp4,(ZEICHEN_AUS)
	STS(adr_LED_BYTE_3), temp4
	ret
ANZEIGE_ZAHL_3_STELLEN_VORZEICHEN_TEMP1_TEMP2_N:
	com temp1
	com temp2
	add temp1,EINS
	adc temp2,NULL
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	ldi temp4,(ZEICHEN_MINUS)				; VORZEICHEN	
	rcall LED_AUSGABE_ZAHL_4_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1+TEMP2															
ANZEIGE_ZAHL_4_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	rcall LED_AUSGABE_ZAHL_4_STELLEN_KURZ
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LED_AUSGABE_ZAHL_4_STELLEN_KURZ:
	STS(adr_LED_BYTE_3), temp4			; 1000-er Stelle
LED_AUSGABE_ZAHL_3_STELLEN_KURZ:
	STS(adr_LED_BYTE_2), temp3			; 100-er Stelle	
LED_AUSGABE_ZAHL_2_STELLEN_KURZ:
	STS(adr_LED_BYTE_1), temp2			; 10-er Stelle	
LED_AUSGABE_ZAHL_1_STELLEN_KURZ:
	STS(adr_LED_BYTE_0),temp1			; 1-er Stelle	
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
;																			
;	Value: 0...	99.999.999													
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		   1-er Stelle)									
;			temp2	(		  10-er Stelle)									
;			temp3	(        100-er Stelle)									
;			temp4	(      1.000-er Stelle)									
;			temp5	(     10.000-er Stelle)									
;			temp6	(    100.000-er Stelle)									
;			temp7	(  1.000.000-er Stelle)									
;			temp8	( 10.000.000-er Stelle)									
; 																			
; rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8			
; 																			
FUNKTION_HEX_ASC_32:
	clr temp
FUNKTION_HEX_ASC_10000000:; 10.000.000
	inc temp
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_10000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp8) auf dem Stack sichern            
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
	clr temp
FUNKTION_HEX_ASC_1000000:
	inc temp
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_1000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp7) auf dem Stack sichern            
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
	clr temp
FUNKTION_HEX_ASC_100000:
	inc temp
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_100000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp6) auf dem Stack sichern            
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
	clr temp
FUNKTION_HEX_ASC_10000:
	inc temp
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_10000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp5) auf dem Stack sichern            
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
	clr temp
FUNKTION_HEX_ASC_1000:
	inc temp
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_1000
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp4) auf dem Stack sichern            
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
	clr temp
FUNKTION_HEX_ASC_100:
	inc temp
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_100
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp3) auf dem Stack sichern            
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
	clr temp
FUNKTION_HEX_ASC_10:
	inc temp
	subi temp1, low  (10)
	sbci temp2, HIGH (10)
	brcc FUNKTION_HEX_ASC_10
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp2) auf dem Stack sichern            
	subi temp1, low  (-10)
	sbci temp2, HIGH (-10)
FUNKTION_HEX_ASC_1:	
	subi temp1, -48		; HEX->ASC

	pop	TEMP2			; LESEN vom STACK (KOPIE)
	pop	TEMP3			; LESEN vom STACK (KOPIE)
	pop	TEMP4			; LESEN vom STACK (KOPIE)
	pop	TEMP5			; LESEN vom STACK (KOPIE)
	pop	TEMP6			; LESEN vom STACK (KOPIE)
	pop	TEMP7			; LESEN vom STACK (KOPIE)
	pop	TEMP8			; LESEN vom STACK (KOPIE)

	; auf 7 SEGNMENT
	mov temp,temp1
	rcall FUNKTION_7_SEGMENT
	mov temp1,temp

	mov temp,temp2
	rcall FUNKTION_7_SEGMENT
	mov temp2,temp


	mov temp,temp3
	rcall FUNKTION_7_SEGMENT
	mov temp3,temp

	mov temp,temp4
	rcall FUNKTION_7_SEGMENT
	mov temp4,temp

	mov temp,temp5
	rcall FUNKTION_7_SEGMENT
	mov temp5,temp

	mov temp,temp6
	rcall FUNKTION_7_SEGMENT
	mov temp6,temp

	mov temp,temp7
	rcall FUNKTION_7_SEGMENT
	mov temp7,temp

	mov temp,temp8
	rcall FUNKTION_7_SEGMENT
	mov temp8,temp

ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
FUNKTION_7_SEGMENT:
	cpi temp,'0'
	breq FUNKTION_7_SEGMENT_0
	cpi temp,'1'
	breq FUNKTION_7_SEGMENT_1
	cpi temp,'2'
	breq FUNKTION_7_SEGMENT_2
	cpi temp,'3'
	breq FUNKTION_7_SEGMENT_3
	cpi temp,'4'
	breq FUNKTION_7_SEGMENT_4
	cpi temp,'5'
	breq FUNKTION_7_SEGMENT_5
	cpi temp,'6'
	breq FUNKTION_7_SEGMENT_6
	cpi temp,'7'
	breq FUNKTION_7_SEGMENT_7
	cpi temp,'8'
	breq FUNKTION_7_SEGMENT_8
	cpi temp,'9'
	breq FUNKTION_7_SEGMENT_9
	; ERROR
	ldi temp, (ZEICHEN_E)
	ret
FUNKTION_7_SEGMENT_0:
	ldi temp, (ZAHL_0)
	ret
FUNKTION_7_SEGMENT_1:
	ldi temp, (ZAHL_1)
	ret
FUNKTION_7_SEGMENT_2:
	ldi temp, (ZAHL_2)
	ret
FUNKTION_7_SEGMENT_3:
	ldi temp, (ZAHL_3)
	ret
FUNKTION_7_SEGMENT_4:
	ldi temp, (ZAHL_4)
	ret
FUNKTION_7_SEGMENT_5:
	ldi temp, (ZAHL_5)
	ret
FUNKTION_7_SEGMENT_6:
	ldi temp, (ZAHL_6)
	ret
FUNKTION_7_SEGMENT_7:
	ldi temp, (ZAHL_7)
	ret
FUNKTION_7_SEGMENT_8:
	ldi temp, (ZAHL_8)
	ret
FUNKTION_7_SEGMENT_9:
	ldi temp, (ZAHL_9)
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
NULLSTELLENUNTERDRUECKUNG:

	cpi temp8,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp8,(ZEICHEN_AUS)

	cpi temp7,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp7,(ZEICHEN_AUS)

	cpi temp6,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp6,(ZEICHEN_AUS)

	cpi temp5,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp5,(ZEICHEN_AUS)

	cpi temp4,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp4,(ZEICHEN_AUS)

	cpi temp3,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp3,(ZEICHEN_AUS)

	cpi temp2,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp2,(ZEICHEN_AUS)

	cpi temp1,(ZAHL_0)
	brne NULL_FERTIG
	ldi temp1,(ZAHL_0)

NULL_FERTIG:

ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; INP: temp1																
; OUT: temp1+2 (z.B."FF") 													
FUNKTION_HEX:
	; SICHERUNGSKOPIE						
	push temp
	; 1-er STELLE		
	mov temp2,temp1
	mov temp,temp1	

	rcall FUNKTION_HEX_UMWANDLUNG
	mov temp1,temp
	; 10-er STELLE		
	mov temp,temp2	
	; NIBBLES tausch	
	swap temp
	rcall FUNKTION_HEX_UMWANDLUNG
	mov temp2,temp
	; SICHERUNGSKOPIE wieder herstellen		
	pop temp
	ret
;-------------------------------------------------------------------------------
FUNKTION_HEX_UMWANDLUNG:
	; BITMUSTER	
	andi temp,0b00001111
	; vergleich	
	cpi temp,0
	breq FUNKTION_HEX_0
	cpi temp,1
	breq FUNKTION_HEX_1
	cpi temp,2
	breq FUNKTION_HEX_2
	cpi temp,3
	breq FUNKTION_HEX_3
	cpi temp,4
	breq FUNKTION_HEX_4
	cpi temp,5
	breq FUNKTION_HEX_5
	cpi temp,6
	breq FUNKTION_HEX_6
	cpi temp,7
	breq FUNKTION_HEX_7
	cpi temp,8
	breq FUNKTION_HEX_8
	cpi temp,9
	breq FUNKTION_HEX_9
	cpi temp,10
	breq FUNKTION_HEX_A
	cpi temp,11
	breq FUNKTION_HEX_B
	cpi temp,12
	breq FUNKTION_HEX_C
	cpi temp,13
	breq FUNKTION_HEX_D
	cpi temp,14
	breq FUNKTION_HEX_E
	cpi temp,15
	breq FUNKTION_HEX_F

FUNKTION_HEX_0:
	ldi temp,(ZAHL_0)
	ret
FUNKTION_HEX_1:
	ldi temp,(ZAHL_1)
	ret
FUNKTION_HEX_2:
	ldi temp,(ZAHL_2)
	ret
FUNKTION_HEX_3:
	ldi temp,(ZAHL_3)
	ret
FUNKTION_HEX_4:
	ldi temp,(ZAHL_4)
	ret
FUNKTION_HEX_5:
	ldi temp,(ZAHL_5)
	ret
FUNKTION_HEX_6:
	ldi temp,(ZAHL_6)
	ret
FUNKTION_HEX_7:
	ldi temp,(ZAHL_7)
	ret
FUNKTION_HEX_8:
	ldi temp,(ZAHL_8)
	ret
FUNKTION_HEX_9:
	ldi temp,(ZAHL_9)
	ret
FUNKTION_HEX_A:
	ldi temp,(ZEICHEN_A)
	ret
FUNKTION_HEX_B:
	ldi temp,(ZEICHEN_B)
	ret
FUNKTION_HEX_C:
	ldi temp,(ZEICHEN_C)
	ret
FUNKTION_HEX_D:
	ldi temp,(ZEICHEN_D)
	ret
FUNKTION_HEX_E:
	ldi temp,(ZEICHEN_E)
	ret
FUNKTION_HEX_F:
	ldi temp,(ZEICHEN_F)
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
