; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Ein Byte aus EEPROM holen und Z-Zeiger + 1									
;																				
; INPUT:	ZL Adresse (low)													
;			ZH Adresse (High)													
;																				
; OUTPUT: 	TEMP (DATEN)														
;																				
; rcall EEPROM_READ_PLUS ; INP: ZL+ZH(ADRESSE) OUT: TEMP (DATEN)				
;																				
EEPROM_READ_PLUS_Z_TEMP:
	sbic EECR,EEWE 		; Wait for completion of previous write
	rjmp EEPROM_READ_PLUS_Z_TEMP
	out  EEARH, ZH		; ADRESSE setzen						
	out  EEARL, ZL
	sbi  EECR,EERE		; Start eeprom read by writing EERE		
	in 	 temp,EEDR		; Read data from data register			
	adiw ZL,1			; ADRESSE +1 							
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Ein Byte im EEPROM ablegen und Z-Zeiger + 1									
;																				
; INPUT:	ZL Adresse (low)													
;			ZH Adresse (High)													
;																				
; 		 	TEMP  DATEN															
;																				
;	rcall EEPROM_WRITE_PLUS	; INP: TEMP1(DATEN) ZL+ZH(ADRESSE) (Z+1)			
;																				
EEPROM_WRITE_PLUS_Z_TEMP:
	sbic EECR,EEWE		; Wait for completion of previous write
	rjmp EEPROM_WRITE_PLUS_Z_TEMP
	out  EEARH,ZH		; ADRESSE setzen						
	out  EEARL,ZL
	out  EEDR, temp		; Write data  to data register			
	sbi  EECR, EEMWE	; Write logical one to EEMWE			
	sbi  EECR, EEWE		; Start eeprom write by setting EEWE	
	adiw ZL,1			; ADRESSE +1 							
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EEPROM_KONFIGURATION_LADEN:
	rcall LED_STRICH4
	rcall wait_100ms
	rcall wait_100ms

	clr ZL
	clr ZH
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	cpi temp,'E'
	breq EEPROM_KONFIGURATION_LADEN_RUN
	ret
EEPROM_KONFIGURATION_LADEN_RUN:
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_OFFSET_L),temp
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_OFFSET_H),temp

	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_UGES_L),temp
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_UGES_H),temp

	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_UREF_L),temp
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_UREF_H),temp

	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_R1_L),temp
	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_KTY_R1_H),temp

	rcall EEPROM_READ_PLUS_Z_TEMP		; READ
	STS(adr_HELL_WERT),temp

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EEPROM_KONFIGURATION_SICHERN:
	rcall LED_STRICH4

	clr ZL
	clr ZH
	ldi temp,'E'
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	LDS temp,(adr_KTY_OFFSET_L)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write
	LDS temp,(adr_KTY_OFFSET_H)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	LDS temp,(adr_KTY_UGES_L)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write
	LDS temp,(adr_KTY_UGES_H)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	LDS temp,(adr_KTY_UREF_L)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write
	LDS temp,(adr_KTY_UREF_H)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	LDS temp,(adr_KTY_R1_L)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write
	LDS temp,(adr_KTY_R1_H)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	LDS temp,(adr_HELL_WERT)
	rcall EEPROM_WRITE_PLUS_Z_TEMP		; write

	rcall wait_100ms
	rcall wait_100ms
	rcall wait_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
