; ##############################################################################
; ##############################################################################
; ##############################################################################
; Version: 14.11.2014																	
;																						
; 	INPUT:	TEMP1 / TEMP2 	1.Faktor													
;			TEMP3 / TEMP4	2.Faktor													
; 																						
; 	OUTPUT: TEMP1...4	Produkt															
; 																						
;	HILFSREGISTER: 	R0,R1,R2 (werden nicht gesichert !	)								
; 					temp5+6+7+8															
FUNKTION_MULTIPLIKATION_16_16_32:
	push temp5
	push temp6
	push temp7
	push temp8

	clr	r2
	mul	temp4,temp2		; ah * bh
	mov	temp7,r0
	mov	temp8,r1
	mul	temp3,temp1		; al * bl
	mov	temp5,r0
	mov	temp6,r1
	mul	temp4,temp1		; ah * bl
	add	temp6,r0
	adc	temp7,r1
	adc	temp8,r2
	mul	temp2,temp3		; bh * al
	add	temp6,r0
	adc	temp7,r1
	adc	temp8,r2


	mov temp1,temp5
	mov temp2,temp6
	mov temp3,temp7
	mov temp4,temp8

	pop temp8
	pop temp7
	pop temp6
	pop temp5

ret
;###############################################################################
;###############################################################################
;###############################################################################
; Version: 22.10.2015															
; 																		 		
; FUNKTION DIVISION 32-32-BYTE													
; 																		 		
; 	INPUT: 	TEMP1....TEMP4 (0....4.294.967.295)	Divident				 		
;			TEMP5....TEMP8 (1....4.294.967.295)	Divisor 				 		
;																		 		
; 	OUTPUT;	TEMP1....TEMP5 (0....4.294.967.295) Quotient				 		
;																		 		
;	Hilfsregister: R0,R1,R2,R3,R4,R5,R6;R7,TEMP									
;																		 		
DIVISION_32_32:
; FEHLERPRFUNG (Divisor >0)			
	tst  temp5
	brne DIVISION_32_32_RUN
	tst  temp6
	brne DIVISION_32_32_RUN
	tst  temp7
	brne DIVISION_32_32_RUN
	tst  temp8
	brne DIVISION_32_32_RUN
	; FEHLER ==> AUSGABE 888888888		
	clr temp1
	clr temp2
	clr temp3
	clr temp4
	clr temp5
	clr temp6
	clr temp7
	clr temp8
	ret
;-------------------------------------------------------------------------------
; Register sichern																
DIVISION_32_32_RUN:
	push R0
	push R1
	push R2
	push R3
	push R4
	push R5
	push R6
	push R7
;-------------------------------------------------------------------------------
; aufrunden	(halben Devisor dazuaddieren)										
	mov R0,temp5	; kopieren	
	mov R1,temp6
	mov R2,temp7
	mov R3,temp8
	LSR R3			; durch 2	
	ROR R2
	ROR R1
	ROR R0
	add temp1,R0	; addieren	
	adc temp2,R1
	adc temp3,R2
	adc temp4,R3
;-------------------------------------------------------------------------------
; Register Initialisieren	
	ldi temp,1
	mov	R0,temp				; HILFSREGISTER =1 
	clr R1
	clr R2
	clr R3
	clr R4					; ERGEBNIS			
	clr R5
	clr R6
	clr R7
;-------------------------------------------------------------------------------
; Divisor linksbndig 	
DIVISION_32_32_LINKS:
	tst	temp8					; Linksbndig ?		
	brmi DIVISION_32_32_START	; ja ==> SPRUNG		

	LSL R0						; HILFSREGISTER 1x links	
	ROL R1
	ROL R2
	ROL R3

	LSL	temp5					; DIVISOR 1x links	
	ROL temp6
	ROL temp7
	ROL temp8
	rjmp DIVISION_32_32_LINKS

; DIVISION START		
DIVISION_32_32_START:
	cp	temp4,temp8	; DIVIDENT ">=" DIVISOR	?	(H_H)	
	brlo DIVISION_32_32_SCHIEBEN	; nein=> SPRUNG						
	breq DIVISION_32_32__w
	brsh DIVISION_32_32_ADD_SUB
DIVISION_32_32__w:
	cp	temp3,temp7	; DIVIDENT ">=" DIVISOR	?	(H_L)	
	brlo DIVISION_32_32_SCHIEBEN	; nein=> SPRUNG						
	breq DIVISION_32_32__ww
	brsh DIVISION_32_32_ADD_SUB
DIVISION_32_32__ww:
	cp	temp2,temp6	; DIVIDENT ">=" DIVISOR	?	(L_H)	
	brlo DIVISION_32_32_SCHIEBEN	; nein=> SPRUNG						
	breq DIVISION_32_32__www
	brsh DIVISION_32_32_ADD_SUB
DIVISION_32_32__www:
	cp	temp1,temp5	; DIVIDENT ">=" DIVISOR	?	(L_L)	
	brlo DIVISION_32_32_SCHIEBEN	; nein=> SPRUNG				

; ADDIEREN und SUBTRAHIEREN
DIVISION_32_32_ADD_SUB:
	add	R4,R0				; ERGEBNIS vergrern 				
	adc R5,R1
	adc R6,R2
	adc R7,R3

	sub	temp1,temp5			; DIVIDENT verkleinern				
	sbc temp2,temp6
	sbc temp3,temp7
	sbc temp4,temp8

; 1 x rechts schieben		
DIVISION_32_32_SCHIEBEN:
	LSR	temp8				; DIVISOR 1 x rechts				
	ROR temp7
	ROR temp6
	ROR temp5

	LSR	R3					; HILFSREGISTER => 1 x rechts		
	ROR R2
	ROR R1
	ROR R0

; HILFSREGISTER=0 ?						
	TST R3						; =0 ?							
	brne DIVISION_32_32_START	; nein ==> SPRUNG				
	TST R2
	brne DIVISION_32_32_START			
	TST R1
	brne DIVISION_32_32_START	
	TST R0
	brne DIVISION_32_32_START	
; ERGEBNIS nach temp1...Temp4 kopieren	
	mov temp1, R4
	mov temp2, R5
	mov temp3, R6
	mov temp4, R7
; DIVISOR lschen						
	clr temp5
	clr temp6
	clr temp7
	clr temp8
; REGISTER wiederherstellen				
	pop R7
	pop R6
	pop R5
	pop R4
	pop R3
	pop R2
	pop R1
	pop R0
ret
;###############################################################################
;###############################################################################
;###############################################################################

