; ##############################################################################
; ##############################################################################
; ##############################################################################
; REFERENZ-SPANNUNG																
KTY_INITIALISIERUNG:
	sbi (POWER_DDR) ,(POWER_PIN_NR)		; auf AUSGANG	
	cbi (POWER_PORT),(POWER_PIN_NR)		; LOW			
	; Uges				
	ldi temp1,LOW (Uges)
	ldi temp2,HIGH(Uges)
	STS(adr_KTY_UGES_L),temp1	
	STS(adr_KTY_UGES_H),temp2
	; UREF				
	ldi temp1,LOW (Uref)
	ldi temp2,HIGH(Uref)
	STS(adr_KTY_UREF_L),temp1	
	STS(adr_KTY_UREF_H),temp2
	; R1				
	ldi temp1,LOW (W_R1)
	ldi temp2,HIGH(W_R1)
	STS(adr_KTY_R1_L),temp1	
	STS(adr_KTY_R1_H),temp2
	; OFFSET			
	ldi temp1,LOW (0)
	ldi temp2,HIGH(0)
	STS(adr_KTY_OFFSET_L),temp1	
	STS(adr_KTY_OFFSET_H),temp2
	; HELLIGKEIT		
	ldi temp,4
	STS(adr_HELL_WERT),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
KTY_MESSUNG_UREF:
	rcall KTY_POWER_ON				; POWER ON		
;	rcall SEGMENT7_OFF
	rcall wait_1ms					; PAUSE			
	rcall MESSEN_0_VBG				; Messen (VBG)	
	rcall KTY_POWER_OFF				; POWER OFF		
;	rcall SEGMENT7_ON
	; Uref=1024*1230/ADC			
	ldi temp1,BYTE1(1024*UBG)
	ldi temp2,BYTE2(1024*UBG)
	ldi temp3,BYTE3(1024*UBG)
	ldi temp4,BYTE4(1024*UBG)
	LDS temp5,(adr_ADC_0_L)			; ADC-WERT laden
	LDS temp6,(adr_ADC_0_H)
	clr temp7
	clr temp8
	rcall DIVISION_32_32			; DIVISION		
	STS(adr_KTY_UREF_L),temp1		; speichern		
	STS(adr_KTY_UREF_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
KTY_POWER_ON:
	sbi (POWER_PORT),(POWER_PIN_NR)					; HIGH		
	; PUNKT on					
	LDS temp,(adr_LED_BYTE_0)
	ori temp, 0b10000000	
	STS(adr_LED_BYTE_0),temp
ret
; #############################################################################
; ##############################################################################
; ##############################################################################
KTY_POWER_OFF:
	cbi (POWER_PORT),(POWER_PIN_NR)					; LOW		
	; PUNKT off					
	LDS temp,(adr_LED_BYTE_0)
	andi temp, 0b01111111
	STS(adr_LED_BYTE_0),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
KTY_MESSUNG:
	rcall KTY_POWER_ON				; REFERENZ-ON	
;	rcall wait_1ms					; PAUSE			
	rcall MESSEN_0					; Messen		
	rcall KTY_POWER_OFF				; REFERENZ-OFF	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
KTY_BERECHNUNG:
;-------------------------------------------------------------------------------
; U2=ADC x Uref / 1024															
	LDS temp1,(adr_ADC_0_L)					; ADC-WERT laden 			
	LDS temp2,(adr_ADC_0_H)
	; TESTWERT		
;	ldi temp1,LOW (854)
;	ldi temp2,HIGH(854)
;	ldi temp1,LOW (1023)
;	ldi temp2,HIGH(1023)
	; ERROR ?	
	cpi temp2,HIGH(1023)
	brlo KTY_BERECHNUNG_OK
	breq KTY_BERECHNUNG_L
	rjmp KTY_BERECHNUNG_ERROR
KTY_BERECHNUNG_L:
	cpi temp1,LOW(1023)
	brlo KTY_BERECHNUNG_OK
	breq KTY_BERECHNUNG_OK
	rjmp KTY_BERECHNUNG_ERROR
;-------------------------------------------------------------------------------
KTY_BERECHNUNG_OK:
	LDS temp3,(adr_KTY_OFFSET_L)			; OFFSET-addieren			
	LDS temp4,(adr_KTY_OFFSET_H)	
	add temp1,temp3
	adc temp2,temp4
	LDS temp3,(adr_KTY_UREF_L)				; Uref						
	LDS temp4,(adr_KTY_UREF_H)
	rcall FUNKTION_MULTIPLIKATION_16_16_32	; Multiplikation			
	ldi temp5,BYTE1(1024)					; :1024						
	ldi temp6,BYTE2(1024)
	ldi temp7,BYTE3(1024)
	ldi temp8,BYTE4(1024)
	rcall DIVISION_32_32					; DIVISION					
	mov XL,temp1							; Zwischenergebnis	U2 (519)
	mov XH,temp2
;-------------------------------------------------------------------------------
; U1=Uges-U2			
	LDS YL,(adr_KTY_UGES_L)
	LDS YH,(adr_KTY_UGES_H)
	sub YL,XL								; Zwischenergebnis	U1 (481)
	sbc YH,XH
;-------------------------------------------------------------------------------
; R2=U2 x R1 / U1
	mov temp1,XL							; Zwischenergebnis	U1		
	mov temp2,XH
	LDS temp3,(adr_KTY_R1_L)				; R1						
	LDS temp4,(adr_KTY_R1_H)
	rcall FUNKTION_MULTIPLIKATION_16_16_32	; Multiplikation			
	mov temp5,YL							; Zwischenergebnis	U1		
	mov temp6,YH
	clr temp7
	clr temp8
	rcall DIVISION_32_32					; DIVISION					
;-------------------------------------------------------------------------------
	; TESTWERT					
;	ldi temp1,LOW (971)						; 971Ohm = 20C (KTY81-122)	
;	ldi temp2,HIGH(971)
	; ERROR R_MIN ?				
	cpi temp2,HIGH(R_MIN)
	brlo KTY_BERECHNUNG_ERROR
	breq KTY_BERECHNUNG_w1
	brsh KTY_BERECHNUNG_w2
KTY_BERECHNUNG_w1:
	cpi temp1,LOW(R_MIN)
	brlo KTY_BERECHNUNG_ERROR
KTY_BERECHNUNG_w2:
	; ERROR R_MAX ?				
	cpi temp2,HIGH(R_MAX)
	brlo KTY_BERECHNUNG_w4
	breq KTY_BERECHNUNG_w3
	brsh KTY_BERECHNUNG_ERROR
KTY_BERECHNUNG_w3:
	cpi temp1,LOW(R_MAX)
	brlo KTY_BERECHNUNG_w4
	breq KTY_BERECHNUNG_w4
	brsh KTY_BERECHNUNG_ERROR
KTY_BERECHNUNG_w4:
;-------------------------------------------------------------------------------
	; TABELLE initialisieren	
	subi temp1,LOW (R_MIN)		; Minus R_MIN	
	sbci temp2,HIGH(R_MIN)
	; Z auf TABELLE				
	ldi ZL,LOW (TABELLE_KTY81_122*2)
	ldi ZH,HIGH(TABELLE_KTY81_122*2)	
	; 2xaddieren				
	add ZL,temp1
	adc ZH,temp2
	add ZL,temp1
	adc ZH,temp2
	; aus Tabelle laden			
	LPM temp1, Z+   			; LOW  aus Tabelle laden und Zeiger um 1 erhhen
	LPM temp2, Z    			; HIGH aus Tabelle laden						
	; SPEICHERN							
	STS(adr_KTY_TEMPERATUR_L),temp1
	STS(adr_KTY_TEMPERATUR_H),temp2
	ret
;-------------------------------------------------------------------------------
KTY_BERECHNUNG_ERROR:
	ldi temp1,LOW (8888)
	ldi temp2,HIGH(8888)
	STS(adr_KTY_TEMPERATUR_L),temp1
	STS(adr_KTY_TEMPERATUR_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KTY81-122                                          							
; Zahlenrechner   22.10.2015      21:49:02										
; Temperatur in Abhngigkeit WIDERSTAND											
; -55...150C                                        							
; Tabellen-Anfangswert: 495 Ohm = -55 C             							
; Tabellen-Endwert:    2233 Ohm = 150 C             							
;                                                    							
.equ R_MIN	= 495
.equ R_MAX	=2233
TABELLE_KTY81_122:
.dw -550 ,-548 ,-547 ,-544 ,-543 ,-540 ,-538 ,-537 ,-534 ,-533 
.dw -530 ,-528 ,-527 ,-524 ,-523 ,-520 ,-518 ,-517 ,-514 ,-513 
.dw -510 ,-508 ,-507 ,-504 ,-503 ,-500 ,-499 ,-497 ,-495 ,-493 
.dw -491 ,-489 ,-487 ,-485 ,-484 ,-482 ,-480 ,-478 ,-476 ,-474 
.dw -472 ,-470 ,-468 ,-467 ,-465 ,-463 ,-461 ,-459 ,-457 ,-455 
.dw -453 ,-451 ,-450 ,-448 ,-446 ,-444 ,-442 ,-440 ,-438 ,-436 
.dw -434 ,-433 ,-431 ,-429 ,-427 ,-425 ,-423 ,-421 ,-419 ,-417 
.dw -416 ,-414 ,-412 ,-410 ,-408 ,-406 ,-404 ,-402 ,-400 ,-399 
.dw -397 ,-395 ,-393 ,-392 ,-390 ,-388 ,-386 ,-385 ,-383 ,-381 
.dw -379 ,-378 ,-376 ,-374 ,-372 ,-371 ,-369 ,-367 ,-365 ,-364 
.dw -362 ,-360 ,-358 ,-357 ,-355 ,-353 ,-351 ,-350 ,-348 ,-346 
.dw -344 ,-343 ,-341 ,-339 ,-337 ,-336 ,-334 ,-332 ,-330 ,-329 
.dw -327 ,-325 ,-323 ,-322 ,-320 ,-318 ,-316 ,-315 ,-313 ,-311 
.dw -309 ,-308 ,-306 ,-304 ,-302 ,-300 ,-299 ,-297 ,-295 ,-294 
.dw -292 ,-290 ,-289 ,-287 ,-285 ,-284 ,-282 ,-280 ,-279 ,-277 
.dw -275 ,-274 ,-272 ,-270 ,-269 ,-267 ,-265 ,-264 ,-262 ,-260 
.dw -259 ,-257 ,-255 ,-254 ,-252 ,-250 ,-249 ,-247 ,-245 ,-244 
.dw -242 ,-240 ,-239 ,-237 ,-235 ,-234 ,-232 ,-230 ,-229 ,-227 
.dw -225 ,-224 ,-222 ,-220 ,-219 ,-217 ,-215 ,-214 ,-212 ,-210 
.dw -209 ,-207 ,-205 ,-204 ,-202 ,-200 ,-199 ,-197 ,-196 ,-194 
.dw -193 ,-191 ,-190 ,-188 ,-187 ,-185 ,-184 ,-182 ,-180 ,-179 
.dw -177 ,-176 ,-174 ,-173 ,-171 ,-170 ,-168 ,-167 ,-165 ,-164 
.dw -162 ,-160 ,-159 ,-157 ,-156 ,-154 ,-153 ,-151 ,-150 ,-148 
.dw -147 ,-145 ,-144 ,-142 ,-140 ,-139 ,-137 ,-136 ,-134 ,-133 
.dw -131 ,-130 ,-128 ,-127 ,-125 ,-124 ,-122 ,-120 ,-119 ,-117 
.dw -116 ,-114 ,-113 ,-111 ,-110 ,-108 ,-107 ,-105 ,-104 ,-102 
.dw -100 ,-99 ,-98 ,-96 ,-95 ,-93 ,-92 ,-90 ,-89 ,-87 
.dw -86 ,-84 ,-83 ,-81 ,-80 ,-78 ,-77 ,-75 ,-74 ,-73 
.dw -71 ,-70 ,-68 ,-67 ,-65 ,-64 ,-62 ,-61 ,-59 ,-58 
.dw -56 ,-55 ,-53 ,-52 ,-50 ,-49 ,-48 ,-46 ,-45 ,-43 
.dw -42 ,-40 ,-39 ,-37 ,-36 ,-34 ,-33 ,-31 ,-30 ,-28 
.dw -27 ,-25 ,-24 ,-23 ,-21 ,-20 ,-18 ,-17 ,-15 ,-14 
.dw -12 ,-11 ,-9 ,-8 ,-6 ,-5 ,-3 ,-2 , 0 , 1 
.dw  2 , 4 , 5 , 6 , 8 , 9 , 11 , 12 , 13 , 15 
.dw  16 , 18 , 19 , 20 , 22 , 23 , 25 , 26 , 27 , 29 
.dw  30 , 31 , 33 , 34 , 36 , 37 , 38 , 40 , 41 , 43 
.dw  44 , 45 , 47 , 48 , 50 , 51 , 52 , 54 , 55 , 56 
.dw  58 , 59 , 61 , 62 , 63 , 65 , 66 , 68 , 69 , 70 
.dw  72 , 73 , 75 , 76 , 77 , 79 , 80 , 81 , 83 , 84 
.dw  86 , 87 , 88 , 90 , 91 , 93 , 94 , 95 , 97 , 98 
.dw  100 , 101 , 102 , 103 , 105 , 106 , 107 , 109 , 110 , 111 
.dw  113 , 114 , 115 , 117 , 118 , 119 , 121 , 122 , 123 , 125 
.dw  126 , 127 , 128 , 130 , 131 , 132 , 134 , 135 , 136 , 138 
.dw  139 , 140 , 142 , 143 , 144 , 146 , 147 , 148 , 150 , 151 
.dw  152 , 153 , 155 , 156 , 157 , 159 , 160 , 161 , 163 , 164 
.dw  165 , 167 , 168 , 169 , 171 , 172 , 173 , 175 , 176 , 177 
.dw  178 , 180 , 181 , 182 , 184 , 185 , 186 , 188 , 189 , 190 
.dw  192 , 193 , 194 , 196 , 197 , 198 , 200 , 201 , 202 , 203 
.dw  205 , 206 , 207 , 208 , 210 , 211 , 212 , 214 , 215 , 216 
.dw  217 , 219 , 220 , 221 , 223 , 224 , 225 , 226 , 228 , 229 
.dw  230 , 232 , 233 , 234 , 235 , 237 , 238 , 239 , 241 , 242 
.dw  243 , 244 , 246 , 247 , 248 , 250 , 251 , 252 , 253 , 255 
.dw  256 , 257 , 258 , 260 , 261 , 262 , 263 , 265 , 266 , 267 
.dw  268 , 270 , 271 , 272 , 273 , 275 , 276 , 277 , 278 , 280 
.dw  281 , 282 , 283 , 285 , 286 , 287 , 288 , 290 , 291 , 292 
.dw  293 , 295 , 296 , 297 , 298 , 300 , 301 , 302 , 303 , 304 
.dw  305 , 307 , 308 , 309 , 310 , 311 , 313 , 314 , 315 , 316 
.dw  317 , 319 , 320 , 321 , 322 , 323 , 325 , 326 , 327 , 328 
.dw  329 , 330 , 332 , 333 , 334 , 335 , 336 , 338 , 339 , 340 
.dw  341 , 342 , 344 , 345 , 346 , 347 , 348 , 350 , 351 , 352 
.dw  353 , 354 , 355 , 357 , 358 , 359 , 360 , 361 , 363 , 364 
.dw  365 , 366 , 367 , 369 , 370 , 371 , 372 , 373 , 375 , 376 
.dw  377 , 378 , 379 , 380 , 382 , 383 , 384 , 385 , 386 , 388 
.dw  389 , 390 , 391 , 392 , 394 , 395 , 396 , 397 , 398 , 400 
.dw  401 , 402 , 403 , 404 , 405 , 406 , 408 , 409 , 410 , 411 
.dw  412 , 413 , 414 , 416 , 417 , 418 , 419 , 420 , 421 , 422 
.dw  424 , 425 , 426 , 427 , 428 , 429 , 431 , 432 , 433 , 434 
.dw  435 , 436 , 437 , 439 , 440 , 441 , 442 , 443 , 444 , 445 
.dw  447 , 448 , 449 , 450 , 451 , 452 , 454 , 455 , 456 , 457 
.dw  458 , 459 , 460 , 462 , 463 , 464 , 465 , 466 , 467 , 468 
.dw  470 , 471 , 472 , 473 , 474 , 475 , 477 , 478 , 479 , 480 
.dw  481 , 482 , 483 , 485 , 486 , 487 , 488 , 489 , 490 , 491 
.dw  493 , 494 , 495 , 496 , 497 , 498 , 500 , 501 , 502 , 503 
.dw  504 , 505 , 506 , 507 , 508 , 509 , 510 , 512 , 513 , 514 
.dw  515 , 516 , 517 , 518 , 519 , 520 , 521 , 523 , 524 , 525 
.dw  526 , 527 , 528 , 529 , 530 , 531 , 532 , 534 , 535 , 536 
.dw  537 , 538 , 539 , 540 , 541 , 542 , 543 , 545 , 546 , 547 
.dw  548 , 549 , 550 , 551 , 552 , 553 , 554 , 556 , 557 , 558 
.dw  559 , 560 , 561 , 562 , 563 , 564 , 565 , 567 , 568 , 569 
.dw  570 , 571 , 572 , 573 , 574 , 575 , 576 , 578 , 579 , 580 
.dw  581 , 582 , 583 , 584 , 585 , 586 , 587 , 589 , 590 , 591 
.dw  592 , 593 , 594 , 595 , 596 , 597 , 598 , 600 , 601 , 602 
.dw  603 , 604 , 605 , 606 , 607 , 608 , 609 , 610 , 611 , 612 
.dw  613 , 614 , 615 , 617 , 618 , 619 , 620 , 621 , 622 , 623 
.dw  624 , 625 , 626 , 627 , 628 , 629 , 630 , 631 , 632 , 634 
.dw  635 , 636 , 637 , 638 , 639 , 640 , 641 , 642 , 643 , 644 
.dw  645 , 646 , 647 , 648 , 650 , 651 , 652 , 653 , 654 , 655 
.dw  656 , 657 , 658 , 659 , 660 , 661 , 662 , 663 , 664 , 665 
.dw  667 , 668 , 669 , 670 , 671 , 672 , 673 , 674 , 675 , 676 
.dw  677 , 678 , 679 , 680 , 681 , 682 , 684 , 685 , 686 , 687 
.dw  688 , 689 , 690 , 691 , 692 , 693 , 694 , 695 , 696 , 697 
.dw  698 , 700 , 701 , 702 , 703 , 704 , 705 , 706 , 707 , 708 
.dw  709 , 710 , 711 , 712 , 713 , 714 , 715 , 716 , 717 , 718 
.dw  719 , 720 , 721 , 722 , 723 , 724 , 725 , 726 , 727 , 728 
.dw  729 , 730 , 731 , 732 , 733 , 734 , 735 , 736 , 737 , 738 
.dw  739 , 740 , 741 , 742 , 743 , 744 , 745 , 746 , 747 , 748 
.dw  749 , 750 , 751 , 752 , 753 , 754 , 755 , 756 , 757 , 758 
.dw  759 , 760 , 761 , 762 , 763 , 764 , 765 , 766 , 767 , 768 
.dw  769 , 770 , 771 , 772 , 773 , 774 , 775 , 776 , 777 , 778 
.dw  779 , 780 , 781 , 782 , 783 , 784 , 785 , 786 , 787 , 788 
.dw  789 , 790 , 791 , 792 , 793 , 794 , 795 , 796 , 797 , 798 
.dw  800 , 800 , 801 , 802 , 803 , 804 , 805 , 806 , 807 , 808 
.dw  809 , 810 , 811 , 812 , 813 , 814 , 815 , 816 , 817 , 818 
.dw  819 , 820 , 821 , 822 , 823 , 824 , 825 , 826 , 827 , 828 
.dw  829 , 830 , 831 , 832 , 833 , 834 , 835 , 836 , 837 , 838 
.dw  839 , 840 , 841 , 842 , 843 , 844 , 845 , 846 , 847 , 848 
.dw  849 , 850 , 850 , 851 , 852 , 853 , 854 , 855 , 856 , 857 
.dw  858 , 859 , 860 , 861 , 862 , 863 , 864 , 865 , 866 , 867 
.dw  868 , 869 , 870 , 871 , 872 , 873 , 874 , 875 , 876 , 877 
.dw  878 , 879 , 880 , 881 , 882 , 883 , 884 , 885 , 886 , 887 
.dw  888 , 889 , 890 , 891 , 892 , 893 , 894 , 895 , 896 , 897 
.dw  898 , 899 , 900 , 900 , 901 , 902 , 903 , 904 , 905 , 906 
.dw  907 , 908 , 909 , 910 , 911 , 912 , 913 , 914 , 915 , 916 
.dw  916 , 917 , 918 , 919 , 920 , 921 , 922 , 923 , 924 , 925 
.dw  926 , 927 , 928 , 929 , 930 , 931 , 932 , 933 , 933 , 934 
.dw  935 , 936 , 937 , 938 , 939 , 940 , 941 , 942 , 943 , 944 
.dw  945 , 946 , 947 , 948 , 949 , 950 , 950 , 951 , 952 , 953 
.dw  954 , 955 , 956 , 957 , 958 , 959 , 960 , 961 , 962 , 963 
.dw  964 , 965 , 966 , 966 , 967 , 968 , 969 , 970 , 971 , 972 
.dw  973 , 974 , 975 , 976 , 977 , 978 , 979 , 980 , 981 , 982 
.dw  983 , 983 , 984 , 985 , 986 , 987 , 988 , 989 , 990 , 991 
.dw  992 , 993 , 994 , 995 , 996 , 997 , 998 , 999 , 1000 , 1000 
.dw  1001 , 1002 , 1003 , 1004 , 1005 , 1006 , 1007 , 1008 , 1009 , 1010 
.dw  1010 , 1011 , 1012 , 1013 , 1014 , 1015 , 1016 , 1017 , 1018 , 1019 
.dw  1020 , 1020 , 1021 , 1022 , 1023 , 1024 , 1025 , 1026 , 1027 , 1028 
.dw  1029 , 1030 , 1030 , 1031 , 1032 , 1033 , 1034 , 1035 , 1036 , 1037 
.dw  1038 , 1039 , 1040 , 1040 , 1041 , 1042 , 1043 , 1044 , 1045 , 1046 
.dw  1047 , 1048 , 1049 , 1050 , 1050 , 1051 , 1052 , 1053 , 1054 , 1055 
.dw  1056 , 1057 , 1058 , 1059 , 1060 , 1060 , 1061 , 1062 , 1063 , 1064 
.dw  1065 , 1066 , 1067 , 1068 , 1069 , 1070 , 1070 , 1071 , 1072 , 1073 
.dw  1074 , 1075 , 1076 , 1077 , 1078 , 1079 , 1080 , 1080 , 1081 , 1082 
.dw  1083 , 1084 , 1085 , 1086 , 1087 , 1088 , 1089 , 1090 , 1090 , 1091 
.dw  1092 , 1093 , 1094 , 1095 , 1096 , 1097 , 1098 , 1099 , 1100 , 1100 
.dw  1101 , 1102 , 1103 , 1104 , 1105 , 1106 , 1107 , 1108 , 1109 , 1109 
.dw  1110 , 1111 , 1112 , 1113 , 1114 , 1115 , 1116 , 1117 , 1118 , 1118 
.dw  1119 , 1120 , 1121 , 1122 , 1123 , 1124 , 1125 , 1126 , 1127 , 1127 
.dw  1128 , 1129 , 1130 , 1131 , 1132 , 1133 , 1134 , 1135 , 1136 , 1136 
.dw  1137 , 1138 , 1139 , 1140 , 1141 , 1142 , 1143 , 1144 , 1145 , 1145 
.dw  1146 , 1147 , 1148 , 1149 , 1150 , 1151 , 1152 , 1153 , 1154 , 1154 
.dw  1155 , 1156 , 1157 , 1158 , 1159 , 1160 , 1161 , 1162 , 1163 , 1163 
.dw  1164 , 1165 , 1166 , 1167 , 1168 , 1169 , 1170 , 1171 , 1172 , 1172 
.dw  1173 , 1174 , 1175 , 1176 , 1177 , 1178 , 1179 , 1180 , 1181 , 1181 
.dw  1182 , 1183 , 1184 , 1185 , 1186 , 1187 , 1188 , 1189 , 1190 , 1190 
.dw  1191 , 1192 , 1193 , 1194 , 1195 , 1196 , 1197 , 1198 , 1199 , 1200 
.dw  1200 , 1201 , 1202 , 1203 , 1204 , 1205 , 1206 , 1207 , 1208 , 1209 
.dw  1210 , 1210 , 1211 , 1212 , 1213 , 1214 , 1215 , 1216 , 1217 , 1218 
.dw  1219 , 1220 , 1220 , 1221 , 1222 , 1223 , 1224 , 1225 , 1226 , 1227 
.dw  1228 , 1229 , 1230 , 1230 , 1231 , 1232 , 1233 , 1234 , 1235 , 1236 
.dw  1237 , 1238 , 1239 , 1240 , 1240 , 1241 , 1242 , 1243 , 1244 , 1245 
.dw  1246 , 1247 , 1248 , 1249 , 1250 , 1250 , 1251 , 1252 , 1253 , 1254 
.dw  1255 , 1256 , 1257 , 1258 , 1259 , 1260 , 1260 , 1261 , 1262 , 1263 
.dw  1264 , 1265 , 1266 , 1267 , 1268 , 1269 , 1270 , 1270 , 1271 , 1272 
.dw  1273 , 1274 , 1275 , 1276 , 1277 , 1278 , 1279 , 1280 , 1280 , 1281 
.dw  1282 , 1283 , 1284 , 1285 , 1286 , 1287 , 1288 , 1289 , 1290 , 1290 
.dw  1291 , 1292 , 1293 , 1294 , 1295 , 1296 , 1297 , 1298 , 1299 , 1300 
.dw  1300 , 1301 , 1302 , 1303 , 1304 , 1305 , 1306 , 1307 , 1308 , 1309 
.dw  1310 , 1311 , 1312 , 1313 , 1314 , 1315 , 1316 , 1317 , 1318 , 1319 
.dw  1320 , 1321 , 1322 , 1323 , 1324 , 1325 , 1326 , 1327 , 1328 , 1329 
.dw  1330 , 1331 , 1332 , 1333 , 1334 , 1335 , 1336 , 1337 , 1338 , 1339 
.dw  1340 , 1341 , 1342 , 1343 , 1344 , 1345 , 1346 , 1347 , 1348 , 1349 
.dw  1350 , 1350 , 1351 , 1352 , 1353 , 1354 , 1355 , 1356 , 1357 , 1358 
.dw  1359 , 1360 , 1361 , 1362 , 1363 , 1364 , 1365 , 1366 , 1367 , 1368 
.dw  1369 , 1370 , 1371 , 1372 , 1373 , 1374 , 1375 , 1376 , 1377 , 1378 
.dw  1379 , 1380 , 1381 , 1382 , 1383 , 1384 , 1385 , 1386 , 1387 , 1388 
.dw  1389 , 1390 , 1391 , 1392 , 1393 , 1394 , 1395 , 1396 , 1397 , 1398 
.dw  1399 , 1400 , 1401 , 1402 , 1403 , 1404 , 1405 , 1406 , 1408 , 1409 
.dw  1410 , 1411 , 1412 , 1413 , 1414 , 1416 , 1417 , 1418 , 1419 , 1420 
.dw  1421 , 1422 , 1424 , 1425 , 1426 , 1427 , 1428 , 1429 , 1431 , 1432 
.dw  1433 , 1434 , 1435 , 1436 , 1437 , 1439 , 1440 , 1441 , 1442 , 1443 
.dw  1444 , 1445 , 1447 , 1448 , 1449 , 1450 , 1451 , 1452 , 1454 , 1455 
.dw  1456 , 1457 , 1458 , 1459 , 1460 , 1462 , 1463 , 1464 , 1465 , 1466 
.dw  1467 , 1468 , 1470 , 1471 , 1472 , 1473 , 1474 , 1475 , 1477 , 1478 
.dw  1479 , 1480 , 1481 , 1482 , 1483 , 1485 , 1486 , 1487 , 1488 , 1489 
.dw  1490 , 1491 , 1493 , 1494 , 1495 , 1496 , 1497 , 1498 , 1500 , 1500 
