; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE:
	; TASTE MENUE gedrckt ?	
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_MENUE_WERT)
	brne MENUE_RUN
	LDS temp,(adr_MENUE)
	inc temp
	STS(adr_MENUE),temp
	STS(adr_TASTE),NULL	; TASTE clear	
;-------------------------------------------------------------------------------
MENUE_RUN:
	ldi ZL,LOW (MENUE_SPRUNGMARKE)
	ldi ZH,HIGH(MENUE_SPRUNGMARKE)
	LDS temp,(adr_MENUE)
	add ZL,temp
	adc ZH,NULL
	ijmp ; Sprung nach Z 
;-------------------------------------------------------------------------------
MENUE_SPRUNGMARKE:
	rjmp MENUE_ANZEIGE
	rjmp MENUE_HELLIGKEIT
	rjmp MENUE_OFFSET
	rjmp MENUE_UGES
	rjmp MENUE_UREF
	rjmp MENUE_R1
	rjmp MENUE_ADC
	rjmp MENUE_KALIBRIERUNG
	rjmp MENUE_AUTO_KALIBRIERUNG
	rjmp MENUE_TEMPERATUR_MAX
	rjmp MENUE_RESET ; WERKSEINSTELLUNG	
	rjmp MENUE_RESERVE
	; BERLAUF	
	rcall EEPROM_KONFIGURATION_SICHERN	
	rcall ANZEIGE_RUN
MENUE_NEUSTART:
	rjmp MENUE_NEUSTART

;-------------------------------------------------------------------------------
MENUE_ANZEIGE:
	rcall KTY_MESSUNG
	rcall KTY_BERECHNUNG
	rcall ANZEIGE_TEMPERATUR_KTY
	rcall TASTATUR_WAIT
	rcall TASTATUR_WAIT
	rcall TASTATUR_WAIT
	rcall TASTATUR_WAIT
	rcall TASTATUR_WAIT
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
; EDIT OFFSET																	
MENUE_OFFSET:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_OFFSET_P
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_OFFSET_M
	rjmp MENUE_OFFSET_RUN
MENUE_OFFSET_P:
	LDS temp1,(adr_KTY_OFFSET_L)	
	LDS temp2,(adr_KTY_OFFSET_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_KTY_OFFSET_L),temp1
	STS(adr_KTY_OFFSET_H),temp2
	rjmp MENUE_OFFSET_RUN
MENUE_OFFSET_M:
	LDS temp1,(adr_KTY_OFFSET_L)	
	LDS temp2,(adr_KTY_OFFSET_H)
	sub temp1,EINS
	sbc temp2,NULL
	STS(adr_KTY_OFFSET_L),temp1
	STS(adr_KTY_OFFSET_H),temp2
	rjmp MENUE_OFFSET_RUN
MENUE_OFFSET_RUN:
	rcall KTY_MESSUNG
	rcall KTY_BERECHNUNG
	rcall ANZEIGE_OFFSET
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
; EDIT Uges																		
MENUE_UGES:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_UGES_P
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_UGES_M
	rjmp MENUE_UGES_RUN
MENUE_UGES_P:
	LDS temp1,(adr_KTY_UGES_L)	
	LDS temp2,(adr_KTY_UGES_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_KTY_UGES_L),temp1
	STS(adr_KTY_UGES_H),temp2
	rjmp MENUE_UGES_RUN
MENUE_UGES_M:
	LDS temp1,(adr_KTY_UGES_L)	
	LDS temp2,(adr_KTY_UGES_H)
	sub temp1,EINS
	sbc temp2,NULL
	STS(adr_KTY_UGES_L),temp1
	STS(adr_KTY_UGES_H),temp2
	rjmp MENUE_UGES_RUN
MENUE_UGES_RUN:
	rcall ANZEIGE_UGES
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
; EDIT Uref																		
MENUE_UREF:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_UREF_P
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_UREF_M
	rjmp MENUE_UREF_RUN
MENUE_UREF_P:
	LDS temp1,(adr_KTY_UREF_L)	
	LDS temp2,(adr_KTY_UREF_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_KTY_UREF_L),temp1
	STS(adr_KTY_UREF_H),temp2
	rjmp MENUE_UREF_RUN
MENUE_UREF_M:
	LDS temp1,(adr_KTY_UREF_L)	
	LDS temp2,(adr_KTY_UREF_H)
	sub temp1,EINS
	sbc temp2,NULL
	STS(adr_KTY_UREF_L),temp1
	STS(adr_KTY_UREF_H),temp2
	rjmp MENUE_UREF_RUN
MENUE_UREF_RUN:
	rcall ANZEIGE_UREF
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
; EDIT R1																		
MENUE_R1:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_R1_P
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_R1_M
	rjmp MENUE_R1_RUN
MENUE_R1_P:
	LDS temp1,(adr_KTY_R1_L)	
	LDS temp2,(adr_KTY_R1_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_KTY_R1_L),temp1
	STS(adr_KTY_R1_H),temp2
	rjmp MENUE_R1_RUN
MENUE_R1_M:
	LDS temp1,(adr_KTY_R1_L)	
	LDS temp2,(adr_KTY_R1_H)
	sub temp1,EINS
	sbc temp2,NULL
	STS(adr_KTY_R1_L),temp1
	STS(adr_KTY_R1_H),temp2
	rjmp MENUE_R1_RUN
MENUE_R1_RUN:
	rcall ANZEIGE_R1
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
MENUE_RESET:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_RESET_PM
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_RESET_PM
	rjmp MENUE_RESET_RUN
MENUE_RESET_PM:
	STS(adr_LED_BYTE_0),NULL
	STS(adr_LED_BYTE_1),NULL
	STS(adr_LED_BYTE_2),NULL
	STS(adr_LED_BYTE_3),NULL
	rcall wait_100ms
	ldi temp,0b10000000
	STS(adr_LED_BYTE_0),temp
	rcall wait_100ms
	STS(adr_LED_BYTE_1),temp
	rcall wait_100ms
	STS(adr_LED_BYTE_2),temp
	rcall wait_100ms
	STS(adr_LED_BYTE_3),temp
	rcall wait_100ms
	rcall KTY_INITIALISIERUNG
	rcall EEPROM_KONFIGURATION_SICHERN	
MENUE_RESET_PM_s:
	rjmp MENUE_RESET_PM_s
MENUE_RESET_RUN:
	rcall ANZEIGE_RESET
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
MENUE_KALIBRIERUNG:
	rcall ANZEIGE_KALIBRIERUNG
	rcall KTY_POWER_ON
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
	ret
;-------------------------------------------------------------------------------
MENUE_TEMPERATUR_MAX:
	rcall ANZEIGE_TEMPERATUR_KTY_MAX
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
ret
;-------------------------------------------------------------------------------
MENUE_AUTO_KALIBRIERUNG:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_AUTO_KALIBRIERUNG_PM
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_AUTO_KALIBRIERUNG_PM
	rjmp MENUE_AUTO_KALIBRIERUNG_RUN
MENUE_AUTO_KALIBRIERUNG_PM:
	rcall KTY_MESSUNG_UREF
	rcall ANZEIGE_UREF
	rcall wait_1s

MENUE_AUTO_KALIBRIERUNG_RUN:
	rcall ANZEIGE_AUTO
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
ret
;-------------------------------------------------------------------------------
MENUE_HELLIGKEIT:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS_WERT)
	breq MENUE_HELLIGKEIT_P
	cpi temp,(TASTE_MINUS_WERT)
	breq MENUE_HELLIGKEIT_M
	rjmp MENUE_HELLIGKEIT_RUN
MENUE_HELLIGKEIT_P:
	LDS temp1,(adr_HELL_WERT)	
	add temp1,EINS
	STS(adr_HELL_WERT),temp1
	rjmp MENUE_HELLIGKEIT_RUN
MENUE_HELLIGKEIT_M:
	LDS temp1,(adr_HELL_WERT)	
	sub temp1,EINS
	STS(adr_HELL_WERT),temp1
	rjmp MENUE_HELLIGKEIT_RUN
MENUE_HELLIGKEIT_RUN:
	rcall ANZEIGE_HELLIGKEIT
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
ret
;-------------------------------------------------------------------------------
MENUE_ADC:
	rcall KTY_MESSUNG
	rcall KTY_BERECHNUNG
	rcall ANZEIGE_ADC_0
	rcall wait_100ms
	rcall wait_100ms
	rcall TASTATUR_WAIT
ret
;-------------------------------------------------------------------------------
MENUE_RESERVE:
	rcall ANZEIGE_MENUE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
