; ##############################################################################
; ##############################################################################
; ##############################################################################
WDR_INITIALISIERUNG:
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (SRAM_START)
	ldi ZH, HIGH(SRAM_START)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT B+C+D initialisieren														
PORT_CLEAR:
	ldi temp, 0b00000000	
	out DDRB, temp
	out DDRC, temp
	out DDRD, temp
	out PORTB,temp				
	out PORTC,temp				
	out PORTD,temp	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
REGISTER_CLEAR:
	clr R0
	clr R1
	clr R2
	clr R3
	clr R4
	clr R5
	clr R6
	clr R7
	clr R8
	clr R9
	clr R10
	clr R11
	clr R12
	clr R13
	clr R14
	clr R15
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	ret
; SCHLEIFE, bis WDR zubeit		
PROGRAMM_CHECK_FEHLER:
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_STOP:
	WDR
rjmp PROGRAMM_STOP
; ##############################################################################
; ##############################################################################
; ##############################################################################

