; ##############################################################################
; ##############################################################################
; ##############################################################################
TIMER_AKTIVIEREN:
;																			
; Timer 0+1+2 berlauf-Int aktivieren (Timer/Counter Interrupt Mask)		
;																			
; TIMSK ==> OCIE2 TOIE2 TICIE1 OCIE1A OCIE1B TOIE1 R TOIE0  				
;																			
	ldi temp,(0<<OCIE2)|(0<<TOIE2)|(0<<TICIE1)|(0<<OCIE1A)|(0<<OCIE1B)|(0<<TOIE1)|(1<<TOIE0)
	out TIMSK,temp       
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TIMER0_INITIALISIERUNG:
; TIMER0 (8Bit) Vorteiler													
;																			
; CS02 CS01 CS00 	Description												
;	0 	0 	0 		No clock source (Timer/Counter stopped).				
;	0 	0 	1 		clkI/O/		(No prescaling)								
;	0 	1 	0 		clkI/O/8 	(From prescaler)							
; *	0 	1 	1 		clkI/O/64 	(From prescaler)							
; 	1 	0 	0 		clkI/O/256 	(From prescaler)							
; 	1 	0 	1 		clkI/O/1024 (From prescaler)							
;	1 	1 	0 		External clock source on T0 pin. Clock on falling edge.	
;	1 	1 	1 		External clock source on T0 pin. Clock on rising edge.	
	ldi temp,(0<<CS02)|(1<<CS01)|(1<<CS00)
	OUT TCCR0,temp
; TIMER0 Startwert		
	ldi temp, TIMERWERT0
	out TCNT0,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TIM0_OVF:
	push TEMP		    ; Sichern von "TEMP" im Stack
	in	 TEMP,SREG		; Einlesen des SREG 
	push TEMP	    	; Schreiben von  SREG  im Stack (KOPIE)
	push TEMP1
; ----------------------------------
; TIMER0 Startwert					
	ldi temp, TIMERWERT0
	out TCNT0,temp
; ----------------------------------
	rcall SEGMENT7_DIGIT
; ----------------------------------
	pop TEMP1
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)
	out	SREG,TEMP		; Wiederherstellen von SREG
	pop	TEMP			; Wiederherstellen von "TEMP" 			
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
