;												
; Thermometer KTY81-122							
; -55..150C									
;												
; ATmega8										
; 1 MHz											
;												
; Bernhard.Erfurt@gmx.de						
; 10/2015										
;												

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> s. Belegung							
; PB1 ==> s. Belegung							
; PB2 ==> TASTE									
; PB3 ==> 										
; PB4 ==> 										
; PB5 ==> 										
; PB6 ==> s. Belegung							
; PB7 ==> s. Belegung							
;												
; PC0 ==> IN-ADC								
; PC1 ==> OUT-REF								
; PC2 ==> TASTE									
; PC3 ==> TASTE									
; PC4 ==> 										
; PC5 ==> 										
;												
; PD0 ==> s. Belegung							
; PD1 ==> s. Belegung							
; PD2 ==> s. Belegung							
; PD3 ==> s. Belegung							
; PD4 ==> s. Belegung							
; PD5 ==> s. Belegung							
; PD6 ==> s. Belegung							
; PD7 ==> s. Belegung							
;												


; ATmega8 										
.include "m8def.inc"
; KONSTANTEN									
.equ TAKT					=1000000			
; TIMER-WERTE (2 hoch 8  minus...)				
.equ TIMERWERT0 			=256-25	
; KTY											
.equ Uges   =4880			  ; mV			
.equ Uref	=2908			  ; mV			
.equ UBG	=1230			  ; mV	Bandgap reference voltage (1,15...1,23...1,4V)		
.equ W_R1	=990			  ; OHM			
; POWER-KTY										
.equ POWER_PIN_NR				= 1
.equ POWER_DDR					= DDRC
.equ POWER_PORT					= PORTC
; TASTE "MENUE"									
.equ TASTE_MENUE_WERT			= 1
.equ TASTE_MENUE_PIN_NR			= 2
.equ TASTE_MENUE_PIN			= PINB
.equ TASTE_MENUE_DDR			= DDRB
.equ TASTE_MENUE_PORT			= PORTB
; TASTE "PLUS"									
.equ TASTE_PLUS_WERT			= 2
.equ TASTE_PLUS_PIN_NR			= 2
.equ TASTE_PLUS_PIN				= PINC
.equ TASTE_PLUS_DDR				= DDRC
.equ TASTE_PLUS_PORT			= PORTC
; TASTE "MINUS"									
.equ TASTE_MINUS_WERT			= 4
.equ TASTE_MINUS_PIN_NR			= 3
.equ TASTE_MINUS_PIN			= PINC
.equ TASTE_MINUS_DDR			= DDRC
.equ TASTE_MINUS_PORT			= PORTC
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN					=SRAM_START+0			; 0x0060 START Adresse 		

.equ adr_MENUE					=SRAM_START+2

.equ adr_HELL_WERT				=SRAM_START+4

.equ adr_TASTE					=SRAM_START+10
.equ adr_TASTE_OLD				=SRAM_START+11

.equ adr_KTY_OFFSET_L			=SRAM_START+30
.equ adr_KTY_OFFSET_H			=SRAM_START+31
.equ adr_KTY_UGES_L				=SRAM_START+32
.equ adr_KTY_UGES_H				=SRAM_START+33
.equ adr_KTY_UREF_L				=SRAM_START+34
.equ adr_KTY_UREF_H				=SRAM_START+35
.equ adr_KTY_R1_L				=SRAM_START+36
.equ adr_KTY_R1_H				=SRAM_START+37
.equ adr_KTY_TEMPERATUR_L       =SRAM_START+38
.equ adr_KTY_TEMPERATUR_H       =SRAM_START+39

.equ adr_ADC_0_L				=SRAM_START+50
.equ adr_ADC_0_H				=SRAM_START+51
.equ adr_ADC_1_L				=SRAM_START+52
.equ adr_ADC_1_H				=SRAM_START+53
.equ adr_ADC_2_L				=SRAM_START+54
.equ adr_ADC_2_H				=SRAM_START+55
.equ adr_ADC_3_L				=SRAM_START+56
.equ adr_ADC_3_H				=SRAM_START+57
.equ adr_ADC_4_L				=SRAM_START+58
.equ adr_ADC_4_H				=SRAM_START+59
.equ adr_ADC_5_L				=SRAM_START+60
.equ adr_ADC_5_H				=SRAM_START+61

.equ adr_LED_DIGIT_ZAEHLER		= SRAM_START+90

.equ adr_LED_BYTE_0				= SRAM_START+100		; DIGIT (rechts)
.equ adr_LED_BYTE_1				= SRAM_START+101
.equ adr_LED_BYTE_2				= SRAM_START+102
.equ adr_LED_BYTE_3				= SRAM_START+103


; REGISTER										

.def NULL 	= R14
.def EINS 	= R15

.def temp 	= R16
.def temp1 	= R17
.def temp2 	= R18
.def temp3 	= R19
.def temp4 	= R20
.def temp5 	= R21
.def temp6 	= R22
.def temp7 	= R23
.def temp8 	= R24
.def temp9 	= R25





.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF   ; Timer1 Overflow Handler           	
rjmp TIM0_OVF   		; Timer0 Overflow Handler           					
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	; USART RX Complete Handler         					
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI      ; Two-wire Serial Interface Handler 					
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Bei unkorrekten Interrupt aufrufen erfolgt ein RESET ber WDR	
INTERRUPT_ERROR:
	wdr	
INTERRUPT_ERROR_SCHLEIFE:
	rjmp INTERRUPT_ERROR_SCHLEIFE

RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; WDR_INITIALISIERUNG								
	rcall WDR_INITIALISIERUNG
; SRAM clear										
	rcall SRAM_CLEAR
; PORT_CLEAR										
	rcall PORT_CLEAR
; REGISTER_CLEAR									
	rcall REGISTER_CLEAR
; SEGMENT7_INITIALISIERUNG							
	rcall SEGMENT7_INITIALISIERUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; ADC_INITIALISIERUNG								
	rcall ADC_INITIALISIERUNG
; TIMER0_INITIALISIERUNG							
	rcall TIMER0_INITIALISIERUNG
; TIMER_AKTIVIEREN									
	rcall TIMER_AKTIVIEREN
; KTY_INITIALISIERUNG								
	rcall KTY_INITIALISIERUNG
; TASTATUR_INITIALISIERUNG							
	rcall TASTATUR_INITIALISIERUNG
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
; interrupts freigeben								
	SEI
	rcall EEPROM_KONFIGURATION_LADEN
	rcall ANZEIGE_LED_TEST
	rcall ANZEIGE_BEGRUESSUNG
	rcall WAIT_100ms
	rcall WAIT_100ms
	rcall WAIT_100ms
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR		; Watch-Dog-RESET	
	rcall TASTATUR_ABFRAGE
	rcall MENUE
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "THERMO_TASTEN.asm"
.include "THERMO_MENUE.asm"
.include "THERMO_EEPROM.asm"
.include "THERMO_ANZEIGE.asm"
.include "THERMO_TIMER.asm"
.include "THERMO_SONSTIGES.asm"
.include "THERMO_ADC.asm"
.include "THERMO_7SEGMENT.asm"
.include "THERMO_7SEGMENT_BELEGUNG_V1.asm"
.include "THERMO_WAIT_01MHZ.asm"
.include "THERMO_FUNKTIONEN.asm"
.include "THERMO_KTY.asm"
