/*****************************************************************************
*
*	File Name: Display.c                                          
*                                                                  
*	Content:   This is a LCD demo program for the MDECE0620 eval board.
*			   Each of the three pushbuttons (S2-S4) bring up a different LCD
*			   demo when pressed.
*
*  	Date:  27-07-02
*  	This program was written to run on the M16C 30624F
*                  
*                                                                  
*	Copyright 2002 
*       R.Inacker                                            
*                                                                  
*=============================================================================
*	$Log:$
*===========================================================================*/

#include   "sfr_3062.h"
//#define M3062F
//#include "Config.h"
#include <stdio.h>
#define NOP nop_instruction()
#include "lcd_grafik.h"
#include <ctype.h>
#include "Anzeige.h"
#include "alias.h" // fr IC BUS
#include "i2c.h"   // fr IC BUS



#define ADST ADCON0.6           // Startbit fr die A/D_Wandlung

/* Prototypes */

void LCD_write (char *msg_string, int line );
void LCD_scroll (char *msg_string, int line );
void Key_ISR (void );
void Int0_ISR (void);
void init_sys(void);
void init_i2c_bus(void);
void read_eeprom_cmd(void);
void write_eeprom_cmd(void);


/* Global variables */
unsigned char ki0_flag = 0;
unsigned char ki1_flag = 0;
unsigned char int0_flag = 0;
int wait=0,x=0,t,i=0,ad_value;
unsigned char i2c_ram[256];	// RAM region used in I2C slave transmission and reception.
extern unsigned char status;	

extern unsigned char func_call(unsigned char a, unsigned char b, unsigned char c, unsigned char d, unsigned char e);

unsigned int bcd,wert,max=0,min=9999,e=0;
unsigned char ad_low, ad_high;


/* String Messages */
const char msg_text1[] = "LCD mit M30624F";
const char msg_text2[] = "by R.Inacker";

char msg_ad[] = "A/D-Wandlung";
char msg_scroll[] = "Mitsubishi LCD Demo";

void far main(void) {

        i2c_ram[0]=0xD0;
        i2c_ram[1]=0x83;
        init_sys();      /* Initalize System Clock   */
        init_i2c_bus();  /* Initalize i2c Bus        */
        asm("fset i");	
        asm("nop");
	write_eeprom_cmd();
	asm("nop");	
	delay_xs(2);
	asm("nop");	
        read_eeprom_cmd();     
     
        PD0=0xff;               /* Change port 0 to all outputs (LCD data) */
        PD1=0xff;               /* Change port 1 to all outputs (LCD control) */
        P0 =0;                  /* Initialize port 0. */
	P1 = 0;			/* Initialize port 1. */
	LCD_init();	   	/* Initialize LCD display */
	
        LCD_write( "Hello Reini" , 1 );
        delay_xs(2);

        LCD_write( "ABCDEFGHIJKLMNOP" , 1 );	/* output initial text to LCD line 1*/
	LCD_write( "QRSTUVWXYZabcdef" , 2 );	/* output initial text to LCD line 2*/
	LCD_write( "ghijklmnopqrstuv" , 3 );	/* output initial text to LCD line 3*/        
        LCD_write( "wxyz   123456789" , 4 );	/* output initial text to LCD line 4*/
        delay_xs(1);
        SendCmd(clr_dsp);
        delay_xms(100);
        LCDscr();
        LCD_scroll("  dlrow olleH  " ,2);
        delay_xs(1);        
        LCDinc();
        SendCmd(clr_dsp);	

        delay_xs(2);
        LCD_write("    Hello World " , 1 );	/* output initial text to LCD line 1*/
	LCD_write("----------------" , 2 );	/* output initial text to LCD line 2*/
	LCD_write("                " , 3 );	/* output initial text to LCD line 2*/
	LCD_write("           Reini" , 4 );	/* output initial text to LCD line 2*/
        delay_xs(2);
               
        SendCmd (clr_dsp);    
  
        Int0_ISR ();   


/*****************************************************************************
		MAIN PROGRAM LOOP
****************************************************************************/

	while(1){
		//if(int0_flag)			/* S2 pushed? */
		//{
//			asm("FCLR I");		/* disable interrupts */
			ADST = 1;		/* Start A2D conversion */
			while(ADST == 1);	/* wait for A/D conversion start bit to return to 0 */
			ad_value = AD0;		/* read value from A/D register */ 
                        wert=ad_value;
		        ad_low = AD0L;
                        ad_high = AD0H;
                        bcd=(wert/1000<<12)+(wert%1000/100<<8)+(wert%100/10<<4)+(wert%10);
                        if(bcd<=min)min = bcd;
                        if(bcd>=max)max=bcd;
                        L2homeLCD();
                        LCD_write( "Hex-Wert:" , 2 );
                        LCD_DisplayHex(ad_high);
                        LCD_DisplayHex(ad_low);
                        L3homeLCD();
                        LCD_write( "Dez-Wert:" ,3 );
                        Anzeige(bcd);
                        LCD_write("Min:     Max:",4);
                        SetCursor(0x54);
                        Anzeige(min);
                        SetCursor(0x5C);
                        Anzeige(max);
                          
                 //	asm("FSET I");		/* enable interrupts */
			delay_xs(1); 	  /* short delay */	
	        //	}
		
		if(ki0_flag)			/* S3 pushed? */
		{						
			clrLCD();			/* clear LCD */
			LCD_scroll( msg_scroll, 1 );
		}
		
		asm("NOP");
	}
}

/*****************************************************************************
		END OF MAIN PROGRAM
****************************************************************************/



void LCD_write (char *msg_string, int line )
{
	int i;

	switch(line)
            {
		case 1:
                        L1homeLCD();			    /* home display on line 1*/
                        break;
        	case 2:
                        L2homeLCD();			    /* home display on line 2*/
                        break;
	        case 3:
                        L3homeLCD();			    /* home display on line 3*/
                        break;
	        case 4:
                        L4homeLCD();			    /* home display on line 4*/
                        break;
                default:
                     L1homeLCD();			    /* home display on line 1*/
            }
	for (i=0; msg_string[i]; i++)
            {	/* This loop reads in the text string */
			SendChar(msg_string[i]);

             }

}

 /*****************************************************************************
Name:   LCD_scroll         
Parameters:                     
Returns:        
Description: This routine scrolls text on the LCD display   

*****************************************************************************/
void LCD_scroll (char *msg_string, int line )
{
	int i;

        switch(line)
            {
		case 1:
                        L2homeLCD();			    /* start at end of line 1*/
                        break;
        	case 2:
                        L1endLCD();			    /* start at end of line 2*/
                        break;
	        case 3:
                        L3homeLCD();			    /* start at end of line 3*/
                        break;
	        case 4:
                        L2endLCD();			    /* start at end of line 4*/
                        break;
                default:
                        L1endLCD();			    /* start at end of line 1*/
              }

                                           
	for (i=0; msg_string[i] ; i++)
              {	    /*&& ki0_flag war noch drin  This loop reads in the text string */
		SendChar(msg_string[i]);
		delay_xs(0.3);//for (wait=0x1FFF; wait>0; wait--);	/* scroll delay */	
               }
}

/*****************************************************************************
Name:   Key_ISR         
Parameters:  none                   
Returns:    none    
Description:  Interrupt routine for pushbuttons S3 & S4
			  S3 (KI0): This display a scrolling message
 			  S4 (KI1): This displays a japanese text message   

*****************************************************************************/
void Key_ISR (void )
{
	unsigned key;		  		/* Declare key pressed variable */
	unsigned debounce;			/* Declare debounce delay variable */

	key = P10;					/* read data on Port 10 */

	if ((P10.4 == 0) && (ki0_flag == 0)) { 	/* S3 pushed? */
		ki0_flag = 1;			/* set S3 flag */
		ki1_flag = 0;			/* clear other key indicators */
		int0_flag = 0;
		LCDscr();				/* enter LCD scroll mode */
	}
	else if (P10.5 == 0) {			/* S4 pushed? */
		ki1_flag = 1;				/* set S4 flag */
		ki0_flag = 0;				/* clear other key indicators */
		int0_flag = 0;
		clrLCD();					/* clear LCD display */
		LCDinc();					/* normal entry mode */
		//LCD_write( japanese1, 1 );	/* output text to LCD */
		//LCD_write( japanese2, 2 );	/* output text to LCD */
	}
	else
		asm("NOP");				/* error, return from interrupt */

	for (debounce=0xFF; debounce>0; debounce--);  /* debounce delay */	

}

/*****************************************************************************
Name:     Int0_ISR      
Parameters:   none                  
Returns:    none    
Description:  Interrupt routine for S2 (INT0)
			  This routine displays the a/d value of R11  

*****************************************************************************/
void Int0_ISR (void)
{
	unsigned debounce;			/* Declare debounce delay variable */

	/* ********* USE A/D FOR READING POT. VALUE ***********
	 Set up A/D register for AN0	 
	 - AN7 selected
	 - One shot mode
	 - Software trigger
	 - Frequency /4 
	 - 8 bit conversion
	 - Vref connected
	 - Sample & Hold  */

/*	ADCON0 = 0x00;
	ADCON1 = 0x20;		    
	ADCON2 = 0x01;*/
//        ADCON0 = 0x58;
        ADCON0 = 0x50;
	ADCON1 = 0x29;		    
	ADCON2 = 0x01;

	int0_flag = 1;			/* set S2 indicator */
	ki0_flag = 0;			/* clear other button indicators */
	ki1_flag = 0;
	clrLCD();				/* clear LCD */
	LCDinc();   			/* normal entry mode */
	LCD_write(msg_ad, 1);	/* output text to LCD */

	for (debounce=0xFF; debounce>0; debounce--);  /* debounce delay */	
}

/***************************************************************************/

void init_sys(void)
{
/* System clock initialization */
    PRCR = 0x01;        // Write enable sys clock
    CM0  = 0x00;        // Set system clock
    CM1  = 0x00;        // divide main clock by 16
    PRCR = 0x00;        // disable protect reg
}
/***************************************************************************/


/***************************************************************************/

void init_i2c_bus(void)		 // Initizes I2C slave functions 
{
	unsigned char *MEM;
	int i;
	 // MEM = &i2c_ram[0];
	 if( _iic_stop() == 0)
	 {		 /* Check fpr current use. kill bus intialize for start of new message */
	 	init_i2c_mas_func();
	 	_iic_ini(0x54, i2c_ram);	 // Intialize I2C device driver. 
	 
	 	MEM = &i2c_ram[0];
		
		for(i=0;i<128;i++)
		{
			*MEM++ = 0xff;		 /* zero out ram buffer. */ 
		}
	 }
 
}
/***************************************************************************/


void read_eeprom_cmd(void)
{

	while(check_i2c_bus_status(Set_flag))
	{   
		// Check if i2c bus is not busy and set the bus flag.
	} 
	
	i2c_ram[0] = 0x00;	// Start address
 	
 	//if(_iic_mw_start(0x01,&i2c_ram[0],0x50) != 0)// fr EEPROM
// 	if(_iic_mw_start(0x01,&i2c_ram[0],0x51) != 0)// fr RTC
	if(_iic_mw_start(0x0F,&i2c_ram[0],0x51) != 0)// fr RTC
	{											// 1st Argument: Designate data length sent by master
												// 2nd Argument: Designate leading address of where data are stored
												// 3rd Argument: Designate the address of the slave device
 	
		// For DEMO we do not provide any error checking. 
		if(Get_error_mass() != 0)
			asm("nop");
	}

	while(check_i2c_bus_status(0))
	{    
		// wait for read to be completed.   
	}
	
	// For DEMO we do not provide any error checking. 
	if(Get_error_mass() != 0)
	{
			asm("nop");
	}
	else
	{
	/* read  data */
		
		while(check_i2c_bus_status(Set_flag))
		{	 
			// Check if i2c bus is not busy and set the busy flag 
		}
		//if(_iic_mr_start(0x0F,&i2c_ram[0],0x50)!= 0) // fr EEPROM
		if(_iic_mr_start(0x0F,&i2c_ram[0],0x51)!= 0) //fr RTC
		{
			// For DEMO we do not provide any error checking. 
			if(Get_error_mass() != 0)
				asm("nop");
		}
		while(check_i2c_bus_status(0))
		{	 
			// wait for read to be completed.   
		}
		
		// For DEMO we do not provide any error checking. 
		if(Get_error_mass() != 0)		// Post process error checking 
		{
			asm("nop");
		}
		else
		{	
			asm("nop");
		}
	}
 
}

/***************************************************************************/

void write_eeprom_cmd(void)
{

       
    while(check_i2c_bus_status(Set_flag))
    {    
   	    // repeat until bus is finished 
   	}

	//if(_iic_mw_start(0x10,&i2c_ram[0],0x50)!= 0)// 1st Argument: Designate data length sent by master
	if(_iic_mw_start(0x02,&i2c_ram[0],0x51)!= 0)// 1st Argument: Designate data length sent by master	
	{						// 2nd Argument: Designate leading address of where data are stored
							// 3rd Argument: Designate the address of the slave device

		asm("nop");

		if(Get_error_mass() != 0)
					asm("nop");

	}																			
       
	while(check_i2c_bus_status(0))
	{    
		// wait for read to be completed.   
	}
    
    asm("nop");

}












