/*****************************************************************************
*
*	File Name:  lcd.c                                         
*                                                                  
*	Content:  LCD routines for 4x16 character display from GPO                
*                                                                  
*  	Date:  21-08-02
*                                                                  
*	Copyright 2002
*	by R.Inacker
*                                                                  
*=============================================================================
*	$Log:$
*===========================================================================*/
#include "Config.h"
#include "lcd.h"

#define TA3S TABSR.3
#define TA3OS ONSF.3
#define IR_TA3IC TA3IC.3



int timeout=0;

/*****************************************************************************
Name:    delay_1ms       
Parameters:                     
Returns:        
Description:   Routine that creates a 1ms delay 

*****************************************************************************/

void delay_1ms(void)                 
{
        TA3IC = 0x00;			/* make sure that the interrupt is not active */
	TA3MR = 0x82;			/* set for one shot timer mode */
	TA3 = 0x01F4;			/* 1 ms time delay */
     	TA3S = 1;			/* get ready */
        TA3OS = 1;			/* start it here */
        while (IR_TA3IC != 1);		/* wait for timer to run out */
	TA3S = 0;			/* stop the timer */
}

/*****************************************************************************
Name:    delay_xms    delay mit x-millisecound       
Parameters:           max. 131 ms          
Returns:        
Description:   Routine that creates a 1ms delay 

*****************************************************************************/

void delay_xms(long time)                 
{
        time = time * 500;              /* 1 Tick = 2 us*/            
        TA3IC = 0x00;			/* make sure that the interrupt is not active */
	TA3MR = 0x82;			/* set for one shot timer mode */
	TA3 = time;                     /* x ms time delay */
 	TA3S = 1;			/* get ready */
        TA3OS = 1;			/* start it here */
        while (IR_TA3IC != 1);		/* wait for timer to run out */
	TA3S = 0;			/* stop the timer */
}

void delay_xs(double second)                 
{        
        second=second*10;  
        while (second !=0)
                {delay_xms(100);
                 second--;
                }
}



/*****************************************************************************
Name:   LCD_init        
Parameters: none                    
Returns:   none     
Description:  LCD initialization routine

*****************************************************************************/

void LCD_init (void) 
{
	unsigned short i;

   	for (i=15; i>0; i--)
   		delay_1ms();  		/* startup delay 15mS */
   			
        lcd_out_dir=0xff;
        lcd_control = 0x00;             /*lsche RS + R/W */
        lcd_out= disp_mode;       
        ctr_enable();

        delay_xms(4);                   /* 4ms*/
        lcd_out= disp_mode;
        ctr_enable();
        delay_1ms();                    /* 100us*/
        lcd_out= disp_mode;
        ctr_enable();
        lcd_out= disp_mode;             /* set interface length and line*/
        ctr_enable();
        lcd_out= disp_off;              /* display off*/
        ctr_enable();
        lcd_out= clr_dsp;               /* clear display */
        ctr_enable();
        lcd_out= inc_entry;             /* display off*/
        ctr_enable();
/* ********busy is now avaible ***************/

	delay_1ms();
	SendCmd(disp_mode);		/* set display mode */
	delay_1ms();
	SendCmd(disp_mode);		/* set display mode */
	delay_1ms();
	SendCmd(disp_mode);		/* set display mode */
	delay_1ms();
	SendCmd(inc_entry);		/* set entry mode, increment on */
	delay_1ms();
        SendCmd(disp_b_on);		/* display on */
	delay_1ms();
	clrLCD();			/* clear LCD */
}

/******************************************************************
	SendChar - Sends character to LCD                               
******************************************************************/
void SendChar (unsigned char lcd_data)
{
        busycheck();
	lcd_out = lcd_data;	        /* put data on Port 0 */
	rs = 1;				/* Set for data */
	rw = 0;				/* write data */
	asm("NOP");			/* setup time */
	lcd_enable = 1;	 	        /* Clock data into LCD */
	asm("NOP");			/* enable cycle time */
	lcd_enable = 0;		        /* Latch data */
	delay_1ms();
}

/******************************************************************
	SendCmd - Sends command to LCD
******************************************************************/
void SendCmd (unsigned char lcd_data)
{
        busycheck(); 
        lcd_out = lcd_data;	        /* put data on Port 0 */
	rs = 0;	 			/* clear for command */
	rw = 0;				/* clear for command */
	asm("NOP");			/* setup time */
	lcd_enable = 1;	 	        /* Clock data into LCD */
	asm("NOP");			/* enable cycle time */
	lcd_enable = 0;		        /* Latch data */
	delay_1ms();
}

/******************************************************************
	clrLCD - Clear the contents of the LCD
******************************************************************/
void clrLCD (void)
{
	SendCmd(clr_dsp);		/* clear display */
	delay_1ms();
	delay_1ms();
}

/******************************************************************
	L1homeLCD - Moves the cursor to home position on Line 1         
******************************************************************/
void L1homeLCD (void)
{
	SendCmd(DD_RAM_AD10);	/* home position on line 1 */
	delay_1ms();
}

/******************************************************************
	L2homeLCD - Moves the cursor to home position on Line 2 
******************************************************************/
void L2homeLCD (void)
{
	SendCmd(DD_RAM_AD20);	/* home position on line 2 */
	delay_1ms();
}

/******************************************************************
	L3homeLCD - Moves the cursor to home position on Line 3         
******************************************************************/
void L3homeLCD (void)
{
	SendCmd(DD_RAM_AD30);	/* home position on line 3 */
	delay_1ms();
}

/******************************************************************
	L4homeLCD - Moves the cursor to home position on Line 4         
******************************************************************/
void L4homeLCD (void)
{
	SendCmd(DD_RAM_AD40);	/* home position on line 1 */
	delay_1ms();
}

/******************************************************************
	L1endLCD - Moves the cursor to end of Line 1         
******************************************************************/
void L1endLCD (void)
{
	SendCmd(DD_RAM_AD1E);	/* last address of line 1 */
	delay_1ms();
}

/******************************************************************
	L2endLCD - Moves the cursor to end of Line 2         
******************************************************************/
void L2endLCD (void)
{
	SendCmd(DD_RAM_AD2E);	/* last address of line 2 */
	delay_1ms();
}

/******************************************************************
	L3endLCD - Moves the cursor to end of Line 3         
******************************************************************/
void L3endLCD (void)
{
	SendCmd(DD_RAM_AD3E);	/* last address of line 3 */
	delay_1ms();
}

/******************************************************************
	L4endLCD - Moves the cursor to end of Line 4         
******************************************************************/
void L4endLCD (void)
{
	SendCmd(DD_RAM_AD4E);	  /* last address of line 4 */
	delay_1ms();
}

/******************************************************************
	LCD_entry - Puts the LCD in normal increment entry mode 
******************************************************************/
void LCDinc (void) 
{
	SendCmd(inc_entry);	  /* set entry mode, increment on */
	delay_1ms();
}

/******************************************************************
	LCD_scroll - Puts the LCD in scroll entry mode 
******************************************************************/
void LCDscr (void)
{
	SendCmd(scr_entry);
	delay_1ms();
}

/******************************************************************
	set enable-signal 
******************************************************************/
void ctr_enable (void)
{
        lcd_enable = 1;
       	asm("NOP");	            /* setup time           */
        lcd_enable = 0;
}

void busycheck(void)
{

        lcd_out_dir= 0x00;          /* Datenport auf Eingang*/
        rs = 0;                     /* setzt D/I            */
        rs =1;                      /* setzt R/W            */
	timeout = 0;
        asm("NOP");			/* setup time       */
        asm("NOP");			/* setup time       */
        while (busy == 1){
                        timeout = timeout +1;
                        delay_1ms();
                        if (timeout ==5000) break;
                        }
        
        lcd_out_dir= 0xFF;          /* Datenport auf Ausgang*/
}

void SetCursor(unsigned char lcd_data)
{

        lcd_data =lcd_data + 0x80;
	SendCmd(lcd_data);
	delay_1ms();
}