/*****************************************************************************
*
*	File Name:  lcd.h                                         
*                                                                  
*	Content:  LCD header 4 x 16 LCD module von GPO
*
*  	Date:  26-07-02
*                                                                  
*	Copyright 2000 Mitsubishi Electric & Electronics US                           
*	All rights reserved                                            
*                                                                  
*=============================================================================
*	$Log:$
*===========================================================================*/


/********************************************************
	declare LCD connections				
********************************************************/
#ifndef __LCD_H
#define __LCD_H

#define		rs		P1.5   	/* LCD register select */
#define		rw		P1.6   	/* LCD read/write pin */
#define		lcd_enable 	P1.7   	/* LCD enable pin */
#define		lcd_control	P1   	/* LCD control output */
#define		lcd_out		P0   	/* LCD data output */
#define         lcd_out_dir     P0D     /* LCD data port direction*/
#define		busy  		P0.7   	/* busy flag */
/********************************************************
	declare LCD instructions				
********************************************************/

#define		clr_dsp	 	0x01	/* clear display */
#define 	disp_on	 	0x0C	/* Display on */
#define 	disp_c_on	0x0E	/* Display on, Cursor on */
#define 	disp_b_on	0x0F	/* Display on, Cursor on, Blink cursor */
#define 	disp_off 	0x08	/* Display off */
#define		disp_mode	0x38	/* 8 bit, 2 line, 5x7 mode */
#define		inc_entry	0x06	/* increment entry mode */
#define		scr_entry	0x05	/* scroll entry mode */	
/*defines for 4x20 display
#define 	DD_RAM_AD10	0x80	// Line 1 home 		
#define		DD_RAM_AD20	0xC0	// Line 2 home 
#define 	DD_RAM_AD30	0x94	// Line 3 home 		
#define		DD_RAM_AD40	0xD4	// Line 4 home 
#define 	DD_RAM_AD1E	0x91	// End of line 1 
#define 	DD_RAM_AD2E	0xD1	// End of line 2 
#define 	DD_RAM_AD3E	0xA5	// End of line 3 
#define 	DD_RAM_AD4E	0xE5	// End of line 4 
*/
//defines for 4x16 display
#define 	DD_RAM_AD10	0x80	// Line 1 home 		
#define		DD_RAM_AD20	0xC0	// Line 2 home 
#define 	DD_RAM_AD30	0x90	// Line 3 home 		
#define		DD_RAM_AD40	0xD0	// Line 4 home 
#define 	DD_RAM_AD1E	0x8F	// End of line 1 
#define 	DD_RAM_AD2E	0xCF	// End of line 2 
#define 	DD_RAM_AD3E	0x9F	// End of line 3 
#define 	DD_RAM_AD4E	0xDF	// End of line 4 


/********************************************************
	function prototypes				
********************************************************/
 
extern void delay_1ms(void);
extern void delay_xms(long time);
extern void delay_xs(double second);                   
extern void LCD_init(void);
extern void SendChar(unsigned char);
extern void SendCmd(unsigned char);
extern void clrLCD(void);
extern void L1homeLCD(void);
extern void L2homeLCD(void);
extern void L3homeLCD(void);
extern void L4homeLCD(void);
extern void L1endLCD(void);
extern void L2endLCD(void);
extern void L3endLCD(void);
extern void L4endLCD(void);
extern void LCDinc(void);
extern void LCDscr(void);
extern void ctr_enable (void);
extern void busycheck(void);
extern void SetCursor(unsigned char);
#endif