/* Definitions for the Densitron PC-6749 LCD glass (Pollin 120818)
 * this is a 3-digit 16-segment LC display controlled by a HT1621
 *
 *   glass segment mapping
 * from the display datasheet  |  and how we use it
 *
 * ---------------------------
 *      | COM0 COM1 COM2 COM3
 * -----+---------------------
 * SEG0 | 1G   1K   1F   1E    \ lcd_buf[0] bit 0  1  2  3
 * SEG1 | 1H   1L   1N   1D    /                4  5  6  7
 *
 * SEG2 | 1I   1M   1O   1P    \ lcd_buf[1] bit 0  1  2  3
 * SEG3 | 1A   1J   1B   1C    /                4  5  6  7
 *
 * SEG4 |       X    Y    Z    \ lcd_buf[2] bit 0  1  2  3
 * SEG5 | 2G   2K   2F   2E    /                4  5  6  7
 *
 * SEG6 | 2H   2L   2N   2D    \ lcd_buf[3] bit 0  1  2  3
 * SEG7 | 2I   2M   2O   2P    /                4  5  6  7
 *
 * SEG8 | 2A   2J   2B   2C    \ lcd_buf[4] bit 0  1  2  3
 * SEG9 | 3G   3K   3F   3E    /                4  5  6  7
 *
 * SEG10| 3H   3L   3N   3D    \ lcd_buf[5] bit 0  1  2  3
 * SEG11| 3I   3M   3O   3P    /                4  5  6  7
 *
 * SEG12| 3A   3K   3B   3C    } lcd_buf[6] bit 0  1  2  3
 * ---------------------------
 */

/*
 * segment mapping table [digit][segment]
 * entry is lcd_buf address in high nibble
 * and bit number in low nibble
 */
const uint8_t __flash segmap[3][16]=
{
    { 0x14, 0x16, 0x17, 0x07, 0x03, 0x02, 0x00, 0x04,
      0x10, 0x15, 0x01, 0x05, 0x11, 0x06, 0x12, 0x13 },
    { 0x40, 0x42, 0x43, 0x33, 0x27, 0x26, 0x24, 0x30,
      0x34, 0x41, 0x25, 0x31, 0x35, 0x32, 0x36, 0x37 },
    { 0x60, 0x62, 0x63, 0x53, 0x47, 0x46, 0x44, 0x50,
      0x54, 0x61, 0x45, 0x51, 0x55, 0x52, 0x56, 0x57 }
};

