/*
 * Driving HT1621 based LCD Densitron PC-6749 from Arduino nano
 *
 * ports.h - hardware definition
 *
 * $Id: ports.h 130 2011-08-08 19:01:55Z schwenke $
 */

#ifndef PORTS_H
#define PORTS_H

/*

ATmega328      Arduino         LCD
GND............GND.............GND  (1)
Vcc............+5V.............Vcc  (2)
PD4............D4..............WCLK (3)
PD3............D3..............DATA (4)
PD2............D2..............CS   (5)

*/

#define CS_low()   PORTD &= ~(1<<2); _delay_us(1)
#define CS_high()  _delay_us(1); PORTD |= (1<<2);
#define DATA(x)    if ((x)==0) PORTD &= ~(1<<3); else PORTD |= (1<<3)
#define WR_pulse() PORTD &= ~(1<<4); _delay_us(3); PORTD |= (1<<4); _delay_us(3)
#define LED_on()   PORTB |= 0x20;
#define LED_off()  PORTB &= ~0x20;

#endif
