/*
 * font for 16-segment display
 * it is sparse, hence organized as list
 */

const struct {
    char c;     /* the character */
    uint16_t s; /* 16 bits for segments A..P */
} __flash seg16font[]=
{         /* ABCDEFGHIJKLMNOP */
    { '1', 0b0110000001000000 },
    { '2', 0b1101110000111000 },
    { '3', 0b1111100000111000 },
    { '4', 0b0000001010111010 },
    { '5', 0b1011101000111000 },
    { '6', 0b1011111000111000 },
    { '7', 0b1000000001111010 },
    { '8', 0b1111111000111000 },
    { '9', 0b1111101000111000 },
    { '0', 0b1111111001010100 },
    { '+', 0b0000000010111010 },
    { '-', 0b0000000000111000 },
    { '*', 0b0000000111111111 },
    { '/', 0b0000000001010100 },
    { '.', 0b0000100000000000 },
    { '(', 0b0000000001000001 },
    { '$', 0b1011101010111010 },
    { ')', 0b0000000100000100 },
    { 'A', 0b1110011000111000 },
    { 'B', 0b1111100010011010 },
    { 'C', 0b1001111000000000 },
    { 'D', 0b1111100010010010 },
    { 'E', 0b1001111000110000 },
    { 'F', 0b1000011000110000 },
    { 'G', 0b1011111000001000 },
    { 'H', 0b0110011000111000 },
    { 'I', 0b1001100010010010 },
    { 'J', 0b1000100010010010 },
    { 'K', 0b0000000011010011 },
    { 'L', 0b0001111000000000 },
    { 'M', 0b0110011101010000 },
    { 'N', 0b0110011100010001 },
    { 'O', 0b1111111000000000 },
    { 'P', 0b1100011000111000 },
    { 'Q', 0b1111111000000001 },
    { 'R', 0b1100011000110001 },
    { 'S', 0b1011101000111000 },
    { 'T', 0b1000000010010010 },
    { 'U', 0b0111111000000000 },
    { 'V', 0b0000011001010100 },
    { 'W', 0b0110011000010101 },
    { 'X', 0b0000000101010101 },
    { 'Y', 0b0000000101010010 },
    { 'Z', 0b1001100001010100 },
    { '{', 0b0000000001011001 },
    { '_', 0b0001100000000000 },
    { '}', 0b0000000100110100 },
    { 'b', 0b0011111000111000 },
    { 'c', 0b0001110000111000 },
    { 'd', 0b0111110000111000 },
    { 'h', 0b0010011000111000 },
    { 'l', 0b0000111000000000 },
    { 'm', 0b0010010000101010 },
    { 'n', 0b0010010000111000 },
    { 'o', 0b0011110000111000 },
    { 'r', 0b0000010000110000 },
    { 't', 0b0001000010111010 },
    { 'u', 0b0011110000000000 },
    { 'v', 0b0000010000000100 },
    { 'w', 0b0010010000000101 },
    { '[', 0b1001111000000000 },
    { '|', 0b0000000010010010 },
    { ']', 0b1111100000000000 },
    { ' ', 0b0000000000000000 },
          /* ABCDEFGHIJKLMNOP */
    { 0, 0xFFFF }
};


/*
 * search character in font, return segments
 * nonexisting character yields empty pattern
 */
uint16_t char2seg(char c)
{
    for (uint8_t j=0; seg16font[j].c; j++) {
        if (seg16font[j].c == c) {
            return seg16font[j].s;
        }
    }
    return 0;
}

