; ##############################################################################
; ##############################################################################
; ##############################################################################
; INITIALISIERUNG																
;																				
ONE_WIRE_INITIALISIERUNG:
	; DATENBUS											
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; PULL-UP ein	
	rcall WAIT_10ms
	; STRONG_PULLUP aus									
	sbi (ONE_WIRE_STRONG_PULLUP_DDR) ,(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF AUSGANG	
	sbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF HIGH		
	; DATENBUS-RESET (100ms LOW)						
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; LOW			
	rcall WAIT_100ms
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; PULL-UP ein	
	rcall WAIT_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; GELB blinkt wenn BUS LOW ist													
ONE_WIRE_BUS_CHECK_PROGRAMMSTART:
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip if..."
	ret
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an	
	rcall WAIT_100ms
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR		; GELB aus	
	rcall WAIT_100ms
	rjmp ONE_WIRE_BUS_CHECK_PROGRAMMSTART	; SCHLEIFE	
; ##############################################################################
; ##############################################################################
; ##############################################################################
; GELB leuchtet, wenn Kurzschluss auf BUS										
ONE_WIRE_BUS_CHECK:
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus	
	ldi temp,255
ONE_WIRE_BUS_CHECK_s:
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip if..."
	ret
	sbis (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR) 	; "skip if..."
	ret
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an	
	rcall wait_1ms
	dec temp
	brne ONE_WIRE_BUS_CHECK_s
; ------------------------------------------------------------------------------
	; ERROR					
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; PULL-UP ein	
	sbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF HIGH		
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	ldi temp,(ERROR_OW_BUS)
	STS(adr_ERROR_CODE),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; OUT: CARRY	0=ERROR 1=OK													
;																				
ONE_WIRE_RESET_PRESENCE_C:
	; vorsichtshalber STRONG_PULLUP aus		
	sbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF HIGH
	WDR
; ------------------------------------------------------------------------------
	; PIN schon auf HIGH ?					
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN LOW"
	rjmp ONE_WIRE_RESET_PRESENCE_C_RUN
; ------------------------------------------------------------------------------
	; PIN auf EINGANG + HIGH				
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	NOP										; etwas warten	
	NOP
	NOP
	NOP
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	rcall WAIT_10ms							; PAUSE 		
	; PIN HIGH ? Wenn LOW, dann ERROR		
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
; ------------------------------------------------------------------------------
ONE_WIRE_RESET_PRESENCE_C_RUN:
	; PIN auf AUSGANG und LOW				
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF LOW		
	rcall WAIT_500us						; PAUSE 500ms	
	; PIN auf EINGANG + HIGH				
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	NOP										; etwas warten	
	NOP
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	NOP										; etwas warten	
	NOP
	; PIN HIGH ? Wenn LOW, dann ERROR		
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
	rcall WAIT_50us							; Pause 50s 			
	; SAMPLES - Wenn HIGH, dann ERROR		
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN LOW"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
; ------------------------------------------------------------------------------
	; PRESENCE-IMPULS abwarten, bis PIN wieder HIGH ist		
ONE_WIRE_RESET_PRESENCE_C_S1:
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_S1
; ------------------------------------------------------------------------------
	; Verbesserung der Flankensteilheit		
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	rcall WAIT_100us						; PAUSE		
	SEC										; CARRY=1	
	ret
; ------------------------------------------------------------------------------
ONE_WIRE_RESET_PRESENCE_C_ERROR:
	; ERROR									
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	ldi temp,(ERROR_RESET_PRESENCE)
	STS(adr_ERROR_CODE),temp
	rcall WAIT_100us						; PAUSE 10us
	CLC										; CARRY=0	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 1 DATENBYTE 1-wire schreiben													
;																				
; inp: temp1																	
;																				
ONE_WIRE_BYTE_WRITE_TEMP1:
	LSR temp1						; 1x rechts 1 rollt raus (LSB)
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-0 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-1 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-2 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-3 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-4 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-5 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-6 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus (MSB)
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-7 schreiben			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; DATEN-BIT schreiben															
;																				
; Hier kommt es auf Zeiten an, stimmen die Zeiten nicht, werden die BITs vom	
; MASTER an den SLAVE nicht genau gelesen ! (ggf. mit OSZI prfen)				
;																				
; INP: CARRY																	
;																				
ONE_WIRE_BIT_WRITE_C:
	; CARRY auswerten													
	brcs ONE_WIRE_DATA_WRITE_BIT_HIGH		; wenn CARRY=1 dann HIGH	
	; "0" SLOT 60s (LOW-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG				
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	; mind. 10s (HIGH-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
;	cbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF EINGANG				
	cbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF LOW
	rcall WAIT_10us							; PAUSE 					
ret
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_WRITE_BIT_HIGH:
	; "1" SLOT 5s (LOW-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG				
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL					
	rcall WAIT_5us							; PAUSE						
	; mind. 64s (HIGH-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
;	cbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF EINGANG				
	cbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF LOW
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 1 DATENBYTE 1-wire lesen														
;																				
; out: temp1																	
;																				
ONE_WIRE_BYTE_READ_TEMP1:
	clr temp1
	rcall ONE_WIRE_BIT_READ_C		; LSB					
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ein BIT vom SLAVE einlesen													
;																				
; Hier kommt es auf Zeiten an, stimmen die Zeiten nicht, werden die BITs vom	
; MASTER an den SLAVE nicht genau gelesen ! (ggf. mit OSZI prfen)				
;																				
; OUT: CARRY																	
;																				
ONE_WIRE_BIT_READ_C:
	; vorsichtshalber STRONG_PULLUP aus		
	sbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF HIGH
	; kurzer LOW-IMPULS 1...5s									
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL		
	; diese Pause ist kritisch, hier ggf. nachbessern		
	rcall WAIT_5us					; 5s PAUSE				
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	; diese Pause ist kritisch, hier ggf. nachbessern		
	rcall WAIT_10us							; ca 10s warten
	; MASTER SAMPLES			
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip if..."
	rjmp ONE_WIRE_DATA_READ_1_SLOT
	rjmp ONE_WIRE_DATA_READ_0_SLOT
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_READ_0_SLOT:
	rcall WAIT_100us						; warten		
	CLC										; CARRY clear	
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_READ_1_SLOT:
	rcall WAIT_100us						; warten		
	SEC										; CARRY setzen	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
