; ##############################################################################
; ##############################################################################
; ##############################################################################
AUSWERTUNG:
	; X-ZEIGER (Empfangspuffer)	
	ldi XL,LOW (adr_BUFFER_RX256)	 
	ldi XH,HIGH(adr_BUFFER_RX256)
; ------------------------------------------------------------------------------
AUSWERTUNG_s:
	WDR						; WDR							
	; STRONG_PULLUP (TRANSISTOR)
	sbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF HIGH		
	; Z-ZEIGER (Sendepuffer)	
	ldi ZL,LOW (adr_BUFFER_TX512)
	ldi ZH,HIGH(adr_BUFFER_TX512)
	; Sendepuffer clear			
	STS(adr_BUFFER_TX512+0),NULL
	STS(adr_BUFFER_TX512+1),NULL
	STS(adr_BUFFER_TX512+2),NULL
	STS(adr_BUFFER_TX512+3),NULL
	STS(adr_BUFFER_TX512+4),NULL
	STS(adr_BUFFER_TX512+5),NULL
	STS(adr_BUFFER_TX512+6),NULL
	STS(adr_BUFFER_TX512+7),NULL
	STS(adr_BUFFER_TX512+8),NULL
	STS(adr_BUFFER_TX512+9),NULL
	; KOMMANDO				
	LD temp1,X				; Empfangspuffer auslesen		
	ST X+,NULL				; Empfangspuffer NULL (X+1)		
	; INTERFACE-RESET		
	cpi temp1,(OW_INTERFACE_RESET)
	brne PC+2
	rjmp AUSWERTUNG_INTERFACE_RESET
	; ERROR_CODE			
	cpi temp1,(OW_ERROR_CODE)
	brne PC+2
	rjmp AUSWERTUNG_ERROR_CODE
	; VERBINDUNGSTEST		
	cpi temp1,(OW_VERBINDUNGSTEST)
	brne PC+2
	rjmp AUSWERTUNG_VERBINDUNGSTEST_TEMP1
	; PEGEL-TEST			
	cpi temp1,(OW_BUS_PEGEL_TEST)
	brne PC+2
	rjmp AUSWERTUNG_BUS_PEGEL_TEST
	; PIN auf LOW ziehen	
	cpi temp1,(OW_BUS_LOW)
	brne PC+2
	rjmp AUSWERTUNG_BUS_LOW
	; STRONG-PULLUP (VOLL POWER auf BUS)
	cpi temp1,(OW_STRONG_PULLUP_ON)
	brne PC+2
	rjmp AUSWERTUNG_STRONG_PULLUP_ON
	; RESET-PRESENCE (RP)		
	cpi temp1,(OW_RESET_PRESENCE)
	brne PC+2
	rjmp AUSWERTUNG_RESET_PRESENCE
	; ROM_SEARCH				
	cpi temp1,(OW_ROM_SEARCH)
	brne PC+2
	rjmp AUSWERTUNG_ROM_SEARCH
	; (RESET-PRESENCE)+(SKIP-ROM)+(CONVERT "T")+(PAUSE)		
	cpi temp1,(OW_RP_SR_CONVERT)
	brne PC+2
	rjmp AUSWERTUNG_OW_RP_SR_CONVERT
	; RP + 1BYTES WRITE			
	cpi temp1,(OW_RP_BYTES1_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_RP_1BYTES_WRITE
	; RP + 2BYTES WRITE			
	cpi temp1,(OW_RP_BYTES2_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_RP_2BYTES_WRITE
	; RP + 9BYTES WRITE			
	cpi temp1,(OW_RP_BYTES9_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_RP_9BYTES_WRITE
	; RP + 10BYTES WRITE			
	cpi temp1,(OW_RP_BYTES10_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_RP_10BYTES_WRITE
	; WRITE-BYTE			
	cpi temp1,(OW_BYTES_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_WRITE_BYTE
	; READ-1-BYTE			
	cpi temp1,(OW_BYTES_READ)
	brne PC+2
	rjmp AUSWERTUNG_READ_1BYTES
	; READ-8-BYTES			
	cpi temp1,(OW_BYTES_READ8)
	brne PC+2
	rjmp AUSWERTUNG_READ_8BYTES
	; READ-9-BYTES			
	cpi temp1,(OW_BYTES_READ9)
	brne PC+2
	rjmp AUSWERTUNG_READ_9BYTES
	; BIT-WRITE				
	cpi temp1,(OW_BIT_WRITE)
	brne PC+2
	rjmp AUSWERTUNG_BIT_WRITE
	; BIT-READ				
	cpi temp1,(OW_BIT_READ)
	brne PC+2
	rjmp AUSWERTUNG_BIT_READ
	; 2xBIT-READ			
	cpi temp1,(OW_BIT_READ2)
	brne PC+2
	rjmp AUSWERTUNG_2BIT_READ
	; WAIT					
	cpi temp1,(OW_WAIT)
	brne PC+2
	rjmp AUSWERTUNG_WAIT
	; DUMMY					
	cpi temp1,(OW_DUMMY)
	brne PC+2
	rjmp AUSWERTUNG_FERTIG
	; ERROR					
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rcall BUFFER_TX_CLEAR
	rcall BUFFER_RX_CLEAR
	ldi temp,(ERROR_KOMMANDO)
	STS(adr_ERROR_CODE),temp
	ret
; ------------------------------------------------------------------------------
; VERBINDUNGSTEST																
AUSWERTUNG_VERBINDUNGSTEST_TEMP1:
	rcall AUSWERTUNG_AUSGABE_TEMP1
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; ERROR-CODE auslesen															
AUSWERTUNG_ERROR_CODE:
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	LDS temp1,(adr_ERROR_CODE)
	STS(adr_ERROR_CODE),NULL
	rcall AUSWERTUNG_AUSGABE_TEMP1
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RESET-INTERFACE																
AUSWERTUNG_INTERFACE_RESET:
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rjmp AUSWERTUNG_INTERFACE_RESET			; SCHLEIFE bis WDR zubeit	
; ------------------------------------------------------------------------------
; BUS auf GND																	
AUSWERTUNG_BUS_LOW:
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF LOW		
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; STRONG_PULLUP (VOLL POWER auf BUS)											
AUSWERTUNG_STRONG_PULLUP_ON:
	cbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF HIGH		
	rcall WAIT_1ms	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF HIGH		
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_STRONG_PULLUP_PORT),(ONE_WIRE_STRONG_PULLUP_PIN_NR)	; AUF LOW
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; WAIT																			
AUSWERTUNG_WAIT:
	rcall WAIT_100us
	rcall WAIT_100us
	rcall WAIT_100us
	rcall WAIT_100us
	rcall WAIT_100us
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RESET-PRESENCE																
AUSWERTUNG_RESET_PRESENCE:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_RESET_PRESENCE_ERROR
	ldi temp1,0x50	; OK	
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG	
AUSWERTUNG_RESET_PRESENCE_ERROR:
	ldi temp1,255	; ERROR	
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; (RESET-PRESENCE)+(SKIP-ROM)+(CONVERT "T")+PAUSE		
AUSWERTUNG_OW_RP_SR_CONVERT:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_OW_RP_SR_CONVERT_ERROR
	ldi	temp1,0xCC					; SKIP_ROM						
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	ldi	temp1,0x44					; CONVERT "T"					
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	rcall WAIT_1s					; 1s PAUSE						
AUSWERTUNG_OW_RP_SR_CONVERT_ERROR:
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; BUS_PEGEL_TEST																
AUSWERTUNG_BUS_PEGEL_TEST:
	; SAMPLES-PIN abfragen			
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR)	; "skip wenn PIN LOW"
	rjmp AUSWERTUNG_BUS_PEGEL_HIGH
AUSWERTUNG_BUS_PEGEL_LOW:
	ldi temp1,0	; 0 zurcksenden	
	rcall AUSWERTUNG_AUSGABE_TEMP1 	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
AUSWERTUNG_BUS_PEGEL_HIGH:
	ldi temp1,1	; 1 zurcksenden	
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; OW-BYTE WRITE																	
AUSWERTUNG_WRITE_BYTE:
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden			
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
AUSWERTUNG_READ_9BYTES:		; READ 9 BYTES	
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_8BYTES:		; READ 8 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_7BYTES:		; READ 7 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_6BYTES:		; READ 6 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_5BYTES:		; READ 5 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_4BYTES:		; READ 4 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_3BYTES:		; READ 3 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_2BYTES:		; READ 2 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
AUSWERTUNG_READ_1BYTES:		; READ 1 BYTES
	rcall ONE_WIRE_BYTE_READ_TEMP1		; OUT: temp1			
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; BIT WRITE																		
AUSWERTUNG_BIT_WRITE:
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	LSR temp1						; 1xrechts C rollt raus	
	rcall ONE_WIRE_BIT_WRITE_C		; INP: Carry			
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; BIT_READ																		
AUSWERTUNG_BIT_READ:
	rcall ONE_WIRE_BIT_READ_C		; OUT: CARRY
	clr temp1
	ROL temp1 						; logisch links ber Carry
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; 2x BIT_READ																	
AUSWERTUNG_2BIT_READ:
	clr temp1
	rcall ONE_WIRE_BIT_READ_C		; OUT: CARRY				
	ROR temp1  							; logisch rechts ber Carry	
	rcall ONE_WIRE_BIT_READ_C		; OUT: CARRY				
	ROR temp1  							; logisch rechts ber Carry	
	LSR temp1							; 6x logisch rechts			
	LSR temp1
	LSR temp1
	LSR temp1
	LSR temp1
	LSR temp1
	rcall AUSWERTUNG_AUSGABE_TEMP1	; AUSGABE	
	rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RP + 1 BYTES WRITE															
AUSWERTUNG_RP_1BYTES_WRITE:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_RP_1BYTES_WRITE_ERROR
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	rjmp AUSWERTUNG_FERTIG
AUSWERTUNG_RP_1BYTES_WRITE_ERROR:
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RP + 2 BYTES WRITE															
AUSWERTUNG_RP_2BYTES_WRITE:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_RP_2BYTES_WRITE_ERROR
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	LD temp1,X						
	ST X+,NULL						
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	rjmp AUSWERTUNG_FERTIG
AUSWERTUNG_RP_2BYTES_WRITE_ERROR:
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RP + 9 BYTES WRITE															
AUSWERTUNG_RP_9BYTES_WRITE:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_RP_9BYTES_WRITE_ERROR
	ldi temp9,9						; SCHLEIFE
AUSWERTUNG_RP_9BYTES_WRITE_s:
	push temp9
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	pop temp9
	dec temp9
	brne AUSWERTUNG_RP_9BYTES_WRITE_s
	rjmp AUSWERTUNG_FERTIG
AUSWERTUNG_RP_9BYTES_WRITE_ERROR:
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; RP + 10 BYTES WRITE															
AUSWERTUNG_RP_10BYTES_WRITE:
	rcall ONE_WIRE_RESET_PRESENCE_C
	brcc AUSWERTUNG_RP_10BYTES_WRITE_ERROR
	ldi temp9,10					; SCHLEIFE
AUSWERTUNG_RP_10BYTES_WRITE_s:
	push temp9
	LD temp1,X						; Empfangspuffer auslesen		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1	; 1-WIRE senden					
	pop temp9
	dec temp9
	brne AUSWERTUNG_RP_10BYTES_WRITE_s
	rjmp AUSWERTUNG_FERTIG
AUSWERTUNG_RP_10BYTES_WRITE_ERROR:
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
	ST X+,NULL						; Empfangspuffer NULL (X+1)		
rjmp AUSWERTUNG_FERTIG
; ------------------------------------------------------------------------------
; ROM-SEARCH (ROM-IDs sind im BUFFER_TX abgelegt)								
AUSWERTUNG_ROM_SEARCH:
	rcall ROM_SEARCH
; ------------------------------------------------------------------------------
	; USART ?					
	LDS temp,(adr_USART_AKTIV)
	tst temp
	brne AUSWERTUNG_ROM_SEARCH_USART
	rjmp AUSWERTUNG_FERTIG_ENDE
AUSWERTUNG_ROM_SEARCH_USART:
	; Z-ZEIGER (Sendepuffer)	
	ldi ZL,LOW (adr_BUFFER_TX512)
	ldi ZH,HIGH(adr_BUFFER_TX512)
	LD temp1,Z+						; ANZAHL gefundener SLAVES		
	tst temp1
	brne AUSWERTUNG_ROM_SEARCH_USART_RUN
	rjmp AUSWERTUNG_FERTIG_ENDE
AUSWERTUNG_ROM_SEARCH_USART_RUN:
	rcall BYTE_SENDEN_TEMP1			; 1 BYTE per RS232 zurcksenden	
	mov temp9,temp1					; SCHLEIFE						
AUSWERTUNG_ROM_SEARCH_USART_s:
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	LD temp1,Z+						; ROM-ID						
	rcall BYTE_SENDEN_TEMP1	
	dec temp9
	brne AUSWERTUNG_ROM_SEARCH_USART_s

rjmp AUSWERTUNG_FERTIG_ENDE
; ##############################################################################
; ##############################################################################
; ##############################################################################
AUSWERTUNG_AUSGABE_TEMP1:
	; BUFFER_TX write			
	ST Z+,temp1
; ------------------------------------------------------------------------------
	; USART ?					
	LDS temp,(adr_USART_AKTIV)
	tst temp
	breq AUSWERTUNG_AUSGABE_TEMP1_NO_USART
	rcall BYTE_SENDEN_TEMP1			; 1 BYTE per RS232 zurcksenden	
AUSWERTUNG_AUSGABE_TEMP1_NO_USART:
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
AUSWERTUNG_FERTIG:
	LD temp,X						; Empfangspuffer auslesen
	tst temp
	breq AUSWERTUNG_FERTIG_ENDE
	rjmp AUSWERTUNG_s
; ------------------------------------------------------------------------------
AUSWERTUNG_FERTIG_ENDE:
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################











