;																
; TWI/I2C-1WIRE INTERFACE fr ATmega8							
; Bernhard.Erfurt@gmx.de										
; 12/2015														
;																

;																
; TASTE:Es wird ROM-SEARCH gestartet,leuchtet ROT nicht alles OK
;																

;																
; GELB blinkt nach Programmstart: 1-WIRE-BUS-KURZSCHLUSS 		
;																
; GRN leuchtet: TWI/USART/1-WIRE Aktivitten					
; GELB leuchtet: 1-WIRE-BUS-PROBLEME							
; ROT  leuchtet: ERROR											
;																
; Blinken die LEDs, das ist nicht gut !							
; ROT blinkt: 			 Fehler im Programmcheck				
; ROT+GELB+GRN blinken: unkorrekter Interruptaufruf			
;																

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> TASTE (ROM-SEARCH)					
; PB1 ==> 										
; PB2 ==> 										
; PB3 ==> 										
; PB4 ==> 										
; PB5 ==> 										
; PB6 ==> (Quarz bei Bedarf)					
; PB7 ==> (Quarz bei Bedarf)					
;												
; PC0 ==> 										
; PC1 ==> 										
; PC2 ==> 										
; PC3 ==> 										
; PC4 ==> TWI-SDA								
; PC5 ==> TWI-SCL								
;												
; PD0 ==> USART-RX								
; PD1 ==> USART-TX								
; PD2 ==> 1WIRE-BUS								
; PD3 ==> 										
; PD4 ==> FET/TRANSISTOR						
; PD5 ==> LED GRN								
; PD6 ==> LED GELB								
; PD7 ==> LED ROT								
;												


; ATmega8 										
.include "m8def.inc"
; KONSTANTEN									
.equ TAKT						= 1000000		; 1 MHz	
; USART											
.equ BAUD						= 4800
; TWI-SLAVE-ADRESSE								
.equ TWI_SLAVE_ADRESSE			= 60
; TWI-GENERAL-CALL								
.equ TWI_GENERAL_CALL_ENABLE	= 0				; 0/1	
; KOMMANDOS										
.equ OW_DUMMY					= 0x00			; NIX												
.equ OW_WAIT					= 0x02			; PAUSE (500s)										
.equ OW_INTERFACE_RESET			= 0x04			; INTERFACE-RESET									
.equ OW_ERROR_CODE				= 0x03			; FEHLERCODE_AUSLESEN//Antwort: 0x00 (no ERROR)		
.equ OW_VERBINDUNGSTEST			= 0x06			; VERBINDUNGSTEST 	// Antwort: 0x06				
.equ OW_BUS_PEGEL_TEST			= 0x08			; PEGEL-TEST 		// Antwort: 0x00 / 0x01			

.equ OW_BUS_LOW					= 0x10			; BUS auf LOW										
.equ OW_STRONG_PULLUP_ON		= 0x12			; OW-STRONG-PULLUP-ON								

.equ OW_ROM_SEARCH				= 0x20			; ROM-SEARCH		// Antwort: 0x??(Anzahl SLAVES) 0x?? 0x??... (ROM-ADRESSEN)

.equ OW_RP_BYTES1_WRITE			= 0x31			; (RESET-PRESENCE)+ (1-BYTES-WRITE)					
.equ OW_RP_BYTES2_WRITE			= 0x32			; (RESET-PRESENCE)+ (2-BYTES-WRITE)					
.equ OW_RP_BYTES9_WRITE			= 0x39			; (RESET-PRESENCE)+ (9-BYTES-WRITE)					
.equ OW_RP_BYTES10_WRITE		= 0x3A			; (RESET-PRESENCE)+(10-BYTES-WRITE)					

.equ OW_RP_SR_CONVERT			= 0x40			; (RESET-PRESENCE)+(SKIP-ROM)+(CONVERT "T")+1s PAUSE

.equ OW_RESET_PRESENCE			= 0x50			; RESET-PRESENCE 	// Antwort: 0x50(OK) / 0xFF(ERROR)	

.equ OW_BYTES_WRITE				= 0x60			; OW-BYTES-WRITE									
.equ OW_BIT_WRITE				= 0x62			; OW-BIT-WRITE										

.equ OW_BYTES_READ				= 0x80			; OW-1-BYTES_READ									
.equ OW_BYTES_READ8				= 0x88			; OW-8-BYTES_READ									
.equ OW_BYTES_READ9				= 0x89			; OW-9-BYTES_READ									

.equ OW_BIT_READ				= 0x90			; OW-1-BIT READ										
.equ OW_BIT_READ2				= 0x92			; OW-2-BIT READ										
; ERROR-CODES									
.equ ERROR_KOMMANDO				= 0x22
.equ ERROR_BUFFER_RX			= 0x33
.equ ERROR_TWI					= 0x44
.equ ERROR_SEARCH				= 0x55
.equ ERROR_RESET_PRESENCE		= 0x66
.equ ERROR_OW_BUS				= 0x88
; 1-WIRE-MAXIMAL-ANZAHL-SLAVES					
.equ ONE_WIRE_MAX_SLAVES		= 64
; 1-WIRE-DATENBUS								
.equ ONE_WIRE_PIN_NR				= 2
.equ ONE_WIRE_DDR					= DDRD
.equ ONE_WIRE_PORT					= PORTD
.equ ONE_WIRE_PIN					= PIND
; 1-WIRE-DATENBUS STRONG_PULLUP (FET/TRANSISTOR)
.equ ONE_WIRE_STRONG_PULLUP_PIN_NR	= 4
.equ ONE_WIRE_STRONG_PULLUP_DDR		= DDRD
.equ ONE_WIRE_STRONG_PULLUP_PORT	= PORTD
; TASTE-A										
.equ TASTE_A_PIN_NR					= 0
.equ TASTE_A_DDR					= DDRB
.equ TASTE_A_PORT					= PORTB
.equ TASTE_A_PIN					= PINB
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR				= 5
.equ LED_GRUEN_DDR					= DDRD
.equ LED_GRUEN_PORT					= PORTD
; LED-GELB										
.equ LED_GELB_PIN_NR				= 6
.equ LED_GELB_DDR					= DDRD
.equ LED_GELB_PORT					= PORTD
; LED-ROT										
.equ LED_ROT_PIN_NR					= 7
.equ LED_ROT_DDR					= DDRD
.equ LED_ROT_PORT					= PORTD
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN						=SRAM_START+0	; 0x0060 START Adresse 		
.equ adr_ERROR_CODE					=SRAM_START+2
.equ adr_USART_AKTIV				=SRAM_START+4
.equ adr_USART_ANZAHL_BYTES			=SRAM_START+5
.equ adr_TWI_PROTOKOLL_FERTIG		=SRAM_START+6
.equ adr_ANZAHL_SLAVES				=SRAM_START+8
.equ adr_BUFFER_RX_ZEIGER			=SRAM_START+10
.equ adr_BUFFER_TX_ZEIGER_READ_L	=SRAM_START+12
.equ adr_BUFFER_TX_ZEIGER_READ_H	=SRAM_START+14

.equ adr_ROM_CRC_BEREICH8			=SRAM_START+20

.equ adr_ROM_SEARCH_KNOTEN64		=SRAM_START+30

.equ adr_BUFFER_RX256				=SRAM_START+100	; EMPFANGS-PUFFER	

.equ adr_BUFFER_TX512				=SRAM_START+400	; SENDE-PUFFER (8x64=512)			

.equ adr_SRAM_CHECK					=SRAM_START+943	; SRAM CHECK muss immer "S" sein	
; REGISTER										
.def NULL 	= R14
.def EINS 	= R15

.def temp 	= R16
.def temp1 	= R17
.def temp2 	= R18
.def temp3 	= R19
.def temp4 	= R20
.def temp5 	= R21
.def temp6 	= R22
.def temp7 	= R23
.def temp8 	= R24
.def temp9 	= R25


.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF   	  	; Timer1 Overflow Handler       
rjmp INTERRUPT_ERROR	;rjmp TIM0_OVF   ; Timer0 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp USART_RXC 			; USART RX Complete Handler     						
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp TWSI		       	; Two-wire Serial Interface Handler 					
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Unkorrekten Interrupt Aufruf 						
INTERRUPT_ERROR:
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rcall wait_100ms
	rjmp INTERRUPT_ERROR
RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM lschen										
	rcall SRAM_CLEAR
; REGISTER_CLEAR									
	rcall REGISTER_CLEAR
; PORT_CLEAR										
	rcall PORT_CLEAR
; LED_INITIALISIERUNG								
	rcall LED_INITIALISIERUNG
; TASTEN_INITIALISIERUNG							
	rcall TASTEN_INITIALISIERUNG
; WDR_INITIALISIERUNG								
	rcall WDR_INITIALISIERUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
; ONE_WIRE-INITIALISIERUNG								
	rcall ONE_WIRE_INITIALISIERUNG
; TWI-INITIALISIEREN									
	rcall TWI_INI
; USART_INITIALISIEREN									
	rcall USART_INITIALISIEREN
; PROGRAMM_CHECK										
	rcall PROGRAMM_CHECK
; ONE_WIRE_BUS_CHECK									
	rcall ONE_WIRE_BUS_CHECK_PROGRAMMSTART
;-------------------------------------------------------------------------------
 	SEI										;Interrupts freigeben	
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR	; GRN an   


; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR
	rcall AUSWERTUNG_TWI
	rcall AUSWERTUNG_USART
	rcall TASTEN_ABFRAGE
	rcall ONE_WIRE_BUS_CHECK
	rcall PROGRAMM_CHECK
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
AUSWERTUNG_TWI:
	LDS temp,(adr_TWI_PROTOKOLL_FERTIG)
	tst temp
	brne AUSWERTUNG_TWI_RUN
	ret
; ------------------------------------------------------------------------------
AUSWERTUNG_TWI_RUN:
	CLI						; INTERRUPTS sperren	
	STS (adr_TWI_PROTOKOLL_FERTIG),NULL
	rcall AUSWERTUNG		; AUSWERTUNG			
	SEI						; INTERRUPTS freigeben	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
AUSWERTUNG_USART:
	LDS temp,(adr_USART_ANZAHL_BYTES)
	cpi temp,3
	breq AUSWERTUNG_USART_RUN
	ret
; ------------------------------------------------------------------------------
AUSWERTUNG_USART_RUN:
	CLI						; INTERRUPTS sperren	
	STS (adr_USART_ANZAHL_BYTES),NULL
	rcall AUSWERTUNG		; AUSWERTUNG			
	SEI						; INTERRUPTS freigeben	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "INTERFACE_AUSWERTUNG.asm"		; Auswertung Kommandos			
.include "INTERFACE_TWI_SLAVE.asm"		; TWI/I2C-SLAVE					
.include "INTERFACE_USART.asm"			; USART							
.include "INTERFACE_1WIRE.asm"			; 1-WIRE						
.include "INTERFACE_1WIRE_ROM.asm"		; 1-WIRE (ROM)					
.include "INTERFACE_SONSTIGES.asm"		; sonstiges						
.include "INTERFACE_WAIT_01MHZ.asm"		; 1 MHz							
