; ##############################################################################
; ##############################################################################
; ##############################################################################
WDR_INITIALISIERUNG:
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (adr_DATEN)
	ldi ZH, HIGH(adr_DATEN)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT B+C+D CLEAR														
PORT_CLEAR:
	ldi temp, 0b00000000	
	out DDRB, temp
	out DDRC, temp
	out DDRD, temp
	out PORTB,temp				
	out PORTC,temp				
	out PORTD,temp	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
REGISTER_CLEAR:
	clr R0
	clr R1
	clr R2
	clr R3
	clr R4
	clr R5
	clr R6
	clr R7
	clr R8
	clr R9
	clr R10
	clr R11
	clr R12
	clr R13
	clr R14
	clr R15
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_INITIALISIERUNG:
	; auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)		; GRN		
	sbi (LED_GELB_DDR),(LED_GELB_PIN_NR)		; GELB		
	sbi (LED_ROT_DDR) ,(LED_ROT_PIN_NR)			; ROT		
	; LEDs an									
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rcall wait_10ms
	; LEDs aus									
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_INITIALISIERUNG:
	; auf EINGANG						
	cbi (TASTE_A_DDR) ,(TASTE_A_PIN_NR) 
	; PULL UP ein						
	sbi (TASTE_A_PORT),(TASTE_A_PIN_NR) 		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_ABFRAGE:
	clr temp
	sbic (TASTE_A_PIN),(TASTE_A_PIN_NR)	; springe, wenn...	
	ret
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	rcall ROM_SEARCH
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	; SRAM CHECK
	LDS temp,(adr_SRAM_CHECK)
	cpi temp,'S'
	brne PROGRAMM_CHECK_FEHLER
	ret
;-------------------------------------------------------------------------------
; SCHLEIFE																		
PROGRAMM_CHECK_FEHLER:
	CLI											; INTERRUPTS sperren	
	rcall wait_100ms
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
BUFFER_RX_CLEAR:
	; X-ZEIGER (Empfangspuffer)	
	ldi XL,LOW (adr_BUFFER_RX256)	 
	ldi XH,HIGH(adr_BUFFER_RX256)
	clr temp
BUFFER_RX_CLEAR_s:
	ST X+,NULL
	dec temp
	brne BUFFER_RX_CLEAR_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
BUFFER_TX_CLEAR:
	; X-ZEIGER (Empfangspuffer)	
	ldi XL,LOW (adr_BUFFER_TX512)	 
	ldi XH,HIGH(adr_BUFFER_TX512)
	clr temp
BUFFER_TX_CLEAR_s:
	ST X+,NULL
	cpi XH,HIGH(adr_BUFFER_TX512+512)
	brne BUFFER_TX_CLEAR_s
	cpi XL,LOW (adr_BUFFER_TX512+512)
	brne BUFFER_TX_CLEAR_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
















