;######################################################################## 
;######################################################################## 
;######################################################################## 
TWI_INI:
	; TWI TWCR 				Control-REGISTER	
	ldi temp, 1<<TWINT|1<<TWEA|0<<TWSTA|0<<TWSTO|0<<TWWC|1<<TWEN|1<<TWIE
	out TWCR,temp
	; TWI TWAR (nur SLAVE) 	Adress-Register		
	ldi temp,(TWI_SLAVE_ADRESSE<<TWA0 | TWI_GENERAL_CALL_ENABLE<<TWGCE)
	out TWAR,temp
	; PULL-UP ein								
	sbi PORTC,PC4
	sbi PORTC,PC5
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TWI_AUS:
	ldi temp, 1<<TWINT|0<<TWEA|0<<TWSTA|0<<TWSTO|0<<TWWC|0<<TWEN|0<<TWIE
	out TWCR,temp
ret
; #############################################################################
; #############################################################################
; #############################################################################
;																				
; TWI INTERRUPPT-Routine														
;																				
TWSI:
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR	; GRN an   			
	push TEMP			; temp  auf dem Stack sichern            	
	in TEMP,SREG	    ; SREG auslesen								
	push temp           ; SREG sichern								
	push temp1          ; temp1 auf dem Stack sichern            	
	push temp2
	push ZL
	push ZH
;-------------------------------------------------------------------------------
TWSI_RUN:
	in temp, TWSR		; TWI- Status-Register abfragen							
	andi temp, 0xF8		; Bit0...2 ausblenden (Prescaler und Reserve-Bit)		
	;	vergleich		
	cpi temp,  0x60		; SLAVE RECEIVER						
	brne PC+2
	rjmp TWSI_TW_SR_SLA_ACK
	cpi temp, 0x68
	brne PC+2
	rjmp TWSI_TW_SR_ARB_LOST_SLA_ACK
	cpi temp, 0x70
	brne PC+2
	rjmp TWSI_TW_SR_GCALL_ACK
	cpi temp, 0x78
	brne PC+2
	rjmp TWSI_TW_SR_ARB_LOST_GCALL_ACK
	cpi temp, 0x80
	brne PC+2
	rjmp TWSI_TW_SR_DATA_ACK      	
	cpi temp, 0x88
	brne PC+2
	rjmp TWSI_TW_SR_DATA_NACK
	cpi temp, 0x90
	brne PC+2
	rjmp TWSI_TW_SR_GCALL_DATA_ACK   
	cpi temp, 0x98
	brne PC+2
	rjmp TWSI_TW_SR_GCALL_DATA_NACK
	cpi temp, 0xA0
	brne PC+2
	rjmp TWSI_TW_SR_STOP        	
	cpi temp, 0xA8		;	SLAVE TRANSMITTER					
	brne PC+2
	rjmp TWSI_TW_ST_SLA_ACK	
	cpi temp, 0xB0
	brne PC+2
	rjmp TWSI_TW_ST_ARB_LOST_SLA_ACK
	cpi temp, 0xB8
	brne PC+2
	rjmp TWSI_TW_ST_DATA_ACK
	cpi temp, 0xC0
	brne PC+2
	rjmp TWSI_TW_ST_DATA_NACK
	cpi temp, 0xC8
	brne PC+2
	rjmp TWSI_TW_ST_LAST_DATA 
	cpi temp, 0xF8						; no INFO							
	brne PC+2
	rjmp  TWSI_TW_NO_INFO
	cpi temp, 0x00 						;(Error)							
	brne PC+2
	rjmp TWSI_TW_BUS_ERROR 
	rjmp TWSI_ANTWORT					; nicht behandelte Status-Zustnde	
;-------------------------------------------------------------------------------
; SLAVE RECEIVER						
TWSI_TW_SR_SLA_ACK:						; x60 ("SLA+W" wurde empfangen) 				
	; START (ZEIGER auf NULL)	
	STS(adr_BUFFER_RX_ZEIGER),NULL
	rjmp TWSI_ANTWORT
TWSI_TW_SR_DATA_ACK:					; x80 ("SLA+W"-Datenbyte wurden empfangen) 		
	; ZEIGER					
	LDS temp1, (adr_BUFFER_RX_ZEIGER)
	ldi ZL,LOW (adr_BUFFER_RX256)
	ldi ZH,HIGH(adr_BUFFER_RX256)
	add ZL,temp1
	adc ZH,NULL
	; DATA						
	in temp, TWDR		
	ST Z,temp
	; ZEIGER+1					
	inc temp1
	tst temp1							; berlauf ?	
	breq TWSI_TW_SR_DATA_ACK_UEBERLAUF
	STS(adr_BUFFER_RX_ZEIGER),temp1
	rjmp TWSI_ANTWORT
TWSI_TW_SR_DATA_ACK_UEBERLAUF:
	; ERROR-BERLAUF					
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR	; ROT  an		
	ldi temp,(ERROR_BUFFER_RX)
	STS(adr_ERROR_CODE),temp	
	rjmp TWSI_ANTWORT
TWSI_TW_SR_STOP:						; xA0 (STOP oder Repead-START wurde empfangen)
	; STOP / Repead-START		
	STS(adr_TWI_PROTOKOLL_FERTIG),EINS
	rjmp TWSI_ANTWORT
TWSI_TW_SR_GCALL_ACK:					; x70 ("General Call" wurde empfangen)			
	; START "General Call"		
	rjmp TWSI_ANTWORT
TWSI_TW_SR_GCALL_DATA_ACK:				; x90 ("General Call"-Datenbyte wurden empfangen)	
	; DATA "General Call"		
	in temp, TWDR		; DUMMY		
	rjmp TWSI_ANTWORT
TWSI_TW_SR_ARB_LOST_SLA_ACK:			; x68 (Arbitration verloren)					
	; NIX tun					
	rjmp TWSI_ANTWORT
TWSI_TW_SR_ARB_LOST_GCALL_ACK:			; x78 (Arbitration verloren)					
	; NIX tun					
	rjmp TWSI_ANTWORT
TWSI_TW_SR_DATA_NACK:      				; x88 (die vorher adressierten (SLA+W) Daten wurden empfangen; ACK wurde nicht zurckgesedet
	; NIX tun					
	rjmp TWSI_ANTWORT
TWSI_TW_SR_GCALL_DATA_NACK:				; x98 (die vorher adressierten (General call) Daten wurden empfangen;  ACK wurde nicht zurckgesendet	
	; NIX tun					
	rjmp TWSI_ANTWORT
;-------------------------------------------------------------------------------
;	SLAVE TRANSMITTER					
TWSI_TW_ST_SLA_ACK:						; xA8 (SLA+R wurde empfangen) + ACK 
	; DATA			
	LDS temp,(adr_BUFFER_TX512+0)
	OUT TWDR, temp						; DATA zur Verfgung stellen
;	STS(adr_BUFFER_TX+0),NULL			; DATA-clear
	; ZEIGER=1		
	STS(adr_BUFFER_TX_ZEIGER_READ_L),EINS
	STS(adr_BUFFER_TX_ZEIGER_READ_H),NULL
	rjmp TWSI_ANTWORT
TWSI_TW_ST_DATA_ACK:					; xB8 (DATEN wurden bertragen) + ACK 	
	; ZEIGER		
	LDS temp1,(adr_BUFFER_TX_ZEIGER_READ_L)
	LDS temp2,(adr_BUFFER_TX_ZEIGER_READ_H)
	ldi ZL,LOW (adr_BUFFER_TX512)
	ldi ZH,HIGH(adr_BUFFER_TX512)
	add ZL,temp1
	adc ZH,temp2
	; DATA			
	LD temp,Z
	OUT TWDR, temp						; DATA zur Verfgung stellen
;	ST Z,NULL							; DATA-clear
	; ZEIGER+1		
	add temp1,EINS
	adc temp2,NULL
	STS(adr_BUFFER_TX_ZEIGER_READ_L),temp1
	STS(adr_BUFFER_TX_ZEIGER_READ_H),temp2
	rjmp TWSI_ANTWORT
TWSI_TW_ST_DATA_NACK:					; xC0 (TWDR ist bertragen worden;  ACK ist NICHT empfangen worden
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	rjmp TWSI_ANTWORT
TWSI_TW_ST_ARB_LOST_SLA_ACK:			; xB0 (Arbitration verlor SLA+R/W als MASTER, ACK wurde zurckgesendet)	
	rjmp TWSI_ANTWORT
TWSI_TW_ST_LAST_DATA:					; xC8 (Letztes Datenbyte in TWDR ist bertragen worden (TWEA = "0");  Ack ist empfangen worden
	rjmp TWSI_ANTWORT
TWSI_TW_NO_INFO:						; xF8 (Keine relevanten Zustandinformationen vorhanden;  TWINT = "0" keine TWDR-Ttigkeit 
	rjmp TWSI_ANTWORT
;-------------------------------------------------------------------------------
TWSI_TW_BUS_ERROR:						; x00 (Bus-Error wegen ungltige STARToder STOP BEDIgung; keine TWDR-Ttigkeit 
	; ERROR					
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR	; ROT  an	
	ldi temp,(ERROR_TWI)
	STS(adr_ERROR_CODE),temp
	; TWI_AUS				
	rcall TWI_AUS
	rjmp TWSI_RUN
;-------------------------------------------------------------------------------
TWSI_ANTWORT:	
	; ANTWORTEN							
	ldi temp, 1<<TWINT|1<<TWEA|1<<TWEN|1<<TWIE
	out TWCR,temp
;-------------------------------------------------------------------------------
	pop ZH
	pop ZL
	pop temp2
	pop temp1			; temp1 wieder herstellen			
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)	
	out	SREG,TEMP		; Wiederherstellen von SREG			
	pop	TEMP			; temp1 wieder herstellen			
reti
; #############################################################################
; #############################################################################
; #############################################################################

