; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_INITIALISIEREN:
	ldi temp,TAKT/(BAUD*16)-1  		; Baudrate 								
	out UBRRL,temp
   	ldi temp, (1<<URSEL)|(3<<UCSZ0)	; Frame-Format: 8 Bit					
    out UCSRC, temp
    sbi UCSRB, RXCIE                ; Interrupt bei Empfang	aktivieren		
    sbi UCSRB, RXEN 				; RX aktivieren (Empfang)      			
	sbi UCSRB, TXEN  				; TX aktivieren                 		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 	INPUT: temp1														
;																		
;	rcall SENDEN	; INP: TEMP1										
;																		
BYTE_SENDEN_TEMP1:
	sbis UCSRA,UDRE  		   	; Warten bis UDR frei             	
	rjmp BYTE_SENDEN_TEMP1		; Sprung							
	out UDR, temp1				; senden							
	; kleine PAUSE (nur wenn mehrere Bytes nacheinander gesendet werden mssen)		
	;rcall wait_1ms

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Interruptroutine: wird ausgefhrt sobald ein Byte ber das UART empfangen wurde
USART_RXC:
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR	; GRN an   			
	push TEMP		    ; Sichern von "TEMP" im Stack
	in	 TEMP,SREG		; Einlesen des SREG 
	push TEMP	    	; Schreiben von  SREG  im Stack (KOPIE)
; ------------------------------------------------------------------------------
	STS(adr_USART_AKTIV),EINS

	LDS temp,(adr_USART_ANZAHL_BYTES)
	inc temp
	STS (adr_USART_ANZAHL_BYTES),temp

	cpi temp,1
	breq BYTE_EINLESEN_1
	cpi temp,2
	breq BYTE_EINLESEN_2
	cpi temp,3
	breq BYTE_EINLESEN_3
	; ERROR		
	STS (adr_USART_ANZAHL_BYTES),NULL
	rjmp BYTE_EINLESEN_FERTIG
; ------------------------------------------------------------------------------
; muss ein "*" sein	(Vorhut)													
BYTE_EINLESEN_1:
	in temp, UDR 	; BYTE einlesen	
	cpi temp,'*'
	breq BYTE_EINLESEN_FERTIG
	; ERROR		
	STS (adr_USART_ANZAHL_BYTES),NULL
	rjmp BYTE_EINLESEN_FERTIG
; ------------------------------------------------------------------------------
BYTE_EINLESEN_2:
	in temp, UDR 	; BYTE einlesen	
	STS(adr_BUFFER_RX256+0),temp
	rjmp BYTE_EINLESEN_FERTIG
; ------------------------------------------------------------------------------
BYTE_EINLESEN_3:
	in temp, UDR 	; BYTE einlesen	
	STS(adr_BUFFER_RX256+1),temp
	rjmp BYTE_EINLESEN_FERTIG
; -------------------------------
BYTE_EINLESEN_FERTIG:
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)
	out	SREG,TEMP		; Wiederherstellen von SREG
	pop	TEMP			; Wiederherstellen von "TEMP" 		
reti              
; ##############################################################################
; ##############################################################################
; ##############################################################################

