// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 09.11.2007
//  -------------------------------------------------------------
//  File Name : ADC.c
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Reads Data from ADC Channels 0 & 1
//				Inclusive moving Average Filter
// ***************************************************************
// Remarks: Need Standard Data Types defined in Globals.h
// ***************************************************************

#include "ADC.h"

static ADCCONVERSION adcconv = {
	0,
	0,
	0,
	0,
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

//Initializes ADC for use 
void InitADC(void)
{
	ADMUX	|= _BV(REFS0)|_BV(REFS1);	//Set Internal Reference Voltage 2.56V
	ADCSRA  |= _BV(ADPS1)|_BV(ADPS2);	//Prescaler (64*125nS=125kHz) is below 200khz for 10 Bit Resolution
	ADCSRA	|= _BV(ADEN);				//Enable ADC
	ADCSRA  |= _BV(ADSC);				//Start Single Ended Dummy Conversion
	ADCSRA  |= _BV(ADIE);				//Enable ADC IRQ
}

//Stores Sampled Value to Array to calculate average on it
void StoreADCSample(WORD p_adcvalue)
{
	if(adcconv.currentChannel)
	{
		adcconv.conversions0[adcconv.currentconversion0]=p_adcvalue;
		adcconv.currentconversion0++;
	}
	else
	{
		adcconv.conversions1[adcconv.currentconversion1]=p_adcvalue;
		adcconv.currentconversion1++;
	}
}

//Sets ADC Sample Channel for next conversion
//only used safe before conversion starts
void SetADCChannel(BYTE p_channel)
{
	BYTE admux=ADMUX;
	admux &= ~0x07; 
	admux |= p_channel&0x07;
	ADMUX = admux;
	adcconv.currentChannel = p_channel&0x07;
	//check if no averaging is in progress
	if(!adcconv.avginprogress)
		//Start ADC Conversion
		ADCSRA |= _BV(ADSC);
}

//Calculate Average and lock access to conversion array
WORD GetChannelAverage(BYTE p_channel)
{
	BYTE countdown=AVERAGEINGSIZE;
	WORD* channel;
	WORD value=0;
	adcconv.avginprogress=1;	//lock sampling for time of calculations
	//Channel selection
	if(p_channel)
		channel=adcconv.conversions1;
	else
		channel=adcconv.conversions0;
	//sum up and divide
	do
	{
		countdown--;
		value+=channel[countdown];
	}
	while(countdown);
	value>>=AVERAGINGDIVIDER;	//Divides through 32 -> magic dude
	adcconv.avginprogress=0;	//unlock Sampling
	return value;
}

//ADC Values to Temperature 
BYTE ConvertToDegree(WORD p_adcValue)
{
	static const float t1=21;		//Degrees
	static const float t2=250;		//Degrees
	volatile float a = ((t1-t2)/(CALIBRATION_21_DEGREE-CALIBRATION_250_DEGREE));
	return (BYTE)((a*(float)p_adcValue+(-a*CALIBRATION_21_DEGREE)+t1));
}

