// ***************************************************************
//  TransferPrinter FW Version:  1.0     date: 09.11.2007
//  -------------------------------------------------------------
//  File Name : ADC.h
//  -------------------------------------------------------------
//  Copyright (C) 2007 - All Rights Reserved
//	Author : Markus Stopper
// ***************************************************************
// Description: Reading Temperature Sensor Values
// ***************************************************************

#ifndef __ADC__
#define __ADC__

#include "Globals.h"

#define CALIBRATION_21_DEGREE 273			//ADC Reading for temperature
#define CALIBRATION_250_DEGREE 129			//ADC Reading for temperature

#define AVERAGEINGSIZE	32					//How many values are used to smoothen value
#define AVERAGINGDIVIDER 5
											
typedef struct _adcconversion
{
	BYTE avginprogress		: 1;			//averaging in Progress
	BYTE currentChannel		: 1;			//represents current sampling channel
	BYTE currentconversion0 : 5;
	BYTE currentconversion1 : 5;
	WORD conversions0[AVERAGEINGSIZE];		//holds 32 conversions for averaging channel 0
	WORD conversions1[AVERAGEINGSIZE];		//holds 32 conversions for averaging channel 1

} ADCCONVERSION;

//Function Prototypes
void InitADC(void);
void StoreADCSample(WORD p_adcvalue);
void SetADCChannel(BYTE p_channel);
WORD GetChannelAverage(BYTE p_channel);
BYTE ConvertToDegree(WORD p_adcValue);

#endif /*__ADC__*/

